<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_headers - Serveur Apache HTTP</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_headers</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_headers.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_headers.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_headers.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_headers.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Personnalisation des en-ttes de requtes et de rponses
HTTP</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>headers_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_headers.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module fournit des directives permettant de contrler et
    modifier les en-ttes de requtes et de rponses HTTP. Les en-ttes
    peuvent tre fusionns, remplacs ou supprims.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#header">Header</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requestheader">RequestHeader</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#order">Chronologie du traitement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#early">Traitement prcoce et traitement
tardif</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="order" id="order">Chronologie du traitement</a></h2>

    <p>Les directives fournies par <code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code> peuvent
    s'insrer presque partout dans la configuration du serveur, et on
    peut limiter leur porte en les plaant dans des <a href="../sections.html">sections de configuration</a>.</p>

    <p>La chronologie du traitement est importante et est affecte par
    l'ordre d'apparition des directives dans le fichier de configuration
    et par leur placement dans les <a href="../sections.html#mergin">sections de configuration</a>. Ainsi,
    ces deux directives ont un effet diffrent si leur ordre est invers
    :</p>

    <pre class="prettyprint lang-config">
RequestHeader append MirrorID "mirror 12"
RequestHeader unset MirrorID
    </pre>


    <p>Dans cet ordre, l'en-tte <code>MirrorID</code> n'est pas dfini.
    Si l'ordre des directives tait invers, l'en-tte
    <code>MirrorID</code> serait dfini  "mirror 12".</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="early" id="early">Traitement prcoce et traitement
tardif</a></h2>
    <p><code class="module"><a href="../mod/mod_headers.html">mod_headers</a></code> peut agir soir prcocement, soit
    tardivement au niveau de la requte. Le mode normal est le mode
    tardif, lorsque les en-ttes de <em>requte</em> sont dfinis, immdiatement
    avant l'excution du gnrateur de contenu, et pour les en-ttes de
    <em>rponse</em>, juste au moment o la rponse est envoye sur le rseau.
    Utilisez toujours le mode tardif sur un serveur en production.</p>

    <p>Le mode prcoce a t conu  des fins d'aide aux tests et au
    dbogage pour les dveloppeurs. Les directives dfinies en utilisant
    le mot-cl <code>early</code> sont censes agir au tout dbut du
    traitement de la requte. Cela signifie que l'on peut les utiliser
    pour simuler diffrentes requtes et dfinir des situations de test,
    tout en gardant  l'esprit que les en-ttes peuvent tre modifis 
    tout moment par d'autres modules avant que le rponse ne soit
    gnre.</p>

    <p>Comme les directives prcoces sont traites avant que le
    chemin de la requte ne soit parcouru, les en-ttes
    prcoces ne peuvent tre dfinis que dans un contexte de serveur
    principal ou de serveur virtuel. Les directives prcoces ne peuvent
    pas dpendre d'un chemin de requte, si bien qu'elles choueront
    dans des contextes tels que <code>&lt;Directory&gt;</code> ou
    <code>&lt;Location&gt;</code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples</a></h2>

    <ol>
      <li>
        Copie tous les en-ttes de requte qui commencent par "TS" vers
	les en-ttes de la rponse :

        <pre class="prettyprint lang-config">
          Header echo ^TS
        </pre>

      </li>

      <li>
        Ajoute  la rponse un en-tte, <code>mon-en-tte</code>, qui
	contient un horodatage permettant de dterminer le moment o la
	requte a t reue, et le temps qui s'est coul jusqu' ce que
	la requte ait commenc  tre servie. Cet en-tte peut tre
	utilis par le client pour estimer la charge du serveur ou
	isoler les goulets d'tranglement entre le client et le
	serveur.

        <pre class="prettyprint lang-config">
          Header set mon-en-tte "%D %t"
        </pre>


        <p>le rsultat est l'ajout  la rponse d'un en-tte du type :</p>

        <div class="example"><p><code>
          mon-en-tte: D=3775428 t=991424704447256
        </code></p></div>
      </li>

      <li>
        Dit Bonjour  Joe

        <div class="example"><p><code>
          Header set mon-en-tte "Bonjour Joe. Il a fallu %D microsecondes \<br />
           Apache pour servir cette requte."
        </code></p></div>

        <p>le rsultat est l'ajout  la rponse d'un en-tte du type :</p>

        <pre class="prettyprint lang-config">
	Header set MyHeader "Bonjour Joe. Il a fallu D=3775428 microsecondes  Apache
          pour servir cette requte."
        </pre>

      </li>

      <li>
        Ajoute l'en-tte <code>mon-en-tte</code>  la rponse si et
	seulement si l'en-tte <code>mon-en-tte-requte</code> est
	prsent dans la requte. Ceci peut s'avrer utile pour gnrer
	des en-ttes de rponse " la tte du client". Notez que cet
	exemple ncessite les services du module
	<code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code>.

        <pre class="prettyprint lang-config">
SetEnvIf MyRequestHeader myvalue HAVE_MyRequestHeader
Header set MyHeader "%D %t mytext" env=HAVE_MyRequestHeader
        </pre>


        <p>Si l'en-tte <code>mon-en-tte-requte: mavaleur</code> est
	prsent dans la requte HTTP, la rponse contiendra un en-tte
	du type :</p>

        <div class="example"><p><code>
          mon-en-tte: D=3775428 t=991424704447256 montexte
        </code></p></div>
      </li>

      <li>
        Permet  DAV de fonctionner avec Apache sur SSL (voir la <a href="http://svn.haxx.se/users/archive-2006-03/0549.shtml">description
	du problme</a>) en remplaant <var>https:</var> par
	<var>http:</var> dans l'en-tte <var>Destination</var> :

        <pre class="prettyprint lang-config">
          RequestHeader edit Destination ^https: http: early
        </pre>

      </li>

      <li>
        Dfinit la valeur d'un mme en-tte sous de multiples conditions
	non exclusives, mais ne duplique pas une valeur dj dfinie
	dans l'en-tte qui en rsulte. Si toutes les conditions
	suivantes sont satisfaites pour une requte (en d'autres termes,
	si les trois variables d'environnement <code>CGI</code>,
	<code>NO_CACHE</code> et <code>NO_STORE</code> existent pour la
	requte) :

        <pre class="prettyprint lang-config">
Header merge Cache-Control no-cache env=CGI
Header merge Cache-Control no-cache env=NO_CACHE
Header merge Cache-Control no-store env=NO_STORE
        </pre>


        <p>alors, la rponse contiendra l'en-tte suivant :</p>

        <div class="example"><p><code>
          Cache-Control: no-cache, no-store
        </code></p></div>

        <p>Si <code>append</code> avait t utilis  la place de
	<code>merge</code>, la rponse aurait contenu l'en-tte suivant
	:</p>

        <div class="example"><p><code>
          Cache-Control: no-cache, no-cache, no-store
        </code></p></div>
      </li>
      <li>
        Dfinit un cookie de test si et seulement si le client n'envoie
	pas de cookie
        <pre class="prettyprint lang-config">
          Header set Set-Cookie testcookie "expr=-z %{req:Cookie}"
        </pre>

      </li>
    </ol>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Header" id="Header">Header</a> <a name="header" id="header">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure les en-ttes d'une rponse HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Header [<var>condition</var>] add|append|echo|edit|edit*|merge|set|unset
<var>en-tte</var> [<var>valeur</var>] [<var>remplacement</var>]
[early|env=[!]<var>variable</var>]|expr=<var>expression</var>]
</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_headers</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>La condition par dfaut est temporairement passe
 "always" dans les version 2.3.9 et 2.3.10</td></tr>
</table>
    <p>Cette directive permet de remplacer, fusionner, ou
    supprimer des en-ttes de rponse HTTP. L'en-tte est modifi juste
    aprs que le gestionnaire de contenu et les filtres en sortie ne
    s'excutent, ce qui permet la modification des en-ttes
    sortants.</p>

    <p>L'argument optionnel <var>condition</var> permet de dterminer
    sur quelle table interne d'en-ttes de rponses cette directive va
    oprer. D'autres composants du serveur peuvent avoir stock leurs
    en-ttes de rponses dans la table correspondant 
    <code>onsuccess</code> ou dans celle correspondant 
    <code>always</code>. Dans ce contexte, "Always" fait rfrence au
    choix d'envoyer les en-ttes que vous ajoutez aux rponses, qu'elle
    soient avec succs ou choues ; par contre, si votre action est une
    fonction d'un en-tte existant, vous devrez lire la documentation de
    manire plus approfondie car dans ce cas, les choses se compliquent.</p>

    <p>Vous pouvez avoir  changer la valeur par dfaut
    <code>onsuccess</code> en <code>always</code> dans des circonstances
    similaires  celles exposes plus loin. Notez aussi que la rptition
    de cette directive avec les deux conditions peut tre pertinente
    dans certains scnarios, car <code>always</code> n'englobe pas
    <code>onsuccess</code> en ce qui concerne les en-ttes existants :</p>

    <ul>
       <li>Vous ajoutez un en-tte  une rponse choue (non-2xx),
       une redirection par exemple, et dans ce cas, seule la table
       correspondant  <code>always</code> est utilise dans la rponse
       dfinitive.</li>
       <li>Vous modifiez ou supprimez un en-tte gnr par un script
       CGI, et dans ce cas, les scripts CGI sont dans la table
       correspondant  <code>always</code> et non dans la table par
       dfaut.</li>
       <li>Vous modifiez ou supprimez un en-tte gnr par tel ou tel
       composant du serveur, mais cet en-tte n'est pas trouv par la
       condition par dfaut <code>onsuccess</code>.</li>
    </ul>

    <p>L'action que cette directive provoque est dtermine par le
    premier argument (ou par le second argument si une
    <var>condition</var> est spcifie). Il peut prendre
    une des valeurs suivantes :</p>

    <dl>
    <dt><code>add</code></dt>
    <dd>L'en-tte est ajout au jeu d'en-ttes prexistant, mme s'il
    existe dj. Ceci peut conduire  la prsence de deux (ou plusieurs)
    en-ttes possdant le mme nom et donc induire des consquences
    imprvues ; en gnral, il est prfrable d'utiliser
    <code>set</code>, <code>append</code> ou <code>merge</code>.</dd>

    <dt><code>append</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte existant de mme
    nom. Lorsqu'une nouvelle valeur est ainsi ajoute, elle est spare
    de celles qui sont dj prsentes par une virgule. Il s'agit de la
    mthode HTTP standard permettant d'affecter plusieurs valeurs  un
    en-tte.</dd>

    <dt><code>echo</code></dt>
    <dd>Les en-ttes de la requte possdant le nom spcifi sont
    recopis vers les en-ttes de la rponse. <var>en-tte</var> peut
    tre une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>, et
    <var>valeur</var> ne doit pas tre prsent.</dd>

    <dt><code>edit</code></dt>
    <dt><code>edit*</code></dt>
    <dd>Si l'en-tte existe, sa valeur est modifie en fonction d'une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a> de type
    recherche/remplacement. L'argument <var>valeur</var> est une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>, et
    l'argument <var>remplacement</var> une chane de caractres de
    remplacement qui peut contenir des rfrences
    arrires. La forme <code>edit</code> n'effectuera une
    recherche/remplacement qu'une seule fois dans la valeur de
    l'en-tte, alors que la forme <code>edit*</code> en effectuera autant
    que le nombre d'apparition de la chane  remplacer.</dd>

    <dt><code>merge</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte de mme nom, sauf
    si elle apparat dj dans la liste des valeurs prexistantes de
    l'en-tte spares par des virgules. Lorsqu'une nouvelle valeur est
    ainsi ajoute, elle est spare de celles qui sont dj prsentes
    par une virgule. Il s'agit de la mthode HTTP standard permettant
    d'affecter plusieurs valeurs  un en-tte. Les valeurs sont
    compares en tenant compte de la casse, et aprs le traitement de
    tous les spcificateurs de format. Une valeur entoure de guillemets
    est considre comme diffrente de la mme valeur mais sans
    guillemets.</dd>

    <dt><code>set</code></dt>
    <dd>L'en-tte est dfini, remplaant tout en-tte prexistant avec
    le mme nom. L'argument <var>valeur</var> peut tre une chane de
    formatage.</dd>

    <dt><code>unset</code></dt>
    <dd>L'en-tte est supprim s'il existe. Si plusieurs en-ttes
    possdent le mme nom, ils seront tous supprims. L'argument
    <var>value</var> ne doit pas apparatre.</dd>
    </dl>

    <p>Cet argument est suivi d'un nom d'<var>en-tte</var> qui peut se
    terminer par un caractre ':', mais ce n'est pas obligatoire. La
    casse est ignore avec <code>set</code>, <code>append</code>,
    <code>merge</code>, <code>add</code>, <code>unset</code> et
    <code>edit</code>. Le nom d'<var>en-tte</var> est sensible  la
    casse pour <code>echo</code> et peut tre une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>.</p>

    <p>Avec <code>set</code>, <code>append</code>, <code>merge</code> et
    <code>add</code>, une <var>valeur</var> est spcifie comme
    argument suivant. Si <var>valeur</var> contient des espaces, elle
    doit tre entoure de guillemets. <var>valeur</var> peut tre une
    chane de caractres, une chane contenant des spcificateurs de
    format, ou une combinaison des deux. <var>valeur</var> supporte les
    spcificateurs de format suivants :</p>

    <table class="bordered"><tr class="header"><th>Format</th><th>Description</th></tr>
<tr><td><code>%%</code></td>
        <td>Le caractre pourcentage</td></tr>
<tr class="odd"><td><code>%t</code></td>
        <td>Le moment de rception de la requte en temps
	universel coordonn depuis le temps epoch (Jan. 1, 1970) et
	exprim en microsecondes. La valeur est prcde de
	<code>t=</code>.</td></tr>
<tr><td><code>%D</code></td>
        <td>Le temps coul entre la rception de la requte et l'envoi
	des en-ttes sur le rseau. Il s'agit de la dure de traitement
	de la requte. La valeur est prcde de <code>D=</code>. La
	valeur est exprime en microsecondes.</td></tr>
<tr class="odd"><td><code>%l</code></td>
        <td>La charge courante du serveur. Ce sont les valeurs fournies
	par <code>getloadavg()</code> qui reprsentent la charge
	courante, ainsi que la charge moyenne pendant les cinq et les
	quinze dernires minutes. Chaque valeur est prcde de
	<code>l=</code> et spare des autres par un slash
	<code>/</code>.
        </td></tr>
<tr><td><code>%i</code></td>
        <td>Le pourcentage de disponibilit de httpd (0  100) bas sur
	le nombre de threads et de processus disponibles. La valeur est
	prcde de <code>i=</code>.
        </td></tr>
<tr class="odd"><td><code>%b</code></td>
        <td>Le pourcentage d'utilisation de httpd (0  100) bas sur
	le nombre de threads et de processus disponibles. La valeur est
	prcde de <code>b=</code>.
        </td></tr>
<tr><td><code>%{NOM_VARIABLE}e</code></td>
        <td>Le contenu de la <a href="../env.html">variable
	d'environnement</a> <code>NOM_VARIABLE</code>.</td></tr>
<tr class="odd"><td><code>%{NOM_VARIABLE}s</code></td>
        <td>Le contenu de la <a href="../env.html">variable
	d'environnement SSL</a> <code>NOM_VARIABLE</code>, si
	<code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> est activ.</td></tr>
</table>

    <div class="note"><h3>Note</h3>
      <p>Le spcificateur de format <code>%s</code> est disponible
      depuis la version 2.1 d'Apache ; il peut tre utilis  la place
      de <code>%e</code> pour viter de devoir spcifier
      <code>SSLOptions +StdEnvVars</code>. Cependant, si
      <code>SSLOptions +StdEnvVars</code> doit tout de mme tre
      spcifi pour une raison quelconque, <code>%e</code> sera plus
      efficace que <code>%s</code>.</p>
    </div>

    <p><code>edit</code>ncessite les deux arguments
    <var>valeur</var>, qui est une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression
    rationnelle</a>, et une chane additionnelle
    <var>remplacement</var>.</p>

    <p>La directive <code class="directive">Header</code> peut tre suivie d'un
    argument additionnel qui peut prendre les valeurs suivantes :</p>

    <dl>
    <dt><code>early</code></dt>
    <dd>Spcifie <a href="#early">traitement pralable</a>.</dd>
    <dt><code>env=[!]<var>variable</var></code></dt>
    <dd>La directive est applique si et seulement si la <a href="../env.html">variable d'environnement</a>
    <code>variable</code> existe. Un <code>!</code> devant
    <code>variable</code> inverse le test, et la directive ne
    s'appliquera alors que si <code>variable</code> n'est pas dfinie.</dd>
    <dt><code>expr=<var>expression</var></code></dt>
    <dd>La directive s'applique si et seulement si <var>expression</var>
    est value  true. Vous trouverez plus de dtails  propos de la
    syntaxe et de l'valuation des expressions dans la documentation <a href="../expr.html">ap_expr</a>.</dd>
    </dl>

    <p>Except le cas du mode <a href="#early">prcoce</a>, les
    directives <code class="directive">Header</code> sont traites juste avant
    l'envoi de la rponse sur le rseau. Cela signifie qu'il est
    possible de dfinir et/ou modifier la plupart des en-ttes, 
    l'exception de ceux qui sont ajouts par le filtre HTTP
    d'en-tte, comme Content-Type.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="RequestHeader" id="RequestHeader">RequestHeader</a> <a name="requestheader" id="requestheader">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Configure les en-ttes d'une requte HTTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>RequestHeader add|append|edit|edit*|merge|set|unset
<var>en-tte</var> [<var>valeur</var>] [<var>remplacement</var>]
[early|env=[!]<var>variable</var>]|expr=<var>expression</var>]
</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_headers</td></tr>
</table>
    <p>Cette directive permet de remplacer, fusionner, modifier ou
    supprimer des en-ttes de requte HTTP. L'en-tte est modifi juste
    avant que le gestionnaire de contenu ne s'excute, ce qui permet la
    modification des en-ttes entrants. L'action effectue est
    dtermine par le premier argument. Ce dernier accepte les valeurs
    suivantes :</p>

    <dl>

    <dt><code>add</code></dt>
    <dd>L'en-tte est ajout au jeu d'en-ttes prexistant, mme s'il
    existe dj. Ceci peut conduire  la prsence de deux (ou plusieurs)
    en-ttes possdant le mme nom et donc induire des consquences
    imprvues ; en gnral, il est prfrable d'utiliser
    <code>set</code>, <code>append</code> ou <code>merge</code>.</dd>

    <dt><code>append</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte existant de mme
    nom. Lorsqu'une nouvelle valeur est ainsi ajoute, elle est spare
    de celles qui sont dj prsentes par une virgule. Il s'agit de la
    mthode HTTP standard permettant d'affecter plusieurs valeurs  un
    en-tte.</dd>

    <dt><code>edit*</code></dt>
    <dd>Si l'en-tte existe, sa valeur est modifie en fonction d'une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a> de type
    recherche/remplacement. L'argument <var>valeur</var> est une
    <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>, et
    l'argument <var>remplacement</var> une chane de caractres de
    remplacement qui peut contenir des rfrences arrires. Avec
    <code>edit</code>, la chane de l'en-tte correspondant au modle ne
    sera recherche et remplace qu'une seule fois, alors qu'avec
    <code>edit*</code>, elle le sera pour chacune de ses instances si
    elle apparat plusieurs fois.</dd>

    <dt><code>merge</code></dt>
    <dd>La valeur d'en-tte est ajoute  tout en-tte de mme nom, sauf
    si elle apparat dj dans la liste des valeurs prexistantes de
    l'en-tte spares par des virgules. Lorsqu'une nouvelle valeur est
    ainsi ajoute, elle est spare de celles qui sont dj prsentes
    par une virgule. Il s'agit de la mthode HTTP standard permettant
    d'affecter plusieurs valeurs  un en-tte. Les valeurs sont
    compares en tenant compte de la casse, et aprs le traitement de
    tous les spcificateurs de format. Une valeur entoure de guillemets
    est considre comme diffrente de la mme valeur mais sans
    guillemets.</dd>

    <dt><code>set</code></dt>
    <dd>L'en-tte est dfini, remplaant tout en-tte prexistant avec
    le mme nom.</dd>

    <dt><code>unset</code></dt>
    <dd>L'en-tte est supprim s'il existe. Si plusieurs en-ttes
    possdent le mme nom, ils seront tous supprims. L'argument
    <var>value</var> ne doit pas apparatre.</dd>
    </dl>

    <p>Cet argument est suivi d'un nom d'en-tte qui peut se terminer
    par un caractre ':', mais ce n'est pas obligatoire. La casse est
    ignore. Avec <code>set</code>, <code>append</code>,
    <code>merge</code> et <code>add</code>, une <var>valeur</var> est
    fournie en troisime argument. Si une <var>valeur</var> contient des
    espaces, elle doit tre entoure de guillemets. Avec
    <code>unset</code>, aucune <var>valeur</var> ne doit apparatre.
    <var>valeur</var> peut tre une chane de caractres, une chane
    contenant des spcificateurs de format, ou une combinaison des deux.
    Les spcificateurs de format supports sont les mmes que ceux de la
    directive <code class="directive"><a href="#header">Header</a></code>, 
    laquelle vous pouvez vous reporter pour plus de dtails. Avec
    <code>edit</code>, les deux arguments <var>valeur</var> et
    <var>remplacement</var> sont obligatoires, et correspondent
    respectivement  une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression
    rationnelle</a> et  une chane de remplacement.</p>

    <p>La directive <code class="directive">RequestHeader</code> peut tre
    suivie d'un argument supplmentaire, qui pourra prendre les valeurs
    suivantes :</p>
    <dl>
    <dt><code>early</code></dt>
    <dd>Spcifie <a href="#early">traitement pralable</a>.</dd>
    <dt><code>env=[!]<var>variable</var></code></dt>
    <dd>La directive est applique si et seulement si la <a href="../env.html">variable d'environnement</a>
    <code>variable</code> existe. Un <code>!</code> devant
    <code>variable</code> inverse le test, et la directive ne
    s'appliquera alors que si <code>variable</code> n'est pas dfinie.</dd>
    <dt><code>expr=<var>expression</var></code></dt>
    <dd>La directive s'applique si et seulement si <var>expression</var>
    est value  true. Vous trouverez plus de dtails  propos de la
    syntaxe et de l'valuation des expressions dans la documentation <a href="../expr.html">ap_expr</a>.</dd>
    </dl>

    <p>Except le cas du mode <a href="#early">prcoce</a>, la directive
    <code class="directive">RequestHeader</code> est traite juste avant la
    prise en compte de la requte par son gestionnaire, au cours de la
    phase de vrification. Ceci permet la modification des en-ttes
    gnrs par le navigateur, ou par les filtres en entre
    d'Apache.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_headers.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_headers.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_headers.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_headers.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_headers.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2013 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>