#!/usr/bin/awk -f

# usage: call with "awk -v version=<target version> -f <this file>
# used by debian/scripts/install-dbconfig-upgrade

BEGIN {
    version_found = 0
    data_found = 0
    version--
    if ( version < 1 ) {
	print "error: please pass target version in variable 'version'"
	exit 1
    }
}

{
    # skip to version check for the desired version
    if ( !version_found && !data_found && ($0 ~ "DBVERSION.* +(-eq|=) " version " ") ) {
	version_found = 1
	next
    }
    # skip to beginning of data block (marked by "<<END-OF-DATA")
    if ( version_found && !data_found && ($0 ~ "<<END-OF-DATA$") ) {
	data_found = 1
	next
    }
    # exit if end of data block is reached
    if ( version_found && data_found && ($0 ~ "^END-OF-DATA$") )
	exit
    # skip "USE ${db_name};" line, found in mysql files but handled by dbconfig
    if ( $0 ~ "^USE \\${db_name};" )
	next
    # otherwise print the data line
    if ( version_found && data_found )
	print $0
}

END {
    if ( !version_found ) {
	print "error: target version not found"
	exit 1
    }
    if ( !data_found ) {
	print "error: data block not found for target version"
	exit 1
    }
}
