
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsecategories.proc"

#include <bse/bsecategories.h>
#include <bse/bseprocedure.h>
#include <bse/bseplugin.h>


#line 24 "bsecategories.proc"


/* --- bse-categories-match-typed --- */
static void
bse_categories_match_typed_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 26 "bsecategories.proc"
 {
#line 28 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_string ("pattern", "Pattern", "Pattern to match category, supports '*' and '?' wildcards.",
			    "*", SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("type", "Type", "Base type for categories to conform to.",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("categories", "Categories", NULL, BSE_TYPE_CATEGORY_SEQ, SFI_PARAM_STANDARD);
}
#line 34 "bsecategories.proc"
 }
static BseErrorType
#line 34 "bsecategories.proc"
bse_categories_match_typed_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 37 "bsecategories.proc"
{
#line 38 "bsecategories.proc"
  
  gchar *pattern   = sfi_value_get_string (in_values++);
  gchar *type_name = sfi_value_get_string (in_values++);
  GType  type      = type_name ? g_type_from_name (type_name) : 0;
  BseCategorySeq *cseq = NULL;
  
#line 44 "bsecategories.proc"
  
  if (!pattern)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (type)
    cseq = bse_categories_match_typed (pattern, type);
  if (!cseq)
    cseq = bse_category_seq_new ();
  
#line 53 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cseq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-categories-match --- */
static void
bse_categories_match_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 59 "bsecategories.proc"
 {
#line 61 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_string ("pattern", "Pattern", "Pattern to match category, supports '*' and '?' wildcards.",
			    "*", SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("categories", "Categories", NULL, BSE_TYPE_CATEGORY_SEQ, SFI_PARAM_STANDARD);
}
#line 65 "bsecategories.proc"
 }
static BseErrorType
#line 65 "bsecategories.proc"
bse_categories_match_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 68 "bsecategories.proc"
{
#line 69 "bsecategories.proc"
  
  gchar *pattern   = sfi_value_get_string (in_values++);
  BseCategorySeq *cseq = NULL;
  
#line 73 "bsecategories.proc"
  
  if (!pattern)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  cseq = bse_categories_match_typed (pattern, 0);
  if (!cseq)
    cseq = bse_category_seq_new ();
  
#line 81 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cseq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-category-from-id --- */
static void
bse_category_from_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 87 "bsecategories.proc"
 {
#line 89 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_int ("category_id", "Category ID", NULL,
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("category", "Category", NULL, BSE_TYPE_CATEGORY, SFI_PARAM_STANDARD);
}
#line 93 "bsecategories.proc"
 }
static BseErrorType
#line 93 "bsecategories.proc"
bse_category_from_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 96 "bsecategories.proc"
{
#line 97 "bsecategories.proc"
  
  guint id = sfi_value_get_int (in_values++);
  BseCategory *cat;

  cat = bse_category_from_id (id);
  
#line 103 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cat);
  
  return BSE_ERROR_NONE;
}

static gboolean
categories_check_method (BseCategory *cat,
                         gpointer     data)
{
  GType *type_p = data;
  GType ptype = g_type_from_name (cat->type);
  gboolean match = FALSE;
  if (BSE_TYPE_IS_PROCEDURE (ptype))
    {
      BseProcedureClass *proc = g_type_class_ref (ptype);
      if (proc->n_in_pspecs >= 1 &&
          g_type_is_a (G_PARAM_SPEC_VALUE_TYPE (proc->in_pspecs[0]), *type_p))
        match = TRUE;
      g_type_class_unref (proc);
    }
  return match;
}

/* --- bse-categories-match-method --- */
static void
bse_categories_match_method_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 127 "bsecategories.proc"
 {
#line 129 "bsecategories.proc"
  *(in_pspecs++) = sfi_pspec_string ("pattern", "Pattern", "Pattern to match category, supports '*' and '?' wildcards.",
			    "*", SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("type", "Type", "Object base type for methods to conform to.",
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("categories", "Categories", NULL, BSE_TYPE_CATEGORY_SEQ, SFI_PARAM_STANDARD);
}
#line 135 "bsecategories.proc"
 }
static BseErrorType
#line 135 "bsecategories.proc"
bse_categories_match_method_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 138 "bsecategories.proc"
{
#line 139 "bsecategories.proc"
  
  gchar *pattern   = sfi_value_get_string (in_values++);
  gchar *type_name = sfi_value_get_string (in_values++);
  GType  type      = type_name ? g_type_from_name (type_name) : 0;
  BseCategorySeq *cseq = NULL;
  
#line 145 "bsecategories.proc"
  
  if (!pattern)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  cseq = bse_categories_match (pattern, BSE_TYPE_PROCEDURE, categories_check_method, &type);
  if (!cseq)
    cseq = bse_category_seq_new ();
  
#line 153 "bsecategories.proc"
  
  bse_value_take_boxed (out_values++, cseq);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_bse_categories_match_typed__fill_strings (BseExportStrings *es)
{
  es->blurb = "List BSE categories according to a pattern and type match.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 27;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_categories_match_typed = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "bse-categories-match-typed", 
    NULL,
    "/Proc/Categories/Match Typed",
    NULL,
    __enode_bse_categories_match_typed__fill_strings,
  },
  0, bse_categories_match_typed_setup, bse_categories_match_typed_exec, 
};
static void
__enode_bse_categories_match__fill_strings (BseExportStrings *es)
{
  es->blurb = "List BSE categories according to a pattern match.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 60;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_categories_match = {
  { (BseExportNode*) &__enode_bse_categories_match_typed, BSE_EXPORT_NODE_PROC,
    "bse-categories-match", 
    NULL,
    "/Proc/Categories/Match",
    NULL,
    __enode_bse_categories_match__fill_strings,
  },
  0, bse_categories_match_setup, bse_categories_match_exec, 
};
static void
__enode_bse_category_from_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Find a BSE category from it's unique ID.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 88;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_category_from_id = {
  { (BseExportNode*) &__enode_bse_categories_match, BSE_EXPORT_NODE_PROC,
    "bse-category-from-id", 
    NULL,
    "/Proc/Categories/From ID",
    NULL,
    __enode_bse_category_from_id__fill_strings,
  },
  0, bse_category_from_id_setup, bse_category_from_id_exec, 
};
static void
__enode_bse_categories_match_method__fill_strings (BseExportStrings *es)
{
  es->blurb = "List BSE categories according to a pattern, of type procedure and applying to a certain object type.";
  es->file = "/opt/src/beast/bse/bsecategories.proc";
  es->line = 128;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_bse_categories_match_method = {
  { (BseExportNode*) &__enode_bse_category_from_id, BSE_EXPORT_NODE_PROC,
    "bse-categories-match-method", 
    NULL,
    "/Proc/Categories/Match Method",
    NULL,
    __enode_bse_categories_match_method__fill_strings,
  },
  0, bse_categories_match_method_setup, bse_categories_match_method_exec, 
};
BseExportNode* bse__builtin_init_bsecategories_genprc_c (void);
BseExportNode* bse__builtin_init_bsecategories_genprc_c (void)
{
  return (BseExportNode*) &__enode_bse_categories_match_method;
}

/*
 * Generated data ends here
 */
