// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "RenderQueue.pypp.hpp"

namespace bp = boost::python;

void register_RenderQueue_class(){

    { //::CEGUI::RenderQueue
        typedef bp::class_< CEGUI::RenderQueue > RenderQueue_exposer_t;
        RenderQueue_exposer_t RenderQueue_exposer = RenderQueue_exposer_t( "RenderQueue", "*!\n\
        \n\
            Class that represents a queue of GeometryBuffer objects to be rendered.\n\
        \n\
        \note\n\
            The RenderQueue does not make copies of added GeometryBuffers, nor does it\n\
            take ownership of them - it is up to other parts of the system to manage the\n\
            lifetime of the GeometryBuffer objects (and to remove them from any\n\
            RenderQueue to which they may be attached prior to destoying them).\n\
        *\n" );
        bp::scope RenderQueue_scope( RenderQueue_exposer );
        { //::CEGUI::RenderQueue::addGeometryBuffer
        
            typedef void ( ::CEGUI::RenderQueue::*addGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            RenderQueue_exposer.def( 
                "addGeometryBuffer"
                , addGeometryBuffer_function_type( &::CEGUI::RenderQueue::addGeometryBuffer )
                , ( bp::arg("buffer") )
                , "*!\n\
                \n\
                    Add a GeometryBuffer to the RenderQueue.  Ownership of the\n\
                    GeometryBuffer does not pass to the RenderQueue.\n\
            \n\
                @param buffer\n\
                    GeometryBuffer that is to be added to the RenderQueue for later drawing.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderQueue::draw
        
            typedef void ( ::CEGUI::RenderQueue::*draw_function_type )(  ) const;
            
            RenderQueue_exposer.def( 
                "draw"
                , draw_function_type( &::CEGUI::RenderQueue::draw )
                , "*!\n\
            \n\
                Draw all GeometryBuffer objects currently listed in the RenderQueue.\n\
                The GeometryBuffer objects remain in the queue after drawing has taken\n\
                place.\n\
            *\n" );
        
        }
        { //::CEGUI::RenderQueue::removeGeometryBuffer
        
            typedef void ( ::CEGUI::RenderQueue::*removeGeometryBuffer_function_type )( ::CEGUI::GeometryBuffer const & ) ;
            
            RenderQueue_exposer.def( 
                "removeGeometryBuffer"
                , removeGeometryBuffer_function_type( &::CEGUI::RenderQueue::removeGeometryBuffer )
                , ( bp::arg("buffer") )
                , "*!\n\
                \n\
                    Remove a GeometryBuffer previously queued for drawing.  If the specified\n\
                    GeometryBuffer is not added to the queue, no action is taken.  The\n\
                    removed GeometryBuffer is not destroyed or modified in any way.\n\
            \n\
                @param buffer\n\
                    GeometryBuffer to be removed from the queue.\n\
                *\n" );
        
        }
        { //::CEGUI::RenderQueue::reset
        
            typedef void ( ::CEGUI::RenderQueue::*reset_function_type )(  ) ;
            
            RenderQueue_exposer.def( 
                "reset"
                , reset_function_type( &::CEGUI::RenderQueue::reset )
                , "*!\n\
            \n\
                Remove any and all queued GeometryBuffer objects and restore the queue\n\
                to the default state.  Any GeometryBuffer objects removed are not\n\
                destroyed or modified in any way.\n\
            *\n" );
        
        }
    }

}
