# -*- encoding: utf-8 -*-
#
# Copyright © 2013 eNovance
#
# Author: Julien Danjou <julien@danjou.info>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from sqlalchemy import MetaData, Table, Column, DateTime

from ceilometer.openstack.common import timeutils

meta = MetaData()


def upgrade(migrate_engine):
    meta.bind = migrate_engine
    resource = Table('resource', meta, autoload=True)
    timestamp = Column('timestamp', DateTime)
    resource.drop_column(timestamp)
    received_timestamp = Column('received_timestamp', DateTime)
    resource.drop_column(received_timestamp)


def downgrade(migrate_engine):
    meta.bind = migrate_engine
    resource = Table('resource', meta, autoload=True)
    timestamp = Column('timestamp', DateTime)
    resource.create_column(timestamp)
    received_timestamp = Column('received_timestamp', DateTime,
                                default=timeutils.utcnow)
    resource.create_column(received_timestamp)
