/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU General Public License, Version 2,
 * June 1991, which is contained in the read-me file named
 * "README_GNU_GPL." This program is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "lcd.h"
#include "lcdutils.h"

int main(int argc, char **argv) {
	void *lcd;
	int c, row, column;
	unsigned char address;
	
	row = -1;
	column = -1;
	
	lcd_setlocale();
	
	if (argc < 2) {
		printf(_("Usage: %s <row> <column>\n"),argv[0]);
		exit(0);
	}
	
	for (c = 1; c < argc; c++) {
		if (c == 1)
			row = atoi(argv[c]);
		if (c == 2)
			column = atoi(argv[c]);
	}
	
	if ((row < 1) || (row > 2) || (column < 1) || (column > 16)) {
		printf(_("Usage: %s <row> <column>\n"),argv[0]);
		exit(0);
	}
	
	address = ((unsigned char) row - 1) * 64;
	address += (unsigned char) column - 1;
	
	if (lcd_lock() < 0) {
		printf(_("LCD in use... try again later\n"));
		exit(0);
	}
	
	if ((lcd = lcd_open(O_RDWR)) == NULL) {
		printf(_("LCD is not present\n"));
		exit(0);
	}
	
	lcd_set(lcd, LCD_Cursor_On);
	lcd_setcursorpos(lcd, address);
	lcd_close(lcd);
	lcd_unlock();
	
	exit(0);
}
