/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CalendarValueComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollatingAtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.DecimalSortComparer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements AtomicComparer {
    private Comparator collator;
    private XPathContext conversionContext;
    public static StringValue COLLATION_KEY_NaN = new StringValue("NaN");

    public static AtomicComparer makeSortComparer(Comparator comparator, int n, XPathContext xPathContext) {
        switch (n) {
            case 513: 
            case 529: 
            case 642: {
                if (comparator instanceof CodepointCollator) {
                    return CodepointCollatingComparer.getInstance();
                }
                return new CollatingAtomicComparer(comparator, xPathContext.getConfiguration().getPlatform());
            }
            case 515: 
            case 532: {
                return DecimalSortComparer.getInstance();
            }
            case 516: 
            case 517: 
            case 646: {
                return DoubleSortComparer.getInstance();
            }
            case 519: 
            case 520: 
            case 521: {
                return new CalendarValueComparer(xPathContext.getConfiguration());
            }
        }
        return new AtomicSortComparer(comparator, xPathContext);
    }

    private AtomicSortComparer(Comparator comparator, XPathContext xPathContext) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = xPathContext;
    }

    public int compare(Object object, Object object2) {
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            object = ((AtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof AtomicValue && !((AtomicValue)object2).hasBuiltInType()) {
            object2 = ((AtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator, this.conversionContext);
        }
        if (object2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)object2).compareTo(object, this.collator, this.conversionContext);
        }
        if (object instanceof NumericValue && ((NumericValue)object).isNaN()) {
            if (object2 instanceof NumericValue && ((NumericValue)object2).isNaN()) {
                return 0;
            }
            return -1;
        }
        if (object2 instanceof NumericValue && ((NumericValue)object2).isNaN()) {
            return 1;
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.conversionContext.getConfiguration());
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof StringValue && object2 instanceof StringValue) {
            if (this.collator instanceof CodepointCollator) {
                return ((CodepointCollator)this.collator).compareCS(((StringValue)object).getStringValueCS(), ((StringValue)object2).getStringValueCS());
            }
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue());
        }
        if (object instanceof AtomicValue && object2 instanceof AtomicValue) {
            throw new ClassCastException("Objects are not comparable (" + ((AtomicValue)object).getItemType(null) + ", " + ((AtomicValue)object2).getItemType(null) + ')');
        }
        throw new ClassCastException("Objects are not comparable (" + object.getClass() + ", " + object2.getClass() + ')');
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compare(atomicValue, atomicValue2) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        AtomicValue atomicValue2 = atomicValue.getPrimitiveValue();
        Configuration configuration = this.conversionContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (atomicValue2 instanceof NumericValue) {
            if (((NumericValue)atomicValue2).isNaN()) {
                return new ComparisonKey(646, COLLATION_KEY_NaN);
            }
            return new ComparisonKey(646, atomicValue2);
        }
        if (atomicValue2 instanceof StringValue) {
            Platform platform = configuration.getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, platform.getCollationKey(this.collator, ((StringValue)atomicValue2).getStringValue()));
            }
            return new ComparisonKey(513, atomicValue2);
        }
        if (atomicValue2 instanceof CalendarValue) {
            CalendarValue calendarValue = (CalendarValue)atomicValue2;
            if (calendarValue.hasTimezone()) {
                return new ComparisonKey(atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2);
            }
            calendarValue = calendarValue.copy();
            calendarValue.setTimezoneInMinutes(configuration.getImplicitTimezone());
            return new ComparisonKey(calendarValue.getItemType(typeHierarchy).getPrimitiveType(), calendarValue);
        }
        if (atomicValue2 instanceof DurationValue) {
            return new ComparisonKey(518, atomicValue2);
        }
        return new ComparisonKey(atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), atomicValue2);
    }
}

