﻿/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Scripting.Math;
using Microsoft.Scripting.Runtime;

using IronPython.Runtime.Operations;

namespace IronPython.Compiler.Ast {
    public partial class BinaryExpression {
        internal override Expression ConstantFold() {
            Expression left = _left.ConstantFold();
            Expression right = _right.ConstantFold();

            var constLeft = left as ConstantExpression;
            var constRight = right as ConstantExpression;
            try {
                if (constLeft != null && constRight != null &&
                    constLeft.Value != null && constRight.Value != null &&
                    constLeft.Value.GetType() == constRight.Value.GetType()) {
                    #region Generated Python Constant Folding

                    // *** BEGIN GENERATED CODE ***
                    // generated by function: gen_constant_folding from: generate_ops.py

                    if (constLeft.Value.GetType() == typeof(Int32)) {
                        switch (_op) {
                            case PythonOperator.Add: return new ConstantExpression(Int32Ops.Add((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.Subtract: return new ConstantExpression(Int32Ops.Subtract((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.Power: return new ConstantExpression(Int32Ops.Power((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.Multiply: return new ConstantExpression(Int32Ops.Multiply((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.FloorDivide: return new ConstantExpression(Int32Ops.FloorDivide((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.Divide: return new ConstantExpression(Int32Ops.Divide((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.TrueDivide: return new ConstantExpression(Int32Ops.TrueDivide((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.Mod: return new ConstantExpression(Int32Ops.Mod((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.LeftShift: return new ConstantExpression(Int32Ops.LeftShift((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.RightShift: return new ConstantExpression(Int32Ops.RightShift((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.BitwiseAnd: return new ConstantExpression(Int32Ops.BitwiseAnd((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.BitwiseOr: return new ConstantExpression(Int32Ops.BitwiseOr((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.ExclusiveOr: return new ConstantExpression(Int32Ops.ExclusiveOr((Int32)constLeft.Value, (Int32)constRight.Value));
                            case PythonOperator.LessThan: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(Int32Ops.Compare((Int32)constLeft.Value, (Int32)constRight.Value) < 0));
                            case PythonOperator.GreaterThan: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(Int32Ops.Compare((Int32)constLeft.Value, (Int32)constRight.Value) > 0));
                            case PythonOperator.LessThanOrEqual: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(Int32Ops.Compare((Int32)constLeft.Value, (Int32)constRight.Value) <= 0));
                            case PythonOperator.GreaterThanOrEqual: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(Int32Ops.Compare((Int32)constLeft.Value, (Int32)constRight.Value) >= 0));
                            case PythonOperator.Equals: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(Int32Ops.Compare((Int32)constLeft.Value, (Int32)constRight.Value) == 0));
                            case PythonOperator.NotEquals: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(Int32Ops.Compare((Int32)constLeft.Value, (Int32)constRight.Value) != 0));
                        }
                    }
                    if (constLeft.Value.GetType() == typeof(Double)) {
                        switch (_op) {
                            case PythonOperator.Add: return new ConstantExpression(DoubleOps.Add((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.Subtract: return new ConstantExpression(DoubleOps.Subtract((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.Power: return new ConstantExpression(DoubleOps.Power((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.Multiply: return new ConstantExpression(DoubleOps.Multiply((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.FloorDivide: return new ConstantExpression(DoubleOps.FloorDivide((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.Divide: return new ConstantExpression(DoubleOps.Divide((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.TrueDivide: return new ConstantExpression(DoubleOps.TrueDivide((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.Mod: return new ConstantExpression(DoubleOps.Mod((Double)constLeft.Value, (Double)constRight.Value));
                            case PythonOperator.LessThan: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(DoubleOps.Compare((Double)constLeft.Value, (Double)constRight.Value) < 0));
                            case PythonOperator.GreaterThan: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(DoubleOps.Compare((Double)constLeft.Value, (Double)constRight.Value) > 0));
                            case PythonOperator.LessThanOrEqual: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(DoubleOps.Compare((Double)constLeft.Value, (Double)constRight.Value) <= 0));
                            case PythonOperator.GreaterThanOrEqual: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(DoubleOps.Compare((Double)constLeft.Value, (Double)constRight.Value) >= 0));
                            case PythonOperator.Equals: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(DoubleOps.Compare((Double)constLeft.Value, (Double)constRight.Value) == 0));
                            case PythonOperator.NotEquals: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(DoubleOps.Compare((Double)constLeft.Value, (Double)constRight.Value) != 0));
                        }
                    }
                    if (constLeft.Value.GetType() == typeof(BigInteger)) {
                        switch (_op) {
                            case PythonOperator.Add: return new ConstantExpression(BigIntegerOps.Add((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.Subtract: return new ConstantExpression(BigIntegerOps.Subtract((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.Power: return new ConstantExpression(BigIntegerOps.Power((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.Multiply: return new ConstantExpression(BigIntegerOps.Multiply((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.FloorDivide: return new ConstantExpression(BigIntegerOps.FloorDivide((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.Divide: return new ConstantExpression(BigIntegerOps.Divide((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.TrueDivide: return new ConstantExpression(BigIntegerOps.TrueDivide((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.Mod: return new ConstantExpression(BigIntegerOps.Mod((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.LeftShift: return new ConstantExpression(BigIntegerOps.LeftShift((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.RightShift: return new ConstantExpression(BigIntegerOps.RightShift((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.BitwiseAnd: return new ConstantExpression(BigIntegerOps.BitwiseAnd((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.BitwiseOr: return new ConstantExpression(BigIntegerOps.BitwiseOr((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.ExclusiveOr: return new ConstantExpression(BigIntegerOps.ExclusiveOr((BigInteger)constLeft.Value, (BigInteger)constRight.Value));
                            case PythonOperator.LessThan: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(BigIntegerOps.Compare((BigInteger)constLeft.Value, (BigInteger)constRight.Value) < 0));
                            case PythonOperator.GreaterThan: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(BigIntegerOps.Compare((BigInteger)constLeft.Value, (BigInteger)constRight.Value) > 0));
                            case PythonOperator.LessThanOrEqual: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(BigIntegerOps.Compare((BigInteger)constLeft.Value, (BigInteger)constRight.Value) <= 0));
                            case PythonOperator.GreaterThanOrEqual: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(BigIntegerOps.Compare((BigInteger)constLeft.Value, (BigInteger)constRight.Value) >= 0));
                            case PythonOperator.Equals: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(BigIntegerOps.Compare((BigInteger)constLeft.Value, (BigInteger)constRight.Value) == 0));
                            case PythonOperator.NotEquals: return new ConstantExpression(ScriptingRuntimeHelpers.BooleanToObject(BigIntegerOps.Compare((BigInteger)constLeft.Value, (BigInteger)constRight.Value) != 0));
                        }
                    }

                    // *** END GENERATED CODE ***

                    #endregion

                    if (constLeft.Value.GetType() == typeof(string) && _op == PythonOperator.Add) {
                        return new ConstantExpression((string)constLeft.Value + (string)constRight.Value);
                    }
                } else if (_op == PythonOperator.Multiply && constLeft != null && constRight != null) {
                    if (constLeft.Value.GetType() == typeof(string) && constRight.Value.GetType() == typeof(int)) {
                        return new ConstantExpression(StringOps.Multiply((string)constLeft.Value, (int)constRight.Value));
                    } else if(constLeft.Value.GetType() == typeof(int) && constRight.Value.GetType() == typeof(string)) {
                        return new ConstantExpression(StringOps.Multiply((string)constRight.Value, (int)constLeft.Value));
                    }
                }   
            } catch (ArithmeticException) {
            }

            return this;
        }

    }
}
