# -*- coding: iso-8859-1 -*-
# Copyright (C) 2013 Bastian Kleineidam
"""
Comicfury comic strips
"""
from re import compile
from ..scraper import make_scraper
from ..util import tagre
from ..helpers import bounceStarter


_imageSearch = compile(tagre("img", "src", r'([^"]+)', after='comicimage'))
_prevSearch = compile(tagre("a", "href", r'(/comics/\d+)', after='prev'))
_nextSearch = compile(tagre("a", "href", r'(/comics/\d+)', after='next'))

def add(name, url, description):
    classname = 'ComicFury_%s' % name

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        parts = pageUrl.split('/')
        num = parts[-1]
        return "%s_%s" % (name, num)

    globals()[classname] = make_scraper(classname,
        name='ComicFury/' + name,
        description = description,
        url = url,
        stripUrl = url + '%s',
        starter = bounceStarter(url, _nextSearch),
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        help = 'Index format: none',
        namer = namer,
    )

# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('1234567902791', 'http://1234567902791.webcomic.ws/', u"The comic in when a happily, retarded knight, a hateful wizard, a demon thief, and a darkened thing go on random quests facing dangerous monsters, characters, and the most challenging, themselves. You've never seen a game like this. Super RPG.")
add('12yearslater', 'http://12yearslater.webcomic.ws/', u'This is a strip comic about two different moments. One of them happens a certain number of years after the other- I bet you can guess how many.')
add('6colorstories', 'http://6colorstories.webcomic.ws/', u'')
add('933dollars', 'http://933dollars.webcomic.ws/', u'')
add('AAB', 'http://AAB.webcomic.ws/', u"This is where I plan on sticking all my non-cannon Frostbound, and miscellaneous art for your enjoyment. Any fan art that get's draw for Frostbound will also end up here.")
add('Abrickishspacecomic', 'http://Abrickishspacecomic.webcomic.ws/', u'A photographic comic made with LEGO space.')
add('AccidentallyonPurpose', 'http://Accidentally-on-Purpose.webcomic.ws/', u'A Warlock, a Guitarist, and a Host for a demon live under the same roof and are in a three way relationship. As things go upside down and right side up again, there seems to be quite a few issues in their lives, even though the three of them seem to still make it through okay, minus the huge bills they have to pay to their landlord...')
add('Acryden', 'http://acryden.webcomic.ws/', u"Hey everyone we're back on track with the pages. It was a mess up on my part with the dates. Of course our main site always updates first and has the latest information. Feel free to visit us at Acryden.com")
add('Actingout', 'http://actingout.webcomic.ws/', u"When a bunch of kids with very different personalities come together in their school's drama club, a lot more goes on in the auditorium than you may think! Follow the dramatic lives of Clinton, Ollie, Tasha, and the rest of the gang as they set the scene and put on a heck of a performance, both on and off the stage! Updates are on Sundays and Thursdays!")
add('Adventuresofjonas', 'http://adventuresofjonas.webcomic.ws/', u"These short, scribbely orange comics are excerpts from my life through my own slanted viewpoint .. they are totally out of context. Its mostly disjointed vignettes, relationships, inside jokes, a couple nifty thoughts and dumb adventures sprinkled on over that. somewhere between a soapdrama and a gag strip and a traffic accident. Life. whatever. if you prefer to read it in spanish, check out 'las Aventuras de JONAS!' at http://jonas.subcultura.es/")
add('Afairtrade', 'http://afairtrade.webcomic.ws/', u'')
add('Afrodays', 'http://afrodays.webcomic.ws/', u'Inspired By Life Nope, nope turkeys')
add('Albinobros', 'http://albinobros.webcomic.ws/', u'Two guys at work shoot the breeze and do their best to not break the fourth wall.')
add('Alexanderandlucas', 'http://alexanderandlucas.webcomic.ws/', u'Alex and Lucas are roomies and old friends. Follow their lives as they try to make it through the life of high school graduates. Hilarity, and mainly drama, ensues! This is a reboot of a previous comic I had on Drunk Duck.')
add('Alittlebitofeverything', 'http://alittlebitofeverything.webcomic.ws/', u"Gag-a-day comic featuring the adventures of Lucky, Swifty, their friends & family. Expect laughs, classic muscle cars, and stuff blowing up... but hopefully not the muscle cars. We don't have the budget to replace them.")
add('Allthebbqsauce', 'http://allthebbqsauce.webcomic.ws/', u'A comedy strip about antics and semantics.')
add('Alone', 'http://Alone.webcomic.ws/', u'One day when Arianna wakes up, something\xb4s different... The entire world is gone, she sets out on an exciting adventure to find out what\xb4s going on.')
add('AmericanNerd', 'http://AmericanNerd.webcomic.ws/', u"The adventures of the epynonymous nerd in Japan, going through the usual JRPG motions alongside a blonde amnesiac protagonist, a nature spirit, a Digital monster, a Sonic the Hedgehog cosplayer, and a few characters I haven't gotten around to yet. Whacky shennanigans ensue.")
add('Americanextremists', 'http://americanextremists.webcomic.ws/', u"Politics 'n stuff")
add('Amtheatre', 'http://amtheatre.webcomic.ws/', u"Do you like mid-low fantasy? Do you like comedy? Are you not offended by characters who are missing important appendages? Maybe you should read this. Or maybe not. Is this another DnD comic? No. But is it filled with cheap pop culture references? Hell no. Why is the main character a girl with no legs or right arm? Because I'm a sick human being, okay???")
add('AnK', 'http://AnK.webcomic.ws/', u"Synopsis: For the first time in millennia, Arecace is on the brink of war. Cyden, an Esarian rebel looking to achieve equal rights for his race conspires to overthrow the world's central government through violence and attrition. His nephew, Drake, may be the only one who can stop him. Both want to enlist the help of an young Esarian, Mathaeis who has only just learned what he is, and may be the key to either one's success by his association to a once formidable Esarian, Azrisar. Themes: power, betrayal, civil rights, liability Genre: fantasy, political thriller, action Written Summary of completed chapters here: sta.sh/08f2dfrpf8u")
add('Angryfaerie', 'http://angryfaerie.webcomic.ws/', u"Not all faeries are happy, cheerful little forest creatures. One, in fact, is downright ornery. She's mean-spirited, violent.. and ANGRY. Welcome to the twisted world of Angry Faerie.")
add('Antarcticbroadcasting', 'http://antarcticbroadcasting.webcomic.ws/', u'Stickmen and their shenanigans-- inspired by life and other disasters.')
add('Anthrosanddungeons', 'http://Anthrosanddungeons.webcomic.ws/', u'Welcome to the Inn of the Anthros and Dungeons. Pull up a bar stool and order a pint. Listen to the tales told by the owners of this fine establishment of their years as adventurers and how they escaped their births in bondage. They have many tales to tell, and are always seeking an ear to listen to their tales.')
add('Applepine', 'http://Applepine.webcomic.ws/', u'Follow Applepine as he experiences life one problem at a time, with help from his friends of course! Each with their own way of solving the enigma of life, they help Applepine find his way through trouble, girls, and adventure in this ongoing series.')
add('ArachnidGoddess', 'http://ArachnidGoddess.webcomic.ws/', u"Dark modern fantasy! Born of a severe stroke of individuality & nihilism, 'Ahab' relates more to vermin & outcasts. Join the narrative as she abandons her humanity & finds herself in the gloom. Features peril, BDSM, & disturbing scenes.")
#add('ArchportCityChronicles', 'http://ArchportCityChronicles.webcomic.ws/', u"The best guessed center of the universe has an adventure for everyone...It's amazing what you can stumble into... Dissatisfied on what was supposed to be a fun trip it was only a matter of time until adventure lured Joe in. Now a group of discredited bounty hunters with a dangerous target have dragged him along for the ride.. Updates Tu and Thr... IF THE PAGES GO UP SIDE WAYS LET ME KNOW THE FILES SEEM TO BE MESSING UP FOR SOME REASON SOMETIMES!!! New opening is UP!!")
add('AreYouDoneYet', 'http://AreYouDoneYet.webcomic.ws/', u'A series of cartoons about raising a large family in the traditional three panel format.')
add('Armybrat', 'http://armybrat.webcomic.ws/', u'')
add('Asperchu', 'http://asperchu.webcomic.ws/', u"Welcome to the grand world of ASPERCHU, the electric/aspergers type hedgehog pokemon! Join ASPERCHU in his adventures to save Albville from the evils of evil villains of the PVCC and more. I am so greatful to have my TRUE and LOYAL fanbase, which I would never have had if not for the leadership and artistic genius shown to guide me by Christian Weston Chandler. I welcome all fans who wish to contribute to ASPERCHU'S adventures, as without them my power would be none!")
add('Astralaves', 'http://astralaves.webcomic.ws/', u'a comic I am working on. Sort of a fantasy thing.')
add('Atm', 'http://atm.webcomic.ws/', u'')
add('Atomicmonkey', 'http://atomicmonkey.webcomic.ws/', u'Welcome to Pandora City where monsters, demons, and mechanical menaces roam. Who can stand before this onslaught? Are the citizens doomed? Will heroes like the Killer Bee, Arcane, and the Wildborn be enough to prevent the forces of evil from finally gaining control of the city and its secrets?')
add('Atowncalledalandale', 'http://atowncalledalandale.webcomic.ws/', u'Welcome to the town of Alandale. Join the adventures of three friends as they try to live their lives as normal as possible, in the strangest town on earth where anything can happen.')
#add('Augustos', 'http://augustos.webcomic.ws/', u'When three kids escape from a shady research facility, where humans are being experimented on and dark deeds are happening unnoticed by the rest of the world, they find themselves in the middle of the desert, with no food, no water, and barely able to get along with each other. When their only friend in the world, Emily, is "kidnapped" by government officials, they boldly and stubbornly chase after her, hoping to find her as well as some clues about their past. But Emily is not all that she seems... On the way, they run into several strange and bizarre characters who rarely help and often cause more trouble for them. Augustos is a purely adventurous story with a bit of action and humor squeezed into it!')
add('Awkwardshelby', 'http://awkwardshelby.webcomic.ws/', u"Awkward Shelby is a slice-of-life comic that focuses on everyday awkward situations, staring off into space, cats, and more. It's not only a record of its author's life but it can be transcribed into each one of our own lives. Updates at least once a week, usually weekdays at 10am Visit the online store: http://skreened.com/awkwardshelby")
#add('BASO', 'http://BASO.webcomic.ws/', u'An epic space opera')
add('BATB', 'http://BATB.webcomic.ws/', u'A lushly conceived and meticulously researched retelling of the classic Fairy Tale, Beauty and The Beast.')
add('BTTF', 'http://BTTF.webcomic.ws/', u'A man is residing in his home when he discovers that his fridge has vanished under mysterious circumstances. Updating Mondays, Wednesdays and Fridays.')
add('BabyBatman', 'http://BabyBatman.webcomic.ws/', u"It's Batman, but as a baby. Well technically he's more of a small child but that doesn't have the same ring to it. Updates Tuesday and Friday!")
#add('Barkingcrayon', 'http://barkingcrayon.webcomic.ws/', u'Comics with a Conservative slant.')
add('Baseballcapsandtiaras', 'http://Baseballcapsandtiaras.webcomic.ws/', u'A tomboy, 16 year old Paige, and a girly girl, 8 year old Katie, discover a portal to a magical world in their house. The magical world is fraught with political dangers.')
add('BattleoftheRobofemoids', 'http://Battle-of-the-Robofemoids.webcomic.ws/', u'Robofemoids rocket off into space and meet up with lots of people who prove difficult to live with. Along the way they strip more for conversion and lovingly create more robofemoids and introduce the robohomoid.')
add('Beebleville', 'http://Beebleville.webcomic.ws/', u"A cheesy webcomic following the odd perspective of one man's journey through work, marriage, fatherhood, life, death, and dealing with his wifes' damn cats interwoven with the strange happenings of the world we all inhabit.")
add('Beepolice', 'http://beepolice.webcomic.ws/', u'Bee Police is a comic about government conspiracies, mutant bees, mountain gods, ancient aliens, random monsters, and some aggies living in an out of the way town named Podunk.')
add('Bentelbows', 'http://bentelbows.webcomic.ws/', u"You got some kind of skeleton bag man on hallucinogens, a mummy that's tired of life, and a crocodile that truly appreciates alcohol.")
add('BetaParticles', 'http://BetaParticles.webcomic.ws/', u"This is where things go that don't go elsewhere. For those more curious as to my motives or rationale, see here: [url=http://betaparticles.thecomicseries.com/about/]Click this[/url]")
add('BetweenRounds', 'http://Between-Rounds.webcomic.ws/', u'')
add('Biblebelt', 'http://biblebelt.webcomic.ws/', u"I'm balancing a 3 1/2 year old on my head as I type this. Truly one of God's miracles. (The simultaneous balancing and typing, not my ability to reproduce.) Feel free to point out my spelling and grammar mistakes. Amen.")
add('Bigfoldy', 'http://bigfoldy.webcomic.ws/', u'The Big Foldy: A tale of friendship, robots, earth, lasers, space, action, comedy, sneezing, delicious food such as hot dogs and ice cream, laughter, incessant beeping, invasion, and the relationship between cultures?')
add('Bimorphon', 'http://bimorphon.webcomic.ws/', u'The humans are not alone in the universe, as two small androids travel from planet to planet, attempting to defend them from annihilation. After reaching Earth, they meet their human hosts and defend it from an evil that\u2019s been unstoppable. Can the humans help the androids protect Earth? Or will they only postpone the inevitable?')
add('Biosyte', 'http://biosyte.webcomic.ws/', u'Michael Treble, an everyday man who seems to answer any question thrown at him with ease. Explaining things is a jiffy for him. Or so it would seem. He will receive a rather... gross awakening from his "high and mighty" persona when a biological weapon-a prototype parasitic virus- is suddenly introduced into his system. And what do you know?! This thing has been granted the power of sentience! (Occasional Updates)')
add('Blackwoods', 'http://Blackwoods.webcomic.ws/', u'The Blackwoods is a comic about a teenage girl, Sadie, who ends up having to move in with her aunt. Her aunt works as a maid for a peculiar family in a gigantic mansion from the 1800s. Sadie discovers that the family who lives in the mansion, along with the servants, act as though they are still living in the 1800s. They never leave the mansion, and strange incidents occur which cause Sadie to unravel a dark and terrible secret that the Blackwoods have been hiding for centuries.')
add('BlueBloodHeroes', 'http://BlueBloodHeroes.webcomic.ws/', u'Six children possess a genetic irregularity that grants them super-human powers and turns their blood blue. As criminals and injustice begin to rise in their hometown, they decide to form a superhero team.')
add('Bobbythefetus', 'http://bobbythefetus.webcomic.ws/', u"A fetal adventures of a fetus (which is not an e!). It features a Svalbardian/Swedish fetus(which might be a fetus, but isn't) named Bobby located somewhere in Iceland, adjustment disordered narrator who hates being seen, Roberta the fetus (who is not an e!) who is Bobby's girlfriend, the author himself, a sock puppet and a minor deity destined to ruin the world... This is a mirror of the DrunkDuck comic with the same name and author...")
add('Booksdontworkhere', 'http://booksdontworkhere.webcomic.ws/', u'A meta flavored webcomic with no 4th wall and a plot about a webcomic actress and the challenges she has to face. You know imaginary scripts, unreliable narrators, plot holes, meta walls, wacky physics, mad science, and budget cuts. Updates Monday, Wednesday, and Friday.')
add('Boritom', 'http://boritom.webcomic.ws/', u'The scintillating adventures of an alien, a redneck and a floating orb of death in the bucolic setting of fictional "Utopia Dell, Arizona." The strips currently running are all of the "classic Boritom" adventures from the strip\'s original run from 2000 to 2006. In all, there were about 325 strips, so I am currently updating 5 days a week in order to get people caught up. As we get closer to the "Big Day," where brand new strips start coming up, there will be lots of information and ballyhoo letting everyone know what to expect... to an extent. Spoilers, Doctor... Spoilers... Once new strips start coming out, however, the updates will probably scale back to once or twice a week.')
add('Brickland', 'http://brickland.webcomic.ws/', u'Tales of Brickland centers around four groups of people: Kristy and Drew (adventurers who traveled to another continent for, well, adventures), Gina (a ninja), Captain Slade and his pirate crew, and Queen Toshiko, returned from the dead and bent on world domination. Again. A silly fantasy comic told with minifigs and bricks that updates every Monday, Wednesday, and Friday.')
add('BrokenReality', 'http://BrokenReality.webcomic.ws/', u'This story revolves around two teenage boys who suddenly find themselves living in japan for no apparent reason. Joined by twin Japanese girls, The four of them now seem to be living their lives in a world where the rules of reality are constantly being broken in one way or another.')
#add('Bulletproof', 'http://bulletproof.webcomic.ws/', u'In Junction City, there are men and women with strange powers and abilities, the Omega Humans. Ostracized by society, many turn to crime, while a few are employed by JCORP to keep the city safe. But can a corporation be trusted with law enforcement? Bulletproof is a B&W superhero comic set in a dystopian near-future city.')
add('Bustysolar', 'http://bustysolar.webcomic.ws/', u'The space adventures of Busty Solar and her space police team. Lots of strange jokes and naughty fun.')
add('Cannonadeofhogwash', 'http://cannonadeofhogwash.webcomic.ws/', u'As the title suggests, this is a cannonade of hogwash. Updated almost daily.')
add('Carrotknight', 'http://carrotknight.webcomic.ws/', u'"The Adventures of Carrot Knight" is a surreal adventure comic, drawn entirely on sticky notes, updated every weekday.')
add('CatHero', 'http://CatHero.webcomic.ws/', u"Cat Hero's epic Catventures as an Hero, starring Cat Hero as Cat Hero, by Cat Hero; is a graphical representation of the (mis)adventures of a cat-person named Cat Hero, whose arch-nemesis is CatoreH, a life-sized cardboard cutout of a (very) badly drawn cat-person. Half a quick comic, half an experiment to see if single-panel gag-a-day style can actually convey a story, and be good doing it.")
#add('Cataclysm', 'http://cataclysm.webcomic.ws/', u'Set on the last remaining hospitable island on a frozen world, a covert faction known as Militia attempts to overthrow a utopian civilization and their benevolent rulers, The Council.')
add('Catwithgoggles', 'http://catwithgoggles.webcomic.ws/', u'')
add('Cautionarytales', 'http://cautionarytales.webcomic.ws/', u'A webcomic, caution sign style.')
#add('Chimerical', 'http://chimerical.webcomic.ws/', u"Ever since he was thirteen, visions of monsters and other supernatural beings have plagued Brett's mind. With the help from Quinn, a wannabe mortician who is infatuated with him, Brett becomes a part of a mission to get rid of these monsters once and for all. Unfortunately, everything is not what it seems and nothing goes as planned. --- warnings for gore/violence and terrible, horrible puns. updates every sunday, wednesday, and friday.")
add('Chocolava', 'http://chocolava.webcomic.ws/', u'An awesome webcomic by The BIG Four (email: chocolavacomics[at]gmail[dot]com)')
add('ChopKeemi', 'http://ChopKeemi.webcomic.ws/', u'Chop Keemi A little man in a big city...')
add('ChristianHumberReloaded', 'http://ChristianHumberReloaded.webcomic.ws/', u"Once upon a time, an unpopular kid in a boarding school had his anime taken away and he turned to writing. He created what is simultaneously the worst and the best story ever created. This is that story's comic-book interpretation. You have been warned. Christian Humber Reloaded rips off/steals from every video game and anime ever made. Yes, even that one. It also has Bionicles. And Hitler. And it's supposed to be serious.")
add('Chroniclesofloth', 'http://chroniclesofloth.webcomic.ws/', u'The travels of a female adventurer in a world where her people are hated and her story of gaining friends and saving the world.')
add('ChronoRedux', 'http://ChronoRedux.webcomic.ws/', u'Chrono Redux is a retelling of the classic Chrono Trigger game, except that it makes fun of it. Truthfully, I mock it because I love it.')
add('CityOfDream', 'http://CityOfDream.webcomic.ws/', u'Taking the mixture of Fantasy, Modern and slice of life (with a ton of details on philosophy) is what composes this work. Also the idea is not going for the heroic epic side, for this is made to work with the view of the sidelines not the "hero". You have been warned... Updates Saturday or Sunday')
#add('Clockworkatrium', 'http://clockworkatrium.webcomic.ws/', u'In a misguided attempt to develop their full potential for success, students at a German university are forced to participate in a campus chess "game" in which they are the pieces and the captures could consist of murder. (this is a mirror)')
add('CoftheA', 'http://CoftheA.webcomic.ws/', u'It is a fantasy comic that is loosely about philosophy. It features real pictures and a disturbing amount of software effects to create a drawn feel. Sadly I think it would be less work to just draw it. The main character, Jim Towers" is played by me and represents some sort of mental condition as the majority of the humour in the comic is the character played by me, calling out snarky remarks to me... the author/narrator. Hope you enjoy. Updates are every Friday for now.')
add('Comingapartments', 'http://comingapartments.webcomic.ws/', u'Apartment life is never an adventures. But J.B. and Diri are sure as hell gonna try to make it one.')
add('Compozerz', 'http://compozerz.webcomic.ws/', u'The Compozerz is the story of five classical composers from the 17-1800s, who find themselves whisked suddenly into the 21st century. The Guys have no idea why or how this happened, and to top things off, they find themselves stranded in the middle of the North American Desert. Frightened and confused, The Boys must figure out where they are and find out some answers. They end up stumbling upon a truck stop/diner and meet the free-spirited "hippie" chick, Connie Sanderson, who ends up \'adopting\' the Guys. So here unfolds the tale of Time Traveling Musicians Johannes "Joe" Brahms, Felix Mendelssohn, Frederic "Freddie" Chopin, Wolfgang "Wolfie" Mozart, Ludwig Van Beethoven and of course, Miss Sanderson (who must have some pretty incredible patience). Connie is not-so-loosely based on the author of the comic, by the way.')
add('Conplicated', 'http://Conplicated.webcomic.ws/', u'When sarcastic but charitable Amber Pennicastle follows a handsome panhandler to his secret hideaway, her life turns upside-down in this action/romantic comedy. (Revised and color version of Geode Corner).')
add('Contestedterritory', 'http://contestedterritory.webcomic.ws/', u'What happens when two small girls from either side of the war meet? What happens when they become best friends? Contested Territory is a story about just that; a young Orc named Thook and a rescued Night Elf with no memories named Kithra. Instantly inseparable, the girls face Azeroth together, testing the boundaries of friendship, family and faction as they learn what makes them so similar, yet so different. Raised by loving but cautious Auntie and Uncle, Aguul and Kross, as well as a dear tauren friend, Winthir, Thook and Kithra learn what happens when two enemies meet before they are old enough to understand hatred. This is a fan-based comic set in Azeroth, home of World of Warcraft. This comic was originally written in 2008, with the prologue, and chapters one and two taking place during Vanilla. The comic is done entirely by hand: pencil, pen, colored pencil, and scan. Currently, it uploads regularly on Tuesday mornings and Friday mornings. If you do not play WoW, the main thing that you need to know is the hatred between the two factions: the Horde, made up of Orcs, Tauren, Trolls, Undead and later Blood Elves and Goblins, and the Alliance, comprised of Humans, Dwarves, Night Elves, Gnomes and later Draenei and Worgen. Thank you for viewing and feel free to leave a comment or two!')
add('Copypasteandmrbenjy', 'http://copypasteandmrbenjy.webcomic.ws/', u'Copying and pasting characters with wacky hijinks! HI-LARTY ENSUES!')
#add('Cowtoon', 'http://cowtoon.webcomic.ws/', u'A crazy look into the lives of insane farm animals.')
add('Crawlers', 'http://crawlers.webcomic.ws/', u"Their fate is determined by dice and a set of laws they have become the masters of manipulating. Updated every Tuesday and Thursday at 10AM central time (except during campaign season because I'm running for the Missouri House of Representatives).")
add('Crimsonpixel', 'http://crimsonpixel.webcomic.ws/', u"this is just going to be a series of comics pertaining to things in video games my daily life that i find funny. i'll be updating often (at least once a week), so please enjoy, comment, and share! |m|>.<|m|")
add('Crowbar', 'http://crowbar.webcomic.ws/', u'A curious boy befriends a robot inside an alien pyramid on a distant planet! Together they must solve a puzzling mystery before dark forces overwhelm them.')
add('Crowbars', 'http://Crowbars.webcomic.ws/', u'T-Shirts and other pointless merchandise also available on website.')
add('Cubecows', 'http://cubecows.webcomic.ws/', u'Cube Cows for everyone! Merely shout something out and I, your ever faithful servant, shall warp and twist it into a cube cow. Be it a character, idea, game, object, or even yourself, once put into the cube-cowifier, it shall be done! All suggestions are put on a list, and then selected randomly off of that list. If you or one of your characters are used, you have equal rights, and may use the drawing for personal purposes (eg. Avatar, displaying in webcomic...)')
add('Cupcakegraffiti', 'http://cupcakegraffiti.webcomic.ws/', u'The many adventures of Mr. Cupcake. Shop for Cupcake Graffiti on ETSY!! http://www.etsy.com/shop/sodapopcomics')
#add('DEMENTED', 'http://DEMENTED.webcomic.ws/', u"\u2606 [b]Genre[/b] - LGBT, Horror, Humor, Fantasy, Cross-Dressing \u2606 [b]Rating[/b] - 17+ for Violence, Language, Sexual Content, BDSM and Gore \u2606 [b]Updates[/b] - Every Saturday Karma is a bitch. We're all going to Hell eventually. But what happens if you've taken a visit to it and a certain little someone followed you back on Earth..? CHAOS ensues. Take a ride with Slayne, a killer-for-hire where everyday is the worst day of his life~ Tags: LGBT, Incubus, Demons, Angels, Hell, Heaven, Cute, Chibi, Anime, Sci-Fi")
add('DRouggs', 'http://dRouggs.webcomic.ws/', u'Dark and wierd comic, but sometimes quite funny. [No storyline]')
add('Dailydoodle', 'http://dailydoodle.webcomic.ws/', u'A collection of doodles and drawings')
add('Damnhipsters', 'http://damnhipsters.webcomic.ws/', u"There's some in every generation... those that are so obsessed with being cool they'll do anything to keep ahead of the mainstream no matter how stupid it makes them look. These are their stories.")
add('Dandk', 'http://d-and-k.webcomic.ws/', u'The adventures of a group of friends as they try to live the sex, drugs and rock and roll lifestyle. Nobody said it was going to be easy. Updates every Monday and Wednesday')
add('Datachasers', 'http://Datachasers.webcomic.ws/', u'Data Chasers is set in the distant future, in a world still recovering from an apocalypse. In it, humans and androids live side-by-side and face the hazards of their dangerous environment. Though set far into our future, it reflects our past and our present, dealing with the politics and cultures of different people, along with touching on the very fundamentals of humanity. ( Updates Monday though Friday ) ( discription by Ranger_Brian_New! )')
#add('Ddsr', 'http://ddsr.webcomic.ws/', u'A sprite comic that has no Sonic sprites! Seriously, all custom done. Join two friends and there crazy adventures involving demons, robots, explosions and shiny things.')
add('Dead', 'http://dead.webcomic.ws/', u'"Today a young man on acid realized that all matter is merely energy condensed to a slow vibration, that we are all one consciousness experiencing itself subjectively, there is no such thing as death, life is only a dream, and we are the imagination of ourselves... Here\'s Tom with the Weather!"')
#add('DeadFingers', 'http://DeadFingers.webcomic.ws/', u"Deadfingers is a story about an indigenous girl and her tribe, struggling to salvage its independence from the imperialistic mainland. Features magic, knife fights, guns, robots and everything else you'll find in the alternate universe. To read the entire comic (over 200 pages long and counting) Please visit http://www.drunkduck.com/DeadFingers/. DeadFingers updates with new pages every M T W TH F and S.")
add('Deadducks', 'http://deadducks.webcomic.ws/', u'Danny duck and his two brothers just moved in with their uncle in a small town full of ghost monsters and serial killers')
#add('Demoneater', 'http://Demoneater.webcomic.ws/', u'The grotesque life story of Saturno, a demon that eats other demons to get stronger.')
add('Demonwings', 'http://demonwings.webcomic.ws/', u'')
add('DenizensAttentionComic', 'http://DenizensAttentionComic.webcomic.ws/', u'Alicka and her little brother Winston are sent to Winterkill Boarding School. The number one dumping ground of unwanted troubled teens. A miniature Gormenghast filled with bad seeds and black sheep.')
add('Dictatorship', 'http://dictatorship.webcomic.ws/', u'Meet mr. President and his wacky lackeys who rule the Republic of Syrania with an iron fist.')
add('Dierabbitdie', 'http://dierabbitdie.webcomic.ws/', u'Born in the backwoods of Oklahoma, Daisy Dew Mummolo lived a life of mystery her first few years. She was found in an abandoned house and spent some time at a rescue before Burt responded to her get-rich-quick scheme on Craigslist. She felt pity for him after cleaning out his bank account and decided to move in with him to console his constant spats of crying. Soon, they became friends, and Daisy allowed Burt to chronicle her daily life in exchange for baked chicken dinners, trips to the dog park, and custom made collars. Daisy loves children, tolerates adults, and absolutely hates rabbits. It\'s in her blood. Since the 1500\'s her breed has been raised to find rabbits. Unfortunately, Daisy has somehow twisted this tracking talent into a personal vendetta. She earnestly feels that rabbits are evil and must be hunted down and destroyed. As such, many in the rabbit community have taken exception to this attitude. Several restraining orders have been taken out against Daisy, but she simply chews them up the moment they\'re served. Each morning, she awakes with a smile on her face, a spring in her step, and a singular phrase in her mind, "Die Rabbit, Die!"')
add('Disturbingcomics', 'http://Disturbingcomics.webcomic.ws/', u'Dark dumb luck hero finds super female.')
add('Divebombingkamikazekitties', 'http://divebombingkamikazekitties.webcomic.ws/', u'The strip follows the antics of three kitties (Pagoda, Origami, and Tofu) as they torment their humans and the general public.')
add('Docapoc', 'http://docapoc.webcomic.ws/', u'A useful* resource for surviving** and thriving during*** the end of life as we know it at the "hands"**** of zombies, aliens, robots, boredom, plague, asteroids, the weather, ninjas, clowns, [redacted by National Security], war, global warming, giant creatures from the deep or vampire enslavement. *No "actual" usefulness, either real or implied, is guaranteed. **No "actual" survival, either real or implied, is guaranteed. ***No "actual" thriving, either real or implied, is guaranteed. ****Many forms of apocalyptic doom do not have hands.')
add('Doffeellende', 'http://doffeellende.webcomic.ws/', u'')
add('Doublejump', 'http://doublejump.webcomic.ws/', u'Every day, I have a free half hour, and what better way to spend it than to sketch up some Videogame Comics super-quick for you guys?')
add('Dragoncity', 'http://dragoncity.webcomic.ws/', u'Millions of years ago, a comet wiped out the dinosaurs, but the dragons who were living along side them went underground and stayed there. And now we see the civilization that has come about from those refuges in a current day story.')
#add('Dragonet', 'http://dragonet.webcomic.ws/', u'A wizard tries to raise an orphaned dragon in an age of war, evil, and magic. He soon finds out a dragon does whatever it wants...and he may make all the difference.')
add('Drettaville', 'http://drettaville.webcomic.ws/', u"Rook's life is thrown into chaos when he's suddenly put in charge of raising a seven-year-old daughter he never knew he had. A daily family-friendly comic strip!")
add('Drifting', 'http://Drifting.webcomic.ws/', u'A story of a Young "Drifter" named Venture and the mysteries of Auncen and Novossa.')
add('DuelingHeroes', 'http://DuelingHeroes.webcomic.ws/', u'Cetacion City is in dire straits- the darkness surrounding it going beyond the natural pale. Something is wrong with the city- but two heroes have risen to fight back the darkness- if they can get past each other.')
#add('Dungeonhordes', 'http://dungeonhordes.webcomic.ws/', u'In 1986 Dungeon Hordes was released on the Playtendo and moved 1 million units world wide which is way more successful than its previous release on the Batari 2200 in 1979. Now in 2011 Dungeon Hordes has returned bigger and better than ever with mind numbing graphics and all new enemies to fight. So how do the characters in game feel about this? Only time will tell. Enter the lives of Tiggz and Tomes, two level 5 bosses tired of being easily killed by player 1 and wanting the glory of finally becoming more than just petty bandits. Will they survive the new creatures that the mighty programmers have added to the game? Will they ever kill player 1 and move up the mob boss ladder? Will they ever get a raise from their uptight dungeon boss Kalakis and finally pay off their ale tabs at the Stinky Dragon Inn? Stay tuned and find out..... Will be updated Every Day!')
add('EMT', 'http://eMT.webcomic.ws/', u"an experiment in Mental Theatre, externalized in comic form. Currently Featuring: MAD SCIENCE! with Dr. Nick - steampunk fantasy adventure into the strange! Now updating 3 times weekly, every M-W-F. [i]It doesn't serve the 3 fetish as well as every 3rd day on dates divisible by 3 did, but you get more story for your money - with 3 more strips every month![/i]")
add('Eclipselegend', 'http://eclipselegend.webcomic.ws/', u'A story of war, legends, aliens, explosions and more. A tale of superheroes and villains; of space battles, mad scientists, shadowy plots and dark pasts. This is Eclipse Legend.')
#add('Educomix', 'http://educomix.webcomic.ws/', u'A parody educational comic about a young man called Dave and his crazy adventures. "Good. I\'ll make toast."')
add('Elektroanthology', 'http://elektroanthology.webcomic.ws/', u'These are various unrelated comics I have worked on. Everything\'s tagged just in case. They\'re mostly short stories I\'ve done for different anthologies (Copyright also for "Various" because some of these I worked on with someone else as well). Updates whenever.')
#add('Equsopia', 'http://equsopia.webcomic.ws/', u'Because of black magic, a king and his loyal knight were sent to another world. Now they must find their way home.')
add('EternityC', 'http://EternityC.webcomic.ws/', u'When a compulsion is so strong that it runs your life, you have a complex. When that complex centers around Eternity, you have an adventure. Join Fae as she searches for Eternity and all that it might bring her.')
add('Everydayabnormal', 'http://everydayabnormal.webcomic.ws/', u"When supernatural, technological, or mythic threats endanger human lives, only the Agency of the Unnatural can rise up to stop them -- but it's the ordinary people who are caught in the crossfire. Jon Grasseschi's ongoing saga explores how people react, live, and just survive when the unexplainable, the impossible, and the just plain weird intrude on their lives.")
add('Fairydust', 'http://fairydust.webcomic.ws/', u"A world where fantasy creatures are real ought to feel a little complicated. Should you want to visit it, start with the cities, they're full of humans and modern comfort, if you don't mind having a leprechaun for neighbour or a troll driver. But you're not a racist, right?")
add('Fathead', 'http://fathead.webcomic.ws/', u'A comic about wacky adventures, talking fruit and pointless conversations!')
add('FireBorn2', 'http://FireBorn2.webcomic.ws/', u'The King of the Dead, The Lord of the Shadows, and the Devourer of Souls are amassing their armies to take revenge against the world and the gods that have shunned them. Men and women from different walks of life will join forces to fight them.')
add('Flickwit', 'http://flickwit.webcomic.ws/', u"What's to know? A ragtag bunch of adventurers are embroiled in an Illithid's nefarious plot, and have to fight their way through hordes of monsters, escape the dungeon and save the local peasantry before the lot of them get vaporised in a dimensional cataclysm. You know-- the usual fare. Thrills, spills and fun for the whole family! Warning: Art quality varies wildly.")
add('Foxtales', 'http://Foxtales.webcomic.ws/', u'A manga based on faerie folklore. After encountering a man who can change into a fox, a girl finds herself mixed up in a world of faeries and mythical creatures.')
add('Fpk', 'http://fpk.webcomic.ws/', u'Imagine those badly-photocopied zines that were left on the tables at your local coffee shop got a shave and a haircut, finished their fine arts degrees, and turned out to have really odd Monty Python-esque senses of humor. Then they got married and had a kid. That kid is FPK.')
add('Fraternit', 'http://fraterni-t.webcomic.ws/', u"A comic strip about life, love, long-lost brothers, and everything else a high school girl has to deal with! THIS COMIC STRIP IS SEMI-AUTOBIOGRAPHICAL, WHICH MEANS MOST OF IT IS BASED ON THE IMAGINATION OF THE AUTHOR. ANY CHARACTERS THAT MAY BE BASED ON REAL PEOPLE HAVE HAD THEIR NAMES CHANGED. Special thanks to Jimmy Gownley, author of Amelia Rules! and cofounder of Kids Love Comics. Also, thanks to Bill Wahl, Nikki, my parents and friends. I couldn't have done it without you!")
add('Friendshipisdragons', 'http://friendshipisdragons.webcomic.ws/', u"A screencap comic of My Little Pony: Friendship is Magic. Equestria is a custom campaign setting for Dungeons and Dragons, and the mane six are Player Characters. How will a party of six roleplayers fare in a world where the usual hack-'n'-slash high fantasy has been replaced by pastel-colored ponies?")
add('Frontier2170', 'http://frontier2170.webcomic.ws/', u"Life as an independent spaceship crew isn't easy. In addition to the astronomical cost of fuel, supplies and repairs, it seems like the big corporate outfits get all the well-paying jobs, leaving the petty runs they don't want to people like you. Those jobs don't pay well enough to make ends meet, and there never seem to be enough of them, so sometimes you have to break the law to put fuel in the tanks and food on the table. If that wasn't bad enough, there's a war going on, and that means cargo inspections and surveillance...")
add('Fullmetalbrothers', 'http://fullmetalbrothers.webcomic.ws/', u'')
#add('Fusion', 'http://fusion.webcomic.ws/', u"What's inside the pages of this little book isn't so much a comic as it is a viewport into another dimension where you can follow Savunn's hectic life as a Cambodian teen (and superhero fan-gal) as she tries her best to make her mark as her world's newest superhero, Fusion! As reader, you will serve as her confidant as you watch the reality show of her life unfold with each turn of the page.")
add('Fuzzballandscuzzball', 'http://fuzzballandscuzzball.webcomic.ws/', u'Fuzzball and Scuzzball are brothers who live in the gritty urban hell that is Happy City, New Jersey. In theory, they are private investigators. They have wacky misadventures.')
add('Galbertofbruges', 'http://galbertofbruges.webcomic.ws/', u'A comic based on the book "The Murder of Charles the Good, Count of Flanders"')
add('Ganold', 'http://ganold.webcomic.ws/', u'Sci-fi, but with some fantasy. Current era in the stories is somewhat Steampunk.')
add('Gillimurphy', 'http://gillimurphy.webcomic.ws/', u"Gillimurphy Stories - A turn-of-the-century multi-storied apartment building, nestled in the city of Lockdale. Revel in its charm, discover its secrets, and meet its unwittingly affable occupants. (If you're enjoying this strip, take a gander at the original GS series which predates the current edition, found here: http://gillimurphy-orig.thecomicseries.com/)")
add('Glomshire', 'http://Glomshire.webcomic.ws/', u"The misadventures of the inhabitants of Glomshire, a medieval(ish)land of undetermined origin. LEGO\xae is a trademark of the LEGO Group, which does not sponsor, authorize or endorse this comic (and we don't blame them!)")
add('Godhatesdads', 'http://godhatesdads.webcomic.ws/', u'my journal comic or something. showing the good times and the bad times of being a weirdo in my mid 20s.')
add('GodsAlmighty', 'http://GodsAlmighty.webcomic.ws/', u'A comic that chronicles the strange events and imaginary happenings surrounding Bethany. Accompanying her in her day-to-day life and occasional flights of fantasy are the two Norse Gods, Freyr and Loki. If you like rainbows, sparkly things, the occasional narwhal, cookies, cakes and sexual innuendo (inYOURendo) Then by Odin, this is the comic for you. GOD DAMN I LOVE CHICKEN.')
add('Goldrushdynllewcomics', 'http://goldrush-dynllewcomics.webcomic.ws/', u"Short weekly strips about the adventures of Alistair and Sam as they try to get rich quick from War-time relics buried around the Forest of Dean. There's gunna be blood, sweat and a bit of sex. Just for the mature factor! Requests on story will now be accepted! Written and artwork by Alex 'Dyn Llew' Thomas.")
add('Grandline3point5', 'http://grandline3point5.webcomic.ws/', u"So... yeah. Some time ago, I went on an archive binge on Darths & Droids. If you know what I'm talkin about, then you probably know what's coming up. I decided to give it a shot and here's what I came up with: One Piece if it were a roleplaying campaign. :p")
add('GreenEyes', 'http://GreenEyes.webcomic.ws/', u'One page comics on the simple things in life.')
add('GreenerGrass', 'http://GreenerGrass.webcomic.ws/', u'This is the story of three strangers (and their pets), who for unknown reasons get dragged into a different dimension, named by them as the Grass-Green-Land. Whatever will await them there? Warning: This comic involves a lot of swearing. Updates whenever I have the time for it.')
add('GrippsBrain', 'http://GrippsBrain.webcomic.ws/', u'These are People and Critters I have butted heads with, and are mostly single pages. (HOW do some toonists do all that Drawing and Writing? With you know Conversations and PLOTS?) PS: Please also look at the archives, moving earlier stuff over there.')
add('HIRI', 'http://HIRI.webcomic.ws/', u"Autobiographical comic that's at least 80% true")
add('Halloween2012', 'http://halloween2012.webcomic.ws/', u'This is the Webcomic Hub for the multi-webcomic event known as The Halloween Cameo Caper 2012. The strips will be posted here as they appear on the main sites by the various authors participating in the event, however, here a sense of continuity will hopefully appear as the strips are being rearranged along the way.')
add('Hazardswake', 'http://hazardswake.webcomic.ws/', u"A fantasy webcomic in an J-RPG-like world. The fates of many characters intertwine as their quests converge in a setting that's inspired by old console RPGs and is more than a little silly.")
add('Heavylittlepeople', 'http://heavylittlepeople.webcomic.ws/', u'A (mostly) daily snapshot of the lives of these odd Heavy Little People')
add('Hellowanderingstar', 'http://hello-wandering-star.webcomic.ws/', u'Muse is a superhero in a world without superheroes. Things ensue!')
add('Hero', 'http://hero.webcomic.ws/', u'The suprisingly funny exploits of three friends who fight crime any way they can.')
add('HitmanPiranha', 'http://HitmanPiranha.webcomic.ws/', u'')
add('Hodgemosh', 'http://hodgemosh.webcomic.ws/', u"It's just kind of stuff. And then there's other stuff, and that's pretty much how it goes.")
#add('Holon', 'http://holon.webcomic.ws/', u'In 3013, mankind has been driven to the edge of extinction in an intergalactic war. The lifeline of their endangered civilization are HOLONs, space stations established to harvest omnipotent and extremely destructive particles...')
add('Holybibble', 'http://holy-bibble.webcomic.ws/', u'From out of the ashes.')
add('Honeyvenom', 'http://honeyvenom.webcomic.ws/', u'Honey Venom, the sweetest poison, the daughter of darkness. Honey is an adventurer with an obscure past. She is an assassin and a witch. This comic is about her adventures in mysterious lands, about her loves and her fights against revenants, vampires, evil priests, corrupted zealots, depraved ogres and other revolting villains. Feel you free to contact me at my email address: I like to talk about my comics and to make friends with those who read my works, as well with other comic makers.')
add('Housepets1x', 'http://housepets1x.webcomic.ws/', u'A new weird family approach! Primo is a talented actor, Spike is an avenger. Together they form the most caotic and crazy squad ever! Updates on Monday, Wednesday and Friday')
add('HumanCookies', 'http://HumanCookies.webcomic.ws/', u"My toys get bored when I leave the room, so they come to life and make these comics. Sometimes they do things that cause worldwide issues, sometimes they burn the toast, it's all just a roll of the dice with them! Watch this cast of now just over a 1000 characters do their stuff!")
add('Idget', 'http://idget.webcomic.ws/', u'No description necessary! Usually.')
add('Ignitionzero', 'http://ignitionzero.webcomic.ws/', u"Four years ago, Robbie Finch met his best friend on the Internet. Now he's off to college in that very friend's home town--well, city. Big city. Orson and his friends are exactly the kind of people Robbie wants to meet: punks, hipsters, queers, and artists like himself. It's their exploits that push him headfirst into a new kind of reality, one where the Fair Folk and humanity meet. The city of Glory is full of well-kept secrets, but they might just unravel them all.")
add('Insanitycorp', 'http://insanitycorp.webcomic.ws/', u'[[ ENDED ]] The new and improved--yet still not corporate--Insanity Corp is back with more panels and fewer sticks! :D [Reality not included, offer not available in the Neptunian quadrant, see inside for details.]')
add('Isb', 'http://isb.webcomic.ws/', u"Internet Superbuddies is an experiment in chaos theory, pixels, and utter fucking boredom. It features five protagonists who basically swear and hate each other and are in some kind of bizarre and unclear living situation, to where they also break the fourth wall and realize they're part of a grander machination of being in an experiment in chaos theory, pixels, and utter fucking boredom. It used to be based on real life. Then people started getting killed and orcs with intent to rape started showing up. Then things got wacky.")
add('Isonacia', 'http://Isonacia.webcomic.ws/', u'On a series of hidden islands in the pacific, science has evolved well beyond the modern world. Now a select few are being introduced to the strange land of Isonacia')
add('Its', 'http://its.webcomic.ws/', u'The year is 2180. Immortality is now a commonly-available genetic modification, but complete unkillability has yet to be achieved... Or so the universe thinks. A single batch of military-grade prototype GELFs (Genetically Engineered Life Forms) has exhibited this ability, but at the cost of being rendered mentally unfit for military life. Cooped up for a year, the GELFs manage to escape from the facility that made them. Being a terrible pilot, one GELF, codenamed "Yellow", crash-lands its escape craft on the swamp planet of Bloogis V. After getting stuck in the swamp, Yellow is rescued by two employees from a refueling station orbiting Bloogis. With no ship, no money, and nowhere to turn, Yellow makes up a new name and a gender for itself, re-dyes its fur, and asks for a job on board the station. A couple weeks later, and Yellow, now known as Chaz, is already getting the hang of his job, mixing drinks, talking with customers, the works. What kinds of weird and wonderful customers will he meet while working at the Intergalactic Truckstop? (The comic doesn\'t have a lot of mature language, but there\'s a swear here and there so I figured I\'d play it safe!)')
add('Itscomplicated', 'http://itscomplicated.webcomic.ws/', u'The exploits of a city girl as she gets through her late teenage years')
add('Jakebone', 'http://jakebone.webcomic.ws/', u"Agent Jake Bone, Whatever-oh Zeta, of Her Majesty's Foreign UK Intelligence secret service. Drunk on vodka and his own self-worth, utterly convinced of a conservative British male's uncontested superiority over all others. Racist, narcissistic, sexist, and just generally rude, Jake Bone is a true hero for our times. Yes, this is yet another James Bond parody in a world over-crowded with the things. The difference: thoroughness! As much as feasible, this is an UNABRIDGED parody, doing EVERY official film in-depth and unexpurgated. All done Airplane!-style. Enjoy.")
add('Jamiejupiter', 'http://jamiejupiter.webcomic.ws/', u'Jamie Jupiter is a member of the Galactic Squadron-a team of intergalactic "space cops" who help protect the galaxy. After tracking a villain to Earth, she saves the lives of two teenagers and shares her secret with them. She now vows to use her cosmic superpowers to protect her new friends and her new home, while learning what planet Earth is all about. Monsters of all shapes and sizes threaten our way of life, but with a brave and determined alien; a deadpan snarker photographer, and her comic book-loving geeky boyfriend, no task is simple, and every day is an adventure.')
add('JaysInternetFightClub', 'http://JaysInternetFightClub.webcomic.ws/', u"A Bus Driver starts a female fight club in his basement, with his wife, and his wife's girl pals. They broadcast the fights over the internet, and sell the dvds of the matches.The cast goes through adventures outside of the club as well.")
add('Jenfferscartoonphotomanipulaion', 'http://jenfferscartoonphotomanipulaion.webcomic.ws/', u"where old , unanted lost photos gets a new life as a cartoon pin up for the cast of jenffer's show")
add('Jenffersshow', 'http://jenffersshow.webcomic.ws/', u'Welcome to New Wolf Creek in Yukon Canada. The new home of "Miss J and the AM." This strip is about Miss J and her rock band called "Miss J and the AM" and their life in New Wolf Creek. See, Miss J is a lesbian and just married Jenffer Jay, her friend . And that\'s only the start. Please note: There is some frontal nudity now')
#add('Jericho', 'http://Jericho.webcomic.ws/', u"Jerry, a young women with depression and self esteem issues has had a rough time growing up, and all seems to be going well while she is at Bournemouth University studying Medical Science. However, after putting her fellow students health at risk while testing her new ultra sound glove in an attempt to find an alternative treatment for cancer patients, she is threatened with expulsion. Her tutor, Doctor Foster is soon to be threatened with similar actions after he is accused of having an intimate relation with one of his students. But Jerry's world is pushed to it's limits when her best friend Carl is diagnosed with an inoperable and very aggressive brain tumour. On top of all this, the media is constantly running a story about a serial killer who targets terminally ill patients. The odds are against Jerry, and she has to make a choice. Does she become the bad guy in order to save her friends life? Will she be able to help him before the killer strikes? And what has Doctor Foster done with her invention? 'Jericho' is due for release as a published/printed comic later this year, and this is your chance to read it first! Rather than going out and finding a test audience, we decided that the best test audience is the readers of Comicfury.com! Please rate and comment so that you can help us make a better comic reading experience for you! Thank you! Jericho is registered with the UK Copyright service. Registration No. 324507")
#add('Jix', 'http://Jix.webcomic.ws/', u'An alien sent to survey Earth for conquering crash lands on Earth and an alternate personality takes over and moves in with a 20-something year old woman. These are their stories. BOM BOM!')
add('Judgedred', 'http://judgedred.webcomic.ws/', u"A Modern Day Re-Imaging of A Syndicated Comic Strip You've Likely never heard of before. All Original artwork by Alex Graham/Michael Martin.")
add('Jump2', 'http://Jump2.webcomic.ws/', u'A demon possessed killer gets a glimpse of what life could be like free from his Master...but freedom, like all things in life, is difficult to attain and even more difficult to maintain. (This is the remake of the original.)')
add('JustPeachy', 'http://JustPeachy.webcomic.ws/', u'"Just Peachy" is a cheeky serial comic strip featuring a small college town\'s generation of college alums who aren\'t giving up and growing old without a fight. Kids: don\'t let your parents fool you, this is exactly how they behave when they think you\'re not looking. Parents: don\'t try to act all dignified and deny it. Liar, liar, pants on fire. In fact, you\'re probably worse than this.')
add('Kayandp', 'http://kayandp.webcomic.ws/', u"Kay is a college student who's passions are music and the arts, which probably makes her wacky enough... but also there is her best friend - a skeleton no one else can see, named P.")
add('Keepingthepeace', 'http://keepingthepeace.webcomic.ws/', u"Four universes are combined into one. Three exist as a fictional franchise in another universe far away. Mortals from there are hired to reincarnate into the four worlds to use their knowledge, acquired power, and training undergone to keep the peace between these three worlds they knew of in their first life. Now a new recruit has been hired to manage all three of them and she's not sure if she can handle it. And what about that fourth world?")
add('Kevinzombie', 'http://kevinzombie.webcomic.ws/', u'')
add('Kirahitogame', 'http://kirahitogame.webcomic.ws/', u"A simple game that started with Kira and mine OC's. Every even page is mine, and every odd is hers.")
add('Knavesend', 'http://knavesend.webcomic.ws/', u"Knave's End is a port town in a fantasy world, peopled by humans, orcs, elves, dwarves, halflings, and some odd types of goblins. It's a center of political and criminal intrigue where the criminals are nasty and some of the guards are even worse.")
add('LORDDARKE', 'http://LORDDARKE.webcomic.ws/', u'The adventures of a middle aged black widow spider and her friends. UPDATED MONDAY AND THURSDAY.')
add('Laceyinvestigations', 'http://lacey-investigations.webcomic.ws/', u'Online Detective comic')
add('Laserbrigade', 'http://laserbrigade.webcomic.ws/', u'An experimental comic about cyborgs, robots, and aliens. With lasers!')
add('Lastcallcomic', 'http://lastcallcomic.webcomic.ws/', u'Last Call, a Slice-of-life and Humor webcomic, focuses on a woman in her thirties, the antics of her husband and friends, and her conversations with her best friend at a local bar, who happens to be an alcoholic succubus.')
#add('Latchkey', 'http://latchkey.webcomic.ws/', u"Latchkey is a daily comic strip, and takes its cue from strips such as The Perishers, Calvin and Hobbes, and Peanuts. It's about a group of eccentric and vaguely defective kids who spend most of their time together.")
add('Lauras24hourcomics', 'http://lauras24hourcomics.webcomic.ws/', u'Stuff that Laura\'s drawn for 24 Hour comic events. At such an event you usually try and draw 24 pages of comics in 24 hours. The two main events entered are "The Comikaze Challenge" in June of each year, and "24 Hour Comic Day" in October of each year. It changes, but recently I\'ve always drawn via the computer for the former, and by hand for the latter. This also includes comics drawn as a substitute for an entry (such as "Floods and Storms") and to complete the storyline of an unfinished entry (like "Part Three"). I usually try and draw one page a day for those.')
add('Lavenderlegend', 'http://lavenderlegend.webcomic.ws/', u'Princess Lavender is banished from the sight of all men, but one of her servants has a dangerous secret. Well, more than one.')
#add('Lena', 'http://lena.webcomic.ws/', u'The story of a girl and her interdimensional "friend".')
add('Lethargicmisanthropy', 'http://lethargicmisanthropy.webcomic.ws/', u'Please, do not get depressed after reading this comic. That is my job.')
add('Lifeexplained', 'http://lifeexplained.webcomic.ws/', u'What started as a humorous attempt to participate in "Everyone Draw Mohammed" day resulted in a weekly comic in which things are observed.')
add('Lightbulbs', 'http://lightbulbs.webcomic.ws/', u"A wizard from the 10th century is summoned into the 22nd century to act as a teacher. Sadly the wizard can barely conjure magic thanks to a total global lack of other wizards. To restore magic to the world first the world must be restored it's self.")
add('Lilheroartists', 'http://lilheroartists.webcomic.ws/', u'')
add('Lint', 'http://lint.webcomic.ws/', u'')
add('Littleblackdress', 'http://little-black-dress.webcomic.ws/', u'They say a "little black dress" will get you anywhere. Dress it up\' dress it down. This one is very special. It will do a lot for you, even if it\'s not always exactly what you wanted.')
add('Littlejacquie', 'http://littlejacquie.webcomic.ws/', u'Life as seen through the eyes of Little Jacquie')
#add('Littleredrobo', 'http://littleredrobo.webcomic.ws/', u'A little robot tries to make her way in the future.')
add('Lola2', 'http://Lola2.webcomic.ws/', u'Lola is the story of a sad, sad 13 (now 14) year old girl, who lives with her eccentric grandmother. After just entering junior high school, Lola begins to make new friends and go about life like every other normal kid...of course "normal" is relative.')
add('Longhike', 'http://Longhike.webcomic.ws/', u'Seven people, one dog, one long hike. By Isaac Glovinsky')
add('Lookstraightahead', 'http://lookstraightahead.webcomic.ws/', u"One teen boy's journey through depression and mental illness.")
add('Lp', 'http://lp.webcomic.ws/', u"It's a manga about a college student gets drafted into the Spiritual War for souls as a Prophetess of God. She battles demons, devils,and still manages to make it to class on time. Has action, adventure, and shoujo humor with a Christian theme.")
add('LunaStar', 'http://LunaStar.webcomic.ws/', u'Sister comic to Datachasers. covering events that occured in the past...Updates are "scheduled" for tues and thur... maybe the occasional bonus :D')
add('Maddog', 'http://maddog.webcomic.ws/', u"Mad Dog and Spot are just a couple of cool cats, even though they're dogs. When ever they get together fate always serves them a side dish of adventure with a cup of heart and just a pinch of high fives! Follow along as they encounter mad scientists, alternate dimensions, evil sandwiches and who knows what else! Mad Dog! Every Saturday at 8 o'clock - 7 central! (Or whenever you feel like reading it)")
#add('Magisa', 'http://mag-isa.webcomic.ws/', u'A comic about a loner, an angel, and a psycho cult that shoots up a school.')
#add('Mascara', 'http://Mascara.webcomic.ws/', u"Addison Walker is a girl with natural style. She doesn't even wear makeup because she feels that brains are more important than looks. In fact, one of her closest friends is the smartest boy in school. But she has no clue that he has a strange alter ego\u2014as a makeup artist. When they meet, will it be a makeover disaster?")
add('Mayonakadensha', 'http://mayonakadensha.webcomic.ws/', u'Hatsune Rondo a Japanese-British teenager, living in Japan of 2010, disenchanted by her uneventful life and neglecting mother. But when Hatsune accidentally misses the last train home and boards a mysterious train that arrives on the dot of midnight she finds herself whisked back to London of 1888. Here she meets an orphan named Tom, who reveals to her that he is a member of the Baker Street Irregulars, a group of street urchins hired to assist Sherlock Holmes where needed in his investigations. Hatsune joins Tom and his friends in the Irregulars to tackle the many criminals that London houses. But one criminal in particular has Hatsune and the whole of London in a stranglehold of terror. Jack the Ripper. Contains some moderate gore and blood, a few uses of strong language, non-explicit nudity and some mild sexual scenes Updates a volume (70-90 pages) a month.')
add('Melancholygoround', 'http://melancholygoround.webcomic.ws/', u'Welcome to the Academy! Enjoy life, study hard, avoid getting killed...')
add('Merelymortal', 'http://merelymortal.webcomic.ws/', u'A comic about life, death, and futility. Currently on indefinite hiatus. =(')
add('MichellesUniverseScrapbook', 'http://MichellesUniverseScrapbook.webcomic.ws/', u'Before the Michelle LaFemme in "Pop Culture\'s Kids", the character starred in a few other stories that were condensed and expanded upon in a (currently unpublished) graphic novel called "Michelle\'s Universe". This Michelle was born in 1962, and the novel is her biography. This webcomic is made up of additional material to that story, told in the form of comic strips, comic book pages, editorial cartoons, illustrations, etc.')
add('Mildlyamusing', 'http://mildlyamusing.webcomic.ws/', u'A comic about life, happiness, and flights of fantasy.')
add('Minarga', 'http://minarga.webcomic.ws/', u"My longer-than-ever-anticipated Mass Effect fancomic, originally posted on deviantART, also available here. At the present time, I'm still working on the script, and will be posting first drafts of every chapter as I sketch them out. Finished pages will come when I've written the entire script and have layouts/rough drafts of all the pages. Again, just to cover all my bases, I do not own the Mass Effect universe; it's the creation of Bioware, and they own all the rights. I don't own a damn thing. More of my art is viewable at http://amethystsadachbia.deviantart.com/")
add('Mirroredconversations', 'http://mirroredconversations.webcomic.ws/', u"There are things in life that often don't make sense. This comic highlights them.")
add('MoaK', 'http://MoaK.webcomic.ws/', u"Morgan was not having a good day. Her singer flounced; her basist, and brother, got a better offer; her drummer was blown up by a dragon-- Wait, what's a dragon doing in Chicago? And what's with the orcs with guns? Updates Tuesdays and Fridays, 3pm Chicago time (Currently a mirror from Drunk Duck. You can read it here, about a chapter behind, but with no delays for Writer's block and computer issues, or there for the current story, but with the occasional filler page/missed updates.)")
add('MoizmadComix', 'http://MoizmadComix.webcomic.ws/', u"Crack detective Riddick Q. Loss' never-ending quest to catch the villainous Sir Dimswitch in 1950's Vancouver.")
add('Monstersoup', 'http://monstersoup.webcomic.ws/', u'A group of misfit monsters are sentenced to live under the same roof--a castle belonging to mad scientist, who is serving his own sentence for unethical experiments. The real question is, can a hodgepodge group of monsters live under the same roof? (Some comedy, horror, and a little bit of everything else.)')
add('Morningsquirtz', 'http://Morningsquirtz.webcomic.ws/', u'A filthy Taffy swirl of gooey pun drenched fun.')
add('Moths', 'http://moths.webcomic.ws/', u'In an alternate American past, Aram and his family must cope with the tightening grip of cynical political forces, while trying to understand the threat of the mysterious giant moths.')
add('Mushroomgo', 'http://mushroomgo.webcomic.ws/', u'Go is a Toad that wakes up in a desert, and is picked up by sand pirates. Describing the rest of the plot would take too long. Basically, a drawn Super Mario comic with original characters, disconnected from any particular game.')
add('Namcowars', 'http://namcowars.webcomic.ws/', u'A battle of non-epic proportions! Andore has assembled five classic Namco armies to fight in a competition to prove which is the most powerful! Updates Tue/Thu/Sat.')
#add('Negligence', 'http://negligence.webcomic.ws/', u'Drannik and Lizzep are two kids who are not very well supervised. This leads them into some very crazy adventures. They and the people they meet also deal with their own personal demons along the way. Updated Mondays, Wednesdays, and Fridays (concluded)')
add('Neighborscomic', 'http://neighborscomic.webcomic.ws/', u'it revolves around three characters, each one representing the three great countries of north america. george (a bald eagle)represents the usa, paco(a golden eagle)represents mexico and nashie(a beaver)represents canada. together they will have many adventures.')
add('NewAmerica', 'http://NewAmerica.webcomic.ws/', u"The story of a dysfunctional family, the crumbling nation they've come to control, and the tragic events that gave them power.")
add('NoSongs', 'http://NoSongs.webcomic.ws/', u'Neil Gaiman meets H.P. Lovecraft meets The Bold And The Beautiful! Join Hector, our undead hero, as he attempts to make some sense out his recent death and resurrection. Magic, mystery and mayhem! Updates Sat-Sun.')
add('Nojetpack', 'http://nojetpack.webcomic.ws/', u"My Life Without A Jetpack is a biographical webcomic about MaGnUs' life, written by him, with art by Taibox (and sometimes colored by Mindy Lopkin). Published weekly in English and Spanish.")
add('Nostalgiaofeden', 'http://nostalgiaofeden.webcomic.ws/', u'The future. A colonized planet, Neo-Earth, is our new home. But all would not be well. Our sins have manifested into a being of such pure avarice, pure evil, and of such great size. And it is now heading to the world where its many creators dwells, to consume all of the Universe... Humans have the capacity to fight back, however. To resist. Across the globe, select humans of extraordinary traits will rise and face this threat to our world. From the strangest to the strongest, from the silliest to the serious, everyone\'s struggles become One. The battle for the fate of Creation itself begins! "Sir, put down the microphone." (Occasional Updates)')
add('Notsinceyou', 'http://notsinceyou.webcomic.ws/', u"Your Mirror is an indie rock band in crisis. Zoe, the band leader, isn't sure about her year-old relationship with the band's guitarist, Jenny. Jenny isn't sure if she loves Zoe, but she knows she loves playing in the band. And then tensions rise when the band's tour lands in the backyard of Zoe's high school boyfriend, Rex. Will the band survive one more concert, let alone the rest of the tour? NOT SINCE YOU is a photo webcomic written by Daniel Barlow and Keith Moriarty and starring Vermont's most exciting cartoonists. About the authors: - Daniel Barlow is the co-founder (with Colin Tedford) of the Trees & Hills comic group, a social cartooning organization in New England. With Trees & Hills, Barlow has co-published dozens of comics, including the anthologies SEEDS, SHELTER and WOODS. Barlow lives in Vermont, works in politics and photographs cemeteries. www.danielbarlow.com - Keith Moriarty is a musician and writer living in New Hampshire. That's all you need to know.")
add('Ocarinaoftim', 'http://ocarinaoftim.webcomic.ws/', u"Welcome to our world! It's strange, but a lot of fun! This reads right to left, in traditional manga style. We should warn you: if you are looking for a serious adventure..you may want to pick something else to read. Also...there is a bit of language. Not a lot of harsh language, but it is there.")
add('OldHumanCookies', 'http://OldHumanCookies.webcomic.ws/', u"These are the older comics in my Human Cookies series. I've been asked by a few people to upload them, so here they are (well once they're all up anyway) I know some of them look bad, the focuses are terrible, the lighting is...well...yuck, but this is where I started, so they bring back some smiley memories for me, so enjoy the tackiness!")
add('Organizedmess', 'http://organizedmess.webcomic.ws/', u"Organized Mess documents the everyday lives of 4 oddly familiar characters. Sometime's it's humorous...most of the time it's not.")
add('Outferasmoke', 'http://outferasmoke.webcomic.ws/', u'The long and rambling story of Joss, a snarky young woman, her confused and abused buddy Lee and their perky housemate, Carrie. Contains drug use, sex, mild violence, profanity and, occasionally, boobies. Updates Sundays and Thursdays.')
add('Outletting', 'http://outletting.webcomic.ws/', u"OutLetting is the first webcomic of Feeny, a professional writing student at York University. starting out as random peeks into Feeny's mind and everyday life as she percieves it, the webcomic has much potential. Names have been changed for the protection of prudey and privacy-loving friends.")
#add('Pandemonium', 'http://Pandemonium.webcomic.ws/', u'The random spewage of my mind')
add('Paperstreamer', 'http://paperstreamer.webcomic.ws/', u'A science fiction web comic loosely based on ongoing research and speculation regarding space elevators and alternative space launch methods. The story and images are composed in pulp fiction and noir styles, with some use of 3D models, but with informative sections regarding the related technologies and concepts. The author and artist is an active reader of related technical research papers and hopes to entertain the audience while learning about the space elevator and its related physics concepts.')
add('ParaFrenic', 'http://ParaFrenic.webcomic.ws/', u'ParaFrenic is an 18 year old half-man/half monster who holds down a daytime job as a video comic actor and spends the rest of his days trying to survive the tough avenues of Vagrant Street.')
add('Parmeshen', 'http://parmeshen.webcomic.ws/', u"A story of gypsies, rovers and ramblers, of secrets and stories so old they're in the blood and bone of the people who tell them. This is a tale as wild as the wind and the roads. Come, and learn where it leads.")
add('Peepsnperks', 'http://peepsnperks.webcomic.ws/', u"A Trio of friends decide to combine their two favorite things - sex and coffee. who doesn't love sex and coffee?! NSFW, unless you work in porn, in which case, call me!")
#add('Pegwarmers', 'http://Pegwarmers.webcomic.ws/', u"Pegwarmers is basically a rip off of Twisted Kaiju Theater, but with superhero action figures. Occasionally, Transformers, Godzilla, and Star Trek characters will make an appearance, but it's predominantly superhero based. The main three characters are Deadpool, Spider-Man, and Batman.")
add('PersonaFTW', 'http://PersonaFTW.webcomic.ws/', u'Finally, all of the Persona for the Win series in one convenient location. Containing the works of Persona Won, Persona 2 Win, Persona 3 FTW, and Persona 4TW. Now obviously as parody comics, all of the works do contain spoilers of their respective games. Read at your own risk.')
add('Perspectives', 'http://perspectives.webcomic.ws/', u'The dark twin of humor. A webcomic all about points of view. I write this in my spare time at work to stay sane, and wanted to share it with the world. I update every Monday, Wednesday, and Friday.')
add('Phantomstrail', 'http://phantomstrail.webcomic.ws/', u"The king of Mindon has died. His heir, Princess Jacquilyn, is expected to succeed to the throne, but Duke Medrick makes his own plans to take control of the kingdom. High Councilor Vasquez discovers Medrick's plan to usurp power. He, along with his son and the princess' bodyguard, take the princess away from the kingdom, to protect her. (Please look at the Synopsis page for a detailed description.) This webcomic is currently on hiatus.")
add('PiratesLife', 'http://PiratesLife.webcomic.ws/', u'A story about a Merchant and his crew who find themselves travelling all around the LEGO world.')
add('Pitchblack', 'http://pitchblack.webcomic.ws/', u'A black comedy webcomic with a particular tendency to make little kids cry.')
add('PlanetChaser', 'http://PlanetChaser.webcomic.ws/', u'All Clarissa wanted to do was have fun and travel around the galaxy. Her wish came true when she turned eighteen and inherited a space ship and a robot. She also inherited more than she bargained for.')
add('PlasticBulletsMayhemUnloaded', 'http://PlasticBulletsMayhemUnloaded.webcomic.ws/', u"Andrew Cross was going nowhere fast. It seemed that he couldn't stick to anything that he tried. However after several deaths in the family, Cross realized just how short life truly is. Determined to leave his mark on the world before he dies, Cross and his friends enter the Mayhem Unloaded tournament. A brutal combat simulator, where there can only be one victor.")
add('PobrePucho', 'http://PobrePucho.webcomic.ws/', u'There is a place far underground you have no idea it exists, with Lycanthropes, giant bugs, weird politics and NINJA BUNNIES. And poor Pucho just has to suck it up and join the party as the new Lycan in Paws Den!')
add('Poharex', 'http://poharex.webcomic.ws/', u'In a prehistoric world, Poharex rises up to become the defender of all dinosaurs.')
add('Popcultureskids', 'http://pop-cultures-kids.webcomic.ws/', u'A small group of kids, including a relative newcomer to the town, create a club for their mutual love of TV, music, movies, etc. My influences include Krazy Kat, Pogo, Bloom County and Calvin & Hobbes.')
add('Poussiere', 'http://poussiere.webcomic.ws/', u"Un monde o\xf9 les cr\xe9atures fantastiques existent ne peut qu'\xeatre un peu compliqu\xe9. Si vous voulez le visiter, commencez donc par les villes, c'est plein d'humains et de confort moderne, tant que \xe7a ne vous d\xe9range pas d'avoir un lutin pour voisin ou un troll pour chauffeur. Mais vous n'\xeates pas racistes, n'est-ce pas?")
add('ProjectGTH', 'http://ProjectGTH.webcomic.ws/', u'A story about a genetically engineered girl made to be a killing machine. Who now tries to live a normal life after escaping her creators, but is still haunted by her past')
add('Proportionalexcitability', 'http://proportionalexcitability.webcomic.ws/', u'The mostly real life adventures of two sisters. Updates Mondays.')
add('Pulse', 'http://pulse.webcomic.ws/', u'Annie "Pulse" Chang, and Tabitha "Bolt" Greene, two female human batteries become armored super-heroines.')
add('Punch', 'http://Punch.webcomic.ws/', u'The adventures of Mr Punch')
add('Purehavoc', 'http://pure-havoc.webcomic.ws/', u"Aaron Kidway is a 20 year old pizza delivery boy who hasn't had much luck in life...But Aaron's luck changes when Aaron meets a mysterious girl during a delivery!")
add('RPS', 'http://RPS.webcomic.ws/', u'RPS follows the near asylum-level misadventures of the Role-Play Saturday LARP game. Updates Wednesdays!')
add('RPT', 'http://RPT.webcomic.ws/', u'This webcomic has no amount of roleplaying (as of now or in the near future), and does NOT occur in a roleplaying-game universe with roleplaying-game rules. This webccomic DOES contain the story of a bunch of people living together or whatever, and there\'s supposed to be guns and explosions too. Centered around a main cast of characters, everyone with their perks and peculiarities, who just want to live a "normal" life, even when the destiny (script) pits them into battles where they might fight for more than their lives. And this webcomic also contains a (maybe not so) lenghty description describing in detail things that may or may not be true, depending on how do you interpret "normal".')
add('Randomthoughts', 'http://randomthoughts.webcomic.ws/', u"Yeah so this really is random thoughts. I woke up one morning thinking about a duck-sausage and I figured I might as well start doing a webcomic about things. Yes..Things. Stuff and junk and stuff that happens to me. And things. It's mostly sort of an online diary, except also not. It's just random thoughts. I apologize for dry humor, bad puns and possible injuries you suffer from facepalming. However, I hope you enjoy :D")
add('Rangerrandom', 'http://rangerrandom.webcomic.ws/', u'Basically, where I put my unrelated art, or art not important enough to be mentioned.')
add('Raspcat', 'http://raspcat.webcomic.ws/', u"The story of Upir's Mark, the most shocking band in Siberia and possibly the Universe.")
#add('Ravenwolf', 'http://ravenwolf.webcomic.ws/', u'Due to human negligence the world as we know it has ended and been reborn. The animal spirits that guide man giving them the forms of animals so that they would be able to survive in this new wilderness. Though now carrying the form of beasts man has not forgotten the place they once had, as an existence greater then just what nature wanted of them, an existence above all. Those that worked to gain their humanity are known as domestics, while those who wished to follow the rolls the spirits had given them were known as wilds. Both groups grew arrogant and hateful of one another, the wilds saw the domestics as selfish monsters, for they were returning to the ways that had once destroyed the world, while the domestics saw the wilds as primitive beings afraid of progress, they no better than wild animals. The raven and the wolf spirits grew tired of the destruction and fighting, and sided with the wilds in their ideals, the domestics only capable of further destroying nature. In their anger they marked a tribe of wilds with a curse, they being removed from the sacred circle of life, unable to hunt or grow their own food, their souls never able to move on while their bodies are unable to return to the earth when they died. The curse upon them only broken once the domestics are gone once and for all. The cursed tribe now known to all by the name of the spirits whom cursed them. \u2018Raven Wolf\u2019')
add('RecklessComix', 'http://RecklessComix.webcomic.ws/', u'We are a couple of guys (or a few sometimes) With a camera and too much free time at work... Enjoy us')
add('Remedy', 'http://Remedy.webcomic.ws/', u'Historical fantasy based in 5th century Roman empire. Even folklore has a beginning. Dark powers are stirring and only one band of outcasts stands between the world and oblivion. Whether for revenge,loyalty, curiosity, hope, despair, or love a curse brought them together and somewhere out there is the remedy. Updates often.(Any comments, questions, or criticisms would help greatly.)')
add('Requiemsgate', 'http://requiemsgate.webcomic.ws/', u'')
add('Residentweirdo', 'http://residentweirdo.webcomic.ws/', u'Some games, some life, some randomness. Whenever updates')
add('RumfAdventures', 'http://RumfAdventures.webcomic.ws/', u"Hello! It is my pleasure to welcome you to the site of my beloved comic strip Rumf Adventures! In the event that you have not become acquainted with my tiny strip,allow me to give you a quick rundown.This is an action-packed adventure strip with a dash of humor.It features a cast of thousands, starring the mighty adventurer Rumfus! That's it.I don't want to spoil the rest for you,just start reading! Onward to Adventures!")
add('STA', 'http://STA.webcomic.ws/', u"When two worlds are threaten and all hope seems lost, one hero will stand. Sadly, that's the best They're going to get.")
#add('SailorMoonTheEnemyNextDoor', 'http://SailorMoonTheEnemyNextDoor.webcomic.ws/', u'This is a fan manga inspired, written, and drawn by the original author of Sailor Moon: Ms. Naoko Takeuchi. Karolina Romanska and John Smith do not wish in any way to claim, usurp, or abuse property rights of Ms Naoko Takeuchi and the other authors of images used in this fan-based manga. This is a NON-PROFIT project, done strictly in our leisure time for sheer enjoyment.')
add('Sarakleeyo', 'http://sarakleeyo.webcomic.ws/', u"A World of Warcraft themed web comic starring the Argent Crusade's unusual misfits. The crusade allowed heroes of the Alliance and Horde to become partners. Sara & Kleeyo set the example...provided they can survive their friendship. Updated Mondays.")
add('Savemegebus', 'http://savemegebus.webcomic.ws/', u"Gebus considers himself the True Saviour of Humanity, though he rarely does anything about that. The comic revolves around him and his adventures which are often written as multiple-strip fabricated stories in order to explain changes in Gebus' appearance. As a comic straight out of the minds of the authors with little or no forethought, what plot or general continuity there is exists largely as an excuse for the authors to keep making comic strips. The fourth wall is broken regularly, and characters are taken directly from the authors' real life, though the storylines are not. The comic's style is taken from the comic it was spun from, Pixel-Sapiens, which features blocky characters with little to no curves or movement, and simple or absent backgrounds.")
add('Sawbladersblacknuzlocke', 'http://sawbladersblacknuzlocke.webcomic.ws/', u'*SADLY, THIS COMIC HAS BEEN ABANDONED. NO FURTHER UPDATES ARE BEING MADE TO THIS RUN.* A hand-drawn Nuzlocke comic detailing one crazy adventure in Pokemon: Black Version! Trust me, the art gets better as it goes along! Original Thread on the Offical Nuzlocke Forums: http://s7.zetaboards.com/Nuzlocke_Forum/topic/8520848/')
add('Schizmatic', 'http://schizmatic.webcomic.ws/', u'Schizmatic is a webcomic based on blueprint schematics applied to actual life. It puts the cosmos under a microscope, and reality under analysis.')
add('Seconds', 'http://Seconds.webcomic.ws/', u'All the comics here are primarily made in [i]Second Life[/i] and other virtual worlds, using crews of avatars to pose for and shoot the images used in each panel. It follows different stories with different characters over time. The initial story, [i]Return to Second Life[/i], is about what happens when avatars meet their owner in-world. General schedule is one page a day when reprinting , and about one page every two days when in production.')
add('SeeYourFeels', 'http://SeeYourFeels.webcomic.ws/', u'Comic is storyline-less, jump in anytime and hit the "random" button! Update Schedule: Every business day (Monday through Friday, excluding holidays) www.facebook.com/ICanSeeYourFeels')
#add('Seed', 'http://Seed.webcomic.ws/', u'A fantasy tale about three individuals in a time of war between two unlikely factions.')
add('Serengetti', 'http://serengetti.webcomic.ws/', u"Serengetti Dreams, as you may have inferred from the title, is a webcomic by Shane Itram. It updates daily, Monday through Friday. First time here? Kind of lost? Check out Dr. Bolton's welcome to new readers!")
add('Serpamiaflare', 'http://serpamiaflare.webcomic.ws/', u"Seeking meaning in a series of strange dreams involving her mother who died years ago, Kylie journeys to Raswen to find Madame Zinala, a fortune teller who has been known to interpret dreams with great accuracy. On the way, she meets Cain, a seemingly hapless cleric who, coincidentally, is also trying to meet Madame Zinala in hopes of learning how to break the curse of chains on his body. Together, they reach Raswen and go to find Madame Zinala. Unfortunately, their timing couldn't be worse...")
#add('Shades', 'http://shades.webcomic.ws/', u'A WW2 fighter pilot, a First Century warrior queen and a prehistoric mystic. Oh, and their tailor. These are not your common-or-garden heroes!')
add('Shadowsofnight', 'http://shadowsofnight.webcomic.ws/', u'Shadows of Night is a dark depiction of the Spider-Man mythos, re-imagined in a universe where SpiderMan is more brutal and darker than ever.')
add('ShamanQuest', 'http://ShamanQuest.webcomic.ws/', u'A Nomad, a young runaway, a psychic on the verge of madness and other characters band together to reach New Babel, one of the last cities on Earth. On their way stands the Wastelands, huge desert filled with mad prophets, power-hunger mafias, bizarre creatures and the looming threat of a World-scale conspiracy...')
add('Shatterrealm', 'http://shatterrealm.webcomic.ws/', u'Iconoclasts clash as wanderers from parallel worlds fight for survival, meaning, and a way to get home. Through tehcnological or supernatural means, a random few have managed to move back and forth between worlds. Some are lost. Some are searching. Some are hunters and exterminators. An exploration of the human heart.')
#add('Signifikat', 'http://signifikat.webcomic.ws/', u'While on the run from the Cinnamon City authorities, robotic girl Sunhra meets her match at the outskirts of the information highway: a young man with the ability to bend machinery to his will...')
#add('SimplySarah', 'http://SimplySarah.webcomic.ws/', u'Follow Sarah through her life as she deals with her own personal relationship issues and those of the people around her. Lesbian themed with one trans character and lots of other varied relationship issues.')
add('Sinjetpack', 'http://sinjetpack.webcomic.ws/', u'Mi Vida Sin Un Jetpack es un comic autobiogr\xe1fico sobre la vida de MaGnUs, escrito por \xe9l, con arte de Taibox (ocasionalmente coloreado por Mindy Lopkin). Publicado semanalmente en ingl\xe9s y espa\xf1ol.')
#add('Sketchy', 'http://sketchy.webcomic.ws/', u'Absurdly and charmingly absurd adventures that will make you say "Gosh!" Updates M-F.')
#add('Slightlyaboveaverage', 'http://slightlyaboveaverage.webcomic.ws/', u'Keiko Tachibana is an average High school girl. Scratch that. She\'s a self proclaimed "Slighty above average" High school girl who has dedicated herself to being only moderately better than the social norm. However one day she gets a visit from someone Way over the top. An inter dimensional cutie whom goes by the name Llla-Elac Ngtholi Cllegogg, also known as "Laila" to humans. She has come to destroy the sanity, and lives of everyone at Daisuke Ryuzaki high school. However, poor Keiko seems to be the only one at school whom has noticed this terrifying beast, and to make matters worse, she\'s staying at her house!! Will Keiko be driven insane by the ramblings of this terrible alien and her Slightly above average lifestyle tossed to the wind? Or will she succeed in defeating this strange alien menace!? Find out in this incredibly odd web comic inspired by the works of H.P. Lovecraft!')
#add('SlipstreamSingularity', 'http://SlipstreamSingularity.webcomic.ws/', u'350 years have passed since the first and only mission beyond Human Occupied Space was launched. In search of the alien intelligence that sent such wondrous knowledge back to Earth, the Odyssey mission was lost. Now, denied their own home world by the rebellion of their own children creations, the Synthetics, humanity has become a race of despots and wanderers that meander through the stars, eking out an existence. Updated Tuesdays and Saturdays. Created by TedChristensenGallery.com')
add('Smalltownvalues', 'http://smalltownvalues.webcomic.ws/', u'A mixed up family where at times, the pets have a better grasp of a situation than the humans.')
add('Snarlbear', 'http://snarlbear.webcomic.ws/', u'A teenager named Daisy falls into the mysterious Rainbow Dimension and beats up all of the monsters living there. Fantasy/Comedy/Horror/Action/Drama/Rainbows')
add('SoFunnyIForgotToLaugh', 'http://SoFunnyIForgotToLaugh.webcomic.ws/', u'One day, a neurotic artist decided to create a stick figure comic. Then God said, LET THERE BE CHARACTERS; then appeared Suds, a cynical drinking smartass, Perry, a shy guy lost in his thoughts, and Avital, the dumb creator herself. Together, they will overcome horrifying obstacles. Like CVS.')
add('Sonichuredone', 'http://sonichuredone.webcomic.ws/', u"Remember Sonichu? Well, start forgeting it, because Sonichu: RE-Done is here. An all new version of sonichu, made from obselete paint programs and cheap photoshops. Join Dash Sonichu and his friends as they journey through CWCville in adventures that involve beating up Jerkops, or trying to get rid of Chris. It's the first Sonichu comic made for multiple languages, so everyone can read the failtastic tales of Dash Sonichu. As of March 12, 2012, Chris-chan himself has, for some reason, declared this comic as an official Sonichu re-make. As of July 2012, Chris-chan has given the official Sonichu rights to Screws Enterprises, as he is soon to be shown in court on 10th July. As of December 20th 2012, Sonichu: RE-Done in English has been completed, and will no longer publish new adventures any time soon. Please check the blog for further updates...")
add('Sonichuredonejapanese', 'http://sonichuredonejapanese.webcomic.ws/', u'Japanese version Sonichu \u306e\u4e16\u754c\u3078\u3088\u3046\u3053\u305d \uff01\u3053\u306e\u5909\u66f4\u306e\u30d1\u30ed\u30c7\u30a3 CWC \u306e\u8584\u5f31\u6f2b\u753b\u306e\u304a\u697d\u3057\u307f\u304f\u3060\u3055\u3044\u3002(\u3059\u3079\u3066\u306e\u7ffb\u8a33\u306f\u30d3\u30f3\u30d3\u30f3\u7ffb\u8a33\u306b\u3088\u3063\u3066\u884c\u308f\u308c\u3066\u3044\u307e\u3059)\u66f4\u65b0\u30d7\u30ed\u30b0\u30e9\u30e0\u3001\u304a\u3088\u3073\u30e9\u30f3\u30c0\u30e0\u306a\u8a18\u4e8b\u306e\u305f\u3081\u306e\u30d6\u30ed\u30b0\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002 \u66f4\u65b0\u30d7\u30ed\u30b0\u30e9\u30e0: \u30b9\u30da\u30eb \u30df\u30b9\u767a\u751f\u3057\u307e\u3059\u3002')
add('Spacefarmer', 'http://spacefarmer.webcomic.ws/', u'')
add('Spacefighters', 'http://Spacefighters.webcomic.ws/', u'Do you like space men, martians, ray guns, talking chimps, katana blades, the legend of sasquatch, jet packs, teleportation, and the devil? ...If the answer is yes, than this comic is for you!')
add('Spacepirates', 'http://spacepirates.webcomic.ws/', u"In the near future, human colonies on Jupiter's moons are attacked by mysterious space pirates whose advanced ships can outrun other vessels. A mismatched handful of smugglers takes the pirates on, using near-obsolete hardware, and help from an unexpected source.")
add('Spacepulp', 'http://spacepulp.webcomic.ws/', u"Looks like I'm doin' a SPAAAACE PUUULLLP comic. Mostly for colorin' practice.")
add('Spades', 'http://Spades.webcomic.ws/', u"DISCONTINUED Spades is created by my proudly obnoxious teenage MonsterBrat with it's upkeep done by me. M.B. will referred to as 'it', by it's own request. We both play World of Warcraft as well as various offline games so alot of what is posted will reflect that and it's uncensored (shudder) creepiness. Eventually it will no longer be a teenager and I'll have to change this info thingy again. ~Rrayven")
add('Spf1337', 'http://spf1337.webcomic.ws/', u'A webcomic about the little things in life that let you get through the hard times. With groan-inducing puns and hilarious antics, SPF is here to entertain you. Or is it the other way around...?')
#add('Splitscreen', 'http://splitscreen.webcomic.ws/', u"Jan Lumeneski and Jeremy Tanner were inseparable best friends from childhood through high school. But Jan wanted more, when she didn't see things going her way she cut ties with Jeremy, moved to Mahattan and never looked back. More than a decade later Jan's now a successful fashion designer and chance meeting throws her back into Jeremy's life. He's overweight and depressed but Jan can't help still feeling that old flame burning... will she get what she wants this time around?")
add('Spooncomic', 'http://spooncomic.webcomic.ws/', u'A evil wizard turned Charles\' whole town turned into a kitchen (that\'s right). Cursed with the body of a SPOON, he has embarked on a journey to find the wizard and along the way, he will meet other "cursed" ones.')
add('Sscomic', 'http://ss-comic.webcomic.ws/', u'')
add('Starraccoon', 'http://starraccoon.webcomic.ws/', u"it's bugs bunny meets spiderman an alien raccoon escapes to earth after a evil warlord destroys his planet now he's on run from the goverment the men in black alien bounty hunters and the warlord himself")
#add('Stickfodder', 'http://stickfodder.webcomic.ws/', u"Stick figures at their finest and not so finest. Jokes, violence and harsh language? HELL YEAH! It's just fun for the entire family.")
add('StrangeAttractors', 'http://StrangeAttractors.webcomic.ws/', u'Strange Attractors is a humorous post-modern retro-science fiction comic. Sophie, the curator of the vast Museum of Lost Things, becomes embroiled in an epoch spanning war between magic and science, in which the comics she loves are actually coded histories, and she\u2019s become a magnet for all sorts of cosmic weirdness.')
add('Supershashi', 'http://supershashi.webcomic.ws/', u'')
add('TAOSAE', 'http://TAOSAE.webcomic.ws/', u'The Adventures of Sherilyn and Emma, and sometimes some other people. This comic follows two girls, who are named in the title, as they have adventures and shenanigans at school.')
add('Tangledmess', 'http://tangledmess.webcomic.ws/', u"The journal comic of a young artist, who has no idea what she's doing in life, and that's okay by her.")
add('Tardaasa', 'http://tardaasa.webcomic.ws/', u'Tardaasa is a weekly updated comic about Panny. A perverted, aggressive and majorly inappropriate "lady", who with no inhibitions try to figure out herself, men, and life in general.')
add('Tba', 'http://tba.webcomic.ws/', u'follows the daily life of four sisters and their friends in Tepes Broadview Apartments in Millwood, Iowa')
add('Teenagedragon', 'http://teenagedragon.webcomic.ws/', u"So! Looking for a comic with spunky dragons? Yeah! Sexy cat-girls? YEAH! Evil empires? YEAH YEAH YEAH! Giant spiders? HELL YEAH! Death dealing assassins? OH YEAH! Annoying film critics? YE-ah, wait, what? Zeke Fahrenheit is, if you couldn't tell from the lame build-up, a film critic. And not just any film critic, a bad one (but that's redundant). Follow his crazy, mixed-up adventures as he tries to woo the princess (unsuccessfully), raise his daughter who happens to be a dragon (or is she raising him?) and just try to keep his sanity in a world where pop culture is not to be embraced but feared.")
add('Tennisballman', 'http://tennisballman.webcomic.ws/', u"He's a man of severe delusion. She's a girl with anger problems. He has a skull minion and a giant dirt-breathing fish. She has enemies waiting to be killed with gorey passion. Updated every Tuesday and Friday.")
add('Thebestof25yearsofmissjandtheam', 'http://thebestof25yearsofmissjandtheam.webcomic.ws/', u'The best from 25 years of "Miss J and the AM." This was my strip before I started doing "Jenffer\'s Show." It\'s all about \'Miss J and the AM,\' a rock band in a place called the Yukon.')
add('Thebigscifimishmash', 'http://thebigsci-fimish-mash.webcomic.ws/', u"this comic is a sci-fi comic which mixes several differnt sci-fi things into one. for instance, it starts off kind of like the hitch hiker's guide to the galaxy but quickly moves on to parodies of star trek, star wars and many more.")
add('Theblackprincess', 'http://theblackprincess.webcomic.ws/', u"Sareena Black and Misty Smid are best friends, and co-workers in Eighth Sin's Paranormal Division. While Misty begins to be introduced into the operations of Sareena's family of witches and warlocks, the two find themselves faced with a quickly growing number of magically-inclined threats and dangerous individuals, all while they begin to suspect that things aren't what they seem at their job.")
add('Thechroniclesofdrew', 'http://thechroniclesofdrew.webcomic.ws/', u'A Biographical chronicle of the exploits of a majestic and ruggedly handsome man by the name of Drew. Join him through his exploits of life, love, laughter and the occasional bitchslap')
add('Wowwithatwistdamaclesandkejallcomic', 'http://Wowwithatwist-damaclesandkejallcomic.webcomic.ws/', u'Follow the dangerous adventures of Damacles , the human warrior and kenjall a worgen')
