# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2013 Bastian Kleineidam

from re import compile
from ..scraper import make_scraper, Genre
from ..util import tagre, fetchUrl, getPageContent

# note: adding the compile() functions inside add() is a major performance hog
_imageSearch =  compile(tagre("img", "src", r'(https://s3\.amazonaws\.com/media\.drunkduck\.com/[^"]+)', before="page-image"))
_linkSearch = tagre("a", "href", r'(/[^"]+/\d+/)')
_prevSearch = compile(_linkSearch + tagre("img", "class", "arrow_prev"))
_nextSearch = compile(_linkSearch + tagre("img", "class", "arrow_next"))
_lastSearch = compile(_linkSearch + tagre("img", "class", "arrow_last"))

def add(name, path):
    classname = 'DrunkDuck_%s' % name
    _url = 'http://www.theduckwebcomics.com/%s/' % path

    @classmethod
    def _namer(cls, imageUrl, pageUrl):
        index = int(pageUrl.rstrip('/').split('/')[-1])
        ext = imageUrl.rsplit('.')[-1]
        return '%d.%s' % (index, ext)

    @classmethod
    def _starter(cls):
        # first, try hopping to previous and next comic
        data, baseUrl = getPageContent(_url, cls.session)
        try:
            url = fetchUrl(_url, data, baseUrl, _prevSearch)
        except ValueError:
            # no previous link found, try hopping to last comic
            return fetchUrl(_url, data, baseUrl, _lastSearch)
        else:
            data, baseUrl = getPageContent(url, cls.session)
            return fetchUrl(url, data, baseUrl, _nextSearch)

    attrs = dict(
        name = 'DrunkDuck/' + name,
        url = _url,
        starter = _starter,
        stripUrl = _url + '%s/',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        lang = 'es' if name.lower().endswith('spanish') else 'en',
        help = 'Index format: n (unpadded)',
        namer = _namer,
    )
    attrs.update(Overrides.get(name, dict()))
    globals()[classname] = make_scraper(classname, **attrs)

# manually set attributes
Overrides = {
    'The_Devon_Legacy_Prologue': dict(
        description = u'Earth\'s fate is in the hands of 2 alien races!' \
        ' Luckily 1 of them isn\'t so bad. Attempting to stop a vicious' \
        ' horde can 2 specially gifted humans (Fenny & Sally) actually ' \
        ' turn the tables of balance on this war? Year 2132',
        genres = (Genre.scifi,),
    )
}


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('12_Men_Died_Making_This_Strip', '12_Men_Died_Making_This_Strip')
add('1337_Joe_and_Fellow_Seth', '1337_Joe_and_Fellow_Seth')
add('20_Galaxies', '20_Galaxies')
add('2Masters', '2Masters')
add('2_Bitter_4_Words', '2_Bitter_4_Words')
add('2s_a_company', '2s_a_company')
add('3rd_Party_Fantasy', '3rd_Party_Fantasy')
add('4_Humor', '4_Humor')
add('70_Seas', '70_Seas')
add('AD_1997', 'AD_1997')
add('AGENCY', 'AGENCY')
add('AKA_Limzee', 'AKA_Limzee')
add('ALTER', 'ALTER')
add('ANIME_WARS', 'ANIME_WARS')
add('AWES0ME', 'AWES0ME')
add('AWESOME_HIGH_FIVE_EDITION', 'AWESOME_HIGH_FIVE_EDITION')
add('A_Burden', 'A_Burden')
add('A_Deviant_Mind', 'A_Deviant_Mind')
add('A_Different_Perspective', 'A_Different_Perspective')
add('A_Dim_View', 'A_Dim_View')
add('A_Few_Brain_Cells_Short_of_Normal', 'A_Few_Brain_Cells_Short_of_Normal')
add('A_Jagged_Mind', 'A_Jagged_Mind')
add('A_Loonatics_Tale', 'A_Loonatics_Tale')
add('A_Note_On_My_Life', 'A_Note_On_My_Life')
add('A_Paige_Comic', 'A_Paige_Comic')
add('A_PoKeMoN_comic_that_everyone_will_ignore_even_though_the_author_puts_way_more_work_into_it_than_som', 'A_PoKeMoN_comic_that_everyone_will_ignore_even_though_the_author_puts_way_more_work_into_it_than_some_other_very_popular_PoKeMoN_comics_that_get_over_nine_thousand_views_on_days_they_DONT_update_What_the_hell')
add('A_Roll_of_the_Dice', 'A_Roll_of_the_Dice')
add('A_Step_Out_of_Phase', 'A_Step_Out_of_Phase')
add('A_Tale_of_Two_Sprites', 'A_Tale_of_Two_Sprites')
add('A_Way_to_the_Stars', 'A_Way_to_the_Stars')
add('A_town_called_Alandale', 'A_town_called_Alandale')
add('Acrobat', 'Acrobat')
add('Across_the_Way', 'Across_the_Way')
add('Acting_Out', 'Acting_Out')
add('Action', 'action')
add('Adam_and_Darcys_Shenanigans', 'Adam_and_Darcys_Shenanigans')
add('Adsecula_The_Seventh_Serpent', 'Adsecula_The_Seventh_Serpent')
add('Adventures_Guild', 'Adventures_Guild')
add('Adventures_in_StuffedAnimalLand', 'Adventures_in_StuffedAnimalLand')
add('Adventures_of_Lucrezia', 'Adventures_of_Lucrezia')
add('Adventures_of_Martin', 'Adventures_of_Martin')
add('Adventures_of_Wristance', 'Adventures_of_Wristance')
add('Aerians', 'Aerians')
add('Air_Raid_Robertson', 'Air_Raid_Robertson')
add('Akniatt', 'Akniatt')
add('Al_De_Baran', 'Al_De_Baran')
add('Alien_Circus', 'Alien_Circus')
add('Alien_Concepts', 'Alien_Concepts')
add('Aliens_Anonymous', 'Aliens_Anonymous')
add('All_Saints', 'All_Saints')
add('Allan', 'Allan')
add('Altimatium', 'Altimatium')
add('Amazing_Superteam', 'Amazing_Superteam')
add('America_Jr', 'America_Jr')
add('Amoebaville', 'amoebaville')
add('Amya', 'Amya')
add('An_Act_of_Aggression', 'An_Act_of_Aggression')
add('Anachronism', 'Anachronism')
add('Anarchy_2090', 'Anarchy_2090')
add('Anathema', 'Anathema')
add('And_Id', 'and_Id')
add('Anecdote', 'Anecdote')
add('Angel_Guardian', 'Angel_Guardian')
add('Angelfish_A_COV_comic', 'Angelfish_A_COV_comic')
add('Angry_D_Monkey', 'Angry_D_Monkey')
add('Animania', 'Animania')
add('Anime_Remix', 'Anime_Remix')
add('Animosity_Sonata', 'Animosity_Sonata')
add('Anomic_v2', 'Anomic_v2')
add('Another_Articifial_Time', 'Another_Articifial_Time')
add('Antcomics', 'Antcomics')
add('Anything_could_happen', 'Anything_could_happen')
add('Apathy_cigarettes_and_valentines', 'Apathy_cigarettes_and_valentines')
add('Ar_Oh_Ef_El', 'Ar_Oh_Ef_El')
add('Ardra', 'Ardra')
add('Arrowflight_Chronicles', 'Arrowflight_Chronicles')
add('Art_Captions', 'Art_Captions')
add('Art_and_sketches', 'Art_and_sketches')
add('Art_table_of_Duck', 'Art_table_of_Duck')
add('Artist_Adventure', 'Artist_Adventure')
add('Artwork____The_Mirror_of_Life', 'Artwork____The_Mirror_of_Life')
add('As_the_Galaxy_Turns', 'As_the_Galaxy_Turns')
add('Assassin_Assassin', 'Assassin_Assassin')
add('Asshole', 'Asshole')
add('Asteroid_of_Doom', 'Asteroid_of_Doom')
add('Atavism', 'Atavism')
add('Atlantis_Rising', 'Atlantis_Rising')
add('Attack_of_the_Robofemoids', 'Attack_of_the_Robofemoids')
add('Augustos', 'Augustos')
add('Avatar_of_Fire', 'Avatar_of_Fire')
add('Aw_Nuts_2', 'Aw_Nuts_2')
add('Awakenings_Online', 'Awakenings_Online')
add('Awesomataz', 'Awesomataz')
add('Ax_Crazy', 'Ax_Crazy')
add('AyaTakeo', 'AyaTakeo')
add('BALLMAN', 'BALLMAN')
add('BASO', 'BASO')
add('BFF', 'BFF')
add('BIBLE_BELT', 'BIBLE_BELT')
add('BK_Shadow_Nemesis', 'BK_Shadow_Nemesis')
add('BLADE_OF_THE_FREAK', 'BLADE_OF_THE_FREAK')
add('BLANK_LIFE_insert_player_rokulily', 'BLANK_LIFE_insert_player_rokulily')
add('BRINK', 'BRINK')
add('Ba_Ba', 'Ba_Ba')
add('Bacon_Strips', 'Bacon_Strips')
add('BadBlood', 'BadBlood')
add('Bad_Guy_High', 'Bad_Guy_High')
add('Badly_Drawn_Penguins', 'Badly_Drawn_Penguins')
add('Badly_Drawn_Webcomic', 'Badly_Drawn_Webcomic')
add('Banango', 'Banango')
add('Baroque_Viceroyalty', 'Baroque_Viceroyalty')
add('Barry_Reviews_Webcomics', 'Barry_Reviews_Webcomics')
add('Bass_Rebirth_of_Amp', 'Bass_Rebirth_of_Amp')
add('Battle_of_the_Robofemoids', 'Battle_of_the_Robofemoids')
add('Bear_Versus_Zombies', 'Bear_Versus_Zombies')
add('Bearly_Abel', 'Bearly_Abel')
add('Beautiful_Skies', 'Beautiful_Skies')
add('Beauty_Into_Beast', 'Beauty_Into_Beast')
add('Because_of_Ivan', 'Because_of_Ivan')
add('Been_Better', 'Been_Better')
add('Beer_Noodles', 'Beer_Noodles')
add('Beluga_Weekly', 'Beluga_Weekly')
add('Benders_and_Brawlers', 'Benders_and_Brawlers')
add('Beta', 'Beta')
add('Better_Luck_Next_Time', 'Better_Luck_Next_Time')
add('Betting_On_Love', 'Betting_On_Love')
add('Between_Worlds', 'Between_Worlds')
add('BffSatan', 'BffSatan')
add('Billy_Learns_To_Rock', 'Billy_Learns_To_Rock')
add('Bird_and_Worm', 'Bird_and_Worm')
add('Birdman', 'Birdman')
add('Bitter_Sweet_Melancholy', 'Bitter_Sweet_Melancholy')
add('Black_Dragon', 'Black_Dragon')
add('Blackheart', 'blackheart')
add('Blade_of_Toshubi', 'Blade_of_Toshubi')
add('Blitz', 'Blitz')
add('Blood_Bound', 'Blood_Bound')
add('Blood_Nation', 'Blood_Nation')
add('Bloodlust_Eternal_Conflict', 'Bloodlust_Eternal_Conflict')
add('Blue_Blaster', 'Blue_Blaster')
add('Blue_Comics', 'Blue_Comics')
add('Blue_Strawberry', 'Blue_Strawberry')
add('Blues_Rhapsody', 'Blues_Rhapsody')
add('Bobby_Monos_Crappy_Comics', 'Bobby_Monos_Crappy_Comics')
add('Bobby_the_fetus', 'Bobby_the_fetus')
add('Bombshell', 'Bombshell')
add('Bombshell_Fights_For_America', 'Bombshell_Fights_For_America')
add('Boobs_Ahoy', 'Boobs_Ahoy')
add('Boogey_Dancing', 'Boogey_Dancing')
add('Bored_by_the_Bus_Stop', 'Bored_by_the_Bus_Stop')
add('Bounty', 'Bounty')
add('Brainfuzz', 'Brainfuzz')
add('Bram_and_Vlad', 'Bram_and_Vlad')
add('Breaking_the_Ice', 'Breaking_the_Ice')
add('Breeding_ground', 'breeding_ground')
add('Brick', 'brick')
add('Bricktown', 'Bricktown')
add('Brinkerhoff', 'Brinkerhoff')
add('Broken_Wings', 'Broken_Wings')
add('Brymstone', 'Brymstone')
add('Bulletproof', 'Bulletproof')
add('CATS_AND_ICECREAM', 'CATS_AND_ICECREAM')
add('CDA', 'CDA')
add('COMPANY_MAN', 'COMPANY_MAN')
add('CRAZED', 'CRAZED')
add('CROSS_WORLDS_NEXXUS', 'CROSS_WORLDS_NEXXUS')
add('Camera_Obscura', 'Camera_Obscura')
add('Camp_Calomine', 'Camp_Calomine')
add('Captain_Communism', 'Captain_Communism')
add('Carbon_and_Space', 'Carbon_and_Space')
add('Carnivore_Carnival', 'Carnivore_Carnival')
add('Carrot_and_Roper', 'Carrot_and_Roper')
add('Case_1048_Blind_and_Blue', 'Case_1048_Blind_and_Blue')
add('Cashcow', 'Cashcow')
add('Cataclysm', 'Cataclysm')
add('Catboy_at_th_Con', 'Catboy_at_th_Con')
add('Celebrity_Stalker', 'Celebrity_Stalker')
add('Cerintha', 'Cerintha')
add('Chad_the_Fat_Kid', 'Chad_the_Fat_Kid')
add('Chain_of_Stuff', 'Chain_of_Stuff')
add('Changes', 'Changes')
add('Changes_Redux', 'Changes_Redux')
add('Changing_Worlds', 'Changing_Worlds')
add('Chaos_Punks', 'Chaos_Punks')
add('Chaos_Reigns', 'Chaos_Reigns')
add('Character_Development', 'Character_Development')
add('Charby_the_Vampirate', 'Charby_the_Vampirate')
add('Chester_and_Ferdie', 'Chester_and_Ferdie')
add('Children_at_Play', 'Children_at_Play')
add('Children_of_the_Tiger', 'Children_of_the_Tiger')
add('Chimera', 'Chimera')
add('Christopher', 'Christopher')
add('Chrono_Redux', 'Chrono_Redux')
add('Circle_Arcadia', 'Circle_Arcadia')
add('City_of_Dream', 'City_of_Dream')
add('Civil_Servitude', 'Civil_Servitude')
add('ClashDown', 'ClashDown')
add('Clockwork_Atrium', 'Clockwork_Atrium')
add('Cloud_Eagle', 'Cloud_Eagle')
add('Coalition_of_the_Reluctant', 'Coalition_of_the_Reluctant')
add('Cockroach_Theater', 'Cockroach_Theater')
add('Coffee_Time', 'Coffee_Time')
add('Collision', 'Collision')
add('Comic_Pie', 'Comic_Pie')
add('Comic_Remix', 'Comic_Remix')
add('Coming_Soon', 'Coming_Soon')
add('Conventional_Wisdom', 'Conventional_Wisdom')
add('Cooks_Assistant', 'Cooks_Assistant')
add('Corporate_Life', 'Corporate_Life')
add('CorruptHardware', 'CorruptHardware')
add('Coveinant_Journey', 'Coveinant_Journey')
add('Cowboys_and_Aliens_II', 'Cowboys_and_Aliens_II')
add('Cowtoon', 'cowtoon')
add('Crack_Bird_and_Company', 'Crack_Bird_and_Company')
add('Crackwalker', 'Crackwalker')
add('Cramberries', 'Cramberries')
add('Crap_on_a_Stick', 'Crap_on_a_Stick')
add('CrayonS', 'CrayonS')
add('Crazy_Duck', 'Crazy_Duck')
add('Crickets_Creature', 'Crickets_Creature')
add('Crimson_Dark', 'Crimson_Dark')
add('Crossover', 'Crossover')
add('Crossover_High', 'Crossover_High')
add('Crossoverkill', 'Crossoverkill')
add('Crossoverlord', 'Crossoverlord')
add('Crossoville', 'Crossoville')
add('Cru_The_DwarF', 'Cru_The_DwarF')
add('Ctownstrips', 'Ctownstrips')
add('Culture_Shock', 'Culture_Shock')
add('Cumic_relief', 'Cumic_relief')
add('Curse_of_The_Black_Terror', 'Curse_of_The_Black_Terror')
add('Cute_N_Spicy', 'Cute_N_Spicy')
add('Cuttley_Bear', 'Cuttley_Bear')
add('Cwens_Quest', 'Cwens_Quest')
add('CyBoar', 'CyBoar')
add('Cyberspace', 'Cyberspace')
add('Cybertech', 'Cybertech')
add('DD24hour_2010', 'DD24hour_2010')
add('DD24hour_2011', 'DD24hour_2011')
add('DDSR', 'DDSR')
add('DHF_Jam', 'DHF_Jam')
add('DIAMOND_English_version', 'DIAMOND_English_version')
add('DR_Second_arc_Part_1', 'DR_Second_arc_Part_1')
add('DR_Valume_1', 'DR_Valume_1')
add('D_U_E', 'D_U_E')
add('Danielle_Dark', 'Danielle_Dark')
add('Dansk_Folly', 'Dansk_Folly')
add('Daqueran', 'Daqueran')
add('DarkKyos_Short', 'DarkKyos_Short')
add('Darken', 'Darken')
add('Darkling_Visions_of_a_Madmans_Soul', 'Darkling_Visions_of_a_Madmans_Soul')
add('Daryl_and_Susie', 'Daryl_and_Susie')
add('Dasien', 'Dasien')
add('Day_in_the_Life_of_a_Cosplayer', 'Day_in_the_Life_of_a_Cosplayer')
add('DeadFingers', 'DeadFingers')
add('Dead_Men', 'Dead_Men')
add('Dead_ducks', 'dead_ducks')
add('Death_Brigade', 'Death_Brigade')
add('Decimated_Eden', 'Decimated_Eden')
add('DeepHurting', 'DeepHurting')
add('Demon_Eater', 'Demon_Eater')
add('Demon_Fist', 'Demon_Fist')
add('Demon_Slayers', 'Demon_Slayers')
add('Demonics', 'Demonics')
add('Demons_Mirror', 'Demons_Mirror')
add('Denizens__Attention', 'Denizens__Attention')
add('Depths_of_My_Empty_Soul', 'Depths_of_My_Empty_Soul')
add('Desperate_Angels', 'Desperate_Angels')
add('Destroying_The_Illusion', 'Destroying_The_Illusion')
add('Deviant_Prophets', 'Deviant_Prophets')
add('Diamond', 'Diamond')
add('Din_Krakatau', 'Din_Krakatau')
add('Dirtheads', 'Dirtheads')
add('Distant_Embrace', 'Distant_Embrace')
add('Divine_Grace', 'Divine_Grace')
add('Divine_Leap', 'Divine_Leap')
add('Do_it_Yourself', 'Do_it_Yourself')
add('Dobutsu_no_Tamashii', 'Dobutsu_no_Tamashii')
add('Doctor_Death_vs_The_Zombie_', 'Doctor_Death_vs_The_Zombie_')
add('Dog_the_Spot', 'Dog_the_Spot')
add('Dogs_Eye_View', 'Dogs_Eye_View')
add('Don_Josh', 'Don_Josh')
add('Dont_Eat_the_Bread', 'Dont_Eat_the_Bread')
add('Doodlerama', 'Doodlerama')
add('Dot_Dot_Dot', 'Dot_Dot_Dot')
add('Dot_EXE_Saga', 'dot_EXE_Saga')
add('Double_Coupons', 'Double_Coupons')
add('Drag_them_down', 'drag_them_down')
add('Dragon_City', 'Dragon_City')
add('Dragon_Kingdoms', 'Dragon_Kingdoms')
add('Dragonaur', 'Dragonaur')
add('Dragonaur_Mini', 'Dragonaur_Mini')
add('Dragonballz__Smash_Tournament', 'Dragonballz__Smash_Tournament')
add('Dragonet', 'Dragonet')
add('Dragons_Quest___Crystals_of_the_Elder', 'Dragons_Quest___Crystals_of_the_Elder')
add('Drawn_to_you', 'Drawn_to_you')
add('Dread_Sisterhood_of_Randomnessossity', 'Dread_Sisterhood_of_Randomnessossity')
add('DreamCatcher', 'DreamCatcher')
add('Dream_Chronicles', 'Dream_Chronicles')
add('Dribble_For_Kids', 'Dribble_For_Kids')
add('DrunkDuck_Poop', 'DrunkDuck_Poop')
add('Drunk_Duck_Beauty_Contest', 'Drunk_Duck_Beauty_Contest')
add('Drunk_Duck_Gift_Exchanges', 'Drunk_Duck_Gift_Exchanges')
add('Drunk_Duck_Zombies', 'Drunk_Duck_Zombies')
add('Duck_and_Quail', 'Duck_and_Quail')
add('Ducks_of_Doom', 'Ducks_of_Doom')
add('Due_East', 'Due_East')
add('Dueling_Heroes', 'Dueling_Heroes')
add('Dungeon_Hordes', 'Dungeon_Hordes')
add('Dying_to_Live', 'Dying_to_Live')
add('ELEMENT', 'ELEMENT')
add('ELO', 'ELO')
add('Edepth_Angel', 'Edepth_Angel')
add('Edge_of_December', 'Edge_of_December')
add('Educomix', 'Educomix')
add('Elastik_Dreamz', 'Elastik_Dreamz')
add('Electronic_Revolutions_The_Burnhams', 'Electronic_Revolutions_The_Burnhams')
add('Elemental_Animarus', 'Elemental_Animarus')
add('Elements_CYOA', 'Elements_CYOA')
add('Elf_N_Hood', 'Elf_N_Hood')
add('Eliada', 'eliada')
add('Elijah_and_Azuu', 'Elijah_and_Azuu')
add('Elijah_and_Azuu_Classic', 'Elijah_and_Azuu_Classic')
add('Elsewhere', 'Elsewhere')
add('Elves_With_Mecha', 'Elves_With_Mecha')
add('Em_oi', 'Em_oi')
add('Emma', 'Emma')
add('Endstone', 'Endstone')
add('Energize', 'Energize')
add('Engine', 'Engine')
add('Enter_the_Duck_3', 'Enter_the_Duck_3')
add('Epic_Brundala', 'Epic_Brundala')
add('Epic_adventures', 'Epic_adventures')
add('Erth', 'Erth')
add('Essay_Bee_Comics_Presents_Fusion', 'Essay_Bee_Comics_Presents_Fusion')
add('Estatic_Gods', 'Estatic_Gods')
add('Eternal_Flame', 'Eternal_Flame')
add('EternityComplex', 'EternityComplex')
add('Eternity_Comic', 'Eternity_Comic')
add('Eternity_Complex', 'Eternity_Complex')
add('Ethereal', 'Ethereal')
add('Evan_Yeti', 'Evan_Yeti')
add('Even_For_a_Lunch_Meat', 'Even_For_a_Lunch_Meat')
add('Evergreen_Comics', 'Evergreen_Comics')
add('Everybody_Loves_Zero', 'Everybody_Loves_Zero')
add('Everybody_hates_Herb', 'Everybody_hates_Herb')
add('Eves_Apple', 'Eves_Apple')
add('Evil_Dawn', 'Evil_Dawn')
add('Evil_Empire_Moratorium', 'Evil_Empire_Moratorium')
add('Evil_Inc', 'Evil_Inc')
add('Evil_Plan', 'Evil_Plan')
add('Evilish', 'Evilish')
add('Explorers_Of_the_Unknown', 'Explorers_Of_the_Unknown')
add('Extra_stuff_of_the_other_comics', 'Extra_stuff_of_the_other_comics')
add('FIGHT', 'FIGHT')
add('FIGHT_2', 'FIGHT_2')
add('FLICKERFLAME', 'FLICKERFLAME')
add('FRANKENSTEIN__Her_Majestys_Secret_Service', 'FRANKENSTEIN__Her_Majestys_Secret_Service')
add('Fahei_Volume_1__Firefly', 'Fahei_Volume_1__Firefly')
add('Fainting_Spells', 'Fainting_Spells')
add('FanDanGo', 'FanDanGo')
add('FantastiTeam', 'FantastiTeam')
add('Far_Out_There', 'Far_Out_There')
add('Fated_Feather', 'Fated_Feather')
add('Faults', 'Faults')
add('Faust', 'Faust')
add('Featuring_Talking_Guinea_Pigs', 'featuring_Talking_Guinea_Pigs')
add('Feeling_Rushed', 'Feeling_Rushed')
add('Fifth_Dimension', 'Fifth_Dimension')
add('Fighter_House', 'Fighter_House')
add('Fightsplosion_Legends', 'Fightsplosion_Legends')
add('Figured_It_Out', 'Figured_It_Out')
add('Final_Blasphemy', 'Final_Blasphemy')
add('FireBorn', 'FireBorn')
add('Firefly_Cross', 'Firefly_Cross')
add('Fizz', 'Fizz')
add('Flame_of_Earth', 'Flame_of_Earth')
add('Flaming_Codfish', 'Flaming_Codfish')
add('Flaming_Fuzzy_People', 'Flaming_Fuzzy_People')
add('Floyd_and_Mike', 'Floyd_and_Mike')
add('Flying_Under_the_Influence', 'Flying_Under_the_Influence')
add('For_Your_Eyes_Only', 'For_Your_Eyes_Only')
add('Forsaken_Valor', 'Forsaken_Valor')
add('Fortress_Avalon', 'Fortress_Avalon')
add('Four_Bats', 'Four_Bats')
add('Frame_by_Frame', 'Frame_by_Frame')
add('Frank_and_Steinway', 'Frank_and_Steinway')
add('Frank_and_Vinny', 'Frank_and_Vinny')
add('Fred_Peterson_The_Mighty_Warlord_Book_1', 'Fred_Peterson_The_Mighty_Warlord_Book_1')
add('Freedom_Fighters', 'Freedom_Fighters')
add('Frobert_the_Demon', 'Frobert_the_Demon')
add('Frog_Skin_Boots', 'Frog_Skin_Boots')
add('Frontier__2170', 'Frontier__2170')
add('Fun_Times', 'Fun_Times')
add('Fuse', 'Fuse')
add('Fusion', 'Fusion')
add('GAAK', 'GAAK')
add('GIF_Showcase', 'GIF_Showcase')
add('Gambit_as_Bishounen', 'Gambit_as_Bishounen')
add('Gamers_Anonymous', 'Gamers_Anonymous')
add('Gametard', 'Gametard')
add('Gary_the_Alchemist', 'Gary_the_Alchemist')
add('Gello_Apocalypse', 'Gello_Apocalypse')
add('Gelotology', 'Gelotology')
add('Gemutations__Plague', 'Gemutations__Plague')
add('George_the_Dragon', 'George_the_Dragon')
add('Get_Up_and_Go', 'Get_Up_and_Go')
add('Getting_Into_The_MiddleGround', 'Getting_Into_The_MiddleGround')
add('Ghost_Hunters_Online_Manga', 'Ghost_Hunters_Online_Manga')
add('Ghosting', 'Ghosting')
add('Gift', 'Gift')
add('Gifted', 'Gifted')
add('Ginger_and_Shadow', 'Ginger_and_Shadow')
add('Girl_robot', 'girl_robot')
add('Give_Me_The_Sky', 'Give_Me_The_Sky')
add('Glass_Hearts', 'Glass_Hearts')
add('Gnoph', 'Gnoph')
add('Go_A_Viking_The_Sword_of_Kings', 'Go_A_Viking_The_Sword_of_Kings')
add('Go_For_it', 'Go_For_it')
add('Goblin_Hollow', 'Goblin_Hollow')
add('God_Complex', 'God_Complex')
add('God_Damn_It', 'God_Damn_It')
add('God_of_Destruction', 'God_of_Destruction')
add('Godlings', 'Godlings')
add('Godot', 'Godot')
add('Gods_Playing_Poker', 'Gods_Playing_Poker')
add('Golden_Gamers', 'Golden_Gamers')
add('Goo_From_Another_Dimension', 'Goo_From_Another_Dimension')
add('Goober_Nice_To_Meep_You', 'Goober_Nice_To_Meep_You')
add('Good_Guy', 'Good_Guy')
add('Good_Sir_Cat', 'Good_Sir_Cat')
add('Good_Taste', 'Good_Taste')
add('Goosetown_and_Lunch_Break', 'Goosetown_and_Lunch_Break')
add('Graphical_Deviants', 'Graphical_Deviants')
add('Grayling', 'Grayling')
add('Grim', 'Grim')
add('Grin_n_spirit', 'grin_n_spirit')
add('Grog', 'Grog')
add('Grounded_Angel', 'Grounded_Angel')
add('Growth', 'Growth')
add('Guardian_of_Twilight', 'Guardian_of_Twilight')
add('Guinea_Something_Good', 'Guinea_Something_Good')
add('Gundula_un_de_Stuventiger', 'Gundula_un_de_Stuventiger')
add('HASBEN_AND_HASH', 'HASBEN_AND_HASH')
add('HSW_Remix', 'HSW_Remix')
add('H_A_R_D', 'H_A_R_D')
add('H_I_K_A_R_I', 'H_I_K_A_R_I')
add('Hakkum_Town', 'Hakkum_Town')
add('Hand_Drawn', 'Hand_Drawn')
add('Hanged_doll', 'hanged_doll')
add('Happyface_Comics', 'Happyface_Comics')
add('Harkovast', 'Harkovast')
add('Headless_Cross', 'Headless_Cross')
add('Heart_of_a_Dragon', 'Heart_of_a_Dragon')
add('Hearts_and_Nails', 'Hearts_and_Nails')
add('Heavy_Mech', 'Heavy_Mech')
add('Hellbent', 'Hellbent')
add('Hellscream', 'Hellscream')
add('Hephaestus', 'Hephaestus')
add('Here_Comes_the_Chavalry_and_other_random_things_we_decided_to_draw', 'Here_Comes_the_Chavalry_and_other_random_things_we_decided_to_draw')
add('Hero_Force', 'Hero_Force')
add('Heroes_Alliance', 'Heroes_Alliance')
add('Heroes_Unite', 'Heroes_Unite')
add('Hexagon_Death_Squad', 'Hexagon_Death_Squad')
add('Hi_Res_Heroes', 'Hi_Res_Heroes')
add('Hikari_The_Demon_Swordsman', 'Hikari_The_Demon_Swordsman')
add('Hiro', 'hiro')
add('Hit_and_Miss', 'Hit_and_Miss')
add('Holon', 'Holon')
add('Horribleville', 'Horribleville')
add('Hospitality_Included', 'Hospitality_Included')
add('HotelSoul', 'HotelSoul')
add('How_I_Killed_The_Gods', 'How_I_Killed_The_Gods')
add('How_Unfortunate', 'How_Unfortunate')
add('Hyper_Death_Babies', 'Hyper_Death_Babies')
add('Hyperactive_Comics', 'Hyperactive_Comics')
add('IF_I_GET_LOCKED_UP_TONITE', 'IF_I_GET_LOCKED_UP_TONITE')
add('IRC', 'IRC')
add('I_Come_From_Mars', 'I_Come_From_Mars')
add('I_Fell_Down_The_Stairs', 'I_Fell_Down_The_Stairs')
add('I_got_it_in_my_mouth', 'I_got_it_in_my_mouth')
add('ImaginaryFriends', 'ImaginaryFriends')
add('Imaginary_Daughter_Bonus', 'Imaginary_Daughter_Bonus')
add('Imaginary_Tactics', 'Imaginary_Tactics')
add('Inappropriate_Irving', 'Inappropriate_Irving')
add('Inchoatica', 'Inchoatica')
add('Incorporated_Hate', 'Incorporated_Hate')
add('Infinity_Burger', 'Infinity_Burger')
add('Inhuman', 'Inhuman')
add('Insanity_Untamed', 'Insanity_Untamed')
add('Insanity_of_Xade', 'Insanity_of_Xade')
add('Insomnia_The_Comic', 'Insomnia_The_Comic')
add('Insomniart', 'Insomniart')
add('Intergalactic_Continental_Dimension_Travelers', 'Intergalactic_Continental_Dimension_Travelers')
add('Internet_Superbuddies', 'Internet_Superbuddies')
add('Iornhart', 'Iornhart')
add('Ishi_Alliance', 'Ishi_Alliance')
add('Island_Of_Submission', 'Island_Of_Submission')
add('Its_Ninja_Time', 'Its_Ninja_Time')
add('ItzWrAiTh', 'ItzWrAiTh')
add('JRs_Minutemen', 'JRs_Minutemen')
add('JUNK_a_story', 'JUNK_a_story')
add('Jac_Strips_for_You', 'Jac_Strips_for_You')
add('Jack', 'Jack')
add('Jake_the_Evil_Hare', 'Jake_the_Evil_Hare')
add('Jays_Internet_Fight_Club', 'Jays_Internet_Fight_Club')
add('Jenffers_show', 'jenffers_show')
add('Jeriah', 'Jeriah')
add('Jericho', 'Jericho')
add('Jerk_Wadz', 'Jerk_Wadz')
add('Jet_and_Joe', 'Jet_and_Joe')
add('Jhulene_the_Paladin', 'Jhulene_the_Paladin')
add('Jix', 'Jix')
add('Joe_Bivins_Man_Genius', 'Joe_Bivins_Man_Genius')
add('Joe_Pop', 'Joe_Pop')
add('John', 'John')
add('Jonkos_Picture_Diary', 'Jonkos_Picture_Diary')
add('Jump', 'Jump')
add('Junk_Food', 'Junk_Food')
add('Jurbas', 'Jurbas')
add('JustAnotherDay', 'JustAnotherDay')
add('Just_Call_Me_Freedom', 'Just_Call_Me_Freedom')
add('Just_Liam', 'Just_Liam')
add('Just_My_Luck', 'Just_My_Luck')
add('Just_random', 'just_random')
add('KAKA_PENCIL_magical_pen', 'KAKA_PENCIL_magical_pen')
add('KAMs_Fanart', 'KAMs_Fanart')
add('KISS_4K_the_webcomic', 'KISS_4K_the_webcomic')
add('Karabear_Comics_Unlimited', 'Karabear_Comics_Unlimited')
add('Karen_the_Marilith', 'Karen_the_Marilith')
add('Kat_and_Dogg', 'Kat_and_Dogg')
add('Kawaii_Daigakusei', 'Kawaii_Daigakusei')
add('Kazei_5_Rebirth', 'Kazei_5_Rebirth')
add('Keeping_Up_with_Thursday', 'Keeping_Up_with_Thursday')
add('Kemono_Densetsu', 'Kemono_Densetsu')
add('Kenji_Nin', 'Kenji_Nin')
add('Kevin_Wards_A_Frickin_Ninja_Story', 'Kevin_Wards_A_Frickin_Ninja_Story')
add('Keyguard_Active', 'Keyguard_Active')
add('Kids_With_Gas_Eat_Free', 'Kids_With_Gas_Eat_Free')
add('Killer_Kittenz', 'Killer_Kittenz')
add('Kimeral', 'Kimeral')
add('King_Me', 'King_Me')
add('Kirby_Komiks', 'Kirby_Komiks')
add('Kirby_supah_star', 'kirby_supah_star')
add('Kitty_Litter', 'Kitty_Litter')
add('Knights_Requiem', 'Knights_Requiem')
add('Knock_on_Wood', 'Knock_on_Wood')
add('Koji_Takahashi_Stops_the_World', 'Koji_Takahashi_Stops_the_World')
add('Kroniki_Black_Dragons', 'Kroniki_Black_Dragons')
add('Kung_Fu_Komix', 'Kung_Fu_Komix')
add('Kurenai_Mashin', 'Kurenai_Mashin')
add('LASTFantasy', 'LASTFantasy')
add('LA_ESPADA_DEL_ANORMAL', 'LA_ESPADA_DEL_ANORMAL')
add('LOE_Plus', 'LOE_Plus')
add('Lacerated_Veil', 'Lacerated_Veil')
add('Laggoo_and_the_Kings_Trident', 'Laggoo_and_the_Kings_Trident')
add('Lancaster_the_Ghost_Detective', 'Lancaster_the_Ghost_Detective')
add('Last_Chance_The_Beast_Hunter', 'Last_Chance_The_Beast_Hunter')
add('Last_Of_The_Wilds', 'Last_Of_The_Wilds')
add('Last_Place_Comics', 'Last_Place_Comics')
add('Last_War', 'Last_War')
add('Last_words', 'Last_words')
add('Latchkey', 'Latchkey')
add('Laurentinas_Improv_Studio_The_Comic_Art', 'Laurentinas_Improv_Studio_The_Comic_Art')
add('Lavender_Legend', 'Lavender_Legend')
add('Led_by_a_Mad_Man', 'Led_by_a_Mad_Man')
add('LeeEXE', 'LeeEXE')
add('Legacy_of_Kain_Laugh_Reaver', 'Legacy_of_Kain_Laugh_Reaver')
add('Legend_of_Link', 'Legend_of_Link')
add('Legend_of_Setar', 'Legend_of_Setar')
add('Legend_of_Zelda__Ocarina_of_Tim', 'Legend_of_Zelda__Ocarina_of_Tim')
add('Legends_of_Idiocy', 'Legends_of_Idiocy')
add('Leggo_my_Ego', 'Leggo_my_Ego')
add('Lego_Space', 'Lego_Space')
add('Lena', 'Lena')
add('Leo', 'Leo')
add('Leon', 'Leon')
add('Lexcore', 'Lexcore')
add('Life_Blowz', 'Life_Blowz')
add('Life_and_Death', 'Life_and_Death')
add('Life_and_Maybe_Death_of_Ed', 'Life_and_Maybe_Death_of_Ed')
add('Life_as_an_8bit', 'Life_as_an_8bit')
add('Life_with_Dragons', 'Life_with_Dragons')
add('Lifeblood', 'Lifeblood')
add('Light_within_shadow', 'light_within_shadow')
add('Like_Fish_in_Water', 'Like_Fish_in_Water')
add('Lil_Hero_Artists_Manga_Edition', 'Lil_Hero_Artists_Manga_Edition')
add('Link_Skywalker', 'Link_Skywalker')
add('Linnyanie', 'Linnyanie')
add('Liquid_Lunch', 'Liquid_Lunch')
add('Lite_bites', 'Lite_bites')
add('Little_Bat_Koku', 'Little_Bat_Koku')
add('Little_Black_Dress', 'Little_Black_Dress')
add('Little_Digital_People', 'Little_Digital_People')
add('Little_Terrors', 'Little_Terrors')
add('Livin_On_The_Edge', 'Livin_On_The_Edge')
add('Living_With_Insanity', 'Living_With_Insanity')
add('Lizzy', 'Lizzy')
add('Lola', 'Lola')
add('Long_Conversations_About_Nothing', 'Long_Conversations_About_Nothing')
add('Loose_Lips', 'Loose_Lips')
add('Lost', 'Lost')
add('Lost_Chapters_of_Megaman', 'Lost_Chapters_of_Megaman')
add('Lost_Invisible', 'Lost_Invisible')
add('Lost_Tribe_of_Pen_GUin', 'Lost_Tribe_of_Pen_GUin')
add('Lovarian_Adventures', 'Lovarian_Adventures')
add('Love_And_Chaos', 'Love_And_Chaos')
add('Love_Story', 'Love_Story')
add('Lovecraft_Yaoi', 'Lovecraft_Yaoi')
add('Lucidfairy', 'Lucidfairy')
add('MAG_ISA', 'MAG_ISA')
add('MAYA_la_leyenda_del_lobo', 'MAYA_la_leyenda_del_lobo')
add('MISFIT_ASSASSINS', 'MISFIT_ASSASSINS')
add('MKIA_The_Sprite_Comic', 'MKIA_The_Sprite_Comic')
add('MMM_BooGrrs', 'MMM_BooGrrs')
add('MMZ_After_Zero', 'MMZ_After_Zero')
add('MS_Pain', 'MS_Pain')
add('Mad_World', 'Mad_World')
add('Madness_to_my_Method', 'Madness_to_my_Method')
add('Mafital', 'Mafital')
add('Mage', 'Mage')
add('Magellan', 'Magellan')
add('Magenta_the_Witchgirl', 'Magenta_the_Witchgirl')
add('Maggot_Boy', 'Maggot_Boy')
add('Magical_Misfits', 'Magical_Misfits')
add('Magicians_Quest', 'Magicians_Quest')
add('Magick', 'magick')
add('Magiversity', 'Magiversity')
add('Maidens_Monsters_and_Madmen_the_Tim_Tyler_sketchbook', 'Maidens_Monsters_and_Madmen_the_Tim_Tyler_sketchbook')
add('Malefic', 'Malefic')
add('Malefic_Tales', 'Malefic_Tales')
add('ManBoys', 'ManBoys')
add('Mario_and_Luigi_Misadventures', 'Mario_and_Luigi_Misadventures')
add('Marios_Day_Job', 'Marios_Day_Job')
add('Marital_Bliss', 'Marital_Bliss')
add('Mask_of_the_Aryans', 'Mask_of_the_Aryans')
add('Master_the_Tiger', 'Master_the_Tiger')
add('Mastorism', 'Mastorism')
add('Matthews_crazy_adventure', 'Matthews_crazy_adventure')
add('Max_Zing', 'Max_Zing')
add('May_the_Rain_Come', 'May_the_Rain_Come')
add('Mayhem_the_Comic', 'Mayhem_the_Comic')
add('Mech_Academy', 'Mech_Academy')
add('MegaNonsense', 'MegaNonsense')
add('Mega_Child_Xtreme', 'Mega_Child_Xtreme')
add('Mega_Maiden_and_the_Chop_Chop_Princess', 'Mega_Maiden_and_the_Chop_Chop_Princess')
add('Megaman_EXE', 'Megaman_EXE')
add('Megaman_Neo_Adventures', 'Megaman_Neo_Adventures')
add('Megaman_The_Megamissions', 'Megaman_The_Megamissions')
add('Megaman_battle_network_continues', 'Megaman_battle_network_continues')
add('Melody_and_Macabre', 'Melody_and_Macabre')
add('Memories_from_Requiem', 'Memories_from_Requiem')
add('Mental_Meltdown', 'Mental_Meltdown')
add('Mercs', 'Mercs')
add('Messenger', 'Messenger')
add('Metal_Breakdown', 'Metal_Breakdown')
add('Metroid_Vengeance', 'Metroid_Vengeance')
add('Metroid_primed', 'metroid_primed')
add('Mildly_mundane', 'Mildly_mundane')
add('Milo_and_John', 'Milo_and_John')
add('Mind_Under_Matter', 'Mind_Under_Matter')
add('Mindmistress_at_Drunk_Duck', 'Mindmistress_at_Drunk_Duck')
add('Minion', 'Minion')
add('Misadventures_of_Classic_MegaMan', 'Misadventures_of_Classic_MegaMan')
add('Misfire_Reactional', 'Misfire_Reactional')
add('Misfits_of_Fandom', 'Misfits_of_Fandom')
add('Mishap_Mania', 'Mishap_Mania')
add('Miss_Grey', 'Miss_Grey')
add('Mixed_Bag_Comics', 'Mixed_Bag_Comics')
add('Mob_Ties', 'Mob_Ties')
add('Modern_Day_Witchdoctor', 'Modern_Day_Witchdoctor')
add('Modest_Medusa', 'Modest_Medusa')
add('Monkey_Pot', 'Monkey_Pot')
add('Monster_Soup', 'Monster_Soup')
add('Moon_Reflected_in_Water', 'Moon_Reflected_in_Water')
add('Moonlight_Doll', 'Moonlight_Doll')
add('Moose_Shoe', 'Moose_Shoe')
add('Morning_Squirtz_lite', 'Morning_Squirtz_lite')
add('Morph_Man_Heir', 'Morph_Man_Heir')
add('Morphic', 'Morphic')
add('Much_the_Millers_Son', 'Much_the_Millers_Son')
add('Murder_in_the_Mushroom_Kingdom', 'Murder_in_the_Mushroom_Kingdom')
add('Muse_of_a_Knight', 'Muse_of_a_Knight')
add('Musical_Farm', 'Musical_Farm')
add('My_Imaginary_Life', 'My_Imaginary_Life')
add('My_Parents_are_Nobodies', 'My_Parents_are_Nobodies')
add('My_Pet_Demon', 'My_Pet_Demon')
add('My_Shining_Knight', 'My_Shining_Knight')
add('My_Sister_The_Demon', 'My_Sister_The_Demon')
add('My_Sister_The_Goddess', 'My_Sister_The_Goddess')
add('My_Sister_prequel_Eclipse', 'My_Sister_prequel_Eclipse')
add('My_Sister_the_Awakening', 'My_Sister_the_Awakening')
add('My_Sister_the_Damned', 'My_Sister_the_Damned')
add('My_Sister_the_Witch_0', 'My_Sister_the_Witch_0')
add('My_TV_is_Evil', 'My_TV_is_Evil')
add('My_Thingie', 'My_Thingie')
add('Myo_Min_Myo', 'Myo_Min_Myo')
add('Mystery_World', 'Mystery_World')
add('Myths_And_Legends', 'Myths_And_Legends')
add('NEC', 'NEC')
add('NPC', 'NPC')
add('NUTS', 'NUTS')
add('N_N_Sp', 'N_N_Sp')
add('Nahim', 'Nahim')
add('Namco_Wars', 'Namco_Wars')
add('Naruto_Blood_Inheritance', 'Naruto_Blood_Inheritance')
add('Naruto_The_Comic', 'Naruto_The_Comic')
add('Necromancer_Troubadour', 'Necromancer_Troubadour')
add('Nectar_of_the_Gods', 'Nectar_of_the_Gods')
add('Negate_Never', 'Negate_Never')
add('Negligence', 'Negligence')
add('Neil_And_Ryan', 'Neil_And_Ryan')
add('Nerdcore', 'Nerdcore')
add('NewGirl', 'NewGirl')
add('New_America', 'New_America')
add('New_Challenger_Approaches', 'New_Challenger_Approaches')
add('New_Jerusalem', 'New_Jerusalem')
add('Newton_the_Newt', 'Newton_the_Newt')
add('Nicola_and_belmondo', 'nicola_and_belmondo')
add('Niego', 'Niego')
add('Nightmistress', 'Nightmistress')
add('Ninjoy', 'Ninjoy')
add('Nintendo_Super_Squad', 'Nintendo_Super_Squad')
add('Nintendo_randomness', 'Nintendo_randomness')
add('Nintendos_Untold_Legends', 'Nintendos_Untold_Legends')
add('No_Capes', 'No_Capes')
add('No_Parking', 'No_Parking')
add('No_Talent', 'No_Talent')
add('Nocturne_21', 'Nocturne_21')
add('Not_Faust', 'Not_Faust')
add('Nothing_Really_Serious', 'Nothing_Really_Serious')
add('Novusgenesis_Hype', 'Novusgenesis_Hype')
add('O_deer', 'O_deer')
add('Obiit', 'Obiit')
add('Oblivion', 'Oblivion')
add('Obnoxious_High', 'Obnoxious_High')
add('Odd_Days', 'Odd_Days')
add('Off_Hours', 'Off_Hours')
add('Off_White', 'Off_White')
add('Oh_Brother_Qlippoth', 'Oh_Brother_Qlippoth')
add('Old_Batman_Comics', 'Old_Batman_Comics')
add('Old_Comic', 'Old_Comic')
add('Old_Pond', 'Old_Pond')
add('Omikami', 'Omikami')
add('One_Piece_Grand_Line_3_point_5', 'One_Piece_Grand_Line_3_point_5')
add('One_Question', 'One_Question')
add('One_Sixth_Sense', 'One_Sixth_Sense')
add('One_last_breath', 'One_last_breath')
add('Operation_blakck_sun', 'operation_blakck_sun')
add('Opey_the_Warhead', 'Opey_the_Warhead')
add('Our_Amazing_Adventures', 'Our_Amazing_Adventures')
add('Out_of_Curiosity', 'Out_of_Curiosity')
add('Outer_Space_Alien_Nazis_From_Outer_Space', 'Outer_Space_Alien_Nazis_From_Outer_Space')
add('Outlawed', 'Outlawed')
add('Overshadow', 'Overshadow')
add('Oyer', 'Oyer')
add('POKETTO_MONSUTAA_SPECIAL_SUPER_EX_ADVENTURE_XXXVX_THE_CHRONICLES_OF_RED_BLUE_GREEN_AND_A_BUNCH_OF_OT', 'POKETTO_MONSUTAA_SPECIAL_SUPER_EX_ADVENTURE_XXXVX_THE_CHRONICLES_OF_RED_BLUE_GREEN_AND_A_BUNCH_OF_OTHER_KIDS_WITH_COLORS_FOR_NAMES')
add('PSI', 'PSI')
add('PUTRID_MEAT', 'PUTRID_MEAT')
add('Pagan_Zoetrope', 'Pagan_Zoetrope')
add('Paint_Heroes', 'Paint_Heroes')
add('Panda_panda', 'Panda_panda')
add('Pandemonium', 'Pandemonium')
add('Paper_Cuts', 'Paper_Cuts')
add('Paranoia_and_Denial', 'Paranoia_and_Denial')
add('Paranormal_Activity', 'Paranormal_Activity')
add('Parody_Paridise', 'Parody_Paridise')
add('Patent_pending', 'patent_pending')
add('Pegwarmers', 'Pegwarmers')
add('Pep_Squad', 'Pep_Squad')
add('Per_Ardua', 'Per_Ardua')
add('Peregrination_of_the_Deliverer', 'Peregrination_of_the_Deliverer')
add('Perpendicular_Universe', 'Perpendicular_Universe')
add('Persona_3_FTW', 'Persona_3_FTW')
add('Persona_4TW', 'Persona_4TW')
add('Persona_Won', 'Persona_Won')
add('Phantasy_Star_Replay', 'Phantasy_Star_Replay')
add('Phayrh', 'Phayrh')
add('Philly', 'Philly')
add('Phineus_Magician_for_Hire', 'Phineus_Magician_for_Hire')
add('Phobophobia', 'Phobophobia')
add('PiLLI__ADVENTURE', 'PiLLI__ADVENTURE')
add('Pinkerton', 'Pinkerton')
add('Pinky_TA', 'Pinky_TA')
add('Pinnacle_of_Evolution', 'Pinnacle_of_Evolution')
add('Pixel_Plumbers', 'Pixel_Plumbers')
add('Pizza_Project', 'Pizza_Project')
add('Planet_B', 'Planet_B')
add('Planet_Chaser', 'Planet_Chaser')
add('Plastic_Bullets', 'Plastic_Bullets')
add('Plumber_Switch_a_rio', 'Plumber_Switch_a_rio')
add('PoKeMoN_HEROES', 'PoKeMoN_HEROES')
add('Poharex_issues_1_to_11', 'Poharex_issues_1_to_11')
add('Pokemon_Contest_Challenge', 'Pokemon_Contest_Challenge')
add('Pokemon_Edge_2009', 'Pokemon_Edge_2009')
add('Pokemon_Granite', 'Pokemon_Granite')
add('Pokemon_Haven', 'Pokemon_Haven')
add('Pokemon_Jade', 'Pokemon_Jade')
add('Pokemon_Light_and_Dark', 'Pokemon_Light_and_Dark')
add('Pokemon_Mystery_Dungeon_Strikedown_Chronicles', 'Pokemon_Mystery_Dungeon_Strikedown_Chronicles')
add('Pokemon_Random_Kanto', 'Pokemon_Random_Kanto')
add('Pokemon_Shroom_Version', 'Pokemon_Shroom_Version')
add('Pokemon_Silver_State_Version', 'Pokemon_Silver_State_Version')
add('Pokemon_Warpers', 'Pokemon_Warpers')
add('Pokemon_Yellow_Comics', 'Pokemon_Yellow_Comics')
add('Politics_The_Tankers_Way', 'Politics_The_Tankers_Way')
add('Ponzi', 'Ponzi')
add('Pools_of_Zara', 'Pools_of_Zara')
add('Powell_and_Derry_Product_', 'Powell_and_Derry_Product_')
add('PowerTrip', 'PowerTrip')
add('Powerup_Adventure', 'Powerup_Adventure')
add('Powerup_Comics', 'Powerup_Comics')
add('Prelude', 'Prelude')
add('Present_Day', 'Present_Day')
add('Princess_Natsumi', 'Princess_Natsumi')
add('Professor_Dolphin_presents_Pokemon', 'Professor_Dolphin_presents_Pokemon')
add('Project_217', 'Project_217')
add('Project_Darklight', 'Project_Darklight')
add('Project_GTH', 'Project_GTH')
add('Project_kokiro', 'project_kokiro')
add('Proto_Culture_Comics', 'Proto_Culture_Comics')
add('Proyecto_GTH', 'Proyecto_GTH')
add('Public_humiliation', 'public_humiliation')
add('Pugnuggle_Tales', 'Pugnuggle_Tales')
add('Pulp_Fantasy', 'Pulp_Fantasy')
add('Pulse_Comics', 'Pulse_Comics')
add('Punk_Pink', 'Punk_Pink')
add('Puppetry', 'Puppetry')
add('Puppets_and_Strings', 'Puppets_and_Strings')
add('Pyroicon', 'pyroicon')
add('QUANTUM_Rock_of_Ages', 'QUANTUM_Rock_of_Ages')
add('Quickening', 'Quickening')
add('REAL_Men_Wear_Lipstick', 'REAL_Men_Wear_Lipstick')
add('RIDDICK_Q_LOSS_TALES', 'RIDDICK_Q_LOSS_TALES')
add('RIOT_and_FadeOut_From_the_Top', 'RIOT_and_FadeOut_From_the_Top')
add('Radio_Active_Rainbows', 'Radio_Active_Rainbows')
add('Raiders_of_The_Lost_Mind', 'Raiders_of_The_Lost_Mind')
add('Raidou_Kuzunoha_the_19th', 'Raidou_Kuzunoha_the_19th')
add('Rain_Of_Gods', 'Rain_Of_Gods')
add('Rainbow_Carousel', 'Rainbow_Carousel')
add('Rainbow_Connection_2', 'Rainbow_Connection_2')
add('Rakina', 'Rakina')
add('Randi', 'Randi')
add('Random_Ramblings', 'Random_Ramblings')
add('Random_Sonic_Stories', 'Random_Sonic_Stories')
add('Random_Street_Theater', 'Random_Street_Theater')
add('Random_anime_fanart_comics', 'random_anime_fanart_comics')
add('Rangetsu', 'Rangetsu')
add('Rasvaar', 'Rasvaar')
add('Raven_Wolf', 'Raven_Wolf')
add('Ravenwood', 'Ravenwood')
add('Raw_Fish', 'Raw_Fish')
add('Razor_Candy', 'Razor_Candy')
add('Rebound', 'Rebound')
add('Reckless_Youth', 'Reckless_Youth')
add('Red_Moon', 'Red_Moon')
add('Red_String', 'Red_String')
add('Redemption_of_Heroes', 'Redemption_of_Heroes')
add('Redneck_Comics', 'Redneck_Comics')
add('Remote_Angel', 'Remote_Angel')
add('Requiem_for_Innocents', 'Requiem_for_Innocents')
add('Requiems_Gate', 'Requiems_Gate')
add('Retake', 'Retake')
add('RiTH', 'RiTH')
add('Riggs_Hell', 'Riggs_Hell')
add('Rileys_notebook', 'Rileys_notebook')
add('Rival_Angels', 'Rival_Angels')
add('Roastytoasty', 'roastytoasty')
add('Robot_Chuck', 'Robot_Chuck')
add('Robot_Wars', 'Robot_Wars')
add('Robukkagenerator', 'Robukkagenerator')
add('Rock_Paper_Cynic', 'Rock_Paper_Cynic')
add('Rocketship_A_GoGo', 'Rocketship_A_GoGo')
add('Rococo_Eternal', 'Rococo_Eternal')
add('Rogue_Agent_Axl', 'Rogue_Agent_Axl')
add('Rogues_of_Clwyd_Rhan', 'Rogues_of_Clwyd_Rhan')
add('Roll_Call', 'Roll_Call')
add('Roll_For_Intelligence', 'Roll_For_Intelligence')
add('Romeo', 'Romeo')
add('Room_Mates', 'Room_Mates')
add('Row_and_Bee', 'Row_and_Bee')
add('Roy_Barley', 'Roy_Barley')
add('Royal_Icing', 'Royal_Icing')
add('Ruby', 'Ruby')
add('Ruby_And_Pipers_World_Of_Magical_Pink_Fearie_Unicorns', 'Ruby_And_Pipers_World_Of_Magical_Pink_Fearie_Unicorns')
add('Rule_of_Three', 'Rule_of_Three')
add('Rules_of_Make_Believe', 'Rules_of_Make_Believe')
add('Rune', 'Rune')
add('Runway', 'Runway')
add('Ryosaki_Uzumaki_1', 'Ryosaki_Uzumaki_1')
add('SECKS', 'SECKS')
add('SHELL', 'SHELL')
add('SOPHIA_Awakening', 'SOPHIA_Awakening')
add('SPOON', 'SPOON')
add('STICKFODDER', 'STICKFODDER')
add('Safety_Man', 'Safety_Man')
add('Sailor_Soldiers_of_Justice', 'Sailor_Soldiers_of_Justice')
add('Saint_Remy', 'Saint_Remy')
add('Salvation_Of_Morrowind', 'Salvation_Of_Morrowind')
add('Satans_Evil_Square', 'Satans_Evil_Square')
add('Saviours_X', 'Saviours_X')
add('ScareCrow_Lullaby', 'ScareCrow_Lullaby')
add('Schadenfreude', 'Schadenfreude')
add('School_Spirit', 'School_Spirit')
add('School_of__Rumble', 'School_of__Rumble')
add('Scorch', 'Scorch')
add('Screwball_Islands', 'Screwball_Islands')
add('Seedy_Comics', 'Seedy_Comics')
add('Senretsu_Gaiden', 'Senretsu_Gaiden')
add('Senshi_Vs_Sentai', 'Senshi_Vs_Sentai')
add('Serai', 'Serai')
add('Seth_the_Hippo', 'Seth_the_Hippo')
add('Shades', 'Shades')
add('Shades_of_Gray', 'Shades_of_Gray')
add('Shades_of_Illusion', 'Shades_of_Illusion')
add('Shadow_Sprinters', 'Shadow_Sprinters')
add('Shaman_Quest', 'Shaman_Quest')
add('Shiny_Things', 'Shiny_Things')
add('Short_Bus', 'Short_Bus')
add('Signifikat', 'signifikat')
add('Silver_Vein', 'Silver_Vein')
add('Simply_sarah', 'simply_sarah')
add('Sinful', 'Sinful')
add('Sire', 'Sire')
add('Sketchy', 'Sketchy')
add('Skewed_Reality_Origins', 'Skewed_Reality_Origins')
add('Skooland', 'Skooland')
add('Slice_of_Life', 'Slice_of_Life')
add('Slugs_of_Mystery', 'Slugs_of_Mystery')
add('Small_Wonder', 'Small_Wonder')
add('Smash_Bros_Royale', 'Smash_Bros_Royale')
add('Smoke_Manmuscle_PI', 'Smoke_Manmuscle_PI')
add('So_Fantastic_Pork_Show_9oCLOCK', 'So_Fantastic_Pork_Show_9oCLOCK')
add('SoapOperaGoneWrong', 'SoapOperaGoneWrong')
add('Soapbox_Hill', 'Soapbox_Hill')
add('Solar_Salvage', 'Solar_Salvage')
add('Something_Else_Anime_Theater', 'Something_Else_Anime_Theater')
add('Something_Like_Life', 'Something_Like_Life')
add('Something_To_Do', 'Something_To_Do')
add('Somewhere_in_San_Fransisco_Half_Way_Beyond_The_Bridge_and_The_Tower_Lies_A_Place_Where_Nothing_is_Ev', 'Somewhere_in_San_Fransisco_Half_Way_Beyond_The_Bridge_and_The_Tower_Lies_A_Place_Where_Nothing_is_Ever_What_It_Seems_On_A_Day_to_Day_Basis_Because_That_Is_What_Happens_in_This_Kinda_Place')
add('Songs_of_An_Angel', 'Songs_of_An_Angel')
add('Sonic_A_Heroes_Tail', 'Sonic_A_Heroes_Tail')
add('Sonic_Advance_The_Real_Story', 'Sonic_Advance_The_Real_Story')
add('Sonic_Adventurz', 'Sonic_Adventurz')
add('Sonic_Bluff', 'Sonic_Bluff')
add('Sonic_College', 'Sonic_College')
add('Sonic_Destination_Chaos', 'Sonic_Destination_Chaos')
add('Sonic_Meets_Megaman', 'Sonic_Meets_Megaman')
add('Sonic_Overdose', 'Sonic_Overdose')
add('Sonic_plus_a_castle', 'Sonic_plus_a_castle')
add('Sonic_the_Hedgehog_in_the_Comic', 'Sonic_the_Hedgehog_in_the_Comic')
add('Soul_Less', 'Soul_Less')
add('Soul_Palisade', 'Soul_Palisade')
add('Soul_Symphony', 'Soul_Symphony')
add('South_Of_Sanity', 'South_Of_Sanity')
add('Spellmon', 'Spellmon')
add('Spitfire', 'Spitfire')
add('Splash_Damage', 'Splash_Damage')
add('Split_Screen', 'Split_Screen')
add('Sprite_Happy_Comic', 'Sprite_Happy_Comic')
add('Sprite_Life___Nineteen_Eternal', 'Sprite_Life___Nineteen_Eternal')
add('Spritely', 'Spritely')
add('St_Dyphnia_Academy', 'St_Dyphnia_Academy')
add('Stafettserien', 'Stafettserien')
add('Star_Crossed_Destiny', 'Star_Crossed_Destiny')
add('Starcrossed', 'Starcrossed')
add('Starfox__Declassified', 'Starfox__Declassified')
add('Startoons_Super_Force', 'Startoons_Super_Force')
add('Starving_Artists', 'Starving_Artists')
add('Status_Update', 'Status_Update')
add('Stellar_Arcana', 'Stellar_Arcana')
add('Stellar_Arcana_Spanish', 'Stellar_Arcana_Spanish')
add('Step_It_Up', 'Step_It_Up')
add('Stick_Figure_Comics', 'Stick_Figure_Comics')
add('Stickman_and_Cube', 'Stickman_and_Cube')
add('Stories_of_Strangeness', 'Stories_of_Strangeness')
add('Story_irc', 'story_irc')
add('Story_of_My_Life', 'Story_of_My_Life')
add('Story_of_a_Robot', 'Story_of_a_Robot')
add('Strange_Attractors', 'Strange_Attractors')
add('Stranger_Things_have_Happened', 'Stranger_Things_have_Happened')
add('Strangers_and_Friends', 'Strangers_and_Friends')
add('Strawberry_Death_Cake', 'Strawberry_Death_Cake')
add('Stupid_machine_comics', 'stupid_machine_comics')
add('Stupidity_in_Magic', 'Stupidity_in_Magic')
add('SubStandard_Comics', 'SubStandard_Comics')
add('Such_A_Simple_Life', 'Such_A_Simple_Life')
add('Such_Is_Life', 'Such_Is_Life')
add('SunSpots', 'SunSpots')
add('Sun_Fish_Moon_Fish', 'Sun_Fish_Moon_Fish')
add('Sune', 'Sune')
add('Sunset_Grill', 'Sunset_Grill')
add('Supahnariobros', 'supahnariobros')
add('Super_Mario_super_comic', 'Super_Mario_super_comic')
add('Super_Smash_Bros_Grand_Tour', 'Super_Smash_Bros_Grand_Tour')
add('Super_Smash_Bros_Royale', 'Super_Smash_Bros_Royale')
add('Super_Temps', 'Super_Temps')
add('Super_Wario_Bros', 'Super_Wario_Bros')
add('Super_smash_bros_omega', 'super_smash_bros_omega')
add('Superior_Day', 'Superior_Day')
add('Supermassive_Black_Hole_A_Star', 'Supermassive_Black_Hole_A_Star')
add('Surviving_Older_Schools', 'Surviving_Older_Schools')
add('Sweet_Dreams', 'Sweet_Dreams')
add('Sword_in_Hand', 'Sword_in_Hand')
add('Sword_of_Heaven', 'Sword_of_Heaven')
add('Syndicate', 'Syndicate')
add('Synthea', 'Synthea')
add('TCCPC', 'TCCPC')
add('THE_RANCAT', 'THE_RANCAT')
add('THRUD_Goddess_Of_Thunder', 'THRUD_Goddess_Of_Thunder')
add('TRUBBLE', 'TRUBBLE')
add('Taint_of_Exile', 'Taint_of_Exile')
add('Taking_Stock', 'Taking_Stock')
add('Tales_of_Kenah', 'Tales_of_Kenah')
add('Tales_of_Magid', 'Tales_of_Magid')
add('Tales_of_The_Sly_Ditt_Inn', 'Tales_of_The_Sly_Ditt_Inn')
add('Team_Kim_Possible', 'Team_Kim_Possible')
add('Tears_will_Shatter_Steel', 'Tears_will_Shatter_Steel')
add('TeenTeam', 'TeenTeam')
add('Teenage_Wasteland', 'Teenage_Wasteland')
add('Tennisball_Man', 'Tennisball_Man')
add('Tera_Forming', 'Tera_Forming')
add('Tern_and_Zebra', 'Tern_and_Zebra')
add('Terror_Of_The_Undead', 'Terror_Of_The_Undead')
add('That_Which_Is_Summoned', 'That_Which_Is_Summoned')
add('Thats_Comical', 'Thats_Comical')
add('The_3rd', 'The_3rd')
add('The_600', 'The_600')
add('The_Adventure_of_the_Goat_Chin_Pirates', 'The_Adventure_of_the_Goat_Chin_Pirates')
add('The_Adventures_Of_Vindibudd_Superhero_In_Training', 'The_Adventures_Of_Vindibudd_Superhero_In_Training')
add('The_Adventures_of_Chad_Cleanly', 'The_Adventures_of_Chad_Cleanly')
add('The_Apocalypse', 'The_Apocalypse')
add('The_Art_of_Joe_Jarin', 'The_Art_of_Joe_Jarin')
add('The_Asim_Stone', 'The_Asim_Stone')
add('The_Author', 'The_Author')
add('The_Authors_Corner', 'The_Authors_Corner')
add('The_Beast_Legion', 'The_Beast_Legion')
add('The_Begining_of_an_End', 'The_Begining_of_an_End')
add('The_Black_Dragons_Chronicles', 'The_Black_Dragons_Chronicles')
add('The_Bluenoser', 'The_Bluenoser')
add('The_Cafe_d_Alizee', 'The_Cafe_d_Alizee')
add('The_Chelation_Kid', 'The_Chelation_Kid')
add('The_Chronicles_of_Gaddick', 'The_Chronicles_of_Gaddick')
add('The_Chronicles_of_Wyrden', 'The_Chronicles_of_Wyrden')
add('The_Compozerz', 'The_Compozerz')
add('The_Continentals', 'The_Continentals')
add('The_Crossroads', 'The_Crossroads')
add('The_Dashing_Rogue', 'The_Dashing_Rogue')
add('The_Death_Pact', 'The_Death_Pact')
add('The_Deed', 'The_Deed')
add('The_Demonic_Adventures_of_Angel_Witch_Pita', 'The_Demonic_Adventures_of_Angel_Witch_Pita')
add('The_Devon_Legacy_Prologue', 'The_Devon_Legacy_Prologue')
add('The_Dragon_Doctors', 'The_Dragon_Doctors')
add('The_Dragon_Fists_of_Smorty_Smythe', 'The_Dragon_Fists_of_Smorty_Smythe')
add('The_Drunk_Duck_Mafia', 'The_Drunk_Duck_Mafia')
add('The_ECS_Strips', 'The_ECS_Strips')
add('The_Emerald_City', 'The_Emerald_City')
add('The_Errant_Apprentice', 'The_Errant_Apprentice')
add('The_Escapists', 'The_Escapists')
add('The_Fabled_Travelers', 'The_Fabled_Travelers')
add('The_Faction', 'The_Faction')
add('The_Fifty_Peso_Ninja', 'The_Fifty_Peso_Ninja')
add('The_Final_Zone', 'The_Final_Zone')
add('The_Garden', 'The_Garden')
add('The_Gimblians', 'The_Gimblians')
add('The_Girl_Next_Door', 'The_Girl_Next_Door')
add('The_Goblin_Apprentice', 'The_Goblin_Apprentice')
add('The_Gods_of_ArrKelaan', 'The_Gods_of_ArrKelaan')
add('The_Godstrain', 'The_Godstrain')
add('The_Greening_Wars', 'The_Greening_Wars')
add('The_Hero_Factor', 'The_Hero_Factor')
add('The_Horribles', 'The_Horribles')
add('The_KAMics', 'The_KAMics')
add('The_Lamp', 'The_Lamp')
add('The_Last_Element', 'The_Last_Element')
add('The_Legends', 'The_Legends')
add('The_Loserz', 'The_Loserz')
add('The_Manual', 'The_Manual')
add('The_Many_Deaths_of_Mario', 'the_Many_Deaths_of_Mario')
add('The_Many_Misfortunes_of_Lady_Luck', 'The_Many_Misfortunes_of_Lady_Luck')
add('The_MatFkkinRix', 'The_MatFkkinRix')
add('The_Mephit_Plot', 'The_Mephit_Plot')
add('The_Mercs', 'The_Mercs')
add('The_Misadventures_of_SuperMilo', 'The_Misadventures_of_SuperMilo')
add('The_Muffinman', 'The_Muffinman')
add('The_Necropolis_Chronicles', 'The_Necropolis_Chronicles')
add('The_Nineteenth_Century_Industrialist', 'The_Nineteenth_Century_Industrialist')
add('The_Nonstandard_Assembly', 'The_Nonstandard_Assembly')
add('The_Omega_Key', 'The_Omega_Key')
add('The_Onett_Suite', 'The_Onett_Suite')
add('The_Only_Half_Saga', 'The_Only_Half_Saga')
add('The_Order_vol_1', 'The_Order_vol_1')
add('The_Panty_Brigade', 'The_Panty_Brigade')
add('The_Path', 'The_Path')
add('The_People_That_Melt_in_The_Rain', 'The_People_That_Melt_in_The_Rain')
add('The_Pirate_Balthasar', 'The_Pirate_Balthasar')
add('The_Planet_Closest_To_Heaven', 'The_Planet_Closest_To_Heaven')
add('The_Portland_Express', 'The_Portland_Express')
add('The_Princess', 'The_Princess')
add('The_Princess_and_the_Giant', 'The_Princess_and_the_Giant')
add('The_Pure_Soul', 'The_Pure_Soul')
add('The_Realms_of_Aegis', 'The_Realms_of_Aegis')
add('The_Reborn', 'The_Reborn')
add('The_Rift', 'The_Rift')
add('The_Rose_Killer', 'The_Rose_Killer')
add('The_Rube_Goldberg_Machine', 'The_Rube_Goldberg_Machine')
add('The_SMW_Chronicles', 'The_SMW_Chronicles')
add('The_Shape_of_the_Heart', 'The_Shape_of_the_Heart')
add('The_Silver_Eye', 'The_Silver_Eye')
add('The_Sok_Comic', 'The_Sok_Comic')
add('The_SuperFogeys', 'The_SuperFogeys')
add('The_Surreal_Adventures_of_Edgar_Allan_Poo', 'The_Surreal_Adventures_of_Edgar_Allan_Poo')
add('The_Symmetrical_Breadpazoid', 'The_Symmetrical_Breadpazoid')
add('The_Tainted', 'The_Tainted')
add('The_Temple_of_a_Thousand_Tears', 'The_Temple_of_a_Thousand_Tears')
add('The_Tonberry_Spritedom', 'The_Tonberry_Spritedom')
add('The_Truth_About_Corey_Strode', 'The_Truth_About_Corey_Strode')
add('The_Uncanny_Uper_Dave', 'The_Uncanny_Uper_Dave')
add('The_Vanguard', 'The_Vanguard')
add('The_WAVAM_Project', 'The_WAVAM_Project')
add('The_World_Robot_Competition', 'The_World_Robot_Competition')
add('The_World_of_Higal', 'The_World_of_Higal')
add('The_Young_Defenders', 'The_Young_Defenders')
add('The__Porch', 'The__Porch')
add('The_hedgehogs', 'the_hedgehogs')
add('The_idiotic_odyssey', 'The_idiotic_odyssey')
add('The_lost_boys_of_hometown', 'The_lost_boys_of_hometown')
add('The_random_archives_of_TJ', 'the_random_archives_of_TJ')
add('The_story_of_Quark', 'The_story_of_Quark')
add('The_world_of_Aeria', 'The_world_of_Aeria')
add('They_Are_Night_Zombies_They_Are_Neighbors_They_Have_Come_Back_From_The_Dead_Ahhhhh', 'They_Are_Night_Zombies_They_Are_Neighbors_They_Have_Come_Back_From_The_Dead_Ahhhhh')
add('This_Ego_of_Mine', 'This_Ego_of_Mine')
add('This_Is_What_I_Do', 'This_Is_What_I_Do')
add('This_is_a_random_comic', 'This_is_a_random_comic')
add('Thog_Infinitron', 'Thog_Infinitron')
add('Thors_Thundershack', 'Thors_Thundershack')
add('Thunder_Roarer', 'Thunder_Roarer')
add('Timed_chaos', 'Timed_chaos')
add('Times_Like_This', 'Times_Like_This')
add('Tiziana', 'Tiziana')
add('Too_Many_Authors', 'Too_Many_Authors')
add('Total_Immersion', 'Total_Immersion')
add('Total_Insanity', 'Total_Insanity')
add('Toy_Story_X', 'Toy_Story_X')
add('Tozzer', 'Tozzer')
add('Trail_Mix', 'Trail_Mix')
add('TransUMan', 'TransUMan')
add('Tri_Noble', 'Tri_Noble')
add('Trinity_Legends_of_Zevera', 'Trinity_Legends_of_Zevera')
add('Triple_Torture', 'Triple_Torture')
add('Troop_37', 'Troop_37')
add('TrueNuff', 'TrueNuff')
add('True_North', 'True_North')
add('True_Power', 'True_Power')
add('Try_Everything_Once', 'Try_Everything_Once')
add('Turner_and_Hercules', 'Turner_and_Hercules')
add('Twenty_Eight', 'Twenty_Eight')
add('Twenty_Four_Seven', 'Twenty_Four_Seven')
add('Twisted_Chronicles', 'Twisted_Chronicles')
add('Twisted_Mind_of_Stranger', 'Twisted_Mind_of_Stranger')
add('Twisted_Mirrors', 'Twisted_Mirrors')
add('TwoMoons', 'TwoMoons')
add('Two_Rooks', 'Two_Rooks')
add('Two_Weeks_Notice', 'Two_Weeks_Notice')
add('Typical_Strange', 'Typical_Strange')
add('UNA_Frontiers_Commentary', 'UNA_Frontiers_Commentary')
add('USB', 'USB')
add('Ultimate_X', 'Ultimate_X')
add('Ultimate_tourny_of_ultimate_fighting', 'Ultimate_tourny_of_ultimate_fighting')
add('Ultranimu', 'Ultranimu')
add('Un_Re_Stop_Comics', 'Un_Re_Stop_Comics')
add('Underscore', 'Underscore')
add('Unfunny_comics', 'Unfunny_comics')
add('Unlife_is_Unfair', 'Unlife_is_Unfair')
add('Unsung_Heroes_Of_Subtlety', 'Unsung_Heroes_Of_Subtlety')
add('Unwanted_Eyes', 'Unwanted_Eyes')
add('Used_Books', 'Used_Books')
add('Utterly_Rucked', 'Utterly_Rucked')
add('VICT0RY', 'VICT0RY')
add('Valentines_Dei', 'Valentines_Dei')
add('Vampire_Phantasm_X', 'Vampire_Phantasm_X')
add('VampyrFetal', 'VampyrFetal')
add('Vanguard', 'Vanguard')
add('Version_2_Fantasy', 'Version_2_Fantasy')
add('Vi_is_Manor', 'Vi_is_Manor')
add('Vic_and_Edwards', 'Vic_and_Edwards')
add('Vice_and_Virtue', 'Vice_and_Virtue')
add('Viera_Dimension', 'Viera_Dimension')
add('Vigil_1to_4', 'Vigil_1to_4')
add('Vile_Withering', 'Vile_Withering')
add('Virtual_reality', 'Virtual_reality')
add('Vita_Di_Vetro', 'Vita_Di_Vetro')
add('Voodoo_Walrus', 'Voodoo_Walrus')
add('Vreakerz', 'Vreakerz')
add('WACOT', 'WACOT')
add('WIRES_2', 'WIRES_2')
add('WTF_Renewed', 'WTF_Renewed')
add('WWE_The_Comic', 'WWE_The_Comic')
add('Wakon_Yosai', 'Wakon_Yosai')
add('Wanted_Dead_or_dead', 'Wanted_Dead_or_dead')
add('WarriorBorn', 'WarriorBorn')
add('Warriors_of_the_night', 'Warriors_of_the_night')
add('Waste_Of_Time', 'Waste_Of_Time')
add('Wasted_Potential', 'Wasted_Potential')
add('WeirdStar', 'WeirdStar')
add('What_The_Fucking_Shit_Fuck_Ass_Fuck_Is_Mario_Gonna_Do_Now', 'What_The_Fucking_Shit_Fuck_Ass_Fuck_Is_Mario_Gonna_Do_Now')
add('What_You_Dont_See', 'What_You_Dont_See')
add('What_errant_beast', 'what_errant_beast')
add('When_Video_Games_Collided', 'When_Video_Games_Collided')
add('Whensdays', 'whensdays')
add('White_Noise', 'White_Noise')
add('Will_And_Tokyo', 'Will_And_Tokyo')
add('Willem', 'Willem')
add('Wintergreen', 'Wintergreen')
add('Witchthorn', 'Witchthorn')
add('With_Friends_like_these', 'With_Friends_like_these')
add('Woah_Roscoe', 'Woah_Roscoe')
add('Wolf', 'Wolf')
add('Working_Stiffs', 'Working_Stiffs')
add('World_of_Orenda', 'World_of_Orenda')
add('Worlds_Apart', 'Worlds_Apart')
add('Wren', 'Wren')
add('Wyyrd_Vintage', 'Wyyrd_Vintage')
add('XAZ_A_Megaman_X_Fancomic', 'XAZ_A_Megaman_X_Fancomic')
add('XAll_Things_Consideredx', 'xAll_Things_Consideredx')
add('XYZ_Identity', 'XYZ_Identity')
add('Xenogenesis', 'Xenogenesis')
add('YO_Comix', 'YO_Comix')
add('Yamase', 'Yamase')
add('Yamete_Kudasai', 'Yamete_Kudasai')
add('Yaoi_Seth', 'Yaoi_Seth')
add('Yeah_wait_what', 'Yeah_wait_what')
add('Yoshi_Saga', 'Yoshi_Saga')
