# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2013 Bastian Kleineidam

from re import compile
from ..scraper import make_scraper
from ..util import tagre
from ..helpers import bounceStarter

_imageSearch = compile(tagre("meta", "content", r'(http://assets\.amuniversal\.com/[0-9a-f]+)', before="og:image"))
_prevSearch = compile(tagre("a", "href", r'(/[^"]+/\d+/\d+/\d+)', after="prev"))
_nextSearch = compile(tagre("a", "href", r'(/[^"]+/\d+/\d+/\d+)', after="next"))

def add(name, shortname):
    baseUrl = 'http://www.gocomics.com'
    url = baseUrl + shortname
    classname = 'GoComics_%s' % name

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        prefix, year, month, day = pageUrl.rsplit('/', 3)
        return "%s_%s%s%s.gif" % (name, year, month, day)

    globals()[classname] = make_scraper(classname,
        url = url,
        starter = bounceStarter(url, _nextSearch),
        name='GoComics/' + name,
        stripUrl=baseUrl + shortname + '/%s',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        help='Index format: yyyy/mm/dd',
        namer=namer,
    )


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('060', '/0-60')
add('2CowsandaChicken', '/2cowsandachicken')
add('9ChickweedLane', '/9chickweedlane')
add('9to5', '/9to5')
add('AdamAtHome', '/adamathome')
add('AdultChildren', '/adult-children')
add('AdventuresofDaisy', '/Adventures-of-Daisy')
add('AdventuresofMartyandTurkey', '/marty-and-turkey')
add('Agnes', '/agnes')
add('AlisonWard', '/alison-ward')
add('AlleyOop', '/alley-oop')
add('AmaZnEvents', '/amaznevents')
add('Andertoons', '/andertoons')
add('Andnow', '/and-now')
add('AndyCapp', '/andycapp')
add('AngryLittleGirls', '/angry-little-girls')
add('AnimalCrackers', '/animalcrackers')
add('Annie', '/annie')
add('AppleCreekComics', '/apple-creek')
add('ArloandJanis', '/arloandjanis')
add('AskShagg', '/askshagg')
add('AuntyAcid', '/aunty-acid')
add('BC', '/bc')
add('BERSERKALERT', '/berserk-alert')
add('BUNS', '/buns')
add('BUSHYTALES', '/bushy-tales')
add('BackintheDay', '/backintheday')
add('BadReporter', '/badreporter')
add('Badlands', '/badlands')
add('Baldo', '/baldo')
add('BallardStreet', '/ballardstreet')
add('BananaTriangle', '/banana-triangle')
add('BarkeaterLake', '/barkeaterlake')
add('BarkingCrayon', '/barking-crayon')
add('BarneyAndClyde', '/barneyandclyde')
add('BasicInstructions', '/basicinstructions')
add('Beardo', '/beardo')
add('Ben', '/ben')
add('BenSargent', '/bensargent')
add('BergerAndWyse', '/berger-and-wyse')
add('BestInShow', '/best-in-show')
add('Betty', '/betty')
add('Bewley', '/bewley')
add('BiffAndRiley', '/biff-and-riley')
add('BigNate', '/bignate')
add('BigTop', '/bigtop')
add('Biographic', '/biographic')
add('Birdbrains', '/birdbrains')
add('Bliss', '/bliss')
add('BloomCounty', '/bloomcounty')
add('BlueSkiesToons', '/blue-skies-toons')
add('Bluebonnets', '/cowsandstuff')
add('BoNanas', '/bonanas')
add('BobGorrell', '/bobgorrell')
add('BobtheSquirrel', '/bobthesquirrel')
add('Boomerangs', '/boomerangs')
add('Bottomliners', '/bottomliners')
add('BoundandGagged', '/boundandgagged')
add('BreakofDay', '/break-of-day')
add('Brevity', '/brevity')
add('BrewsterRockit', '/brewsterrockit')
add('BrilliantMines', '/brilliant-mines')
add('BroomHilda', '/broomhilda')
add('Buni', '/buni')
add('BuzzaWuzza', '/buzza-wuzza')
add('CAFFEINATED', '/CAFFEINATED')
add('CafconLeche', '/cafeconleche')
add('CalvinandHobbes', '/calvinandhobbes')
add('Candorville', '/candorville')
add('CandyPills', '/candy-pills')
add('CaricaturesbyKerryWaghorn', '/facesinthenews')
add('Cartertoons', '/cartertoons')
add('Cathy', '/cathy')
add('CestlaVie', '/cestlavie')
add('ChanLowe', '/chanlowe')
add('CharmysArmy', '/charmy-s-army')
add('CheapThrillsCuisine', '/cheap-thrills-cuisine')
add('ChipBok', '/chipbok')
add('ChrisBritt', '/chrisbritt')
add('ChubbyGirlComics', '/chubbygirlcomics')
add('ChuckAsay', '/chuckasay')
add('ChuckleBros', '/chucklebros')
add('CitizenDog', '/citizendog')
add('Classifudds', '/classifudds')
add('ClayBennett', '/claybennett')
add('Cleats', '/cleats')
add('ClosetoHome', '/closetohome')
add('CockroachComix', '/cockroachcomix')
add('CoffeeShopTidbits', '/coffee-shop-tidbits')
add('Committed', '/committed')
add('Computoon', '/compu-toon')
add('Cornered', '/cornered')
add('Cortoons', '/cortoons')
add('CowSheepandaGnomeNamedHelga', '/cow-sheep-and-a-gnome-named-helga')
add('CowTown', '/cowtown')
add('CowandBoyClassics', '/cowandboy')
add('Crumb', '/crumb')
add('CuldeSac', '/culdesac')
add('DaddysHome', '/daddyshome')
add('DanWasserman', '/danwasserman')
add('DanaSummers', '/danasummers')
add('DarkSideoftheHorse', '/darksideofthehorse')
add('DarrinBell', '/darrin-bell')
add('DevinCraneComicStripGhostwriter', '/devincranecomicstripghostwriter')
add('DialHforHBomb', '/dial-h-for-h-bomb')
add('DiamondLil', '/diamondlil')
add('DickTracy', '/dicktracy')
add('DilbertClassics', '/dilbert-classics')
add('DitzAbledPrincess', '/ditzabled-princess')
add('DixieDrive', '/dixie-drive')
add('DogEatDoug', '/dogeatdoug')
add('DogsofCKennel', '/dogsofckennel')
add('DomesticAbuse', '/domesticabuse')
add('DonkeyLlama', '/donkey-llama')
add('DontPicktheFlowers', '/dont-pick-the-flowers')
add('DoodleDaysComics', '/doodle-days')
add('Doonesbury', '/doonesbury')
add('Drabble', '/drabble')
add('Dragin', '/dragin')
add('DrewLitton', '/drewlitton')
add('DrewSheneman', '/drewsheneman')
add('Dromo', '/dro-mo')
add('DudeandDude', '/dudedude')
add('DumbQuestionBadAnswer', '/dumb-question-bad-answer')
add('DustSpecks', '/dust-specks')
add('EBEJeebie', '/ebe-jeebie')
add('Econogirl', '/econogirl')
add('Eek', '/eek')
add('Elmo', '/elmo')
add('EmmyLou', '/emmy-lou')
add('Endtown', '/endtown')
add('EngagAndNevets', '/engag-nevets')
add('ErictheCircle', '/eric-the-circle')
add('EspressoCity', '/Espresso-City')
add('EttoreandBaldo', '/ettore-and-baldo')
add('FMinus', '/fminus')
add('FamilyTree', '/familytree')
add('FantasticMegaLeague', '/fantastiteam')
add('FarcesofNature', '/Farces-of-Nature')
add('Farcus', '/farcus')
add('FatCats', '/fat-cats')
add('Featherweight', '/featherweight')
add('FloandFriends', '/floandfriends')
add('FoolishMortals', '/foolish-mortals')
add('ForBetterorForWorse', '/forbetterorforworse')
add('ForHeavensSake', '/forheavenssake')
add('FortKnox', '/fortknox')
add('FourEyes', '/four-eyes')
add('FoxTrot', '/foxtrot')
add('FoxTrotClassics', '/foxtrotclassics')
add('FrankAndErnest', '/frankandernest')
add('FrankAndSteinway', '/frank-and-steinway')
add('FrankBlunt', '/frankblunt')
add('Frazz', '/frazz')
add('FredBasset', '/fredbasset')
add('FreeRange', '/freerange')
add('FreshlySqueezed', '/freshlysqueezed')
add('FrizziToons', '/frizzitoons')
add('FrogApplause', '/frogapplause')
add('GIRTH', '/--G-I-R-T-H--')
add('Garfield', '/garfield')
add('GarfieldMinusGarfield', '/garfieldminusgarfield')
add('GaryMarkstein', '/garymarkstein')
add('GaryVarvel', '/garyvarvel')
add('GasolineAlley', '/gasolinealley')
add('Geech', '/geech')
add('GentleCreatures', '/gentle-creatures')
add('GetAGrip', '/get-a-grip')
add('GetFuzzy', '/getfuzzy')
add('GetaLife', '/getalife')
add('GilThorp', '/gilthorp')
add('GingerMeggs', '/gingermeggs')
add('GlennMcCoy', '/glennmccoy')
add('GoComicsontheRoad', '/gocomics-on-the-road')
add('Graffiti', '/graffiti')
add('GrandAvenue', '/grand-avenue')
add('GrannyAnny', '/granny-anny')
add('GrayMatters', '/gray-matters')
add('GreenPieces', '/green-pieces')
add('GunstonStreet', '/gunston-street')
add('HIP', '/hip')
add('HUBRIS', '/hubris')
add('HaikuEwe', '/haikuewe')
add('HalfFull', '/half-full')
add('HamShears', '/ham-shears')
add('HanginOut', '/hangin-out')
add('HankandDalesOurWorld', '/hank-and-dales-our-world')
add('HanktheSock', '/hank-the-sock')
add('HarambeeHills', '/harambeehills')
add('Hbenson7', '/hbenson7')
add('HealthCapsules', '/healthcapsules')
add('HeartoftheCity', '/heartofthecity')
add('Heathcliff', '/heathcliff')
add('HeavenlyNostrils', '/heavenly-nostrils')
add('HenryPayne', '/henrypayne')
add('HerbandJamaal', '/herbandjamaal')
add('Herman', '/herman')
add('HolySchnark', '/holy-schnark!')
add('HomeandAway', '/homeandaway')
add('HoodootheUnwiseOwl', '/hoodootheunwiseowl')
add('HumanCull', '/human-cull')
add('Humoresque', '/humoresque ')
add('HutchOwen', '/hutch-owen')
add('ImaDillo', '/i-m-a-dillo')
add('ImagineThis', '/imaginethis')
add('InTheSandbox', '/inthesandbox')
add('IncidentalComics', '/incidentalcomics')
add('InherittheMirth', '/inherit-the-mirth')
add('InkPen', '/inkpen')
add('Inkytown', '/inkytown')
add('InspectorDangersCrimeQuiz', '/inspector-dangers-crime-quiz')
add('IntheBleachers', '/inthebleachers')
add('IntheSticks', '/inthesticks')
add('InvisibleBread', '/invisible-bread')
add('ItsAllAboutYou', '/itsallaboutyou')
add('JackOhman', '/jackohman')
add('JackRadioComics', '/jack-radio-comics')
add('JanesWorld', '/janesworld')
add('JeffDanziger', '/jeffdanziger')
add('JeffStahler', '/jeffstahler')
add('JenSorensen', '/jen-sorensen')
add('JerryHolbert', '/jerryholbert')
add('JillpokeBohemia', '/jillpoke-bohemia')
add('JimMorin', '/jimmorin')
add('JimsJournal', '/jimsjournal')
add('JoeHeller', '/joe-heller')
add('JoeVanilla', '/joevanilla')
add('JoelPett', '/joelpett')
add('JohnDeering', '/johndeering')
add('JumpStart', '/jumpstart')
add('JustPosted', '/just-posted')
add('JustSayUncle', '/just-say-uncle')
add('KatetheGreat', '/kate-the-great')
add('KenCatalino', '/kencatalino')
add('KevinKallaugher', '/kevinkallaugher')
add('KidSpot', '/kidspot')
add('KidTown', '/kidtown')
add('KitNCarlyle', '/kitandcarlyle')
add('KitchenCapers', '/kitchen-capers')
add('Kliban', '/kliban')
add('KlibansCats', '/klibans-cats')
add('KozmooftheCosmos', '/kozmoofthecosmos')
add('LaCucaracha', '/lacucaracha')
add('LaloAlcaraz', '/laloalcaraz')
add('LarryvilleBlue', '/larryville-blue')
add('LastKiss', '/lastkiss')
add('LeGooseyLu', '/LeGoosey-Lu')
add('Leadbellies', '/leadbellies')
add('LegendofBill', '/legendofbill')
add('LibertyMeadows', '/libertymeadows')
add('LilAbner', '/lil-abner')
add('Lio', '/lio')
add('LisaBenson', '/lisabenson')
add('LittleDogLost', '/littledoglost')
add('Lola', '/lola')
add('LooseParts', '/looseparts')
add('LostInTranslation', '/lost-in-translation')
add('LostSheep', '/lostsheep')
add('LostSideofSuburbia', '/lostsideofsuburbia')
add('Luann', '/luann')
add('LuannAgainn', '/luann-againn')
add('Lucan', '/lucan')
add('LucasLuminous', '/lucas-luminous')
add('LuckyCow', '/luckycow')
add('LumandAbner', '/lum-and-abner')
add('Mac', '/mac')
add('MagicinaMinute', '/magicinaminute')
add('Maintaining', '/maintaining')
add('MakingIt', '/making-it')
add('MariasDay', '/marias-day')
add('Markonpaper', '/mark-on-paper')
add('Marmaduke', '/marmaduke')
add('MarshallRamsey', '/marshallramsey')
add('MartyandSpud', '/marty-and-spud')
add('MaryBWary', '/mary-b-wary')
add('MattBors', '/matt-bors')
add('MattDavies', '/mattdavies')
add('MattWuerker', '/mattwuerker')
add('McArroni', '/mcarroni')
add('MediumLarge', '/medium-large')
add('MegClassics', '/meg-classics')
add('MichaelRamirez', '/michaelramirez')
add('MikeLester', '/mike-lester')
add('MikeLuckovich', '/mikeluckovich')
add('MikeThompson', '/mikethompson')
add('MikeduJour', '/mike-du-jour')
add('Milton50', '/milton-5-0')
add('Mindframe', '/mindframe')
add('MinimumSecurity', '/minimumsecurity')
add('MiscSoup', '/misc-soup')
add('MixedMedications', '/mixedmedications')
add('ModeratelyConfused', '/moderately-confused')
add('MollyandtheBear', '/mollyandthebear')
add('Momma', '/momma')
add('Monty', '/monty')
add('MortMonday', '/mort-monday')
add('MortsIsland', '/noahs-island')
add('MotleyClassics', '/motley-classics')
add('MrGigiandtheSquid', '/mr-gigi-and-the-squid')
add('MrMorris', '/mr-morris')
add('Mulligan', '/mulligan')
add('MustardandBoloney', '/mustard-and-boloney')
add('MuttAndJeff', '/muttandjeff')
add('MyCage', '/mycage')
add('MyGuardianGrandpa', '/my-guardian-grandpa')
add('MythTickle', '/mythtickle')
add('NEUROTICA', '/neurotica')
add('Nancy', '/nancy')
add('NavyBean', '/navybean')
add('NeatStep', '/neatstep')
add('NedAndLarry', '/ned-and-larry')
add('NeighborhoodZone', '/neightborhood-zone')
add('NestHeads', '/nestheads')
add('NewAdventuresofQueenVictoria', '/thenewadventuresofqueenvictoria')
add('NickAnderson', '/nickanderson')
add('NickandZuzu', '/nick-and-zuzu')
add('NoOrdinaryLife', '/no-ordinary-life')
add('NoPlaceLikeHolmes', '/no-place-like-holmes')
add('NobodysHome', '/nobodys-home')
add('NonSequitur', '/nonsequitur')
add('Norman', '/Norman')
add('NothingisNotSomething', '/nothing-is-not-something')
add('ONIONAndPEA', '/onion-and-pea')
add('Oat', '/oat')
add('OfftheMark', '/offthemark')
add('OllieandQuentin', '/ollie-and-quentin')
add('OnAClaireDay', '/onaclaireday')
add('OneBigHappy', '/onebighappy')
add('OntheQuad', '/on-the-quad')
add('OrangesareFunny', '/oranges-are-funny')
add('OrdinaryBill', '/ordinary-bill')
add('OriginsoftheSundayComics', '/origins-of-the-sunday-comics')
add('OutoftheGenePoolReRuns', '/outofthegenepool')
add('Overboard', '/overboard')
add('OvertheHedge', '/overthehedge')
add('OzyandMillie', '/ozy-and-millie')
add('PCandPixel', '/pcandpixel')
add('PaddedCell', '/padded-cell')
add('ParisDoodles', '/mo-willems-paris-doodles')
add('PatOliphant', '/patoliphant')
add('PaulSzep', '/paulszep')
add('Peanizles', '/peanizles')
add('Peanuts', '/peanuts')
add('PearlsBeforeSwine', '/pearlsbeforeswine')
add('PetFood', '/pet-food')
add('PhilHands', '/phil-hands')
add('Pibgorn', '/pibgorn')
add('PibgornSketches', '/pibgornsketches')
add('Pickles', '/pickles')
add('Pinkerton', '/pinkerton')
add('PlanB', '/planb')
add('PlasticBabyHeadsfromOuterSpace', '/plastic-babyheads')
add('PlentyofPenguins', '/plenty-of-penguins')
add('Pluggers', '/pluggers')
add('PoliceLimit', '/policelimit')
add('PoochCafe', '/poochcafe')
add('PoorlyDrawnLines', '/poorly-drawn-lines')
add('PreTeena', '/preteena')
add('PricklyCity', '/pricklycity')
add('Putz', '/putz')
add('RabbitsAgainstMagic', '/rabbitsagainstmagic')
add('RaisingDuncan', '/raising-duncan')
add('RandolphItch2am', '/randolphitch')
add('RealLifeAdventures', '/reallifeadventures')
add('RealityCheck', '/realitycheck')
add('RedMeat', '/redmeat')
add('RedandRover', '/redandrover')
add('ReplyAll', '/replyall')
add('ReplyAllLite', '/reply-all-lite')
add('RicigsToonTrivia', '/ricigs-toon-trivia')
add('RipHaywire', '/riphaywire')
add('RipleysBelieveItorNot', '/ripleysbelieveitornot')
add('RobRogers', '/robrogers')
add('RobbieandBobby', '/robbie-and-bobby')
add('RobertAriail', '/robert-ariail')
add('RogueSymmetry', '/rogue_symmetry')
add('RonWarren', '/ron-warren')
add('RoseisRose', '/roseisrose')
add('Rubes', '/rubes')
add('RudyPark', '/rudypark')
add('STEPDAD', '/stepdad')
add('Sabine', '/sabine')
add('SavageChickens', '/savage-chickens')
add('ScairyTalesthenotsoscaryfairytales', '/Scairy-Tales:-the-not-so-scary-fairy-tales!')
add('ScaryGary', '/scarygary')
add('ScottStantis', '/scottstantis')
add('SecondPrize', '/secondprize')
add('ShirleyandSonClassics', '/shirley-and-son-classics')
add('Shoe', '/shoe')
add('Shoecabbage', '/shoecabbage')
add('Shortcuts', '/shortcuts')
add('SignGarden', '/signgarden')
add('SigneWilkinson', '/signewilkinson')
add('SkinHorse', '/skinhorse')
add('Skippy', '/skippy')
add('Skooled', '/skooled')
add('SleepytownBeagles', '/sleepytown-beagles')
add('Smith', '/smith')
add('SnowSez', '/snowsez')
add('SoccerEarth', '/soccer-earth')
add('SookyRottweiler', '/sooky-rottweiler')
add('SouptoNutz', '/soup-to-nutz')
add('SpaceNutz', '/space-nutz')
add('SpeedBump', '/speedbump')
add('SportsbyVoort', '/sports-by-voort')
add('SpottheFrog', '/spot-the-frog')
add('StankoAndTibor', '/stankotibor')
add('Starslip', '/starslip')
add('SteveBenson', '/stevebenson')
add('SteveBreen', '/stevebreen')
add('SteveKelley', '/stevekelley')
add('StoneSoup', '/stonesoup')
add('Stookie', '/Stookie')
add('StrangeBrew', '/strangebrew')
add('StuartCarlson', '/stuartcarlson')
add('SubSub', '/subsub')
add('SuburbanFairyTales', '/suburban-fairy-tales')
add('SuburbanWilderness', '/suburban-wilderness')
add('SuckerHeadSmack', '/suckerhead-smack')
add('SunnyStreet', '/sunny-street')
add('SuperSiblings', '/super-siblings')
add('Sylvia', '/sylvia')
add('THESILVERLINING', '/silver-lining')
add('TOBY', '/toby')
add('TOWHOMITMAYCONCERN', '/towhomitmayconcern')
add('TankMcNamara', '/tankmcnamara')
add('Tarzan', '/tarzan')
add('TedRall', '/tedrall')
add('TenCats', '/ten-cats')
add('ThatMonkeyTune', '/that-monkey-tune')
add('ThatNewCarlSmell', '/that-new-carl-smell')
add('Thatababy', '/thatababy')
add('ThatisPriceless', '/that-is-priceless')
add('ThatsLife', '/thats-life')
add('TheAcademiaWaltz', '/academiawaltz')
add('TheArgyleSweater', '/theargylesweater')
add('TheBarn', '/thebarn')
add('TheBentPinky', '/the-bent-pinky')
add('TheBigPicture', '/thebigpicture')
add('TheBoobiehatch', '/the-boobiehatch')
add('TheBoondocks', '/boondocks')
add('TheBornLoser', '/the-born-loser')
add('TheBuckets', '/thebuckets')
add('TheCardinal', '/thecardinal')
add('TheCity', '/thecity')
add('TheCreeps', '/the-creeps')
add('TheDinetteSet', '/dinetteset')
add('TheDoozies', '/thedoozies')
add('TheDuplex', '/duplex')
add('TheElderberries', '/theelderberries')
add('TheFlyingMcCoys', '/theflyingmccoys')
add('TheFuscoBrothers', '/thefuscobrothers')
add('TheGoldenKid', '/golden-kid')
add('TheGreenMonkeys', '/thegreenmonkeys')
add('TheGrizzwells', '/thegrizzwells')
add('TheHumbleStumble', '/humble-stumble')
add('TheInsolentLemon', '/the-insolent-lemon')
add('TheKChronicles', '/thekchronicles')
add('TheKnightLife', '/theknightlife')
add('TheLeftyBoscoPictureShow', '/leftyboscopictureshow')
add('TheLilMiesters', '/the-lil-miesters')
add('TheLostBear', '/the-lost-bear')
add('TheMeaningofLila', '/meaningoflila')
add('TheMiddletons', '/themiddletons')
add('TheMightyWonderBrat', '/mighty-wonderbrat')
add('TheNormClassics', '/thenorm')
add('TheOdderLimits', '/the-odder-limits')
add('TheOldManAndHisDog', '/old-man-and-his-dog')
add('TheOtherCoast', '/theothercoast')
add('TheQuinnAndFinnShow', '/quinn-and-finn')
add('TheSingleDadDiaries', '/single-dad-diaries')
add('TheSunshineClub', '/the-sunshine-club')
add('TheVernalPool', '/vernal-pool')
add('TheWorstThingIveEverDone', '/the-worst-thing-ive-ever-done')
add('ThinLines', '/thinlines')
add('Thingsesque', '/thingsesque')
add('Think', '/think')
add('ThrompTM', '/thromp')
add('TimEagan', '/tim-eagan')
add('TinySepuku', '/tinysepuku')
add('ToBeNamed', '/to-be-named')
add('TodaysDogg', '/todays-dogg')
add('TomToles', '/tomtoles')
add('TomtheDancingBug', '/tomthedancingbug')
add('TonyAuth', '/tonyauth')
add('TooMuchCoffeeMan', '/toomuchcoffeeman')
add('Toocrazy', '/too-crazy')
add('Trivquiz', '/trivquiz')
add('Twaggies', '/twaggies')
add('TwoBits', '/two-bits')
add('USAcres', '/us-acres')
add('UncleArtsFunland', '/uncleartsfunland')
add('UnstrangePhenomena', '/unstrange-phenomena')
add('Vernscartoons', '/vernscartoons')
add('ViewsAfrica', '/viewsafrica')
add('ViewsAmerica', '/viewsamerica')
add('ViewsAsia', '/viewsasia')
add('ViewsBusiness', '/viewsbusiness')
add('ViewsEurope', '/viewseurope')
add('ViewsLatinAmerica', '/viewslatinamerica')
add('ViewsMidEast', '/viewsmideast')
add('ViewsoftheWorld', '/viewsoftheworld')
add('ViiviAndWagner', '/viivi-and-wagner')
add('WTDuck', '/wtduck')
add('WaltHandelsman', '/walthandelsman')
add('WatchYourHead', '/watchyourhead')
add('WayOutInLeftField', '/Way-Out-In-Left-Field')
add('WeePals', '/weepals')
add('WendlesLife', '/wendleslife')
add('WhiskeyFalls', '/whiskey-falls')
add('WitoftheWorld', '/witoftheworld')
add('WizardofId', '/wizardofid')
add('Wordless', '/wordless')
add('WorkingDaze', '/working-daze')
add('WorkingItOut', '/workingitout')
add('WuMo', '/wumo')
add('ZacharyNixonJohnson', '/zachary-nixon-johnson')
add('ZackHill', '/zackhill')
add('ZenPencils', '/zen-pencils')
add('Ziggy', '/ziggy')
