/*
    DrMIPS - Educational MIPS simulator
    Copyright (C) 2013-2014 Bruno Nova <ei08109@fe.up.pt>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

package org.feup.brunonova.drmips.gui;

import org.feup.brunonova.drmips.simulator.AppInfo;

/**
 *
 * @author bruno
 */
public class DlgLoading extends javax.swing.JDialog {

	/**
	 * Creates new form DlgLoading
	 */
	public DlgLoading() {
		initComponents();
	}
	
	/**
	 * Updates the text on the progress bar.
	 * @param text New text.
	 */
	public void setProgressBarText(String text) {
		pbLoading.setString(text);
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblIcon = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        pbLoading = new javax.swing.JProgressBar();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(AppInfo.NAME);
        setMinimumSize(new java.awt.Dimension(300, 150));
        setUndecorated(true);
        getContentPane().setLayout(new java.awt.BorderLayout(5, 5));

        lblIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/res/icons/x96/drmips.png"))); // NOI18N
        getContentPane().add(lblIcon, java.awt.BorderLayout.NORTH);

        lblName.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblName.setText(AppInfo.NAME + " " + AppInfo.VERSION);
        getContentPane().add(lblName, java.awt.BorderLayout.CENTER);

        pbLoading.setIndeterminate(true);
        pbLoading.setString("Loading...");
        pbLoading.setStringPainted(true);
        getContentPane().add(pbLoading, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblIcon;
    private javax.swing.JLabel lblName;
    private javax.swing.JProgressBar pbLoading;
    // End of variables declaration//GEN-END:variables
}
