
DUNE_DEBIAN_DUNECONTROL ?= /usr/bin/dunecontrol
DUNE_DEBIAN_CONFIGURE_FLAGS ?= \
	--enable-parallel \
	--enable-shared \
	--with-alberta=/usr \
	--with-gmp \
	--without-grape \
	--without-metis \
	--without-parmetis \
	--with-superlu \
	--with-ug=/usr \
	--without-x

override_dh_auto_configure:
	$(DUNE_DEBIAN_DUNECONTROL) autogen
	dh_auto_configure -- $(DUNE_DEBIAN_CONFIGURE_FLAGS)

override_dh_auto_test:
	# OpenMPI expects rsh/ssh to be in PATH even when it only starts local processes:
	mkdir debian/tmp-test
	ln -s /bin/false debian/tmp-test/ssh
	ln -s /bin/false debian/tmp-test/rsh
	PATH=$(CURDIR)/debian/tmp-test:$$PATH dh_auto_test
	rm -rf debian/tmp-test

override_dh_clean:
	dh_clean
	find . -name Makefile.in -delete
	rm -f aclocal.m4 compile config.guess config.h.in config.sub configure dependencies.m4 depcomp install-sh ltmain.sh missing test-driver
	rm -rf doc/doxygen/Doxyfile.in doc/doxygen/doxyerr.log doc/doxygen/doxygen-tag doc/doxygen/doxygen.log doc/doxygen/html
	rm -rf debian/tmp-test
