#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <emscripten.h>

int main() {
  EM_ASM(
    FS.writeFile('/forbidden', ''); FS.chmod('/forbidden', 0000);
    FS.writeFile('/readable',  ''); FS.chmod('/readable',  0444);
    FS.writeFile('/writeable', ''); FS.chmod('/writeable', 0222);
    FS.writeFile('/allaccess', ''); FS.chmod('/allaccess', 0777);
  );

  char* files[] = {"/readable", "/writeable",
                   "/allaccess", "/forbidden", "/nonexistent"};
  for (int i = 0; i < sizeof files / sizeof files[0]; i++) {
    printf("F_OK(%s): %d\n", files[i], access(files[i], F_OK));
    printf("errno: %d\n", errno);
    errno = 0;
    printf("R_OK(%s): %d\n", files[i], access(files[i], R_OK));
    printf("errno: %d\n", errno);
    errno = 0;
    printf("X_OK(%s): %d\n", files[i], access(files[i], X_OK));
    printf("errno: %d\n", errno);
    errno = 0;
    printf("W_OK(%s): %d\n", files[i], access(files[i], W_OK));
    printf("errno: %d\n", errno);
    errno = 0;
    printf("\n");
  }
  return 0;
}
