/*___INFO__MARK_BEGIN__*/
/*************************************************************************
 *
 *  The Contents of this file are made available subject to the terms of
 *  the Sun Industry Standards Source License Version 1.2
 *
 *  Sun Microsystems Inc., March, 2001
 *
 *
 *  Sun Industry Standards Source License Version 1.2
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.2 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://gridengine.sunsource.net/Gridengine_SISSL_license.html
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *   The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *   Copyright: 2001 by Sun Microsystems, Inc.
 *
 *   All Rights Reserved.
 *
 ************************************************************************/
/*___INFO__MARK_END__*/
/**
 *  Generated from java_mapping.jsp
 *  !!! DO NOT EDIT THIS FILE !!!
 */
<%
  com.sun.grid.cull.JavaHelper jh = (com.sun.grid.cull.JavaHelper)params.get("javaHelper");
  com.sun.grid.cull.CullDefinition cullDef = (com.sun.grid.cull.CullDefinition)params.get("cullDef");
  
%>
package com.sun.grid.jgdi.configuration.reflect;

import java.util.Map;
import java.util.HashMap;

/**
 *  This class provides the mapping from cull type to its java classes
 */
public class CullTypeMapping {
   
   private static Map<String, Class> typeMap;
   
   private static void reg(String cullType, Class clazz) {
      typeMap.put(cullType, clazz);
   }
   
   private static void init() {
      if (typeMap == null) {
        synchronized(CullTypeMapping.class) {
           if (typeMap == null ) {
               typeMap = new HashMap<String, Class>();
<%  for (String name : cullDef.getObjectNames()) {
      com.sun.grid.cull.CullObject cullObj = cullDef.getCullObject(name);       
%>              reg("<%=name%>", <%=jh.getFullClassName(cullObj)%>.class);   
<% 
    } // end of for 
%>
            }
         }
      }
   }
   
   /**
    *   Get the java class which represents a cull type
    *   @param  cullType  name of the cull type
    *   @return the java class
    *   @throws IllegalArgumentException if the cull type is unknown
    */
   public static Class getClassForCullType(String cullType) {
      init();
      Class ret = typeMap.get(cullType);
      if (ret == null) {
         throw new IllegalArgumentException("Unknown cull type '" + cullType + "'");
      }
      return ret;
   }
}
