/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.util.ArrayList;

/**
 * This class is for unit testing the Element class.
 *
 * @see Element
 * @author Elias Ross
 * @version 1.0
 */
public class ElementTest
	extends junit.framework.TestCase
{
	public ElementTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ElementTest.class);
	}

	public void testInit() {
		String name = "name";
		Element e = new Element(name);
		assertEquals("type is ELEMENT_NODE", Node.ELEMENT_NODE, e.getNodeType());
		assertEquals("isOpen default ", true, e.isOpen());
		assertEquals("children default ", null, e.getChildNodes());
		assertEquals("children get ", null, e.getChild(0));
		e.clearChildren();
		assertEquals("children clear ", null, e.getChildNodes());
		assertTrue("name node", e.toString().startsWith("<name></name>"));
	}

	public void testClosed() {
		String name = "name";
		Element e = new Element(name, null, false);
		assertEquals("type is ELEMENT_NODE", Node.ELEMENT_NODE, e.getNodeType());
		assertEquals("isOpen ", false, e.isOpen());
		try {
			e.appendChild(new Element("whatever"));
			fail("cannot append");
		} catch (ElementException ee) {
		}
		assertEquals("children default ", null, e.getChildNodes());
		assertEquals("children get ", null, e.getChild(0));
		assertEquals("children clear ", null, e.getChildNodes());
		assertTrue("name node", "<name/>".equals(e.toString()));
	}

	public void testAttr() {
		ArrayList al = new ArrayList();
		al.add(new Attribute("name", "value"));
		al.add(new Attribute("name2", "value2"));
		Element e = new Element("name", al, false);
		assertEquals("attr", al, e.getAttributes());
		assertEquals("value", "value", e.getAttValue("name", null));
		assertEquals("value2", "value2", e.getAttValue("name2", null));
		assertEquals("no", null, e.getAttValue("no", null));
		assertEquals("no", "a", e.getAttValue("no", "a"));
	}
	public void testElement() {
		Element e = new Element("name");
		Element a = new Element("a");
		Element b = new Element("b");
		Comment c = new Comment();
		PI i = new PI("php");
		e.appendChild(c);
		e.appendChild(a);
		e.appendChild(i);
		e.appendChild(b);
		assertEquals("a", a, e.getChildElement(0));
		assertEquals("a", a, e.getChild(1));
		assertEquals("b", b, e.getChildElement(1));
		assertEquals("b", b, e.getChild(3));
	}
}
