/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp.util;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatchEnumeration;
import gnu.regexp.RESyntax;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.io.Serializable;

public class REApplet
extends Applet {
    private static String[] names = new String[]{"awk", "ed", "egrep", "emacs", "grep", "POSIX awk", "POSIX basic", "POSIX egrep", "POSIX extended", "POSIX minimal basic", "POSIX minimal extended", "sed", "perl 4", "perl 4 (singe line)", "perl 5", "perl 5 (single line)"};
    private static RESyntax[] values = new RESyntax[]{new RESyntax(RESyntax.RE_SYNTAX_AWK).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_ED).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_EGREP).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_EMACS).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_GREP).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_POSIX_AWK).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_POSIX_BASIC).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_POSIX_EGREP).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_POSIX_EXTENDED).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_POSIX_MINIMAL_BASIC).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_POSIX_MINIMAL_EXTENDED).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_SED).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_PERL4).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_PERL4_S).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_PERL5).setLineSeparator("\n"), new RESyntax(RESyntax.RE_SYNTAX_PERL5_S).setLineSeparator("\n")};
    private Label l1;
    private Label l2;
    private Label l3;
    private Label l4;
    private Button b;
    private TextField tf;
    private TextArea input;
    private TextArea output;
    private Checkbox insens;
    private Choice syntax;

    public void init() {
        Serializable serializable;
        Serializable serializable2;
        try {
            serializable2 = new RE("^.*(w[x])\u0001$");
            serializable = ((RE)serializable2).getMatchEnumeration("wxwx");
            while (serializable.hasMoreMatches()) {
                serializable.nextMatch().toString();
            }
        }
        catch (REException rEException) {
            // empty catch block
        }
        this.setBackground(Color.lightGray);
        serializable2 = new GridBagLayout();
        this.setLayout((LayoutManager)((Object)serializable2));
        serializable = new GridBagConstraints();
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        this.l1 = new Label("Regular Expression");
        gridBagLayout.setConstraints(this.l1, (GridBagConstraints)serializable);
        panel.add(this.l1);
        ((GridBagConstraints)serializable).gridx = 1;
        this.tf = new TextField(this.getParameter("regexp"), 30);
        gridBagLayout.setConstraints(this.tf, (GridBagConstraints)serializable);
        panel.add(this.tf);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        this.l4 = new Label("Expression Syntax");
        gridBagLayout.setConstraints(this.l4, (GridBagConstraints)serializable);
        panel.add(this.l4);
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        panel2.setLayout(gridBagLayout2);
        ((GridBagConstraints)serializable).gridx = 1;
        gridBagLayout.setConstraints(panel2, (GridBagConstraints)serializable);
        panel.add(panel2);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        this.syntax = new Choice();
        int n = 0;
        while (n < names.length) {
            this.syntax.addItem(names[n]);
            ++n;
        }
        String string = this.getParameter("syntax");
        if (string != null) {
            try {
                this.syntax.select(this.getParameter("syntax"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        gridBagLayout2.setConstraints(this.syntax, (GridBagConstraints)serializable);
        panel2.add(this.syntax);
        ((GridBagConstraints)serializable).gridx = 1;
        this.insens = new Checkbox("Ignore case", false);
        gridBagLayout2.setConstraints(this.insens, (GridBagConstraints)serializable);
        panel2.add(this.insens);
        ((GridBagConstraints)serializable).gridx = 1;
        ((GridBagConstraints)serializable).gridy = 2;
        this.b = new Button("Match");
        gridBagLayout.setConstraints(this.b, (GridBagConstraints)serializable);
        panel.add(this.b);
        ((GridBagConstraints)serializable).gridwidth = 2;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).anchor = 10;
        ((GridBagLayout)serializable2).setConstraints(panel, (GridBagConstraints)serializable);
        this.add(panel);
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        this.l2 = new Label("Input Text");
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagLayout)serializable2).setConstraints(this.l2, (GridBagConstraints)serializable);
        this.add(this.l2);
        this.l3 = new Label("Matches Found");
        ((GridBagConstraints)serializable).gridx = 1;
        ((GridBagLayout)serializable2).setConstraints(this.l3, (GridBagConstraints)serializable);
        this.add(this.l3);
        this.input = new TextArea(this.getParameter("input"), 5, 30);
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 2;
        ((GridBagLayout)serializable2).setConstraints(this.input, (GridBagConstraints)serializable);
        this.add(this.input);
        ((GridBagConstraints)serializable).gridx = 1;
        this.output = new TextArea(5, 30);
        this.output.setEditable(false);
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagLayout)serializable2).setConstraints(this.output, (GridBagConstraints)serializable);
        this.add(this.output);
    }

    public boolean action(Event event, Object object) {
        Object object2 = event.target;
        if (object2 == this.b) {
            try {
                String string = this.tf.getText();
                RE rE = null;
                RESyntax rESyntax = values[this.syntax.getSelectedIndex()];
                rE = new RE(string, this.insens.getState() ? 10 : 8, rESyntax);
                REMatchEnumeration rEMatchEnumeration = rE.getMatchEnumeration(this.input.getText());
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (rEMatchEnumeration.hasMoreMatches()) {
                    stringBuffer.append(String.valueOf(++n));
                    stringBuffer.append(". ");
                    stringBuffer.append(rEMatchEnumeration.nextMatch().toString());
                    stringBuffer.append('\n');
                }
                this.output.setText(stringBuffer.toString());
            }
            catch (REException rEException) {
                this.output.setText("Expression compilation error: " + rEException.getMessage());
            }
            return true;
        }
        return false;
    }
}

