/* gsd-delete-operation.c generated by valac 0.16.0.1-eb36, the Vala compiler
 * generated from gsd-delete-operation.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gsd-config.h>


#define GSD_TYPE_ASYNC_OPERATION (gsd_async_operation_get_type ())
#define GSD_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation))
#define GSD_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))
#define GSD_IS_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ASYNC_OPERATION))
#define GSD_IS_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ASYNC_OPERATION))
#define GSD_ASYNC_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))

typedef struct _GsdAsyncOperation GsdAsyncOperation;
typedef struct _GsdAsyncOperationClass GsdAsyncOperationClass;
typedef struct _GsdAsyncOperationPrivate GsdAsyncOperationPrivate;

#define GSD_TYPE_SECURE_DELETE_OPERATION (gsd_secure_delete_operation_get_type ())
#define GSD_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperation))
#define GSD_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))
#define GSD_IS_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_IS_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_SECURE_DELETE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))

typedef struct _GsdSecureDeleteOperation GsdSecureDeleteOperation;
typedef struct _GsdSecureDeleteOperationClass GsdSecureDeleteOperationClass;
typedef struct _GsdSecureDeleteOperationPrivate GsdSecureDeleteOperationPrivate;

#define GSD_TYPE_ZEROABLE_OPERATION (gsd_zeroable_operation_get_type ())
#define GSD_ZEROABLE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperation))
#define GSD_ZEROABLE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperationClass))
#define GSD_IS_ZEROABLE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ZEROABLE_OPERATION))
#define GSD_IS_ZEROABLE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ZEROABLE_OPERATION))
#define GSD_ZEROABLE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ZEROABLE_OPERATION, GsdZeroableOperationClass))

typedef struct _GsdZeroableOperation GsdZeroableOperation;
typedef struct _GsdZeroableOperationClass GsdZeroableOperationClass;
typedef struct _GsdZeroableOperationPrivate GsdZeroableOperationPrivate;

#define GSD_TYPE_DELETE_OPERATION (gsd_delete_operation_get_type ())
#define GSD_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_DELETE_OPERATION, GsdDeleteOperation))
#define GSD_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_DELETE_OPERATION, GsdDeleteOperationClass))
#define GSD_IS_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_DELETE_OPERATION))
#define GSD_IS_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_DELETE_OPERATION))
#define GSD_DELETE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_DELETE_OPERATION, GsdDeleteOperationClass))

typedef struct _GsdDeleteOperation GsdDeleteOperation;
typedef struct _GsdDeleteOperationClass GsdDeleteOperationClass;
typedef struct _GsdDeleteOperationPrivate GsdDeleteOperationPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

typedef enum  {
	GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED,
	GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR
} GsdAsyncOperationError;
#define GSD_ASYNC_OPERATION_ERROR gsd_async_operation_error_quark ()
struct _GsdAsyncOperation {
	GObject parent_instance;
	GsdAsyncOperationPrivate * priv;
	guint n_passes;
	guint passes;
	GPid pid;
	gint fd_in;
	gint fd_out;
	gint fd_err;
};

struct _GsdAsyncOperationClass {
	GObjectClass parent_class;
	GList* (*build_args) (GsdAsyncOperation* self, GError** error);
	gchar** (*build_env) (GsdAsyncOperation* self, int* result_length1);
	void (*cleanup) (GsdAsyncOperation* self);
	guint (*get_max_progress) (GsdAsyncOperation* self);
	guint (*get_progress) (GsdAsyncOperation* self);
	gchar* (*get_subprocess_error_msg) (GsdAsyncOperation* self);
};

struct _GsdSecureDeleteOperation {
	GsdAsyncOperation parent_instance;
	GsdSecureDeleteOperationPrivate * priv;
};

struct _GsdSecureDeleteOperationClass {
	GsdAsyncOperationClass parent_class;
};

struct _GsdZeroableOperation {
	GsdSecureDeleteOperation parent_instance;
	GsdZeroableOperationPrivate * priv;
};

struct _GsdZeroableOperationClass {
	GsdSecureDeleteOperationClass parent_class;
};

struct _GsdDeleteOperation {
	GsdZeroableOperation parent_instance;
	GsdDeleteOperationPrivate * priv;
};

struct _GsdDeleteOperationClass {
	GsdZeroableOperationClass parent_class;
};

struct _GsdDeleteOperationPrivate {
	GList* _paths;
};


static gpointer gsd_delete_operation_parent_class = NULL;

GType gsd_async_operation_get_type (void) G_GNUC_CONST;
GQuark gsd_async_operation_error_quark (void);
GType gsd_secure_delete_operation_get_type (void) G_GNUC_CONST;
GType gsd_zeroable_operation_get_type (void) G_GNUC_CONST;
GType gsd_delete_operation_get_type (void) G_GNUC_CONST;
#define GSD_DELETE_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSD_TYPE_DELETE_OPERATION, GsdDeleteOperationPrivate))
enum  {
	GSD_DELETE_OPERATION_DUMMY_PROPERTY,
	GSD_DELETE_OPERATION_PATHS
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void gsd_delete_operation_add_path (GsdDeleteOperation* self, const gchar* path);
gboolean gsd_async_operation_get_busy (GsdAsyncOperation* self);
void gsd_delete_operation_remove_path (GsdDeleteOperation* self, const gchar* path);
static gint __lambda2_ (const gchar* a, const gchar* b);
static gint ___lambda2__gcompare_func (gconstpointer a, gconstpointer b);
static gchar* gsd_delete_operation_real_get_subprocess_error_msg (GsdAsyncOperation* base);
gchar* gsd_async_operation_get_subprocess_error_msg (GsdAsyncOperation* self);
static guint gsd_delete_operation_count_files (GsdDeleteOperation* self, const gchar* path);
static GList* gsd_delete_operation_real_build_args (GsdAsyncOperation* base, GError** error);
GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error);
static void gsd_delete_operation_real_cleanup (GsdAsyncOperation* base);
static guint gsd_delete_operation_real_get_max_progress (GsdAsyncOperation* base);
guint gsd_async_operation_get_max_progress (GsdAsyncOperation* self);
GsdDeleteOperation* gsd_delete_operation_new (void);
GsdDeleteOperation* gsd_delete_operation_construct (GType object_type);
GsdZeroableOperation* gsd_zeroable_operation_construct (GType object_type);
GList* gsd_delete_operation_get_paths (GsdDeleteOperation* self);
static GObject * gsd_delete_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value);
static void gsd_delete_operation_finalize (GObject* obj);
static void _vala_gsd_delete_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


/**
     * Adds a path to the list of paths to remove.
     * 
     * @param path a path to securely remove.
     */
void gsd_delete_operation_add_path (GsdDeleteOperation* self, const gchar* path) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gsd_async_operation_get_busy ((GsdAsyncOperation*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (!_tmp1_);
	_tmp2_ = path;
	_tmp3_ = g_strdup (_tmp2_);
	self->priv->_paths = g_list_append (self->priv->_paths, _tmp3_);
}


/**
     * Removes a path from the list of paths to wipe.
     * 
     * Note that this is NOT a filter for files not to wipe! It only remove a
     * path previously added with add_path() from the list of paths to wipe, it
     * does not prevent wiping of a path if the directory containing it is in
     * the list of paths to wipe.
     * 
     * @param path a path already added you want to remove from the list.
     */
static gint __lambda2_ (const gchar* a, const gchar* b) {
	gint result = 0;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = a;
	_tmp2_ = b;
	if (g_strcmp0 ((const gchar*) _tmp1_, (const gchar*) _tmp2_) == 0) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static gint ___lambda2__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda2_ (a, b);
	return result;
}


void gsd_delete_operation_remove_path (GsdDeleteOperation* self, const gchar* path) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GList* link = NULL;
	GList* _tmp2_;
	const gchar* _tmp3_;
	GList* _tmp4_ = NULL;
	GList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gsd_async_operation_get_busy ((GsdAsyncOperation*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (!_tmp1_);
	_tmp2_ = self->priv->_paths;
	_tmp3_ = path;
	_tmp4_ = g_list_find_custom (_tmp2_, _tmp3_, ___lambda2__gcompare_func);
	link = _tmp4_;
	_tmp5_ = link;
	if (_tmp5_ != NULL) {
		GList* _tmp6_;
		_tmp6_ = link;
		self->priv->_paths = g_list_delete_link (self->priv->_paths, _tmp6_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* gsd_delete_operation_real_get_subprocess_error_msg (GsdAsyncOperation* base) {
	GsdDeleteOperation * self;
	gchar* result = NULL;
	const gchar* pattern;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	self = (GsdDeleteOperation*) base;
	pattern = "rename/unlink only!";
	_tmp0_ = GSD_ASYNC_OPERATION_CLASS (gsd_delete_operation_parent_class)->get_subprocess_error_msg ((GsdAsyncOperation*) GSD_ZEROABLE_OPERATION (self));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (pattern, "\n", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp1_, pattern, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static guint gsd_delete_operation_count_files (GsdDeleteOperation* self, const gchar* path) {
	guint result = 0U;
	guint n_files;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (path != NULL, 0U);
	n_files = (guint) 0;
	_tmp0_ = path;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_IS_DIR);
	if (_tmp1_) {
		{
			const gchar* _tmp2_;
			GDir* _tmp3_ = NULL;
			GDir* dir;
			const gchar* name = NULL;
			_tmp2_ = path;
			_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error_);
			dir = _tmp3_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch9_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0U;
			}
			while (TRUE) {
				GDir* _tmp4_;
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_;
				guint _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				guint _tmp12_ = 0U;
				_tmp4_ = dir;
				_tmp5_ = g_dir_read_name (_tmp4_);
				name = _tmp5_;
				_tmp6_ = name;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = n_files;
				_tmp8_ = path;
				_tmp9_ = name;
				_tmp10_ = g_build_filename (_tmp8_, _tmp9_, NULL, NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = gsd_delete_operation_count_files (self, _tmp11_);
				n_files = _tmp7_ + _tmp12_;
				_g_free0 (_tmp11_);
			}
			_g_dir_close0 (dir);
		}
		goto __finally9;
		__catch9_g_file_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	} else {
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = path;
		_tmp14_ = g_file_test (_tmp13_, G_FILE_TEST_IS_SYMLINK);
		if (_tmp14_) {
		} else {
			guint _tmp15_;
			_tmp15_ = n_files;
			n_files = _tmp15_ + 1;
		}
	}
	result = n_files;
	return result;
}


static GList* gsd_delete_operation_real_build_args (GsdAsyncOperation* base, GError** error) {
	GsdDeleteOperation * self;
	GList* result = NULL;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
	GList* args;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	gchar* _tmp4_;
	GList* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (GsdDeleteOperation*) base;
	_tmp0_ = self->priv->_paths;
	_tmp1_ = g_list_length (_tmp0_);
	g_return_val_if_fail (_tmp1_ > ((guint) 0), NULL);
	args = NULL;
	_tmp2_ = GSD_ASYNC_OPERATION_CLASS (gsd_delete_operation_parent_class)->build_args ((GsdAsyncOperation*) GSD_ZEROABLE_OPERATION (self), &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	__g_list_free__g_free0_0 (args);
	args = _tmp3_;
	_tmp4_ = g_strdup ("-r");
	args = g_list_append (args, _tmp4_);
	_tmp5_ = self->priv->_paths;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp5_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			const gchar* path = NULL;
			path = (const gchar*) path_it->data;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = path;
				_tmp7_ = g_strdup (_tmp6_);
				args = g_list_append (args, _tmp7_);
			}
		}
	}
	result = args;
	return result;
}


static void gsd_delete_operation_real_cleanup (GsdAsyncOperation* base) {
	GsdDeleteOperation * self;
	self = (GsdDeleteOperation*) base;
	__g_list_free__g_free0_0 (self->priv->_paths);
	self->priv->_paths = NULL;
}


static guint gsd_delete_operation_real_get_max_progress (GsdAsyncOperation* base) {
	GsdDeleteOperation * self;
	guint result = 0U;
	guint n_files;
	GList* _tmp0_;
	guint _tmp4_ = 0U;
	guint _tmp5_;
	self = (GsdDeleteOperation*) base;
	n_files = (guint) 0;
	_tmp0_ = self->priv->_paths;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp0_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			const gchar* path = NULL;
			path = (const gchar*) path_it->data;
			{
				guint _tmp1_;
				const gchar* _tmp2_;
				guint _tmp3_ = 0U;
				_tmp1_ = n_files;
				_tmp2_ = path;
				_tmp3_ = gsd_delete_operation_count_files (self, _tmp2_);
				n_files = _tmp1_ + _tmp3_;
			}
		}
	}
	_tmp4_ = GSD_ASYNC_OPERATION_CLASS (gsd_delete_operation_parent_class)->get_max_progress ((GsdAsyncOperation*) GSD_ZEROABLE_OPERATION (self));
	_tmp5_ = n_files;
	result = _tmp4_ * _tmp5_;
	return result;
}


GsdDeleteOperation* gsd_delete_operation_construct (GType object_type) {
	GsdDeleteOperation * self = NULL;
	self = (GsdDeleteOperation*) gsd_zeroable_operation_construct (object_type);
	return self;
}


GsdDeleteOperation* gsd_delete_operation_new (void) {
	return gsd_delete_operation_construct (GSD_TYPE_DELETE_OPERATION);
}


GList* gsd_delete_operation_get_paths (GsdDeleteOperation* self) {
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_paths;
	result = _tmp0_;
	return result;
}


static GObject * gsd_delete_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GsdDeleteOperation * self;
	parent_class = G_OBJECT_CLASS (gsd_delete_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GSD_DELETE_OPERATION (obj);
	gsd_async_operation_set_path ((GsdAsyncOperation*) self, SRM_PATH);
	return obj;
}


static void gsd_delete_operation_class_init (GsdDeleteOperationClass * klass) {
	gsd_delete_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GsdDeleteOperationPrivate));
	GSD_ASYNC_OPERATION_CLASS (klass)->get_subprocess_error_msg = gsd_delete_operation_real_get_subprocess_error_msg;
	GSD_ASYNC_OPERATION_CLASS (klass)->build_args = gsd_delete_operation_real_build_args;
	GSD_ASYNC_OPERATION_CLASS (klass)->cleanup = gsd_delete_operation_real_cleanup;
	GSD_ASYNC_OPERATION_CLASS (klass)->get_max_progress = gsd_delete_operation_real_get_max_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_gsd_delete_operation_get_property;
	G_OBJECT_CLASS (klass)->constructor = gsd_delete_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = gsd_delete_operation_finalize;
	/**
	     * List of all files to wipe.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_DELETE_OPERATION_PATHS, g_param_spec_pointer ("paths", "paths", "paths", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gsd_delete_operation_instance_init (GsdDeleteOperation * self) {
	self->priv = GSD_DELETE_OPERATION_GET_PRIVATE (self);
}


static void gsd_delete_operation_finalize (GObject* obj) {
	GsdDeleteOperation * self;
	self = GSD_DELETE_OPERATION (obj);
	__g_list_free__g_free0_0 (self->priv->_paths);
	G_OBJECT_CLASS (gsd_delete_operation_parent_class)->finalize (obj);
}


/**
   * Wrapper for //srm//.
   */
GType gsd_delete_operation_get_type (void) {
	static volatile gsize gsd_delete_operation_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_delete_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GsdDeleteOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsd_delete_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GsdDeleteOperation), 0, (GInstanceInitFunc) gsd_delete_operation_instance_init, NULL };
		GType gsd_delete_operation_type_id;
		gsd_delete_operation_type_id = g_type_register_static (GSD_TYPE_ZEROABLE_OPERATION, "GsdDeleteOperation", &g_define_type_info, 0);
		g_once_init_leave (&gsd_delete_operation_type_id__volatile, gsd_delete_operation_type_id);
	}
	return gsd_delete_operation_type_id__volatile;
}


static void _vala_gsd_delete_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GsdDeleteOperation * self;
	self = GSD_DELETE_OPERATION (object);
	switch (property_id) {
		case GSD_DELETE_OPERATION_PATHS:
		g_value_set_pointer (value, gsd_delete_operation_get_paths (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



