/**********************************************************************
  Copyright(c) 2011-2016 Intel Corporation All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.
    * Neither the name of Intel Corporation nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************/
#include <stdint.h>
#include <igzip_lib.h>

uint8_t const gzip_hdr[10] = {
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xff
};

const uint32_t gzip_hdr_bytes = 10;
const uint32_t gzip_trl_bytes = 8;

const struct isal_hufftables hufftables_default = {

	.deflate_hdr = {
		0xed, 0xfd, 0x6d, 0xc7, 0xb6, 0x6d, 0xd7, 0x34,
		0x3d, 0xef, 0xc7, 0x7e, 0x1c, 0xfb, 0xb1, 0x1f,
		0xcb, 0x7c, 0xec, 0xfb, 0xf1, 0xb2, 0x1f, 0xfb,
		0xcb, 0x71, 0xec, 0xc7, 0xbe, 0x1f, 0xc7, 0xb4,
		0xce, 0xfb, 0xb1, 0x6f, 0xcb, 0xbc, 0xec, 0xeb,
		0xb2, 0xce, 0xeb, 0x7a, 0x6c, 0xfb, 0x76, 0xec,
		0xc7, 0x71, 0x6c, 0xcb, 0xb6, 0x6c, 0xc7, 0xb1,
		0x6e, 0xeb, 0xb6, 0x6e, 0xdb, 0xba, 0x1d, 0xfb,
		0xb6, 0x6e, 0xdb, 0xb6, 0xaf, 0xeb, 0xb2, 0x6d,
		0xc7, 0x7a, 0xec, 0xdb, 0xb6, 0xed, 0xcb, 0x31,
		0xaf, 0xf3, 0x3c, 0x2d, 0xcb, 0x32, 0x6f, 0xdb,
		0xbc, 0xcc, 0xf3, 0xb2, 0xcd, 0x2f, 0xcb, 0xb2,
		0x2e, 0xc7, 0xb6, 0xad, 0xc7, 0x7e, 0xbc, 0xbf,
		0xee, 0xfb, 0xb1, 0xbf, 0x1e, 0xc7, 0xb1, 0x1f,
		0xc7, 0xfe, 0x72, 0xbc, 0xec, 0xfb, 0x7e, 0xec,
		0xfb, 0x71, 0xec, 0x2f, 0xc7, 0xeb, 0xbe, 0x1f,
		0xc7, 0xfe, 0x72, 0xbc, 0xec, 0xfb, 0x71, 0x1c,
		0xfb, 0x71, 0xec, 0xfb, 0xf1, 0xbe, 0x1f, 0xc7,
		0xbe, 0x1f, 0xc7, 0xb1, 0xbf, 0x1d, 0x6f, 0xfb,
		0x7e, 0xbc, 0xed, 0xaf, 0xc7, 0xb1, 0xef, 0xc7,
		0xb1, 0x1f, 0xef, 0xfb, 0x31, 0xc6, 0x34, 0xcd,
		0xf3, 0x32, 0xbf, 0x2c, 0xf3, 0xba, 0x6e, 0xeb,
		0x7a, 0x6c, 0xc7, 0xb1, 0x6f, 0xc7, 0x7e, 0x1c,
		0xfb, 0xb6, 0xad, 0xdb, 0xbc, 0x2d, 0xf3, 0x34,
		0x8d, 0x31, 0xa6, 0x31, 0x7a, 0xf4, 0x18, 0xd3,
		0x34, 0x6d, 0xaf },

	.deflate_hdr_count = 203,
	.deflate_hdr_extra_bits = 0,

#ifdef LONGER_HUFFTABLE
	.dist_table = {
		0x00001be9, 0x00003be9, 0x00000be8, 0x000007e9,
		0x000001e7, 0x000009e7, 0x000027ea, 0x000067ea,
		0x000003e9, 0x000013e9, 0x000023e9, 0x000033e9,
		0x000005e8, 0x00000de8, 0x000015e8, 0x00001de8,
		0x00000068, 0x00000468, 0x00000868, 0x00000c68,
		0x00001068, 0x00001468, 0x00001868, 0x00001c68,
		0x00000268, 0x00000668, 0x00000a68, 0x00000e68,
		0x00001268, 0x00001668, 0x00001a68, 0x00001e68,
		0x00000048, 0x00000248, 0x00000448, 0x00000648,
		0x00000848, 0x00000a48, 0x00000c48, 0x00000e48,
		0x00001048, 0x00001248, 0x00001448, 0x00001648,
		0x00001848, 0x00001a48, 0x00001c48, 0x00001e48,
		0x00000148, 0x00000348, 0x00000548, 0x00000748,
		0x00000948, 0x00000b48, 0x00000d48, 0x00000f48,
		0x00001148, 0x00001348, 0x00001548, 0x00001748,
		0x00001948, 0x00001b48, 0x00001d48, 0x00001f48,
		0x000000c9, 0x000002c9, 0x000004c9, 0x000006c9,
		0x000008c9, 0x00000ac9, 0x00000cc9, 0x00000ec9,
		0x000010c9, 0x000012c9, 0x000014c9, 0x000016c9,
		0x000018c9, 0x00001ac9, 0x00001cc9, 0x00001ec9,
		0x000020c9, 0x000022c9, 0x000024c9, 0x000026c9,
		0x000028c9, 0x00002ac9, 0x00002cc9, 0x00002ec9,
		0x000030c9, 0x000032c9, 0x000034c9, 0x000036c9,
		0x000038c9, 0x00003ac9, 0x00003cc9, 0x00003ec9,
		0x0000016a, 0x0000056a, 0x0000096a, 0x00000d6a,
		0x0000116a, 0x0000156a, 0x0000196a, 0x00001d6a,
		0x0000216a, 0x0000256a, 0x0000296a, 0x00002d6a,
		0x0000316a, 0x0000356a, 0x0000396a, 0x00003d6a,
		0x0000416a, 0x0000456a, 0x0000496a, 0x00004d6a,
		0x0000516a, 0x0000556a, 0x0000596a, 0x00005d6a,
		0x0000616a, 0x0000656a, 0x0000696a, 0x00006d6a,
		0x0000716a, 0x0000756a, 0x0000796a, 0x00007d6a,
		0x000001ca, 0x000003ca, 0x000005ca, 0x000007ca,
		0x000009ca, 0x00000bca, 0x00000dca, 0x00000fca,
		0x000011ca, 0x000013ca, 0x000015ca, 0x000017ca,
		0x000019ca, 0x00001bca, 0x00001dca, 0x00001fca,
		0x000021ca, 0x000023ca, 0x000025ca, 0x000027ca,
		0x000029ca, 0x00002bca, 0x00002dca, 0x00002fca,
		0x000031ca, 0x000033ca, 0x000035ca, 0x000037ca,
		0x000039ca, 0x00003bca, 0x00003dca, 0x00003fca,
		0x000041ca, 0x000043ca, 0x000045ca, 0x000047ca,
		0x000049ca, 0x00004bca, 0x00004dca, 0x00004fca,
		0x000051ca, 0x000053ca, 0x000055ca, 0x000057ca,
		0x000059ca, 0x00005bca, 0x00005dca, 0x00005fca,
		0x000061ca, 0x000063ca, 0x000065ca, 0x000067ca,
		0x000069ca, 0x00006bca, 0x00006dca, 0x00006fca,
		0x000071ca, 0x000073ca, 0x000075ca, 0x000077ca,
		0x000079ca, 0x00007bca, 0x00007dca, 0x00007fca,
		0x0000002a, 0x0000022a, 0x0000042a, 0x0000062a,
		0x0000082a, 0x00000a2a, 0x00000c2a, 0x00000e2a,
		0x0000102a, 0x0000122a, 0x0000142a, 0x0000162a,
		0x0000182a, 0x00001a2a, 0x00001c2a, 0x00001e2a,
		0x0000202a, 0x0000222a, 0x0000242a, 0x0000262a,
		0x0000282a, 0x00002a2a, 0x00002c2a, 0x00002e2a,
		0x0000302a, 0x0000322a, 0x0000342a, 0x0000362a,
		0x0000382a, 0x00003a2a, 0x00003c2a, 0x00003e2a,
		0x0000402a, 0x0000422a, 0x0000442a, 0x0000462a,
		0x0000482a, 0x00004a2a, 0x00004c2a, 0x00004e2a,
		0x0000502a, 0x0000522a, 0x0000542a, 0x0000562a,
		0x0000582a, 0x00005a2a, 0x00005c2a, 0x00005e2a,
		0x0000602a, 0x0000622a, 0x0000642a, 0x0000662a,
		0x0000682a, 0x00006a2a, 0x00006c2a, 0x00006e2a,
		0x0000702a, 0x0000722a, 0x0000742a, 0x0000762a,
		0x0000782a, 0x00007a2a, 0x00007c2a, 0x00007e2a,
		0x0000000a, 0x0000010a, 0x0000020a, 0x0000030a,
		0x0000040a, 0x0000050a, 0x0000060a, 0x0000070a,
		0x0000080a, 0x0000090a, 0x00000a0a, 0x00000b0a,
		0x00000c0a, 0x00000d0a, 0x00000e0a, 0x00000f0a,
		0x0000100a, 0x0000110a, 0x0000120a, 0x0000130a,
		0x0000140a, 0x0000150a, 0x0000160a, 0x0000170a,
		0x0000180a, 0x0000190a, 0x00001a0a, 0x00001b0a,
		0x00001c0a, 0x00001d0a, 0x00001e0a, 0x00001f0a,
		0x0000200a, 0x0000210a, 0x0000220a, 0x0000230a,
		0x0000240a, 0x0000250a, 0x0000260a, 0x0000270a,
		0x0000280a, 0x0000290a, 0x00002a0a, 0x00002b0a,
		0x00002c0a, 0x00002d0a, 0x00002e0a, 0x00002f0a,
		0x0000300a, 0x0000310a, 0x0000320a, 0x0000330a,
		0x0000340a, 0x0000350a, 0x0000360a, 0x0000370a,
		0x0000380a, 0x0000390a, 0x00003a0a, 0x00003b0a,
		0x00003c0a, 0x00003d0a, 0x00003e0a, 0x00003f0a,
		0x0000400a, 0x0000410a, 0x0000420a, 0x0000430a,
		0x0000440a, 0x0000450a, 0x0000460a, 0x0000470a,
		0x0000480a, 0x0000490a, 0x00004a0a, 0x00004b0a,
		0x00004c0a, 0x00004d0a, 0x00004e0a, 0x00004f0a,
		0x0000500a, 0x0000510a, 0x0000520a, 0x0000530a,
		0x0000540a, 0x0000550a, 0x0000560a, 0x0000570a,
		0x0000580a, 0x0000590a, 0x00005a0a, 0x00005b0a,
		0x00005c0a, 0x00005d0a, 0x00005e0a, 0x00005f0a,
		0x0000600a, 0x0000610a, 0x0000620a, 0x0000630a,
		0x0000640a, 0x0000650a, 0x0000660a, 0x0000670a,
		0x0000680a, 0x0000690a, 0x00006a0a, 0x00006b0a,
		0x00006c0a, 0x00006d0a, 0x00006e0a, 0x00006f0a,
		0x0000700a, 0x0000710a, 0x0000720a, 0x0000730a,
		0x0000740a, 0x0000750a, 0x0000760a, 0x0000770a,
		0x0000780a, 0x0000790a, 0x00007a0a, 0x00007b0a,
		0x00007c0a, 0x00007d0a, 0x00007e0a, 0x00007f0a,
		0x0000012b, 0x0000032b, 0x0000052b, 0x0000072b,
		0x0000092b, 0x00000b2b, 0x00000d2b, 0x00000f2b,
		0x0000112b, 0x0000132b, 0x0000152b, 0x0000172b,
		0x0000192b, 0x00001b2b, 0x00001d2b, 0x00001f2b,
		0x0000212b, 0x0000232b, 0x0000252b, 0x0000272b,
		0x0000292b, 0x00002b2b, 0x00002d2b, 0x00002f2b,
		0x0000312b, 0x0000332b, 0x0000352b, 0x0000372b,
		0x0000392b, 0x00003b2b, 0x00003d2b, 0x00003f2b,
		0x0000412b, 0x0000432b, 0x0000452b, 0x0000472b,
		0x0000492b, 0x00004b2b, 0x00004d2b, 0x00004f2b,
		0x0000512b, 0x0000532b, 0x0000552b, 0x0000572b,
		0x0000592b, 0x00005b2b, 0x00005d2b, 0x00005f2b,
		0x0000612b, 0x0000632b, 0x0000652b, 0x0000672b,
		0x0000692b, 0x00006b2b, 0x00006d2b, 0x00006f2b,
		0x0000712b, 0x0000732b, 0x0000752b, 0x0000772b,
		0x0000792b, 0x00007b2b, 0x00007d2b, 0x00007f2b,
		0x0000812b, 0x0000832b, 0x0000852b, 0x0000872b,
		0x0000892b, 0x00008b2b, 0x00008d2b, 0x00008f2b,
		0x0000912b, 0x0000932b, 0x0000952b, 0x0000972b,
		0x0000992b, 0x00009b2b, 0x00009d2b, 0x00009f2b,
		0x0000a12b, 0x0000a32b, 0x0000a52b, 0x0000a72b,
		0x0000a92b, 0x0000ab2b, 0x0000ad2b, 0x0000af2b,
		0x0000b12b, 0x0000b32b, 0x0000b52b, 0x0000b72b,
		0x0000b92b, 0x0000bb2b, 0x0000bd2b, 0x0000bf2b,
		0x0000c12b, 0x0000c32b, 0x0000c52b, 0x0000c72b,
		0x0000c92b, 0x0000cb2b, 0x0000cd2b, 0x0000cf2b,
		0x0000d12b, 0x0000d32b, 0x0000d52b, 0x0000d72b,
		0x0000d92b, 0x0000db2b, 0x0000dd2b, 0x0000df2b,
		0x0000e12b, 0x0000e32b, 0x0000e52b, 0x0000e72b,
		0x0000e92b, 0x0000eb2b, 0x0000ed2b, 0x0000ef2b,
		0x0000f12b, 0x0000f32b, 0x0000f52b, 0x0000f72b,
		0x0000f92b, 0x0000fb2b, 0x0000fd2b, 0x0000ff2b,
		0x0000008b, 0x0000018b, 0x0000028b, 0x0000038b,
		0x0000048b, 0x0000058b, 0x0000068b, 0x0000078b,
		0x0000088b, 0x0000098b, 0x00000a8b, 0x00000b8b,
		0x00000c8b, 0x00000d8b, 0x00000e8b, 0x00000f8b,
		0x0000108b, 0x0000118b, 0x0000128b, 0x0000138b,
		0x0000148b, 0x0000158b, 0x0000168b, 0x0000178b,
		0x0000188b, 0x0000198b, 0x00001a8b, 0x00001b8b,
		0x00001c8b, 0x00001d8b, 0x00001e8b, 0x00001f8b,
		0x0000208b, 0x0000218b, 0x0000228b, 0x0000238b,
		0x0000248b, 0x0000258b, 0x0000268b, 0x0000278b,
		0x0000288b, 0x0000298b, 0x00002a8b, 0x00002b8b,
		0x00002c8b, 0x00002d8b, 0x00002e8b, 0x00002f8b,
		0x0000308b, 0x0000318b, 0x0000328b, 0x0000338b,
		0x0000348b, 0x0000358b, 0x0000368b, 0x0000378b,
		0x0000388b, 0x0000398b, 0x00003a8b, 0x00003b8b,
		0x00003c8b, 0x00003d8b, 0x00003e8b, 0x00003f8b,
		0x0000408b, 0x0000418b, 0x0000428b, 0x0000438b,
		0x0000448b, 0x0000458b, 0x0000468b, 0x0000478b,
		0x0000488b, 0x0000498b, 0x00004a8b, 0x00004b8b,
		0x00004c8b, 0x00004d8b, 0x00004e8b, 0x00004f8b,
		0x0000508b, 0x0000518b, 0x0000528b, 0x0000538b,
		0x0000548b, 0x0000558b, 0x0000568b, 0x0000578b,
		0x0000588b, 0x0000598b, 0x00005a8b, 0x00005b8b,
		0x00005c8b, 0x00005d8b, 0x00005e8b, 0x00005f8b,
		0x0000608b, 0x0000618b, 0x0000628b, 0x0000638b,
		0x0000648b, 0x0000658b, 0x0000668b, 0x0000678b,
		0x0000688b, 0x0000698b, 0x00006a8b, 0x00006b8b,
		0x00006c8b, 0x00006d8b, 0x00006e8b, 0x00006f8b,
		0x0000708b, 0x0000718b, 0x0000728b, 0x0000738b,
		0x0000748b, 0x0000758b, 0x0000768b, 0x0000778b,
		0x0000788b, 0x0000798b, 0x00007a8b, 0x00007b8b,
		0x00007c8b, 0x00007d8b, 0x00007e8b, 0x00007f8b,
		0x0000808b, 0x0000818b, 0x0000828b, 0x0000838b,
		0x0000848b, 0x0000858b, 0x0000868b, 0x0000878b,
		0x0000888b, 0x0000898b, 0x00008a8b, 0x00008b8b,
		0x00008c8b, 0x00008d8b, 0x00008e8b, 0x00008f8b,
		0x0000908b, 0x0000918b, 0x0000928b, 0x0000938b,
		0x0000948b, 0x0000958b, 0x0000968b, 0x0000978b,
		0x0000988b, 0x0000998b, 0x00009a8b, 0x00009b8b,
		0x00009c8b, 0x00009d8b, 0x00009e8b, 0x00009f8b,
		0x0000a08b, 0x0000a18b, 0x0000a28b, 0x0000a38b,
		0x0000a48b, 0x0000a58b, 0x0000a68b, 0x0000a78b,
		0x0000a88b, 0x0000a98b, 0x0000aa8b, 0x0000ab8b,
		0x0000ac8b, 0x0000ad8b, 0x0000ae8b, 0x0000af8b,
		0x0000b08b, 0x0000b18b, 0x0000b28b, 0x0000b38b,
		0x0000b48b, 0x0000b58b, 0x0000b68b, 0x0000b78b,
		0x0000b88b, 0x0000b98b, 0x0000ba8b, 0x0000bb8b,
		0x0000bc8b, 0x0000bd8b, 0x0000be8b, 0x0000bf8b,
		0x0000c08b, 0x0000c18b, 0x0000c28b, 0x0000c38b,
		0x0000c48b, 0x0000c58b, 0x0000c68b, 0x0000c78b,
		0x0000c88b, 0x0000c98b, 0x0000ca8b, 0x0000cb8b,
		0x0000cc8b, 0x0000cd8b, 0x0000ce8b, 0x0000cf8b,
		0x0000d08b, 0x0000d18b, 0x0000d28b, 0x0000d38b,
		0x0000d48b, 0x0000d58b, 0x0000d68b, 0x0000d78b,
		0x0000d88b, 0x0000d98b, 0x0000da8b, 0x0000db8b,
		0x0000dc8b, 0x0000dd8b, 0x0000de8b, 0x0000df8b,
		0x0000e08b, 0x0000e18b, 0x0000e28b, 0x0000e38b,
		0x0000e48b, 0x0000e58b, 0x0000e68b, 0x0000e78b,
		0x0000e88b, 0x0000e98b, 0x0000ea8b, 0x0000eb8b,
		0x0000ec8b, 0x0000ed8b, 0x0000ee8b, 0x0000ef8b,
		0x0000f08b, 0x0000f18b, 0x0000f28b, 0x0000f38b,
		0x0000f48b, 0x0000f58b, 0x0000f68b, 0x0000f78b,
		0x0000f88b, 0x0000f98b, 0x0000fa8b, 0x0000fb8b,
		0x0000fc8b, 0x0000fd8b, 0x0000fe8b, 0x0000ff8b,
		0x000000ac, 0x000002ac, 0x000004ac, 0x000006ac,
		0x000008ac, 0x00000aac, 0x00000cac, 0x00000eac,
		0x000010ac, 0x000012ac, 0x000014ac, 0x000016ac,
		0x000018ac, 0x00001aac, 0x00001cac, 0x00001eac,
		0x000020ac, 0x000022ac, 0x000024ac, 0x000026ac,
		0x000028ac, 0x00002aac, 0x00002cac, 0x00002eac,
		0x000030ac, 0x000032ac, 0x000034ac, 0x000036ac,
		0x000038ac, 0x00003aac, 0x00003cac, 0x00003eac,
		0x000040ac, 0x000042ac, 0x000044ac, 0x000046ac,
		0x000048ac, 0x00004aac, 0x00004cac, 0x00004eac,
		0x000050ac, 0x000052ac, 0x000054ac, 0x000056ac,
		0x000058ac, 0x00005aac, 0x00005cac, 0x00005eac,
		0x000060ac, 0x000062ac, 0x000064ac, 0x000066ac,
		0x000068ac, 0x00006aac, 0x00006cac, 0x00006eac,
		0x000070ac, 0x000072ac, 0x000074ac, 0x000076ac,
		0x000078ac, 0x00007aac, 0x00007cac, 0x00007eac,
		0x000080ac, 0x000082ac, 0x000084ac, 0x000086ac,
		0x000088ac, 0x00008aac, 0x00008cac, 0x00008eac,
		0x000090ac, 0x000092ac, 0x000094ac, 0x000096ac,
		0x000098ac, 0x00009aac, 0x00009cac, 0x00009eac,
		0x0000a0ac, 0x0000a2ac, 0x0000a4ac, 0x0000a6ac,
		0x0000a8ac, 0x0000aaac, 0x0000acac, 0x0000aeac,
		0x0000b0ac, 0x0000b2ac, 0x0000b4ac, 0x0000b6ac,
		0x0000b8ac, 0x0000baac, 0x0000bcac, 0x0000beac,
		0x0000c0ac, 0x0000c2ac, 0x0000c4ac, 0x0000c6ac,
		0x0000c8ac, 0x0000caac, 0x0000ccac, 0x0000ceac,
		0x0000d0ac, 0x0000d2ac, 0x0000d4ac, 0x0000d6ac,
		0x0000d8ac, 0x0000daac, 0x0000dcac, 0x0000deac,
		0x0000e0ac, 0x0000e2ac, 0x0000e4ac, 0x0000e6ac,
		0x0000e8ac, 0x0000eaac, 0x0000ecac, 0x0000eeac,
		0x0000f0ac, 0x0000f2ac, 0x0000f4ac, 0x0000f6ac,
		0x0000f8ac, 0x0000faac, 0x0000fcac, 0x0000feac,
		0x000100ac, 0x000102ac, 0x000104ac, 0x000106ac,
		0x000108ac, 0x00010aac, 0x00010cac, 0x00010eac,
		0x000110ac, 0x000112ac, 0x000114ac, 0x000116ac,
		0x000118ac, 0x00011aac, 0x00011cac, 0x00011eac,
		0x000120ac, 0x000122ac, 0x000124ac, 0x000126ac,
		0x000128ac, 0x00012aac, 0x00012cac, 0x00012eac,
		0x000130ac, 0x000132ac, 0x000134ac, 0x000136ac,
		0x000138ac, 0x00013aac, 0x00013cac, 0x00013eac,
		0x000140ac, 0x000142ac, 0x000144ac, 0x000146ac,
		0x000148ac, 0x00014aac, 0x00014cac, 0x00014eac,
		0x000150ac, 0x000152ac, 0x000154ac, 0x000156ac,
		0x000158ac, 0x00015aac, 0x00015cac, 0x00015eac,
		0x000160ac, 0x000162ac, 0x000164ac, 0x000166ac,
		0x000168ac, 0x00016aac, 0x00016cac, 0x00016eac,
		0x000170ac, 0x000172ac, 0x000174ac, 0x000176ac,
		0x000178ac, 0x00017aac, 0x00017cac, 0x00017eac,
		0x000180ac, 0x000182ac, 0x000184ac, 0x000186ac,
		0x000188ac, 0x00018aac, 0x00018cac, 0x00018eac,
		0x000190ac, 0x000192ac, 0x000194ac, 0x000196ac,
		0x000198ac, 0x00019aac, 0x00019cac, 0x00019eac,
		0x0001a0ac, 0x0001a2ac, 0x0001a4ac, 0x0001a6ac,
		0x0001a8ac, 0x0001aaac, 0x0001acac, 0x0001aeac,
		0x0001b0ac, 0x0001b2ac, 0x0001b4ac, 0x0001b6ac,
		0x0001b8ac, 0x0001baac, 0x0001bcac, 0x0001beac,
		0x0001c0ac, 0x0001c2ac, 0x0001c4ac, 0x0001c6ac,
		0x0001c8ac, 0x0001caac, 0x0001ccac, 0x0001ceac,
		0x0001d0ac, 0x0001d2ac, 0x0001d4ac, 0x0001d6ac,
		0x0001d8ac, 0x0001daac, 0x0001dcac, 0x0001deac,
		0x0001e0ac, 0x0001e2ac, 0x0001e4ac, 0x0001e6ac,
		0x0001e8ac, 0x0001eaac, 0x0001ecac, 0x0001eeac,
		0x0001f0ac, 0x0001f2ac, 0x0001f4ac, 0x0001f6ac,
		0x0001f8ac, 0x0001faac, 0x0001fcac, 0x0001feac,
		0x000001ad, 0x000003ad, 0x000005ad, 0x000007ad,
		0x000009ad, 0x00000bad, 0x00000dad, 0x00000fad,
		0x000011ad, 0x000013ad, 0x000015ad, 0x000017ad,
		0x000019ad, 0x00001bad, 0x00001dad, 0x00001fad,
		0x000021ad, 0x000023ad, 0x000025ad, 0x000027ad,
		0x000029ad, 0x00002bad, 0x00002dad, 0x00002fad,
		0x000031ad, 0x000033ad, 0x000035ad, 0x000037ad,
		0x000039ad, 0x00003bad, 0x00003dad, 0x00003fad,
		0x000041ad, 0x000043ad, 0x000045ad, 0x000047ad,
		0x000049ad, 0x00004bad, 0x00004dad, 0x00004fad,
		0x000051ad, 0x000053ad, 0x000055ad, 0x000057ad,
		0x000059ad, 0x00005bad, 0x00005dad, 0x00005fad,
		0x000061ad, 0x000063ad, 0x000065ad, 0x000067ad,
		0x000069ad, 0x00006bad, 0x00006dad, 0x00006fad,
		0x000071ad, 0x000073ad, 0x000075ad, 0x000077ad,
		0x000079ad, 0x00007bad, 0x00007dad, 0x00007fad,
		0x000081ad, 0x000083ad, 0x000085ad, 0x000087ad,
		0x000089ad, 0x00008bad, 0x00008dad, 0x00008fad,
		0x000091ad, 0x000093ad, 0x000095ad, 0x000097ad,
		0x000099ad, 0x00009bad, 0x00009dad, 0x00009fad,
		0x0000a1ad, 0x0000a3ad, 0x0000a5ad, 0x0000a7ad,
		0x0000a9ad, 0x0000abad, 0x0000adad, 0x0000afad,
		0x0000b1ad, 0x0000b3ad, 0x0000b5ad, 0x0000b7ad,
		0x0000b9ad, 0x0000bbad, 0x0000bdad, 0x0000bfad,
		0x0000c1ad, 0x0000c3ad, 0x0000c5ad, 0x0000c7ad,
		0x0000c9ad, 0x0000cbad, 0x0000cdad, 0x0000cfad,
		0x0000d1ad, 0x0000d3ad, 0x0000d5ad, 0x0000d7ad,
		0x0000d9ad, 0x0000dbad, 0x0000ddad, 0x0000dfad,
		0x0000e1ad, 0x0000e3ad, 0x0000e5ad, 0x0000e7ad,
		0x0000e9ad, 0x0000ebad, 0x0000edad, 0x0000efad,
		0x0000f1ad, 0x0000f3ad, 0x0000f5ad, 0x0000f7ad,
		0x0000f9ad, 0x0000fbad, 0x0000fdad, 0x0000ffad,
		0x000101ad, 0x000103ad, 0x000105ad, 0x000107ad,
		0x000109ad, 0x00010bad, 0x00010dad, 0x00010fad,
		0x000111ad, 0x000113ad, 0x000115ad, 0x000117ad,
		0x000119ad, 0x00011bad, 0x00011dad, 0x00011fad,
		0x000121ad, 0x000123ad, 0x000125ad, 0x000127ad,
		0x000129ad, 0x00012bad, 0x00012dad, 0x00012fad,
		0x000131ad, 0x000133ad, 0x000135ad, 0x000137ad,
		0x000139ad, 0x00013bad, 0x00013dad, 0x00013fad,
		0x000141ad, 0x000143ad, 0x000145ad, 0x000147ad,
		0x000149ad, 0x00014bad, 0x00014dad, 0x00014fad,
		0x000151ad, 0x000153ad, 0x000155ad, 0x000157ad,
		0x000159ad, 0x00015bad, 0x00015dad, 0x00015fad,
		0x000161ad, 0x000163ad, 0x000165ad, 0x000167ad,
		0x000169ad, 0x00016bad, 0x00016dad, 0x00016fad,
		0x000171ad, 0x000173ad, 0x000175ad, 0x000177ad,
		0x000179ad, 0x00017bad, 0x00017dad, 0x00017fad,
		0x000181ad, 0x000183ad, 0x000185ad, 0x000187ad,
		0x000189ad, 0x00018bad, 0x00018dad, 0x00018fad,
		0x000191ad, 0x000193ad, 0x000195ad, 0x000197ad,
		0x000199ad, 0x00019bad, 0x00019dad, 0x00019fad,
		0x0001a1ad, 0x0001a3ad, 0x0001a5ad, 0x0001a7ad,
		0x0001a9ad, 0x0001abad, 0x0001adad, 0x0001afad,
		0x0001b1ad, 0x0001b3ad, 0x0001b5ad, 0x0001b7ad,
		0x0001b9ad, 0x0001bbad, 0x0001bdad, 0x0001bfad,
		0x0001c1ad, 0x0001c3ad, 0x0001c5ad, 0x0001c7ad,
		0x0001c9ad, 0x0001cbad, 0x0001cdad, 0x0001cfad,
		0x0001d1ad, 0x0001d3ad, 0x0001d5ad, 0x0001d7ad,
		0x0001d9ad, 0x0001dbad, 0x0001ddad, 0x0001dfad,
		0x0001e1ad, 0x0001e3ad, 0x0001e5ad, 0x0001e7ad,
		0x0001e9ad, 0x0001ebad, 0x0001edad, 0x0001efad,
		0x0001f1ad, 0x0001f3ad, 0x0001f5ad, 0x0001f7ad,
		0x0001f9ad, 0x0001fbad, 0x0001fdad, 0x0001ffad,
		0x000201ad, 0x000203ad, 0x000205ad, 0x000207ad,
		0x000209ad, 0x00020bad, 0x00020dad, 0x00020fad,
		0x000211ad, 0x000213ad, 0x000215ad, 0x000217ad,
		0x000219ad, 0x00021bad, 0x00021dad, 0x00021fad,
		0x000221ad, 0x000223ad, 0x000225ad, 0x000227ad,
		0x000229ad, 0x00022bad, 0x00022dad, 0x00022fad,
		0x000231ad, 0x000233ad, 0x000235ad, 0x000237ad,
		0x000239ad, 0x00023bad, 0x00023dad, 0x00023fad,
		0x000241ad, 0x000243ad, 0x000245ad, 0x000247ad,
		0x000249ad, 0x00024bad, 0x00024dad, 0x00024fad,
		0x000251ad, 0x000253ad, 0x000255ad, 0x000257ad,
		0x000259ad, 0x00025bad, 0x00025dad, 0x00025fad,
		0x000261ad, 0x000263ad, 0x000265ad, 0x000267ad,
		0x000269ad, 0x00026bad, 0x00026dad, 0x00026fad,
		0x000271ad, 0x000273ad, 0x000275ad, 0x000277ad,
		0x000279ad, 0x00027bad, 0x00027dad, 0x00027fad,
		0x000281ad, 0x000283ad, 0x000285ad, 0x000287ad,
		0x000289ad, 0x00028bad, 0x00028dad, 0x00028fad,
		0x000291ad, 0x000293ad, 0x000295ad, 0x000297ad,
		0x000299ad, 0x00029bad, 0x00029dad, 0x00029fad,
		0x0002a1ad, 0x0002a3ad, 0x0002a5ad, 0x0002a7ad,
		0x0002a9ad, 0x0002abad, 0x0002adad, 0x0002afad,
		0x0002b1ad, 0x0002b3ad, 0x0002b5ad, 0x0002b7ad,
		0x0002b9ad, 0x0002bbad, 0x0002bdad, 0x0002bfad,
		0x0002c1ad, 0x0002c3ad, 0x0002c5ad, 0x0002c7ad,
		0x0002c9ad, 0x0002cbad, 0x0002cdad, 0x0002cfad,
		0x0002d1ad, 0x0002d3ad, 0x0002d5ad, 0x0002d7ad,
		0x0002d9ad, 0x0002dbad, 0x0002ddad, 0x0002dfad,
		0x0002e1ad, 0x0002e3ad, 0x0002e5ad, 0x0002e7ad,
		0x0002e9ad, 0x0002ebad, 0x0002edad, 0x0002efad,
		0x0002f1ad, 0x0002f3ad, 0x0002f5ad, 0x0002f7ad,
		0x0002f9ad, 0x0002fbad, 0x0002fdad, 0x0002ffad,
		0x000301ad, 0x000303ad, 0x000305ad, 0x000307ad,
		0x000309ad, 0x00030bad, 0x00030dad, 0x00030fad,
		0x000311ad, 0x000313ad, 0x000315ad, 0x000317ad,
		0x000319ad, 0x00031bad, 0x00031dad, 0x00031fad,
		0x000321ad, 0x000323ad, 0x000325ad, 0x000327ad,
		0x000329ad, 0x00032bad, 0x00032dad, 0x00032fad,
		0x000331ad, 0x000333ad, 0x000335ad, 0x000337ad,
		0x000339ad, 0x00033bad, 0x00033dad, 0x00033fad,
		0x000341ad, 0x000343ad, 0x000345ad, 0x000347ad,
		0x000349ad, 0x00034bad, 0x00034dad, 0x00034fad,
		0x000351ad, 0x000353ad, 0x000355ad, 0x000357ad,
		0x000359ad, 0x00035bad, 0x00035dad, 0x00035fad,
		0x000361ad, 0x000363ad, 0x000365ad, 0x000367ad,
		0x000369ad, 0x00036bad, 0x00036dad, 0x00036fad,
		0x000371ad, 0x000373ad, 0x000375ad, 0x000377ad,
		0x000379ad, 0x00037bad, 0x00037dad, 0x00037fad,
		0x000381ad, 0x000383ad, 0x000385ad, 0x000387ad,
		0x000389ad, 0x00038bad, 0x00038dad, 0x00038fad,
		0x000391ad, 0x000393ad, 0x000395ad, 0x000397ad,
		0x000399ad, 0x00039bad, 0x00039dad, 0x00039fad,
		0x0003a1ad, 0x0003a3ad, 0x0003a5ad, 0x0003a7ad,
		0x0003a9ad, 0x0003abad, 0x0003adad, 0x0003afad,
		0x0003b1ad, 0x0003b3ad, 0x0003b5ad, 0x0003b7ad,
		0x0003b9ad, 0x0003bbad, 0x0003bdad, 0x0003bfad,
		0x0003c1ad, 0x0003c3ad, 0x0003c5ad, 0x0003c7ad,
		0x0003c9ad, 0x0003cbad, 0x0003cdad, 0x0003cfad,
		0x0003d1ad, 0x0003d3ad, 0x0003d5ad, 0x0003d7ad,
		0x0003d9ad, 0x0003dbad, 0x0003ddad, 0x0003dfad,
		0x0003e1ad, 0x0003e3ad, 0x0003e5ad, 0x0003e7ad,
		0x0003e9ad, 0x0003ebad, 0x0003edad, 0x0003efad,
		0x0003f1ad, 0x0003f3ad, 0x0003f5ad, 0x0003f7ad,
		0x0003f9ad, 0x0003fbad, 0x0003fdad, 0x0003ffad,
		0x0000036e, 0x0000076e, 0x00000b6e, 0x00000f6e,
		0x0000136e, 0x0000176e, 0x00001b6e, 0x00001f6e,
		0x0000236e, 0x0000276e, 0x00002b6e, 0x00002f6e,
		0x0000336e, 0x0000376e, 0x00003b6e, 0x00003f6e,
		0x0000436e, 0x0000476e, 0x00004b6e, 0x00004f6e,
		0x0000536e, 0x0000576e, 0x00005b6e, 0x00005f6e,
		0x0000636e, 0x0000676e, 0x00006b6e, 0x00006f6e,
		0x0000736e, 0x0000776e, 0x00007b6e, 0x00007f6e,
		0x0000836e, 0x0000876e, 0x00008b6e, 0x00008f6e,
		0x0000936e, 0x0000976e, 0x00009b6e, 0x00009f6e,
		0x0000a36e, 0x0000a76e, 0x0000ab6e, 0x0000af6e,
		0x0000b36e, 0x0000b76e, 0x0000bb6e, 0x0000bf6e,
		0x0000c36e, 0x0000c76e, 0x0000cb6e, 0x0000cf6e,
		0x0000d36e, 0x0000d76e, 0x0000db6e, 0x0000df6e,
		0x0000e36e, 0x0000e76e, 0x0000eb6e, 0x0000ef6e,
		0x0000f36e, 0x0000f76e, 0x0000fb6e, 0x0000ff6e,
		0x0001036e, 0x0001076e, 0x00010b6e, 0x00010f6e,
		0x0001136e, 0x0001176e, 0x00011b6e, 0x00011f6e,
		0x0001236e, 0x0001276e, 0x00012b6e, 0x00012f6e,
		0x0001336e, 0x0001376e, 0x00013b6e, 0x00013f6e,
		0x0001436e, 0x0001476e, 0x00014b6e, 0x00014f6e,
		0x0001536e, 0x0001576e, 0x00015b6e, 0x00015f6e,
		0x0001636e, 0x0001676e, 0x00016b6e, 0x00016f6e,
		0x0001736e, 0x0001776e, 0x00017b6e, 0x00017f6e,
		0x0001836e, 0x0001876e, 0x00018b6e, 0x00018f6e,
		0x0001936e, 0x0001976e, 0x00019b6e, 0x00019f6e,
		0x0001a36e, 0x0001a76e, 0x0001ab6e, 0x0001af6e,
		0x0001b36e, 0x0001b76e, 0x0001bb6e, 0x0001bf6e,
		0x0001c36e, 0x0001c76e, 0x0001cb6e, 0x0001cf6e,
		0x0001d36e, 0x0001d76e, 0x0001db6e, 0x0001df6e,
		0x0001e36e, 0x0001e76e, 0x0001eb6e, 0x0001ef6e,
		0x0001f36e, 0x0001f76e, 0x0001fb6e, 0x0001ff6e,
		0x0002036e, 0x0002076e, 0x00020b6e, 0x00020f6e,
		0x0002136e, 0x0002176e, 0x00021b6e, 0x00021f6e,
		0x0002236e, 0x0002276e, 0x00022b6e, 0x00022f6e,
		0x0002336e, 0x0002376e, 0x00023b6e, 0x00023f6e,
		0x0002436e, 0x0002476e, 0x00024b6e, 0x00024f6e,
		0x0002536e, 0x0002576e, 0x00025b6e, 0x00025f6e,
		0x0002636e, 0x0002676e, 0x00026b6e, 0x00026f6e,
		0x0002736e, 0x0002776e, 0x00027b6e, 0x00027f6e,
		0x0002836e, 0x0002876e, 0x00028b6e, 0x00028f6e,
		0x0002936e, 0x0002976e, 0x00029b6e, 0x00029f6e,
		0x0002a36e, 0x0002a76e, 0x0002ab6e, 0x0002af6e,
		0x0002b36e, 0x0002b76e, 0x0002bb6e, 0x0002bf6e,
		0x0002c36e, 0x0002c76e, 0x0002cb6e, 0x0002cf6e,
		0x0002d36e, 0x0002d76e, 0x0002db6e, 0x0002df6e,
		0x0002e36e, 0x0002e76e, 0x0002eb6e, 0x0002ef6e,
		0x0002f36e, 0x0002f76e, 0x0002fb6e, 0x0002ff6e,
		0x0003036e, 0x0003076e, 0x00030b6e, 0x00030f6e,
		0x0003136e, 0x0003176e, 0x00031b6e, 0x00031f6e,
		0x0003236e, 0x0003276e, 0x00032b6e, 0x00032f6e,
		0x0003336e, 0x0003376e, 0x00033b6e, 0x00033f6e,
		0x0003436e, 0x0003476e, 0x00034b6e, 0x00034f6e,
		0x0003536e, 0x0003576e, 0x00035b6e, 0x00035f6e,
		0x0003636e, 0x0003676e, 0x00036b6e, 0x00036f6e,
		0x0003736e, 0x0003776e, 0x00037b6e, 0x00037f6e,
		0x0003836e, 0x0003876e, 0x00038b6e, 0x00038f6e,
		0x0003936e, 0x0003976e, 0x00039b6e, 0x00039f6e,
		0x0003a36e, 0x0003a76e, 0x0003ab6e, 0x0003af6e,
		0x0003b36e, 0x0003b76e, 0x0003bb6e, 0x0003bf6e,
		0x0003c36e, 0x0003c76e, 0x0003cb6e, 0x0003cf6e,
		0x0003d36e, 0x0003d76e, 0x0003db6e, 0x0003df6e,
		0x0003e36e, 0x0003e76e, 0x0003eb6e, 0x0003ef6e,
		0x0003f36e, 0x0003f76e, 0x0003fb6e, 0x0003ff6e,
		0x0004036e, 0x0004076e, 0x00040b6e, 0x00040f6e,
		0x0004136e, 0x0004176e, 0x00041b6e, 0x00041f6e,
		0x0004236e, 0x0004276e, 0x00042b6e, 0x00042f6e,
		0x0004336e, 0x0004376e, 0x00043b6e, 0x00043f6e,
		0x0004436e, 0x0004476e, 0x00044b6e, 0x00044f6e,
		0x0004536e, 0x0004576e, 0x00045b6e, 0x00045f6e,
		0x0004636e, 0x0004676e, 0x00046b6e, 0x00046f6e,
		0x0004736e, 0x0004776e, 0x00047b6e, 0x00047f6e,
		0x0004836e, 0x0004876e, 0x00048b6e, 0x00048f6e,
		0x0004936e, 0x0004976e, 0x00049b6e, 0x00049f6e,
		0x0004a36e, 0x0004a76e, 0x0004ab6e, 0x0004af6e,
		0x0004b36e, 0x0004b76e, 0x0004bb6e, 0x0004bf6e,
		0x0004c36e, 0x0004c76e, 0x0004cb6e, 0x0004cf6e,
		0x0004d36e, 0x0004d76e, 0x0004db6e, 0x0004df6e,
		0x0004e36e, 0x0004e76e, 0x0004eb6e, 0x0004ef6e,
		0x0004f36e, 0x0004f76e, 0x0004fb6e, 0x0004ff6e,
		0x0005036e, 0x0005076e, 0x00050b6e, 0x00050f6e,
		0x0005136e, 0x0005176e, 0x00051b6e, 0x00051f6e,
		0x0005236e, 0x0005276e, 0x00052b6e, 0x00052f6e,
		0x0005336e, 0x0005376e, 0x00053b6e, 0x00053f6e,
		0x0005436e, 0x0005476e, 0x00054b6e, 0x00054f6e,
		0x0005536e, 0x0005576e, 0x00055b6e, 0x00055f6e,
		0x0005636e, 0x0005676e, 0x00056b6e, 0x00056f6e,
		0x0005736e, 0x0005776e, 0x00057b6e, 0x00057f6e,
		0x0005836e, 0x0005876e, 0x00058b6e, 0x00058f6e,
		0x0005936e, 0x0005976e, 0x00059b6e, 0x00059f6e,
		0x0005a36e, 0x0005a76e, 0x0005ab6e, 0x0005af6e,
		0x0005b36e, 0x0005b76e, 0x0005bb6e, 0x0005bf6e,
		0x0005c36e, 0x0005c76e, 0x0005cb6e, 0x0005cf6e,
		0x0005d36e, 0x0005d76e, 0x0005db6e, 0x0005df6e,
		0x0005e36e, 0x0005e76e, 0x0005eb6e, 0x0005ef6e,
		0x0005f36e, 0x0005f76e, 0x0005fb6e, 0x0005ff6e,
		0x0006036e, 0x0006076e, 0x00060b6e, 0x00060f6e,
		0x0006136e, 0x0006176e, 0x00061b6e, 0x00061f6e,
		0x0006236e, 0x0006276e, 0x00062b6e, 0x00062f6e,
		0x0006336e, 0x0006376e, 0x00063b6e, 0x00063f6e,
		0x0006436e, 0x0006476e, 0x00064b6e, 0x00064f6e,
		0x0006536e, 0x0006576e, 0x00065b6e, 0x00065f6e,
		0x0006636e, 0x0006676e, 0x00066b6e, 0x00066f6e,
		0x0006736e, 0x0006776e, 0x00067b6e, 0x00067f6e,
		0x0006836e, 0x0006876e, 0x00068b6e, 0x00068f6e,
		0x0006936e, 0x0006976e, 0x00069b6e, 0x00069f6e,
		0x0006a36e, 0x0006a76e, 0x0006ab6e, 0x0006af6e,
		0x0006b36e, 0x0006b76e, 0x0006bb6e, 0x0006bf6e,
		0x0006c36e, 0x0006c76e, 0x0006cb6e, 0x0006cf6e,
		0x0006d36e, 0x0006d76e, 0x0006db6e, 0x0006df6e,
		0x0006e36e, 0x0006e76e, 0x0006eb6e, 0x0006ef6e,
		0x0006f36e, 0x0006f76e, 0x0006fb6e, 0x0006ff6e,
		0x0007036e, 0x0007076e, 0x00070b6e, 0x00070f6e,
		0x0007136e, 0x0007176e, 0x00071b6e, 0x00071f6e,
		0x0007236e, 0x0007276e, 0x00072b6e, 0x00072f6e,
		0x0007336e, 0x0007376e, 0x00073b6e, 0x00073f6e,
		0x0007436e, 0x0007476e, 0x00074b6e, 0x00074f6e,
		0x0007536e, 0x0007576e, 0x00075b6e, 0x00075f6e,
		0x0007636e, 0x0007676e, 0x00076b6e, 0x00076f6e,
		0x0007736e, 0x0007776e, 0x00077b6e, 0x00077f6e,
		0x0007836e, 0x0007876e, 0x00078b6e, 0x00078f6e,
		0x0007936e, 0x0007976e, 0x00079b6e, 0x00079f6e,
		0x0007a36e, 0x0007a76e, 0x0007ab6e, 0x0007af6e,
		0x0007b36e, 0x0007b76e, 0x0007bb6e, 0x0007bf6e,
		0x0007c36e, 0x0007c76e, 0x0007cb6e, 0x0007cf6e,
		0x0007d36e, 0x0007d76e, 0x0007db6e, 0x0007df6e,
		0x0007e36e, 0x0007e76e, 0x0007eb6e, 0x0007ef6e,
		0x0007f36e, 0x0007f76e, 0x0007fb6e, 0x0007ff6e,
		0x000000ef, 0x000004ef, 0x000008ef, 0x00000cef,
		0x000010ef, 0x000014ef, 0x000018ef, 0x00001cef,
		0x000020ef, 0x000024ef, 0x000028ef, 0x00002cef,
		0x000030ef, 0x000034ef, 0x000038ef, 0x00003cef,
		0x000040ef, 0x000044ef, 0x000048ef, 0x00004cef,
		0x000050ef, 0x000054ef, 0x000058ef, 0x00005cef,
		0x000060ef, 0x000064ef, 0x000068ef, 0x00006cef,
		0x000070ef, 0x000074ef, 0x000078ef, 0x00007cef,
		0x000080ef, 0x000084ef, 0x000088ef, 0x00008cef,
		0x000090ef, 0x000094ef, 0x000098ef, 0x00009cef,
		0x0000a0ef, 0x0000a4ef, 0x0000a8ef, 0x0000acef,
		0x0000b0ef, 0x0000b4ef, 0x0000b8ef, 0x0000bcef,
		0x0000c0ef, 0x0000c4ef, 0x0000c8ef, 0x0000ccef,
		0x0000d0ef, 0x0000d4ef, 0x0000d8ef, 0x0000dcef,
		0x0000e0ef, 0x0000e4ef, 0x0000e8ef, 0x0000ecef,
		0x0000f0ef, 0x0000f4ef, 0x0000f8ef, 0x0000fcef,
		0x000100ef, 0x000104ef, 0x000108ef, 0x00010cef,
		0x000110ef, 0x000114ef, 0x000118ef, 0x00011cef,
		0x000120ef, 0x000124ef, 0x000128ef, 0x00012cef,
		0x000130ef, 0x000134ef, 0x000138ef, 0x00013cef,
		0x000140ef, 0x000144ef, 0x000148ef, 0x00014cef,
		0x000150ef, 0x000154ef, 0x000158ef, 0x00015cef,
		0x000160ef, 0x000164ef, 0x000168ef, 0x00016cef,
		0x000170ef, 0x000174ef, 0x000178ef, 0x00017cef,
		0x000180ef, 0x000184ef, 0x000188ef, 0x00018cef,
		0x000190ef, 0x000194ef, 0x000198ef, 0x00019cef,
		0x0001a0ef, 0x0001a4ef, 0x0001a8ef, 0x0001acef,
		0x0001b0ef, 0x0001b4ef, 0x0001b8ef, 0x0001bcef,
		0x0001c0ef, 0x0001c4ef, 0x0001c8ef, 0x0001ccef,
		0x0001d0ef, 0x0001d4ef, 0x0001d8ef, 0x0001dcef,
		0x0001e0ef, 0x0001e4ef, 0x0001e8ef, 0x0001ecef,
		0x0001f0ef, 0x0001f4ef, 0x0001f8ef, 0x0001fcef,
		0x000200ef, 0x000204ef, 0x000208ef, 0x00020cef,
		0x000210ef, 0x000214ef, 0x000218ef, 0x00021cef,
		0x000220ef, 0x000224ef, 0x000228ef, 0x00022cef,
		0x000230ef, 0x000234ef, 0x000238ef, 0x00023cef,
		0x000240ef, 0x000244ef, 0x000248ef, 0x00024cef,
		0x000250ef, 0x000254ef, 0x000258ef, 0x00025cef,
		0x000260ef, 0x000264ef, 0x000268ef, 0x00026cef,
		0x000270ef, 0x000274ef, 0x000278ef, 0x00027cef,
		0x000280ef, 0x000284ef, 0x000288ef, 0x00028cef,
		0x000290ef, 0x000294ef, 0x000298ef, 0x00029cef,
		0x0002a0ef, 0x0002a4ef, 0x0002a8ef, 0x0002acef,
		0x0002b0ef, 0x0002b4ef, 0x0002b8ef, 0x0002bcef,
		0x0002c0ef, 0x0002c4ef, 0x0002c8ef, 0x0002ccef,
		0x0002d0ef, 0x0002d4ef, 0x0002d8ef, 0x0002dcef,
		0x0002e0ef, 0x0002e4ef, 0x0002e8ef, 0x0002ecef,
		0x0002f0ef, 0x0002f4ef, 0x0002f8ef, 0x0002fcef,
		0x000300ef, 0x000304ef, 0x000308ef, 0x00030cef,
		0x000310ef, 0x000314ef, 0x000318ef, 0x00031cef,
		0x000320ef, 0x000324ef, 0x000328ef, 0x00032cef,
		0x000330ef, 0x000334ef, 0x000338ef, 0x00033cef,
		0x000340ef, 0x000344ef, 0x000348ef, 0x00034cef,
		0x000350ef, 0x000354ef, 0x000358ef, 0x00035cef,
		0x000360ef, 0x000364ef, 0x000368ef, 0x00036cef,
		0x000370ef, 0x000374ef, 0x000378ef, 0x00037cef,
		0x000380ef, 0x000384ef, 0x000388ef, 0x00038cef,
		0x000390ef, 0x000394ef, 0x000398ef, 0x00039cef,
		0x0003a0ef, 0x0003a4ef, 0x0003a8ef, 0x0003acef,
		0x0003b0ef, 0x0003b4ef, 0x0003b8ef, 0x0003bcef,
		0x0003c0ef, 0x0003c4ef, 0x0003c8ef, 0x0003ccef,
		0x0003d0ef, 0x0003d4ef, 0x0003d8ef, 0x0003dcef,
		0x0003e0ef, 0x0003e4ef, 0x0003e8ef, 0x0003ecef,
		0x0003f0ef, 0x0003f4ef, 0x0003f8ef, 0x0003fcef,
		0x000400ef, 0x000404ef, 0x000408ef, 0x00040cef,
		0x000410ef, 0x000414ef, 0x000418ef, 0x00041cef,
		0x000420ef, 0x000424ef, 0x000428ef, 0x00042cef,
		0x000430ef, 0x000434ef, 0x000438ef, 0x00043cef,
		0x000440ef, 0x000444ef, 0x000448ef, 0x00044cef,
		0x000450ef, 0x000454ef, 0x000458ef, 0x00045cef,
		0x000460ef, 0x000464ef, 0x000468ef, 0x00046cef,
		0x000470ef, 0x000474ef, 0x000478ef, 0x00047cef,
		0x000480ef, 0x000484ef, 0x000488ef, 0x00048cef,
		0x000490ef, 0x000494ef, 0x000498ef, 0x00049cef,
		0x0004a0ef, 0x0004a4ef, 0x0004a8ef, 0x0004acef,
		0x0004b0ef, 0x0004b4ef, 0x0004b8ef, 0x0004bcef,
		0x0004c0ef, 0x0004c4ef, 0x0004c8ef, 0x0004ccef,
		0x0004d0ef, 0x0004d4ef, 0x0004d8ef, 0x0004dcef,
		0x0004e0ef, 0x0004e4ef, 0x0004e8ef, 0x0004ecef,
		0x0004f0ef, 0x0004f4ef, 0x0004f8ef, 0x0004fcef,
		0x000500ef, 0x000504ef, 0x000508ef, 0x00050cef,
		0x000510ef, 0x000514ef, 0x000518ef, 0x00051cef,
		0x000520ef, 0x000524ef, 0x000528ef, 0x00052cef,
		0x000530ef, 0x000534ef, 0x000538ef, 0x00053cef,
		0x000540ef, 0x000544ef, 0x000548ef, 0x00054cef,
		0x000550ef, 0x000554ef, 0x000558ef, 0x00055cef,
		0x000560ef, 0x000564ef, 0x000568ef, 0x00056cef,
		0x000570ef, 0x000574ef, 0x000578ef, 0x00057cef,
		0x000580ef, 0x000584ef, 0x000588ef, 0x00058cef,
		0x000590ef, 0x000594ef, 0x000598ef, 0x00059cef,
		0x0005a0ef, 0x0005a4ef, 0x0005a8ef, 0x0005acef,
		0x0005b0ef, 0x0005b4ef, 0x0005b8ef, 0x0005bcef,
		0x0005c0ef, 0x0005c4ef, 0x0005c8ef, 0x0005ccef,
		0x0005d0ef, 0x0005d4ef, 0x0005d8ef, 0x0005dcef,
		0x0005e0ef, 0x0005e4ef, 0x0005e8ef, 0x0005ecef,
		0x0005f0ef, 0x0005f4ef, 0x0005f8ef, 0x0005fcef,
		0x000600ef, 0x000604ef, 0x000608ef, 0x00060cef,
		0x000610ef, 0x000614ef, 0x000618ef, 0x00061cef,
		0x000620ef, 0x000624ef, 0x000628ef, 0x00062cef,
		0x000630ef, 0x000634ef, 0x000638ef, 0x00063cef,
		0x000640ef, 0x000644ef, 0x000648ef, 0x00064cef,
		0x000650ef, 0x000654ef, 0x000658ef, 0x00065cef,
		0x000660ef, 0x000664ef, 0x000668ef, 0x00066cef,
		0x000670ef, 0x000674ef, 0x000678ef, 0x00067cef,
		0x000680ef, 0x000684ef, 0x000688ef, 0x00068cef,
		0x000690ef, 0x000694ef, 0x000698ef, 0x00069cef,
		0x0006a0ef, 0x0006a4ef, 0x0006a8ef, 0x0006acef,
		0x0006b0ef, 0x0006b4ef, 0x0006b8ef, 0x0006bcef,
		0x0006c0ef, 0x0006c4ef, 0x0006c8ef, 0x0006ccef,
		0x0006d0ef, 0x0006d4ef, 0x0006d8ef, 0x0006dcef,
		0x0006e0ef, 0x0006e4ef, 0x0006e8ef, 0x0006ecef,
		0x0006f0ef, 0x0006f4ef, 0x0006f8ef, 0x0006fcef,
		0x000700ef, 0x000704ef, 0x000708ef, 0x00070cef,
		0x000710ef, 0x000714ef, 0x000718ef, 0x00071cef,
		0x000720ef, 0x000724ef, 0x000728ef, 0x00072cef,
		0x000730ef, 0x000734ef, 0x000738ef, 0x00073cef,
		0x000740ef, 0x000744ef, 0x000748ef, 0x00074cef,
		0x000750ef, 0x000754ef, 0x000758ef, 0x00075cef,
		0x000760ef, 0x000764ef, 0x000768ef, 0x00076cef,
		0x000770ef, 0x000774ef, 0x000778ef, 0x00077cef,
		0x000780ef, 0x000784ef, 0x000788ef, 0x00078cef,
		0x000790ef, 0x000794ef, 0x000798ef, 0x00079cef,
		0x0007a0ef, 0x0007a4ef, 0x0007a8ef, 0x0007acef,
		0x0007b0ef, 0x0007b4ef, 0x0007b8ef, 0x0007bcef,
		0x0007c0ef, 0x0007c4ef, 0x0007c8ef, 0x0007ccef,
		0x0007d0ef, 0x0007d4ef, 0x0007d8ef, 0x0007dcef,
		0x0007e0ef, 0x0007e4ef, 0x0007e8ef, 0x0007ecef,
		0x0007f0ef, 0x0007f4ef, 0x0007f8ef, 0x0007fcef,
		0x000800ef, 0x000804ef, 0x000808ef, 0x00080cef,
		0x000810ef, 0x000814ef, 0x000818ef, 0x00081cef,
		0x000820ef, 0x000824ef, 0x000828ef, 0x00082cef,
		0x000830ef, 0x000834ef, 0x000838ef, 0x00083cef,
		0x000840ef, 0x000844ef, 0x000848ef, 0x00084cef,
		0x000850ef, 0x000854ef, 0x000858ef, 0x00085cef,
		0x000860ef, 0x000864ef, 0x000868ef, 0x00086cef,
		0x000870ef, 0x000874ef, 0x000878ef, 0x00087cef,
		0x000880ef, 0x000884ef, 0x000888ef, 0x00088cef,
		0x000890ef, 0x000894ef, 0x000898ef, 0x00089cef,
		0x0008a0ef, 0x0008a4ef, 0x0008a8ef, 0x0008acef,
		0x0008b0ef, 0x0008b4ef, 0x0008b8ef, 0x0008bcef,
		0x0008c0ef, 0x0008c4ef, 0x0008c8ef, 0x0008ccef,
		0x0008d0ef, 0x0008d4ef, 0x0008d8ef, 0x0008dcef,
		0x0008e0ef, 0x0008e4ef, 0x0008e8ef, 0x0008ecef,
		0x0008f0ef, 0x0008f4ef, 0x0008f8ef, 0x0008fcef,
		0x000900ef, 0x000904ef, 0x000908ef, 0x00090cef,
		0x000910ef, 0x000914ef, 0x000918ef, 0x00091cef,
		0x000920ef, 0x000924ef, 0x000928ef, 0x00092cef,
		0x000930ef, 0x000934ef, 0x000938ef, 0x00093cef,
		0x000940ef, 0x000944ef, 0x000948ef, 0x00094cef,
		0x000950ef, 0x000954ef, 0x000958ef, 0x00095cef,
		0x000960ef, 0x000964ef, 0x000968ef, 0x00096cef,
		0x000970ef, 0x000974ef, 0x000978ef, 0x00097cef,
		0x000980ef, 0x000984ef, 0x000988ef, 0x00098cef,
		0x000990ef, 0x000994ef, 0x000998ef, 0x00099cef,
		0x0009a0ef, 0x0009a4ef, 0x0009a8ef, 0x0009acef,
		0x0009b0ef, 0x0009b4ef, 0x0009b8ef, 0x0009bcef,
		0x0009c0ef, 0x0009c4ef, 0x0009c8ef, 0x0009ccef,
		0x0009d0ef, 0x0009d4ef, 0x0009d8ef, 0x0009dcef,
		0x0009e0ef, 0x0009e4ef, 0x0009e8ef, 0x0009ecef,
		0x0009f0ef, 0x0009f4ef, 0x0009f8ef, 0x0009fcef,
		0x000a00ef, 0x000a04ef, 0x000a08ef, 0x000a0cef,
		0x000a10ef, 0x000a14ef, 0x000a18ef, 0x000a1cef,
		0x000a20ef, 0x000a24ef, 0x000a28ef, 0x000a2cef,
		0x000a30ef, 0x000a34ef, 0x000a38ef, 0x000a3cef,
		0x000a40ef, 0x000a44ef, 0x000a48ef, 0x000a4cef,
		0x000a50ef, 0x000a54ef, 0x000a58ef, 0x000a5cef,
		0x000a60ef, 0x000a64ef, 0x000a68ef, 0x000a6cef,
		0x000a70ef, 0x000a74ef, 0x000a78ef, 0x000a7cef,
		0x000a80ef, 0x000a84ef, 0x000a88ef, 0x000a8cef,
		0x000a90ef, 0x000a94ef, 0x000a98ef, 0x000a9cef,
		0x000aa0ef, 0x000aa4ef, 0x000aa8ef, 0x000aacef,
		0x000ab0ef, 0x000ab4ef, 0x000ab8ef, 0x000abcef,
		0x000ac0ef, 0x000ac4ef, 0x000ac8ef, 0x000accef,
		0x000ad0ef, 0x000ad4ef, 0x000ad8ef, 0x000adcef,
		0x000ae0ef, 0x000ae4ef, 0x000ae8ef, 0x000aecef,
		0x000af0ef, 0x000af4ef, 0x000af8ef, 0x000afcef,
		0x000b00ef, 0x000b04ef, 0x000b08ef, 0x000b0cef,
		0x000b10ef, 0x000b14ef, 0x000b18ef, 0x000b1cef,
		0x000b20ef, 0x000b24ef, 0x000b28ef, 0x000b2cef,
		0x000b30ef, 0x000b34ef, 0x000b38ef, 0x000b3cef,
		0x000b40ef, 0x000b44ef, 0x000b48ef, 0x000b4cef,
		0x000b50ef, 0x000b54ef, 0x000b58ef, 0x000b5cef,
		0x000b60ef, 0x000b64ef, 0x000b68ef, 0x000b6cef,
		0x000b70ef, 0x000b74ef, 0x000b78ef, 0x000b7cef,
		0x000b80ef, 0x000b84ef, 0x000b88ef, 0x000b8cef,
		0x000b90ef, 0x000b94ef, 0x000b98ef, 0x000b9cef,
		0x000ba0ef, 0x000ba4ef, 0x000ba8ef, 0x000bacef,
		0x000bb0ef, 0x000bb4ef, 0x000bb8ef, 0x000bbcef,
		0x000bc0ef, 0x000bc4ef, 0x000bc8ef, 0x000bccef,
		0x000bd0ef, 0x000bd4ef, 0x000bd8ef, 0x000bdcef,
		0x000be0ef, 0x000be4ef, 0x000be8ef, 0x000becef,
		0x000bf0ef, 0x000bf4ef, 0x000bf8ef, 0x000bfcef,
		0x000c00ef, 0x000c04ef, 0x000c08ef, 0x000c0cef,
		0x000c10ef, 0x000c14ef, 0x000c18ef, 0x000c1cef,
		0x000c20ef, 0x000c24ef, 0x000c28ef, 0x000c2cef,
		0x000c30ef, 0x000c34ef, 0x000c38ef, 0x000c3cef,
		0x000c40ef, 0x000c44ef, 0x000c48ef, 0x000c4cef,
		0x000c50ef, 0x000c54ef, 0x000c58ef, 0x000c5cef,
		0x000c60ef, 0x000c64ef, 0x000c68ef, 0x000c6cef,
		0x000c70ef, 0x000c74ef, 0x000c78ef, 0x000c7cef,
		0x000c80ef, 0x000c84ef, 0x000c88ef, 0x000c8cef,
		0x000c90ef, 0x000c94ef, 0x000c98ef, 0x000c9cef,
		0x000ca0ef, 0x000ca4ef, 0x000ca8ef, 0x000cacef,
		0x000cb0ef, 0x000cb4ef, 0x000cb8ef, 0x000cbcef,
		0x000cc0ef, 0x000cc4ef, 0x000cc8ef, 0x000cccef,
		0x000cd0ef, 0x000cd4ef, 0x000cd8ef, 0x000cdcef,
		0x000ce0ef, 0x000ce4ef, 0x000ce8ef, 0x000cecef,
		0x000cf0ef, 0x000cf4ef, 0x000cf8ef, 0x000cfcef,
		0x000d00ef, 0x000d04ef, 0x000d08ef, 0x000d0cef,
		0x000d10ef, 0x000d14ef, 0x000d18ef, 0x000d1cef,
		0x000d20ef, 0x000d24ef, 0x000d28ef, 0x000d2cef,
		0x000d30ef, 0x000d34ef, 0x000d38ef, 0x000d3cef,
		0x000d40ef, 0x000d44ef, 0x000d48ef, 0x000d4cef,
		0x000d50ef, 0x000d54ef, 0x000d58ef, 0x000d5cef,
		0x000d60ef, 0x000d64ef, 0x000d68ef, 0x000d6cef,
		0x000d70ef, 0x000d74ef, 0x000d78ef, 0x000d7cef,
		0x000d80ef, 0x000d84ef, 0x000d88ef, 0x000d8cef,
		0x000d90ef, 0x000d94ef, 0x000d98ef, 0x000d9cef,
		0x000da0ef, 0x000da4ef, 0x000da8ef, 0x000dacef,
		0x000db0ef, 0x000db4ef, 0x000db8ef, 0x000dbcef,
		0x000dc0ef, 0x000dc4ef, 0x000dc8ef, 0x000dccef,
		0x000dd0ef, 0x000dd4ef, 0x000dd8ef, 0x000ddcef,
		0x000de0ef, 0x000de4ef, 0x000de8ef, 0x000decef,
		0x000df0ef, 0x000df4ef, 0x000df8ef, 0x000dfcef,
		0x000e00ef, 0x000e04ef, 0x000e08ef, 0x000e0cef,
		0x000e10ef, 0x000e14ef, 0x000e18ef, 0x000e1cef,
		0x000e20ef, 0x000e24ef, 0x000e28ef, 0x000e2cef,
		0x000e30ef, 0x000e34ef, 0x000e38ef, 0x000e3cef,
		0x000e40ef, 0x000e44ef, 0x000e48ef, 0x000e4cef,
		0x000e50ef, 0x000e54ef, 0x000e58ef, 0x000e5cef,
		0x000e60ef, 0x000e64ef, 0x000e68ef, 0x000e6cef,
		0x000e70ef, 0x000e74ef, 0x000e78ef, 0x000e7cef,
		0x000e80ef, 0x000e84ef, 0x000e88ef, 0x000e8cef,
		0x000e90ef, 0x000e94ef, 0x000e98ef, 0x000e9cef,
		0x000ea0ef, 0x000ea4ef, 0x000ea8ef, 0x000eacef,
		0x000eb0ef, 0x000eb4ef, 0x000eb8ef, 0x000ebcef,
		0x000ec0ef, 0x000ec4ef, 0x000ec8ef, 0x000eccef,
		0x000ed0ef, 0x000ed4ef, 0x000ed8ef, 0x000edcef,
		0x000ee0ef, 0x000ee4ef, 0x000ee8ef, 0x000eecef,
		0x000ef0ef, 0x000ef4ef, 0x000ef8ef, 0x000efcef,
		0x000f00ef, 0x000f04ef, 0x000f08ef, 0x000f0cef,
		0x000f10ef, 0x000f14ef, 0x000f18ef, 0x000f1cef,
		0x000f20ef, 0x000f24ef, 0x000f28ef, 0x000f2cef,
		0x000f30ef, 0x000f34ef, 0x000f38ef, 0x000f3cef,
		0x000f40ef, 0x000f44ef, 0x000f48ef, 0x000f4cef,
		0x000f50ef, 0x000f54ef, 0x000f58ef, 0x000f5cef,
		0x000f60ef, 0x000f64ef, 0x000f68ef, 0x000f6cef,
		0x000f70ef, 0x000f74ef, 0x000f78ef, 0x000f7cef,
		0x000f80ef, 0x000f84ef, 0x000f88ef, 0x000f8cef,
		0x000f90ef, 0x000f94ef, 0x000f98ef, 0x000f9cef,
		0x000fa0ef, 0x000fa4ef, 0x000fa8ef, 0x000facef,
		0x000fb0ef, 0x000fb4ef, 0x000fb8ef, 0x000fbcef,
		0x000fc0ef, 0x000fc4ef, 0x000fc8ef, 0x000fccef,
		0x000fd0ef, 0x000fd4ef, 0x000fd8ef, 0x000fdcef,
		0x000fe0ef, 0x000fe4ef, 0x000fe8ef, 0x000fecef,
		0x000ff0ef, 0x000ff4ef, 0x000ff8ef, 0x000ffcef,
		0x000002ef, 0x000006ef, 0x00000aef, 0x00000eef,
		0x000012ef, 0x000016ef, 0x00001aef, 0x00001eef,
		0x000022ef, 0x000026ef, 0x00002aef, 0x00002eef,
		0x000032ef, 0x000036ef, 0x00003aef, 0x00003eef,
		0x000042ef, 0x000046ef, 0x00004aef, 0x00004eef,
		0x000052ef, 0x000056ef, 0x00005aef, 0x00005eef,
		0x000062ef, 0x000066ef, 0x00006aef, 0x00006eef,
		0x000072ef, 0x000076ef, 0x00007aef, 0x00007eef,
		0x000082ef, 0x000086ef, 0x00008aef, 0x00008eef,
		0x000092ef, 0x000096ef, 0x00009aef, 0x00009eef,
		0x0000a2ef, 0x0000a6ef, 0x0000aaef, 0x0000aeef,
		0x0000b2ef, 0x0000b6ef, 0x0000baef, 0x0000beef,
		0x0000c2ef, 0x0000c6ef, 0x0000caef, 0x0000ceef,
		0x0000d2ef, 0x0000d6ef, 0x0000daef, 0x0000deef,
		0x0000e2ef, 0x0000e6ef, 0x0000eaef, 0x0000eeef,
		0x0000f2ef, 0x0000f6ef, 0x0000faef, 0x0000feef,
		0x000102ef, 0x000106ef, 0x00010aef, 0x00010eef,
		0x000112ef, 0x000116ef, 0x00011aef, 0x00011eef,
		0x000122ef, 0x000126ef, 0x00012aef, 0x00012eef,
		0x000132ef, 0x000136ef, 0x00013aef, 0x00013eef,
		0x000142ef, 0x000146ef, 0x00014aef, 0x00014eef,
		0x000152ef, 0x000156ef, 0x00015aef, 0x00015eef,
		0x000162ef, 0x000166ef, 0x00016aef, 0x00016eef,
		0x000172ef, 0x000176ef, 0x00017aef, 0x00017eef,
		0x000182ef, 0x000186ef, 0x00018aef, 0x00018eef,
		0x000192ef, 0x000196ef, 0x00019aef, 0x00019eef,
		0x0001a2ef, 0x0001a6ef, 0x0001aaef, 0x0001aeef,
		0x0001b2ef, 0x0001b6ef, 0x0001baef, 0x0001beef,
		0x0001c2ef, 0x0001c6ef, 0x0001caef, 0x0001ceef,
		0x0001d2ef, 0x0001d6ef, 0x0001daef, 0x0001deef,
		0x0001e2ef, 0x0001e6ef, 0x0001eaef, 0x0001eeef,
		0x0001f2ef, 0x0001f6ef, 0x0001faef, 0x0001feef,
		0x000202ef, 0x000206ef, 0x00020aef, 0x00020eef,
		0x000212ef, 0x000216ef, 0x00021aef, 0x00021eef,
		0x000222ef, 0x000226ef, 0x00022aef, 0x00022eef,
		0x000232ef, 0x000236ef, 0x00023aef, 0x00023eef,
		0x000242ef, 0x000246ef, 0x00024aef, 0x00024eef,
		0x000252ef, 0x000256ef, 0x00025aef, 0x00025eef,
		0x000262ef, 0x000266ef, 0x00026aef, 0x00026eef,
		0x000272ef, 0x000276ef, 0x00027aef, 0x00027eef,
		0x000282ef, 0x000286ef, 0x00028aef, 0x00028eef,
		0x000292ef, 0x000296ef, 0x00029aef, 0x00029eef,
		0x0002a2ef, 0x0002a6ef, 0x0002aaef, 0x0002aeef,
		0x0002b2ef, 0x0002b6ef, 0x0002baef, 0x0002beef,
		0x0002c2ef, 0x0002c6ef, 0x0002caef, 0x0002ceef,
		0x0002d2ef, 0x0002d6ef, 0x0002daef, 0x0002deef,
		0x0002e2ef, 0x0002e6ef, 0x0002eaef, 0x0002eeef,
		0x0002f2ef, 0x0002f6ef, 0x0002faef, 0x0002feef,
		0x000302ef, 0x000306ef, 0x00030aef, 0x00030eef,
		0x000312ef, 0x000316ef, 0x00031aef, 0x00031eef,
		0x000322ef, 0x000326ef, 0x00032aef, 0x00032eef,
		0x000332ef, 0x000336ef, 0x00033aef, 0x00033eef,
		0x000342ef, 0x000346ef, 0x00034aef, 0x00034eef,
		0x000352ef, 0x000356ef, 0x00035aef, 0x00035eef,
		0x000362ef, 0x000366ef, 0x00036aef, 0x00036eef,
		0x000372ef, 0x000376ef, 0x00037aef, 0x00037eef,
		0x000382ef, 0x000386ef, 0x00038aef, 0x00038eef,
		0x000392ef, 0x000396ef, 0x00039aef, 0x00039eef,
		0x0003a2ef, 0x0003a6ef, 0x0003aaef, 0x0003aeef,
		0x0003b2ef, 0x0003b6ef, 0x0003baef, 0x0003beef,
		0x0003c2ef, 0x0003c6ef, 0x0003caef, 0x0003ceef,
		0x0003d2ef, 0x0003d6ef, 0x0003daef, 0x0003deef,
		0x0003e2ef, 0x0003e6ef, 0x0003eaef, 0x0003eeef,
		0x0003f2ef, 0x0003f6ef, 0x0003faef, 0x0003feef,
		0x000402ef, 0x000406ef, 0x00040aef, 0x00040eef,
		0x000412ef, 0x000416ef, 0x00041aef, 0x00041eef,
		0x000422ef, 0x000426ef, 0x00042aef, 0x00042eef,
		0x000432ef, 0x000436ef, 0x00043aef, 0x00043eef,
		0x000442ef, 0x000446ef, 0x00044aef, 0x00044eef,
		0x000452ef, 0x000456ef, 0x00045aef, 0x00045eef,
		0x000462ef, 0x000466ef, 0x00046aef, 0x00046eef,
		0x000472ef, 0x000476ef, 0x00047aef, 0x00047eef,
		0x000482ef, 0x000486ef, 0x00048aef, 0x00048eef,
		0x000492ef, 0x000496ef, 0x00049aef, 0x00049eef,
		0x0004a2ef, 0x0004a6ef, 0x0004aaef, 0x0004aeef,
		0x0004b2ef, 0x0004b6ef, 0x0004baef, 0x0004beef,
		0x0004c2ef, 0x0004c6ef, 0x0004caef, 0x0004ceef,
		0x0004d2ef, 0x0004d6ef, 0x0004daef, 0x0004deef,
		0x0004e2ef, 0x0004e6ef, 0x0004eaef, 0x0004eeef,
		0x0004f2ef, 0x0004f6ef, 0x0004faef, 0x0004feef,
		0x000502ef, 0x000506ef, 0x00050aef, 0x00050eef,
		0x000512ef, 0x000516ef, 0x00051aef, 0x00051eef,
		0x000522ef, 0x000526ef, 0x00052aef, 0x00052eef,
		0x000532ef, 0x000536ef, 0x00053aef, 0x00053eef,
		0x000542ef, 0x000546ef, 0x00054aef, 0x00054eef,
		0x000552ef, 0x000556ef, 0x00055aef, 0x00055eef,
		0x000562ef, 0x000566ef, 0x00056aef, 0x00056eef,
		0x000572ef, 0x000576ef, 0x00057aef, 0x00057eef,
		0x000582ef, 0x000586ef, 0x00058aef, 0x00058eef,
		0x000592ef, 0x000596ef, 0x00059aef, 0x00059eef,
		0x0005a2ef, 0x0005a6ef, 0x0005aaef, 0x0005aeef,
		0x0005b2ef, 0x0005b6ef, 0x0005baef, 0x0005beef,
		0x0005c2ef, 0x0005c6ef, 0x0005caef, 0x0005ceef,
		0x0005d2ef, 0x0005d6ef, 0x0005daef, 0x0005deef,
		0x0005e2ef, 0x0005e6ef, 0x0005eaef, 0x0005eeef,
		0x0005f2ef, 0x0005f6ef, 0x0005faef, 0x0005feef,
		0x000602ef, 0x000606ef, 0x00060aef, 0x00060eef,
		0x000612ef, 0x000616ef, 0x00061aef, 0x00061eef,
		0x000622ef, 0x000626ef, 0x00062aef, 0x00062eef,
		0x000632ef, 0x000636ef, 0x00063aef, 0x00063eef,
		0x000642ef, 0x000646ef, 0x00064aef, 0x00064eef,
		0x000652ef, 0x000656ef, 0x00065aef, 0x00065eef,
		0x000662ef, 0x000666ef, 0x00066aef, 0x00066eef,
		0x000672ef, 0x000676ef, 0x00067aef, 0x00067eef,
		0x000682ef, 0x000686ef, 0x00068aef, 0x00068eef,
		0x000692ef, 0x000696ef, 0x00069aef, 0x00069eef,
		0x0006a2ef, 0x0006a6ef, 0x0006aaef, 0x0006aeef,
		0x0006b2ef, 0x0006b6ef, 0x0006baef, 0x0006beef,
		0x0006c2ef, 0x0006c6ef, 0x0006caef, 0x0006ceef,
		0x0006d2ef, 0x0006d6ef, 0x0006daef, 0x0006deef,
		0x0006e2ef, 0x0006e6ef, 0x0006eaef, 0x0006eeef,
		0x0006f2ef, 0x0006f6ef, 0x0006faef, 0x0006feef,
		0x000702ef, 0x000706ef, 0x00070aef, 0x00070eef,
		0x000712ef, 0x000716ef, 0x00071aef, 0x00071eef,
		0x000722ef, 0x000726ef, 0x00072aef, 0x00072eef,
		0x000732ef, 0x000736ef, 0x00073aef, 0x00073eef,
		0x000742ef, 0x000746ef, 0x00074aef, 0x00074eef,
		0x000752ef, 0x000756ef, 0x00075aef, 0x00075eef,
		0x000762ef, 0x000766ef, 0x00076aef, 0x00076eef,
		0x000772ef, 0x000776ef, 0x00077aef, 0x00077eef,
		0x000782ef, 0x000786ef, 0x00078aef, 0x00078eef,
		0x000792ef, 0x000796ef, 0x00079aef, 0x00079eef,
		0x0007a2ef, 0x0007a6ef, 0x0007aaef, 0x0007aeef,
		0x0007b2ef, 0x0007b6ef, 0x0007baef, 0x0007beef,
		0x0007c2ef, 0x0007c6ef, 0x0007caef, 0x0007ceef,
		0x0007d2ef, 0x0007d6ef, 0x0007daef, 0x0007deef,
		0x0007e2ef, 0x0007e6ef, 0x0007eaef, 0x0007eeef,
		0x0007f2ef, 0x0007f6ef, 0x0007faef, 0x0007feef,
		0x000802ef, 0x000806ef, 0x00080aef, 0x00080eef,
		0x000812ef, 0x000816ef, 0x00081aef, 0x00081eef,
		0x000822ef, 0x000826ef, 0x00082aef, 0x00082eef,
		0x000832ef, 0x000836ef, 0x00083aef, 0x00083eef,
		0x000842ef, 0x000846ef, 0x00084aef, 0x00084eef,
		0x000852ef, 0x000856ef, 0x00085aef, 0x00085eef,
		0x000862ef, 0x000866ef, 0x00086aef, 0x00086eef,
		0x000872ef, 0x000876ef, 0x00087aef, 0x00087eef,
		0x000882ef, 0x000886ef, 0x00088aef, 0x00088eef,
		0x000892ef, 0x000896ef, 0x00089aef, 0x00089eef,
		0x0008a2ef, 0x0008a6ef, 0x0008aaef, 0x0008aeef,
		0x0008b2ef, 0x0008b6ef, 0x0008baef, 0x0008beef,
		0x0008c2ef, 0x0008c6ef, 0x0008caef, 0x0008ceef,
		0x0008d2ef, 0x0008d6ef, 0x0008daef, 0x0008deef,
		0x0008e2ef, 0x0008e6ef, 0x0008eaef, 0x0008eeef,
		0x0008f2ef, 0x0008f6ef, 0x0008faef, 0x0008feef,
		0x000902ef, 0x000906ef, 0x00090aef, 0x00090eef,
		0x000912ef, 0x000916ef, 0x00091aef, 0x00091eef,
		0x000922ef, 0x000926ef, 0x00092aef, 0x00092eef,
		0x000932ef, 0x000936ef, 0x00093aef, 0x00093eef,
		0x000942ef, 0x000946ef, 0x00094aef, 0x00094eef,
		0x000952ef, 0x000956ef, 0x00095aef, 0x00095eef,
		0x000962ef, 0x000966ef, 0x00096aef, 0x00096eef,
		0x000972ef, 0x000976ef, 0x00097aef, 0x00097eef,
		0x000982ef, 0x000986ef, 0x00098aef, 0x00098eef,
		0x000992ef, 0x000996ef, 0x00099aef, 0x00099eef,
		0x0009a2ef, 0x0009a6ef, 0x0009aaef, 0x0009aeef,
		0x0009b2ef, 0x0009b6ef, 0x0009baef, 0x0009beef,
		0x0009c2ef, 0x0009c6ef, 0x0009caef, 0x0009ceef,
		0x0009d2ef, 0x0009d6ef, 0x0009daef, 0x0009deef,
		0x0009e2ef, 0x0009e6ef, 0x0009eaef, 0x0009eeef,
		0x0009f2ef, 0x0009f6ef, 0x0009faef, 0x0009feef,
		0x000a02ef, 0x000a06ef, 0x000a0aef, 0x000a0eef,
		0x000a12ef, 0x000a16ef, 0x000a1aef, 0x000a1eef,
		0x000a22ef, 0x000a26ef, 0x000a2aef, 0x000a2eef,
		0x000a32ef, 0x000a36ef, 0x000a3aef, 0x000a3eef,
		0x000a42ef, 0x000a46ef, 0x000a4aef, 0x000a4eef,
		0x000a52ef, 0x000a56ef, 0x000a5aef, 0x000a5eef,
		0x000a62ef, 0x000a66ef, 0x000a6aef, 0x000a6eef,
		0x000a72ef, 0x000a76ef, 0x000a7aef, 0x000a7eef,
		0x000a82ef, 0x000a86ef, 0x000a8aef, 0x000a8eef,
		0x000a92ef, 0x000a96ef, 0x000a9aef, 0x000a9eef,
		0x000aa2ef, 0x000aa6ef, 0x000aaaef, 0x000aaeef,
		0x000ab2ef, 0x000ab6ef, 0x000abaef, 0x000abeef,
		0x000ac2ef, 0x000ac6ef, 0x000acaef, 0x000aceef,
		0x000ad2ef, 0x000ad6ef, 0x000adaef, 0x000adeef,
		0x000ae2ef, 0x000ae6ef, 0x000aeaef, 0x000aeeef,
		0x000af2ef, 0x000af6ef, 0x000afaef, 0x000afeef,
		0x000b02ef, 0x000b06ef, 0x000b0aef, 0x000b0eef,
		0x000b12ef, 0x000b16ef, 0x000b1aef, 0x000b1eef,
		0x000b22ef, 0x000b26ef, 0x000b2aef, 0x000b2eef,
		0x000b32ef, 0x000b36ef, 0x000b3aef, 0x000b3eef,
		0x000b42ef, 0x000b46ef, 0x000b4aef, 0x000b4eef,
		0x000b52ef, 0x000b56ef, 0x000b5aef, 0x000b5eef,
		0x000b62ef, 0x000b66ef, 0x000b6aef, 0x000b6eef,
		0x000b72ef, 0x000b76ef, 0x000b7aef, 0x000b7eef,
		0x000b82ef, 0x000b86ef, 0x000b8aef, 0x000b8eef,
		0x000b92ef, 0x000b96ef, 0x000b9aef, 0x000b9eef,
		0x000ba2ef, 0x000ba6ef, 0x000baaef, 0x000baeef,
		0x000bb2ef, 0x000bb6ef, 0x000bbaef, 0x000bbeef,
		0x000bc2ef, 0x000bc6ef, 0x000bcaef, 0x000bceef,
		0x000bd2ef, 0x000bd6ef, 0x000bdaef, 0x000bdeef,
		0x000be2ef, 0x000be6ef, 0x000beaef, 0x000beeef,
		0x000bf2ef, 0x000bf6ef, 0x000bfaef, 0x000bfeef,
		0x000c02ef, 0x000c06ef, 0x000c0aef, 0x000c0eef,
		0x000c12ef, 0x000c16ef, 0x000c1aef, 0x000c1eef,
		0x000c22ef, 0x000c26ef, 0x000c2aef, 0x000c2eef,
		0x000c32ef, 0x000c36ef, 0x000c3aef, 0x000c3eef,
		0x000c42ef, 0x000c46ef, 0x000c4aef, 0x000c4eef,
		0x000c52ef, 0x000c56ef, 0x000c5aef, 0x000c5eef,
		0x000c62ef, 0x000c66ef, 0x000c6aef, 0x000c6eef,
		0x000c72ef, 0x000c76ef, 0x000c7aef, 0x000c7eef,
		0x000c82ef, 0x000c86ef, 0x000c8aef, 0x000c8eef,
		0x000c92ef, 0x000c96ef, 0x000c9aef, 0x000c9eef,
		0x000ca2ef, 0x000ca6ef, 0x000caaef, 0x000caeef,
		0x000cb2ef, 0x000cb6ef, 0x000cbaef, 0x000cbeef,
		0x000cc2ef, 0x000cc6ef, 0x000ccaef, 0x000cceef,
		0x000cd2ef, 0x000cd6ef, 0x000cdaef, 0x000cdeef,
		0x000ce2ef, 0x000ce6ef, 0x000ceaef, 0x000ceeef,
		0x000cf2ef, 0x000cf6ef, 0x000cfaef, 0x000cfeef,
		0x000d02ef, 0x000d06ef, 0x000d0aef, 0x000d0eef,
		0x000d12ef, 0x000d16ef, 0x000d1aef, 0x000d1eef,
		0x000d22ef, 0x000d26ef, 0x000d2aef, 0x000d2eef,
		0x000d32ef, 0x000d36ef, 0x000d3aef, 0x000d3eef,
		0x000d42ef, 0x000d46ef, 0x000d4aef, 0x000d4eef,
		0x000d52ef, 0x000d56ef, 0x000d5aef, 0x000d5eef,
		0x000d62ef, 0x000d66ef, 0x000d6aef, 0x000d6eef,
		0x000d72ef, 0x000d76ef, 0x000d7aef, 0x000d7eef,
		0x000d82ef, 0x000d86ef, 0x000d8aef, 0x000d8eef,
		0x000d92ef, 0x000d96ef, 0x000d9aef, 0x000d9eef,
		0x000da2ef, 0x000da6ef, 0x000daaef, 0x000daeef,
		0x000db2ef, 0x000db6ef, 0x000dbaef, 0x000dbeef,
		0x000dc2ef, 0x000dc6ef, 0x000dcaef, 0x000dceef,
		0x000dd2ef, 0x000dd6ef, 0x000ddaef, 0x000ddeef,
		0x000de2ef, 0x000de6ef, 0x000deaef, 0x000deeef,
		0x000df2ef, 0x000df6ef, 0x000dfaef, 0x000dfeef,
		0x000e02ef, 0x000e06ef, 0x000e0aef, 0x000e0eef,
		0x000e12ef, 0x000e16ef, 0x000e1aef, 0x000e1eef,
		0x000e22ef, 0x000e26ef, 0x000e2aef, 0x000e2eef,
		0x000e32ef, 0x000e36ef, 0x000e3aef, 0x000e3eef,
		0x000e42ef, 0x000e46ef, 0x000e4aef, 0x000e4eef,
		0x000e52ef, 0x000e56ef, 0x000e5aef, 0x000e5eef,
		0x000e62ef, 0x000e66ef, 0x000e6aef, 0x000e6eef,
		0x000e72ef, 0x000e76ef, 0x000e7aef, 0x000e7eef,
		0x000e82ef, 0x000e86ef, 0x000e8aef, 0x000e8eef,
		0x000e92ef, 0x000e96ef, 0x000e9aef, 0x000e9eef,
		0x000ea2ef, 0x000ea6ef, 0x000eaaef, 0x000eaeef,
		0x000eb2ef, 0x000eb6ef, 0x000ebaef, 0x000ebeef,
		0x000ec2ef, 0x000ec6ef, 0x000ecaef, 0x000eceef,
		0x000ed2ef, 0x000ed6ef, 0x000edaef, 0x000edeef,
		0x000ee2ef, 0x000ee6ef, 0x000eeaef, 0x000eeeef,
		0x000ef2ef, 0x000ef6ef, 0x000efaef, 0x000efeef,
		0x000f02ef, 0x000f06ef, 0x000f0aef, 0x000f0eef,
		0x000f12ef, 0x000f16ef, 0x000f1aef, 0x000f1eef,
		0x000f22ef, 0x000f26ef, 0x000f2aef, 0x000f2eef,
		0x000f32ef, 0x000f36ef, 0x000f3aef, 0x000f3eef,
		0x000f42ef, 0x000f46ef, 0x000f4aef, 0x000f4eef,
		0x000f52ef, 0x000f56ef, 0x000f5aef, 0x000f5eef,
		0x000f62ef, 0x000f66ef, 0x000f6aef, 0x000f6eef,
		0x000f72ef, 0x000f76ef, 0x000f7aef, 0x000f7eef,
		0x000f82ef, 0x000f86ef, 0x000f8aef, 0x000f8eef,
		0x000f92ef, 0x000f96ef, 0x000f9aef, 0x000f9eef,
		0x000fa2ef, 0x000fa6ef, 0x000faaef, 0x000faeef,
		0x000fb2ef, 0x000fb6ef, 0x000fbaef, 0x000fbeef,
		0x000fc2ef, 0x000fc6ef, 0x000fcaef, 0x000fceef,
		0x000fd2ef, 0x000fd6ef, 0x000fdaef, 0x000fdeef,
		0x000fe2ef, 0x000fe6ef, 0x000feaef, 0x000feeef,
		0x000ff2ef, 0x000ff6ef, 0x000ffaef, 0x000ffeef,
		0x000017f4, 0x000057f4, 0x000097f4, 0x0000d7f4,
		0x000117f4, 0x000157f4, 0x000197f4, 0x0001d7f4,
		0x000217f4, 0x000257f4, 0x000297f4, 0x0002d7f4,
		0x000317f4, 0x000357f4, 0x000397f4, 0x0003d7f4,
		0x000417f4, 0x000457f4, 0x000497f4, 0x0004d7f4,
		0x000517f4, 0x000557f4, 0x000597f4, 0x0005d7f4,
		0x000617f4, 0x000657f4, 0x000697f4, 0x0006d7f4,
		0x000717f4, 0x000757f4, 0x000797f4, 0x0007d7f4,
		0x000817f4, 0x000857f4, 0x000897f4, 0x0008d7f4,
		0x000917f4, 0x000957f4, 0x000997f4, 0x0009d7f4,
		0x000a17f4, 0x000a57f4, 0x000a97f4, 0x000ad7f4,
		0x000b17f4, 0x000b57f4, 0x000b97f4, 0x000bd7f4,
		0x000c17f4, 0x000c57f4, 0x000c97f4, 0x000cd7f4,
		0x000d17f4, 0x000d57f4, 0x000d97f4, 0x000dd7f4,
		0x000e17f4, 0x000e57f4, 0x000e97f4, 0x000ed7f4,
		0x000f17f4, 0x000f57f4, 0x000f97f4, 0x000fd7f4,
		0x001017f4, 0x001057f4, 0x001097f4, 0x0010d7f4,
		0x001117f4, 0x001157f4, 0x001197f4, 0x0011d7f4,
		0x001217f4, 0x001257f4, 0x001297f4, 0x0012d7f4,
		0x001317f4, 0x001357f4, 0x001397f4, 0x0013d7f4,
		0x001417f4, 0x001457f4, 0x001497f4, 0x0014d7f4,
		0x001517f4, 0x001557f4, 0x001597f4, 0x0015d7f4,
		0x001617f4, 0x001657f4, 0x001697f4, 0x0016d7f4,
		0x001717f4, 0x001757f4, 0x001797f4, 0x0017d7f4,
		0x001817f4, 0x001857f4, 0x001897f4, 0x0018d7f4,
		0x001917f4, 0x001957f4, 0x001997f4, 0x0019d7f4,
		0x001a17f4, 0x001a57f4, 0x001a97f4, 0x001ad7f4,
		0x001b17f4, 0x001b57f4, 0x001b97f4, 0x001bd7f4,
		0x001c17f4, 0x001c57f4, 0x001c97f4, 0x001cd7f4,
		0x001d17f4, 0x001d57f4, 0x001d97f4, 0x001dd7f4,
		0x001e17f4, 0x001e57f4, 0x001e97f4, 0x001ed7f4,
		0x001f17f4, 0x001f57f4, 0x001f97f4, 0x001fd7f4,
		0x002017f4, 0x002057f4, 0x002097f4, 0x0020d7f4,
		0x002117f4, 0x002157f4, 0x002197f4, 0x0021d7f4,
		0x002217f4, 0x002257f4, 0x002297f4, 0x0022d7f4,
		0x002317f4, 0x002357f4, 0x002397f4, 0x0023d7f4,
		0x002417f4, 0x002457f4, 0x002497f4, 0x0024d7f4,
		0x002517f4, 0x002557f4, 0x002597f4, 0x0025d7f4,
		0x002617f4, 0x002657f4, 0x002697f4, 0x0026d7f4,
		0x002717f4, 0x002757f4, 0x002797f4, 0x0027d7f4,
		0x002817f4, 0x002857f4, 0x002897f4, 0x0028d7f4,
		0x002917f4, 0x002957f4, 0x002997f4, 0x0029d7f4,
		0x002a17f4, 0x002a57f4, 0x002a97f4, 0x002ad7f4,
		0x002b17f4, 0x002b57f4, 0x002b97f4, 0x002bd7f4,
		0x002c17f4, 0x002c57f4, 0x002c97f4, 0x002cd7f4,
		0x002d17f4, 0x002d57f4, 0x002d97f4, 0x002dd7f4,
		0x002e17f4, 0x002e57f4, 0x002e97f4, 0x002ed7f4,
		0x002f17f4, 0x002f57f4, 0x002f97f4, 0x002fd7f4,
		0x003017f4, 0x003057f4, 0x003097f4, 0x0030d7f4,
		0x003117f4, 0x003157f4, 0x003197f4, 0x0031d7f4,
		0x003217f4, 0x003257f4, 0x003297f4, 0x0032d7f4,
		0x003317f4, 0x003357f4, 0x003397f4, 0x0033d7f4,
		0x003417f4, 0x003457f4, 0x003497f4, 0x0034d7f4,
		0x003517f4, 0x003557f4, 0x003597f4, 0x0035d7f4,
		0x003617f4, 0x003657f4, 0x003697f4, 0x0036d7f4,
		0x003717f4, 0x003757f4, 0x003797f4, 0x0037d7f4,
		0x003817f4, 0x003857f4, 0x003897f4, 0x0038d7f4,
		0x003917f4, 0x003957f4, 0x003997f4, 0x0039d7f4,
		0x003a17f4, 0x003a57f4, 0x003a97f4, 0x003ad7f4,
		0x003b17f4, 0x003b57f4, 0x003b97f4, 0x003bd7f4,
		0x003c17f4, 0x003c57f4, 0x003c97f4, 0x003cd7f4,
		0x003d17f4, 0x003d57f4, 0x003d97f4, 0x003dd7f4,
		0x003e17f4, 0x003e57f4, 0x003e97f4, 0x003ed7f4,
		0x003f17f4, 0x003f57f4, 0x003f97f4, 0x003fd7f4,
		0x004017f4, 0x004057f4, 0x004097f4, 0x0040d7f4,
		0x004117f4, 0x004157f4, 0x004197f4, 0x0041d7f4,
		0x004217f4, 0x004257f4, 0x004297f4, 0x0042d7f4,
		0x004317f4, 0x004357f4, 0x004397f4, 0x0043d7f4,
		0x004417f4, 0x004457f4, 0x004497f4, 0x0044d7f4,
		0x004517f4, 0x004557f4, 0x004597f4, 0x0045d7f4,
		0x004617f4, 0x004657f4, 0x004697f4, 0x0046d7f4,
		0x004717f4, 0x004757f4, 0x004797f4, 0x0047d7f4,
		0x004817f4, 0x004857f4, 0x004897f4, 0x0048d7f4,
		0x004917f4, 0x004957f4, 0x004997f4, 0x0049d7f4,
		0x004a17f4, 0x004a57f4, 0x004a97f4, 0x004ad7f4,
		0x004b17f4, 0x004b57f4, 0x004b97f4, 0x004bd7f4,
		0x004c17f4, 0x004c57f4, 0x004c97f4, 0x004cd7f4,
		0x004d17f4, 0x004d57f4, 0x004d97f4, 0x004dd7f4,
		0x004e17f4, 0x004e57f4, 0x004e97f4, 0x004ed7f4,
		0x004f17f4, 0x004f57f4, 0x004f97f4, 0x004fd7f4,
		0x005017f4, 0x005057f4, 0x005097f4, 0x0050d7f4,
		0x005117f4, 0x005157f4, 0x005197f4, 0x0051d7f4,
		0x005217f4, 0x005257f4, 0x005297f4, 0x0052d7f4,
		0x005317f4, 0x005357f4, 0x005397f4, 0x0053d7f4,
		0x005417f4, 0x005457f4, 0x005497f4, 0x0054d7f4,
		0x005517f4, 0x005557f4, 0x005597f4, 0x0055d7f4,
		0x005617f4, 0x005657f4, 0x005697f4, 0x0056d7f4,
		0x005717f4, 0x005757f4, 0x005797f4, 0x0057d7f4,
		0x005817f4, 0x005857f4, 0x005897f4, 0x0058d7f4,
		0x005917f4, 0x005957f4, 0x005997f4, 0x0059d7f4,
		0x005a17f4, 0x005a57f4, 0x005a97f4, 0x005ad7f4,
		0x005b17f4, 0x005b57f4, 0x005b97f4, 0x005bd7f4,
		0x005c17f4, 0x005c57f4, 0x005c97f4, 0x005cd7f4,
		0x005d17f4, 0x005d57f4, 0x005d97f4, 0x005dd7f4,
		0x005e17f4, 0x005e57f4, 0x005e97f4, 0x005ed7f4,
		0x005f17f4, 0x005f57f4, 0x005f97f4, 0x005fd7f4,
		0x006017f4, 0x006057f4, 0x006097f4, 0x0060d7f4,
		0x006117f4, 0x006157f4, 0x006197f4, 0x0061d7f4,
		0x006217f4, 0x006257f4, 0x006297f4, 0x0062d7f4,
		0x006317f4, 0x006357f4, 0x006397f4, 0x0063d7f4,
		0x006417f4, 0x006457f4, 0x006497f4, 0x0064d7f4,
		0x006517f4, 0x006557f4, 0x006597f4, 0x0065d7f4,
		0x006617f4, 0x006657f4, 0x006697f4, 0x0066d7f4,
		0x006717f4, 0x006757f4, 0x006797f4, 0x0067d7f4,
		0x006817f4, 0x006857f4, 0x006897f4, 0x0068d7f4,
		0x006917f4, 0x006957f4, 0x006997f4, 0x0069d7f4,
		0x006a17f4, 0x006a57f4, 0x006a97f4, 0x006ad7f4,
		0x006b17f4, 0x006b57f4, 0x006b97f4, 0x006bd7f4,
		0x006c17f4, 0x006c57f4, 0x006c97f4, 0x006cd7f4,
		0x006d17f4, 0x006d57f4, 0x006d97f4, 0x006dd7f4,
		0x006e17f4, 0x006e57f4, 0x006e97f4, 0x006ed7f4,
		0x006f17f4, 0x006f57f4, 0x006f97f4, 0x006fd7f4,
		0x007017f4, 0x007057f4, 0x007097f4, 0x0070d7f4,
		0x007117f4, 0x007157f4, 0x007197f4, 0x0071d7f4,
		0x007217f4, 0x007257f4, 0x007297f4, 0x0072d7f4,
		0x007317f4, 0x007357f4, 0x007397f4, 0x0073d7f4,
		0x007417f4, 0x007457f4, 0x007497f4, 0x0074d7f4,
		0x007517f4, 0x007557f4, 0x007597f4, 0x0075d7f4,
		0x007617f4, 0x007657f4, 0x007697f4, 0x0076d7f4,
		0x007717f4, 0x007757f4, 0x007797f4, 0x0077d7f4,
		0x007817f4, 0x007857f4, 0x007897f4, 0x0078d7f4,
		0x007917f4, 0x007957f4, 0x007997f4, 0x0079d7f4,
		0x007a17f4, 0x007a57f4, 0x007a97f4, 0x007ad7f4,
		0x007b17f4, 0x007b57f4, 0x007b97f4, 0x007bd7f4,
		0x007c17f4, 0x007c57f4, 0x007c97f4, 0x007cd7f4,
		0x007d17f4, 0x007d57f4, 0x007d97f4, 0x007dd7f4,
		0x007e17f4, 0x007e57f4, 0x007e97f4, 0x007ed7f4,
		0x007f17f4, 0x007f57f4, 0x007f97f4, 0x007fd7f4,
		0x008017f4, 0x008057f4, 0x008097f4, 0x0080d7f4,
		0x008117f4, 0x008157f4, 0x008197f4, 0x0081d7f4,
		0x008217f4, 0x008257f4, 0x008297f4, 0x0082d7f4,
		0x008317f4, 0x008357f4, 0x008397f4, 0x0083d7f4,
		0x008417f4, 0x008457f4, 0x008497f4, 0x0084d7f4,
		0x008517f4, 0x008557f4, 0x008597f4, 0x0085d7f4,
		0x008617f4, 0x008657f4, 0x008697f4, 0x0086d7f4,
		0x008717f4, 0x008757f4, 0x008797f4, 0x0087d7f4,
		0x008817f4, 0x008857f4, 0x008897f4, 0x0088d7f4,
		0x008917f4, 0x008957f4, 0x008997f4, 0x0089d7f4,
		0x008a17f4, 0x008a57f4, 0x008a97f4, 0x008ad7f4,
		0x008b17f4, 0x008b57f4, 0x008b97f4, 0x008bd7f4,
		0x008c17f4, 0x008c57f4, 0x008c97f4, 0x008cd7f4,
		0x008d17f4, 0x008d57f4, 0x008d97f4, 0x008dd7f4,
		0x008e17f4, 0x008e57f4, 0x008e97f4, 0x008ed7f4,
		0x008f17f4, 0x008f57f4, 0x008f97f4, 0x008fd7f4,
		0x009017f4, 0x009057f4, 0x009097f4, 0x0090d7f4,
		0x009117f4, 0x009157f4, 0x009197f4, 0x0091d7f4,
		0x009217f4, 0x009257f4, 0x009297f4, 0x0092d7f4,
		0x009317f4, 0x009357f4, 0x009397f4, 0x0093d7f4,
		0x009417f4, 0x009457f4, 0x009497f4, 0x0094d7f4,
		0x009517f4, 0x009557f4, 0x009597f4, 0x0095d7f4,
		0x009617f4, 0x009657f4, 0x009697f4, 0x0096d7f4,
		0x009717f4, 0x009757f4, 0x009797f4, 0x0097d7f4,
		0x009817f4, 0x009857f4, 0x009897f4, 0x0098d7f4,
		0x009917f4, 0x009957f4, 0x009997f4, 0x0099d7f4,
		0x009a17f4, 0x009a57f4, 0x009a97f4, 0x009ad7f4,
		0x009b17f4, 0x009b57f4, 0x009b97f4, 0x009bd7f4,
		0x009c17f4, 0x009c57f4, 0x009c97f4, 0x009cd7f4,
		0x009d17f4, 0x009d57f4, 0x009d97f4, 0x009dd7f4,
		0x009e17f4, 0x009e57f4, 0x009e97f4, 0x009ed7f4,
		0x009f17f4, 0x009f57f4, 0x009f97f4, 0x009fd7f4,
		0x00a017f4, 0x00a057f4, 0x00a097f4, 0x00a0d7f4,
		0x00a117f4, 0x00a157f4, 0x00a197f4, 0x00a1d7f4,
		0x00a217f4, 0x00a257f4, 0x00a297f4, 0x00a2d7f4,
		0x00a317f4, 0x00a357f4, 0x00a397f4, 0x00a3d7f4,
		0x00a417f4, 0x00a457f4, 0x00a497f4, 0x00a4d7f4,
		0x00a517f4, 0x00a557f4, 0x00a597f4, 0x00a5d7f4,
		0x00a617f4, 0x00a657f4, 0x00a697f4, 0x00a6d7f4,
		0x00a717f4, 0x00a757f4, 0x00a797f4, 0x00a7d7f4,
		0x00a817f4, 0x00a857f4, 0x00a897f4, 0x00a8d7f4,
		0x00a917f4, 0x00a957f4, 0x00a997f4, 0x00a9d7f4,
		0x00aa17f4, 0x00aa57f4, 0x00aa97f4, 0x00aad7f4,
		0x00ab17f4, 0x00ab57f4, 0x00ab97f4, 0x00abd7f4,
		0x00ac17f4, 0x00ac57f4, 0x00ac97f4, 0x00acd7f4,
		0x00ad17f4, 0x00ad57f4, 0x00ad97f4, 0x00add7f4,
		0x00ae17f4, 0x00ae57f4, 0x00ae97f4, 0x00aed7f4,
		0x00af17f4, 0x00af57f4, 0x00af97f4, 0x00afd7f4,
		0x00b017f4, 0x00b057f4, 0x00b097f4, 0x00b0d7f4,
		0x00b117f4, 0x00b157f4, 0x00b197f4, 0x00b1d7f4,
		0x00b217f4, 0x00b257f4, 0x00b297f4, 0x00b2d7f4,
		0x00b317f4, 0x00b357f4, 0x00b397f4, 0x00b3d7f4,
		0x00b417f4, 0x00b457f4, 0x00b497f4, 0x00b4d7f4,
		0x00b517f4, 0x00b557f4, 0x00b597f4, 0x00b5d7f4,
		0x00b617f4, 0x00b657f4, 0x00b697f4, 0x00b6d7f4,
		0x00b717f4, 0x00b757f4, 0x00b797f4, 0x00b7d7f4,
		0x00b817f4, 0x00b857f4, 0x00b897f4, 0x00b8d7f4,
		0x00b917f4, 0x00b957f4, 0x00b997f4, 0x00b9d7f4,
		0x00ba17f4, 0x00ba57f4, 0x00ba97f4, 0x00bad7f4,
		0x00bb17f4, 0x00bb57f4, 0x00bb97f4, 0x00bbd7f4,
		0x00bc17f4, 0x00bc57f4, 0x00bc97f4, 0x00bcd7f4,
		0x00bd17f4, 0x00bd57f4, 0x00bd97f4, 0x00bdd7f4,
		0x00be17f4, 0x00be57f4, 0x00be97f4, 0x00bed7f4,
		0x00bf17f4, 0x00bf57f4, 0x00bf97f4, 0x00bfd7f4,
		0x00c017f4, 0x00c057f4, 0x00c097f4, 0x00c0d7f4,
		0x00c117f4, 0x00c157f4, 0x00c197f4, 0x00c1d7f4,
		0x00c217f4, 0x00c257f4, 0x00c297f4, 0x00c2d7f4,
		0x00c317f4, 0x00c357f4, 0x00c397f4, 0x00c3d7f4,
		0x00c417f4, 0x00c457f4, 0x00c497f4, 0x00c4d7f4,
		0x00c517f4, 0x00c557f4, 0x00c597f4, 0x00c5d7f4,
		0x00c617f4, 0x00c657f4, 0x00c697f4, 0x00c6d7f4,
		0x00c717f4, 0x00c757f4, 0x00c797f4, 0x00c7d7f4,
		0x00c817f4, 0x00c857f4, 0x00c897f4, 0x00c8d7f4,
		0x00c917f4, 0x00c957f4, 0x00c997f4, 0x00c9d7f4,
		0x00ca17f4, 0x00ca57f4, 0x00ca97f4, 0x00cad7f4,
		0x00cb17f4, 0x00cb57f4, 0x00cb97f4, 0x00cbd7f4,
		0x00cc17f4, 0x00cc57f4, 0x00cc97f4, 0x00ccd7f4,
		0x00cd17f4, 0x00cd57f4, 0x00cd97f4, 0x00cdd7f4,
		0x00ce17f4, 0x00ce57f4, 0x00ce97f4, 0x00ced7f4,
		0x00cf17f4, 0x00cf57f4, 0x00cf97f4, 0x00cfd7f4,
		0x00d017f4, 0x00d057f4, 0x00d097f4, 0x00d0d7f4,
		0x00d117f4, 0x00d157f4, 0x00d197f4, 0x00d1d7f4,
		0x00d217f4, 0x00d257f4, 0x00d297f4, 0x00d2d7f4,
		0x00d317f4, 0x00d357f4, 0x00d397f4, 0x00d3d7f4,
		0x00d417f4, 0x00d457f4, 0x00d497f4, 0x00d4d7f4,
		0x00d517f4, 0x00d557f4, 0x00d597f4, 0x00d5d7f4,
		0x00d617f4, 0x00d657f4, 0x00d697f4, 0x00d6d7f4,
		0x00d717f4, 0x00d757f4, 0x00d797f4, 0x00d7d7f4,
		0x00d817f4, 0x00d857f4, 0x00d897f4, 0x00d8d7f4,
		0x00d917f4, 0x00d957f4, 0x00d997f4, 0x00d9d7f4,
		0x00da17f4, 0x00da57f4, 0x00da97f4, 0x00dad7f4,
		0x00db17f4, 0x00db57f4, 0x00db97f4, 0x00dbd7f4,
		0x00dc17f4, 0x00dc57f4, 0x00dc97f4, 0x00dcd7f4,
		0x00dd17f4, 0x00dd57f4, 0x00dd97f4, 0x00ddd7f4,
		0x00de17f4, 0x00de57f4, 0x00de97f4, 0x00ded7f4,
		0x00df17f4, 0x00df57f4, 0x00df97f4, 0x00dfd7f4,
		0x00e017f4, 0x00e057f4, 0x00e097f4, 0x00e0d7f4,
		0x00e117f4, 0x00e157f4, 0x00e197f4, 0x00e1d7f4,
		0x00e217f4, 0x00e257f4, 0x00e297f4, 0x00e2d7f4,
		0x00e317f4, 0x00e357f4, 0x00e397f4, 0x00e3d7f4,
		0x00e417f4, 0x00e457f4, 0x00e497f4, 0x00e4d7f4,
		0x00e517f4, 0x00e557f4, 0x00e597f4, 0x00e5d7f4,
		0x00e617f4, 0x00e657f4, 0x00e697f4, 0x00e6d7f4,
		0x00e717f4, 0x00e757f4, 0x00e797f4, 0x00e7d7f4,
		0x00e817f4, 0x00e857f4, 0x00e897f4, 0x00e8d7f4,
		0x00e917f4, 0x00e957f4, 0x00e997f4, 0x00e9d7f4,
		0x00ea17f4, 0x00ea57f4, 0x00ea97f4, 0x00ead7f4,
		0x00eb17f4, 0x00eb57f4, 0x00eb97f4, 0x00ebd7f4,
		0x00ec17f4, 0x00ec57f4, 0x00ec97f4, 0x00ecd7f4,
		0x00ed17f4, 0x00ed57f4, 0x00ed97f4, 0x00edd7f4,
		0x00ee17f4, 0x00ee57f4, 0x00ee97f4, 0x00eed7f4,
		0x00ef17f4, 0x00ef57f4, 0x00ef97f4, 0x00efd7f4,
		0x00f017f4, 0x00f057f4, 0x00f097f4, 0x00f0d7f4,
		0x00f117f4, 0x00f157f4, 0x00f197f4, 0x00f1d7f4,
		0x00f217f4, 0x00f257f4, 0x00f297f4, 0x00f2d7f4,
		0x00f317f4, 0x00f357f4, 0x00f397f4, 0x00f3d7f4,
		0x00f417f4, 0x00f457f4, 0x00f497f4, 0x00f4d7f4,
		0x00f517f4, 0x00f557f4, 0x00f597f4, 0x00f5d7f4,
		0x00f617f4, 0x00f657f4, 0x00f697f4, 0x00f6d7f4,
		0x00f717f4, 0x00f757f4, 0x00f797f4, 0x00f7d7f4,
		0x00f817f4, 0x00f857f4, 0x00f897f4, 0x00f8d7f4,
		0x00f917f4, 0x00f957f4, 0x00f997f4, 0x00f9d7f4,
		0x00fa17f4, 0x00fa57f4, 0x00fa97f4, 0x00fad7f4,
		0x00fb17f4, 0x00fb57f4, 0x00fb97f4, 0x00fbd7f4,
		0x00fc17f4, 0x00fc57f4, 0x00fc97f4, 0x00fcd7f4,
		0x00fd17f4, 0x00fd57f4, 0x00fd97f4, 0x00fdd7f4,
		0x00fe17f4, 0x00fe57f4, 0x00fe97f4, 0x00fed7f4,
		0x00ff17f4, 0x00ff57f4, 0x00ff97f4, 0x00ffd7f4,
		0x010017f4, 0x010057f4, 0x010097f4, 0x0100d7f4,
		0x010117f4, 0x010157f4, 0x010197f4, 0x0101d7f4,
		0x010217f4, 0x010257f4, 0x010297f4, 0x0102d7f4,
		0x010317f4, 0x010357f4, 0x010397f4, 0x0103d7f4,
		0x010417f4, 0x010457f4, 0x010497f4, 0x0104d7f4,
		0x010517f4, 0x010557f4, 0x010597f4, 0x0105d7f4,
		0x010617f4, 0x010657f4, 0x010697f4, 0x0106d7f4,
		0x010717f4, 0x010757f4, 0x010797f4, 0x0107d7f4,
		0x010817f4, 0x010857f4, 0x010897f4, 0x0108d7f4,
		0x010917f4, 0x010957f4, 0x010997f4, 0x0109d7f4,
		0x010a17f4, 0x010a57f4, 0x010a97f4, 0x010ad7f4,
		0x010b17f4, 0x010b57f4, 0x010b97f4, 0x010bd7f4,
		0x010c17f4, 0x010c57f4, 0x010c97f4, 0x010cd7f4,
		0x010d17f4, 0x010d57f4, 0x010d97f4, 0x010dd7f4,
		0x010e17f4, 0x010e57f4, 0x010e97f4, 0x010ed7f4,
		0x010f17f4, 0x010f57f4, 0x010f97f4, 0x010fd7f4,
		0x011017f4, 0x011057f4, 0x011097f4, 0x0110d7f4,
		0x011117f4, 0x011157f4, 0x011197f4, 0x0111d7f4,
		0x011217f4, 0x011257f4, 0x011297f4, 0x0112d7f4,
		0x011317f4, 0x011357f4, 0x011397f4, 0x0113d7f4,
		0x011417f4, 0x011457f4, 0x011497f4, 0x0114d7f4,
		0x011517f4, 0x011557f4, 0x011597f4, 0x0115d7f4,
		0x011617f4, 0x011657f4, 0x011697f4, 0x0116d7f4,
		0x011717f4, 0x011757f4, 0x011797f4, 0x0117d7f4,
		0x011817f4, 0x011857f4, 0x011897f4, 0x0118d7f4,
		0x011917f4, 0x011957f4, 0x011997f4, 0x0119d7f4,
		0x011a17f4, 0x011a57f4, 0x011a97f4, 0x011ad7f4,
		0x011b17f4, 0x011b57f4, 0x011b97f4, 0x011bd7f4,
		0x011c17f4, 0x011c57f4, 0x011c97f4, 0x011cd7f4,
		0x011d17f4, 0x011d57f4, 0x011d97f4, 0x011dd7f4,
		0x011e17f4, 0x011e57f4, 0x011e97f4, 0x011ed7f4,
		0x011f17f4, 0x011f57f4, 0x011f97f4, 0x011fd7f4,
		0x012017f4, 0x012057f4, 0x012097f4, 0x0120d7f4,
		0x012117f4, 0x012157f4, 0x012197f4, 0x0121d7f4,
		0x012217f4, 0x012257f4, 0x012297f4, 0x0122d7f4,
		0x012317f4, 0x012357f4, 0x012397f4, 0x0123d7f4,
		0x012417f4, 0x012457f4, 0x012497f4, 0x0124d7f4,
		0x012517f4, 0x012557f4, 0x012597f4, 0x0125d7f4,
		0x012617f4, 0x012657f4, 0x012697f4, 0x0126d7f4,
		0x012717f4, 0x012757f4, 0x012797f4, 0x0127d7f4,
		0x012817f4, 0x012857f4, 0x012897f4, 0x0128d7f4,
		0x012917f4, 0x012957f4, 0x012997f4, 0x0129d7f4,
		0x012a17f4, 0x012a57f4, 0x012a97f4, 0x012ad7f4,
		0x012b17f4, 0x012b57f4, 0x012b97f4, 0x012bd7f4,
		0x012c17f4, 0x012c57f4, 0x012c97f4, 0x012cd7f4,
		0x012d17f4, 0x012d57f4, 0x012d97f4, 0x012dd7f4,
		0x012e17f4, 0x012e57f4, 0x012e97f4, 0x012ed7f4,
		0x012f17f4, 0x012f57f4, 0x012f97f4, 0x012fd7f4,
		0x013017f4, 0x013057f4, 0x013097f4, 0x0130d7f4,
		0x013117f4, 0x013157f4, 0x013197f4, 0x0131d7f4,
		0x013217f4, 0x013257f4, 0x013297f4, 0x0132d7f4,
		0x013317f4, 0x013357f4, 0x013397f4, 0x0133d7f4,
		0x013417f4, 0x013457f4, 0x013497f4, 0x0134d7f4,
		0x013517f4, 0x013557f4, 0x013597f4, 0x0135d7f4,
		0x013617f4, 0x013657f4, 0x013697f4, 0x0136d7f4,
		0x013717f4, 0x013757f4, 0x013797f4, 0x0137d7f4,
		0x013817f4, 0x013857f4, 0x013897f4, 0x0138d7f4,
		0x013917f4, 0x013957f4, 0x013997f4, 0x0139d7f4,
		0x013a17f4, 0x013a57f4, 0x013a97f4, 0x013ad7f4,
		0x013b17f4, 0x013b57f4, 0x013b97f4, 0x013bd7f4,
		0x013c17f4, 0x013c57f4, 0x013c97f4, 0x013cd7f4,
		0x013d17f4, 0x013d57f4, 0x013d97f4, 0x013dd7f4,
		0x013e17f4, 0x013e57f4, 0x013e97f4, 0x013ed7f4,
		0x013f17f4, 0x013f57f4, 0x013f97f4, 0x013fd7f4,
		0x014017f4, 0x014057f4, 0x014097f4, 0x0140d7f4,
		0x014117f4, 0x014157f4, 0x014197f4, 0x0141d7f4,
		0x014217f4, 0x014257f4, 0x014297f4, 0x0142d7f4,
		0x014317f4, 0x014357f4, 0x014397f4, 0x0143d7f4,
		0x014417f4, 0x014457f4, 0x014497f4, 0x0144d7f4,
		0x014517f4, 0x014557f4, 0x014597f4, 0x0145d7f4,
		0x014617f4, 0x014657f4, 0x014697f4, 0x0146d7f4,
		0x014717f4, 0x014757f4, 0x014797f4, 0x0147d7f4,
		0x014817f4, 0x014857f4, 0x014897f4, 0x0148d7f4,
		0x014917f4, 0x014957f4, 0x014997f4, 0x0149d7f4,
		0x014a17f4, 0x014a57f4, 0x014a97f4, 0x014ad7f4,
		0x014b17f4, 0x014b57f4, 0x014b97f4, 0x014bd7f4,
		0x014c17f4, 0x014c57f4, 0x014c97f4, 0x014cd7f4,
		0x014d17f4, 0x014d57f4, 0x014d97f4, 0x014dd7f4,
		0x014e17f4, 0x014e57f4, 0x014e97f4, 0x014ed7f4,
		0x014f17f4, 0x014f57f4, 0x014f97f4, 0x014fd7f4,
		0x015017f4, 0x015057f4, 0x015097f4, 0x0150d7f4,
		0x015117f4, 0x015157f4, 0x015197f4, 0x0151d7f4,
		0x015217f4, 0x015257f4, 0x015297f4, 0x0152d7f4,
		0x015317f4, 0x015357f4, 0x015397f4, 0x0153d7f4,
		0x015417f4, 0x015457f4, 0x015497f4, 0x0154d7f4,
		0x015517f4, 0x015557f4, 0x015597f4, 0x0155d7f4,
		0x015617f4, 0x015657f4, 0x015697f4, 0x0156d7f4,
		0x015717f4, 0x015757f4, 0x015797f4, 0x0157d7f4,
		0x015817f4, 0x015857f4, 0x015897f4, 0x0158d7f4,
		0x015917f4, 0x015957f4, 0x015997f4, 0x0159d7f4,
		0x015a17f4, 0x015a57f4, 0x015a97f4, 0x015ad7f4,
		0x015b17f4, 0x015b57f4, 0x015b97f4, 0x015bd7f4,
		0x015c17f4, 0x015c57f4, 0x015c97f4, 0x015cd7f4,
		0x015d17f4, 0x015d57f4, 0x015d97f4, 0x015dd7f4,
		0x015e17f4, 0x015e57f4, 0x015e97f4, 0x015ed7f4,
		0x015f17f4, 0x015f57f4, 0x015f97f4, 0x015fd7f4,
		0x016017f4, 0x016057f4, 0x016097f4, 0x0160d7f4,
		0x016117f4, 0x016157f4, 0x016197f4, 0x0161d7f4,
		0x016217f4, 0x016257f4, 0x016297f4, 0x0162d7f4,
		0x016317f4, 0x016357f4, 0x016397f4, 0x0163d7f4,
		0x016417f4, 0x016457f4, 0x016497f4, 0x0164d7f4,
		0x016517f4, 0x016557f4, 0x016597f4, 0x0165d7f4,
		0x016617f4, 0x016657f4, 0x016697f4, 0x0166d7f4,
		0x016717f4, 0x016757f4, 0x016797f4, 0x0167d7f4,
		0x016817f4, 0x016857f4, 0x016897f4, 0x0168d7f4,
		0x016917f4, 0x016957f4, 0x016997f4, 0x0169d7f4,
		0x016a17f4, 0x016a57f4, 0x016a97f4, 0x016ad7f4,
		0x016b17f4, 0x016b57f4, 0x016b97f4, 0x016bd7f4,
		0x016c17f4, 0x016c57f4, 0x016c97f4, 0x016cd7f4,
		0x016d17f4, 0x016d57f4, 0x016d97f4, 0x016dd7f4,
		0x016e17f4, 0x016e57f4, 0x016e97f4, 0x016ed7f4,
		0x016f17f4, 0x016f57f4, 0x016f97f4, 0x016fd7f4,
		0x017017f4, 0x017057f4, 0x017097f4, 0x0170d7f4,
		0x017117f4, 0x017157f4, 0x017197f4, 0x0171d7f4,
		0x017217f4, 0x017257f4, 0x017297f4, 0x0172d7f4,
		0x017317f4, 0x017357f4, 0x017397f4, 0x0173d7f4,
		0x017417f4, 0x017457f4, 0x017497f4, 0x0174d7f4,
		0x017517f4, 0x017557f4, 0x017597f4, 0x0175d7f4,
		0x017617f4, 0x017657f4, 0x017697f4, 0x0176d7f4,
		0x017717f4, 0x017757f4, 0x017797f4, 0x0177d7f4,
		0x017817f4, 0x017857f4, 0x017897f4, 0x0178d7f4,
		0x017917f4, 0x017957f4, 0x017997f4, 0x0179d7f4,
		0x017a17f4, 0x017a57f4, 0x017a97f4, 0x017ad7f4,
		0x017b17f4, 0x017b57f4, 0x017b97f4, 0x017bd7f4,
		0x017c17f4, 0x017c57f4, 0x017c97f4, 0x017cd7f4,
		0x017d17f4, 0x017d57f4, 0x017d97f4, 0x017dd7f4,
		0x017e17f4, 0x017e57f4, 0x017e97f4, 0x017ed7f4,
		0x017f17f4, 0x017f57f4, 0x017f97f4, 0x017fd7f4,
		0x018017f4, 0x018057f4, 0x018097f4, 0x0180d7f4,
		0x018117f4, 0x018157f4, 0x018197f4, 0x0181d7f4,
		0x018217f4, 0x018257f4, 0x018297f4, 0x0182d7f4,
		0x018317f4, 0x018357f4, 0x018397f4, 0x0183d7f4,
		0x018417f4, 0x018457f4, 0x018497f4, 0x0184d7f4,
		0x018517f4, 0x018557f4, 0x018597f4, 0x0185d7f4,
		0x018617f4, 0x018657f4, 0x018697f4, 0x0186d7f4,
		0x018717f4, 0x018757f4, 0x018797f4, 0x0187d7f4,
		0x018817f4, 0x018857f4, 0x018897f4, 0x0188d7f4,
		0x018917f4, 0x018957f4, 0x018997f4, 0x0189d7f4,
		0x018a17f4, 0x018a57f4, 0x018a97f4, 0x018ad7f4,
		0x018b17f4, 0x018b57f4, 0x018b97f4, 0x018bd7f4,
		0x018c17f4, 0x018c57f4, 0x018c97f4, 0x018cd7f4,
		0x018d17f4, 0x018d57f4, 0x018d97f4, 0x018dd7f4,
		0x018e17f4, 0x018e57f4, 0x018e97f4, 0x018ed7f4,
		0x018f17f4, 0x018f57f4, 0x018f97f4, 0x018fd7f4,
		0x019017f4, 0x019057f4, 0x019097f4, 0x0190d7f4,
		0x019117f4, 0x019157f4, 0x019197f4, 0x0191d7f4,
		0x019217f4, 0x019257f4, 0x019297f4, 0x0192d7f4,
		0x019317f4, 0x019357f4, 0x019397f4, 0x0193d7f4,
		0x019417f4, 0x019457f4, 0x019497f4, 0x0194d7f4,
		0x019517f4, 0x019557f4, 0x019597f4, 0x0195d7f4,
		0x019617f4, 0x019657f4, 0x019697f4, 0x0196d7f4,
		0x019717f4, 0x019757f4, 0x019797f4, 0x0197d7f4,
		0x019817f4, 0x019857f4, 0x019897f4, 0x0198d7f4,
		0x019917f4, 0x019957f4, 0x019997f4, 0x0199d7f4,
		0x019a17f4, 0x019a57f4, 0x019a97f4, 0x019ad7f4,
		0x019b17f4, 0x019b57f4, 0x019b97f4, 0x019bd7f4,
		0x019c17f4, 0x019c57f4, 0x019c97f4, 0x019cd7f4,
		0x019d17f4, 0x019d57f4, 0x019d97f4, 0x019dd7f4,
		0x019e17f4, 0x019e57f4, 0x019e97f4, 0x019ed7f4,
		0x019f17f4, 0x019f57f4, 0x019f97f4, 0x019fd7f4,
		0x01a017f4, 0x01a057f4, 0x01a097f4, 0x01a0d7f4,
		0x01a117f4, 0x01a157f4, 0x01a197f4, 0x01a1d7f4,
		0x01a217f4, 0x01a257f4, 0x01a297f4, 0x01a2d7f4,
		0x01a317f4, 0x01a357f4, 0x01a397f4, 0x01a3d7f4,
		0x01a417f4, 0x01a457f4, 0x01a497f4, 0x01a4d7f4,
		0x01a517f4, 0x01a557f4, 0x01a597f4, 0x01a5d7f4,
		0x01a617f4, 0x01a657f4, 0x01a697f4, 0x01a6d7f4,
		0x01a717f4, 0x01a757f4, 0x01a797f4, 0x01a7d7f4,
		0x01a817f4, 0x01a857f4, 0x01a897f4, 0x01a8d7f4,
		0x01a917f4, 0x01a957f4, 0x01a997f4, 0x01a9d7f4,
		0x01aa17f4, 0x01aa57f4, 0x01aa97f4, 0x01aad7f4,
		0x01ab17f4, 0x01ab57f4, 0x01ab97f4, 0x01abd7f4,
		0x01ac17f4, 0x01ac57f4, 0x01ac97f4, 0x01acd7f4,
		0x01ad17f4, 0x01ad57f4, 0x01ad97f4, 0x01add7f4,
		0x01ae17f4, 0x01ae57f4, 0x01ae97f4, 0x01aed7f4,
		0x01af17f4, 0x01af57f4, 0x01af97f4, 0x01afd7f4,
		0x01b017f4, 0x01b057f4, 0x01b097f4, 0x01b0d7f4,
		0x01b117f4, 0x01b157f4, 0x01b197f4, 0x01b1d7f4,
		0x01b217f4, 0x01b257f4, 0x01b297f4, 0x01b2d7f4,
		0x01b317f4, 0x01b357f4, 0x01b397f4, 0x01b3d7f4,
		0x01b417f4, 0x01b457f4, 0x01b497f4, 0x01b4d7f4,
		0x01b517f4, 0x01b557f4, 0x01b597f4, 0x01b5d7f4,
		0x01b617f4, 0x01b657f4, 0x01b697f4, 0x01b6d7f4,
		0x01b717f4, 0x01b757f4, 0x01b797f4, 0x01b7d7f4,
		0x01b817f4, 0x01b857f4, 0x01b897f4, 0x01b8d7f4,
		0x01b917f4, 0x01b957f4, 0x01b997f4, 0x01b9d7f4,
		0x01ba17f4, 0x01ba57f4, 0x01ba97f4, 0x01bad7f4,
		0x01bb17f4, 0x01bb57f4, 0x01bb97f4, 0x01bbd7f4,
		0x01bc17f4, 0x01bc57f4, 0x01bc97f4, 0x01bcd7f4,
		0x01bd17f4, 0x01bd57f4, 0x01bd97f4, 0x01bdd7f4,
		0x01be17f4, 0x01be57f4, 0x01be97f4, 0x01bed7f4,
		0x01bf17f4, 0x01bf57f4, 0x01bf97f4, 0x01bfd7f4,
		0x01c017f4, 0x01c057f4, 0x01c097f4, 0x01c0d7f4,
		0x01c117f4, 0x01c157f4, 0x01c197f4, 0x01c1d7f4,
		0x01c217f4, 0x01c257f4, 0x01c297f4, 0x01c2d7f4,
		0x01c317f4, 0x01c357f4, 0x01c397f4, 0x01c3d7f4,
		0x01c417f4, 0x01c457f4, 0x01c497f4, 0x01c4d7f4,
		0x01c517f4, 0x01c557f4, 0x01c597f4, 0x01c5d7f4,
		0x01c617f4, 0x01c657f4, 0x01c697f4, 0x01c6d7f4,
		0x01c717f4, 0x01c757f4, 0x01c797f4, 0x01c7d7f4,
		0x01c817f4, 0x01c857f4, 0x01c897f4, 0x01c8d7f4,
		0x01c917f4, 0x01c957f4, 0x01c997f4, 0x01c9d7f4,
		0x01ca17f4, 0x01ca57f4, 0x01ca97f4, 0x01cad7f4,
		0x01cb17f4, 0x01cb57f4, 0x01cb97f4, 0x01cbd7f4,
		0x01cc17f4, 0x01cc57f4, 0x01cc97f4, 0x01ccd7f4,
		0x01cd17f4, 0x01cd57f4, 0x01cd97f4, 0x01cdd7f4,
		0x01ce17f4, 0x01ce57f4, 0x01ce97f4, 0x01ced7f4,
		0x01cf17f4, 0x01cf57f4, 0x01cf97f4, 0x01cfd7f4,
		0x01d017f4, 0x01d057f4, 0x01d097f4, 0x01d0d7f4,
		0x01d117f4, 0x01d157f4, 0x01d197f4, 0x01d1d7f4,
		0x01d217f4, 0x01d257f4, 0x01d297f4, 0x01d2d7f4,
		0x01d317f4, 0x01d357f4, 0x01d397f4, 0x01d3d7f4,
		0x01d417f4, 0x01d457f4, 0x01d497f4, 0x01d4d7f4,
		0x01d517f4, 0x01d557f4, 0x01d597f4, 0x01d5d7f4,
		0x01d617f4, 0x01d657f4, 0x01d697f4, 0x01d6d7f4,
		0x01d717f4, 0x01d757f4, 0x01d797f4, 0x01d7d7f4,
		0x01d817f4, 0x01d857f4, 0x01d897f4, 0x01d8d7f4,
		0x01d917f4, 0x01d957f4, 0x01d997f4, 0x01d9d7f4,
		0x01da17f4, 0x01da57f4, 0x01da97f4, 0x01dad7f4,
		0x01db17f4, 0x01db57f4, 0x01db97f4, 0x01dbd7f4,
		0x01dc17f4, 0x01dc57f4, 0x01dc97f4, 0x01dcd7f4,
		0x01dd17f4, 0x01dd57f4, 0x01dd97f4, 0x01ddd7f4,
		0x01de17f4, 0x01de57f4, 0x01de97f4, 0x01ded7f4,
		0x01df17f4, 0x01df57f4, 0x01df97f4, 0x01dfd7f4,
		0x01e017f4, 0x01e057f4, 0x01e097f4, 0x01e0d7f4,
		0x01e117f4, 0x01e157f4, 0x01e197f4, 0x01e1d7f4,
		0x01e217f4, 0x01e257f4, 0x01e297f4, 0x01e2d7f4,
		0x01e317f4, 0x01e357f4, 0x01e397f4, 0x01e3d7f4,
		0x01e417f4, 0x01e457f4, 0x01e497f4, 0x01e4d7f4,
		0x01e517f4, 0x01e557f4, 0x01e597f4, 0x01e5d7f4,
		0x01e617f4, 0x01e657f4, 0x01e697f4, 0x01e6d7f4,
		0x01e717f4, 0x01e757f4, 0x01e797f4, 0x01e7d7f4,
		0x01e817f4, 0x01e857f4, 0x01e897f4, 0x01e8d7f4,
		0x01e917f4, 0x01e957f4, 0x01e997f4, 0x01e9d7f4,
		0x01ea17f4, 0x01ea57f4, 0x01ea97f4, 0x01ead7f4,
		0x01eb17f4, 0x01eb57f4, 0x01eb97f4, 0x01ebd7f4,
		0x01ec17f4, 0x01ec57f4, 0x01ec97f4, 0x01ecd7f4,
		0x01ed17f4, 0x01ed57f4, 0x01ed97f4, 0x01edd7f4,
		0x01ee17f4, 0x01ee57f4, 0x01ee97f4, 0x01eed7f4,
		0x01ef17f4, 0x01ef57f4, 0x01ef97f4, 0x01efd7f4,
		0x01f017f4, 0x01f057f4, 0x01f097f4, 0x01f0d7f4,
		0x01f117f4, 0x01f157f4, 0x01f197f4, 0x01f1d7f4,
		0x01f217f4, 0x01f257f4, 0x01f297f4, 0x01f2d7f4,
		0x01f317f4, 0x01f357f4, 0x01f397f4, 0x01f3d7f4,
		0x01f417f4, 0x01f457f4, 0x01f497f4, 0x01f4d7f4,
		0x01f517f4, 0x01f557f4, 0x01f597f4, 0x01f5d7f4,
		0x01f617f4, 0x01f657f4, 0x01f697f4, 0x01f6d7f4,
		0x01f717f4, 0x01f757f4, 0x01f797f4, 0x01f7d7f4,
		0x01f817f4, 0x01f857f4, 0x01f897f4, 0x01f8d7f4,
		0x01f917f4, 0x01f957f4, 0x01f997f4, 0x01f9d7f4,
		0x01fa17f4, 0x01fa57f4, 0x01fa97f4, 0x01fad7f4,
		0x01fb17f4, 0x01fb57f4, 0x01fb97f4, 0x01fbd7f4,
		0x01fc17f4, 0x01fc57f4, 0x01fc97f4, 0x01fcd7f4,
		0x01fd17f4, 0x01fd57f4, 0x01fd97f4, 0x01fdd7f4,
		0x01fe17f4, 0x01fe57f4, 0x01fe97f4, 0x01fed7f4,
		0x01ff17f4, 0x01ff57f4, 0x01ff97f4, 0x01ffd7f4,
		0x000037f4, 0x000077f4, 0x0000b7f4, 0x0000f7f4,
		0x000137f4, 0x000177f4, 0x0001b7f4, 0x0001f7f4,
		0x000237f4, 0x000277f4, 0x0002b7f4, 0x0002f7f4,
		0x000337f4, 0x000377f4, 0x0003b7f4, 0x0003f7f4,
		0x000437f4, 0x000477f4, 0x0004b7f4, 0x0004f7f4,
		0x000537f4, 0x000577f4, 0x0005b7f4, 0x0005f7f4,
		0x000637f4, 0x000677f4, 0x0006b7f4, 0x0006f7f4,
		0x000737f4, 0x000777f4, 0x0007b7f4, 0x0007f7f4,
		0x000837f4, 0x000877f4, 0x0008b7f4, 0x0008f7f4,
		0x000937f4, 0x000977f4, 0x0009b7f4, 0x0009f7f4,
		0x000a37f4, 0x000a77f4, 0x000ab7f4, 0x000af7f4,
		0x000b37f4, 0x000b77f4, 0x000bb7f4, 0x000bf7f4,
		0x000c37f4, 0x000c77f4, 0x000cb7f4, 0x000cf7f4,
		0x000d37f4, 0x000d77f4, 0x000db7f4, 0x000df7f4,
		0x000e37f4, 0x000e77f4, 0x000eb7f4, 0x000ef7f4,
		0x000f37f4, 0x000f77f4, 0x000fb7f4, 0x000ff7f4,
		0x001037f4, 0x001077f4, 0x0010b7f4, 0x0010f7f4,
		0x001137f4, 0x001177f4, 0x0011b7f4, 0x0011f7f4,
		0x001237f4, 0x001277f4, 0x0012b7f4, 0x0012f7f4,
		0x001337f4, 0x001377f4, 0x0013b7f4, 0x0013f7f4,
		0x001437f4, 0x001477f4, 0x0014b7f4, 0x0014f7f4,
		0x001537f4, 0x001577f4, 0x0015b7f4, 0x0015f7f4,
		0x001637f4, 0x001677f4, 0x0016b7f4, 0x0016f7f4,
		0x001737f4, 0x001777f4, 0x0017b7f4, 0x0017f7f4,
		0x001837f4, 0x001877f4, 0x0018b7f4, 0x0018f7f4,
		0x001937f4, 0x001977f4, 0x0019b7f4, 0x0019f7f4,
		0x001a37f4, 0x001a77f4, 0x001ab7f4, 0x001af7f4,
		0x001b37f4, 0x001b77f4, 0x001bb7f4, 0x001bf7f4,
		0x001c37f4, 0x001c77f4, 0x001cb7f4, 0x001cf7f4,
		0x001d37f4, 0x001d77f4, 0x001db7f4, 0x001df7f4,
		0x001e37f4, 0x001e77f4, 0x001eb7f4, 0x001ef7f4,
		0x001f37f4, 0x001f77f4, 0x001fb7f4, 0x001ff7f4,
		0x002037f4, 0x002077f4, 0x0020b7f4, 0x0020f7f4,
		0x002137f4, 0x002177f4, 0x0021b7f4, 0x0021f7f4,
		0x002237f4, 0x002277f4, 0x0022b7f4, 0x0022f7f4,
		0x002337f4, 0x002377f4, 0x0023b7f4, 0x0023f7f4,
		0x002437f4, 0x002477f4, 0x0024b7f4, 0x0024f7f4,
		0x002537f4, 0x002577f4, 0x0025b7f4, 0x0025f7f4,
		0x002637f4, 0x002677f4, 0x0026b7f4, 0x0026f7f4,
		0x002737f4, 0x002777f4, 0x0027b7f4, 0x0027f7f4,
		0x002837f4, 0x002877f4, 0x0028b7f4, 0x0028f7f4,
		0x002937f4, 0x002977f4, 0x0029b7f4, 0x0029f7f4,
		0x002a37f4, 0x002a77f4, 0x002ab7f4, 0x002af7f4,
		0x002b37f4, 0x002b77f4, 0x002bb7f4, 0x002bf7f4,
		0x002c37f4, 0x002c77f4, 0x002cb7f4, 0x002cf7f4,
		0x002d37f4, 0x002d77f4, 0x002db7f4, 0x002df7f4,
		0x002e37f4, 0x002e77f4, 0x002eb7f4, 0x002ef7f4,
		0x002f37f4, 0x002f77f4, 0x002fb7f4, 0x002ff7f4,
		0x003037f4, 0x003077f4, 0x0030b7f4, 0x0030f7f4,
		0x003137f4, 0x003177f4, 0x0031b7f4, 0x0031f7f4,
		0x003237f4, 0x003277f4, 0x0032b7f4, 0x0032f7f4,
		0x003337f4, 0x003377f4, 0x0033b7f4, 0x0033f7f4,
		0x003437f4, 0x003477f4, 0x0034b7f4, 0x0034f7f4,
		0x003537f4, 0x003577f4, 0x0035b7f4, 0x0035f7f4,
		0x003637f4, 0x003677f4, 0x0036b7f4, 0x0036f7f4,
		0x003737f4, 0x003777f4, 0x0037b7f4, 0x0037f7f4,
		0x003837f4, 0x003877f4, 0x0038b7f4, 0x0038f7f4,
		0x003937f4, 0x003977f4, 0x0039b7f4, 0x0039f7f4,
		0x003a37f4, 0x003a77f4, 0x003ab7f4, 0x003af7f4,
		0x003b37f4, 0x003b77f4, 0x003bb7f4, 0x003bf7f4,
		0x003c37f4, 0x003c77f4, 0x003cb7f4, 0x003cf7f4,
		0x003d37f4, 0x003d77f4, 0x003db7f4, 0x003df7f4,
		0x003e37f4, 0x003e77f4, 0x003eb7f4, 0x003ef7f4,
		0x003f37f4, 0x003f77f4, 0x003fb7f4, 0x003ff7f4,
		0x004037f4, 0x004077f4, 0x0040b7f4, 0x0040f7f4,
		0x004137f4, 0x004177f4, 0x0041b7f4, 0x0041f7f4,
		0x004237f4, 0x004277f4, 0x0042b7f4, 0x0042f7f4,
		0x004337f4, 0x004377f4, 0x0043b7f4, 0x0043f7f4,
		0x004437f4, 0x004477f4, 0x0044b7f4, 0x0044f7f4,
		0x004537f4, 0x004577f4, 0x0045b7f4, 0x0045f7f4,
		0x004637f4, 0x004677f4, 0x0046b7f4, 0x0046f7f4,
		0x004737f4, 0x004777f4, 0x0047b7f4, 0x0047f7f4,
		0x004837f4, 0x004877f4, 0x0048b7f4, 0x0048f7f4,
		0x004937f4, 0x004977f4, 0x0049b7f4, 0x0049f7f4,
		0x004a37f4, 0x004a77f4, 0x004ab7f4, 0x004af7f4,
		0x004b37f4, 0x004b77f4, 0x004bb7f4, 0x004bf7f4,
		0x004c37f4, 0x004c77f4, 0x004cb7f4, 0x004cf7f4,
		0x004d37f4, 0x004d77f4, 0x004db7f4, 0x004df7f4,
		0x004e37f4, 0x004e77f4, 0x004eb7f4, 0x004ef7f4,
		0x004f37f4, 0x004f77f4, 0x004fb7f4, 0x004ff7f4,
		0x005037f4, 0x005077f4, 0x0050b7f4, 0x0050f7f4,
		0x005137f4, 0x005177f4, 0x0051b7f4, 0x0051f7f4,
		0x005237f4, 0x005277f4, 0x0052b7f4, 0x0052f7f4,
		0x005337f4, 0x005377f4, 0x0053b7f4, 0x0053f7f4,
		0x005437f4, 0x005477f4, 0x0054b7f4, 0x0054f7f4,
		0x005537f4, 0x005577f4, 0x0055b7f4, 0x0055f7f4,
		0x005637f4, 0x005677f4, 0x0056b7f4, 0x0056f7f4,
		0x005737f4, 0x005777f4, 0x0057b7f4, 0x0057f7f4,
		0x005837f4, 0x005877f4, 0x0058b7f4, 0x0058f7f4,
		0x005937f4, 0x005977f4, 0x0059b7f4, 0x0059f7f4,
		0x005a37f4, 0x005a77f4, 0x005ab7f4, 0x005af7f4,
		0x005b37f4, 0x005b77f4, 0x005bb7f4, 0x005bf7f4,
		0x005c37f4, 0x005c77f4, 0x005cb7f4, 0x005cf7f4,
		0x005d37f4, 0x005d77f4, 0x005db7f4, 0x005df7f4,
		0x005e37f4, 0x005e77f4, 0x005eb7f4, 0x005ef7f4,
		0x005f37f4, 0x005f77f4, 0x005fb7f4, 0x005ff7f4,
		0x006037f4, 0x006077f4, 0x0060b7f4, 0x0060f7f4,
		0x006137f4, 0x006177f4, 0x0061b7f4, 0x0061f7f4,
		0x006237f4, 0x006277f4, 0x0062b7f4, 0x0062f7f4,
		0x006337f4, 0x006377f4, 0x0063b7f4, 0x0063f7f4,
		0x006437f4, 0x006477f4, 0x0064b7f4, 0x0064f7f4,
		0x006537f4, 0x006577f4, 0x0065b7f4, 0x0065f7f4,
		0x006637f4, 0x006677f4, 0x0066b7f4, 0x0066f7f4,
		0x006737f4, 0x006777f4, 0x0067b7f4, 0x0067f7f4,
		0x006837f4, 0x006877f4, 0x0068b7f4, 0x0068f7f4,
		0x006937f4, 0x006977f4, 0x0069b7f4, 0x0069f7f4,
		0x006a37f4, 0x006a77f4, 0x006ab7f4, 0x006af7f4,
		0x006b37f4, 0x006b77f4, 0x006bb7f4, 0x006bf7f4,
		0x006c37f4, 0x006c77f4, 0x006cb7f4, 0x006cf7f4,
		0x006d37f4, 0x006d77f4, 0x006db7f4, 0x006df7f4,
		0x006e37f4, 0x006e77f4, 0x006eb7f4, 0x006ef7f4,
		0x006f37f4, 0x006f77f4, 0x006fb7f4, 0x006ff7f4,
		0x007037f4, 0x007077f4, 0x0070b7f4, 0x0070f7f4,
		0x007137f4, 0x007177f4, 0x0071b7f4, 0x0071f7f4,
		0x007237f4, 0x007277f4, 0x0072b7f4, 0x0072f7f4,
		0x007337f4, 0x007377f4, 0x0073b7f4, 0x0073f7f4,
		0x007437f4, 0x007477f4, 0x0074b7f4, 0x0074f7f4,
		0x007537f4, 0x007577f4, 0x0075b7f4, 0x0075f7f4,
		0x007637f4, 0x007677f4, 0x0076b7f4, 0x0076f7f4,
		0x007737f4, 0x007777f4, 0x0077b7f4, 0x0077f7f4,
		0x007837f4, 0x007877f4, 0x0078b7f4, 0x0078f7f4,
		0x007937f4, 0x007977f4, 0x0079b7f4, 0x0079f7f4,
		0x007a37f4, 0x007a77f4, 0x007ab7f4, 0x007af7f4,
		0x007b37f4, 0x007b77f4, 0x007bb7f4, 0x007bf7f4,
		0x007c37f4, 0x007c77f4, 0x007cb7f4, 0x007cf7f4,
		0x007d37f4, 0x007d77f4, 0x007db7f4, 0x007df7f4,
		0x007e37f4, 0x007e77f4, 0x007eb7f4, 0x007ef7f4,
		0x007f37f4, 0x007f77f4, 0x007fb7f4, 0x007ff7f4,
		0x008037f4, 0x008077f4, 0x0080b7f4, 0x0080f7f4,
		0x008137f4, 0x008177f4, 0x0081b7f4, 0x0081f7f4,
		0x008237f4, 0x008277f4, 0x0082b7f4, 0x0082f7f4,
		0x008337f4, 0x008377f4, 0x0083b7f4, 0x0083f7f4,
		0x008437f4, 0x008477f4, 0x0084b7f4, 0x0084f7f4,
		0x008537f4, 0x008577f4, 0x0085b7f4, 0x0085f7f4,
		0x008637f4, 0x008677f4, 0x0086b7f4, 0x0086f7f4,
		0x008737f4, 0x008777f4, 0x0087b7f4, 0x0087f7f4,
		0x008837f4, 0x008877f4, 0x0088b7f4, 0x0088f7f4,
		0x008937f4, 0x008977f4, 0x0089b7f4, 0x0089f7f4,
		0x008a37f4, 0x008a77f4, 0x008ab7f4, 0x008af7f4,
		0x008b37f4, 0x008b77f4, 0x008bb7f4, 0x008bf7f4,
		0x008c37f4, 0x008c77f4, 0x008cb7f4, 0x008cf7f4,
		0x008d37f4, 0x008d77f4, 0x008db7f4, 0x008df7f4,
		0x008e37f4, 0x008e77f4, 0x008eb7f4, 0x008ef7f4,
		0x008f37f4, 0x008f77f4, 0x008fb7f4, 0x008ff7f4,
		0x009037f4, 0x009077f4, 0x0090b7f4, 0x0090f7f4,
		0x009137f4, 0x009177f4, 0x0091b7f4, 0x0091f7f4,
		0x009237f4, 0x009277f4, 0x0092b7f4, 0x0092f7f4,
		0x009337f4, 0x009377f4, 0x0093b7f4, 0x0093f7f4,
		0x009437f4, 0x009477f4, 0x0094b7f4, 0x0094f7f4,
		0x009537f4, 0x009577f4, 0x0095b7f4, 0x0095f7f4,
		0x009637f4, 0x009677f4, 0x0096b7f4, 0x0096f7f4,
		0x009737f4, 0x009777f4, 0x0097b7f4, 0x0097f7f4,
		0x009837f4, 0x009877f4, 0x0098b7f4, 0x0098f7f4,
		0x009937f4, 0x009977f4, 0x0099b7f4, 0x0099f7f4,
		0x009a37f4, 0x009a77f4, 0x009ab7f4, 0x009af7f4,
		0x009b37f4, 0x009b77f4, 0x009bb7f4, 0x009bf7f4,
		0x009c37f4, 0x009c77f4, 0x009cb7f4, 0x009cf7f4,
		0x009d37f4, 0x009d77f4, 0x009db7f4, 0x009df7f4,
		0x009e37f4, 0x009e77f4, 0x009eb7f4, 0x009ef7f4,
		0x009f37f4, 0x009f77f4, 0x009fb7f4, 0x009ff7f4,
		0x00a037f4, 0x00a077f4, 0x00a0b7f4, 0x00a0f7f4,
		0x00a137f4, 0x00a177f4, 0x00a1b7f4, 0x00a1f7f4,
		0x00a237f4, 0x00a277f4, 0x00a2b7f4, 0x00a2f7f4,
		0x00a337f4, 0x00a377f4, 0x00a3b7f4, 0x00a3f7f4,
		0x00a437f4, 0x00a477f4, 0x00a4b7f4, 0x00a4f7f4,
		0x00a537f4, 0x00a577f4, 0x00a5b7f4, 0x00a5f7f4,
		0x00a637f4, 0x00a677f4, 0x00a6b7f4, 0x00a6f7f4,
		0x00a737f4, 0x00a777f4, 0x00a7b7f4, 0x00a7f7f4,
		0x00a837f4, 0x00a877f4, 0x00a8b7f4, 0x00a8f7f4,
		0x00a937f4, 0x00a977f4, 0x00a9b7f4, 0x00a9f7f4,
		0x00aa37f4, 0x00aa77f4, 0x00aab7f4, 0x00aaf7f4,
		0x00ab37f4, 0x00ab77f4, 0x00abb7f4, 0x00abf7f4,
		0x00ac37f4, 0x00ac77f4, 0x00acb7f4, 0x00acf7f4,
		0x00ad37f4, 0x00ad77f4, 0x00adb7f4, 0x00adf7f4,
		0x00ae37f4, 0x00ae77f4, 0x00aeb7f4, 0x00aef7f4,
		0x00af37f4, 0x00af77f4, 0x00afb7f4, 0x00aff7f4,
		0x00b037f4, 0x00b077f4, 0x00b0b7f4, 0x00b0f7f4,
		0x00b137f4, 0x00b177f4, 0x00b1b7f4, 0x00b1f7f4,
		0x00b237f4, 0x00b277f4, 0x00b2b7f4, 0x00b2f7f4,
		0x00b337f4, 0x00b377f4, 0x00b3b7f4, 0x00b3f7f4,
		0x00b437f4, 0x00b477f4, 0x00b4b7f4, 0x00b4f7f4,
		0x00b537f4, 0x00b577f4, 0x00b5b7f4, 0x00b5f7f4,
		0x00b637f4, 0x00b677f4, 0x00b6b7f4, 0x00b6f7f4,
		0x00b737f4, 0x00b777f4, 0x00b7b7f4, 0x00b7f7f4,
		0x00b837f4, 0x00b877f4, 0x00b8b7f4, 0x00b8f7f4,
		0x00b937f4, 0x00b977f4, 0x00b9b7f4, 0x00b9f7f4,
		0x00ba37f4, 0x00ba77f4, 0x00bab7f4, 0x00baf7f4,
		0x00bb37f4, 0x00bb77f4, 0x00bbb7f4, 0x00bbf7f4,
		0x00bc37f4, 0x00bc77f4, 0x00bcb7f4, 0x00bcf7f4,
		0x00bd37f4, 0x00bd77f4, 0x00bdb7f4, 0x00bdf7f4,
		0x00be37f4, 0x00be77f4, 0x00beb7f4, 0x00bef7f4,
		0x00bf37f4, 0x00bf77f4, 0x00bfb7f4, 0x00bff7f4,
		0x00c037f4, 0x00c077f4, 0x00c0b7f4, 0x00c0f7f4,
		0x00c137f4, 0x00c177f4, 0x00c1b7f4, 0x00c1f7f4,
		0x00c237f4, 0x00c277f4, 0x00c2b7f4, 0x00c2f7f4,
		0x00c337f4, 0x00c377f4, 0x00c3b7f4, 0x00c3f7f4,
		0x00c437f4, 0x00c477f4, 0x00c4b7f4, 0x00c4f7f4,
		0x00c537f4, 0x00c577f4, 0x00c5b7f4, 0x00c5f7f4,
		0x00c637f4, 0x00c677f4, 0x00c6b7f4, 0x00c6f7f4,
		0x00c737f4, 0x00c777f4, 0x00c7b7f4, 0x00c7f7f4,
		0x00c837f4, 0x00c877f4, 0x00c8b7f4, 0x00c8f7f4,
		0x00c937f4, 0x00c977f4, 0x00c9b7f4, 0x00c9f7f4,
		0x00ca37f4, 0x00ca77f4, 0x00cab7f4, 0x00caf7f4,
		0x00cb37f4, 0x00cb77f4, 0x00cbb7f4, 0x00cbf7f4,
		0x00cc37f4, 0x00cc77f4, 0x00ccb7f4, 0x00ccf7f4,
		0x00cd37f4, 0x00cd77f4, 0x00cdb7f4, 0x00cdf7f4,
		0x00ce37f4, 0x00ce77f4, 0x00ceb7f4, 0x00cef7f4,
		0x00cf37f4, 0x00cf77f4, 0x00cfb7f4, 0x00cff7f4,
		0x00d037f4, 0x00d077f4, 0x00d0b7f4, 0x00d0f7f4,
		0x00d137f4, 0x00d177f4, 0x00d1b7f4, 0x00d1f7f4,
		0x00d237f4, 0x00d277f4, 0x00d2b7f4, 0x00d2f7f4,
		0x00d337f4, 0x00d377f4, 0x00d3b7f4, 0x00d3f7f4,
		0x00d437f4, 0x00d477f4, 0x00d4b7f4, 0x00d4f7f4,
		0x00d537f4, 0x00d577f4, 0x00d5b7f4, 0x00d5f7f4,
		0x00d637f4, 0x00d677f4, 0x00d6b7f4, 0x00d6f7f4,
		0x00d737f4, 0x00d777f4, 0x00d7b7f4, 0x00d7f7f4,
		0x00d837f4, 0x00d877f4, 0x00d8b7f4, 0x00d8f7f4,
		0x00d937f4, 0x00d977f4, 0x00d9b7f4, 0x00d9f7f4,
		0x00da37f4, 0x00da77f4, 0x00dab7f4, 0x00daf7f4,
		0x00db37f4, 0x00db77f4, 0x00dbb7f4, 0x00dbf7f4,
		0x00dc37f4, 0x00dc77f4, 0x00dcb7f4, 0x00dcf7f4,
		0x00dd37f4, 0x00dd77f4, 0x00ddb7f4, 0x00ddf7f4,
		0x00de37f4, 0x00de77f4, 0x00deb7f4, 0x00def7f4,
		0x00df37f4, 0x00df77f4, 0x00dfb7f4, 0x00dff7f4,
		0x00e037f4, 0x00e077f4, 0x00e0b7f4, 0x00e0f7f4,
		0x00e137f4, 0x00e177f4, 0x00e1b7f4, 0x00e1f7f4,
		0x00e237f4, 0x00e277f4, 0x00e2b7f4, 0x00e2f7f4,
		0x00e337f4, 0x00e377f4, 0x00e3b7f4, 0x00e3f7f4,
		0x00e437f4, 0x00e477f4, 0x00e4b7f4, 0x00e4f7f4,
		0x00e537f4, 0x00e577f4, 0x00e5b7f4, 0x00e5f7f4,
		0x00e637f4, 0x00e677f4, 0x00e6b7f4, 0x00e6f7f4,
		0x00e737f4, 0x00e777f4, 0x00e7b7f4, 0x00e7f7f4,
		0x00e837f4, 0x00e877f4, 0x00e8b7f4, 0x00e8f7f4,
		0x00e937f4, 0x00e977f4, 0x00e9b7f4, 0x00e9f7f4,
		0x00ea37f4, 0x00ea77f4, 0x00eab7f4, 0x00eaf7f4,
		0x00eb37f4, 0x00eb77f4, 0x00ebb7f4, 0x00ebf7f4,
		0x00ec37f4, 0x00ec77f4, 0x00ecb7f4, 0x00ecf7f4,
		0x00ed37f4, 0x00ed77f4, 0x00edb7f4, 0x00edf7f4,
		0x00ee37f4, 0x00ee77f4, 0x00eeb7f4, 0x00eef7f4,
		0x00ef37f4, 0x00ef77f4, 0x00efb7f4, 0x00eff7f4,
		0x00f037f4, 0x00f077f4, 0x00f0b7f4, 0x00f0f7f4,
		0x00f137f4, 0x00f177f4, 0x00f1b7f4, 0x00f1f7f4,
		0x00f237f4, 0x00f277f4, 0x00f2b7f4, 0x00f2f7f4,
		0x00f337f4, 0x00f377f4, 0x00f3b7f4, 0x00f3f7f4,
		0x00f437f4, 0x00f477f4, 0x00f4b7f4, 0x00f4f7f4,
		0x00f537f4, 0x00f577f4, 0x00f5b7f4, 0x00f5f7f4,
		0x00f637f4, 0x00f677f4, 0x00f6b7f4, 0x00f6f7f4,
		0x00f737f4, 0x00f777f4, 0x00f7b7f4, 0x00f7f7f4,
		0x00f837f4, 0x00f877f4, 0x00f8b7f4, 0x00f8f7f4,
		0x00f937f4, 0x00f977f4, 0x00f9b7f4, 0x00f9f7f4,
		0x00fa37f4, 0x00fa77f4, 0x00fab7f4, 0x00faf7f4,
		0x00fb37f4, 0x00fb77f4, 0x00fbb7f4, 0x00fbf7f4,
		0x00fc37f4, 0x00fc77f4, 0x00fcb7f4, 0x00fcf7f4,
		0x00fd37f4, 0x00fd77f4, 0x00fdb7f4, 0x00fdf7f4,
		0x00fe37f4, 0x00fe77f4, 0x00feb7f4, 0x00fef7f4,
		0x00ff37f4, 0x00ff77f4, 0x00ffb7f4, 0x00fff7f4,
		0x010037f4, 0x010077f4, 0x0100b7f4, 0x0100f7f4,
		0x010137f4, 0x010177f4, 0x0101b7f4, 0x0101f7f4,
		0x010237f4, 0x010277f4, 0x0102b7f4, 0x0102f7f4,
		0x010337f4, 0x010377f4, 0x0103b7f4, 0x0103f7f4,
		0x010437f4, 0x010477f4, 0x0104b7f4, 0x0104f7f4,
		0x010537f4, 0x010577f4, 0x0105b7f4, 0x0105f7f4,
		0x010637f4, 0x010677f4, 0x0106b7f4, 0x0106f7f4,
		0x010737f4, 0x010777f4, 0x0107b7f4, 0x0107f7f4,
		0x010837f4, 0x010877f4, 0x0108b7f4, 0x0108f7f4,
		0x010937f4, 0x010977f4, 0x0109b7f4, 0x0109f7f4,
		0x010a37f4, 0x010a77f4, 0x010ab7f4, 0x010af7f4,
		0x010b37f4, 0x010b77f4, 0x010bb7f4, 0x010bf7f4,
		0x010c37f4, 0x010c77f4, 0x010cb7f4, 0x010cf7f4,
		0x010d37f4, 0x010d77f4, 0x010db7f4, 0x010df7f4,
		0x010e37f4, 0x010e77f4, 0x010eb7f4, 0x010ef7f4,
		0x010f37f4, 0x010f77f4, 0x010fb7f4, 0x010ff7f4,
		0x011037f4, 0x011077f4, 0x0110b7f4, 0x0110f7f4,
		0x011137f4, 0x011177f4, 0x0111b7f4, 0x0111f7f4,
		0x011237f4, 0x011277f4, 0x0112b7f4, 0x0112f7f4,
		0x011337f4, 0x011377f4, 0x0113b7f4, 0x0113f7f4,
		0x011437f4, 0x011477f4, 0x0114b7f4, 0x0114f7f4,
		0x011537f4, 0x011577f4, 0x0115b7f4, 0x0115f7f4,
		0x011637f4, 0x011677f4, 0x0116b7f4, 0x0116f7f4,
		0x011737f4, 0x011777f4, 0x0117b7f4, 0x0117f7f4,
		0x011837f4, 0x011877f4, 0x0118b7f4, 0x0118f7f4,
		0x011937f4, 0x011977f4, 0x0119b7f4, 0x0119f7f4,
		0x011a37f4, 0x011a77f4, 0x011ab7f4, 0x011af7f4,
		0x011b37f4, 0x011b77f4, 0x011bb7f4, 0x011bf7f4,
		0x011c37f4, 0x011c77f4, 0x011cb7f4, 0x011cf7f4,
		0x011d37f4, 0x011d77f4, 0x011db7f4, 0x011df7f4,
		0x011e37f4, 0x011e77f4, 0x011eb7f4, 0x011ef7f4,
		0x011f37f4, 0x011f77f4, 0x011fb7f4, 0x011ff7f4,
		0x012037f4, 0x012077f4, 0x0120b7f4, 0x0120f7f4,
		0x012137f4, 0x012177f4, 0x0121b7f4, 0x0121f7f4,
		0x012237f4, 0x012277f4, 0x0122b7f4, 0x0122f7f4,
		0x012337f4, 0x012377f4, 0x0123b7f4, 0x0123f7f4,
		0x012437f4, 0x012477f4, 0x0124b7f4, 0x0124f7f4,
		0x012537f4, 0x012577f4, 0x0125b7f4, 0x0125f7f4,
		0x012637f4, 0x012677f4, 0x0126b7f4, 0x0126f7f4,
		0x012737f4, 0x012777f4, 0x0127b7f4, 0x0127f7f4,
		0x012837f4, 0x012877f4, 0x0128b7f4, 0x0128f7f4,
		0x012937f4, 0x012977f4, 0x0129b7f4, 0x0129f7f4,
		0x012a37f4, 0x012a77f4, 0x012ab7f4, 0x012af7f4,
		0x012b37f4, 0x012b77f4, 0x012bb7f4, 0x012bf7f4,
		0x012c37f4, 0x012c77f4, 0x012cb7f4, 0x012cf7f4,
		0x012d37f4, 0x012d77f4, 0x012db7f4, 0x012df7f4,
		0x012e37f4, 0x012e77f4, 0x012eb7f4, 0x012ef7f4,
		0x012f37f4, 0x012f77f4, 0x012fb7f4, 0x012ff7f4,
		0x013037f4, 0x013077f4, 0x0130b7f4, 0x0130f7f4,
		0x013137f4, 0x013177f4, 0x0131b7f4, 0x0131f7f4,
		0x013237f4, 0x013277f4, 0x0132b7f4, 0x0132f7f4,
		0x013337f4, 0x013377f4, 0x0133b7f4, 0x0133f7f4,
		0x013437f4, 0x013477f4, 0x0134b7f4, 0x0134f7f4,
		0x013537f4, 0x013577f4, 0x0135b7f4, 0x0135f7f4,
		0x013637f4, 0x013677f4, 0x0136b7f4, 0x0136f7f4,
		0x013737f4, 0x013777f4, 0x0137b7f4, 0x0137f7f4,
		0x013837f4, 0x013877f4, 0x0138b7f4, 0x0138f7f4,
		0x013937f4, 0x013977f4, 0x0139b7f4, 0x0139f7f4,
		0x013a37f4, 0x013a77f4, 0x013ab7f4, 0x013af7f4,
		0x013b37f4, 0x013b77f4, 0x013bb7f4, 0x013bf7f4,
		0x013c37f4, 0x013c77f4, 0x013cb7f4, 0x013cf7f4,
		0x013d37f4, 0x013d77f4, 0x013db7f4, 0x013df7f4,
		0x013e37f4, 0x013e77f4, 0x013eb7f4, 0x013ef7f4,
		0x013f37f4, 0x013f77f4, 0x013fb7f4, 0x013ff7f4,
		0x014037f4, 0x014077f4, 0x0140b7f4, 0x0140f7f4,
		0x014137f4, 0x014177f4, 0x0141b7f4, 0x0141f7f4,
		0x014237f4, 0x014277f4, 0x0142b7f4, 0x0142f7f4,
		0x014337f4, 0x014377f4, 0x0143b7f4, 0x0143f7f4,
		0x014437f4, 0x014477f4, 0x0144b7f4, 0x0144f7f4,
		0x014537f4, 0x014577f4, 0x0145b7f4, 0x0145f7f4,
		0x014637f4, 0x014677f4, 0x0146b7f4, 0x0146f7f4,
		0x014737f4, 0x014777f4, 0x0147b7f4, 0x0147f7f4,
		0x014837f4, 0x014877f4, 0x0148b7f4, 0x0148f7f4,
		0x014937f4, 0x014977f4, 0x0149b7f4, 0x0149f7f4,
		0x014a37f4, 0x014a77f4, 0x014ab7f4, 0x014af7f4,
		0x014b37f4, 0x014b77f4, 0x014bb7f4, 0x014bf7f4,
		0x014c37f4, 0x014c77f4, 0x014cb7f4, 0x014cf7f4,
		0x014d37f4, 0x014d77f4, 0x014db7f4, 0x014df7f4,
		0x014e37f4, 0x014e77f4, 0x014eb7f4, 0x014ef7f4,
		0x014f37f4, 0x014f77f4, 0x014fb7f4, 0x014ff7f4,
		0x015037f4, 0x015077f4, 0x0150b7f4, 0x0150f7f4,
		0x015137f4, 0x015177f4, 0x0151b7f4, 0x0151f7f4,
		0x015237f4, 0x015277f4, 0x0152b7f4, 0x0152f7f4,
		0x015337f4, 0x015377f4, 0x0153b7f4, 0x0153f7f4,
		0x015437f4, 0x015477f4, 0x0154b7f4, 0x0154f7f4,
		0x015537f4, 0x015577f4, 0x0155b7f4, 0x0155f7f4,
		0x015637f4, 0x015677f4, 0x0156b7f4, 0x0156f7f4,
		0x015737f4, 0x015777f4, 0x0157b7f4, 0x0157f7f4,
		0x015837f4, 0x015877f4, 0x0158b7f4, 0x0158f7f4,
		0x015937f4, 0x015977f4, 0x0159b7f4, 0x0159f7f4,
		0x015a37f4, 0x015a77f4, 0x015ab7f4, 0x015af7f4,
		0x015b37f4, 0x015b77f4, 0x015bb7f4, 0x015bf7f4,
		0x015c37f4, 0x015c77f4, 0x015cb7f4, 0x015cf7f4,
		0x015d37f4, 0x015d77f4, 0x015db7f4, 0x015df7f4,
		0x015e37f4, 0x015e77f4, 0x015eb7f4, 0x015ef7f4,
		0x015f37f4, 0x015f77f4, 0x015fb7f4, 0x015ff7f4,
		0x016037f4, 0x016077f4, 0x0160b7f4, 0x0160f7f4,
		0x016137f4, 0x016177f4, 0x0161b7f4, 0x0161f7f4,
		0x016237f4, 0x016277f4, 0x0162b7f4, 0x0162f7f4,
		0x016337f4, 0x016377f4, 0x0163b7f4, 0x0163f7f4,
		0x016437f4, 0x016477f4, 0x0164b7f4, 0x0164f7f4,
		0x016537f4, 0x016577f4, 0x0165b7f4, 0x0165f7f4,
		0x016637f4, 0x016677f4, 0x0166b7f4, 0x0166f7f4,
		0x016737f4, 0x016777f4, 0x0167b7f4, 0x0167f7f4,
		0x016837f4, 0x016877f4, 0x0168b7f4, 0x0168f7f4,
		0x016937f4, 0x016977f4, 0x0169b7f4, 0x0169f7f4,
		0x016a37f4, 0x016a77f4, 0x016ab7f4, 0x016af7f4,
		0x016b37f4, 0x016b77f4, 0x016bb7f4, 0x016bf7f4,
		0x016c37f4, 0x016c77f4, 0x016cb7f4, 0x016cf7f4,
		0x016d37f4, 0x016d77f4, 0x016db7f4, 0x016df7f4,
		0x016e37f4, 0x016e77f4, 0x016eb7f4, 0x016ef7f4,
		0x016f37f4, 0x016f77f4, 0x016fb7f4, 0x016ff7f4,
		0x017037f4, 0x017077f4, 0x0170b7f4, 0x0170f7f4,
		0x017137f4, 0x017177f4, 0x0171b7f4, 0x0171f7f4,
		0x017237f4, 0x017277f4, 0x0172b7f4, 0x0172f7f4,
		0x017337f4, 0x017377f4, 0x0173b7f4, 0x0173f7f4,
		0x017437f4, 0x017477f4, 0x0174b7f4, 0x0174f7f4,
		0x017537f4, 0x017577f4, 0x0175b7f4, 0x0175f7f4,
		0x017637f4, 0x017677f4, 0x0176b7f4, 0x0176f7f4,
		0x017737f4, 0x017777f4, 0x0177b7f4, 0x0177f7f4,
		0x017837f4, 0x017877f4, 0x0178b7f4, 0x0178f7f4,
		0x017937f4, 0x017977f4, 0x0179b7f4, 0x0179f7f4,
		0x017a37f4, 0x017a77f4, 0x017ab7f4, 0x017af7f4,
		0x017b37f4, 0x017b77f4, 0x017bb7f4, 0x017bf7f4,
		0x017c37f4, 0x017c77f4, 0x017cb7f4, 0x017cf7f4,
		0x017d37f4, 0x017d77f4, 0x017db7f4, 0x017df7f4,
		0x017e37f4, 0x017e77f4, 0x017eb7f4, 0x017ef7f4,
		0x017f37f4, 0x017f77f4, 0x017fb7f4, 0x017ff7f4,
		0x018037f4, 0x018077f4, 0x0180b7f4, 0x0180f7f4,
		0x018137f4, 0x018177f4, 0x0181b7f4, 0x0181f7f4,
		0x018237f4, 0x018277f4, 0x0182b7f4, 0x0182f7f4,
		0x018337f4, 0x018377f4, 0x0183b7f4, 0x0183f7f4,
		0x018437f4, 0x018477f4, 0x0184b7f4, 0x0184f7f4,
		0x018537f4, 0x018577f4, 0x0185b7f4, 0x0185f7f4,
		0x018637f4, 0x018677f4, 0x0186b7f4, 0x0186f7f4,
		0x018737f4, 0x018777f4, 0x0187b7f4, 0x0187f7f4,
		0x018837f4, 0x018877f4, 0x0188b7f4, 0x0188f7f4,
		0x018937f4, 0x018977f4, 0x0189b7f4, 0x0189f7f4,
		0x018a37f4, 0x018a77f4, 0x018ab7f4, 0x018af7f4,
		0x018b37f4, 0x018b77f4, 0x018bb7f4, 0x018bf7f4,
		0x018c37f4, 0x018c77f4, 0x018cb7f4, 0x018cf7f4,
		0x018d37f4, 0x018d77f4, 0x018db7f4, 0x018df7f4,
		0x018e37f4, 0x018e77f4, 0x018eb7f4, 0x018ef7f4,
		0x018f37f4, 0x018f77f4, 0x018fb7f4, 0x018ff7f4,
		0x019037f4, 0x019077f4, 0x0190b7f4, 0x0190f7f4,
		0x019137f4, 0x019177f4, 0x0191b7f4, 0x0191f7f4,
		0x019237f4, 0x019277f4, 0x0192b7f4, 0x0192f7f4,
		0x019337f4, 0x019377f4, 0x0193b7f4, 0x0193f7f4,
		0x019437f4, 0x019477f4, 0x0194b7f4, 0x0194f7f4,
		0x019537f4, 0x019577f4, 0x0195b7f4, 0x0195f7f4,
		0x019637f4, 0x019677f4, 0x0196b7f4, 0x0196f7f4,
		0x019737f4, 0x019777f4, 0x0197b7f4, 0x0197f7f4,
		0x019837f4, 0x019877f4, 0x0198b7f4, 0x0198f7f4,
		0x019937f4, 0x019977f4, 0x0199b7f4, 0x0199f7f4,
		0x019a37f4, 0x019a77f4, 0x019ab7f4, 0x019af7f4,
		0x019b37f4, 0x019b77f4, 0x019bb7f4, 0x019bf7f4,
		0x019c37f4, 0x019c77f4, 0x019cb7f4, 0x019cf7f4,
		0x019d37f4, 0x019d77f4, 0x019db7f4, 0x019df7f4,
		0x019e37f4, 0x019e77f4, 0x019eb7f4, 0x019ef7f4,
		0x019f37f4, 0x019f77f4, 0x019fb7f4, 0x019ff7f4,
		0x01a037f4, 0x01a077f4, 0x01a0b7f4, 0x01a0f7f4,
		0x01a137f4, 0x01a177f4, 0x01a1b7f4, 0x01a1f7f4,
		0x01a237f4, 0x01a277f4, 0x01a2b7f4, 0x01a2f7f4,
		0x01a337f4, 0x01a377f4, 0x01a3b7f4, 0x01a3f7f4,
		0x01a437f4, 0x01a477f4, 0x01a4b7f4, 0x01a4f7f4,
		0x01a537f4, 0x01a577f4, 0x01a5b7f4, 0x01a5f7f4,
		0x01a637f4, 0x01a677f4, 0x01a6b7f4, 0x01a6f7f4,
		0x01a737f4, 0x01a777f4, 0x01a7b7f4, 0x01a7f7f4,
		0x01a837f4, 0x01a877f4, 0x01a8b7f4, 0x01a8f7f4,
		0x01a937f4, 0x01a977f4, 0x01a9b7f4, 0x01a9f7f4,
		0x01aa37f4, 0x01aa77f4, 0x01aab7f4, 0x01aaf7f4,
		0x01ab37f4, 0x01ab77f4, 0x01abb7f4, 0x01abf7f4,
		0x01ac37f4, 0x01ac77f4, 0x01acb7f4, 0x01acf7f4,
		0x01ad37f4, 0x01ad77f4, 0x01adb7f4, 0x01adf7f4,
		0x01ae37f4, 0x01ae77f4, 0x01aeb7f4, 0x01aef7f4,
		0x01af37f4, 0x01af77f4, 0x01afb7f4, 0x01aff7f4,
		0x01b037f4, 0x01b077f4, 0x01b0b7f4, 0x01b0f7f4,
		0x01b137f4, 0x01b177f4, 0x01b1b7f4, 0x01b1f7f4,
		0x01b237f4, 0x01b277f4, 0x01b2b7f4, 0x01b2f7f4,
		0x01b337f4, 0x01b377f4, 0x01b3b7f4, 0x01b3f7f4,
		0x01b437f4, 0x01b477f4, 0x01b4b7f4, 0x01b4f7f4,
		0x01b537f4, 0x01b577f4, 0x01b5b7f4, 0x01b5f7f4,
		0x01b637f4, 0x01b677f4, 0x01b6b7f4, 0x01b6f7f4,
		0x01b737f4, 0x01b777f4, 0x01b7b7f4, 0x01b7f7f4,
		0x01b837f4, 0x01b877f4, 0x01b8b7f4, 0x01b8f7f4,
		0x01b937f4, 0x01b977f4, 0x01b9b7f4, 0x01b9f7f4,
		0x01ba37f4, 0x01ba77f4, 0x01bab7f4, 0x01baf7f4,
		0x01bb37f4, 0x01bb77f4, 0x01bbb7f4, 0x01bbf7f4,
		0x01bc37f4, 0x01bc77f4, 0x01bcb7f4, 0x01bcf7f4,
		0x01bd37f4, 0x01bd77f4, 0x01bdb7f4, 0x01bdf7f4,
		0x01be37f4, 0x01be77f4, 0x01beb7f4, 0x01bef7f4,
		0x01bf37f4, 0x01bf77f4, 0x01bfb7f4, 0x01bff7f4,
		0x01c037f4, 0x01c077f4, 0x01c0b7f4, 0x01c0f7f4,
		0x01c137f4, 0x01c177f4, 0x01c1b7f4, 0x01c1f7f4,
		0x01c237f4, 0x01c277f4, 0x01c2b7f4, 0x01c2f7f4,
		0x01c337f4, 0x01c377f4, 0x01c3b7f4, 0x01c3f7f4,
		0x01c437f4, 0x01c477f4, 0x01c4b7f4, 0x01c4f7f4,
		0x01c537f4, 0x01c577f4, 0x01c5b7f4, 0x01c5f7f4,
		0x01c637f4, 0x01c677f4, 0x01c6b7f4, 0x01c6f7f4,
		0x01c737f4, 0x01c777f4, 0x01c7b7f4, 0x01c7f7f4,
		0x01c837f4, 0x01c877f4, 0x01c8b7f4, 0x01c8f7f4,
		0x01c937f4, 0x01c977f4, 0x01c9b7f4, 0x01c9f7f4,
		0x01ca37f4, 0x01ca77f4, 0x01cab7f4, 0x01caf7f4,
		0x01cb37f4, 0x01cb77f4, 0x01cbb7f4, 0x01cbf7f4,
		0x01cc37f4, 0x01cc77f4, 0x01ccb7f4, 0x01ccf7f4,
		0x01cd37f4, 0x01cd77f4, 0x01cdb7f4, 0x01cdf7f4,
		0x01ce37f4, 0x01ce77f4, 0x01ceb7f4, 0x01cef7f4,
		0x01cf37f4, 0x01cf77f4, 0x01cfb7f4, 0x01cff7f4,
		0x01d037f4, 0x01d077f4, 0x01d0b7f4, 0x01d0f7f4,
		0x01d137f4, 0x01d177f4, 0x01d1b7f4, 0x01d1f7f4,
		0x01d237f4, 0x01d277f4, 0x01d2b7f4, 0x01d2f7f4,
		0x01d337f4, 0x01d377f4, 0x01d3b7f4, 0x01d3f7f4,
		0x01d437f4, 0x01d477f4, 0x01d4b7f4, 0x01d4f7f4,
		0x01d537f4, 0x01d577f4, 0x01d5b7f4, 0x01d5f7f4,
		0x01d637f4, 0x01d677f4, 0x01d6b7f4, 0x01d6f7f4,
		0x01d737f4, 0x01d777f4, 0x01d7b7f4, 0x01d7f7f4,
		0x01d837f4, 0x01d877f4, 0x01d8b7f4, 0x01d8f7f4,
		0x01d937f4, 0x01d977f4, 0x01d9b7f4, 0x01d9f7f4,
		0x01da37f4, 0x01da77f4, 0x01dab7f4, 0x01daf7f4,
		0x01db37f4, 0x01db77f4, 0x01dbb7f4, 0x01dbf7f4,
		0x01dc37f4, 0x01dc77f4, 0x01dcb7f4, 0x01dcf7f4,
		0x01dd37f4, 0x01dd77f4, 0x01ddb7f4, 0x01ddf7f4,
		0x01de37f4, 0x01de77f4, 0x01deb7f4, 0x01def7f4,
		0x01df37f4, 0x01df77f4, 0x01dfb7f4, 0x01dff7f4,
		0x01e037f4, 0x01e077f4, 0x01e0b7f4, 0x01e0f7f4,
		0x01e137f4, 0x01e177f4, 0x01e1b7f4, 0x01e1f7f4,
		0x01e237f4, 0x01e277f4, 0x01e2b7f4, 0x01e2f7f4,
		0x01e337f4, 0x01e377f4, 0x01e3b7f4, 0x01e3f7f4,
		0x01e437f4, 0x01e477f4, 0x01e4b7f4, 0x01e4f7f4,
		0x01e537f4, 0x01e577f4, 0x01e5b7f4, 0x01e5f7f4,
		0x01e637f4, 0x01e677f4, 0x01e6b7f4, 0x01e6f7f4,
		0x01e737f4, 0x01e777f4, 0x01e7b7f4, 0x01e7f7f4,
		0x01e837f4, 0x01e877f4, 0x01e8b7f4, 0x01e8f7f4,
		0x01e937f4, 0x01e977f4, 0x01e9b7f4, 0x01e9f7f4,
		0x01ea37f4, 0x01ea77f4, 0x01eab7f4, 0x01eaf7f4,
		0x01eb37f4, 0x01eb77f4, 0x01ebb7f4, 0x01ebf7f4,
		0x01ec37f4, 0x01ec77f4, 0x01ecb7f4, 0x01ecf7f4,
		0x01ed37f4, 0x01ed77f4, 0x01edb7f4, 0x01edf7f4,
		0x01ee37f4, 0x01ee77f4, 0x01eeb7f4, 0x01eef7f4,
		0x01ef37f4, 0x01ef77f4, 0x01efb7f4, 0x01eff7f4,
		0x01f037f4, 0x01f077f4, 0x01f0b7f4, 0x01f0f7f4,
		0x01f137f4, 0x01f177f4, 0x01f1b7f4, 0x01f1f7f4,
		0x01f237f4, 0x01f277f4, 0x01f2b7f4, 0x01f2f7f4,
		0x01f337f4, 0x01f377f4, 0x01f3b7f4, 0x01f3f7f4,
		0x01f437f4, 0x01f477f4, 0x01f4b7f4, 0x01f4f7f4,
		0x01f537f4, 0x01f577f4, 0x01f5b7f4, 0x01f5f7f4,
		0x01f637f4, 0x01f677f4, 0x01f6b7f4, 0x01f6f7f4,
		0x01f737f4, 0x01f777f4, 0x01f7b7f4, 0x01f7f7f4,
		0x01f837f4, 0x01f877f4, 0x01f8b7f4, 0x01f8f7f4,
		0x01f937f4, 0x01f977f4, 0x01f9b7f4, 0x01f9f7f4,
		0x01fa37f4, 0x01fa77f4, 0x01fab7f4, 0x01faf7f4,
		0x01fb37f4, 0x01fb77f4, 0x01fbb7f4, 0x01fbf7f4,
		0x01fc37f4, 0x01fc77f4, 0x01fcb7f4, 0x01fcf7f4,
		0x01fd37f4, 0x01fd77f4, 0x01fdb7f4, 0x01fdf7f4,
		0x01fe37f4, 0x01fe77f4, 0x01feb7f4, 0x01fef7f4,
		0x01ff37f4, 0x01ff77f4, 0x01ffb7f4, 0x01fff7f4 },
#else
	.dist_table = {
		0x00001be9, 0x00003be9, 0x00000be8, 0x000007e9,
		0x000001e7, 0x000009e7, 0x000027ea, 0x000067ea,
		0x000003e9, 0x000013e9, 0x000023e9, 0x000033e9,
		0x000005e8, 0x00000de8, 0x000015e8, 0x00001de8,
		0x00000068, 0x00000468, 0x00000868, 0x00000c68,
		0x00001068, 0x00001468, 0x00001868, 0x00001c68,
		0x00000268, 0x00000668, 0x00000a68, 0x00000e68,
		0x00001268, 0x00001668, 0x00001a68, 0x00001e68,
		0x00000048, 0x00000248, 0x00000448, 0x00000648,
		0x00000848, 0x00000a48, 0x00000c48, 0x00000e48,
		0x00001048, 0x00001248, 0x00001448, 0x00001648,
		0x00001848, 0x00001a48, 0x00001c48, 0x00001e48,
		0x00000148, 0x00000348, 0x00000548, 0x00000748,
		0x00000948, 0x00000b48, 0x00000d48, 0x00000f48,
		0x00001148, 0x00001348, 0x00001548, 0x00001748,
		0x00001948, 0x00001b48, 0x00001d48, 0x00001f48,
		0x000000c9, 0x000002c9, 0x000004c9, 0x000006c9,
		0x000008c9, 0x00000ac9, 0x00000cc9, 0x00000ec9,
		0x000010c9, 0x000012c9, 0x000014c9, 0x000016c9,
		0x000018c9, 0x00001ac9, 0x00001cc9, 0x00001ec9,
		0x000020c9, 0x000022c9, 0x000024c9, 0x000026c9,
		0x000028c9, 0x00002ac9, 0x00002cc9, 0x00002ec9,
		0x000030c9, 0x000032c9, 0x000034c9, 0x000036c9,
		0x000038c9, 0x00003ac9, 0x00003cc9, 0x00003ec9,
		0x0000016a, 0x0000056a, 0x0000096a, 0x00000d6a,
		0x0000116a, 0x0000156a, 0x0000196a, 0x00001d6a,
		0x0000216a, 0x0000256a, 0x0000296a, 0x00002d6a,
		0x0000316a, 0x0000356a, 0x0000396a, 0x00003d6a,
		0x0000416a, 0x0000456a, 0x0000496a, 0x00004d6a,
		0x0000516a, 0x0000556a, 0x0000596a, 0x00005d6a,
		0x0000616a, 0x0000656a, 0x0000696a, 0x00006d6a,
		0x0000716a, 0x0000756a, 0x0000796a, 0x00007d6a,
		0x000001ca, 0x000003ca, 0x000005ca, 0x000007ca,
		0x000009ca, 0x00000bca, 0x00000dca, 0x00000fca,
		0x000011ca, 0x000013ca, 0x000015ca, 0x000017ca,
		0x000019ca, 0x00001bca, 0x00001dca, 0x00001fca,
		0x000021ca, 0x000023ca, 0x000025ca, 0x000027ca,
		0x000029ca, 0x00002bca, 0x00002dca, 0x00002fca,
		0x000031ca, 0x000033ca, 0x000035ca, 0x000037ca,
		0x000039ca, 0x00003bca, 0x00003dca, 0x00003fca,
		0x000041ca, 0x000043ca, 0x000045ca, 0x000047ca,
		0x000049ca, 0x00004bca, 0x00004dca, 0x00004fca,
		0x000051ca, 0x000053ca, 0x000055ca, 0x000057ca,
		0x000059ca, 0x00005bca, 0x00005dca, 0x00005fca,
		0x000061ca, 0x000063ca, 0x000065ca, 0x000067ca,
		0x000069ca, 0x00006bca, 0x00006dca, 0x00006fca,
		0x000071ca, 0x000073ca, 0x000075ca, 0x000077ca,
		0x000079ca, 0x00007bca, 0x00007dca, 0x00007fca,
		0x0000002a, 0x0000022a, 0x0000042a, 0x0000062a,
		0x0000082a, 0x00000a2a, 0x00000c2a, 0x00000e2a,
		0x0000102a, 0x0000122a, 0x0000142a, 0x0000162a,
		0x0000182a, 0x00001a2a, 0x00001c2a, 0x00001e2a,
		0x0000202a, 0x0000222a, 0x0000242a, 0x0000262a,
		0x0000282a, 0x00002a2a, 0x00002c2a, 0x00002e2a,
		0x0000302a, 0x0000322a, 0x0000342a, 0x0000362a,
		0x0000382a, 0x00003a2a, 0x00003c2a, 0x00003e2a,
		0x0000402a, 0x0000422a, 0x0000442a, 0x0000462a,
		0x0000482a, 0x00004a2a, 0x00004c2a, 0x00004e2a,
		0x0000502a, 0x0000522a, 0x0000542a, 0x0000562a,
		0x0000582a, 0x00005a2a, 0x00005c2a, 0x00005e2a,
		0x0000602a, 0x0000622a, 0x0000642a, 0x0000662a,
		0x0000682a, 0x00006a2a, 0x00006c2a, 0x00006e2a,
		0x0000702a, 0x0000722a, 0x0000742a, 0x0000762a,
		0x0000782a, 0x00007a2a, 0x00007c2a, 0x00007e2a,
		0x0000000a, 0x0000010a, 0x0000020a, 0x0000030a,
		0x0000040a, 0x0000050a, 0x0000060a, 0x0000070a,
		0x0000080a, 0x0000090a, 0x00000a0a, 0x00000b0a,
		0x00000c0a, 0x00000d0a, 0x00000e0a, 0x00000f0a,
		0x0000100a, 0x0000110a, 0x0000120a, 0x0000130a,
		0x0000140a, 0x0000150a, 0x0000160a, 0x0000170a,
		0x0000180a, 0x0000190a, 0x00001a0a, 0x00001b0a,
		0x00001c0a, 0x00001d0a, 0x00001e0a, 0x00001f0a,
		0x0000200a, 0x0000210a, 0x0000220a, 0x0000230a,
		0x0000240a, 0x0000250a, 0x0000260a, 0x0000270a,
		0x0000280a, 0x0000290a, 0x00002a0a, 0x00002b0a,
		0x00002c0a, 0x00002d0a, 0x00002e0a, 0x00002f0a,
		0x0000300a, 0x0000310a, 0x0000320a, 0x0000330a,
		0x0000340a, 0x0000350a, 0x0000360a, 0x0000370a,
		0x0000380a, 0x0000390a, 0x00003a0a, 0x00003b0a,
		0x00003c0a, 0x00003d0a, 0x00003e0a, 0x00003f0a,
		0x0000400a, 0x0000410a, 0x0000420a, 0x0000430a,
		0x0000440a, 0x0000450a, 0x0000460a, 0x0000470a,
		0x0000480a, 0x0000490a, 0x00004a0a, 0x00004b0a,
		0x00004c0a, 0x00004d0a, 0x00004e0a, 0x00004f0a,
		0x0000500a, 0x0000510a, 0x0000520a, 0x0000530a,
		0x0000540a, 0x0000550a, 0x0000560a, 0x0000570a,
		0x0000580a, 0x0000590a, 0x00005a0a, 0x00005b0a,
		0x00005c0a, 0x00005d0a, 0x00005e0a, 0x00005f0a,
		0x0000600a, 0x0000610a, 0x0000620a, 0x0000630a,
		0x0000640a, 0x0000650a, 0x0000660a, 0x0000670a,
		0x0000680a, 0x0000690a, 0x00006a0a, 0x00006b0a,
		0x00006c0a, 0x00006d0a, 0x00006e0a, 0x00006f0a,
		0x0000700a, 0x0000710a, 0x0000720a, 0x0000730a,
		0x0000740a, 0x0000750a, 0x0000760a, 0x0000770a,
		0x0000780a, 0x0000790a, 0x00007a0a, 0x00007b0a,
		0x00007c0a, 0x00007d0a, 0x00007e0a, 0x00007f0a,
		0x0000012b, 0x0000032b, 0x0000052b, 0x0000072b,
		0x0000092b, 0x00000b2b, 0x00000d2b, 0x00000f2b,
		0x0000112b, 0x0000132b, 0x0000152b, 0x0000172b,
		0x0000192b, 0x00001b2b, 0x00001d2b, 0x00001f2b,
		0x0000212b, 0x0000232b, 0x0000252b, 0x0000272b,
		0x0000292b, 0x00002b2b, 0x00002d2b, 0x00002f2b,
		0x0000312b, 0x0000332b, 0x0000352b, 0x0000372b,
		0x0000392b, 0x00003b2b, 0x00003d2b, 0x00003f2b,
		0x0000412b, 0x0000432b, 0x0000452b, 0x0000472b,
		0x0000492b, 0x00004b2b, 0x00004d2b, 0x00004f2b,
		0x0000512b, 0x0000532b, 0x0000552b, 0x0000572b,
		0x0000592b, 0x00005b2b, 0x00005d2b, 0x00005f2b,
		0x0000612b, 0x0000632b, 0x0000652b, 0x0000672b,
		0x0000692b, 0x00006b2b, 0x00006d2b, 0x00006f2b,
		0x0000712b, 0x0000732b, 0x0000752b, 0x0000772b,
		0x0000792b, 0x00007b2b, 0x00007d2b, 0x00007f2b,
		0x0000812b, 0x0000832b, 0x0000852b, 0x0000872b,
		0x0000892b, 0x00008b2b, 0x00008d2b, 0x00008f2b,
		0x0000912b, 0x0000932b, 0x0000952b, 0x0000972b,
		0x0000992b, 0x00009b2b, 0x00009d2b, 0x00009f2b,
		0x0000a12b, 0x0000a32b, 0x0000a52b, 0x0000a72b,
		0x0000a92b, 0x0000ab2b, 0x0000ad2b, 0x0000af2b,
		0x0000b12b, 0x0000b32b, 0x0000b52b, 0x0000b72b,
		0x0000b92b, 0x0000bb2b, 0x0000bd2b, 0x0000bf2b,
		0x0000c12b, 0x0000c32b, 0x0000c52b, 0x0000c72b,
		0x0000c92b, 0x0000cb2b, 0x0000cd2b, 0x0000cf2b,
		0x0000d12b, 0x0000d32b, 0x0000d52b, 0x0000d72b,
		0x0000d92b, 0x0000db2b, 0x0000dd2b, 0x0000df2b,
		0x0000e12b, 0x0000e32b, 0x0000e52b, 0x0000e72b,
		0x0000e92b, 0x0000eb2b, 0x0000ed2b, 0x0000ef2b,
		0x0000f12b, 0x0000f32b, 0x0000f52b, 0x0000f72b,
		0x0000f92b, 0x0000fb2b, 0x0000fd2b, 0x0000ff2b,
		0x0000008b, 0x0000018b, 0x0000028b, 0x0000038b,
		0x0000048b, 0x0000058b, 0x0000068b, 0x0000078b,
		0x0000088b, 0x0000098b, 0x00000a8b, 0x00000b8b,
		0x00000c8b, 0x00000d8b, 0x00000e8b, 0x00000f8b,
		0x0000108b, 0x0000118b, 0x0000128b, 0x0000138b,
		0x0000148b, 0x0000158b, 0x0000168b, 0x0000178b,
		0x0000188b, 0x0000198b, 0x00001a8b, 0x00001b8b,
		0x00001c8b, 0x00001d8b, 0x00001e8b, 0x00001f8b,
		0x0000208b, 0x0000218b, 0x0000228b, 0x0000238b,
		0x0000248b, 0x0000258b, 0x0000268b, 0x0000278b,
		0x0000288b, 0x0000298b, 0x00002a8b, 0x00002b8b,
		0x00002c8b, 0x00002d8b, 0x00002e8b, 0x00002f8b,
		0x0000308b, 0x0000318b, 0x0000328b, 0x0000338b,
		0x0000348b, 0x0000358b, 0x0000368b, 0x0000378b,
		0x0000388b, 0x0000398b, 0x00003a8b, 0x00003b8b,
		0x00003c8b, 0x00003d8b, 0x00003e8b, 0x00003f8b,
		0x0000408b, 0x0000418b, 0x0000428b, 0x0000438b,
		0x0000448b, 0x0000458b, 0x0000468b, 0x0000478b,
		0x0000488b, 0x0000498b, 0x00004a8b, 0x00004b8b,
		0x00004c8b, 0x00004d8b, 0x00004e8b, 0x00004f8b,
		0x0000508b, 0x0000518b, 0x0000528b, 0x0000538b,
		0x0000548b, 0x0000558b, 0x0000568b, 0x0000578b,
		0x0000588b, 0x0000598b, 0x00005a8b, 0x00005b8b,
		0x00005c8b, 0x00005d8b, 0x00005e8b, 0x00005f8b,
		0x0000608b, 0x0000618b, 0x0000628b, 0x0000638b,
		0x0000648b, 0x0000658b, 0x0000668b, 0x0000678b,
		0x0000688b, 0x0000698b, 0x00006a8b, 0x00006b8b,
		0x00006c8b, 0x00006d8b, 0x00006e8b, 0x00006f8b,
		0x0000708b, 0x0000718b, 0x0000728b, 0x0000738b,
		0x0000748b, 0x0000758b, 0x0000768b, 0x0000778b,
		0x0000788b, 0x0000798b, 0x00007a8b, 0x00007b8b,
		0x00007c8b, 0x00007d8b, 0x00007e8b, 0x00007f8b,
		0x0000808b, 0x0000818b, 0x0000828b, 0x0000838b,
		0x0000848b, 0x0000858b, 0x0000868b, 0x0000878b,
		0x0000888b, 0x0000898b, 0x00008a8b, 0x00008b8b,
		0x00008c8b, 0x00008d8b, 0x00008e8b, 0x00008f8b,
		0x0000908b, 0x0000918b, 0x0000928b, 0x0000938b,
		0x0000948b, 0x0000958b, 0x0000968b, 0x0000978b,
		0x0000988b, 0x0000998b, 0x00009a8b, 0x00009b8b,
		0x00009c8b, 0x00009d8b, 0x00009e8b, 0x00009f8b,
		0x0000a08b, 0x0000a18b, 0x0000a28b, 0x0000a38b,
		0x0000a48b, 0x0000a58b, 0x0000a68b, 0x0000a78b,
		0x0000a88b, 0x0000a98b, 0x0000aa8b, 0x0000ab8b,
		0x0000ac8b, 0x0000ad8b, 0x0000ae8b, 0x0000af8b,
		0x0000b08b, 0x0000b18b, 0x0000b28b, 0x0000b38b,
		0x0000b48b, 0x0000b58b, 0x0000b68b, 0x0000b78b,
		0x0000b88b, 0x0000b98b, 0x0000ba8b, 0x0000bb8b,
		0x0000bc8b, 0x0000bd8b, 0x0000be8b, 0x0000bf8b,
		0x0000c08b, 0x0000c18b, 0x0000c28b, 0x0000c38b,
		0x0000c48b, 0x0000c58b, 0x0000c68b, 0x0000c78b,
		0x0000c88b, 0x0000c98b, 0x0000ca8b, 0x0000cb8b,
		0x0000cc8b, 0x0000cd8b, 0x0000ce8b, 0x0000cf8b,
		0x0000d08b, 0x0000d18b, 0x0000d28b, 0x0000d38b,
		0x0000d48b, 0x0000d58b, 0x0000d68b, 0x0000d78b,
		0x0000d88b, 0x0000d98b, 0x0000da8b, 0x0000db8b,
		0x0000dc8b, 0x0000dd8b, 0x0000de8b, 0x0000df8b,
		0x0000e08b, 0x0000e18b, 0x0000e28b, 0x0000e38b,
		0x0000e48b, 0x0000e58b, 0x0000e68b, 0x0000e78b,
		0x0000e88b, 0x0000e98b, 0x0000ea8b, 0x0000eb8b,
		0x0000ec8b, 0x0000ed8b, 0x0000ee8b, 0x0000ef8b,
		0x0000f08b, 0x0000f18b, 0x0000f28b, 0x0000f38b,
		0x0000f48b, 0x0000f58b, 0x0000f68b, 0x0000f78b,
		0x0000f88b, 0x0000f98b, 0x0000fa8b, 0x0000fb8b,
		0x0000fc8b, 0x0000fd8b, 0x0000fe8b, 0x0000ff8b,
		0x000000ac, 0x000002ac, 0x000004ac, 0x000006ac,
		0x000008ac, 0x00000aac, 0x00000cac, 0x00000eac,
		0x000010ac, 0x000012ac, 0x000014ac, 0x000016ac,
		0x000018ac, 0x00001aac, 0x00001cac, 0x00001eac,
		0x000020ac, 0x000022ac, 0x000024ac, 0x000026ac,
		0x000028ac, 0x00002aac, 0x00002cac, 0x00002eac,
		0x000030ac, 0x000032ac, 0x000034ac, 0x000036ac,
		0x000038ac, 0x00003aac, 0x00003cac, 0x00003eac,
		0x000040ac, 0x000042ac, 0x000044ac, 0x000046ac,
		0x000048ac, 0x00004aac, 0x00004cac, 0x00004eac,
		0x000050ac, 0x000052ac, 0x000054ac, 0x000056ac,
		0x000058ac, 0x00005aac, 0x00005cac, 0x00005eac,
		0x000060ac, 0x000062ac, 0x000064ac, 0x000066ac,
		0x000068ac, 0x00006aac, 0x00006cac, 0x00006eac,
		0x000070ac, 0x000072ac, 0x000074ac, 0x000076ac,
		0x000078ac, 0x00007aac, 0x00007cac, 0x00007eac,
		0x000080ac, 0x000082ac, 0x000084ac, 0x000086ac,
		0x000088ac, 0x00008aac, 0x00008cac, 0x00008eac,
		0x000090ac, 0x000092ac, 0x000094ac, 0x000096ac,
		0x000098ac, 0x00009aac, 0x00009cac, 0x00009eac,
		0x0000a0ac, 0x0000a2ac, 0x0000a4ac, 0x0000a6ac,
		0x0000a8ac, 0x0000aaac, 0x0000acac, 0x0000aeac,
		0x0000b0ac, 0x0000b2ac, 0x0000b4ac, 0x0000b6ac,
		0x0000b8ac, 0x0000baac, 0x0000bcac, 0x0000beac,
		0x0000c0ac, 0x0000c2ac, 0x0000c4ac, 0x0000c6ac,
		0x0000c8ac, 0x0000caac, 0x0000ccac, 0x0000ceac,
		0x0000d0ac, 0x0000d2ac, 0x0000d4ac, 0x0000d6ac,
		0x0000d8ac, 0x0000daac, 0x0000dcac, 0x0000deac,
		0x0000e0ac, 0x0000e2ac, 0x0000e4ac, 0x0000e6ac,
		0x0000e8ac, 0x0000eaac, 0x0000ecac, 0x0000eeac,
		0x0000f0ac, 0x0000f2ac, 0x0000f4ac, 0x0000f6ac,
		0x0000f8ac, 0x0000faac, 0x0000fcac, 0x0000feac,
		0x000100ac, 0x000102ac, 0x000104ac, 0x000106ac,
		0x000108ac, 0x00010aac, 0x00010cac, 0x00010eac,
		0x000110ac, 0x000112ac, 0x000114ac, 0x000116ac,
		0x000118ac, 0x00011aac, 0x00011cac, 0x00011eac,
		0x000120ac, 0x000122ac, 0x000124ac, 0x000126ac,
		0x000128ac, 0x00012aac, 0x00012cac, 0x00012eac,
		0x000130ac, 0x000132ac, 0x000134ac, 0x000136ac,
		0x000138ac, 0x00013aac, 0x00013cac, 0x00013eac,
		0x000140ac, 0x000142ac, 0x000144ac, 0x000146ac,
		0x000148ac, 0x00014aac, 0x00014cac, 0x00014eac,
		0x000150ac, 0x000152ac, 0x000154ac, 0x000156ac,
		0x000158ac, 0x00015aac, 0x00015cac, 0x00015eac,
		0x000160ac, 0x000162ac, 0x000164ac, 0x000166ac,
		0x000168ac, 0x00016aac, 0x00016cac, 0x00016eac,
		0x000170ac, 0x000172ac, 0x000174ac, 0x000176ac,
		0x000178ac, 0x00017aac, 0x00017cac, 0x00017eac,
		0x000180ac, 0x000182ac, 0x000184ac, 0x000186ac,
		0x000188ac, 0x00018aac, 0x00018cac, 0x00018eac,
		0x000190ac, 0x000192ac, 0x000194ac, 0x000196ac,
		0x000198ac, 0x00019aac, 0x00019cac, 0x00019eac,
		0x0001a0ac, 0x0001a2ac, 0x0001a4ac, 0x0001a6ac,
		0x0001a8ac, 0x0001aaac, 0x0001acac, 0x0001aeac,
		0x0001b0ac, 0x0001b2ac, 0x0001b4ac, 0x0001b6ac,
		0x0001b8ac, 0x0001baac, 0x0001bcac, 0x0001beac,
		0x0001c0ac, 0x0001c2ac, 0x0001c4ac, 0x0001c6ac,
		0x0001c8ac, 0x0001caac, 0x0001ccac, 0x0001ceac,
		0x0001d0ac, 0x0001d2ac, 0x0001d4ac, 0x0001d6ac,
		0x0001d8ac, 0x0001daac, 0x0001dcac, 0x0001deac,
		0x0001e0ac, 0x0001e2ac, 0x0001e4ac, 0x0001e6ac,
		0x0001e8ac, 0x0001eaac, 0x0001ecac, 0x0001eeac,
		0x0001f0ac, 0x0001f2ac, 0x0001f4ac, 0x0001f6ac,
		0x0001f8ac, 0x0001faac, 0x0001fcac, 0x0001feac },
#endif

	.len_table = {
		0x00000004, 0x00000104, 0x00000185, 0x00000385,
		0x000007c6, 0x00000026, 0x000003a7, 0x00000426,
		0x00000227, 0x00000a27, 0x00000627, 0x00000e27,
		0x00000127, 0x00000927, 0x00000ba8, 0x00001ba8,
		0x00000528, 0x00000d28, 0x00001528, 0x00001d28,
		0x0000066a, 0x0000266a, 0x0000466a, 0x0000666a,
		0x0000166a, 0x0000366a, 0x0000566a, 0x0000766a,
		0x0000276b, 0x0000676b, 0x0000a76b, 0x0000e76b,
		0x00000e6b, 0x00002e6b, 0x00004e6b, 0x00006e6b,
		0x00008e6b, 0x0000ae6b, 0x0000ce6b, 0x0000ee6b,
		0x00001e6b, 0x00003e6b, 0x00005e6b, 0x00007e6b,
		0x00009e6b, 0x0000be6b, 0x0000de6b, 0x0000fe6b,
		0x00005fee, 0x00015fee, 0x00025fee, 0x00035fee,
		0x00045fee, 0x00055fee, 0x00065fee, 0x00075fee,
		0x0000176c, 0x0000576c, 0x0000976c, 0x0000d76c,
		0x0001176c, 0x0001576c, 0x0001976c, 0x0001d76c,
		0x0000dfef, 0x0001dfef, 0x0002dfef, 0x0003dfef,
		0x0004dfef, 0x0005dfef, 0x0006dfef, 0x0007dfef,
		0x0008dfef, 0x0009dfef, 0x000adfef, 0x000bdfef,
		0x000cdfef, 0x000ddfef, 0x000edfef, 0x000fdfef,
		0x00003fef, 0x00013fef, 0x00023fef, 0x00033fef,
		0x00043fef, 0x00053fef, 0x00063fef, 0x00073fef,
		0x00083fef, 0x00093fef, 0x000a3fef, 0x000b3fef,
		0x000c3fef, 0x000d3fef, 0x000e3fef, 0x000f3fef,
		0x000051ee, 0x0000d1ee, 0x000151ee, 0x0001d1ee,
		0x000251ee, 0x0002d1ee, 0x000351ee, 0x0003d1ee,
		0x000451ee, 0x0004d1ee, 0x000551ee, 0x0005d1ee,
		0x000651ee, 0x0006d1ee, 0x000751ee, 0x0007d1ee,
		0x0000376d, 0x0000776d, 0x0000b76d, 0x0000f76d,
		0x0001376d, 0x0001776d, 0x0001b76d, 0x0001f76d,
		0x0002376d, 0x0002776d, 0x0002b76d, 0x0002f76d,
		0x0003376d, 0x0003776d, 0x0003b76d, 0x0003f76d,
		0x0000bff0, 0x0001bff0, 0x0002bff0, 0x0003bff0,
		0x0004bff0, 0x0005bff0, 0x0006bff0, 0x0007bff0,
		0x0008bff0, 0x0009bff0, 0x000abff0, 0x000bbff0,
		0x000cbff0, 0x000dbff0, 0x000ebff0, 0x000fbff0,
		0x0010bff0, 0x0011bff0, 0x0012bff0, 0x0013bff0,
		0x0014bff0, 0x0015bff0, 0x0016bff0, 0x0017bff0,
		0x0018bff0, 0x0019bff0, 0x001abff0, 0x001bbff0,
		0x001cbff0, 0x001dbff0, 0x001ebff0, 0x001fbff0,
		0x000031ef, 0x0000b1ef, 0x000131ef, 0x0001b1ef,
		0x000231ef, 0x0002b1ef, 0x000331ef, 0x0003b1ef,
		0x000431ef, 0x0004b1ef, 0x000531ef, 0x0005b1ef,
		0x000631ef, 0x0006b1ef, 0x000731ef, 0x0007b1ef,
		0x000831ef, 0x0008b1ef, 0x000931ef, 0x0009b1ef,
		0x000a31ef, 0x000ab1ef, 0x000b31ef, 0x000bb1ef,
		0x000c31ef, 0x000cb1ef, 0x000d31ef, 0x000db1ef,
		0x000e31ef, 0x000eb1ef, 0x000f31ef, 0x000fb1ef,
		0x00007ff0, 0x00017ff0, 0x00027ff0, 0x00037ff0,
		0x00047ff0, 0x00057ff0, 0x00067ff0, 0x00077ff0,
		0x00087ff0, 0x00097ff0, 0x000a7ff0, 0x000b7ff0,
		0x000c7ff0, 0x000d7ff0, 0x000e7ff0, 0x000f7ff0,
		0x00107ff0, 0x00117ff0, 0x00127ff0, 0x00137ff0,
		0x00147ff0, 0x00157ff0, 0x00167ff0, 0x00177ff0,
		0x00187ff0, 0x00197ff0, 0x001a7ff0, 0x001b7ff0,
		0x001c7ff0, 0x001d7ff0, 0x001e7ff0, 0x001f7ff0,
		0x0000fff0, 0x0001fff0, 0x0002fff0, 0x0003fff0,
		0x0004fff0, 0x0005fff0, 0x0006fff0, 0x0007fff0,
		0x0008fff0, 0x0009fff0, 0x000afff0, 0x000bfff0,
		0x000cfff0, 0x000dfff0, 0x000efff0, 0x000ffff0,
		0x0010fff0, 0x0011fff0, 0x0012fff0, 0x0013fff0,
		0x0014fff0, 0x0015fff0, 0x0016fff0, 0x0017fff0,
		0x0018fff0, 0x0019fff0, 0x001afff0, 0x001bfff0,
		0x001cfff0, 0x001dfff0, 0x001efff0, 0x000071ea },

	.lit_table = {
		0x007b, 0x004f, 0x027b, 0x044f, 0x024f, 0x017b, 0x064f, 0x037b,
		0x014f, 0x0019, 0x0002, 0x054f, 0x00fb, 0x02fb, 0x034f, 0x074f,
		0x00cf, 0x04cf, 0x01fb, 0x02cf, 0x03fb, 0x0007, 0x0207, 0x0107,
		0x06cf, 0x01cf, 0x0307, 0x05cf, 0x0087, 0x0287, 0x03cf, 0x07cf,
		0x0004, 0x003d, 0x0022, 0x0187, 0x002f, 0x0387, 0x000b, 0x0059,
		0x0012, 0x0039, 0x0047, 0x00bd, 0x0079, 0x007d, 0x0032, 0x00fd,
		0x0003, 0x042f, 0x010b, 0x0247, 0x008b, 0x022f, 0x0147, 0x062f,
		0x012f, 0x052f, 0x018b, 0x0005, 0x004b, 0x0045, 0x014b, 0x032f,
		0x072f, 0x0083, 0x00cb, 0x0043, 0x01cb, 0x00c3, 0x002b, 0x012b,
		0x0023, 0x00ab, 0x00af, 0x0347, 0x01ab, 0x00a3, 0x006b, 0x016b,
		0x00eb, 0x00c7, 0x0063, 0x00e3, 0x0025, 0x01eb, 0x001b, 0x04af,
		0x0013, 0x02af, 0x02c7, 0x011b, 0x009b, 0x019b, 0x01c7, 0x0065,
		0x06af, 0x000a, 0x0093, 0x002a, 0x001a, 0x0014, 0x0015, 0x0055,
		0x0035, 0x003a, 0x005b, 0x015b, 0x0006, 0x0075, 0x0026, 0x0016,
		0x000d, 0x00db, 0x0036, 0x000e, 0x002e, 0x001e, 0x004d, 0x002d,
		0x0053, 0x006d, 0x01af, 0x01db, 0x003b, 0x00d3, 0x05af, 0x03c7,
		0x03af, 0x07af, 0x006f, 0x046f, 0x026f, 0x066f, 0x016f, 0x056f,
		0x036f, 0x076f, 0x00ef, 0x04ef, 0x0027, 0x0227, 0x02ef, 0x0127,
		0x0327, 0x00a7, 0x02a7, 0x01a7, 0x03a7, 0x06ef, 0x01ef, 0x05ef,
		0x0067, 0x03ef, 0x07ef, 0x0267, 0x0167, 0x0367, 0x00e7, 0x001f,
		0x041f, 0x021f, 0x061f, 0x02e7, 0x01e7, 0x03e7, 0x011f, 0x0017,
		0x0217, 0x051f, 0x031f, 0x0117, 0x0317, 0x0097, 0x0297, 0x071f,
		0x009f, 0x049f, 0x029f, 0x069f, 0x019f, 0x0197, 0x0397, 0x059f,
		0x039f, 0x0057, 0x0257, 0x0157, 0x0357, 0x079f, 0x005f, 0x045f,
		0x025f, 0x00d7, 0x02d7, 0x065f, 0x015f, 0x055f, 0x01d7, 0x035f,
		0x075f, 0x03d7, 0x0037, 0x00df, 0x04df, 0x02df, 0x06df, 0x01df,
		0x05df, 0x03df, 0x0237, 0x07df, 0x003f, 0x0137, 0x0337, 0x043f,
		0x023f, 0x063f, 0x00b7, 0x02b7, 0x01b7, 0x03b7, 0x0077, 0x013f,
		0x053f, 0x033f, 0x073f, 0x00bf, 0x0277, 0x0177, 0x04bf, 0x02bf,
		0x06bf, 0x01bf, 0x05bf, 0x0377, 0x00f7, 0x02f7, 0x01f7, 0x03f7,
		0x000f, 0x03bf, 0x07bf, 0x020f, 0x010f, 0x007f, 0x047f, 0x030f,
		0x027f, 0x067f, 0x017f, 0x057f, 0x037f, 0x077f, 0x00ff, 0x008f,
		0x04ff },

	.lit_table_sizes = {
		0xa, 0xb, 0xa, 0xb, 0xb, 0xa, 0xb, 0xa,
		0xb, 0x7, 0x6, 0xb, 0xa, 0xa, 0xb, 0xb,
		0xb, 0xb, 0xa, 0xb, 0xa, 0xa, 0xa, 0xa,
		0xb, 0xb, 0xa, 0xb, 0xa, 0xa, 0xb, 0xb,
		0x5, 0x8, 0x6, 0xa, 0xb, 0xa, 0x9, 0x7,
		0x6, 0x7, 0xa, 0x8, 0x7, 0x8, 0x6, 0x8,
		0x8, 0xb, 0x9, 0xa, 0x9, 0xb, 0xa, 0xb,
		0xb, 0xb, 0x9, 0x7, 0x9, 0x7, 0x9, 0xb,
		0xb, 0x8, 0x9, 0x8, 0x9, 0x8, 0x9, 0x9,
		0x8, 0x9, 0xb, 0xa, 0x9, 0x8, 0x9, 0x9,
		0x9, 0xa, 0x8, 0x8, 0x7, 0x9, 0x9, 0xb,
		0x8, 0xb, 0xa, 0x9, 0x9, 0x9, 0xa, 0x7,
		0xb, 0x6, 0x8, 0x6, 0x6, 0x5, 0x7, 0x7,
		0x7, 0x6, 0x9, 0x9, 0x6, 0x7, 0x6, 0x6,
		0x7, 0x9, 0x6, 0x6, 0x6, 0x6, 0x7, 0x7,
		0x8, 0x7, 0xb, 0x9, 0x9, 0x8, 0xb, 0xa,
		0xb, 0xb, 0xb, 0xb, 0xb, 0xb, 0xb, 0xb,
		0xb, 0xb, 0xb, 0xb, 0xa, 0xa, 0xb, 0xa,
		0xa, 0xa, 0xa, 0xa, 0xa, 0xb, 0xb, 0xb,
		0xa, 0xb, 0xb, 0xa, 0xa, 0xa, 0xa, 0xb,
		0xb, 0xb, 0xb, 0xa, 0xa, 0xa, 0xb, 0xa,
		0xa, 0xb, 0xb, 0xa, 0xa, 0xa, 0xa, 0xb,
		0xb, 0xb, 0xb, 0xb, 0xb, 0xa, 0xa, 0xb,
		0xb, 0xa, 0xa, 0xa, 0xa, 0xb, 0xb, 0xb,
		0xb, 0xa, 0xa, 0xb, 0xb, 0xb, 0xa, 0xb,
		0xb, 0xa, 0xa, 0xb, 0xb, 0xb, 0xb, 0xb,
		0xb, 0xb, 0xa, 0xb, 0xb, 0xa, 0xa, 0xb,
		0xb, 0xb, 0xa, 0xa, 0xa, 0xa, 0xa, 0xb,
		0xb, 0xb, 0xb, 0xb, 0xa, 0xa, 0xb, 0xb,
		0xb, 0xb, 0xb, 0xa, 0xa, 0xa, 0xa, 0xa,
		0xa, 0xb, 0xb, 0xa, 0xa, 0xb, 0xb, 0xa,
		0xb, 0xb, 0xb, 0xb, 0xb, 0xb, 0xb, 0xa,
		0xb },

#ifndef LONGER_HUFFTABLE
	.dcodes = {
		0x000d, 0x001b, 0x0007, 0x0017, 0x00bf, 0x01bf, 0x007f, 0x017f,
		0x00ff, 0x01ff },
	.dcodes_sizes = { 0x4, 0x5, 0x5, 0x5, 0x9, 0x9, 0x9, 0x9,0x9, 0x9 }
#else
	.dcodes = { 0x007f, 0x017f, 0x00ff, 0x01ff },
	.dcodes_sizes = { 0x9, 0x9, 0x9, 0x9 }
#endif
};
