/* initial-state-handler.c generated by valac 0.22.1, the Vala compiler
 * generated from initial-state-handler.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define KKC_TYPE_STATE_HANDLER (kkc_state_handler_get_type ())
#define KKC_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandler))
#define KKC_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))
#define KKC_IS_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE_HANDLER))
#define KKC_IS_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE_HANDLER))
#define KKC_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))

typedef struct _KkcStateHandler KkcStateHandler;
typedef struct _KkcStateHandlerClass KkcStateHandlerClass;
typedef struct _KkcStateHandlerPrivate KkcStateHandlerPrivate;

#define KKC_TYPE_STATE (kkc_state_get_type ())
#define KKC_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE, KkcState))
#define KKC_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE, KkcStateClass))
#define KKC_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE))
#define KKC_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE))
#define KKC_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE, KkcStateClass))

typedef struct _KkcState KkcState;
typedef struct _KkcStateClass KkcStateClass;

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;

#define KKC_TYPE_INITIAL_STATE_HANDLER (kkc_initial_state_handler_get_type ())
#define KKC_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandler))
#define KKC_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))
#define KKC_IS_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_IS_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_INITIAL_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))

typedef struct _KkcInitialStateHandler KkcInitialStateHandler;
typedef struct _KkcInitialStateHandlerClass KkcInitialStateHandlerClass;
typedef struct _KkcInitialStateHandlerPrivate KkcInitialStateHandlerPrivate;
typedef struct _KkcStatePrivate KkcStatePrivate;

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_DECODER (kkc_decoder_get_type ())
#define KKC_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DECODER, KkcDecoder))
#define KKC_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DECODER, KkcDecoderClass))
#define KKC_IS_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DECODER))
#define KKC_IS_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DECODER))
#define KKC_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DECODER, KkcDecoderClass))

typedef struct _KkcDecoder KkcDecoder;
typedef struct _KkcDecoderClass KkcDecoderClass;

#define KKC_TYPE_SEGMENT_LIST (kkc_segment_list_get_type ())
#define KKC_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentList))
#define KKC_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))
#define KKC_IS_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_LIST))
#define KKC_IS_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT_LIST))
#define KKC_SEGMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))

typedef struct _KkcSegmentList KkcSegmentList;
typedef struct _KkcSegmentListClass KkcSegmentListClass;

#define KKC_TYPE_CANDIDATE_LIST (kkc_candidate_list_get_type ())
#define KKC_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateList))
#define KKC_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))
#define KKC_IS_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE_LIST))
#define KKC_IS_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE_LIST))
#define KKC_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))

typedef struct _KkcCandidateList KkcCandidateList;
typedef struct _KkcCandidateListClass KkcCandidateListClass;

#define KKC_TYPE_DICTIONARY_LIST (kkc_dictionary_list_get_type ())
#define KKC_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryList))
#define KKC_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))
#define KKC_IS_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY_LIST))
#define KKC_IS_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DICTIONARY_LIST))
#define KKC_DICTIONARY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))

typedef struct _KkcDictionaryList KkcDictionaryList;
typedef struct _KkcDictionaryListClass KkcDictionaryListClass;

#define KKC_TYPE_ROM_KANA_CONVERTER (kkc_rom_kana_converter_get_type ())
#define KKC_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter))
#define KKC_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))
#define KKC_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))

typedef struct _KkcRomKanaConverter KkcRomKanaConverter;
typedef struct _KkcRomKanaConverterClass KkcRomKanaConverterClass;

#define KKC_TYPE_ROM_KANA_CHARACTER_LIST (kkc_rom_kana_character_list_get_type ())
#define KKC_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList))
#define KKC_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))
#define KKC_IS_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_IS_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_ROM_KANA_CHARACTER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))

typedef struct _KkcRomKanaCharacterList KkcRomKanaCharacterList;
typedef struct _KkcRomKanaCharacterListClass KkcRomKanaCharacterListClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_SEGMENT (kkc_segment_get_type ())
#define KKC_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT, KkcSegment))
#define KKC_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT, KkcSegmentClass))
#define KKC_IS_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT))
#define KKC_IS_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT))
#define KKC_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT, KkcSegmentClass))

typedef struct _KkcSegment KkcSegment;
typedef struct _KkcSegmentClass KkcSegmentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER (kkc_convert_segment_state_handler_get_type ())
#define KKC_CONVERT_SEGMENT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandler))
#define KKC_CONVERT_SEGMENT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandlerClass))
#define KKC_IS_CONVERT_SEGMENT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER))
#define KKC_IS_CONVERT_SEGMENT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER))
#define KKC_CONVERT_SEGMENT_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandlerClass))

typedef struct _KkcConvertSegmentStateHandler KkcConvertSegmentStateHandler;
typedef struct _KkcConvertSegmentStateHandlerClass KkcConvertSegmentStateHandlerClass;

#define KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER (kkc_convert_sentence_state_handler_get_type ())
#define KKC_CONVERT_SENTENCE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandler))
#define KKC_CONVERT_SENTENCE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandlerClass))
#define KKC_IS_CONVERT_SENTENCE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER))
#define KKC_IS_CONVERT_SENTENCE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER))
#define KKC_CONVERT_SENTENCE_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandlerClass))

typedef struct _KkcConvertSentenceStateHandler KkcConvertSentenceStateHandler;
typedef struct _KkcConvertSentenceStateHandlerClass KkcConvertSentenceStateHandlerClass;

#define KKC_TYPE_MODIFIER_TYPE (kkc_modifier_type_get_type ())

#define KKC_TYPE_ROM_KANA_CHARACTER (kkc_rom_kana_character_get_type ())
typedef struct _KkcRomKanaCharacter KkcRomKanaCharacter;

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

#define KKC_TYPE_INPUT_MODE (kkc_input_mode_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

#define KKC_TYPE_COMMAND_HANDLER (kkc_command_handler_get_type ())
#define KKC_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_COMMAND_HANDLER, KkcCommandHandler))
#define KKC_IS_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_COMMAND_HANDLER))
#define KKC_COMMAND_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_COMMAND_HANDLER, KkcCommandHandlerIface))

typedef struct _KkcCommandHandler KkcCommandHandler;
typedef struct _KkcCommandHandlerIface KkcCommandHandlerIface;

#define KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER (kkc_initial_state_handler_convert_command_handler_get_type ())
#define KKC_INITIAL_STATE_HANDLER_CONVERT_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER, KkcInitialStateHandlerConvertCommandHandler))
#define KKC_INITIAL_STATE_HANDLER_CONVERT_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER, KkcInitialStateHandlerConvertCommandHandlerClass))
#define KKC_INITIAL_STATE_HANDLER_IS_CONVERT_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER))
#define KKC_INITIAL_STATE_HANDLER_IS_CONVERT_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER))
#define KKC_INITIAL_STATE_HANDLER_CONVERT_COMMAND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER, KkcInitialStateHandlerConvertCommandHandlerClass))

typedef struct _KkcInitialStateHandlerConvertCommandHandler KkcInitialStateHandlerConvertCommandHandler;
typedef struct _KkcInitialStateHandlerConvertCommandHandlerClass KkcInitialStateHandlerConvertCommandHandlerClass;
typedef struct _KkcInitialStateHandlerConvertCommandHandlerPrivate KkcInitialStateHandlerConvertCommandHandlerPrivate;

struct _KkcStateHandler {
	GObject parent_instance;
	KkcStateHandlerPrivate * priv;
};

struct _KkcStateHandlerClass {
	GObjectClass parent_class;
	gboolean (*process_key_event) (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
};

struct _KkcInitialStateHandler {
	KkcStateHandler parent_instance;
	KkcInitialStateHandlerPrivate * priv;
};

struct _KkcInitialStateHandlerClass {
	KkcStateHandlerClass parent_class;
};

struct _KkcState {
	GObject parent_instance;
	KkcStatePrivate * priv;
	GType handler_type;
	KkcLanguageModel* model;
	KkcDecoder* decoder;
	KkcSegmentList* segments;
	KkcCandidateList* candidates;
	KkcDictionaryList* dictionaries;
	KkcRomKanaConverter* rom_kana_converter;
	KkcRomKanaCharacterList* input_characters;
	gint input_characters_cursor_pos;
	GString* selection;
	GString* output;
	gboolean quoted;
	KkcKeyEvent* this_command_key;
	KkcKeyEvent* last_command_key;
	gchar* overriding_input;
	GeeIterator* completion_iterator;
};

struct _KkcStateClass {
	GObjectClass parent_class;
};

typedef enum  {
	KKC_MODIFIER_TYPE_NONE = 0,
	KKC_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	KKC_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	KKC_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	KKC_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	KKC_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	KKC_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	KKC_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	KKC_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	KKC_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	KKC_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	KKC_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	KKC_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	KKC_MODIFIER_TYPE_META_MASK = 1 << 28,
	KKC_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} KkcModifierType;

struct _KkcRomKanaCharacter {
	gchar* output;
	gchar* input;
};

typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;

typedef enum  {
	KKC_INPUT_MODE_HIRAGANA = KKC_KANA_MODE_HIRAGANA,
	KKC_INPUT_MODE_KATAKANA = KKC_KANA_MODE_KATAKANA,
	KKC_INPUT_MODE_HANKAKU_KATAKANA = KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_INPUT_MODE_LATIN = KKC_KANA_MODE_LATIN,
	KKC_INPUT_MODE_WIDE_LATIN = KKC_KANA_MODE_WIDE_LATIN,
	KKC_INPUT_MODE_DIRECT
} KkcInputMode;

struct _KkcCommandHandlerIface {
	GTypeInterface parent_iface;
	gboolean (*call) (KkcCommandHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
};

typedef gboolean (*KkcCommandCallback) (const gchar* command, KkcState* state, KkcKeyEvent* key, void* user_data);
struct _KkcInitialStateHandlerConvertCommandHandler {
	GObject parent_instance;
	KkcInitialStateHandlerConvertCommandHandlerPrivate * priv;
};

struct _KkcInitialStateHandlerConvertCommandHandlerClass {
	GObjectClass parent_class;
};

struct _KkcInitialStateHandlerConvertCommandHandlerPrivate {
	KkcKanaMode mode;
};


static gpointer kkc_initial_state_handler_parent_class = NULL;
static gpointer kkc_initial_state_handler_convert_command_handler_parent_class = NULL;
static KkcCommandHandlerIface* kkc_initial_state_handler_convert_command_handler_kkc_command_handler_parent_iface = NULL;

GType kkc_state_handler_get_type (void) G_GNUC_CONST;
GType kkc_state_get_type (void) G_GNUC_CONST;
GType kkc_key_event_get_type (void) G_GNUC_CONST;
GType kkc_initial_state_handler_get_type (void) G_GNUC_CONST;
enum  {
	KKC_INITIAL_STATE_HANDLER_DUMMY_PROPERTY
};
static gboolean kkc_initial_state_handler_do_quote (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_decoder_get_type (void) G_GNUC_CONST;
GType kkc_segment_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_list_get_type (void) G_GNUC_CONST;
GType kkc_dictionary_list_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_character_list_get_type (void) G_GNUC_CONST;
static gboolean kkc_initial_state_handler_do_register (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_initial_state_handler_do_abort (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
gint kkc_rom_kana_character_list_get_size (KkcRomKanaCharacterList* self);
const gchar* kkc_rom_kana_converter_get_pending_output (KkcRomKanaConverter* self);
void kkc_state_reset (KkcState* self);
static gboolean kkc_initial_state_handler_do_delete (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
gboolean kkc_rom_kana_converter_delete (KkcRomKanaConverter* self);
void kkc_rom_kana_character_list_remove_at (KkcRomKanaCharacterList* self, gint index);
static gboolean kkc_initial_state_handler_do_delete_forward (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_initial_state_handler_do_complete (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
void kkc_state_finish_input_editing (KkcState* self);
void kkc_state_completion_start (KkcState* self, const gchar* input);
gchar* kkc_state_get_input (KkcState* self);
static gboolean kkc_initial_state_handler_do_next_candidate (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
GType kkc_segment_get_type (void) G_GNUC_CONST;
KkcSegment* kkc_segment_new (const gchar* input, const gchar* output);
KkcSegment* kkc_segment_construct (GType object_type, const gchar* input, const gchar* output);
void kkc_segment_list_set_segments (KkcSegmentList* self, KkcSegment* segment);
gboolean kkc_segment_list_first_segment (KkcSegmentList* self);
void kkc_state_lookup (KkcState* self, KkcSegment* segment);
KkcSegment* kkc_segment_list_get (KkcSegmentList* self, gint index);
gint kkc_segment_list_get_cursor_pos (KkcSegmentList* self);
gboolean kkc_candidate_list_first (KkcCandidateList* self);
GType kkc_convert_segment_state_handler_get_type (void) G_GNUC_CONST;
gint kkc_segment_list_get_size (KkcSegmentList* self);
gchar* kkc_rom_kana_utils_get_hiragana (const gchar* kana);
gchar* kkc_state_lookup_single (KkcState* self, const gchar* input);
void kkc_state_convert_sentence (KkcState* self, const gchar* input, gint* constraint, int constraint_length1);
GType kkc_convert_sentence_state_handler_get_type (void) G_GNUC_CONST;
static gboolean kkc_initial_state_handler_do_next_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_initial_state_handler_do_previous_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_initial_state_handler_do_first_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_initial_state_handler_do_last_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
static gboolean kkc_initial_state_handler_do_ (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
GType kkc_modifier_type_get_type (void) G_GNUC_CONST;
KkcModifierType kkc_key_event_get_modifiers (KkcKeyEvent* self);
gboolean kkc_rom_kana_converter_is_valid (KkcRomKanaConverter* self, gunichar uc);
gunichar kkc_key_event_get_unicode (KkcKeyEvent* self);
gboolean kkc_rom_kana_converter_append (KkcRomKanaConverter* self, gunichar uc);
KkcRomKanaCharacterList* kkc_rom_kana_converter_get_produced (KkcRomKanaConverter* self);
void kkc_rom_kana_character_list_insert_all (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacterList* other);
GType kkc_rom_kana_character_get_type (void) G_GNUC_CONST;
KkcRomKanaCharacter* kkc_rom_kana_character_dup (const KkcRomKanaCharacter* self);
void kkc_rom_kana_character_free (KkcRomKanaCharacter* self);
void kkc_rom_kana_character_copy (const KkcRomKanaCharacter* self, KkcRomKanaCharacter* dest);
void kkc_rom_kana_character_destroy (KkcRomKanaCharacter* self);
void kkc_rom_kana_character_list_get (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* result);
void kkc_rom_kana_character_list_add_all (KkcRomKanaCharacterList* self, KkcRomKanaCharacterList* other);
void kkc_rom_kana_character_list_clear (KkcRomKanaCharacterList* self);
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
gchar* kkc_rom_kana_utils_convert_by_kana_mode (const gchar* str, KkcKanaMode mode);
GType kkc_input_mode_get_type (void) G_GNUC_CONST;
KkcInputMode kkc_state_get_input_mode (KkcState* self);
void kkc_rom_kana_character_list_insert (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* character);
void kkc_rom_kana_character_list_add (KkcRomKanaCharacterList* self, KkcRomKanaCharacter* character);
static gboolean kkc_initial_state_handler_real_process_key_event (KkcStateHandler* base, KkcState* state, KkcKeyEvent* key);
gchar* kkc_state_lookup_key (KkcState* self, KkcKeyEvent* key);
gchar* kkc_rom_kana_character_list_get_input (KkcRomKanaCharacterList* self);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
void kkc_state_set_input_mode (KkcState* self, KkcInputMode value);
gboolean kkc_state_handler_dispatch_command (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
KkcInitialStateHandler* kkc_initial_state_handler_new (void);
KkcInitialStateHandler* kkc_initial_state_handler_construct (GType object_type);
KkcStateHandler* kkc_state_handler_construct (GType object_type);
static GObject * kkc_initial_state_handler_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GType kkc_command_handler_get_type (void) G_GNUC_CONST;
void kkc_state_handler_register_command_handler (KkcStateHandler* self, const gchar* command, KkcCommandHandler* handler);
static KkcInitialStateHandlerConvertCommandHandler* kkc_initial_state_handler_convert_command_handler_new (KkcKanaMode mode);
static KkcInitialStateHandlerConvertCommandHandler* kkc_initial_state_handler_convert_command_handler_construct (GType object_type, KkcKanaMode mode);
static GType kkc_initial_state_handler_convert_command_handler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
void kkc_state_handler_register_command_callback (KkcStateHandler* self, const gchar* command, KkcCommandCallback cb, void* cb_target);
static gboolean _kkc_initial_state_handler_do_abort_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_complete_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_delete_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_delete_forward_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_next_candidate_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_next_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_previous_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_first_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_last_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_quote_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do_register_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
static gboolean _kkc_initial_state_handler_do__kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self);
#define KKC_INITIAL_STATE_HANDLER_CONVERT_COMMAND_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER, KkcInitialStateHandlerConvertCommandHandlerPrivate))
enum  {
	KKC_INITIAL_STATE_HANDLER_CONVERT_COMMAND_HANDLER_DUMMY_PROPERTY
};
static gboolean kkc_initial_state_handler_convert_command_handler_real_call (KkcCommandHandler* base, const gchar* command, KkcState* state, KkcKeyEvent* key);
gchar* kkc_state_convert_rom_kana_characters_by_kana_mode (KkcState* self, KkcRomKanaCharacterList* characters, KkcKanaMode mode);
static void kkc_initial_state_handler_convert_command_handler_finalize (GObject* obj);


static gboolean kkc_initial_state_handler_do_quote (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp0_->quoted = TRUE;
	result = TRUE;
	return result;
}


static gboolean kkc_initial_state_handler_do_register (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	g_signal_emit_by_name (_tmp0_, "request-selection-text");
	result = TRUE;
	return result;
}


static gboolean kkc_initial_state_handler_do_abort (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	KkcState* _tmp4_ = NULL;
	KkcRomKanaCharacterList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = _tmp0_->overriding_input;
	if (_tmp1_ != NULL) {
		KkcState* _tmp2_ = NULL;
		_tmp2_ = state;
		_g_free0 (_tmp2_->overriding_input);
		_tmp2_->overriding_input = NULL;
		result = TRUE;
		return result;
	}
	_tmp4_ = state;
	_tmp5_ = _tmp4_->input_characters;
	_tmp6_ = kkc_rom_kana_character_list_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ > 0) {
		_tmp3_ = TRUE;
	} else {
		KkcState* _tmp8_ = NULL;
		KkcRomKanaConverter* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp8_ = state;
		_tmp9_ = _tmp8_->rom_kana_converter;
		_tmp10_ = kkc_rom_kana_converter_get_pending_output (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp3_ = _tmp13_ > 0;
	}
	_tmp14_ = _tmp3_;
	if (_tmp14_) {
		KkcState* _tmp15_ = NULL;
		_tmp15_ = state;
		kkc_state_reset (_tmp15_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_initial_state_handler_do_delete (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	KkcState* _tmp3_ = NULL;
	KkcRomKanaConverter* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	KkcState* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	KkcState* _tmp16_ = NULL;
	KkcRomKanaCharacterList* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = _tmp0_->overriding_input;
	if (_tmp1_ != NULL) {
		KkcState* _tmp2_ = NULL;
		_tmp2_ = state;
		_g_free0 (_tmp2_->overriding_input);
		_tmp2_->overriding_input = NULL;
		result = TRUE;
		return result;
	}
	_tmp3_ = state;
	_tmp4_ = _tmp3_->rom_kana_converter;
	_tmp5_ = kkc_rom_kana_converter_delete (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	_tmp6_ = state;
	_tmp7_ = _tmp6_->input_characters_cursor_pos;
	if (_tmp7_ >= 0) {
		KkcState* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp8_ = state;
		_tmp9_ = _tmp8_->input_characters_cursor_pos;
		if (_tmp9_ > 0) {
			KkcState* _tmp10_ = NULL;
			KkcRomKanaCharacterList* _tmp11_ = NULL;
			KkcState* _tmp12_ = NULL;
			KkcState* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			_tmp10_ = state;
			_tmp11_ = _tmp10_->input_characters;
			_tmp12_ = state;
			_tmp13_ = state;
			_tmp14_ = _tmp13_->input_characters_cursor_pos;
			_tmp13_->input_characters_cursor_pos = _tmp14_ - 1;
			_tmp15_ = _tmp13_->input_characters_cursor_pos;
			kkc_rom_kana_character_list_remove_at (_tmp11_, _tmp15_);
		}
		result = TRUE;
		return result;
	}
	_tmp16_ = state;
	_tmp17_ = _tmp16_->input_characters;
	_tmp18_ = kkc_rom_kana_character_list_get_size (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		KkcState* _tmp20_ = NULL;
		KkcRomKanaCharacterList* _tmp21_ = NULL;
		KkcState* _tmp22_ = NULL;
		KkcRomKanaCharacterList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		_tmp20_ = state;
		_tmp21_ = _tmp20_->input_characters;
		_tmp22_ = state;
		_tmp23_ = _tmp22_->input_characters;
		_tmp24_ = kkc_rom_kana_character_list_get_size (_tmp23_);
		_tmp25_ = _tmp24_;
		kkc_rom_kana_character_list_remove_at (_tmp21_, _tmp25_ - 1);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_initial_state_handler_do_delete_forward (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	KkcState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp9_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters_cursor_pos;
	if (_tmp2_ >= 0) {
		KkcState* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		KkcState* _tmp5_ = NULL;
		KkcRomKanaCharacterList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp3_ = state;
		_tmp4_ = _tmp3_->input_characters_cursor_pos;
		_tmp5_ = state;
		_tmp6_ = _tmp5_->input_characters;
		_tmp7_ = kkc_rom_kana_character_list_get_size (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp4_ < _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		KkcState* _tmp10_ = NULL;
		KkcRomKanaCharacterList* _tmp11_ = NULL;
		KkcState* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		KkcState* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		KkcState* _tmp16_ = NULL;
		KkcRomKanaCharacterList* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp10_ = state;
		_tmp11_ = _tmp10_->input_characters;
		_tmp12_ = state;
		_tmp13_ = _tmp12_->input_characters_cursor_pos;
		kkc_rom_kana_character_list_remove_at (_tmp11_, _tmp13_);
		_tmp14_ = state;
		_tmp15_ = _tmp14_->input_characters_cursor_pos;
		_tmp16_ = state;
		_tmp17_ = _tmp16_->input_characters;
		_tmp18_ = kkc_rom_kana_character_list_get_size (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp15_ == _tmp19_) {
			KkcState* _tmp20_ = NULL;
			_tmp20_ = state;
			_tmp20_->input_characters_cursor_pos = -1;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_initial_state_handler_do_complete (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		KkcState* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		KkcState* _tmp11_ = NULL;
		GeeIterator* _tmp12_ = NULL;
		_tmp5_ = state;
		_tmp6_ = _tmp5_->completion_iterator;
		if (_tmp6_ == NULL) {
			KkcState* _tmp7_ = NULL;
			KkcState* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp7_ = state;
			_tmp8_ = state;
			_tmp9_ = kkc_state_get_input (_tmp8_);
			_tmp10_ = _tmp9_;
			kkc_state_completion_start (_tmp7_, _tmp10_);
			_g_free0 (_tmp10_);
		}
		_tmp11_ = state;
		_tmp12_ = _tmp11_->completion_iterator;
		if (_tmp12_ != NULL) {
			KkcState* _tmp13_ = NULL;
			KkcState* _tmp14_ = NULL;
			GeeIterator* _tmp15_ = NULL;
			gpointer _tmp16_ = NULL;
			KkcState* _tmp17_ = NULL;
			GeeIterator* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			_tmp13_ = state;
			_tmp14_ = state;
			_tmp15_ = _tmp14_->completion_iterator;
			_tmp16_ = gee_iterator_get (_tmp15_);
			_g_free0 (_tmp13_->overriding_input);
			_tmp13_->overriding_input = (gchar*) _tmp16_;
			_tmp17_ = state;
			_tmp18_ = _tmp17_->completion_iterator;
			_tmp19_ = gee_iterator_has_next (_tmp18_);
			if (_tmp19_) {
				KkcState* _tmp20_ = NULL;
				GeeIterator* _tmp21_ = NULL;
				_tmp20_ = state;
				_tmp21_ = _tmp20_->completion_iterator;
				gee_iterator_next (_tmp21_);
			}
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean kkc_initial_state_handler_do_next_candidate (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	KkcState* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	gssize _tmp7_ = 0L;
	KkcState* _tmp34_ = NULL;
	KkcSegmentList* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = state;
	_tmp6_ = _tmp5_->selection;
	_tmp7_ = _tmp6_->len;
	if (_tmp7_ > ((gssize) 0)) {
		gchar* input = NULL;
		KkcState* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		KkcSegment* segment = NULL;
		const gchar* _tmp10_ = NULL;
		KkcState* _tmp11_ = NULL;
		GString* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		KkcSegment* _tmp14_ = NULL;
		KkcState* _tmp15_ = NULL;
		GString* _tmp16_ = NULL;
		KkcState* _tmp17_ = NULL;
		KkcSegmentList* _tmp18_ = NULL;
		KkcSegment* _tmp19_ = NULL;
		KkcState* _tmp20_ = NULL;
		KkcSegmentList* _tmp21_ = NULL;
		KkcState* _tmp22_ = NULL;
		KkcState* _tmp23_ = NULL;
		KkcSegmentList* _tmp24_ = NULL;
		KkcState* _tmp25_ = NULL;
		KkcSegmentList* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		KkcSegment* _tmp29_ = NULL;
		KkcSegment* _tmp30_ = NULL;
		KkcState* _tmp31_ = NULL;
		KkcCandidateList* _tmp32_ = NULL;
		KkcState* _tmp33_ = NULL;
		_tmp8_ = state;
		_tmp9_ = kkc_state_get_input (_tmp8_);
		input = _tmp9_;
		_tmp10_ = input;
		_tmp11_ = state;
		_tmp12_ = _tmp11_->selection;
		_tmp13_ = _tmp12_->str;
		_tmp14_ = kkc_segment_new (_tmp10_, _tmp13_);
		segment = _tmp14_;
		_tmp15_ = state;
		_tmp16_ = _tmp15_->selection;
		g_string_erase (_tmp16_, (gssize) 0, (gssize) (-1));
		_tmp17_ = state;
		_tmp18_ = _tmp17_->segments;
		_tmp19_ = segment;
		kkc_segment_list_set_segments (_tmp18_, _tmp19_);
		_tmp20_ = state;
		_tmp21_ = _tmp20_->segments;
		kkc_segment_list_first_segment (_tmp21_);
		_tmp22_ = state;
		_tmp23_ = state;
		_tmp24_ = _tmp23_->segments;
		_tmp25_ = state;
		_tmp26_ = _tmp25_->segments;
		_tmp27_ = kkc_segment_list_get_cursor_pos (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = kkc_segment_list_get (_tmp24_, _tmp28_);
		_tmp30_ = _tmp29_;
		kkc_state_lookup (_tmp22_, _tmp30_);
		_g_object_unref0 (_tmp30_);
		_tmp31_ = state;
		_tmp32_ = _tmp31_->candidates;
		kkc_candidate_list_first (_tmp32_);
		_tmp33_ = state;
		_tmp33_->handler_type = KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER;
		result = TRUE;
		_g_object_unref0 (segment);
		_g_free0 (input);
		return result;
	}
	_tmp34_ = state;
	_tmp35_ = _tmp34_->segments;
	_tmp36_ = kkc_segment_list_get_size (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == 0) {
		KkcState* _tmp38_ = NULL;
		gchar* input = NULL;
		KkcState* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* output = NULL;
		KkcState* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		KkcState* _tmp56_ = NULL;
		KkcSegmentList* _tmp57_ = NULL;
		KkcState* _tmp58_ = NULL;
		_tmp38_ = state;
		kkc_state_finish_input_editing (_tmp38_);
		_tmp39_ = state;
		_tmp40_ = kkc_state_get_input (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = kkc_rom_kana_utils_get_hiragana (_tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		input = _tmp43_;
		_tmp44_ = state;
		_tmp45_ = input;
		_tmp46_ = kkc_state_lookup_single (_tmp44_, _tmp45_);
		output = _tmp46_;
		_tmp47_ = output;
		if (_tmp47_ != NULL) {
			KkcSegment* segment = NULL;
			const gchar* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			KkcSegment* _tmp50_ = NULL;
			KkcState* _tmp51_ = NULL;
			KkcSegmentList* _tmp52_ = NULL;
			KkcSegment* _tmp53_ = NULL;
			_tmp48_ = input;
			_tmp49_ = output;
			_tmp50_ = kkc_segment_new (_tmp48_, _tmp49_);
			segment = _tmp50_;
			_tmp51_ = state;
			_tmp52_ = _tmp51_->segments;
			_tmp53_ = segment;
			kkc_segment_list_set_segments (_tmp52_, _tmp53_);
			_g_object_unref0 (segment);
		} else {
			KkcState* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			_tmp54_ = state;
			_tmp55_ = input;
			kkc_state_convert_sentence (_tmp54_, _tmp55_, NULL, 0);
		}
		_tmp56_ = state;
		_tmp57_ = _tmp56_->segments;
		kkc_segment_list_first_segment (_tmp57_);
		_tmp58_ = state;
		_tmp58_->handler_type = KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER;
		result = TRUE;
		_g_free0 (output);
		_g_free0 (input);
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean kkc_initial_state_handler_do_next_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	KkcState* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	KkcState* _tmp7_ = NULL;
	KkcRomKanaCharacterList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = state;
	_tmp6_ = _tmp5_->input_characters_cursor_pos;
	_tmp7_ = state;
	_tmp8_ = _tmp7_->input_characters;
	_tmp9_ = kkc_rom_kana_character_list_get_size (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp6_ == (_tmp10_ - 1)) {
		KkcState* _tmp11_ = NULL;
		_tmp11_ = state;
		_tmp11_->input_characters_cursor_pos = -1;
	} else {
		gboolean _tmp12_ = FALSE;
		KkcState* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gboolean _tmp21_ = FALSE;
		_tmp13_ = state;
		_tmp14_ = _tmp13_->input_characters_cursor_pos;
		if (_tmp14_ >= 0) {
			KkcState* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			KkcState* _tmp17_ = NULL;
			KkcRomKanaCharacterList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			_tmp15_ = state;
			_tmp16_ = _tmp15_->input_characters_cursor_pos;
			_tmp17_ = state;
			_tmp18_ = _tmp17_->input_characters;
			_tmp19_ = kkc_rom_kana_character_list_get_size (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp12_ = _tmp16_ < (_tmp20_ - 1);
		} else {
			_tmp12_ = FALSE;
		}
		_tmp21_ = _tmp12_;
		if (_tmp21_) {
			KkcState* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			_tmp22_ = state;
			_tmp23_ = _tmp22_->input_characters_cursor_pos;
			_tmp22_->input_characters_cursor_pos = _tmp23_ + 1;
		}
	}
	result = TRUE;
	return result;
}


static gboolean kkc_initial_state_handler_do_previous_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	KkcState* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	KkcState* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = state;
	_tmp6_ = _tmp5_->input_characters_cursor_pos;
	if (_tmp6_ < 0) {
		KkcState* _tmp7_ = NULL;
		KkcState* _tmp8_ = NULL;
		KkcState* _tmp9_ = NULL;
		KkcRomKanaCharacterList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp7_ = state;
		kkc_state_finish_input_editing (_tmp7_);
		_tmp8_ = state;
		_tmp9_ = state;
		_tmp10_ = _tmp9_->input_characters;
		_tmp11_ = kkc_rom_kana_character_list_get_size (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_->input_characters_cursor_pos = _tmp12_ - 1;
		result = TRUE;
		return result;
	}
	_tmp13_ = state;
	_tmp14_ = _tmp13_->input_characters_cursor_pos;
	if (_tmp14_ > 0) {
		KkcState* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp15_ = state;
		_tmp16_ = _tmp15_->input_characters_cursor_pos;
		_tmp15_->input_characters_cursor_pos = _tmp16_ - 1;
	}
	result = TRUE;
	return result;
}


static gboolean kkc_initial_state_handler_do_first_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	KkcState* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = state;
	_tmp5_->input_characters_cursor_pos = 0;
	result = TRUE;
	return result;
}


static gboolean kkc_initial_state_handler_do_last_character (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	KkcState* _tmp5_ = NULL;
	KkcState* _tmp6_ = NULL;
	KkcRomKanaCharacterList* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = state;
	_tmp6_ = state;
	_tmp7_ = _tmp6_->input_characters;
	_tmp8_ = kkc_rom_kana_character_list_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp5_->input_characters_cursor_pos = _tmp9_ - 1;
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean kkc_initial_state_handler_do_ (KkcInitialStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	gboolean result = FALSE;
	gboolean retval = FALSE;
	KkcState* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp9_ = FALSE;
	KkcKeyEvent* _tmp10_ = NULL;
	KkcModifierType _tmp11_ = 0;
	KkcModifierType _tmp12_ = 0;
	gboolean _tmp16_ = FALSE;
	gchar* last_input = NULL;
	KkcState* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	KkcState* _tmp116_ = NULL;
	gchar* input = NULL;
	KkcState* _tmp117_ = NULL;
	gchar* _tmp118_ = NULL;
	KkcState* _tmp119_ = NULL;
	GString* _tmp120_ = NULL;
	const gchar* _tmp121_ = NULL;
	KkcState* _tmp122_ = NULL;
	gboolean _tmp123_ = FALSE;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_ = FALSE;
	gboolean _tmp129_ = FALSE;
	gboolean _tmp132_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	retval = FALSE;
	_tmp0_ = state;
	_tmp1_ = _tmp0_->overriding_input;
	if (_tmp1_ != NULL) {
		KkcState* _tmp2_ = NULL;
		GString* _tmp3_ = NULL;
		KkcState* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		KkcState* _tmp7_ = NULL;
		KkcState* _tmp8_ = NULL;
		_tmp2_ = state;
		_tmp3_ = _tmp2_->output;
		_tmp4_ = state;
		_tmp5_ = kkc_state_get_input (_tmp4_);
		_tmp6_ = _tmp5_;
		g_string_append (_tmp3_, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = state;
		_g_free0 (_tmp7_->overriding_input);
		_tmp7_->overriding_input = NULL;
		_tmp8_ = state;
		kkc_state_reset (_tmp8_);
		retval = TRUE;
	}
	_tmp10_ = key;
	_tmp11_ = kkc_key_event_get_modifiers (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		_tmp9_ = TRUE;
	} else {
		KkcKeyEvent* _tmp13_ = NULL;
		KkcModifierType _tmp14_ = 0;
		KkcModifierType _tmp15_ = 0;
		_tmp13_ = key;
		_tmp14_ = kkc_key_event_get_modifiers (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp9_ = _tmp15_ == KKC_MODIFIER_TYPE_SHIFT_MASK;
	}
	_tmp16_ = _tmp9_;
	if (_tmp16_) {
		KkcState* _tmp17_ = NULL;
		KkcRomKanaConverter* _tmp18_ = NULL;
		KkcKeyEvent* _tmp19_ = NULL;
		gunichar _tmp20_ = 0U;
		gunichar _tmp21_ = 0U;
		gboolean _tmp22_ = FALSE;
		_tmp17_ = state;
		_tmp18_ = _tmp17_->rom_kana_converter;
		_tmp19_ = key;
		_tmp20_ = kkc_key_event_get_unicode (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = kkc_rom_kana_converter_is_valid (_tmp18_, _tmp21_);
		if (_tmp22_) {
			KkcState* _tmp23_ = NULL;
			KkcRomKanaConverter* _tmp24_ = NULL;
			KkcKeyEvent* _tmp25_ = NULL;
			gunichar _tmp26_ = 0U;
			gunichar _tmp27_ = 0U;
			KkcState* _tmp28_ = NULL;
			KkcRomKanaConverter* _tmp29_ = NULL;
			KkcRomKanaCharacterList* _tmp30_ = NULL;
			KkcRomKanaCharacterList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			_tmp23_ = state;
			_tmp24_ = _tmp23_->rom_kana_converter;
			_tmp25_ = key;
			_tmp26_ = kkc_key_event_get_unicode (_tmp25_);
			_tmp27_ = _tmp26_;
			kkc_rom_kana_converter_append (_tmp24_, _tmp27_);
			_tmp28_ = state;
			_tmp29_ = _tmp28_->rom_kana_converter;
			_tmp30_ = kkc_rom_kana_converter_get_produced (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = kkc_rom_kana_character_list_get_size (_tmp31_);
			_tmp33_ = _tmp32_;
			if (_tmp33_ > 0) {
				KkcState* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				KkcState* _tmp70_ = NULL;
				KkcRomKanaConverter* _tmp71_ = NULL;
				KkcRomKanaCharacterList* _tmp72_ = NULL;
				KkcRomKanaCharacterList* _tmp73_ = NULL;
				_tmp34_ = state;
				_tmp35_ = _tmp34_->input_characters_cursor_pos;
				if (_tmp35_ >= 0) {
					KkcState* _tmp36_ = NULL;
					KkcRomKanaCharacterList* _tmp37_ = NULL;
					KkcState* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					KkcState* _tmp40_ = NULL;
					KkcRomKanaConverter* _tmp41_ = NULL;
					KkcRomKanaCharacterList* _tmp42_ = NULL;
					KkcRomKanaCharacterList* _tmp43_ = NULL;
					_tmp36_ = state;
					_tmp37_ = _tmp36_->input_characters;
					_tmp38_ = state;
					_tmp39_ = _tmp38_->input_characters_cursor_pos;
					_tmp40_ = state;
					_tmp41_ = _tmp40_->rom_kana_converter;
					_tmp42_ = kkc_rom_kana_converter_get_produced (_tmp41_);
					_tmp43_ = _tmp42_;
					kkc_rom_kana_character_list_insert_all (_tmp37_, _tmp39_, _tmp43_);
					{
						KkcRomKanaCharacterList* _c_list = NULL;
						KkcState* _tmp44_ = NULL;
						KkcRomKanaConverter* _tmp45_ = NULL;
						KkcRomKanaCharacterList* _tmp46_ = NULL;
						KkcRomKanaCharacterList* _tmp47_ = NULL;
						KkcRomKanaCharacterList* _tmp48_ = NULL;
						gint _c_size = 0;
						KkcRomKanaCharacterList* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
						gint _c_index = 0;
						_tmp44_ = state;
						_tmp45_ = _tmp44_->rom_kana_converter;
						_tmp46_ = kkc_rom_kana_converter_get_produced (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = _g_object_ref0 (_tmp47_);
						_c_list = _tmp48_;
						_tmp49_ = _c_list;
						_tmp50_ = kkc_rom_kana_character_list_get_size (_tmp49_);
						_tmp51_ = _tmp50_;
						_c_size = _tmp51_;
						_c_index = -1;
						while (TRUE) {
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							KkcRomKanaCharacter c = {0};
							KkcRomKanaCharacterList* _tmp55_ = NULL;
							gint _tmp56_ = 0;
							KkcRomKanaCharacter _tmp57_ = {0};
							KkcState* _tmp58_ = NULL;
							KkcState* _tmp59_ = NULL;
							gint _tmp60_ = 0;
							KkcRomKanaCharacter _tmp61_ = {0};
							const gchar* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							_tmp52_ = _c_index;
							_c_index = _tmp52_ + 1;
							_tmp53_ = _c_index;
							_tmp54_ = _c_size;
							if (!(_tmp53_ < _tmp54_)) {
								break;
							}
							_tmp55_ = _c_list;
							_tmp56_ = _c_index;
							kkc_rom_kana_character_list_get (_tmp55_, _tmp56_, &_tmp57_);
							c = _tmp57_;
							_tmp58_ = state;
							_tmp59_ = state;
							_tmp60_ = _tmp59_->input_characters_cursor_pos;
							_tmp61_ = c;
							_tmp62_ = _tmp61_.output;
							_tmp63_ = g_utf8_strlen (_tmp62_, (gssize) (-1));
							_tmp59_->input_characters_cursor_pos = _tmp60_ + _tmp63_;
							kkc_rom_kana_character_destroy (&c);
						}
						_g_object_unref0 (_c_list);
					}
				} else {
					KkcState* _tmp64_ = NULL;
					KkcRomKanaCharacterList* _tmp65_ = NULL;
					KkcState* _tmp66_ = NULL;
					KkcRomKanaConverter* _tmp67_ = NULL;
					KkcRomKanaCharacterList* _tmp68_ = NULL;
					KkcRomKanaCharacterList* _tmp69_ = NULL;
					_tmp64_ = state;
					_tmp65_ = _tmp64_->input_characters;
					_tmp66_ = state;
					_tmp67_ = _tmp66_->rom_kana_converter;
					_tmp68_ = kkc_rom_kana_converter_get_produced (_tmp67_);
					_tmp69_ = _tmp68_;
					kkc_rom_kana_character_list_add_all (_tmp65_, _tmp69_);
				}
				_tmp70_ = state;
				_tmp71_ = _tmp70_->rom_kana_converter;
				_tmp72_ = kkc_rom_kana_converter_get_produced (_tmp71_);
				_tmp73_ = _tmp72_;
				kkc_rom_kana_character_list_clear (_tmp73_);
			}
			result = TRUE;
			return result;
		} else {
			gboolean _tmp74_ = FALSE;
			KkcKeyEvent* _tmp75_ = NULL;
			gunichar _tmp76_ = 0U;
			gunichar _tmp77_ = 0U;
			gboolean _tmp81_ = FALSE;
			_tmp75_ = key;
			_tmp76_ = kkc_key_event_get_unicode (_tmp75_);
			_tmp77_ = _tmp76_;
			if (((gunichar) 0x21) <= _tmp77_) {
				KkcKeyEvent* _tmp78_ = NULL;
				gunichar _tmp79_ = 0U;
				gunichar _tmp80_ = 0U;
				_tmp78_ = key;
				_tmp79_ = kkc_key_event_get_unicode (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp74_ = _tmp80_ <= ((gunichar) 0x7E);
			} else {
				_tmp74_ = FALSE;
			}
			_tmp81_ = _tmp74_;
			if (_tmp81_) {
				KkcState* _tmp82_ = NULL;
				KkcRomKanaCharacter c = {0};
				KkcKeyEvent* _tmp83_ = NULL;
				gunichar _tmp84_ = 0U;
				gunichar _tmp85_ = 0U;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_ = NULL;
				KkcState* _tmp88_ = NULL;
				KkcInputMode _tmp89_ = 0;
				KkcInputMode _tmp90_ = 0;
				gchar* _tmp91_ = NULL;
				KkcKeyEvent* _tmp92_ = NULL;
				gunichar _tmp93_ = 0U;
				gunichar _tmp94_ = 0U;
				gchar* _tmp95_ = NULL;
				KkcRomKanaCharacter _tmp96_ = {0};
				KkcRomKanaCharacter _tmp97_ = {0};
				KkcState* _tmp98_ = NULL;
				gint _tmp99_ = 0;
				KkcState* _tmp110_ = NULL;
				KkcRomKanaConverter* _tmp111_ = NULL;
				KkcRomKanaCharacterList* _tmp112_ = NULL;
				KkcRomKanaCharacterList* _tmp113_ = NULL;
				_tmp82_ = state;
				kkc_state_finish_input_editing (_tmp82_);
				_tmp83_ = key;
				_tmp84_ = kkc_key_event_get_unicode (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = g_unichar_to_string (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = state;
				_tmp89_ = kkc_state_get_input_mode (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp87_, (KkcKanaMode) _tmp90_);
				_tmp92_ = key;
				_tmp93_ = kkc_key_event_get_unicode (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_unichar_to_string (_tmp94_);
				memset (&_tmp96_, 0, sizeof (KkcRomKanaCharacter));
				_g_free0 (_tmp96_.output);
				_tmp96_.output = _tmp91_;
				_g_free0 (_tmp96_.input);
				_tmp96_.input = _tmp95_;
				_tmp97_ = _tmp96_;
				_g_free0 (_tmp87_);
				c = _tmp97_;
				_tmp98_ = state;
				_tmp99_ = _tmp98_->input_characters_cursor_pos;
				if (_tmp99_ >= 0) {
					KkcState* _tmp100_ = NULL;
					KkcRomKanaCharacterList* _tmp101_ = NULL;
					KkcState* _tmp102_ = NULL;
					gint _tmp103_ = 0;
					KkcRomKanaCharacter _tmp104_ = {0};
					KkcState* _tmp105_ = NULL;
					gint _tmp106_ = 0;
					_tmp100_ = state;
					_tmp101_ = _tmp100_->input_characters;
					_tmp102_ = state;
					_tmp103_ = _tmp102_->input_characters_cursor_pos;
					_tmp104_ = c;
					kkc_rom_kana_character_list_insert (_tmp101_, _tmp103_, &_tmp104_);
					_tmp105_ = state;
					_tmp106_ = _tmp105_->input_characters_cursor_pos;
					_tmp105_->input_characters_cursor_pos = _tmp106_ + 1;
				} else {
					KkcState* _tmp107_ = NULL;
					KkcRomKanaCharacterList* _tmp108_ = NULL;
					KkcRomKanaCharacter _tmp109_ = {0};
					_tmp107_ = state;
					_tmp108_ = _tmp107_->input_characters;
					_tmp109_ = c;
					kkc_rom_kana_character_list_add (_tmp108_, &_tmp109_);
				}
				_tmp110_ = state;
				_tmp111_ = _tmp110_->rom_kana_converter;
				_tmp112_ = kkc_rom_kana_converter_get_produced (_tmp111_);
				_tmp113_ = _tmp112_;
				kkc_rom_kana_character_list_clear (_tmp113_);
				result = TRUE;
				kkc_rom_kana_character_destroy (&c);
				return result;
			}
		}
	}
	_tmp114_ = state;
	_tmp115_ = kkc_state_get_input (_tmp114_);
	last_input = _tmp115_;
	_tmp116_ = state;
	kkc_state_finish_input_editing (_tmp116_);
	_tmp117_ = state;
	_tmp118_ = kkc_state_get_input (_tmp117_);
	input = _tmp118_;
	_tmp119_ = state;
	_tmp120_ = _tmp119_->output;
	_tmp121_ = input;
	g_string_append (_tmp120_, _tmp121_);
	_tmp122_ = state;
	kkc_state_reset (_tmp122_);
	_tmp125_ = retval;
	if (_tmp125_) {
		_tmp124_ = TRUE;
	} else {
		const gchar* _tmp126_ = NULL;
		gint _tmp127_ = 0;
		gint _tmp128_ = 0;
		_tmp126_ = input;
		_tmp127_ = strlen (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp124_ = _tmp128_ > 0;
	}
	_tmp129_ = _tmp124_;
	if (_tmp129_) {
		_tmp123_ = TRUE;
	} else {
		const gchar* _tmp130_ = NULL;
		const gchar* _tmp131_ = NULL;
		_tmp130_ = last_input;
		_tmp131_ = input;
		_tmp123_ = g_strcmp0 (_tmp130_, _tmp131_) != 0;
	}
	_tmp132_ = _tmp123_;
	result = _tmp132_;
	_g_free0 (input);
	_g_free0 (last_input);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static GEnumValue* _g_enum_value_dup (GEnumValue* self) {
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}


static gpointer __g_enum_value_dup0 (gpointer self) {
	return self ? _g_enum_value_dup (self) : NULL;
}


static gboolean kkc_initial_state_handler_real_process_key_event (KkcStateHandler* base, KkcState* state, KkcKeyEvent* key) {
	KkcInitialStateHandler * self;
	gboolean result = FALSE;
	gchar* command = NULL;
	KkcState* _tmp0_ = NULL;
	KkcKeyEvent* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	KkcState* _tmp3_ = NULL;
	KkcKeyEvent* _tmp4_ = NULL;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_ = NULL;
	gboolean _tmp39_ = FALSE;
	KkcState* _tmp69_ = NULL;
	KkcInputMode _tmp70_ = 0;
	KkcInputMode _tmp71_ = 0;
	gboolean _tmp72_ = FALSE;
	KkcState* _tmp73_ = NULL;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp83_ = FALSE;
	KkcState* _tmp98_ = NULL;
	KkcKeyEvent* _tmp99_ = NULL;
	gboolean _tmp100_ = FALSE;
	self = (KkcInitialStateHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	_tmp1_ = key;
	_tmp2_ = kkc_state_lookup_key (_tmp0_, _tmp1_);
	command = _tmp2_;
	_tmp3_ = state;
	_tmp4_ = _tmp3_->last_command_key;
	if (_tmp4_ != NULL) {
		gchar* last_command = NULL;
		KkcState* _tmp5_ = NULL;
		KkcState* _tmp6_ = NULL;
		KkcKeyEvent* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp5_ = state;
		_tmp6_ = state;
		_tmp7_ = _tmp6_->last_command_key;
		_tmp8_ = kkc_state_lookup_key (_tmp5_, _tmp7_);
		last_command = _tmp8_;
		_tmp10_ = last_command;
		if (g_strcmp0 (_tmp10_, "complete") == 0) {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = command;
			_tmp9_ = g_strcmp0 (_tmp11_, "complete") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp12_ = _tmp9_;
		if (_tmp12_) {
			KkcState* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			KkcState* _tmp33_ = NULL;
			KkcState* _tmp34_ = NULL;
			_tmp13_ = state;
			_tmp14_ = _tmp13_->overriding_input;
			if (_tmp14_ != NULL) {
				GString* builder = NULL;
				GString* _tmp15_ = NULL;
				GString* _tmp16_ = NULL;
				KkcState* _tmp17_ = NULL;
				KkcRomKanaCharacterList* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				KkcState* _tmp21_ = NULL;
				KkcRomKanaCharacterList* _tmp22_ = NULL;
				KkcState* _tmp23_ = NULL;
				KkcRomKanaCharacterList* _tmp24_ = NULL;
				KkcState* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				GString* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				KkcRomKanaCharacter _tmp31_ = {0};
				KkcRomKanaCharacter _tmp32_ = {0};
				_tmp15_ = g_string_new ("");
				builder = _tmp15_;
				_tmp16_ = builder;
				_tmp17_ = state;
				_tmp18_ = _tmp17_->input_characters;
				_tmp19_ = kkc_rom_kana_character_list_get_input (_tmp18_);
				_tmp20_ = _tmp19_;
				g_string_append (_tmp16_, _tmp20_);
				_g_free0 (_tmp20_);
				_tmp21_ = state;
				_tmp22_ = _tmp21_->input_characters;
				kkc_rom_kana_character_list_clear (_tmp22_);
				_tmp23_ = state;
				_tmp24_ = _tmp23_->input_characters;
				_tmp25_ = state;
				_tmp26_ = _tmp25_->overriding_input;
				_tmp27_ = g_strdup (_tmp26_);
				_tmp28_ = builder;
				_tmp29_ = _tmp28_->str;
				_tmp30_ = g_strdup (_tmp29_);
				memset (&_tmp31_, 0, sizeof (KkcRomKanaCharacter));
				_g_free0 (_tmp31_.output);
				_tmp31_.output = _tmp27_;
				_g_free0 (_tmp31_.input);
				_tmp31_.input = _tmp30_;
				_tmp32_ = _tmp31_;
				kkc_rom_kana_character_list_add (_tmp24_, &_tmp32_);
				kkc_rom_kana_character_destroy (&_tmp32_);
				_g_string_free0 (builder);
			}
			_tmp33_ = state;
			_g_free0 (_tmp33_->overriding_input);
			_tmp33_->overriding_input = NULL;
			_tmp34_ = state;
			_g_object_unref0 (_tmp34_->completion_iterator);
			_tmp34_->completion_iterator = NULL;
		}
		_g_free0 (last_command);
	}
	_tmp36_ = command;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_ = NULL;
		gboolean _tmp38_ = FALSE;
		_tmp37_ = command;
		_tmp38_ = g_str_has_prefix (_tmp37_, "set-input-mode-");
		_tmp35_ = _tmp38_;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp39_ = _tmp35_;
	if (_tmp39_) {
		GEnumClass* enum_class = NULL;
		GTypeClass* _tmp40_ = NULL;
		GEnumValue* enum_value = NULL;
		GEnumClass* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		const gchar* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		GEnumValue* _tmp50_ = NULL;
		GEnumValue* _tmp51_ = NULL;
		GEnumValue* _tmp52_ = NULL;
		GEnumValue* _tmp53_ = NULL;
		_tmp40_ = g_type_class_ref (KKC_TYPE_INPUT_MODE);
		enum_class = (GEnumClass*) _tmp40_;
		_tmp41_ = enum_class;
		_tmp42_ = command;
		_tmp43_ = strlen ("set-input-mode-");
		_tmp44_ = _tmp43_;
		_tmp45_ = command;
		_tmp46_ = strlen (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = string_slice (_tmp42_, (glong) _tmp44_, (glong) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_enum_get_value_by_nick (_tmp41_, _tmp49_);
		_tmp51_ = __g_enum_value_dup0 (_tmp50_);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp49_);
		enum_value = _tmp52_;
		_tmp53_ = enum_value;
		if (_tmp53_ != NULL) {
			KkcState* _tmp54_ = NULL;
			GString* _tmp55_ = NULL;
			KkcState* _tmp56_ = NULL;
			KkcState* _tmp57_ = NULL;
			GEnumValue* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			KkcState* _tmp60_ = NULL;
			KkcInputMode _tmp61_ = 0;
			KkcInputMode _tmp62_ = 0;
			_tmp54_ = state;
			_tmp55_ = _tmp54_->selection;
			g_string_erase (_tmp55_, (gssize) 0, (gssize) (-1));
			_tmp56_ = state;
			kkc_state_finish_input_editing (_tmp56_);
			_tmp57_ = state;
			_tmp58_ = enum_value;
			_tmp59_ = (*_tmp58_).value;
			kkc_state_set_input_mode (_tmp57_, (KkcInputMode) _tmp59_);
			_tmp60_ = state;
			_tmp61_ = kkc_state_get_input_mode (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_ == KKC_INPUT_MODE_DIRECT) {
				gchar* input = NULL;
				KkcState* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				KkcState* _tmp65_ = NULL;
				GString* _tmp66_ = NULL;
				const gchar* _tmp67_ = NULL;
				KkcState* _tmp68_ = NULL;
				_tmp63_ = state;
				_tmp64_ = kkc_state_get_input (_tmp63_);
				input = _tmp64_;
				_tmp65_ = state;
				_tmp66_ = _tmp65_->output;
				_tmp67_ = input;
				g_string_append (_tmp66_, _tmp67_);
				_tmp68_ = state;
				kkc_state_reset (_tmp68_);
				_g_free0 (input);
			}
			result = TRUE;
			_g_free0 (enum_value);
			_g_type_class_unref0 (enum_class);
			_g_free0 (command);
			return result;
		}
		_g_free0 (enum_value);
		_g_type_class_unref0 (enum_class);
	}
	_tmp69_ = state;
	_tmp70_ = kkc_state_get_input_mode (_tmp69_);
	_tmp71_ = _tmp70_;
	if (_tmp71_ == KKC_INPUT_MODE_DIRECT) {
		result = FALSE;
		_g_free0 (command);
		return result;
	}
	_tmp73_ = state;
	_tmp74_ = _tmp73_->quoted;
	if (_tmp74_) {
		gboolean _tmp75_ = FALSE;
		KkcKeyEvent* _tmp76_ = NULL;
		KkcModifierType _tmp77_ = 0;
		KkcModifierType _tmp78_ = 0;
		gboolean _tmp82_ = FALSE;
		_tmp76_ = key;
		_tmp77_ = kkc_key_event_get_modifiers (_tmp76_);
		_tmp78_ = _tmp77_;
		if (_tmp78_ == 0) {
			_tmp75_ = TRUE;
		} else {
			KkcKeyEvent* _tmp79_ = NULL;
			KkcModifierType _tmp80_ = 0;
			KkcModifierType _tmp81_ = 0;
			_tmp79_ = key;
			_tmp80_ = kkc_key_event_get_modifiers (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp75_ = _tmp81_ == KKC_MODIFIER_TYPE_SHIFT_MASK;
		}
		_tmp82_ = _tmp75_;
		_tmp72_ = _tmp82_;
	} else {
		_tmp72_ = FALSE;
	}
	_tmp83_ = _tmp72_;
	if (_tmp83_) {
		KkcState* _tmp84_ = NULL;
		KkcState* _tmp85_ = NULL;
		KkcRomKanaCharacterList* _tmp86_ = NULL;
		KkcKeyEvent* _tmp87_ = NULL;
		gunichar _tmp88_ = 0U;
		gunichar _tmp89_ = 0U;
		gchar* _tmp90_ = NULL;
		KkcKeyEvent* _tmp91_ = NULL;
		gunichar _tmp92_ = 0U;
		gunichar _tmp93_ = 0U;
		gchar* _tmp94_ = NULL;
		KkcRomKanaCharacter _tmp95_ = {0};
		KkcRomKanaCharacter _tmp96_ = {0};
		KkcState* _tmp97_ = NULL;
		_tmp84_ = state;
		kkc_state_finish_input_editing (_tmp84_);
		_tmp85_ = state;
		_tmp86_ = _tmp85_->input_characters;
		_tmp87_ = key;
		_tmp88_ = kkc_key_event_get_unicode (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = g_unichar_to_string (_tmp89_);
		_tmp91_ = key;
		_tmp92_ = kkc_key_event_get_unicode (_tmp91_);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_unichar_to_string (_tmp93_);
		memset (&_tmp95_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp95_.output);
		_tmp95_.output = _tmp90_;
		_g_free0 (_tmp95_.input);
		_tmp95_.input = _tmp94_;
		_tmp96_ = _tmp95_;
		kkc_rom_kana_character_list_add (_tmp86_, &_tmp96_);
		kkc_rom_kana_character_destroy (&_tmp96_);
		_tmp97_ = state;
		_tmp97_->quoted = FALSE;
		result = TRUE;
		_g_free0 (command);
		return result;
	}
	_tmp98_ = state;
	_tmp99_ = key;
	_tmp100_ = kkc_state_handler_dispatch_command ((KkcStateHandler*) self, _tmp98_, _tmp99_);
	result = _tmp100_;
	_g_free0 (command);
	return result;
}


KkcInitialStateHandler* kkc_initial_state_handler_construct (GType object_type) {
	KkcInitialStateHandler * self = NULL;
	self = (KkcInitialStateHandler*) kkc_state_handler_construct (object_type);
	return self;
}


KkcInitialStateHandler* kkc_initial_state_handler_new (void) {
	return kkc_initial_state_handler_construct (KKC_TYPE_INITIAL_STATE_HANDLER);
}


static gboolean _kkc_initial_state_handler_do_abort_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_abort (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_complete_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_complete (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_delete_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_delete (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_delete_forward_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_delete_forward (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_next_candidate_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_next_candidate (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_next_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_next_character (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_previous_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_previous_character (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_first_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_first_character (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_last_character_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_last_character (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_quote_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_quote (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do_register_kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_register (self, command, state, key);
	return result;
}


static gboolean _kkc_initial_state_handler_do__kkc_command_callback (const gchar* command, KkcState* state, KkcKeyEvent* key, gpointer self) {
	gboolean result;
	result = kkc_initial_state_handler_do_ (self, command, state, key);
	return result;
}


static GObject * kkc_initial_state_handler_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	KkcInitialStateHandler * self;
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (kkc_initial_state_handler_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandler);
	_tmp0_ = g_type_class_ref (KKC_TYPE_KANA_MODE);
	enum_class = (GEnumClass*) _tmp0_;
	{
		gint i = 0;
		GEnumClass* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = enum_class;
		_tmp2_ = _tmp1_->minimum;
		i = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				GEnumClass* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				GEnumValue* enum_value = NULL;
				GEnumClass* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				GEnumValue* _tmp11_ = NULL;
				GEnumValue* _tmp12_ = NULL;
				GEnumValue* _tmp13_ = NULL;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = enum_class;
				_tmp8_ = _tmp7_->maximum;
				if (!(_tmp6_ <= _tmp8_)) {
					break;
				}
				_tmp9_ = enum_class;
				_tmp10_ = i;
				_tmp11_ = g_enum_get_value (_tmp9_, _tmp10_);
				_tmp12_ = __g_enum_value_dup0 (_tmp11_);
				enum_value = _tmp12_;
				_tmp13_ = enum_value;
				if (_tmp13_ != NULL) {
					GEnumValue* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					GEnumValue* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					KkcInitialStateHandlerConvertCommandHandler* _tmp20_ = NULL;
					KkcInitialStateHandlerConvertCommandHandler* _tmp21_ = NULL;
					_tmp14_ = enum_value;
					_tmp15_ = (*_tmp14_).value_nick;
					_tmp16_ = g_strconcat ("convert-", _tmp15_, NULL);
					_tmp17_ = _tmp16_;
					_tmp18_ = enum_value;
					_tmp19_ = (*_tmp18_).value;
					_tmp20_ = kkc_initial_state_handler_convert_command_handler_new ((KkcKanaMode) _tmp19_);
					_tmp21_ = _tmp20_;
					kkc_state_handler_register_command_handler ((KkcStateHandler*) self, _tmp17_, (KkcCommandHandler*) _tmp21_);
					_g_object_unref0 (_tmp21_);
					_g_free0 (_tmp17_);
				}
				_g_free0 (enum_value);
			}
		}
	}
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "abort", _kkc_initial_state_handler_do_abort_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "complete", _kkc_initial_state_handler_do_complete_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "delete", _kkc_initial_state_handler_do_delete_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "delete-forward", _kkc_initial_state_handler_do_delete_forward_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "next-candidate", _kkc_initial_state_handler_do_next_candidate_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "next-segment", _kkc_initial_state_handler_do_next_character_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "previous-segment", _kkc_initial_state_handler_do_previous_character_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "first-segment", _kkc_initial_state_handler_do_first_character_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "last-segment", _kkc_initial_state_handler_do_last_character_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "quote", _kkc_initial_state_handler_do_quote_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, "register", _kkc_initial_state_handler_do_register_kkc_command_callback, self);
	kkc_state_handler_register_command_callback ((KkcStateHandler*) self, NULL, _kkc_initial_state_handler_do__kkc_command_callback, self);
	_g_type_class_unref0 (enum_class);
	return obj;
}


static KkcInitialStateHandlerConvertCommandHandler* kkc_initial_state_handler_convert_command_handler_construct (GType object_type, KkcKanaMode mode) {
	KkcInitialStateHandlerConvertCommandHandler * self = NULL;
	KkcKanaMode _tmp0_ = 0;
	self = (KkcInitialStateHandlerConvertCommandHandler*) g_object_new (object_type, NULL);
	_tmp0_ = mode;
	self->priv->mode = _tmp0_;
	return self;
}


static KkcInitialStateHandlerConvertCommandHandler* kkc_initial_state_handler_convert_command_handler_new (KkcKanaMode mode) {
	return kkc_initial_state_handler_convert_command_handler_construct (KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER, mode);
}


static gboolean kkc_initial_state_handler_convert_command_handler_real_call (KkcCommandHandler* base, const gchar* command, KkcState* state, KkcKeyEvent* key) {
	KkcInitialStateHandlerConvertCommandHandler * self;
	gboolean result = FALSE;
	KkcState* _tmp0_ = NULL;
	KkcState* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = (KkcInitialStateHandlerConvertCommandHandler*) base;
	g_return_val_if_fail (state != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = state;
	kkc_state_finish_input_editing (_tmp0_);
	_tmp1_ = state;
	_tmp2_ = _tmp1_->input_characters;
	_tmp3_ = kkc_rom_kana_character_list_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		KkcState* _tmp5_ = NULL;
		GString* _tmp6_ = NULL;
		KkcState* _tmp7_ = NULL;
		KkcState* _tmp8_ = NULL;
		KkcState* _tmp9_ = NULL;
		KkcRomKanaCharacterList* _tmp10_ = NULL;
		KkcKanaMode _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		_tmp5_ = state;
		_tmp6_ = _tmp5_->selection;
		g_string_erase (_tmp6_, (gssize) 0, (gssize) (-1));
		_tmp7_ = state;
		_tmp8_ = state;
		_tmp9_ = state;
		_tmp10_ = _tmp9_->input_characters;
		_tmp11_ = self->priv->mode;
		_tmp12_ = kkc_state_convert_rom_kana_characters_by_kana_mode (_tmp8_, _tmp10_, _tmp11_);
		_g_free0 (_tmp7_->overriding_input);
		_tmp7_->overriding_input = _tmp12_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void kkc_initial_state_handler_convert_command_handler_class_init (KkcInitialStateHandlerConvertCommandHandlerClass * klass) {
	kkc_initial_state_handler_convert_command_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcInitialStateHandlerConvertCommandHandlerPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_initial_state_handler_convert_command_handler_finalize;
}


static void kkc_initial_state_handler_convert_command_handler_kkc_command_handler_interface_init (KkcCommandHandlerIface * iface) {
	kkc_initial_state_handler_convert_command_handler_kkc_command_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->call = (gboolean (*)(KkcCommandHandler*, const gchar*, KkcState*, KkcKeyEvent*)) kkc_initial_state_handler_convert_command_handler_real_call;
}


static void kkc_initial_state_handler_convert_command_handler_instance_init (KkcInitialStateHandlerConvertCommandHandler * self) {
	self->priv = KKC_INITIAL_STATE_HANDLER_CONVERT_COMMAND_HANDLER_GET_PRIVATE (self);
}


static void kkc_initial_state_handler_convert_command_handler_finalize (GObject* obj) {
	KkcInitialStateHandlerConvertCommandHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_INITIAL_STATE_HANDLER_TYPE_CONVERT_COMMAND_HANDLER, KkcInitialStateHandlerConvertCommandHandler);
	G_OBJECT_CLASS (kkc_initial_state_handler_convert_command_handler_parent_class)->finalize (obj);
}


static GType kkc_initial_state_handler_convert_command_handler_get_type (void) {
	static volatile gsize kkc_initial_state_handler_convert_command_handler_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_initial_state_handler_convert_command_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcInitialStateHandlerConvertCommandHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_initial_state_handler_convert_command_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcInitialStateHandlerConvertCommandHandler), 0, (GInstanceInitFunc) kkc_initial_state_handler_convert_command_handler_instance_init, NULL };
		static const GInterfaceInfo kkc_command_handler_info = { (GInterfaceInitFunc) kkc_initial_state_handler_convert_command_handler_kkc_command_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_initial_state_handler_convert_command_handler_type_id;
		kkc_initial_state_handler_convert_command_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcInitialStateHandlerConvertCommandHandler", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_initial_state_handler_convert_command_handler_type_id, KKC_TYPE_COMMAND_HANDLER, &kkc_command_handler_info);
		g_once_init_leave (&kkc_initial_state_handler_convert_command_handler_type_id__volatile, kkc_initial_state_handler_convert_command_handler_type_id);
	}
	return kkc_initial_state_handler_convert_command_handler_type_id__volatile;
}


static void kkc_initial_state_handler_class_init (KkcInitialStateHandlerClass * klass) {
	kkc_initial_state_handler_parent_class = g_type_class_peek_parent (klass);
	KKC_STATE_HANDLER_CLASS (klass)->process_key_event = kkc_initial_state_handler_real_process_key_event;
	G_OBJECT_CLASS (klass)->constructor = kkc_initial_state_handler_constructor;
}


static void kkc_initial_state_handler_instance_init (KkcInitialStateHandler * self) {
}


GType kkc_initial_state_handler_get_type (void) {
	static volatile gsize kkc_initial_state_handler_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_initial_state_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcInitialStateHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_initial_state_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcInitialStateHandler), 0, (GInstanceInitFunc) kkc_initial_state_handler_instance_init, NULL };
		GType kkc_initial_state_handler_type_id;
		kkc_initial_state_handler_type_id = g_type_register_static (KKC_TYPE_STATE_HANDLER, "KkcInitialStateHandler", &g_define_type_info, 0);
		g_once_init_leave (&kkc_initial_state_handler_type_id__volatile, kkc_initial_state_handler_type_id);
	}
	return kkc_initial_state_handler_type_id__volatile;
}



