/* key-event.c generated by valac 0.22.1, the Vala compiler
 * generated from key-event.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define KKC_TYPE_MODIFIER_TYPE (kkc_modifier_type_get_type ())

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;
typedef struct _KkcKeyEventPrivate KkcKeyEventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED,
	KKC_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND
} KkcKeyEventFormatError;
#define KKC_KEY_EVENT_FORMAT_ERROR kkc_key_event_format_error_quark ()
typedef enum  {
	KKC_MODIFIER_TYPE_NONE = 0,
	KKC_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	KKC_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	KKC_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	KKC_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	KKC_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	KKC_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	KKC_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	KKC_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	KKC_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	KKC_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	KKC_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	KKC_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	KKC_MODIFIER_TYPE_META_MASK = 1 << 28,
	KKC_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} KkcModifierType;

struct _KkcKeyEvent {
	GObject parent_instance;
	KkcKeyEventPrivate * priv;
};

struct _KkcKeyEventClass {
	GObjectClass parent_class;
};

struct _KkcKeyEventPrivate {
	gchar* _name;
	gunichar _unicode;
	guint _keyval;
	guint _keycode;
	KkcModifierType _modifiers;
};


static gpointer kkc_key_event_parent_class = NULL;

GQuark kkc_key_event_format_error_quark (void);
GType kkc_modifier_type_get_type (void) G_GNUC_CONST;
GType kkc_key_event_get_type (void) G_GNUC_CONST;
#define KKC_KEY_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_KEY_EVENT, KkcKeyEventPrivate))
enum  {
	KKC_KEY_EVENT_DUMMY_PROPERTY,
	KKC_KEY_EVENT_NAME,
	KKC_KEY_EVENT_UNICODE,
	KKC_KEY_EVENT_KEYVAL,
	KKC_KEY_EVENT_KEYCODE,
	KKC_KEY_EVENT_MODIFIERS
};
KkcKeyEvent* kkc_key_event_new_from_string (const gchar* key, GError** error);
KkcKeyEvent* kkc_key_event_construct_from_string (GType object_type, const gchar* key, GError** error);
#define KKC_KEYSYMS_VoidSymbol ((guint) 0xffffff)
guint kkc_key_event_utils_keyval_from_name (const gchar* name);
KkcKeyEvent* kkc_key_event_new_from_x_event (guint keyval, guint keycode, KkcModifierType modifiers);
KkcKeyEvent* kkc_key_event_construct_from_x_event (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers);
gchar* kkc_key_event_to_string (KkcKeyEvent* self);
const gchar* kkc_key_event_get_name (KkcKeyEvent* self);
gunichar kkc_key_event_get_unicode (KkcKeyEvent* self);
KkcModifierType kkc_key_event_get_modifiers (KkcKeyEvent* self);
KkcKeyEvent* kkc_key_event_new (guint keyval, guint keycode, KkcModifierType modifiers);
KkcKeyEvent* kkc_key_event_construct (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers);
gchar* kkc_key_event_utils_keyval_name (guint keyval);
void kkc_key_event_set_name (KkcKeyEvent* self, const gchar* value);
gunichar kkc_key_event_utils_keyval_unicode (guint keyval);
void kkc_key_event_set_unicode (KkcKeyEvent* self, gunichar value);
void kkc_key_event_set_keyval (KkcKeyEvent* self, guint value);
void kkc_key_event_set_keycode (KkcKeyEvent* self, guint value);
void kkc_key_event_set_modifiers (KkcKeyEvent* self, KkcModifierType value);
guint kkc_key_event_get_keyval (KkcKeyEvent* self);
guint kkc_key_event_get_keycode (KkcKeyEvent* self);
static void kkc_key_event_finalize (GObject* obj);
static void _vala_kkc_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark kkc_key_event_format_error_quark (void) {
	return g_quark_from_static_string ("kkc_key_event_format_error-quark");
}


/**
     * A set of bit-flags to indicate the state of modifier keys.
     */
GType kkc_modifier_type_get_type (void) {
	static volatile gsize kkc_modifier_type_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_modifier_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{KKC_MODIFIER_TYPE_NONE, "KKC_MODIFIER_TYPE_NONE", "none"}, {KKC_MODIFIER_TYPE_SHIFT_MASK, "KKC_MODIFIER_TYPE_SHIFT_MASK", "shift-mask"}, {KKC_MODIFIER_TYPE_LOCK_MASK, "KKC_MODIFIER_TYPE_LOCK_MASK", "lock-mask"}, {KKC_MODIFIER_TYPE_CONTROL_MASK, "KKC_MODIFIER_TYPE_CONTROL_MASK", "control-mask"}, {KKC_MODIFIER_TYPE_MOD1_MASK, "KKC_MODIFIER_TYPE_MOD1_MASK", "mod1-mask"}, {KKC_MODIFIER_TYPE_MOD2_MASK, "KKC_MODIFIER_TYPE_MOD2_MASK", "mod2-mask"}, {KKC_MODIFIER_TYPE_MOD3_MASK, "KKC_MODIFIER_TYPE_MOD3_MASK", "mod3-mask"}, {KKC_MODIFIER_TYPE_MOD4_MASK, "KKC_MODIFIER_TYPE_MOD4_MASK", "mod4-mask"}, {KKC_MODIFIER_TYPE_MOD5_MASK, "KKC_MODIFIER_TYPE_MOD5_MASK", "mod5-mask"}, {KKC_MODIFIER_TYPE_LSHIFT_MASK, "KKC_MODIFIER_TYPE_LSHIFT_MASK", "lshift-mask"}, {KKC_MODIFIER_TYPE_RSHIFT_MASK, "KKC_MODIFIER_TYPE_RSHIFT_MASK", "rshift-mask"}, {KKC_MODIFIER_TYPE_SUPER_MASK, "KKC_MODIFIER_TYPE_SUPER_MASK", "super-mask"}, {KKC_MODIFIER_TYPE_HYPER_MASK, "KKC_MODIFIER_TYPE_HYPER_MASK", "hyper-mask"}, {KKC_MODIFIER_TYPE_META_MASK, "KKC_MODIFIER_TYPE_META_MASK", "meta-mask"}, {KKC_MODIFIER_TYPE_RELEASE_MASK, "KKC_MODIFIER_TYPE_RELEASE_MASK", "release-mask"}, {0, NULL, NULL}};
		GType kkc_modifier_type_type_id;
		kkc_modifier_type_type_id = g_flags_register_static ("KkcModifierType", values);
		g_once_init_leave (&kkc_modifier_type_type_id__volatile, kkc_modifier_type_type_id);
	}
	return kkc_modifier_type_type_id__volatile;
}


/**
         * Create a key event from string.
         *
         * @param key a string representation of a key event
         *
         * @return a new KeyEvent
         */
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


KkcKeyEvent* kkc_key_event_construct_from_string (GType object_type, const gchar* key, GError** error) {
	KkcKeyEvent * self = NULL;
	KkcModifierType _modifiers = 0;
	guint _keyval = 0U;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	guint _tmp98_ = 0U;
	KkcModifierType _tmp99_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	_modifiers = 0;
	_keyval = KKC_KEYSYMS_VoidSymbol;
	_tmp1_ = key;
	_tmp2_ = g_str_has_prefix (_tmp1_, "(");
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = key;
		_tmp4_ = g_str_has_suffix (_tmp3_, ")");
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gchar** strv = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gint index = 0;
		gchar** _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		gint _tmp58_ = 0;
		const gchar* _tmp59_ = NULL;
		guint _tmp60_ = 0U;
		guint _tmp61_ = 0U;
		_tmp6_ = key;
		_tmp7_ = string_slice (_tmp6_, (glong) 1, (glong) (-1));
		_tmp8_ = _tmp7_;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _vala_array_length (_tmp9_);
		_g_free0 (_tmp8_);
		strv = _tmp11_;
		strv_length1 = _tmp11__length1;
		_strv_size_ = strv_length1;
		index = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				gint _tmp15_ = 0;
				gchar** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				const gchar* _tmp19_ = NULL;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					_tmp14_ = index;
					index = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = index;
				_tmp16_ = strv;
				_tmp16__length1 = strv_length1;
				if (!(_tmp15_ < (_tmp16__length1 - 1))) {
					break;
				}
				_tmp17_ = strv;
				_tmp17__length1 = strv_length1;
				_tmp18_ = index;
				_tmp19_ = _tmp17_[_tmp18_];
				if (g_strcmp0 (_tmp19_, "shift") == 0) {
					KkcModifierType _tmp20_ = 0;
					_tmp20_ = _modifiers;
					_modifiers = _tmp20_ | KKC_MODIFIER_TYPE_SHIFT_MASK;
				} else {
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					gint _tmp22_ = 0;
					const gchar* _tmp23_ = NULL;
					_tmp21_ = strv;
					_tmp21__length1 = strv_length1;
					_tmp22_ = index;
					_tmp23_ = _tmp21_[_tmp22_];
					if (g_strcmp0 (_tmp23_, "control") == 0) {
						KkcModifierType _tmp24_ = 0;
						_tmp24_ = _modifiers;
						_modifiers = _tmp24_ | KKC_MODIFIER_TYPE_CONTROL_MASK;
					} else {
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						gint _tmp26_ = 0;
						const gchar* _tmp27_ = NULL;
						_tmp25_ = strv;
						_tmp25__length1 = strv_length1;
						_tmp26_ = index;
						_tmp27_ = _tmp25_[_tmp26_];
						if (g_strcmp0 (_tmp27_, "meta") == 0) {
							KkcModifierType _tmp28_ = 0;
							_tmp28_ = _modifiers;
							_modifiers = _tmp28_ | KKC_MODIFIER_TYPE_META_MASK;
						} else {
							gchar** _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp30_ = 0;
							const gchar* _tmp31_ = NULL;
							_tmp29_ = strv;
							_tmp29__length1 = strv_length1;
							_tmp30_ = index;
							_tmp31_ = _tmp29_[_tmp30_];
							if (g_strcmp0 (_tmp31_, "hyper") == 0) {
								KkcModifierType _tmp32_ = 0;
								_tmp32_ = _modifiers;
								_modifiers = _tmp32_ | KKC_MODIFIER_TYPE_HYPER_MASK;
							} else {
								gchar** _tmp33_ = NULL;
								gint _tmp33__length1 = 0;
								gint _tmp34_ = 0;
								const gchar* _tmp35_ = NULL;
								_tmp33_ = strv;
								_tmp33__length1 = strv_length1;
								_tmp34_ = index;
								_tmp35_ = _tmp33_[_tmp34_];
								if (g_strcmp0 (_tmp35_, "super") == 0) {
									KkcModifierType _tmp36_ = 0;
									_tmp36_ = _modifiers;
									_modifiers = _tmp36_ | KKC_MODIFIER_TYPE_SUPER_MASK;
								} else {
									gchar** _tmp37_ = NULL;
									gint _tmp37__length1 = 0;
									gint _tmp38_ = 0;
									const gchar* _tmp39_ = NULL;
									_tmp37_ = strv;
									_tmp37__length1 = strv_length1;
									_tmp38_ = index;
									_tmp39_ = _tmp37_[_tmp38_];
									if (g_strcmp0 (_tmp39_, "alt") == 0) {
										KkcModifierType _tmp40_ = 0;
										_tmp40_ = _modifiers;
										_modifiers = _tmp40_ | KKC_MODIFIER_TYPE_MOD1_MASK;
									} else {
										gchar** _tmp41_ = NULL;
										gint _tmp41__length1 = 0;
										gint _tmp42_ = 0;
										const gchar* _tmp43_ = NULL;
										_tmp41_ = strv;
										_tmp41__length1 = strv_length1;
										_tmp42_ = index;
										_tmp43_ = _tmp41_[_tmp42_];
										if (g_strcmp0 (_tmp43_, "lshift") == 0) {
											KkcModifierType _tmp44_ = 0;
											_tmp44_ = _modifiers;
											_modifiers = _tmp44_ | KKC_MODIFIER_TYPE_LSHIFT_MASK;
										} else {
											gchar** _tmp45_ = NULL;
											gint _tmp45__length1 = 0;
											gint _tmp46_ = 0;
											const gchar* _tmp47_ = NULL;
											_tmp45_ = strv;
											_tmp45__length1 = strv_length1;
											_tmp46_ = index;
											_tmp47_ = _tmp45_[_tmp46_];
											if (g_strcmp0 (_tmp47_, "rshift") == 0) {
												KkcModifierType _tmp48_ = 0;
												_tmp48_ = _modifiers;
												_modifiers = _tmp48_ | KKC_MODIFIER_TYPE_RSHIFT_MASK;
											} else {
												gchar** _tmp49_ = NULL;
												gint _tmp49__length1 = 0;
												gint _tmp50_ = 0;
												const gchar* _tmp51_ = NULL;
												_tmp49_ = strv;
												_tmp49__length1 = strv_length1;
												_tmp50_ = index;
												_tmp51_ = _tmp49_[_tmp50_];
												if (g_strcmp0 (_tmp51_, "release") == 0) {
													KkcModifierType _tmp52_ = 0;
													_tmp52_ = _modifiers;
													_modifiers = _tmp52_ | KKC_MODIFIER_TYPE_RELEASE_MASK;
												} else {
													gchar** _tmp53_ = NULL;
													gint _tmp53__length1 = 0;
													gint _tmp54_ = 0;
													const gchar* _tmp55_ = NULL;
													GError* _tmp56_ = NULL;
													_tmp53_ = strv;
													_tmp53__length1 = strv_length1;
													_tmp54_ = index;
													_tmp55_ = _tmp53_[_tmp54_];
													_tmp56_ = g_error_new (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown modifier %s", _tmp55_);
													_inner_error_ = _tmp56_;
													if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
														g_propagate_error (error, _inner_error_);
														strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
														_g_object_unref0 (self);
														return NULL;
													} else {
														strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
														g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
														g_clear_error (&_inner_error_);
														return NULL;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp57_ = strv;
		_tmp57__length1 = strv_length1;
		_tmp58_ = index;
		_tmp59_ = _tmp57_[_tmp58_];
		_tmp60_ = kkc_key_event_utils_keyval_from_name (_tmp59_);
		_keyval = _tmp60_;
		_tmp61_ = _keyval;
		if (_tmp61_ == KKC_KEYSYMS_VoidSymbol) {
			gchar** _tmp62_ = NULL;
			gint _tmp62__length1 = 0;
			gint _tmp63_ = 0;
			const gchar* _tmp64_ = NULL;
			GError* _tmp65_ = NULL;
			_tmp62_ = strv;
			_tmp62__length1 = strv_length1;
			_tmp63_ = index;
			_tmp64_ = _tmp62_[_tmp63_];
			_tmp65_ = g_error_new (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp64_);
			_inner_error_ = _tmp65_;
			if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gint index = 0;
		const gchar* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		gchar* _name = NULL;
		gint _tmp68_ = 0;
		const gchar* _tmp93_ = NULL;
		guint _tmp94_ = 0U;
		guint _tmp95_ = 0U;
		_tmp66_ = key;
		_tmp67_ = string_last_index_of (_tmp66_, "-", 0);
		index = _tmp67_;
		_name = NULL;
		_tmp68_ = index;
		if (_tmp68_ > 0) {
			gchar** mods = NULL;
			const gchar* _tmp69_ = NULL;
			gint _tmp70_ = 0;
			gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			gchar** _tmp73_ = NULL;
			gchar** _tmp74_ = NULL;
			gchar** _tmp75_ = NULL;
			gint _tmp75__length1 = 0;
			gint mods_length1 = 0;
			gint _mods_size_ = 0;
			gchar** _tmp76_ = NULL;
			gint _tmp76__length1 = 0;
			const gchar* _tmp88_ = NULL;
			gint _tmp89_ = 0;
			gchar* _tmp90_ = NULL;
			_tmp69_ = key;
			_tmp70_ = index;
			_tmp71_ = string_substring (_tmp69_, (glong) 0, (glong) _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp74_ = _tmp73_ = g_strsplit (_tmp72_, "-", 0);
			_tmp75_ = _tmp74_;
			_tmp75__length1 = _vala_array_length (_tmp73_);
			_g_free0 (_tmp72_);
			mods = _tmp75_;
			mods_length1 = _tmp75__length1;
			_mods_size_ = mods_length1;
			_tmp76_ = mods;
			_tmp76__length1 = mods_length1;
			{
				gchar** mod_collection = NULL;
				gint mod_collection_length1 = 0;
				gint _mod_collection_size_ = 0;
				gint mod_it = 0;
				mod_collection = _tmp76_;
				mod_collection_length1 = _tmp76__length1;
				for (mod_it = 0; mod_it < _tmp76__length1; mod_it = mod_it + 1) {
					gchar* _tmp77_ = NULL;
					gchar* mod = NULL;
					_tmp77_ = g_strdup (mod_collection[mod_it]);
					mod = _tmp77_;
					{
						const gchar* _tmp78_ = NULL;
						_tmp78_ = mod;
						if (g_strcmp0 (_tmp78_, "S") == 0) {
							KkcModifierType _tmp79_ = 0;
							_tmp79_ = _modifiers;
							_modifiers = _tmp79_ | KKC_MODIFIER_TYPE_SHIFT_MASK;
						} else {
							const gchar* _tmp80_ = NULL;
							_tmp80_ = mod;
							if (g_strcmp0 (_tmp80_, "C") == 0) {
								KkcModifierType _tmp81_ = 0;
								_tmp81_ = _modifiers;
								_modifiers = _tmp81_ | KKC_MODIFIER_TYPE_CONTROL_MASK;
							} else {
								const gchar* _tmp82_ = NULL;
								_tmp82_ = mod;
								if (g_strcmp0 (_tmp82_, "A") == 0) {
									KkcModifierType _tmp83_ = 0;
									_tmp83_ = _modifiers;
									_modifiers = _tmp83_ | KKC_MODIFIER_TYPE_MOD1_MASK;
								} else {
									const gchar* _tmp84_ = NULL;
									_tmp84_ = mod;
									if (g_strcmp0 (_tmp84_, "M") == 0) {
										KkcModifierType _tmp85_ = 0;
										_tmp85_ = _modifiers;
										_modifiers = _tmp85_ | KKC_MODIFIER_TYPE_META_MASK;
									} else {
										const gchar* _tmp86_ = NULL;
										_tmp86_ = mod;
										if (g_strcmp0 (_tmp86_, "G") == 0) {
											KkcModifierType _tmp87_ = 0;
											_tmp87_ = _modifiers;
											_modifiers = _tmp87_ | KKC_MODIFIER_TYPE_MOD5_MASK;
										}
									}
								}
							}
						}
						_g_free0 (mod);
					}
				}
			}
			_tmp88_ = key;
			_tmp89_ = index;
			_tmp90_ = string_substring (_tmp88_, (glong) (_tmp89_ + 1), (glong) (-1));
			_g_free0 (_name);
			_name = _tmp90_;
			mods = (_vala_array_free (mods, mods_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp91_ = NULL;
			gchar* _tmp92_ = NULL;
			_modifiers = KKC_MODIFIER_TYPE_NONE;
			_tmp91_ = key;
			_tmp92_ = g_strdup (_tmp91_);
			_g_free0 (_name);
			_name = _tmp92_;
		}
		_tmp93_ = _name;
		_tmp94_ = kkc_key_event_utils_keyval_from_name (_tmp93_);
		_keyval = _tmp94_;
		_tmp95_ = _keyval;
		if (_tmp95_ == KKC_KEYSYMS_VoidSymbol) {
			const gchar* _tmp96_ = NULL;
			GError* _tmp97_ = NULL;
			_tmp96_ = _name;
			_tmp97_ = g_error_new (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "unknown keyval %s", _tmp96_);
			_inner_error_ = _tmp97_;
			if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (_name);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_free0 (_name);
	}
	_tmp98_ = _keyval;
	_tmp99_ = _modifiers;
	self = (KkcKeyEvent*) kkc_key_event_construct_from_x_event (object_type, _tmp98_, (guint) 0, _tmp99_);
	return self;
}


KkcKeyEvent* kkc_key_event_new_from_string (const gchar* key, GError** error) {
	return kkc_key_event_construct_from_string (KKC_TYPE_KEY_EVENT, key, error);
}


/**
         * Convert the KeyEvent to string.
         *
         * @return a string representing the KeyEvent
         */
static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* kkc_key_event_to_string (KkcKeyEvent* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _base = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	KkcModifierType _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_name;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gunichar _tmp4_ = 0U;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->_unicode;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp7_ = g_strdup (_tmp6_);
	_base = _tmp7_;
	_tmp8_ = self->priv->_modifiers;
	if (_tmp8_ != 0) {
		GeeArrayList* elements = NULL;
		GeeArrayList* _tmp9_ = NULL;
		KkcModifierType _tmp10_ = 0;
		KkcModifierType _tmp12_ = 0;
		KkcModifierType _tmp14_ = 0;
		KkcModifierType _tmp16_ = 0;
		KkcModifierType _tmp18_ = 0;
		KkcModifierType _tmp20_ = 0;
		KkcModifierType _tmp22_ = 0;
		KkcModifierType _tmp24_ = 0;
		KkcModifierType _tmp26_ = 0;
		GeeArrayList* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GeeArrayList* _tmp30_ = NULL;
		gchar** array = NULL;
		GeeArrayList* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gpointer* _tmp33_ = NULL;
		gint array_length1 = 0;
		gint _array_size_ = 0;
		gint _tmp34_ = 0;
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		elements = _tmp9_;
		_tmp10_ = self->priv->_modifiers;
		if ((_tmp10_ & KKC_MODIFIER_TYPE_SHIFT_MASK) != 0) {
			GeeArrayList* _tmp11_ = NULL;
			_tmp11_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "shift");
		}
		_tmp12_ = self->priv->_modifiers;
		if ((_tmp12_ & KKC_MODIFIER_TYPE_CONTROL_MASK) != 0) {
			GeeArrayList* _tmp13_ = NULL;
			_tmp13_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "control");
		}
		_tmp14_ = self->priv->_modifiers;
		if ((_tmp14_ & KKC_MODIFIER_TYPE_META_MASK) != 0) {
			GeeArrayList* _tmp15_ = NULL;
			_tmp15_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "meta");
		}
		_tmp16_ = self->priv->_modifiers;
		if ((_tmp16_ & KKC_MODIFIER_TYPE_HYPER_MASK) != 0) {
			GeeArrayList* _tmp17_ = NULL;
			_tmp17_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "hyper");
		}
		_tmp18_ = self->priv->_modifiers;
		if ((_tmp18_ & KKC_MODIFIER_TYPE_SUPER_MASK) != 0) {
			GeeArrayList* _tmp19_ = NULL;
			_tmp19_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "super");
		}
		_tmp20_ = self->priv->_modifiers;
		if ((_tmp20_ & KKC_MODIFIER_TYPE_MOD1_MASK) != 0) {
			GeeArrayList* _tmp21_ = NULL;
			_tmp21_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, "alt");
		}
		_tmp22_ = self->priv->_modifiers;
		if ((_tmp22_ & KKC_MODIFIER_TYPE_LSHIFT_MASK) != 0) {
			GeeArrayList* _tmp23_ = NULL;
			_tmp23_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, "lshift");
		}
		_tmp24_ = self->priv->_modifiers;
		if ((_tmp24_ & KKC_MODIFIER_TYPE_RSHIFT_MASK) != 0) {
			GeeArrayList* _tmp25_ = NULL;
			_tmp25_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, "rshift");
		}
		_tmp26_ = self->priv->_modifiers;
		if ((_tmp26_ & KKC_MODIFIER_TYPE_RELEASE_MASK) != 0) {
			GeeArrayList* _tmp27_ = NULL;
			_tmp27_ = elements;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, "release");
		}
		_tmp28_ = elements;
		_tmp29_ = _base;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
		_tmp30_ = elements;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, NULL);
		_tmp31_ = elements;
		_tmp33_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp31_, &_tmp32_);
		array = _tmp33_;
		array_length1 = _tmp32_;
		_array_size_ = array_length1;
		array_length1 = -1;
		_tmp34_ = array_length1;
		_tmp35_ = array;
		_tmp35__length1 = array_length1;
		_tmp36_ = g_strjoinv (" ", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat ("(", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, ")", NULL);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		result = _tmp41_;
		array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (elements);
		_g_free0 (_base);
		_g_free0 (_tmp0_);
		return result;
	} else {
		result = _base;
		_g_free0 (_tmp0_);
		return result;
	}
	_g_free0 (_base);
	_g_free0 (_tmp0_);
}


KkcKeyEvent* kkc_key_event_construct_from_x_event (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers) {
	KkcKeyEvent * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	KkcModifierType _tmp2_ = 0;
	_tmp0_ = keyval;
	_tmp1_ = keycode;
	_tmp2_ = modifiers;
	self = (KkcKeyEvent*) kkc_key_event_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


KkcKeyEvent* kkc_key_event_new_from_x_event (guint keyval, guint keycode, KkcModifierType modifiers) {
	return kkc_key_event_construct_from_x_event (KKC_TYPE_KEY_EVENT, keyval, keycode, modifiers);
}


/**
         * Create a key event from an X event.
         *
         * @param keyval an X keysym
         * @param keycode an X keycode
         * @param modifiers modifier mask
         *
         * @return a new KeyEvent
         */
KkcKeyEvent* kkc_key_event_construct (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers) {
	KkcKeyEvent * self = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gunichar _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	guint _tmp6_ = 0U;
	gboolean _tmp8_ = FALSE;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	KkcModifierType _tmp12_ = 0;
	self = (KkcKeyEvent*) g_object_new (object_type, NULL);
	_tmp0_ = keyval;
	_tmp1_ = kkc_key_event_utils_keyval_name (_tmp0_);
	_tmp2_ = _tmp1_;
	kkc_key_event_set_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = keyval;
	_tmp4_ = kkc_key_event_utils_keyval_unicode (_tmp3_);
	kkc_key_event_set_unicode (self, _tmp4_);
	_tmp6_ = keyval;
	if (((guint) 0x21) <= _tmp6_) {
		guint _tmp7_ = 0U;
		_tmp7_ = keyval;
		_tmp5_ = _tmp7_ < ((guint) 0x7F);
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		KkcModifierType _tmp9_ = 0;
		_tmp9_ = modifiers;
		modifiers = _tmp9_ & (~KKC_MODIFIER_TYPE_SHIFT_MASK);
	}
	_tmp10_ = keyval;
	kkc_key_event_set_keyval (self, _tmp10_);
	_tmp11_ = keycode;
	kkc_key_event_set_keycode (self, _tmp11_);
	_tmp12_ = modifiers;
	kkc_key_event_set_modifiers (self, _tmp12_);
	return self;
}


KkcKeyEvent* kkc_key_event_new (guint keyval, guint keycode, KkcModifierType modifiers) {
	return kkc_key_event_construct (KKC_TYPE_KEY_EVENT, keyval, keycode, modifiers);
}


const gchar* kkc_key_event_get_name (KkcKeyEvent* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_name (KkcKeyEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


gunichar kkc_key_event_get_unicode (KkcKeyEvent* self) {
	gunichar result;
	gunichar _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_unicode;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_unicode (KkcKeyEvent* self, gunichar value) {
	gunichar _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_unicode = _tmp0_;
	g_object_notify ((GObject *) self, "unicode");
}


guint kkc_key_event_get_keyval (KkcKeyEvent* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keyval;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_keyval (KkcKeyEvent* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keyval = _tmp0_;
	g_object_notify ((GObject *) self, "keyval");
}


guint kkc_key_event_get_keycode (KkcKeyEvent* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keycode;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_keycode (KkcKeyEvent* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keycode = _tmp0_;
	g_object_notify ((GObject *) self, "keycode");
}


KkcModifierType kkc_key_event_get_modifiers (KkcKeyEvent* self) {
	KkcModifierType result;
	KkcModifierType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


void kkc_key_event_set_modifiers (KkcKeyEvent* self, KkcModifierType value) {
	KkcModifierType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
	g_object_notify ((GObject *) self, "modifiers");
}


static void kkc_key_event_class_init (KkcKeyEventClass * klass) {
	kkc_key_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcKeyEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_key_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_key_event_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_key_event_finalize;
	/**
	         * The base name of the KeyEvent.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * The base unicode output of the KeyEvent.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_UNICODE, g_param_spec_uint ("unicode", "unicode", "unicode", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * X keyval.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_KEYVAL, g_param_spec_uint ("keyval", "keyval", "keyval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * X keycode.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_KEYCODE, g_param_spec_uint ("keycode", "keycode", "keycode", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * Modifier mask.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_KEY_EVENT_MODIFIERS, g_param_spec_flags ("modifiers", "modifiers", "modifiers", KKC_TYPE_MODIFIER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void kkc_key_event_instance_init (KkcKeyEvent * self) {
	self->priv = KKC_KEY_EVENT_GET_PRIVATE (self);
}


static void kkc_key_event_finalize (GObject* obj) {
	KkcKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_KEY_EVENT, KkcKeyEvent);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (kkc_key_event_parent_class)->finalize (obj);
}


/**
     * Object representing a key event.
     */
GType kkc_key_event_get_type (void) {
	static volatile gsize kkc_key_event_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_key_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcKeyEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_key_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcKeyEvent), 0, (GInstanceInitFunc) kkc_key_event_instance_init, NULL };
		GType kkc_key_event_type_id;
		kkc_key_event_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcKeyEvent", &g_define_type_info, 0);
		g_once_init_leave (&kkc_key_event_type_id__volatile, kkc_key_event_type_id);
	}
	return kkc_key_event_type_id__volatile;
}


static void _vala_kkc_key_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_KEY_EVENT, KkcKeyEvent);
	switch (property_id) {
		case KKC_KEY_EVENT_NAME:
		g_value_set_string (value, kkc_key_event_get_name (self));
		break;
		case KKC_KEY_EVENT_UNICODE:
		g_value_set_uint (value, kkc_key_event_get_unicode (self));
		break;
		case KKC_KEY_EVENT_KEYVAL:
		g_value_set_uint (value, kkc_key_event_get_keyval (self));
		break;
		case KKC_KEY_EVENT_KEYCODE:
		g_value_set_uint (value, kkc_key_event_get_keycode (self));
		break;
		case KKC_KEY_EVENT_MODIFIERS:
		g_value_set_flags (value, kkc_key_event_get_modifiers (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_key_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcKeyEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_KEY_EVENT, KkcKeyEvent);
	switch (property_id) {
		case KKC_KEY_EVENT_NAME:
		kkc_key_event_set_name (self, g_value_get_string (value));
		break;
		case KKC_KEY_EVENT_UNICODE:
		kkc_key_event_set_unicode (self, g_value_get_uint (value));
		break;
		case KKC_KEY_EVENT_KEYVAL:
		kkc_key_event_set_keyval (self, g_value_get_uint (value));
		break;
		case KKC_KEY_EVENT_KEYCODE:
		kkc_key_event_set_keycode (self, g_value_get_uint (value));
		break;
		case KKC_KEY_EVENT_MODIFIERS:
		kkc_key_event_set_modifiers (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



