/* map-file.c generated by valac 0.22.1, the Vala compiler
 * generated from map-file.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <json-glib/json-glib.h>


#define KKC_TYPE_MAP_FILE (kkc_map_file_get_type ())
#define KKC_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAP_FILE, KkcMapFile))
#define KKC_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAP_FILE, KkcMapFileClass))
#define KKC_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAP_FILE))
#define KKC_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAP_FILE))
#define KKC_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAP_FILE, KkcMapFileClass))

typedef struct _KkcMapFile KkcMapFile;
typedef struct _KkcMapFileClass KkcMapFileClass;
typedef struct _KkcMapFilePrivate KkcMapFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_RULE_METADATA (kkc_rule_metadata_get_type ())
#define KKC_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadata))
#define KKC_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))
#define KKC_IS_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE_METADATA))
#define KKC_IS_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE_METADATA))
#define KKC_RULE_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))

typedef struct _KkcRuleMetadata KkcRuleMetadata;
typedef struct _KkcRuleMetadataClass KkcRuleMetadataClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _KkcMapFile {
	GObject parent_instance;
	KkcMapFilePrivate * priv;
};

struct _KkcMapFileClass {
	GObjectClass parent_class;
	gchar* (*uniquify) (KkcMapFile* self, const gchar* key);
};

struct _KkcMapFilePrivate {
	GeeMap* maps;
	GeeMap* parent_maps;
};

typedef enum  {
	KKC_RULE_PARSE_ERROR_FAILED
} KkcRuleParseError;
#define KKC_RULE_PARSE_ERROR kkc_rule_parse_error_quark ()

static gpointer kkc_map_file_parent_class = NULL;

GType kkc_map_file_get_type (void) G_GNUC_CONST;
#define KKC_MAP_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_MAP_FILE, KkcMapFilePrivate))
enum  {
	KKC_MAP_FILE_DUMMY_PROPERTY
};
static void kkc_map_file_load_map (KkcMapFile* self, GeeMap* map, JsonObject* object);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
gchar* kkc_map_file_uniquify (KkcMapFile* self, const gchar* key);
static void _vala_JsonNode_free (JsonNode* self);
static gchar* kkc_map_file_real_uniquify (KkcMapFile* self, const gchar* key);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_rule_metadata_get_type (void) G_GNUC_CONST;
GQuark kkc_rule_parse_error_quark (void);
static void kkc_map_file_load (KkcMapFile* self, KkcRuleMetadata* metadata, const gchar* type, const gchar* name, GeeSet* parents, GeeMap* maps, GeeMap* parent_maps, GError** error);
gchar* kkc_rule_metadata_locate_map_file (KkcRuleMetadata* self, const gchar* type, const gchar* name);
const gchar* kkc_metadata_file_get_name (KkcMetadataFile* self);
KkcRuleMetadata* kkc_rule_metadata_find (const gchar* name);
KkcMapFile* kkc_map_file_construct (GType object_type, KkcRuleMetadata* metadata, const gchar* type, const gchar* name, GError** error);
GeeMap* kkc_map_file_get (KkcMapFile* self, const gchar* name);
GeeMap* kkc_map_file_get_parent (KkcMapFile* self, const gchar* name);
static void kkc_map_file_finalize (GObject* obj);


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void kkc_map_file_load_map (KkcMapFile* self, GeeMap* map, JsonObject* object) {
	GList* keys = NULL;
	JsonObject* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = object;
	_tmp1_ = json_object_get_members (_tmp0_);
	keys = _tmp1_;
	_tmp2_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp2_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				JsonNode* value = NULL;
				JsonObject* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				JsonNode* _tmp5_ = NULL;
				JsonNode* _tmp6_ = NULL;
				gchar* _key = NULL;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				GeeMap* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				JsonNode* _tmp11_ = NULL;
				_tmp3_ = object;
				_tmp4_ = key;
				_tmp5_ = json_object_get_member (_tmp3_, _tmp4_);
				_tmp6_ = __vala_JsonNode_copy0 (_tmp5_);
				value = _tmp6_;
				_tmp7_ = key;
				_tmp8_ = kkc_map_file_uniquify (self, _tmp7_);
				_key = _tmp8_;
				_tmp9_ = map;
				_tmp10_ = _key;
				_tmp11_ = value;
				gee_map_set (_tmp9_, _tmp10_, _tmp11_);
				_g_free0 (_key);
				__vala_JsonNode_free0 (value);
			}
		}
	}
	_g_list_free0 (keys);
}


static gchar* kkc_map_file_real_uniquify (KkcMapFile* self, const gchar* key) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* kkc_map_file_uniquify (KkcMapFile* self, const gchar* key) {
	g_return_val_if_fail (self != NULL, NULL);
	return KKC_MAP_FILE_GET_CLASS (self)->uniquify (self, key);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void kkc_map_file_load (KkcMapFile* self, KkcRuleMetadata* metadata, const gchar* type, const gchar* name, GeeSet* parents, GeeMap* maps, GeeMap* parent_maps, GError** error) {
	gchar* filename = NULL;
	KkcRuleMetadata* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_ = NULL;
	JsonNode* root = NULL;
	JsonParser* _tmp18_ = NULL;
	JsonNode* _tmp19_ = NULL;
	JsonNode* _tmp20_ = NULL;
	JsonNode* _tmp21_ = NULL;
	JsonNodeType _tmp22_ = 0;
	JsonObject* object = NULL;
	JsonNode* _tmp24_ = NULL;
	JsonObject* _tmp25_ = NULL;
	JsonObject* _tmp26_ = NULL;
	JsonNode* member = NULL;
	JsonObject* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	JsonObject* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (parents != NULL);
	g_return_if_fail (maps != NULL);
	g_return_if_fail (parent_maps != NULL);
	_tmp0_ = metadata;
	_tmp1_ = type;
	_tmp2_ = name;
	_tmp3_ = kkc_rule_metadata_locate_map_file (_tmp0_, _tmp1_, _tmp2_);
	filename = _tmp3_;
	if (filename == NULL) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		_tmp4_ = type;
		_tmp5_ = name;
		_tmp6_ = g_error_new (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "can't locate map file for %s/%s", _tmp4_, _tmp5_);
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		} else {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp7_ = json_parser_new ();
	parser = _tmp7_;
	{
		gboolean _tmp8_ = FALSE;
		JsonParser* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = parser;
		_tmp10_ = json_parser_load_from_file (_tmp9_, filename, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		if (!_tmp8_) {
			GError* _tmp11_ = NULL;
			_tmp11_ = g_error_new_literal (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "");
			_inner_error_ = _tmp11_;
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_strdup_printf ("can't load %s: %s", filename, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_error_new_literal (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_inner_error_ = _tmp17_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp18_ = parser;
	_tmp19_ = json_parser_get_root (_tmp18_);
	_tmp20_ = __vala_JsonNode_copy0 (_tmp19_);
	root = _tmp20_;
	_tmp21_ = root;
	_tmp22_ = json_node_get_node_type (_tmp21_);
	if (_tmp22_ != JSON_NODE_OBJECT) {
		GError* _tmp23_ = NULL;
		_tmp23_ = g_error_new_literal (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "root element must be an object");
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp24_ = root;
	_tmp25_ = json_node_get_object (_tmp24_);
	_tmp26_ = _json_object_ref0 (_tmp25_);
	object = _tmp26_;
	_tmp27_ = object;
	_tmp28_ = json_object_has_member (_tmp27_, "include");
	if (_tmp28_) {
		JsonObject* _tmp29_ = NULL;
		JsonNode* _tmp30_ = NULL;
		JsonNode* _tmp31_ = NULL;
		JsonNode* _tmp32_ = NULL;
		JsonNodeType _tmp33_ = 0;
		JsonArray* include = NULL;
		JsonNode* _tmp35_ = NULL;
		JsonArray* _tmp36_ = NULL;
		JsonArray* _tmp37_ = NULL;
		GList* elements = NULL;
		JsonArray* _tmp38_ = NULL;
		GList* _tmp39_ = NULL;
		GList* _tmp40_ = NULL;
		_tmp29_ = object;
		_tmp30_ = json_object_get_member (_tmp29_, "include");
		_tmp31_ = __vala_JsonNode_copy0 (_tmp30_);
		__vala_JsonNode_free0 (member);
		member = _tmp31_;
		_tmp32_ = member;
		_tmp33_ = json_node_get_node_type (_tmp32_);
		if (_tmp33_ != JSON_NODE_ARRAY) {
			GError* _tmp34_ = NULL;
			_tmp34_ = g_error_new_literal (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "\"include\" element must be an array");
			_inner_error_ = _tmp34_;
			if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp35_ = member;
		_tmp36_ = json_node_get_array (_tmp35_);
		_tmp37_ = _json_array_ref0 (_tmp36_);
		include = _tmp37_;
		_tmp38_ = include;
		_tmp39_ = json_array_get_elements (_tmp38_);
		elements = _tmp39_;
		_tmp40_ = elements;
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
			element_collection = _tmp40_;
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
				JsonNode* element = NULL;
				element = (JsonNode*) element_it->data;
				{
					gchar* parent = NULL;
					JsonNode* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					GeeSet* _tmp44_ = NULL;
					const gchar* _tmp45_ = NULL;
					gboolean _tmp46_ = FALSE;
					gchar* parent_rule = NULL;
					gchar* parent_name = NULL;
					gint index = 0;
					const gchar* _tmp49_ = NULL;
					gint _tmp50_ = 0;
					gint _tmp51_ = 0;
					KkcRuleMetadata* parent_metadata = NULL;
					const gchar* _tmp67_ = NULL;
					KkcRuleMetadata* _tmp68_ = NULL;
					KkcRuleMetadata* _tmp69_ = NULL;
					GeeSet* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					KkcRuleMetadata* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					const gchar* _tmp76_ = NULL;
					GeeSet* _tmp77_ = NULL;
					GeeMap* _tmp78_ = NULL;
					GeeMap* _tmp79_ = NULL;
					_tmp41_ = element;
					_tmp42_ = json_node_get_string (_tmp41_);
					_tmp43_ = g_strdup (_tmp42_);
					parent = _tmp43_;
					_tmp44_ = parents;
					_tmp45_ = parent;
					_tmp46_ = gee_collection_contains ((GeeCollection*) _tmp44_, _tmp45_);
					if (_tmp46_) {
						const gchar* _tmp47_ = NULL;
						GError* _tmp48_ = NULL;
						_tmp47_ = parent;
						_tmp48_ = g_error_new (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "found circular include of %s", _tmp47_);
						_inner_error_ = _tmp48_;
						if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp49_ = parent;
					_tmp50_ = string_index_of (_tmp49_, "/", 0);
					index = _tmp50_;
					_tmp51_ = index;
					if (_tmp51_ < 0) {
						KkcRuleMetadata* _tmp52_ = NULL;
						const gchar* _tmp53_ = NULL;
						const gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						const gchar* _tmp56_ = NULL;
						gchar* _tmp57_ = NULL;
						_tmp52_ = metadata;
						_tmp53_ = kkc_metadata_file_get_name ((KkcMetadataFile*) _tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = g_strdup (_tmp54_);
						_g_free0 (parent_rule);
						parent_rule = _tmp55_;
						_tmp56_ = parent;
						_tmp57_ = g_strdup (_tmp56_);
						_g_free0 (parent_name);
						parent_name = _tmp57_;
					} else {
						const gchar* _tmp58_ = NULL;
						gint _tmp59_ = 0;
						gchar* _tmp60_ = NULL;
						const gchar* _tmp61_ = NULL;
						gint _tmp62_ = 0;
						const gchar* _tmp63_ = NULL;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gchar* _tmp66_ = NULL;
						_tmp58_ = parent;
						_tmp59_ = index;
						_tmp60_ = string_slice (_tmp58_, (glong) 0, (glong) _tmp59_);
						_g_free0 (parent_rule);
						parent_rule = _tmp60_;
						_tmp61_ = parent;
						_tmp62_ = index;
						_tmp63_ = parent;
						_tmp64_ = strlen (_tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = string_slice (_tmp61_, (glong) (_tmp62_ + 1), (glong) _tmp65_);
						_g_free0 (parent_name);
						parent_name = _tmp66_;
					}
					_tmp67_ = parent_rule;
					_tmp68_ = kkc_rule_metadata_find (_tmp67_);
					parent_metadata = _tmp68_;
					_tmp69_ = parent_metadata;
					if (_tmp69_ == NULL) {
						const gchar* _tmp70_ = NULL;
						GError* _tmp71_ = NULL;
						_tmp70_ = parent_rule;
						_tmp71_ = g_error_new (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "can't find rule %s", _tmp70_);
						_inner_error_ = _tmp71_;
						if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_object_unref0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp72_ = parents;
					_tmp73_ = parent;
					gee_collection_add ((GeeCollection*) _tmp72_, _tmp73_);
					_tmp74_ = parent_metadata;
					_tmp75_ = type;
					_tmp76_ = parent_name;
					_tmp77_ = parents;
					_tmp78_ = parent_maps;
					_tmp79_ = parent_maps;
					kkc_map_file_load (self, _tmp74_, _tmp75_, _tmp76_, _tmp77_, _tmp78_, _tmp79_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_object_unref0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							_g_list_free0 (elements);
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_g_object_unref0 (parent_metadata);
					_g_free0 (parent_name);
					_g_free0 (parent_rule);
					_g_free0 (parent);
				}
			}
		}
		_g_list_free0 (elements);
		_json_array_unref0 (include);
	}
	_tmp80_ = object;
	_tmp81_ = json_object_has_member (_tmp80_, "define");
	if (_tmp81_) {
		JsonObject* _tmp82_ = NULL;
		JsonNode* _tmp83_ = NULL;
		JsonNode* _tmp84_ = NULL;
		JsonNode* _tmp85_ = NULL;
		JsonNodeType _tmp86_ = 0;
		JsonObject* define = NULL;
		JsonNode* _tmp88_ = NULL;
		JsonObject* _tmp89_ = NULL;
		JsonObject* _tmp90_ = NULL;
		GList* keys = NULL;
		JsonObject* _tmp91_ = NULL;
		GList* _tmp92_ = NULL;
		GList* _tmp93_ = NULL;
		_tmp82_ = object;
		_tmp83_ = json_object_get_member (_tmp82_, "define");
		_tmp84_ = __vala_JsonNode_copy0 (_tmp83_);
		__vala_JsonNode_free0 (member);
		member = _tmp84_;
		_tmp85_ = member;
		_tmp86_ = json_node_get_node_type (_tmp85_);
		if (_tmp86_ != JSON_NODE_OBJECT) {
			GError* _tmp87_ = NULL;
			_tmp87_ = g_error_new_literal (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "\"define\" element must be an object");
			_inner_error_ = _tmp87_;
			if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp88_ = member;
		_tmp89_ = json_node_get_object (_tmp88_);
		_tmp90_ = _json_object_ref0 (_tmp89_);
		define = _tmp90_;
		_tmp91_ = define;
		_tmp92_ = json_object_get_members (_tmp91_);
		keys = _tmp92_;
		_tmp93_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp93_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GeeMap* _tmp94_ = NULL;
					const gchar* _tmp95_ = NULL;
					gboolean _tmp96_ = FALSE;
					JsonObject* _tmp101_ = NULL;
					const gchar* _tmp102_ = NULL;
					JsonNode* _tmp103_ = NULL;
					JsonNode* _tmp104_ = NULL;
					JsonNode* _tmp105_ = NULL;
					JsonNodeType _tmp106_ = 0;
					GeeMap* _tmp108_ = NULL;
					const gchar* _tmp109_ = NULL;
					gpointer _tmp110_ = NULL;
					GeeMap* _tmp111_ = NULL;
					JsonNode* _tmp112_ = NULL;
					JsonObject* _tmp113_ = NULL;
					_tmp94_ = maps;
					_tmp95_ = key;
					_tmp96_ = gee_map_has_key (_tmp94_, _tmp95_);
					if (!_tmp96_) {
						GeeHashMap* map = NULL;
						GeeHashMap* _tmp97_ = NULL;
						GeeMap* _tmp98_ = NULL;
						const gchar* _tmp99_ = NULL;
						GeeHashMap* _tmp100_ = NULL;
						_tmp97_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, _vala_JsonNode_free, NULL, NULL, NULL);
						map = _tmp97_;
						_tmp98_ = maps;
						_tmp99_ = key;
						_tmp100_ = map;
						gee_map_set (_tmp98_, _tmp99_, (GeeMap*) _tmp100_);
						_g_object_unref0 (map);
					}
					_tmp101_ = define;
					_tmp102_ = key;
					_tmp103_ = json_object_get_member (_tmp101_, _tmp102_);
					_tmp104_ = __vala_JsonNode_copy0 (_tmp103_);
					__vala_JsonNode_free0 (member);
					member = _tmp104_;
					_tmp105_ = member;
					_tmp106_ = json_node_get_node_type (_tmp105_);
					if (_tmp106_ != JSON_NODE_OBJECT) {
						GError* _tmp107_ = NULL;
						_tmp107_ = g_error_new_literal (KKC_RULE_PARSE_ERROR, KKC_RULE_PARSE_ERROR_FAILED, "map element must be an object");
						_inner_error_ = _tmp107_;
						if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_list_free0 (keys);
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_g_list_free0 (keys);
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp108_ = maps;
					_tmp109_ = key;
					_tmp110_ = gee_map_get (_tmp108_, _tmp109_);
					_tmp111_ = (GeeMap*) _tmp110_;
					_tmp112_ = member;
					_tmp113_ = json_node_get_object (_tmp112_);
					kkc_map_file_load_map (self, _tmp111_, _tmp113_);
					_g_object_unref0 (_tmp111_);
				}
			}
		}
		_g_list_free0 (keys);
		_json_object_unref0 (define);
	}
	__vala_JsonNode_free0 (member);
	_json_object_unref0 (object);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	_g_free0 (filename);
}


KkcMapFile* kkc_map_file_construct (GType object_type, KkcRuleMetadata* metadata, const gchar* type, const gchar* name, GError** error) {
	KkcMapFile * self = NULL;
	GeeSet* parents = NULL;
	GeeHashSet* _tmp0_ = NULL;
	KkcRuleMetadata* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	GeeMap* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (KkcMapFile*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	parents = (GeeSet*) _tmp0_;
	_tmp1_ = metadata;
	_tmp2_ = type;
	_tmp3_ = name;
	_tmp4_ = self->priv->maps;
	_tmp5_ = self->priv->parent_maps;
	kkc_map_file_load (self, _tmp1_, _tmp2_, _tmp3_, parents, _tmp4_, _tmp5_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parents);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (parents);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (parents);
	return self;
}


GeeMap* kkc_map_file_get (KkcMapFile* self, const gchar* name) {
	GeeMap* result = NULL;
	GeeMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = name;
	_tmp2_ = gee_map_has_key (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GeeMap* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		_tmp3_ = self->priv->maps;
		_tmp4_ = name;
		_tmp5_ = gee_map_get (_tmp3_, _tmp4_);
		result = (GeeMap*) _tmp5_;
		return result;
	}
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, _vala_JsonNode_free, NULL, NULL, NULL);
	result = (GeeMap*) _tmp6_;
	return result;
}


GeeMap* kkc_map_file_get_parent (KkcMapFile* self, const gchar* name) {
	GeeMap* result = NULL;
	GeeMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->parent_maps;
	_tmp1_ = name;
	_tmp2_ = gee_map_has_key (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GeeMap* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		_tmp3_ = self->priv->parent_maps;
		_tmp4_ = name;
		_tmp5_ = gee_map_get (_tmp3_, _tmp4_);
		result = (GeeMap*) _tmp5_;
		return result;
	}
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, _vala_JsonNode_free, NULL, NULL, NULL);
	result = (GeeMap*) _tmp6_;
	return result;
}


static void kkc_map_file_class_init (KkcMapFileClass * klass) {
	kkc_map_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcMapFilePrivate));
	KKC_MAP_FILE_CLASS (klass)->uniquify = kkc_map_file_real_uniquify;
	G_OBJECT_CLASS (klass)->finalize = kkc_map_file_finalize;
}


static void kkc_map_file_instance_init (KkcMapFile * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self->priv = KKC_MAP_FILE_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->maps = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->parent_maps = (GeeMap*) _tmp1_;
}


static void kkc_map_file_finalize (GObject* obj) {
	KkcMapFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_MAP_FILE, KkcMapFile);
	_g_object_unref0 (self->priv->maps);
	_g_object_unref0 (self->priv->parent_maps);
	G_OBJECT_CLASS (kkc_map_file_parent_class)->finalize (obj);
}


GType kkc_map_file_get_type (void) {
	static volatile gsize kkc_map_file_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_map_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcMapFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_map_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcMapFile), 0, (GInstanceInitFunc) kkc_map_file_instance_init, NULL };
		GType kkc_map_file_type_id;
		kkc_map_file_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcMapFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&kkc_map_file_type_id__volatile, kkc_map_file_type_id);
	}
	return kkc_map_file_type_id__volatile;
}



