/* rom-kana-utils.c generated by valac 0.22.1, the Vala compiler
 * generated from rom-kana-utils.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define KKC_TYPE_NUMERIC_CONVERSION_TYPE (kkc_numeric_conversion_type_get_type ())

#define KKC_TYPE_ROM_KANA_UTILS (kkc_rom_kana_utils_get_type ())
#define KKC_ROM_KANA_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_UTILS, KkcRomKanaUtils))
#define KKC_ROM_KANA_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_UTILS, KkcRomKanaUtilsClass))
#define KKC_IS_ROM_KANA_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_UTILS))
#define KKC_IS_ROM_KANA_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_UTILS))
#define KKC_ROM_KANA_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_UTILS, KkcRomKanaUtilsClass))

typedef struct _KkcRomKanaUtils KkcRomKanaUtils;
typedef struct _KkcRomKanaUtilsClass KkcRomKanaUtilsClass;
typedef struct _KkcRomKanaUtilsPrivate KkcRomKanaUtilsPrivate;

#define KKC_ROM_KANA_UTILS_TYPE_KANA_TABLE_ENTRY (kkc_rom_kana_utils_kana_table_entry_get_type ())
typedef struct _KkcRomKanaUtilsKanaTableEntry KkcRomKanaUtilsKanaTableEntry;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

typedef enum  {
	KKC_NUMERIC_CONVERSION_TYPE_LATIN,
	KKC_NUMERIC_CONVERSION_TYPE_WIDE_LATIN,
	KKC_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL,
	KKC_NUMERIC_CONVERSION_TYPE_KANJI,
	KKC_NUMERIC_CONVERSION_TYPE_RECONVERT,
	KKC_NUMERIC_CONVERSION_TYPE_DAIJI,
	KKC_NUMERIC_CONVERSION_TYPE_RESERVED6,
	KKC_NUMERIC_CONVERSION_TYPE_RESERVED7,
	KKC_NUMERIC_CONVERSION_TYPE_GROUPING,
	KKC_NUMERIC_CONVERSION_TYPE_SHOGI
} KkcNumericConversionType;

struct _KkcRomKanaUtils {
	GObject parent_instance;
	KkcRomKanaUtilsPrivate * priv;
};

struct _KkcRomKanaUtilsClass {
	GObjectClass parent_class;
};

struct _KkcRomKanaUtilsKanaTableEntry {
	gunichar katakana;
	gchar* hiragana;
	gchar* hankaku_katakana;
};

struct _Block1Data {
	int _ref_count_;
	GString* builder;
};

struct _Block2Data {
	int _ref_count_;
	GString* builder;
};

struct _Block3Data {
	int _ref_count_;
	GString* builder;
};

typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;


static gpointer kkc_rom_kana_utils_parent_class = NULL;
static GeeMap* kkc_rom_kana_utils__HiraganaTable;
static GeeMap* kkc_rom_kana_utils__HiraganaTable = NULL;
static GeeMap* kkc_rom_kana_utils__KatakanaTable;
static GeeMap* kkc_rom_kana_utils__KatakanaTable = NULL;
static GeeMap* kkc_rom_kana_utils__HankakuKatakanaTable;
static GeeMap* kkc_rom_kana_utils__HankakuKatakanaTable = NULL;
static GeeMap* kkc_rom_kana_utils__CompositionTable;
static GeeMap* kkc_rom_kana_utils__CompositionTable = NULL;
static GeeMap* kkc_rom_kana_utils__WideLatinToLatinTable;
static GeeMap* kkc_rom_kana_utils__WideLatinToLatinTable = NULL;

GType kkc_numeric_conversion_type_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_utils_get_type (void) G_GNUC_CONST;
enum  {
	KKC_ROM_KANA_UTILS_DUMMY_PROPERTY
};
static GType kkc_rom_kana_utils_kana_table_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static KkcRomKanaUtilsKanaTableEntry* kkc_rom_kana_utils_kana_table_entry_dup (const KkcRomKanaUtilsKanaTableEntry* self);
static void kkc_rom_kana_utils_kana_table_entry_free (KkcRomKanaUtilsKanaTableEntry* self);
static void kkc_rom_kana_utils_kana_table_entry_copy (const KkcRomKanaUtilsKanaTableEntry* self, KkcRomKanaUtilsKanaTableEntry* dest);
static void kkc_rom_kana_utils_kana_table_entry_destroy (KkcRomKanaUtilsKanaTableEntry* self);
static gchar* kkc_rom_kana_utils_get_okurigana_prefix_for_char (gunichar uc);
gchar* kkc_rom_kana_utils_get_okurigana_prefix (const gchar* okurigana);
gunichar kkc_rom_kana_utils_get_wide_latin_char (gunichar uc);
gchar* kkc_rom_kana_utils_get_wide_latin (const gchar* latin);
gchar* kkc_rom_kana_utils_get_latin (const gchar* wide_latin);
gchar* kkc_rom_kana_utils_normalize (const gchar* input);
gchar* kkc_rom_kana_utils_get_hiragana (const gchar* kana);
static gunichar kkc_rom_kana_utils_get_katakana_char (gunichar uc);
static void kkc_rom_kana_utils_foreach_katakana (const gchar* kana, GFunc func, void* func_target);
gchar* kkc_rom_kana_utils_get_katakana (const gchar* kana);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_, gunichar uc);
static void ___lambda5__gfunc (gconstpointer data, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_, gunichar uc);
static void ___lambda4__gfunc (gconstpointer data, gpointer self);
gchar* kkc_rom_kana_utils_get_hankaku_katakana (const gchar* kana);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_, gunichar uc);
static void ___lambda6__gfunc (gconstpointer data, gpointer self);
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
gchar* kkc_rom_kana_utils_convert_by_kana_mode (const gchar* str, KkcKanaMode mode);
static gchar* kkc_rom_kana_utils_get_kanji_numeric (gint numeric, gchar** num_table, int num_table_length1, gchar** num_pos_table, int num_pos_table_length1);
gchar* kkc_rom_kana_utils_get_numeric (gint numeric, KkcNumericConversionType type);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
gboolean kkc_rom_kana_utils_is_katakana (const gchar* str);
gboolean kkc_rom_kana_utils_is_hiragana (const gchar* str);
KkcRomKanaUtils* kkc_rom_kana_utils_construct (GType object_type);
static void kkc_rom_kana_utils_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const KkcRomKanaUtilsKanaTableEntry KKC_ROM_KANA_UTILS_KanaTable[92] = {{12450U, "あ", "ｱ"}, {12452U, "い", "ｲ"}, {12454U, "う", "ｳ"}, {12456U, "え", "ｴ"}, {12458U, "お", "ｵ"}, {12459U, "か", "ｶ"}, {12461U, "き", "ｷ"}, {12463U, "く", "ｸ"}, {12465U, "け", "ｹ"}, {12467U, "こ", "ｺ"}, {12469U, "さ", "ｻ"}, {12471U, "し", "ｼ"}, {12473U, "す", "ｽ"}, {12475U, "せ", "ｾ"}, {12477U, "そ", "ｿ"}, {12479U, "た", "ﾀ"}, {12481U, "ち", "ﾁ"}, {12484U, "つ", "ﾂ"}, {12486U, "て", "ﾃ"}, {12488U, "と", "ﾄ"}, {12490U, "な", "ﾅ"}, {12491U, "に", "ﾆ"}, {12492U, "ぬ", "ﾇ"}, {12493U, "ね", "ﾈ"}, {12494U, "の", "ﾉ"}, {12495U, "は", "ﾊ"}, {12498U, "ひ", "ﾋ"}, {12501U, "ふ", "ﾌ"}, {12504U, "へ", "ﾍ"}, {12507U, "ほ", "ﾎ"}, {12510U, "ま", "ﾏ"}, {12511U, "み", "ﾐ"}, {12512U, "む", "ﾑ"}, {12513U, "め", "ﾒ"}, {12514U, "も", "ﾓ"}, {12516U, "や", "ﾔ"}, {12518U, "ゆ", "ﾕ"}, {12520U, "よ", "ﾖ"}, {12521U, "ら", "ﾗ"}, {12522U, "り", "ﾘ"}, {12523U, "る", "ﾙ"}, {12524U, "れ", "ﾚ"}, {12525U, "ろ", "ﾛ"}, {12527U, "わ", "ﾜ"}, {12528U, "ゐ", "ｲ"}, {12529U, "ゑ", "ｴ"}, {12530U, "を", "ｦ"}, {12531U, "ん", "ﾝ"}, {12460U, "が", "ｶﾞ"}, {12462U, "ぎ", "ｷﾞ"}, {12464U, "ぐ", "ｸﾞ"}, {12466U, "げ", "ｹﾞ"}, {12468U, "ご", "ｺﾞ"}, {12470U, "ざ", "ｻﾞ"}, {12472U, "じ", "ｼﾞ"}, {12474U, "ず", "ｽﾞ"}, {12476U, "ぜ", "ｾﾞ"}, {12478U, "ぞ", "ｿﾞ"}, {12480U, "だ", "ﾀﾞ"}, {12482U, "ぢ", "ﾁﾞ"}, {12485U, "づ", "ﾂﾞ"}, {12487U, "で", "ﾃﾞ"}, {12489U, "ど", "ﾄﾞ"}, {12496U, "ば", "ﾊﾞ"}, {12499U, "び", "ﾋﾞ"}, {12502U, "ぶ", "ﾌﾞ"}, {12505U, "べ", "ﾍﾞ"}, {12508U, "ぼ", "ﾎﾞ"}, {12497U, "ぱ", "ﾊﾟ"}, {12500U, "ぴ", "ﾋﾟ"}, {12503U, "ぷ", "ﾌﾟ"}, {12506U, "ぺ", "ﾍﾟ"}, {12509U, "ぽ", "ﾎﾟ"}, {12449U, "ぁ", "ｧ"}, {12451U, "ぃ", "ｨ"}, {12453U, "ぅ", "ｩ"}, {12455U, "ぇ", "ｪ"}, {12457U, "ぉ", "ｫ"}, {12483U, "っ", "ｯ"}, {12515U, "ゃ", "ｬ"}, {12517U, "ゅ", "ｭ"}, {12519U, "ょ", "ｮ"}, {12526U, "ゎ", NULL}, {12532U, "う゛", "ｳﾞ"}, {12533U, NULL, NULL}, {12534U, NULL, NULL}, {12290U, "。", "｡"}, {12300U, "「", "｢"}, {12301U, "」", "｣"}, {12289U, "、", "､"}, {12539U, "・", "･"}, {12540U, "ー", "ｰ"}};
static const KkcRomKanaUtilsKanaTableEntry KKC_ROM_KANA_UTILS_HankakuKatakanaSubstitute[3] = {{12526U, NULL, "ﾜ"}, {12533U, NULL, "ｶ"}, {12534U, NULL, "ｹ"}};
static const gchar* KKC_ROM_KANA_UTILS_WideLatinTable[95] = {"　", "！", "”", "＃", "＄", "％", "＆", "’", "（", "）", "＊", "＋", "，", "−", "．", "／", "０", "１", "２", "３", "４", "５", "６", "７", "８", "９", "：", "；", "＜", "＝", "＞", "？", "＠", "Ａ", "Ｂ", "Ｃ", "Ｄ", "Ｅ", "Ｆ", "Ｇ", "Ｈ", "Ｉ", "Ｊ", "Ｋ", "Ｌ", "Ｍ", "Ｎ", "Ｏ", "Ｐ", "Ｑ", "Ｒ", "Ｓ", "Ｔ", "Ｕ", "Ｖ", "Ｗ", "Ｘ", "Ｙ", "Ｚ", "［", "＼", "］", "＾", "＿", "‘", "ａ", "ｂ", "ｃ", "ｄ", "ｅ", "ｆ", "ｇ", "ｈ", "ｉ", "ｊ", "ｋ", "ｌ", "ｍ", "ｎ", "ｏ", "ｐ", "ｑ", "ｒ", "ｓ", "ｔ", "ｕ", "ｖ", "ｗ", "ｘ", "ｙ", "ｚ", "｛", "｜", "｝", "〜"};
static const gchar* KKC_ROM_KANA_UTILS_KanaRomTable[83] = {"x", "a", "x", "i", "x", "u", "x", "e", "x", "o", "k", "g", "k", "g", "k", "g", "k", "g", "k", "g", "s", "z", "s", "z", "s", "z", "s", "z", "s", "z", "t", "d", "t", "d", "t", "t", "d", "t", "d", "t", "d", "n", "n", "n", "n", "n", "h", "b", "p", "h", "b", "p", "h", "b", "p", "h", "b", "p", "h", "b", "p", "m", "m", "m", "m", "m", "x", "y", "x", "y", "x", "y", "r", "r", "r", "r", "r", "x", "w", "x", "x", "w", "n"};
static const gchar* KKC_ROM_KANA_UTILS_KanjiNumericTable[10] = {"〇", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
static const gchar* KKC_ROM_KANA_UTILS_DaijiNumericTable[10] = {"零", "壱", "弐", "参", "四", "伍", "六", "七", "八", "九"};
static const gchar* KKC_ROM_KANA_UTILS_KanjiNumericalPositionTable[18] = {NULL, "十", "百", "千", "万", NULL, NULL, NULL, "億", NULL, NULL, NULL, "兆", NULL, NULL, NULL, NULL, "京"};
static const gchar* KKC_ROM_KANA_UTILS_DaijiNumericalPositionTable[18] = {NULL, "拾", "百", "阡", "萬", NULL, NULL, NULL, "億", NULL, NULL, NULL, "兆", NULL, NULL, NULL, NULL, "京"};

GType kkc_numeric_conversion_type_get_type (void) {
	static volatile gsize kkc_numeric_conversion_type_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_numeric_conversion_type_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_NUMERIC_CONVERSION_TYPE_LATIN, "KKC_NUMERIC_CONVERSION_TYPE_LATIN", "latin"}, {KKC_NUMERIC_CONVERSION_TYPE_WIDE_LATIN, "KKC_NUMERIC_CONVERSION_TYPE_WIDE_LATIN", "wide-latin"}, {KKC_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL, "KKC_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL", "kanji-numeral"}, {KKC_NUMERIC_CONVERSION_TYPE_KANJI, "KKC_NUMERIC_CONVERSION_TYPE_KANJI", "kanji"}, {KKC_NUMERIC_CONVERSION_TYPE_RECONVERT, "KKC_NUMERIC_CONVERSION_TYPE_RECONVERT", "reconvert"}, {KKC_NUMERIC_CONVERSION_TYPE_DAIJI, "KKC_NUMERIC_CONVERSION_TYPE_DAIJI", "daiji"}, {KKC_NUMERIC_CONVERSION_TYPE_RESERVED6, "KKC_NUMERIC_CONVERSION_TYPE_RESERVED6", "reserved6"}, {KKC_NUMERIC_CONVERSION_TYPE_RESERVED7, "KKC_NUMERIC_CONVERSION_TYPE_RESERVED7", "reserved7"}, {KKC_NUMERIC_CONVERSION_TYPE_GROUPING, "KKC_NUMERIC_CONVERSION_TYPE_GROUPING", "grouping"}, {KKC_NUMERIC_CONVERSION_TYPE_SHOGI, "KKC_NUMERIC_CONVERSION_TYPE_SHOGI", "shogi"}, {0, NULL, NULL}};
		GType kkc_numeric_conversion_type_type_id;
		kkc_numeric_conversion_type_type_id = g_enum_register_static ("KkcNumericConversionType", values);
		g_once_init_leave (&kkc_numeric_conversion_type_type_id__volatile, kkc_numeric_conversion_type_type_id);
	}
	return kkc_numeric_conversion_type_type_id__volatile;
}


static gchar* kkc_rom_kana_utils_get_okurigana_prefix_for_char (gunichar uc) {
	gchar* result = NULL;
	gunichar _tmp0_ = 0U;
	_tmp0_ = uc;
	if (_tmp0_ == 12435U) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("n");
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		gunichar _tmp3_ = 0U;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = uc;
		if (_tmp3_ < 12353U) {
			_tmp2_ = TRUE;
		} else {
			gunichar _tmp4_ = 0U;
			_tmp4_ = uc;
			_tmp2_ = _tmp4_ > 12435U;
		}
		_tmp5_ = _tmp2_;
		if (_tmp5_) {
			result = NULL;
			return result;
		} else {
			gunichar _tmp6_ = 0U;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp6_ = uc;
			_tmp7_ = KKC_ROM_KANA_UTILS_KanaRomTable[_tmp6_ - 12353U];
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
	}
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gchar* kkc_rom_kana_utils_get_okurigana_prefix (const gchar* okurigana) {
	gchar* result = NULL;
	gunichar head = 0U;
	const gchar* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp3_ = 0U;
	gboolean _tmp5_ = FALSE;
	gunichar _tmp11_ = 0U;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (okurigana != NULL, NULL);
	_tmp0_ = okurigana;
	_tmp1_ = string_get_char (_tmp0_, (glong) 0);
	head = _tmp1_;
	_tmp3_ = head;
	if (_tmp3_ == 12387U) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = okurigana;
		_tmp2_ = g_strcmp0 (_tmp4_, "っ") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		gint index = 0;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gunichar _tmp10_ = 0U;
		_tmp6_ = okurigana;
		_tmp7_ = string_index_of_nth_char (_tmp6_, (glong) 1);
		index = _tmp7_;
		_tmp8_ = okurigana;
		_tmp9_ = index;
		_tmp10_ = string_get_char (_tmp8_, (glong) _tmp9_);
		head = _tmp10_;
	}
	_tmp11_ = head;
	_tmp12_ = kkc_rom_kana_utils_get_okurigana_prefix_for_char (_tmp11_);
	result = _tmp12_;
	return result;
}


gunichar kkc_rom_kana_utils_get_wide_latin_char (gunichar uc) {
	gunichar result = 0U;
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_ = 0U;
	gboolean _tmp3_ = FALSE;
	gunichar _tmp7_ = 0U;
	_tmp1_ = uc;
	if (((gunichar) 0x20) <= _tmp1_) {
		gunichar _tmp2_ = 0U;
		_tmp2_ = uc;
		_tmp0_ = _tmp2_ <= ((gunichar) 0x7E);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gunichar _tmp4_ = 0U;
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		_tmp4_ = uc;
		_tmp5_ = KKC_ROM_KANA_UTILS_WideLatinTable[_tmp4_ - 32];
		_tmp6_ = string_get_char (_tmp5_, (glong) 0);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = uc;
	result = _tmp7_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gchar* kkc_rom_kana_utils_get_wide_latin (const gchar* latin) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gint index = 0;
	gunichar uc = 0U;
	GString* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	g_return_val_if_fail (latin != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		GString* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gunichar _tmp6_ = 0U;
		_tmp1_ = latin;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = builder;
		_tmp5_ = uc;
		_tmp6_ = kkc_rom_kana_utils_get_wide_latin_char (_tmp5_);
		g_string_append_unichar (_tmp4_, _tmp6_);
	}
	_tmp7_ = builder;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (builder);
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* kkc_rom_kana_utils_get_latin (const gchar* wide_latin) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gint index = 0;
	gunichar uc = 0U;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (wide_latin != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		gchar* str = NULL;
		gunichar _tmp4_ = 0U;
		gchar* _tmp5_ = NULL;
		GeeMap* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp1_ = wide_latin;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = uc;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		str = _tmp5_;
		_tmp6_ = kkc_rom_kana_utils__WideLatinToLatinTable;
		_tmp7_ = str;
		_tmp8_ = gee_map_has_key (_tmp6_, _tmp7_);
		if (_tmp8_) {
			GString* _tmp9_ = NULL;
			GeeMap* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			_tmp9_ = builder;
			_tmp10_ = kkc_rom_kana_utils__WideLatinToLatinTable;
			_tmp11_ = str;
			_tmp12_ = gee_map_get (_tmp10_, _tmp11_);
			g_string_append_c (_tmp9_, (gchar) ((gintptr) _tmp12_));
		} else {
			GString* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp13_ = builder;
			_tmp14_ = str;
			g_string_append (_tmp13_, _tmp14_);
		}
		_g_free0 (str);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


gchar* kkc_rom_kana_utils_normalize (const gchar* input) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = kkc_rom_kana_utils_get_hiragana (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_rom_kana_utils_get_latin (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gunichar kkc_rom_kana_utils_get_katakana_char (gunichar uc) {
	gunichar result = 0U;
	GeeMap* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp6_ = 0U;
	_tmp0_ = kkc_rom_kana_utils__KatakanaTable;
	_tmp1_ = uc;
	_tmp2_ = gee_map_has_key (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeMap* _tmp3_ = NULL;
		gunichar _tmp4_ = 0U;
		gpointer _tmp5_ = NULL;
		_tmp3_ = kkc_rom_kana_utils__KatakanaTable;
		_tmp4_ = uc;
		_tmp5_ = gee_map_get (_tmp3_, (gpointer) ((gintptr) _tmp4_));
		result = (gunichar) ((gintptr) _tmp5_);
		return result;
	}
	_tmp6_ = uc;
	result = _tmp6_;
	return result;
}


static void kkc_rom_kana_utils_foreach_katakana (const gchar* kana, GFunc func, void* func_target) {
	gint index = 0;
	gunichar uc0 = 0U;
	g_return_if_fail (kana != NULL);
	index = 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		GeeMap* _tmp3_ = NULL;
		gunichar _tmp4_ = 0U;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = kana;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		uc0 = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = kkc_rom_kana_utils__CompositionTable;
		_tmp4_ = uc0;
		_tmp5_ = gee_map_has_key (_tmp3_, (gpointer) ((gintptr) _tmp4_));
		if (_tmp5_) {
			GeeMap* composition = NULL;
			GeeMap* _tmp6_ = NULL;
			gunichar _tmp7_ = 0U;
			gpointer _tmp8_ = NULL;
			gunichar uc1 = 0U;
			const gchar* _tmp9_ = NULL;
			gunichar _tmp10_ = 0U;
			gboolean _tmp11_ = FALSE;
			_tmp6_ = kkc_rom_kana_utils__CompositionTable;
			_tmp7_ = uc0;
			_tmp8_ = gee_map_get (_tmp6_, (gpointer) ((gintptr) _tmp7_));
			composition = (GeeMap*) _tmp8_;
			_tmp9_ = kana;
			_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
			uc1 = _tmp10_;
			if (_tmp11_) {
				GeeMap* _tmp12_ = NULL;
				gunichar _tmp13_ = 0U;
				gboolean _tmp14_ = FALSE;
				_tmp12_ = composition;
				_tmp13_ = uc1;
				_tmp14_ = gee_map_has_key (_tmp12_, (gpointer) ((gintptr) _tmp13_));
				if (_tmp14_) {
					GFunc _tmp15_ = NULL;
					void* _tmp15__target = NULL;
					GeeMap* _tmp16_ = NULL;
					gunichar _tmp17_ = 0U;
					gpointer _tmp18_ = NULL;
					_tmp15_ = func;
					_tmp15__target = func_target;
					_tmp16_ = composition;
					_tmp17_ = uc1;
					_tmp18_ = gee_map_get (_tmp16_, (gpointer) ((gintptr) _tmp17_));
					_tmp15_ ((gpointer) ((gintptr) ((gunichar) ((gintptr) _tmp18_))), _tmp15__target);
				} else {
					GFunc _tmp19_ = NULL;
					void* _tmp19__target = NULL;
					gunichar _tmp20_ = 0U;
					gunichar _tmp21_ = 0U;
					GFunc _tmp22_ = NULL;
					void* _tmp22__target = NULL;
					gunichar _tmp23_ = 0U;
					gunichar _tmp24_ = 0U;
					_tmp19_ = func;
					_tmp19__target = func_target;
					_tmp20_ = uc0;
					_tmp21_ = kkc_rom_kana_utils_get_katakana_char (_tmp20_);
					_tmp19_ ((gpointer) ((gintptr) _tmp21_), _tmp19__target);
					_tmp22_ = func;
					_tmp22__target = func_target;
					_tmp23_ = uc1;
					_tmp24_ = kkc_rom_kana_utils_get_katakana_char (_tmp23_);
					_tmp22_ ((gpointer) ((gintptr) _tmp24_), _tmp22__target);
				}
			} else {
				GFunc _tmp25_ = NULL;
				void* _tmp25__target = NULL;
				gunichar _tmp26_ = 0U;
				gunichar _tmp27_ = 0U;
				_tmp25_ = func;
				_tmp25__target = func_target;
				_tmp26_ = uc0;
				_tmp27_ = kkc_rom_kana_utils_get_katakana_char (_tmp26_);
				_tmp25_ ((gpointer) ((gintptr) _tmp27_), _tmp25__target);
				_g_object_unref0 (composition);
				break;
			}
			_g_object_unref0 (composition);
		} else {
			GFunc _tmp28_ = NULL;
			void* _tmp28__target = NULL;
			gunichar _tmp29_ = 0U;
			gunichar _tmp30_ = 0U;
			_tmp28_ = func;
			_tmp28__target = func_target;
			_tmp29_ = uc0;
			_tmp30_ = kkc_rom_kana_utils_get_katakana_char (_tmp29_);
			_tmp28_ ((gpointer) ((gintptr) _tmp30_), _tmp28__target);
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_string_free0 (_data1_->builder);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda5_ (Block1Data* _data1_, gunichar uc) {
	gunichar _tmp0_ = 0U;
	_tmp0_ = uc;
	g_string_append_unichar (_data1_->builder, _tmp0_);
}


static void ___lambda5__gfunc (gconstpointer data, gpointer self) {
	__lambda5_ (self, data);
}


gchar* kkc_rom_kana_utils_get_katakana (const gchar* kana) {
	gchar* result = NULL;
	Block1Data* _data1_;
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (kana != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data1_->builder = _tmp0_;
	_tmp1_ = kana;
	kkc_rom_kana_utils_foreach_katakana (_tmp1_, ___lambda5__gfunc, _data1_);
	_tmp2_ = _data1_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_string_free0 (_data2_->builder);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda4_ (Block2Data* _data2_, gunichar uc) {
	GeeMap* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = kkc_rom_kana_utils__HiraganaTable;
	_tmp1_ = uc;
	_tmp2_ = gee_map_has_key (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeMap* _tmp3_ = NULL;
		gunichar _tmp4_ = 0U;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp3_ = kkc_rom_kana_utils__HiraganaTable;
		_tmp4_ = uc;
		_tmp5_ = gee_map_get (_tmp3_, (gpointer) ((gintptr) _tmp4_));
		_tmp6_ = (gchar*) _tmp5_;
		g_string_append (_data2_->builder, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		gunichar _tmp7_ = 0U;
		_tmp7_ = uc;
		g_string_append_unichar (_data2_->builder, _tmp7_);
	}
}


static void ___lambda4__gfunc (gconstpointer data, gpointer self) {
	__lambda4_ (self, data);
}


gchar* kkc_rom_kana_utils_get_hiragana (const gchar* kana) {
	gchar* result = NULL;
	Block2Data* _data2_;
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (kana != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data2_->builder = _tmp0_;
	_tmp1_ = kana;
	kkc_rom_kana_utils_foreach_katakana (_tmp1_, ___lambda4__gfunc, _data2_);
	_tmp2_ = _data2_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_string_free0 (_data3_->builder);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda6_ (Block3Data* _data3_, gunichar uc) {
	GeeMap* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = kkc_rom_kana_utils__HankakuKatakanaTable;
	_tmp1_ = uc;
	_tmp2_ = gee_map_has_key (_tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeMap* _tmp3_ = NULL;
		gunichar _tmp4_ = 0U;
		gpointer _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp3_ = kkc_rom_kana_utils__HankakuKatakanaTable;
		_tmp4_ = uc;
		_tmp5_ = gee_map_get (_tmp3_, (gpointer) ((gintptr) _tmp4_));
		_tmp6_ = (gchar*) _tmp5_;
		g_string_append (_data3_->builder, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		gunichar _tmp7_ = 0U;
		_tmp7_ = uc;
		g_string_append_unichar (_data3_->builder, _tmp7_);
	}
}


static void ___lambda6__gfunc (gconstpointer data, gpointer self) {
	__lambda6_ (self, data);
}


gchar* kkc_rom_kana_utils_get_hankaku_katakana (const gchar* kana) {
	gchar* result = NULL;
	Block3Data* _data3_;
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (kana != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_string_new ("");
	_data3_->builder = _tmp0_;
	_tmp1_ = kana;
	kkc_rom_kana_utils_foreach_katakana (_tmp1_, ___lambda6__gfunc, _data3_);
	_tmp2_ = _data3_->builder->str;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


gchar* kkc_rom_kana_utils_convert_by_kana_mode (const gchar* str, KkcKanaMode mode) {
	gchar* result = NULL;
	KkcKanaMode _tmp0_ = 0;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		case KKC_KANA_MODE_HIRAGANA:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_ = NULL;
			_tmp1_ = str;
			_tmp2_ = kkc_rom_kana_utils_get_hiragana (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case KKC_KANA_MODE_KATAKANA:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			_tmp3_ = str;
			_tmp4_ = kkc_rom_kana_utils_get_katakana (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case KKC_KANA_MODE_HANKAKU_KATAKANA:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp5_ = str;
			_tmp6_ = kkc_rom_kana_utils_get_hankaku_katakana (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case KKC_KANA_MODE_LATIN:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp7_ = str;
			_tmp8_ = kkc_rom_kana_utils_get_latin (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case KKC_KANA_MODE_WIDE_LATIN:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp9_ = str;
			_tmp10_ = kkc_rom_kana_utils_get_wide_latin (_tmp9_);
			result = _tmp10_;
			return result;
		}
		default:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp11_ = str;
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
	}
}


static gchar* kkc_rom_kana_utils_get_kanji_numeric (gint numeric, gchar** num_table, int num_table_length1, gchar** num_pos_table, int num_pos_table_length1) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gchar* str = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gunichar uc = 0U;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = numeric;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	str = _tmp2_;
	_tmp3_ = num_pos_table;
	_tmp3__length1 = num_pos_table_length1;
	if (_tmp3_ == NULL) {
		GString* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gboolean _tmp5_ = FALSE;
					const gchar* _tmp6_ = NULL;
					gunichar _tmp7_ = 0U;
					gboolean _tmp8_ = FALSE;
					GString* _tmp9_ = NULL;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gunichar _tmp11_ = 0U;
					const gchar* _tmp12_ = NULL;
					_tmp5_ = _tmp4_;
					if (!_tmp5_) {
					}
					_tmp4_ = FALSE;
					_tmp6_ = str;
					_tmp8_ = string_get_next_char (_tmp6_, &index, &_tmp7_);
					uc = _tmp7_;
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = builder;
					_tmp10_ = num_table;
					_tmp10__length1 = num_table_length1;
					_tmp11_ = uc;
					_tmp12_ = _tmp10_[_tmp11_ - '0'];
					g_string_append (_tmp9_, _tmp12_);
				}
			}
		}
		_tmp13_ = builder;
		_tmp14_ = _tmp13_->str;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		_g_free0 (str);
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp18_ = NULL;
					gunichar _tmp19_ = 0U;
					gboolean _tmp20_ = FALSE;
					gunichar _tmp21_ = 0U;
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
					}
					_tmp16_ = FALSE;
					_tmp18_ = str;
					_tmp20_ = string_get_next_char (_tmp18_, &index, &_tmp19_);
					uc = _tmp19_;
					if (!_tmp20_) {
						break;
					}
					_tmp21_ = uc;
					if (_tmp21_ > ((gunichar) '0')) {
						gint pos_index = 0;
						const gchar* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
						gint _tmp25_ = 0;
						gboolean _tmp26_ = FALSE;
						gunichar _tmp27_ = 0U;
						gboolean _tmp29_ = FALSE;
						gchar* pos = NULL;
						gchar** _tmp33_ = NULL;
						gint _tmp33__length1 = 0;
						gint _tmp34_ = 0;
						const gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						gboolean _tmp37_ = FALSE;
						const gchar* _tmp38_ = NULL;
						gboolean _tmp40_ = FALSE;
						const gchar* _tmp45_ = NULL;
						_tmp22_ = str;
						_tmp23_ = strlen (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = index;
						pos_index = _tmp24_ - _tmp25_;
						_tmp27_ = uc;
						if (_tmp27_ != ((gunichar) '1')) {
							_tmp26_ = TRUE;
						} else {
							gint _tmp28_ = 0;
							_tmp28_ = pos_index;
							_tmp26_ = (_tmp28_ % 4) == 0;
						}
						_tmp29_ = _tmp26_;
						if (_tmp29_) {
							GString* _tmp30_ = NULL;
							gunichar _tmp31_ = 0U;
							const gchar* _tmp32_ = NULL;
							_tmp30_ = builder;
							_tmp31_ = uc;
							_tmp32_ = KKC_ROM_KANA_UTILS_KanjiNumericTable[_tmp31_ - '0'];
							g_string_append (_tmp30_, _tmp32_);
						}
						_tmp33_ = num_pos_table;
						_tmp33__length1 = num_pos_table_length1;
						_tmp34_ = pos_index;
						_tmp35_ = _tmp33_[_tmp34_];
						_tmp36_ = g_strdup (_tmp35_);
						pos = _tmp36_;
						_tmp38_ = pos;
						if (_tmp38_ == NULL) {
							gint _tmp39_ = 0;
							_tmp39_ = pos_index;
							_tmp37_ = (_tmp39_ % 4) > 0;
						} else {
							_tmp37_ = FALSE;
						}
						_tmp40_ = _tmp37_;
						if (_tmp40_) {
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							gint _tmp42_ = 0;
							const gchar* _tmp43_ = NULL;
							gchar* _tmp44_ = NULL;
							_tmp41_ = num_pos_table;
							_tmp41__length1 = num_pos_table_length1;
							_tmp42_ = pos_index;
							_tmp43_ = _tmp41_[_tmp42_ % 4];
							_tmp44_ = g_strdup (_tmp43_);
							_g_free0 (pos);
							pos = _tmp44_;
						}
						_tmp45_ = pos;
						if (_tmp45_ != NULL) {
							GString* _tmp46_ = NULL;
							const gchar* _tmp47_ = NULL;
							_tmp46_ = builder;
							_tmp47_ = pos;
							g_string_append (_tmp46_, _tmp47_);
						}
						_g_free0 (pos);
					}
				}
			}
		}
		_tmp48_ = builder;
		_tmp49_ = _tmp48_->str;
		_tmp50_ = g_strdup (_tmp49_);
		result = _tmp50_;
		_g_free0 (str);
		_g_string_free0 (builder);
		return result;
	}
	_g_free0 (str);
	_g_string_free0 (builder);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* kkc_rom_kana_utils_get_numeric (gint numeric, KkcNumericConversionType type) {
	gchar* result = NULL;
	KkcNumericConversionType _tmp0_ = 0;
	gchar* _tmp43_ = NULL;
	_tmp0_ = type;
	switch (_tmp0_) {
		case KKC_NUMERIC_CONVERSION_TYPE_LATIN:
		{
			gint _tmp1_ = 0;
			gchar* _tmp2_ = NULL;
			_tmp1_ = numeric;
			_tmp2_ = g_strdup_printf ("%i", _tmp1_);
			result = _tmp2_;
			return result;
		}
		case KKC_NUMERIC_CONVERSION_TYPE_WIDE_LATIN:
		{
			gint _tmp3_ = 0;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp3_ = numeric;
			_tmp4_ = g_strdup_printf ("%i", _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = kkc_rom_kana_utils_get_wide_latin (_tmp5_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			result = _tmp7_;
			return result;
		}
		case KKC_NUMERIC_CONVERSION_TYPE_KANJI_NUMERAL:
		{
			gint _tmp8_ = 0;
			gchar* _tmp9_ = NULL;
			_tmp8_ = numeric;
			_tmp9_ = kkc_rom_kana_utils_get_kanji_numeric (_tmp8_, KKC_ROM_KANA_UTILS_KanjiNumericTable, G_N_ELEMENTS (KKC_ROM_KANA_UTILS_KanjiNumericTable), NULL, 0);
			result = _tmp9_;
			return result;
		}
		case KKC_NUMERIC_CONVERSION_TYPE_KANJI:
		{
			gint _tmp10_ = 0;
			gchar* _tmp11_ = NULL;
			_tmp10_ = numeric;
			_tmp11_ = kkc_rom_kana_utils_get_kanji_numeric (_tmp10_, KKC_ROM_KANA_UTILS_KanjiNumericTable, G_N_ELEMENTS (KKC_ROM_KANA_UTILS_KanjiNumericTable), KKC_ROM_KANA_UTILS_KanjiNumericalPositionTable, G_N_ELEMENTS (KKC_ROM_KANA_UTILS_KanjiNumericalPositionTable));
			result = _tmp11_;
			return result;
		}
		case KKC_NUMERIC_CONVERSION_TYPE_DAIJI:
		{
			gint _tmp12_ = 0;
			gchar* _tmp13_ = NULL;
			_tmp12_ = numeric;
			_tmp13_ = kkc_rom_kana_utils_get_kanji_numeric (_tmp12_, KKC_ROM_KANA_UTILS_DaijiNumericTable, G_N_ELEMENTS (KKC_ROM_KANA_UTILS_DaijiNumericTable), KKC_ROM_KANA_UTILS_DaijiNumericalPositionTable, G_N_ELEMENTS (KKC_ROM_KANA_UTILS_DaijiNumericalPositionTable));
			result = _tmp13_;
			return result;
		}
		case KKC_NUMERIC_CONVERSION_TYPE_GROUPING:
		{
			gchar* str = NULL;
			gint _tmp14_ = 0;
			gchar* _tmp15_ = NULL;
			gchar** strv = NULL;
			gchar** _tmp16_ = NULL;
			gint strv_length1 = 0;
			gint _strv_size_ = 0;
			gint length = 0;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint start = 0;
			gint _tmp19_ = 0;
			gint offset = 0;
			gint _tmp20_ = 0;
			gchar** _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gchar* _tmp42_ = NULL;
			_tmp14_ = numeric;
			_tmp15_ = g_strdup_printf ("%i", _tmp14_);
			str = _tmp15_;
			_tmp16_ = g_new0 (gchar*, 0 + 1);
			strv = _tmp16_;
			strv_length1 = 0;
			_strv_size_ = strv_length1;
			_tmp17_ = str;
			_tmp18_ = g_utf8_strlen (_tmp17_, (gssize) (-1));
			length = _tmp18_;
			_tmp19_ = length;
			start = _tmp19_ % 3;
			offset = 0;
			_tmp20_ = start;
			if (_tmp20_ > 0) {
				const gchar* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				const gchar* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gchar* _tmp27_ = NULL;
				_tmp21_ = str;
				_tmp22_ = start;
				_tmp23_ = string_index_of_nth_char (_tmp21_, (glong) _tmp22_);
				offset = _tmp23_;
				_tmp24_ = strv;
				_tmp24__length1 = strv_length1;
				_tmp25_ = str;
				_tmp26_ = offset;
				_tmp27_ = string_substring (_tmp25_, (glong) 0, (glong) _tmp26_);
				_vala_array_add3 (&strv, &strv_length1, &_strv_size_, _tmp27_);
			}
			while (TRUE) {
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint next_offset = 0;
				const gchar* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				const gchar* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gchar* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				_tmp28_ = start;
				_tmp29_ = length;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = str;
				_tmp31_ = start;
				_tmp32_ = string_index_of_nth_char (_tmp30_, (glong) (_tmp31_ + 3));
				next_offset = _tmp32_;
				_tmp33_ = strv;
				_tmp33__length1 = strv_length1;
				_tmp34_ = str;
				_tmp35_ = offset;
				_tmp36_ = next_offset;
				_tmp37_ = offset;
				_tmp38_ = string_substring (_tmp34_, (glong) _tmp35_, (glong) (_tmp36_ - _tmp37_));
				_vala_array_add4 (&strv, &strv_length1, &_strv_size_, _tmp38_);
				_tmp39_ = next_offset;
				offset = _tmp39_;
				_tmp40_ = start;
				start = _tmp40_ + 3;
			}
			_tmp41_ = strv;
			_tmp41__length1 = strv_length1;
			_tmp42_ = g_strjoinv (",", _tmp41_);
			result = _tmp42_;
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (str);
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp43_ = g_strdup ("");
	result = _tmp43_;
	return result;
}


gboolean kkc_rom_kana_utils_is_katakana (const gchar* str) {
	gboolean result = FALSE;
	gint index = 0;
	gunichar uc = 0U;
	g_return_val_if_fail (str != NULL, FALSE);
	index = 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_ = 0U;
		gboolean _tmp6_ = FALSE;
		_tmp0_ = str;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		uc = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = uc;
		if (_tmp4_ < ((gunichar) 0x30a0)) {
			_tmp3_ = TRUE;
		} else {
			gunichar _tmp5_ = 0U;
			_tmp5_ = uc;
			_tmp3_ = _tmp5_ > ((gunichar) 0x30ff);
		}
		_tmp6_ = _tmp3_;
		if (_tmp6_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


gboolean kkc_rom_kana_utils_is_hiragana (const gchar* str) {
	gboolean result = FALSE;
	gint index = 0;
	gunichar uc = 0U;
	g_return_val_if_fail (str != NULL, FALSE);
	index = 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_ = 0U;
		gboolean _tmp6_ = FALSE;
		_tmp0_ = str;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		uc = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp4_ = uc;
		if (_tmp4_ < ((gunichar) 0x3041)) {
			_tmp3_ = TRUE;
		} else {
			gunichar _tmp5_ = 0U;
			_tmp5_ = uc;
			_tmp3_ = _tmp5_ > ((gunichar) 0x309f);
		}
		_tmp6_ = _tmp3_;
		if (_tmp6_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


KkcRomKanaUtils* kkc_rom_kana_utils_construct (GType object_type) {
	KkcRomKanaUtils * self = NULL;
	self = (KkcRomKanaUtils*) g_object_new (object_type, NULL);
	return self;
}


static void kkc_rom_kana_utils_kana_table_entry_copy (const KkcRomKanaUtilsKanaTableEntry* self, KkcRomKanaUtilsKanaTableEntry* dest) {
	gunichar _tmp0_ = 0U;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = (*self).katakana;
	(*dest).katakana = _tmp0_;
	_tmp1_ = (*self).hiragana;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).hiragana);
	(*dest).hiragana = _tmp2_;
	_tmp3_ = (*self).hankaku_katakana;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).hankaku_katakana);
	(*dest).hankaku_katakana = _tmp4_;
}


static void kkc_rom_kana_utils_kana_table_entry_destroy (KkcRomKanaUtilsKanaTableEntry* self) {
	_g_free0 ((*self).hiragana);
	_g_free0 ((*self).hankaku_katakana);
}


static KkcRomKanaUtilsKanaTableEntry* kkc_rom_kana_utils_kana_table_entry_dup (const KkcRomKanaUtilsKanaTableEntry* self) {
	KkcRomKanaUtilsKanaTableEntry* dup;
	dup = g_new0 (KkcRomKanaUtilsKanaTableEntry, 1);
	kkc_rom_kana_utils_kana_table_entry_copy (self, dup);
	return dup;
}


static void kkc_rom_kana_utils_kana_table_entry_free (KkcRomKanaUtilsKanaTableEntry* self) {
	kkc_rom_kana_utils_kana_table_entry_destroy (self);
	g_free (self);
}


static GType kkc_rom_kana_utils_kana_table_entry_get_type (void) {
	static volatile gsize kkc_rom_kana_utils_kana_table_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_utils_kana_table_entry_type_id__volatile)) {
		GType kkc_rom_kana_utils_kana_table_entry_type_id;
		kkc_rom_kana_utils_kana_table_entry_type_id = g_boxed_type_register_static ("KkcRomKanaUtilsKanaTableEntry", (GBoxedCopyFunc) kkc_rom_kana_utils_kana_table_entry_dup, (GBoxedFreeFunc) kkc_rom_kana_utils_kana_table_entry_free);
		g_once_init_leave (&kkc_rom_kana_utils_kana_table_entry_type_id__volatile, kkc_rom_kana_utils_kana_table_entry_type_id);
	}
	return kkc_rom_kana_utils_kana_table_entry_type_id__volatile;
}


static void kkc_rom_kana_utils_class_init (KkcRomKanaUtilsClass * klass) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	GeeHashMap* _tmp3_ = NULL;
	GeeHashMap* _tmp4_ = NULL;
	kkc_rom_kana_utils_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_utils_finalize;
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	kkc_rom_kana_utils__HiraganaTable = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	kkc_rom_kana_utils__KatakanaTable = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	kkc_rom_kana_utils__HankakuKatakanaTable = (GeeMap*) _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	kkc_rom_kana_utils__CompositionTable = (GeeMap*) _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_CHAR, NULL, NULL, NULL, NULL, NULL);
	kkc_rom_kana_utils__WideLatinToLatinTable = (GeeMap*) _tmp4_;
	{
		KkcRomKanaUtilsKanaTableEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = KKC_ROM_KANA_UTILS_KanaTable;
		entry_collection_length1 = G_N_ELEMENTS (KKC_ROM_KANA_UTILS_KanaTable);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (KKC_ROM_KANA_UTILS_KanaTable); entry_it = entry_it + 1) {
			KkcRomKanaUtilsKanaTableEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				GeeMap* _tmp5_ = NULL;
				KkcRomKanaUtilsKanaTableEntry _tmp6_ = {0};
				gunichar _tmp7_ = 0U;
				KkcRomKanaUtilsKanaTableEntry _tmp8_ = {0};
				const gchar* _tmp9_ = NULL;
				GeeMap* _tmp10_ = NULL;
				KkcRomKanaUtilsKanaTableEntry _tmp11_ = {0};
				gunichar _tmp12_ = 0U;
				KkcRomKanaUtilsKanaTableEntry _tmp13_ = {0};
				const gchar* _tmp14_ = NULL;
				KkcRomKanaUtilsKanaTableEntry _tmp20_ = {0};
				const gchar* _tmp21_ = NULL;
				KkcRomKanaUtilsKanaTableEntry _tmp51_ = {0};
				const gchar* _tmp52_ = NULL;
				_tmp5_ = kkc_rom_kana_utils__HiraganaTable;
				_tmp6_ = entry;
				_tmp7_ = _tmp6_.katakana;
				_tmp8_ = entry;
				_tmp9_ = _tmp8_.hiragana;
				gee_map_set (_tmp5_, (gpointer) ((gintptr) _tmp7_), _tmp9_);
				_tmp10_ = kkc_rom_kana_utils__HankakuKatakanaTable;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_.katakana;
				_tmp13_ = entry;
				_tmp14_ = _tmp13_.hankaku_katakana;
				gee_map_set (_tmp10_, (gpointer) ((gintptr) _tmp12_), _tmp14_);
				{
					KkcRomKanaUtilsKanaTableEntry* substitute_collection = NULL;
					gint substitute_collection_length1 = 0;
					gint _substitute_collection_size_ = 0;
					gint substitute_it = 0;
					substitute_collection = KKC_ROM_KANA_UTILS_HankakuKatakanaSubstitute;
					substitute_collection_length1 = G_N_ELEMENTS (KKC_ROM_KANA_UTILS_HankakuKatakanaSubstitute);
					for (substitute_it = 0; substitute_it < G_N_ELEMENTS (KKC_ROM_KANA_UTILS_HankakuKatakanaSubstitute); substitute_it = substitute_it + 1) {
						KkcRomKanaUtilsKanaTableEntry substitute = {0};
						substitute = substitute_collection[substitute_it];
						{
							GeeMap* _tmp15_ = NULL;
							KkcRomKanaUtilsKanaTableEntry _tmp16_ = {0};
							gunichar _tmp17_ = 0U;
							KkcRomKanaUtilsKanaTableEntry _tmp18_ = {0};
							const gchar* _tmp19_ = NULL;
							_tmp15_ = kkc_rom_kana_utils__HankakuKatakanaTable;
							_tmp16_ = substitute;
							_tmp17_ = _tmp16_.katakana;
							_tmp18_ = substitute;
							_tmp19_ = _tmp18_.hankaku_katakana;
							gee_map_set (_tmp15_, (gpointer) ((gintptr) _tmp17_), _tmp19_);
						}
					}
				}
				_tmp20_ = entry;
				_tmp21_ = _tmp20_.hiragana;
				if (_tmp21_ != NULL) {
					KkcRomKanaUtilsKanaTableEntry _tmp22_ = {0};
					const gchar* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					_tmp22_ = entry;
					_tmp23_ = _tmp22_.hiragana;
					_tmp24_ = g_utf8_strlen (_tmp23_, (gssize) (-1));
					if (_tmp24_ > 1) {
						gint index = 0;
						gunichar uc0 = 0U;
						gunichar uc1 = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp25_ = {0};
						const gchar* _tmp26_ = NULL;
						gunichar _tmp27_ = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp28_ = {0};
						const gchar* _tmp29_ = NULL;
						gunichar _tmp30_ = 0U;
						GeeMap* _tmp31_ = NULL;
						gunichar _tmp32_ = 0U;
						gboolean _tmp33_ = FALSE;
						GeeMap* composition = NULL;
						GeeMap* _tmp38_ = NULL;
						gunichar _tmp39_ = 0U;
						gpointer _tmp40_ = NULL;
						GeeMap* _tmp41_ = NULL;
						gunichar _tmp42_ = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp43_ = {0};
						gunichar _tmp44_ = 0U;
						index = 0;
						_tmp25_ = entry;
						_tmp26_ = _tmp25_.hiragana;
						string_get_next_char (_tmp26_, &index, &_tmp27_);
						uc0 = _tmp27_;
						_tmp28_ = entry;
						_tmp29_ = _tmp28_.hiragana;
						string_get_next_char (_tmp29_, &index, &_tmp30_);
						uc1 = _tmp30_;
						_tmp31_ = kkc_rom_kana_utils__CompositionTable;
						_tmp32_ = uc0;
						_tmp33_ = gee_map_has_key (_tmp31_, (gpointer) ((gintptr) _tmp32_));
						if (!_tmp33_) {
							GeeMap* _tmp34_ = NULL;
							gunichar _tmp35_ = 0U;
							GeeHashMap* _tmp36_ = NULL;
							GeeHashMap* _tmp37_ = NULL;
							_tmp34_ = kkc_rom_kana_utils__CompositionTable;
							_tmp35_ = uc0;
							_tmp36_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
							_tmp37_ = _tmp36_;
							gee_map_set (_tmp34_, (gpointer) ((gintptr) _tmp35_), (GeeMap*) _tmp37_);
							_g_object_unref0 (_tmp37_);
						}
						_tmp38_ = kkc_rom_kana_utils__CompositionTable;
						_tmp39_ = uc0;
						_tmp40_ = gee_map_get (_tmp38_, (gpointer) ((gintptr) _tmp39_));
						composition = (GeeMap*) _tmp40_;
						_tmp41_ = composition;
						_tmp42_ = uc1;
						_tmp43_ = entry;
						_tmp44_ = _tmp43_.katakana;
						gee_map_set (_tmp41_, (gpointer) ((gintptr) _tmp42_), (gpointer) ((gintptr) _tmp44_));
						_g_object_unref0 (composition);
					} else {
						GeeMap* _tmp45_ = NULL;
						KkcRomKanaUtilsKanaTableEntry _tmp46_ = {0};
						const gchar* _tmp47_ = NULL;
						gunichar _tmp48_ = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp49_ = {0};
						gunichar _tmp50_ = 0U;
						_tmp45_ = kkc_rom_kana_utils__KatakanaTable;
						_tmp46_ = entry;
						_tmp47_ = _tmp46_.hiragana;
						_tmp48_ = string_get_char (_tmp47_, (glong) 0);
						_tmp49_ = entry;
						_tmp50_ = _tmp49_.katakana;
						gee_map_set (_tmp45_, (gpointer) ((gintptr) _tmp48_), (gpointer) ((gintptr) _tmp50_));
					}
				}
				_tmp51_ = entry;
				_tmp52_ = _tmp51_.hankaku_katakana;
				if (_tmp52_ != NULL) {
					KkcRomKanaUtilsKanaTableEntry _tmp53_ = {0};
					const gchar* _tmp54_ = NULL;
					gint _tmp55_ = 0;
					_tmp53_ = entry;
					_tmp54_ = _tmp53_.hankaku_katakana;
					_tmp55_ = g_utf8_strlen (_tmp54_, (gssize) (-1));
					if (_tmp55_ > 1) {
						gint index = 0;
						gunichar uc0 = 0U;
						gunichar uc1 = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp56_ = {0};
						const gchar* _tmp57_ = NULL;
						gunichar _tmp58_ = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp59_ = {0};
						const gchar* _tmp60_ = NULL;
						gunichar _tmp61_ = 0U;
						GeeMap* _tmp62_ = NULL;
						gunichar _tmp63_ = 0U;
						gboolean _tmp64_ = FALSE;
						GeeMap* composition = NULL;
						GeeMap* _tmp69_ = NULL;
						gunichar _tmp70_ = 0U;
						gpointer _tmp71_ = NULL;
						GeeMap* _tmp72_ = NULL;
						gunichar _tmp73_ = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp74_ = {0};
						gunichar _tmp75_ = 0U;
						index = 0;
						_tmp56_ = entry;
						_tmp57_ = _tmp56_.hankaku_katakana;
						string_get_next_char (_tmp57_, &index, &_tmp58_);
						uc0 = _tmp58_;
						_tmp59_ = entry;
						_tmp60_ = _tmp59_.hankaku_katakana;
						string_get_next_char (_tmp60_, &index, &_tmp61_);
						uc1 = _tmp61_;
						_tmp62_ = kkc_rom_kana_utils__CompositionTable;
						_tmp63_ = uc0;
						_tmp64_ = gee_map_has_key (_tmp62_, (gpointer) ((gintptr) _tmp63_));
						if (!_tmp64_) {
							GeeMap* _tmp65_ = NULL;
							gunichar _tmp66_ = 0U;
							GeeHashMap* _tmp67_ = NULL;
							GeeHashMap* _tmp68_ = NULL;
							_tmp65_ = kkc_rom_kana_utils__CompositionTable;
							_tmp66_ = uc0;
							_tmp67_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
							_tmp68_ = _tmp67_;
							gee_map_set (_tmp65_, (gpointer) ((gintptr) _tmp66_), (GeeMap*) _tmp68_);
							_g_object_unref0 (_tmp68_);
						}
						_tmp69_ = kkc_rom_kana_utils__CompositionTable;
						_tmp70_ = uc0;
						_tmp71_ = gee_map_get (_tmp69_, (gpointer) ((gintptr) _tmp70_));
						composition = (GeeMap*) _tmp71_;
						_tmp72_ = composition;
						_tmp73_ = uc1;
						_tmp74_ = entry;
						_tmp75_ = _tmp74_.katakana;
						gee_map_set (_tmp72_, (gpointer) ((gintptr) _tmp73_), (gpointer) ((gintptr) _tmp75_));
						_g_object_unref0 (composition);
					} else {
						gunichar uc = 0U;
						KkcRomKanaUtilsKanaTableEntry _tmp76_ = {0};
						const gchar* _tmp77_ = NULL;
						gunichar _tmp78_ = 0U;
						GeeMap* _tmp79_ = NULL;
						gunichar _tmp80_ = 0U;
						gboolean _tmp81_ = FALSE;
						_tmp76_ = entry;
						_tmp77_ = _tmp76_.hankaku_katakana;
						_tmp78_ = string_get_char (_tmp77_, (glong) 0);
						uc = _tmp78_;
						_tmp79_ = kkc_rom_kana_utils__KatakanaTable;
						_tmp80_ = uc;
						_tmp81_ = gee_map_has_key (_tmp79_, (gpointer) ((gintptr) _tmp80_));
						if (!_tmp81_) {
							GeeMap* _tmp82_ = NULL;
							gunichar _tmp83_ = 0U;
							KkcRomKanaUtilsKanaTableEntry _tmp84_ = {0};
							gunichar _tmp85_ = 0U;
							_tmp82_ = kkc_rom_kana_utils__KatakanaTable;
							_tmp83_ = uc;
							_tmp84_ = entry;
							_tmp85_ = _tmp84_.katakana;
							gee_map_set (_tmp82_, (gpointer) ((gintptr) _tmp83_), (gpointer) ((gintptr) _tmp85_));
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp86_ = FALSE;
			_tmp86_ = TRUE;
			while (TRUE) {
				gboolean _tmp87_ = FALSE;
				gint _tmp89_ = 0;
				GeeMap* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				const gchar* _tmp92_ = NULL;
				gint _tmp93_ = 0;
				_tmp87_ = _tmp86_;
				if (!_tmp87_) {
					gint _tmp88_ = 0;
					_tmp88_ = i;
					i = _tmp88_ + 1;
				}
				_tmp86_ = FALSE;
				_tmp89_ = i;
				if (!(_tmp89_ < G_N_ELEMENTS (KKC_ROM_KANA_UTILS_WideLatinTable))) {
					break;
				}
				_tmp90_ = kkc_rom_kana_utils__WideLatinToLatinTable;
				_tmp91_ = i;
				_tmp92_ = KKC_ROM_KANA_UTILS_WideLatinTable[_tmp91_];
				_tmp93_ = i;
				gee_map_set (_tmp90_, _tmp92_, (gpointer) ((gintptr) ((gchar) (_tmp93_ + 32))));
			}
		}
	}
}


static void kkc_rom_kana_utils_instance_init (KkcRomKanaUtils * self) {
}


static void kkc_rom_kana_utils_finalize (GObject* obj) {
	KkcRomKanaUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_UTILS, KkcRomKanaUtils);
	G_OBJECT_CLASS (kkc_rom_kana_utils_parent_class)->finalize (obj);
}


GType kkc_rom_kana_utils_get_type (void) {
	static volatile gsize kkc_rom_kana_utils_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_utils_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaUtils), 0, (GInstanceInitFunc) kkc_rom_kana_utils_instance_init, NULL };
		GType kkc_rom_kana_utils_type_id;
		kkc_rom_kana_utils_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaUtils", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&kkc_rom_kana_utils_type_id__volatile, kkc_rom_kana_utils_type_id);
	}
	return kkc_rom_kana_utils_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



