/* rom-kana.c generated by valac 0.22.1, the Vala compiler
 * generated from rom-kana.vala, do not modify */

/* -*- coding: utf-8 -*-*/
/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define KKC_TYPE_ROM_KANA_ENTRY (kkc_rom_kana_entry_get_type ())
typedef struct _KkcRomKanaEntry KkcRomKanaEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

#define KKC_TYPE_ROM_KANA_NODE (kkc_rom_kana_node_get_type ())
#define KKC_ROM_KANA_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNode))
#define KKC_ROM_KANA_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNodeClass))
#define KKC_IS_ROM_KANA_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_NODE))
#define KKC_IS_ROM_KANA_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_NODE))
#define KKC_ROM_KANA_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNodeClass))

typedef struct _KkcRomKanaNode KkcRomKanaNode;
typedef struct _KkcRomKanaNodeClass KkcRomKanaNodeClass;
typedef struct _KkcRomKanaNodePrivate KkcRomKanaNodePrivate;
#define _kkc_rom_kana_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_rom_kana_entry_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_TYPE_PUNCTUATION_STYLE (kkc_punctuation_style_get_type ())

#define KKC_TYPE_ROM_KANA_CHARACTER (kkc_rom_kana_character_get_type ())
typedef struct _KkcRomKanaCharacter KkcRomKanaCharacter;

#define KKC_TYPE_ROM_KANA_CHARACTER_LIST (kkc_rom_kana_character_list_get_type ())
#define KKC_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList))
#define KKC_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))
#define KKC_IS_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_IS_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_ROM_KANA_CHARACTER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))

typedef struct _KkcRomKanaCharacterList KkcRomKanaCharacterList;
typedef struct _KkcRomKanaCharacterListClass KkcRomKanaCharacterListClass;
typedef struct _KkcRomKanaCharacterListPrivate KkcRomKanaCharacterListPrivate;
#define _kkc_rom_kana_character_free0(var) ((var == NULL) ? NULL : (var = (kkc_rom_kana_character_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define KKC_TYPE_ROM_KANA_CONVERTER (kkc_rom_kana_converter_get_type ())
#define KKC_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter))
#define KKC_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))
#define KKC_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))

typedef struct _KkcRomKanaConverter KkcRomKanaConverter;
typedef struct _KkcRomKanaConverterClass KkcRomKanaConverterClass;
typedef struct _KkcRomKanaConverterPrivate KkcRomKanaConverterPrivate;

#define KKC_TYPE_MAP_FILE (kkc_map_file_get_type ())
#define KKC_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAP_FILE, KkcMapFile))
#define KKC_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAP_FILE, KkcMapFileClass))
#define KKC_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAP_FILE))
#define KKC_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAP_FILE))
#define KKC_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAP_FILE, KkcMapFileClass))

typedef struct _KkcMapFile KkcMapFile;
typedef struct _KkcMapFileClass KkcMapFileClass;

#define KKC_TYPE_ROM_KANA_MAP_FILE (kkc_rom_kana_map_file_get_type ())
#define KKC_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFile))
#define KKC_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFileClass))
#define KKC_IS_ROM_KANA_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_MAP_FILE))
#define KKC_IS_ROM_KANA_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_MAP_FILE))
#define KKC_ROM_KANA_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_MAP_FILE, KkcRomKanaMapFileClass))

typedef struct _KkcRomKanaMapFile KkcRomKanaMapFile;
typedef struct _KkcRomKanaMapFileClass KkcRomKanaMapFileClass;

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_RULE_METADATA (kkc_rule_metadata_get_type ())
#define KKC_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadata))
#define KKC_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))
#define KKC_IS_RULE_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE_METADATA))
#define KKC_IS_RULE_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE_METADATA))
#define KKC_RULE_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE_METADATA, KkcRuleMetadataClass))

typedef struct _KkcRuleMetadata KkcRuleMetadata;
typedef struct _KkcRuleMetadataClass KkcRuleMetadataClass;
typedef struct _KkcMapFilePrivate KkcMapFilePrivate;
typedef struct _KkcRomKanaMapFilePrivate KkcRomKanaMapFilePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _KkcRomKanaEntry {
	gchar* rom;
	gchar* carryover;
	gchar* hiragana;
	gchar* katakana;
	gchar* hiragana_partial;
	gchar* katakana_partial;
};

typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;

struct _KkcRomKanaNode {
	GObject parent_instance;
	KkcRomKanaNodePrivate * priv;
	KkcRomKanaEntry* entry;
	KkcRomKanaNode* parent;
	KkcRomKanaNode* children[256];
	gchar c;
	guint n_children;
	guint8 valid[32];
};

struct _KkcRomKanaNodeClass {
	GObjectClass parent_class;
};

typedef enum  {
	KKC_PUNCTUATION_STYLE_JA_JA,
	KKC_PUNCTUATION_STYLE_EN_EN,
	KKC_PUNCTUATION_STYLE_JA_EN,
	KKC_PUNCTUATION_STYLE_EN_JA
} KkcPunctuationStyle;

struct _KkcRomKanaCharacter {
	gchar* output;
	gchar* input;
};

struct _KkcRomKanaCharacterList {
	GObject parent_instance;
	KkcRomKanaCharacterListPrivate * priv;
};

struct _KkcRomKanaCharacterListClass {
	GObjectClass parent_class;
};

struct _KkcRomKanaCharacterListPrivate {
	GeeList* _characters;
};

struct _KkcRomKanaConverter {
	GObject parent_instance;
	KkcRomKanaConverterPrivate * priv;
};

struct _KkcRomKanaConverterClass {
	GObjectClass parent_class;
};

struct _KkcRomKanaConverterPrivate {
	KkcRomKanaMapFile* _rule;
	KkcRomKanaNode* current_node;
	KkcKanaMode _kana_mode;
	KkcPunctuationStyle _punctuation_style;
	gboolean _auto_correct;
	GString* _pending_output;
	GString* _pending_input;
	KkcRomKanaCharacterList* _produced;
};

typedef enum  {
	KKC_RULE_PARSE_ERROR_FAILED
} KkcRuleParseError;
#define KKC_RULE_PARSE_ERROR kkc_rule_parse_error_quark ()
struct _KkcMapFile {
	GObject parent_instance;
	KkcMapFilePrivate * priv;
};

struct _KkcMapFileClass {
	GObjectClass parent_class;
	gchar* (*uniquify) (KkcMapFile* self, const gchar* key);
};

struct _KkcRomKanaMapFile {
	KkcMapFile parent_instance;
	KkcRomKanaMapFilePrivate * priv;
	KkcRomKanaNode* root_node;
};

struct _KkcRomKanaMapFileClass {
	KkcMapFileClass parent_class;
};


static gpointer kkc_rom_kana_node_parent_class = NULL;
static gpointer kkc_rom_kana_character_list_parent_class = NULL;
static gpointer kkc_rom_kana_converter_parent_class = NULL;

GType kkc_rom_kana_entry_get_type (void) G_GNUC_CONST;
KkcRomKanaEntry* kkc_rom_kana_entry_dup (const KkcRomKanaEntry* self);
void kkc_rom_kana_entry_free (KkcRomKanaEntry* self);
void kkc_rom_kana_entry_copy (const KkcRomKanaEntry* self, KkcRomKanaEntry* dest);
void kkc_rom_kana_entry_destroy (KkcRomKanaEntry* self);
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
gchar* kkc_rom_kana_entry_get_kana (KkcRomKanaEntry *self, KkcKanaMode mode, gboolean partial);
gchar* kkc_rom_kana_utils_convert_by_kana_mode (const gchar* str, KkcKanaMode mode);
GType kkc_rom_kana_node_get_type (void) G_GNUC_CONST;
enum  {
	KKC_ROM_KANA_NODE_DUMMY_PROPERTY
};
KkcRomKanaNode* kkc_rom_kana_node_new (KkcRomKanaEntry* entry);
KkcRomKanaNode* kkc_rom_kana_node_construct (GType object_type, KkcRomKanaEntry* entry);
void kkc_rom_kana_node_insert (KkcRomKanaNode* self, const gchar* key, KkcRomKanaEntry* entry);
static void kkc_rom_kana_node_finalize (GObject* obj);
GType kkc_punctuation_style_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_character_get_type (void) G_GNUC_CONST;
KkcRomKanaCharacter* kkc_rom_kana_character_dup (const KkcRomKanaCharacter* self);
void kkc_rom_kana_character_free (KkcRomKanaCharacter* self);
void kkc_rom_kana_character_copy (const KkcRomKanaCharacter* self, KkcRomKanaCharacter* dest);
void kkc_rom_kana_character_destroy (KkcRomKanaCharacter* self);
GType kkc_rom_kana_character_list_get_type (void) G_GNUC_CONST;
#define KKC_ROM_KANA_CHARACTER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListPrivate))
enum  {
	KKC_ROM_KANA_CHARACTER_LIST_DUMMY_PROPERTY,
	KKC_ROM_KANA_CHARACTER_LIST_SIZE
};
void kkc_rom_kana_character_list_add (KkcRomKanaCharacterList* self, KkcRomKanaCharacter* character);
void kkc_rom_kana_character_list_add_all (KkcRomKanaCharacterList* self, KkcRomKanaCharacterList* other);
void kkc_rom_kana_character_list_insert (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* character);
void kkc_rom_kana_character_list_insert_all (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacterList* other);
void kkc_rom_kana_character_list_get (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* result);
void kkc_rom_kana_character_list_clear (KkcRomKanaCharacterList* self);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_slice (KkcRomKanaCharacterList* self, gint start_char_pos, gint stop_char_pos);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_new (void);
KkcRomKanaCharacterList* kkc_rom_kana_character_list_construct (GType object_type);
void kkc_rom_kana_character_list_remove_at (KkcRomKanaCharacterList* self, gint index);
gchar* kkc_rom_kana_character_list_get_output (KkcRomKanaCharacterList* self);
gchar* kkc_rom_kana_character_list_get_input (KkcRomKanaCharacterList* self);
gint kkc_rom_kana_character_list_get_size (KkcRomKanaCharacterList* self);
static void kkc_rom_kana_character_list_finalize (GObject* obj);
static void _vala_kkc_rom_kana_character_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType kkc_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType kkc_map_file_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_map_file_get_type (void) G_GNUC_CONST;
#define KKC_ROM_KANA_CONVERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterPrivate))
enum  {
	KKC_ROM_KANA_CONVERTER_DUMMY_PROPERTY,
	KKC_ROM_KANA_CONVERTER_RULE,
	KKC_ROM_KANA_CONVERTER_KANA_MODE,
	KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE,
	KKC_ROM_KANA_CONVERTER_AUTO_CORRECT,
	KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT,
	KKC_ROM_KANA_CONVERTER_PENDING_INPUT,
	KKC_ROM_KANA_CONVERTER_PRODUCED
};
gchar* kkc_rom_kana_converter_get_produced_output (KkcRomKanaConverter* self);
KkcRomKanaConverter* kkc_rom_kana_converter_new (void);
KkcRomKanaConverter* kkc_rom_kana_converter_construct (GType object_type);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_rule_metadata_get_type (void) G_GNUC_CONST;
KkcRuleMetadata* kkc_rule_metadata_find (const gchar* name);
GQuark kkc_rule_parse_error_quark (void);
KkcRomKanaMapFile* kkc_rom_kana_map_file_new (KkcRuleMetadata* metadata, GError** error);
KkcRomKanaMapFile* kkc_rom_kana_map_file_construct (GType object_type, KkcRuleMetadata* metadata, GError** error);
gboolean kkc_rom_kana_converter_is_valid (KkcRomKanaConverter* self, gunichar uc);
gboolean kkc_rom_kana_converter_flush_partial (KkcRomKanaConverter* self);
KkcKanaMode kkc_rom_kana_converter_get_kana_mode (KkcRomKanaConverter* self);
KkcRomKanaMapFile* kkc_rom_kana_converter_get_rule (KkcRomKanaConverter* self);
gboolean kkc_rom_kana_converter_get_auto_correct (KkcRomKanaConverter* self);
void kkc_rom_kana_converter_append_text (KkcRomKanaConverter* self, const gchar* text);
gboolean kkc_rom_kana_converter_append (KkcRomKanaConverter* self, gunichar uc);
static gboolean kkc_rom_kana_converter_append_punctuation (KkcRomKanaConverter* self, gunichar uc);
KkcPunctuationStyle kkc_rom_kana_converter_get_punctuation_style (KkcRomKanaConverter* self);
gboolean kkc_rom_kana_converter_can_consume (KkcRomKanaConverter* self, gunichar uc, gboolean no_carryover);
void kkc_rom_kana_converter_reset (KkcRomKanaConverter* self);
gboolean kkc_rom_kana_converter_delete (KkcRomKanaConverter* self);
void kkc_rom_kana_converter_set_rule (KkcRomKanaConverter* self, KkcRomKanaMapFile* value);
void kkc_rom_kana_converter_set_kana_mode (KkcRomKanaConverter* self, KkcKanaMode value);
void kkc_rom_kana_converter_set_punctuation_style (KkcRomKanaConverter* self, KkcPunctuationStyle value);
void kkc_rom_kana_converter_set_auto_correct (KkcRomKanaConverter* self, gboolean value);
const gchar* kkc_rom_kana_converter_get_pending_output (KkcRomKanaConverter* self);
const gchar* kkc_rom_kana_converter_get_pending_input (KkcRomKanaConverter* self);
KkcRomKanaCharacterList* kkc_rom_kana_converter_get_produced (KkcRomKanaConverter* self);
static void kkc_rom_kana_converter_finalize (GObject* obj);
static void _vala_kkc_rom_kana_converter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_rom_kana_converter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* KKC_PUNCTUATION_RULE[4] = {"。、", "．，", "。，", "．、"};

gchar* kkc_rom_kana_entry_get_kana (KkcRomKanaEntry *self, KkcKanaMode mode, gboolean partial) {
	gchar* result = NULL;
	KkcKanaMode _tmp0_ = 0;
	_tmp0_ = mode;
	switch (_tmp0_) {
		case KKC_KANA_MODE_HIRAGANA:
		{
			const gchar* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp2_ = partial;
			if (_tmp2_) {
				const gchar* _tmp3_ = NULL;
				_tmp3_ = (*self).hiragana_partial;
				_tmp1_ = _tmp3_;
			} else {
				const gchar* _tmp4_ = NULL;
				_tmp4_ = (*self).hiragana;
				_tmp1_ = _tmp4_;
			}
			_tmp5_ = _tmp1_;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case KKC_KANA_MODE_KATAKANA:
		{
			const gchar* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp8_ = partial;
			if (_tmp8_) {
				const gchar* _tmp9_ = NULL;
				_tmp9_ = (*self).katakana_partial;
				_tmp7_ = _tmp9_;
			} else {
				const gchar* _tmp10_ = NULL;
				_tmp10_ = (*self).katakana;
				_tmp7_ = _tmp10_;
			}
			_tmp11_ = _tmp7_;
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		default:
		{
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp17_ = NULL;
			KkcKanaMode _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			_tmp14_ = partial;
			if (_tmp14_) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = (*self).hiragana_partial;
				_tmp13_ = _tmp15_;
			} else {
				const gchar* _tmp16_ = NULL;
				_tmp16_ = (*self).hiragana;
				_tmp13_ = _tmp16_;
			}
			_tmp17_ = _tmp13_;
			_tmp18_ = mode;
			_tmp19_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp17_, _tmp18_);
			result = _tmp19_;
			return result;
		}
	}
}


void kkc_rom_kana_entry_copy (const KkcRomKanaEntry* self, KkcRomKanaEntry* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	_tmp0_ = (*self).rom;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).rom);
	(*dest).rom = _tmp1_;
	_tmp2_ = (*self).carryover;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).carryover);
	(*dest).carryover = _tmp3_;
	_tmp4_ = (*self).hiragana;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).hiragana);
	(*dest).hiragana = _tmp5_;
	_tmp6_ = (*self).katakana;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).katakana);
	(*dest).katakana = _tmp7_;
	_tmp8_ = (*self).hiragana_partial;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).hiragana_partial);
	(*dest).hiragana_partial = _tmp9_;
	_tmp10_ = (*self).katakana_partial;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 ((*dest).katakana_partial);
	(*dest).katakana_partial = _tmp11_;
}


void kkc_rom_kana_entry_destroy (KkcRomKanaEntry* self) {
	_g_free0 ((*self).rom);
	_g_free0 ((*self).carryover);
	_g_free0 ((*self).hiragana);
	_g_free0 ((*self).katakana);
	_g_free0 ((*self).hiragana_partial);
	_g_free0 ((*self).katakana_partial);
}


KkcRomKanaEntry* kkc_rom_kana_entry_dup (const KkcRomKanaEntry* self) {
	KkcRomKanaEntry* dup;
	dup = g_new0 (KkcRomKanaEntry, 1);
	kkc_rom_kana_entry_copy (self, dup);
	return dup;
}


void kkc_rom_kana_entry_free (KkcRomKanaEntry* self) {
	kkc_rom_kana_entry_destroy (self);
	g_free (self);
}


GType kkc_rom_kana_entry_get_type (void) {
	static volatile gsize kkc_rom_kana_entry_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_entry_type_id__volatile)) {
		GType kkc_rom_kana_entry_type_id;
		kkc_rom_kana_entry_type_id = g_boxed_type_register_static ("KkcRomKanaEntry", (GBoxedCopyFunc) kkc_rom_kana_entry_dup, (GBoxedFreeFunc) kkc_rom_kana_entry_free);
		g_once_init_leave (&kkc_rom_kana_entry_type_id__volatile, kkc_rom_kana_entry_type_id);
	}
	return kkc_rom_kana_entry_type_id__volatile;
}


static gpointer _kkc_rom_kana_entry_dup0 (gpointer self) {
	return self ? kkc_rom_kana_entry_dup (self) : NULL;
}


KkcRomKanaNode* kkc_rom_kana_node_construct (GType object_type, KkcRomKanaEntry* entry) {
	KkcRomKanaNode * self = NULL;
	KkcRomKanaEntry* _tmp0_ = NULL;
	KkcRomKanaEntry* _tmp1_ = NULL;
	self = (KkcRomKanaNode*) g_object_new (object_type, NULL);
	_tmp0_ = entry;
	_tmp1_ = _kkc_rom_kana_entry_dup0 (_tmp0_);
	_kkc_rom_kana_entry_free0 (self->entry);
	self->entry = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				KkcRomKanaNode* _tmp7_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < 256)) {
					break;
				}
				_tmp6_ = i;
				_g_object_unref0 (self->children[_tmp6_]);
				self->children[_tmp6_] = NULL;
				_tmp7_ = self->children[_tmp6_];
			}
		}
	}
	memset (self->valid, 0, (gsize) 32);
	return self;
}


KkcRomKanaNode* kkc_rom_kana_node_new (KkcRomKanaEntry* entry) {
	return kkc_rom_kana_node_construct (KKC_TYPE_ROM_KANA_NODE, entry);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void kkc_rom_kana_node_insert (KkcRomKanaNode* self, const gchar* key, KkcRomKanaEntry* entry) {
	KkcRomKanaNode* node = NULL;
	KkcRomKanaNode* _tmp0_ = NULL;
	gint index = 0;
	gunichar uc = 0U;
	KkcRomKanaNode* _tmp23_ = NULL;
	KkcRomKanaEntry _tmp24_ = {0};
	KkcRomKanaEntry _tmp25_ = {0};
	KkcRomKanaEntry* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = _g_object_ref0 (self);
	node = _tmp0_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		KkcRomKanaNode* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		KkcRomKanaNode* _tmp6_ = NULL;
		KkcRomKanaNode* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		KkcRomKanaNode* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		KkcRomKanaNode* _tmp18_ = NULL;
		KkcRomKanaNode* _tmp19_ = NULL;
		gunichar _tmp20_ = 0U;
		gunichar _tmp21_ = 0U;
		guint8 _tmp22_ = 0U;
		_tmp1_ = key;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		uc = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = node;
		_tmp5_ = uc;
		_tmp6_ = _tmp4_->children[_tmp5_];
		if (_tmp6_ == NULL) {
			KkcRomKanaNode* child = NULL;
			KkcRomKanaNode* _tmp7_ = NULL;
			gunichar _tmp8_ = 0U;
			KkcRomKanaNode* _tmp9_ = NULL;
			KkcRomKanaNode* _tmp10_ = NULL;
			KkcRomKanaNode* _tmp11_ = NULL;
			KkcRomKanaNode* _tmp12_ = NULL;
			KkcRomKanaNode* _tmp13_ = NULL;
			_tmp7_ = node;
			_tmp8_ = uc;
			_tmp9_ = kkc_rom_kana_node_new (NULL);
			_g_object_unref0 (_tmp7_->children[_tmp8_]);
			_tmp7_->children[_tmp8_] = _tmp9_;
			_tmp10_ = _tmp7_->children[_tmp8_];
			_tmp11_ = _g_object_ref0 (_tmp10_);
			child = _tmp11_;
			_tmp12_ = child;
			_tmp13_ = node;
			_tmp12_->parent = _tmp13_;
			_g_object_unref0 (child);
		}
		_tmp14_ = node;
		_tmp15_ = _tmp14_->n_children;
		_tmp14_->n_children = _tmp15_ + 1;
		_tmp16_ = node;
		_tmp17_ = uc;
		_tmp18_ = _tmp16_->children[_tmp17_];
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_g_object_unref0 (node);
		node = _tmp19_;
		_tmp20_ = uc;
		_tmp21_ = uc;
		self->valid[_tmp20_ / 8] |= (guint8) (1 << (_tmp21_ % 8));
		_tmp22_ = self->valid[_tmp20_ / 8];
	}
	_tmp23_ = node;
	_tmp24_ = *entry;
	_tmp25_ = _tmp24_;
	_tmp26_ = _kkc_rom_kana_entry_dup0 (&_tmp25_);
	_kkc_rom_kana_entry_free0 (_tmp23_->entry);
	_tmp23_->entry = _tmp26_;
	_g_object_unref0 (node);
}


static void kkc_rom_kana_node_class_init (KkcRomKanaNodeClass * klass) {
	kkc_rom_kana_node_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_node_finalize;
}


static void kkc_rom_kana_node_instance_init (KkcRomKanaNode * self) {
	self->n_children = (guint) 0;
}


static void kkc_rom_kana_node_finalize (GObject* obj) {
	KkcRomKanaNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_NODE, KkcRomKanaNode);
	_kkc_rom_kana_entry_free0 (self->entry);
	_vala_array_destroy (self->children, 256, (GDestroyNotify) g_object_unref);
	G_OBJECT_CLASS (kkc_rom_kana_node_parent_class)->finalize (obj);
}


GType kkc_rom_kana_node_get_type (void) {
	static volatile gsize kkc_rom_kana_node_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaNode), 0, (GInstanceInitFunc) kkc_rom_kana_node_instance_init, NULL };
		GType kkc_rom_kana_node_type_id;
		kkc_rom_kana_node_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaNode", &g_define_type_info, 0);
		g_once_init_leave (&kkc_rom_kana_node_type_id__volatile, kkc_rom_kana_node_type_id);
	}
	return kkc_rom_kana_node_type_id__volatile;
}


/**
     * Type representing kana scripts.
     */
GType kkc_kana_mode_get_type (void) {
	static volatile gsize kkc_kana_mode_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_kana_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_KANA_MODE_HIRAGANA, "KKC_KANA_MODE_HIRAGANA", "hiragana"}, {KKC_KANA_MODE_KATAKANA, "KKC_KANA_MODE_KATAKANA", "katakana"}, {KKC_KANA_MODE_HANKAKU_KATAKANA, "KKC_KANA_MODE_HANKAKU_KATAKANA", "hankaku-katakana"}, {KKC_KANA_MODE_LATIN, "KKC_KANA_MODE_LATIN", "latin"}, {KKC_KANA_MODE_WIDE_LATIN, "KKC_KANA_MODE_WIDE_LATIN", "wide-latin"}, {0, NULL, NULL}};
		GType kkc_kana_mode_type_id;
		kkc_kana_mode_type_id = g_enum_register_static ("KkcKanaMode", values);
		g_once_init_leave (&kkc_kana_mode_type_id__volatile, kkc_kana_mode_type_id);
	}
	return kkc_kana_mode_type_id__volatile;
}


/**
     * Type to specify how "." and "," are converted.
     */
GType kkc_punctuation_style_get_type (void) {
	static volatile gsize kkc_punctuation_style_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_punctuation_style_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_PUNCTUATION_STYLE_JA_JA, "KKC_PUNCTUATION_STYLE_JA_JA", "ja-ja"}, {KKC_PUNCTUATION_STYLE_EN_EN, "KKC_PUNCTUATION_STYLE_EN_EN", "en-en"}, {KKC_PUNCTUATION_STYLE_JA_EN, "KKC_PUNCTUATION_STYLE_JA_EN", "ja-en"}, {KKC_PUNCTUATION_STYLE_EN_JA, "KKC_PUNCTUATION_STYLE_EN_JA", "en-ja"}, {0, NULL, NULL}};
		GType kkc_punctuation_style_type_id;
		kkc_punctuation_style_type_id = g_enum_register_static ("KkcPunctuationStyle", values);
		g_once_init_leave (&kkc_punctuation_style_type_id__volatile, kkc_punctuation_style_type_id);
	}
	return kkc_punctuation_style_type_id__volatile;
}


void kkc_rom_kana_character_copy (const KkcRomKanaCharacter* self, KkcRomKanaCharacter* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = (*self).output;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).output);
	(*dest).output = _tmp1_;
	_tmp2_ = (*self).input;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).input);
	(*dest).input = _tmp3_;
}


void kkc_rom_kana_character_destroy (KkcRomKanaCharacter* self) {
	_g_free0 ((*self).output);
	_g_free0 ((*self).input);
}


KkcRomKanaCharacter* kkc_rom_kana_character_dup (const KkcRomKanaCharacter* self) {
	KkcRomKanaCharacter* dup;
	dup = g_new0 (KkcRomKanaCharacter, 1);
	kkc_rom_kana_character_copy (self, dup);
	return dup;
}


void kkc_rom_kana_character_free (KkcRomKanaCharacter* self) {
	kkc_rom_kana_character_destroy (self);
	g_free (self);
}


GType kkc_rom_kana_character_get_type (void) {
	static volatile gsize kkc_rom_kana_character_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_character_type_id__volatile)) {
		GType kkc_rom_kana_character_type_id;
		kkc_rom_kana_character_type_id = g_boxed_type_register_static ("KkcRomKanaCharacter", (GBoxedCopyFunc) kkc_rom_kana_character_dup, (GBoxedFreeFunc) kkc_rom_kana_character_free);
		g_once_init_leave (&kkc_rom_kana_character_type_id__volatile, kkc_rom_kana_character_type_id);
	}
	return kkc_rom_kana_character_type_id__volatile;
}


/**
         * Append a character to the character list.
         *
         * @param character a RomKanaCharacter
         */
void kkc_rom_kana_character_list_add (KkcRomKanaCharacterList* self, KkcRomKanaCharacter* character) {
	GeeList* _tmp0_ = NULL;
	KkcRomKanaCharacter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (character != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = *character;
	gee_collection_add ((GeeCollection*) _tmp0_, &_tmp1_);
}


/**
         * Append all characters in other character list to the character list.
         *
         * @param other RomKanaCharacterList
         */
void kkc_rom_kana_character_list_add_all (KkcRomKanaCharacterList* self, KkcRomKanaCharacterList* other) {
	GeeList* _tmp0_ = NULL;
	KkcRomKanaCharacterList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = other;
	_tmp2_ = _tmp1_->priv->_characters;
	gee_collection_add_all ((GeeCollection*) _tmp0_, (GeeCollection*) _tmp2_);
}


/**
         * Add a character to the character list at the specified
         * position.
         *
         * @param index index
         * @param character RomKanaCharacter
         */
void kkc_rom_kana_character_list_insert (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* character) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	KkcRomKanaCharacter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (character != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = *character;
	gee_list_insert (_tmp0_, _tmp1_, &_tmp2_);
}


/**
         * Add all characters in other character list to the character
         * list at the specified position.
         *
         * @param index index
         * @param other RomKanaCharacterList
         */
void kkc_rom_kana_character_list_insert_all (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacterList* other) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = other;
	_tmp3_ = _tmp2_->priv->_characters;
	gee_list_insert_all (_tmp0_, _tmp1_, (GeeCollection*) _tmp3_);
}


/**
         * Get a character at the given index.
         *
         * @param index index
         *
         * @return a RomKanaCharacter
         */
void kkc_rom_kana_character_list_get (KkcRomKanaCharacterList* self, gint index, KkcRomKanaCharacter* result) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	KkcRomKanaCharacter* _tmp3_ = NULL;
	KkcRomKanaCharacter _tmp4_ = {0};
	KkcRomKanaCharacter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
	_tmp3_ = (KkcRomKanaCharacter*) _tmp2_;
	kkc_rom_kana_character_copy (_tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_kkc_rom_kana_character_free0 (_tmp3_);
	*result = _tmp5_;
	return;
}


/**
         * Remove all characters from the character list.
         */
void kkc_rom_kana_character_list_clear (KkcRomKanaCharacterList* self) {
	GeeList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_characters;
	gee_collection_clear ((GeeCollection*) _tmp0_);
}


/**
         * Return a slice of this character list.
         *
         * @param start_char_pos zero-based index of the begin of the slice
         * @param stop_char_pos zero-based index after the end of the slice
         *
         * @return a RomKanaCharacterList
         */
KkcRomKanaCharacterList* kkc_rom_kana_character_list_slice (KkcRomKanaCharacterList* self, gint start_char_pos, gint stop_char_pos) {
	KkcRomKanaCharacterList* result = NULL;
	gint start = 0;
	gint stop = 0;
	gint char_pos = 0;
	KkcRomKanaCharacterList* _result_ = NULL;
	KkcRomKanaCharacterList* _tmp33_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	char_pos = 0;
	{
		gboolean _tmp0_ = FALSE;
		start = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp3_ = 0;
			GeeList* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			GeeList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			KkcRomKanaCharacter* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_ = 0;
				_tmp2_ = start;
				start = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = start;
			_tmp4_ = self->priv->_characters;
			_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			if (!(_tmp3_ < _tmp6_)) {
				break;
			}
			_tmp7_ = char_pos;
			_tmp8_ = start_char_pos;
			if (_tmp7_ >= _tmp8_) {
				break;
			}
			_tmp9_ = char_pos;
			_tmp10_ = self->priv->_characters;
			_tmp11_ = start;
			_tmp12_ = gee_list_get (_tmp10_, _tmp11_);
			_tmp13_ = (KkcRomKanaCharacter*) _tmp12_;
			_tmp14_ = (*_tmp13_).output;
			_tmp15_ = g_utf8_strlen (_tmp14_, (gssize) (-1));
			char_pos = _tmp9_ + _tmp15_;
			_kkc_rom_kana_character_free0 (_tmp13_);
		}
	}
	{
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = start;
		stop = _tmp16_;
		_tmp17_ = TRUE;
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			gint _tmp20_ = 0;
			GeeList* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			GeeList* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gpointer _tmp27_ = NULL;
			KkcRomKanaCharacter* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			_tmp18_ = _tmp17_;
			if (!_tmp18_) {
				gint _tmp19_ = 0;
				_tmp19_ = stop;
				stop = _tmp19_ + 1;
			}
			_tmp17_ = FALSE;
			_tmp20_ = stop;
			_tmp21_ = self->priv->_characters;
			_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			if (!(_tmp20_ < _tmp23_)) {
				break;
			}
			_tmp24_ = char_pos;
			_tmp25_ = self->priv->_characters;
			_tmp26_ = stop;
			_tmp27_ = gee_list_get (_tmp25_, _tmp26_);
			_tmp28_ = (KkcRomKanaCharacter*) _tmp27_;
			_tmp29_ = (*_tmp28_).output;
			_tmp30_ = g_utf8_strlen (_tmp29_, (gssize) (-1));
			char_pos = _tmp24_ + _tmp30_;
			_kkc_rom_kana_character_free0 (_tmp28_);
			_tmp31_ = char_pos;
			_tmp32_ = stop_char_pos;
			if (_tmp31_ >= _tmp32_) {
				break;
			}
		}
	}
	_tmp33_ = kkc_rom_kana_character_list_new ();
	_result_ = _tmp33_;
	{
		gboolean _tmp34_ = FALSE;
		_tmp34_ = TRUE;
		while (TRUE) {
			gboolean _tmp35_ = FALSE;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			KkcRomKanaCharacterList* _tmp39_ = NULL;
			GeeList* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gpointer _tmp42_ = NULL;
			KkcRomKanaCharacter* _tmp43_ = NULL;
			KkcRomKanaCharacter _tmp44_ = {0};
			_tmp35_ = _tmp34_;
			if (!_tmp35_) {
				gint _tmp36_ = 0;
				_tmp36_ = start;
				start = _tmp36_ + 1;
			}
			_tmp34_ = FALSE;
			_tmp37_ = start;
			_tmp38_ = stop;
			if (!(_tmp37_ <= _tmp38_)) {
				break;
			}
			_tmp39_ = _result_;
			_tmp40_ = self->priv->_characters;
			_tmp41_ = start;
			_tmp42_ = gee_list_get (_tmp40_, _tmp41_);
			_tmp43_ = (KkcRomKanaCharacter*) _tmp42_;
			_tmp44_ = *_tmp43_;
			kkc_rom_kana_character_list_add (_tmp39_, &_tmp44_);
			_kkc_rom_kana_character_free0 (_tmp43_);
		}
	}
	result = _result_;
	return result;
}


/**
         * Remove a character at the given index.
         *
         * @param index index
         */
void kkc_rom_kana_character_list_remove_at (KkcRomKanaCharacterList* self, gint index) {
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	KkcRomKanaCharacter* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = index;
	_tmp2_ = gee_list_remove_at (_tmp0_, _tmp1_);
	_tmp3_ = (KkcRomKanaCharacter*) _tmp2_;
	_kkc_rom_kana_character_free0 (_tmp3_);
}


/**
         * Return the concatenation of all character output as a string.
         *
         * @return a string
         */
gchar* kkc_rom_kana_character_list_get_output (KkcRomKanaCharacterList* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		GeeList* _character_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _character_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _character_index = 0;
		_tmp1_ = self->priv->_characters;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_character_list = _tmp2_;
		_tmp3_ = _character_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_character_size = _tmp5_;
		_character_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			KkcRomKanaCharacter* character = NULL;
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GString* _tmp12_ = NULL;
			KkcRomKanaCharacter* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp6_ = _character_index;
			_character_index = _tmp6_ + 1;
			_tmp7_ = _character_index;
			_tmp8_ = _character_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _character_list;
			_tmp10_ = _character_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			character = (KkcRomKanaCharacter*) _tmp11_;
			_tmp12_ = builder;
			_tmp13_ = character;
			_tmp14_ = (*_tmp13_).output;
			g_string_append (_tmp12_, _tmp14_);
			_kkc_rom_kana_character_free0 (character);
		}
		_g_object_unref0 (_character_list);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


/**
         * Return the concatenation of all character input as a string.
         *
         * @return a string
         */
gchar* kkc_rom_kana_character_list_get_input (KkcRomKanaCharacterList* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		GeeList* _character_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _character_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _character_index = 0;
		_tmp1_ = self->priv->_characters;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_character_list = _tmp2_;
		_tmp3_ = _character_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_character_size = _tmp5_;
		_character_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			KkcRomKanaCharacter* character = NULL;
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GString* _tmp12_ = NULL;
			KkcRomKanaCharacter* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp6_ = _character_index;
			_character_index = _tmp6_ + 1;
			_tmp7_ = _character_index;
			_tmp8_ = _character_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _character_list;
			_tmp10_ = _character_index;
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
			character = (KkcRomKanaCharacter*) _tmp11_;
			_tmp12_ = builder;
			_tmp13_ = character;
			_tmp14_ = (*_tmp13_).input;
			g_string_append (_tmp12_, _tmp14_);
			_kkc_rom_kana_character_free0 (character);
		}
		_g_object_unref0 (_character_list);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


KkcRomKanaCharacterList* kkc_rom_kana_character_list_construct (GType object_type) {
	KkcRomKanaCharacterList * self = NULL;
	self = (KkcRomKanaCharacterList*) g_object_new (object_type, NULL);
	return self;
}


KkcRomKanaCharacterList* kkc_rom_kana_character_list_new (void) {
	return kkc_rom_kana_character_list_construct (KKC_TYPE_ROM_KANA_CHARACTER_LIST);
}


gint kkc_rom_kana_character_list_get_size (KkcRomKanaCharacterList* self) {
	gint result;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_characters;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void kkc_rom_kana_character_list_class_init (KkcRomKanaCharacterListClass * klass) {
	kkc_rom_kana_character_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcRomKanaCharacterListPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_rom_kana_character_list_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_character_list_finalize;
	/**
	         * The number of characters in the character list.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CHARACTER_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_rom_kana_character_list_instance_init (KkcRomKanaCharacterList * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = KKC_ROM_KANA_CHARACTER_LIST_GET_PRIVATE (self);
	_tmp0_ = gee_array_list_new (KKC_TYPE_ROM_KANA_CHARACTER, (GBoxedCopyFunc) kkc_rom_kana_character_dup, kkc_rom_kana_character_free, NULL);
	self->priv->_characters = (GeeList*) _tmp0_;
}


static void kkc_rom_kana_character_list_finalize (GObject* obj) {
	KkcRomKanaCharacterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList);
	_g_object_unref0 (self->priv->_characters);
	G_OBJECT_CLASS (kkc_rom_kana_character_list_parent_class)->finalize (obj);
}


/**
     * A list of RomKanaCharacter
     */
GType kkc_rom_kana_character_list_get_type (void) {
	static volatile gsize kkc_rom_kana_character_list_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_character_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaCharacterListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_character_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaCharacterList), 0, (GInstanceInitFunc) kkc_rom_kana_character_list_instance_init, NULL };
		GType kkc_rom_kana_character_list_type_id;
		kkc_rom_kana_character_list_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaCharacterList", &g_define_type_info, 0);
		g_once_init_leave (&kkc_rom_kana_character_list_type_id__volatile, kkc_rom_kana_character_list_type_id);
	}
	return kkc_rom_kana_character_list_type_id__volatile;
}


static void _vala_kkc_rom_kana_character_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcRomKanaCharacterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList);
	switch (property_id) {
		case KKC_ROM_KANA_CHARACTER_LIST_SIZE:
		g_value_set_int (value, kkc_rom_kana_character_list_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
         * Return the concatenation of the produced output characters.
         *
         * @return a string
         */
gchar* kkc_rom_kana_converter_get_produced_output (KkcRomKanaConverter* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		KkcRomKanaCharacterList* _c_list = NULL;
		KkcRomKanaCharacterList* _tmp1_ = NULL;
		KkcRomKanaCharacterList* _tmp2_ = NULL;
		gint _c_size = 0;
		KkcRomKanaCharacterList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _c_index = 0;
		_tmp1_ = self->priv->_produced;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_c_list = _tmp2_;
		_tmp3_ = _c_list;
		_tmp4_ = kkc_rom_kana_character_list_get_size (_tmp3_);
		_tmp5_ = _tmp4_;
		_c_size = _tmp5_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			KkcRomKanaCharacter c = {0};
			KkcRomKanaCharacterList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			KkcRomKanaCharacter _tmp11_ = {0};
			GString* _tmp12_ = NULL;
			KkcRomKanaCharacter _tmp13_ = {0};
			const gchar* _tmp14_ = NULL;
			_tmp6_ = _c_index;
			_c_index = _tmp6_ + 1;
			_tmp7_ = _c_index;
			_tmp8_ = _c_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _c_list;
			_tmp10_ = _c_index;
			kkc_rom_kana_character_list_get (_tmp9_, _tmp10_, &_tmp11_);
			c = _tmp11_;
			_tmp12_ = builder;
			_tmp13_ = c;
			_tmp14_ = _tmp13_.output;
			g_string_append (_tmp12_, _tmp14_);
			kkc_rom_kana_character_destroy (&c);
		}
		_g_object_unref0 (_c_list);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


/**
         * Create a new RomKanaConverter.
         *
         * @return a new RomKanaConverter
         */
KkcRomKanaConverter* kkc_rom_kana_converter_construct (GType object_type) {
	KkcRomKanaConverter * self = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcRomKanaConverter*) g_object_new (object_type, NULL);
	{
		KkcRomKanaMapFile* _tmp0_ = NULL;
		KkcRuleMetadata* _tmp1_ = NULL;
		KkcRuleMetadata* _tmp2_ = NULL;
		KkcRomKanaMapFile* _tmp3_ = NULL;
		KkcRomKanaMapFile* _tmp4_ = NULL;
		KkcRomKanaMapFile* _tmp5_ = NULL;
		KkcRomKanaNode* _tmp6_ = NULL;
		KkcRomKanaNode* _tmp7_ = NULL;
		_tmp1_ = kkc_rule_metadata_find ("default");
		_tmp2_ = _tmp1_;
		_tmp3_ = kkc_rom_kana_map_file_new (_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
				goto __catch4_kkc_rule_parse_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (self->priv->_rule);
		self->priv->_rule = _tmp0_;
		_tmp5_ = self->priv->_rule;
		_tmp6_ = _tmp5_->root_node;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp7_;
	}
	goto __finally4;
	__catch4_kkc_rule_parse_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e->message;
		g_warning ("rom-kana.vala:400: can't find default rom-kana rule: %s", _tmp8_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


KkcRomKanaConverter* kkc_rom_kana_converter_new (void) {
	return kkc_rom_kana_converter_construct (KKC_TYPE_ROM_KANA_CONVERTER);
}


/**
         * Check if a character is a valid conversion input.
         *
         * @param uc unichar
         * @return `true` if uc is in a valid range, `false` otherwise
         */
gboolean kkc_rom_kana_converter_is_valid (KkcRomKanaConverter* self, gunichar uc) {
	gboolean result = FALSE;
	gunichar _tmp0_ = 0U;
	guint8 mask = 0U;
	gunichar _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	KkcRomKanaNode* _tmp3_ = NULL;
	gunichar _tmp4_ = 0U;
	guint8 _tmp5_ = 0U;
	guint8 _tmp6_ = 0U;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = uc;
	if (_tmp0_ > ((gunichar) 256)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = uc;
	mask = (guint8) (1 << (_tmp1_ % 8));
	_tmp3_ = self->priv->current_node;
	_tmp4_ = uc;
	_tmp5_ = _tmp3_->valid[_tmp4_ / 8];
	_tmp6_ = mask;
	if (((gint) (_tmp5_ & _tmp6_)) != 0) {
		_tmp2_ = TRUE;
	} else {
		KkcRomKanaMapFile* _tmp7_ = NULL;
		KkcRomKanaNode* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		guint8 _tmp10_ = 0U;
		guint8 _tmp11_ = 0U;
		_tmp7_ = self->priv->_rule;
		_tmp8_ = _tmp7_->root_node;
		_tmp9_ = uc;
		_tmp10_ = _tmp8_->valid[_tmp9_ / 8];
		_tmp11_ = mask;
		_tmp2_ = ((gint) (_tmp10_ & _tmp11_)) != 0;
	}
	_tmp12_ = _tmp2_;
	result = _tmp12_;
	return result;
}


/**
         * Finish pending input, if any.
         *
         * Note that this does not reset pending input/output and the
         * current node if there is no partial output.
         *
         * @return `true` if there is partial output, `false` otherwise
         */
gboolean kkc_rom_kana_converter_flush_partial (KkcRomKanaConverter* self) {
	gboolean result = FALSE;
	gchar* output = NULL;
	gboolean _tmp0_ = FALSE;
	KkcRomKanaNode* _tmp1_ = NULL;
	KkcRomKanaEntry* _tmp2_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp29_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current_node;
	_tmp2_ = _tmp1_->entry;
	if (_tmp2_ != NULL) {
		KkcRomKanaNode* _tmp3_ = NULL;
		KkcRomKanaEntry* _tmp4_ = NULL;
		KkcKanaMode _tmp5_ = 0;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp3_ = self->priv->current_node;
		_tmp4_ = _tmp3_->entry;
		_tmp5_ = self->priv->_kana_mode;
		_tmp6_ = kkc_rom_kana_entry_get_kana (_tmp4_, _tmp5_, TRUE);
		_g_free0 (output);
		output = _tmp6_;
		_tmp7_ = output;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		KkcRomKanaCharacterList* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GString* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		KkcRomKanaCharacter _tmp17_ = {0};
		KkcRomKanaCharacter _tmp18_ = {0};
		GString* _tmp19_ = NULL;
		GString* _tmp20_ = NULL;
		KkcRomKanaMapFile* _tmp21_ = NULL;
		KkcRomKanaMapFile* _tmp22_ = NULL;
		KkcRomKanaNode* _tmp23_ = NULL;
		KkcRomKanaNode* _tmp24_ = NULL;
		_tmp11_ = self->priv->_produced;
		_tmp12_ = output;
		_tmp13_ = g_strdup (_tmp12_);
		_tmp14_ = self->priv->_pending_input;
		_tmp15_ = _tmp14_->str;
		_tmp16_ = g_strdup (_tmp15_);
		memset (&_tmp17_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp17_.output);
		_tmp17_.output = _tmp13_;
		_g_free0 (_tmp17_.input);
		_tmp17_.input = _tmp16_;
		_tmp18_ = _tmp17_;
		kkc_rom_kana_character_list_add (_tmp11_, &_tmp18_);
		kkc_rom_kana_character_destroy (&_tmp18_);
		_tmp19_ = self->priv->_pending_input;
		g_string_erase (_tmp19_, (gssize) 0, (gssize) (-1));
		_tmp20_ = self->priv->_pending_output;
		g_string_erase (_tmp20_, (gssize) 0, (gssize) (-1));
		_tmp21_ = kkc_rom_kana_converter_get_rule (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->root_node;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp24_;
		result = TRUE;
		_g_free0 (output);
		return result;
	}
	_tmp26_ = self->priv->_auto_correct;
	if (!_tmp26_) {
		GString* _tmp27_ = NULL;
		gssize _tmp28_ = 0L;
		_tmp27_ = self->priv->_pending_output;
		_tmp28_ = _tmp27_->len;
		_tmp25_ = _tmp28_ > ((gssize) 0);
	} else {
		_tmp25_ = FALSE;
	}
	_tmp29_ = _tmp25_;
	if (_tmp29_) {
		KkcRomKanaCharacterList* _tmp30_ = NULL;
		GString* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		GString* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		KkcRomKanaCharacter _tmp37_ = {0};
		KkcRomKanaCharacter _tmp38_ = {0};
		GString* _tmp39_ = NULL;
		GString* _tmp40_ = NULL;
		KkcRomKanaMapFile* _tmp41_ = NULL;
		KkcRomKanaMapFile* _tmp42_ = NULL;
		KkcRomKanaNode* _tmp43_ = NULL;
		KkcRomKanaNode* _tmp44_ = NULL;
		_tmp30_ = self->priv->_produced;
		_tmp31_ = self->priv->_pending_output;
		_tmp32_ = _tmp31_->str;
		_tmp33_ = g_strdup (_tmp32_);
		_tmp34_ = self->priv->_pending_input;
		_tmp35_ = _tmp34_->str;
		_tmp36_ = g_strdup (_tmp35_);
		memset (&_tmp37_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp37_.output);
		_tmp37_.output = _tmp33_;
		_g_free0 (_tmp37_.input);
		_tmp37_.input = _tmp36_;
		_tmp38_ = _tmp37_;
		kkc_rom_kana_character_list_add (_tmp30_, &_tmp38_);
		kkc_rom_kana_character_destroy (&_tmp38_);
		_tmp39_ = self->priv->_pending_input;
		g_string_erase (_tmp39_, (gssize) 0, (gssize) (-1));
		_tmp40_ = self->priv->_pending_output;
		g_string_erase (_tmp40_, (gssize) 0, (gssize) (-1));
		_tmp41_ = kkc_rom_kana_converter_get_rule (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_->root_node;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp44_;
		result = TRUE;
		_g_free0 (output);
		return result;
	}
	result = FALSE;
	_g_free0 (output);
	return result;
}


/**
         * Append text to the internal buffer.
         *
         * @param text a string
         */
void kkc_rom_kana_converter_append_text (KkcRomKanaConverter* self, const gchar* text) {
	gint index = 0;
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	index = 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		gunichar _tmp3_ = 0U;
		_tmp0_ = text;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		_tmp3_ = c;
		kkc_rom_kana_converter_append (self, _tmp3_);
	}
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean kkc_rom_kana_converter_append_punctuation (KkcRomKanaConverter* self, gunichar uc) {
	gboolean result = FALSE;
	gint index = 0;
	gunichar _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gint _tmp17_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	index = -1;
	_tmp0_ = uc;
	_tmp1_ = kkc_rom_kana_converter_is_valid (self, _tmp0_);
	if (_tmp1_) {
		KkcRomKanaNode* node = NULL;
		KkcRomKanaNode* _tmp2_ = NULL;
		gunichar _tmp3_ = 0U;
		KkcRomKanaNode* _tmp4_ = NULL;
		KkcRomKanaNode* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		KkcRomKanaNode* _tmp7_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp2_ = self->priv->current_node;
		_tmp3_ = uc;
		_tmp4_ = _tmp2_->children[_tmp3_];
		_tmp5_ = _g_object_ref0 (_tmp4_);
		node = _tmp5_;
		_tmp7_ = node;
		if (_tmp7_ != NULL) {
			KkcRomKanaNode* _tmp8_ = NULL;
			KkcRomKanaEntry* _tmp9_ = NULL;
			_tmp8_ = node;
			_tmp9_ = _tmp8_->entry;
			_tmp6_ = _tmp9_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp10_ = _tmp6_;
		if (_tmp10_) {
			KkcRomKanaNode* _tmp11_ = NULL;
			KkcRomKanaEntry* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			_tmp11_ = node;
			_tmp12_ = _tmp11_->entry;
			_tmp13_ = (*_tmp12_).hiragana;
			if (g_strcmp0 (_tmp13_, "。") == 0) {
				index = 0;
			} else {
				KkcRomKanaNode* _tmp14_ = NULL;
				KkcRomKanaEntry* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				_tmp14_ = node;
				_tmp15_ = _tmp14_->entry;
				_tmp16_ = (*_tmp15_).hiragana;
				if (g_strcmp0 (_tmp16_, "、") == 0) {
					index = 1;
				}
			}
		}
		_g_object_unref0 (node);
	}
	_tmp17_ = index;
	if (_tmp17_ >= 0) {
		KkcRomKanaNode* _tmp18_ = NULL;
		KkcRomKanaEntry* _tmp19_ = NULL;
		KkcPunctuationStyle _tmp29_ = 0;
		const gchar* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gunichar punctuation = 0U;
		KkcPunctuationStyle _tmp33_ = 0;
		const gchar* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gunichar _tmp36_ = 0U;
		KkcRomKanaCharacterList* _tmp37_ = NULL;
		gunichar _tmp38_ = 0U;
		gchar* _tmp39_ = NULL;
		gunichar _tmp40_ = 0U;
		gchar* _tmp41_ = NULL;
		KkcRomKanaCharacter _tmp42_ = {0};
		KkcRomKanaCharacter _tmp43_ = {0};
		GString* _tmp44_ = NULL;
		GString* _tmp45_ = NULL;
		KkcRomKanaMapFile* _tmp46_ = NULL;
		KkcRomKanaMapFile* _tmp47_ = NULL;
		KkcRomKanaNode* _tmp48_ = NULL;
		KkcRomKanaNode* _tmp49_ = NULL;
		_tmp18_ = self->priv->current_node;
		_tmp19_ = _tmp18_->entry;
		if (_tmp19_ != NULL) {
			KkcRomKanaCharacterList* _tmp20_ = NULL;
			GString* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			GString* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			KkcRomKanaCharacter _tmp27_ = {0};
			KkcRomKanaCharacter _tmp28_ = {0};
			_tmp20_ = self->priv->_produced;
			_tmp21_ = self->priv->_pending_output;
			_tmp22_ = _tmp21_->str;
			_tmp23_ = g_strdup (_tmp22_);
			_tmp24_ = self->priv->_pending_input;
			_tmp25_ = _tmp24_->str;
			_tmp26_ = g_strdup (_tmp25_);
			memset (&_tmp27_, 0, sizeof (KkcRomKanaCharacter));
			_g_free0 (_tmp27_.output);
			_tmp27_.output = _tmp23_;
			_g_free0 (_tmp27_.input);
			_tmp27_.input = _tmp26_;
			_tmp28_ = _tmp27_;
			kkc_rom_kana_character_list_add (_tmp20_, &_tmp28_);
			kkc_rom_kana_character_destroy (&_tmp28_);
		}
		_tmp29_ = self->priv->_punctuation_style;
		_tmp30_ = KKC_PUNCTUATION_RULE[_tmp29_];
		_tmp31_ = index;
		_tmp32_ = string_index_of_nth_char (_tmp30_, (glong) _tmp31_);
		index = _tmp32_;
		_tmp33_ = self->priv->_punctuation_style;
		_tmp34_ = KKC_PUNCTUATION_RULE[_tmp33_];
		_tmp35_ = index;
		_tmp36_ = string_get_char (_tmp34_, (glong) _tmp35_);
		punctuation = _tmp36_;
		_tmp37_ = self->priv->_produced;
		_tmp38_ = punctuation;
		_tmp39_ = g_unichar_to_string (_tmp38_);
		_tmp40_ = uc;
		_tmp41_ = g_unichar_to_string (_tmp40_);
		memset (&_tmp42_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp42_.output);
		_tmp42_.output = _tmp39_;
		_g_free0 (_tmp42_.input);
		_tmp42_.input = _tmp41_;
		_tmp43_ = _tmp42_;
		kkc_rom_kana_character_list_add (_tmp37_, &_tmp43_);
		kkc_rom_kana_character_destroy (&_tmp43_);
		_tmp44_ = self->priv->_pending_input;
		g_string_erase (_tmp44_, (gssize) 0, (gssize) (-1));
		_tmp45_ = self->priv->_pending_output;
		g_string_erase (_tmp45_, (gssize) 0, (gssize) (-1));
		_tmp46_ = kkc_rom_kana_converter_get_rule (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_->root_node;
		_tmp49_ = _g_object_ref0 (_tmp48_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp49_;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
         * Append a character to the internal buffer.
         *
         * @param uc an ASCII character
         *
         * @return `true` if the character is handled, `false` otherwise
         */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean kkc_rom_kana_converter_append (KkcRomKanaConverter* self, gunichar uc) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	KkcKanaMode _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	KkcRomKanaNode* child_node = NULL;
	KkcRomKanaNode* _tmp16_ = NULL;
	gunichar _tmp17_ = 0U;
	KkcRomKanaNode* _tmp18_ = NULL;
	KkcRomKanaNode* _tmp19_ = NULL;
	KkcRomKanaNode* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_kana_mode;
	if (_tmp1_ == KKC_KANA_MODE_LATIN) {
		_tmp0_ = TRUE;
	} else {
		KkcKanaMode _tmp2_ = 0;
		_tmp2_ = self->priv->_kana_mode;
		_tmp0_ = _tmp2_ == KKC_KANA_MODE_WIDE_LATIN;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gchar* input = NULL;
		gunichar _tmp4_ = 0U;
		gchar* _tmp5_ = NULL;
		gchar* output = NULL;
		const gchar* _tmp6_ = NULL;
		KkcKanaMode _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		KkcRomKanaCharacterList* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		KkcRomKanaCharacter _tmp14_ = {0};
		KkcRomKanaCharacter _tmp15_ = {0};
		_tmp4_ = uc;
		_tmp5_ = g_unichar_to_string (_tmp4_);
		input = _tmp5_;
		_tmp6_ = input;
		_tmp7_ = self->priv->_kana_mode;
		_tmp8_ = kkc_rom_kana_utils_convert_by_kana_mode (_tmp6_, _tmp7_);
		output = _tmp8_;
		_tmp9_ = self->priv->_produced;
		_tmp10_ = output;
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = input;
		_tmp13_ = g_strdup (_tmp12_);
		memset (&_tmp14_, 0, sizeof (KkcRomKanaCharacter));
		_g_free0 (_tmp14_.output);
		_tmp14_.output = _tmp11_;
		_g_free0 (_tmp14_.input);
		_tmp14_.input = _tmp13_;
		_tmp15_ = _tmp14_;
		kkc_rom_kana_character_list_add (_tmp9_, &_tmp15_);
		kkc_rom_kana_character_destroy (&_tmp15_);
		result = TRUE;
		_g_free0 (output);
		_g_free0 (input);
		return result;
	}
	_tmp16_ = self->priv->current_node;
	_tmp17_ = uc;
	_tmp18_ = _tmp16_->children[_tmp17_];
	_tmp19_ = _g_object_ref0 (_tmp18_);
	child_node = _tmp19_;
	_tmp20_ = child_node;
	if (_tmp20_ == NULL) {
		gboolean retval = FALSE;
		gboolean _tmp21_ = FALSE;
		gunichar _tmp22_ = 0U;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = kkc_rom_kana_converter_flush_partial (self);
		retval = _tmp21_;
		_tmp22_ = uc;
		_tmp23_ = kkc_rom_kana_converter_append_punctuation (self, _tmp22_);
		if (_tmp23_) {
			result = TRUE;
			_g_object_unref0 (child_node);
			return result;
		} else {
			KkcRomKanaMapFile* _tmp24_ = NULL;
			KkcRomKanaMapFile* _tmp25_ = NULL;
			KkcRomKanaNode* _tmp26_ = NULL;
			gunichar _tmp27_ = 0U;
			KkcRomKanaNode* _tmp28_ = NULL;
			_tmp24_ = kkc_rom_kana_converter_get_rule (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_->root_node;
			_tmp27_ = uc;
			_tmp28_ = _tmp26_->children[_tmp27_];
			if (_tmp28_ == NULL) {
				GString* _tmp29_ = NULL;
				GString* _tmp30_ = NULL;
				KkcRomKanaMapFile* _tmp31_ = NULL;
				KkcRomKanaMapFile* _tmp32_ = NULL;
				KkcRomKanaNode* _tmp33_ = NULL;
				KkcRomKanaNode* _tmp34_ = NULL;
				_tmp29_ = self->priv->_pending_input;
				g_string_erase (_tmp29_, (gssize) 0, (gssize) (-1));
				_tmp30_ = self->priv->_pending_output;
				g_string_erase (_tmp30_, (gssize) 0, (gssize) (-1));
				_tmp31_ = kkc_rom_kana_converter_get_rule (self);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_->root_node;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				_g_object_unref0 (self->priv->current_node);
				self->priv->current_node = _tmp34_;
				result = retval;
				_g_object_unref0 (child_node);
				return result;
			} else {
				KkcRomKanaNode* _tmp35_ = NULL;
				KkcRomKanaEntry* _tmp36_ = NULL;
				_tmp35_ = self->priv->current_node;
				_tmp36_ = _tmp35_->entry;
				if (_tmp36_ != NULL) {
					KkcRomKanaCharacterList* _tmp37_ = NULL;
					GString* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					GString* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gchar* _tmp43_ = NULL;
					KkcRomKanaCharacter _tmp44_ = {0};
					KkcRomKanaCharacter _tmp45_ = {0};
					GString* _tmp46_ = NULL;
					GString* _tmp47_ = NULL;
					KkcRomKanaMapFile* _tmp48_ = NULL;
					KkcRomKanaMapFile* _tmp49_ = NULL;
					KkcRomKanaNode* _tmp50_ = NULL;
					KkcRomKanaNode* _tmp51_ = NULL;
					gunichar _tmp52_ = 0U;
					gboolean _tmp53_ = FALSE;
					_tmp37_ = self->priv->_produced;
					_tmp38_ = self->priv->_pending_output;
					_tmp39_ = _tmp38_->str;
					_tmp40_ = g_strdup (_tmp39_);
					_tmp41_ = self->priv->_pending_input;
					_tmp42_ = _tmp41_->str;
					_tmp43_ = g_strdup (_tmp42_);
					memset (&_tmp44_, 0, sizeof (KkcRomKanaCharacter));
					_g_free0 (_tmp44_.output);
					_tmp44_.output = _tmp40_;
					_g_free0 (_tmp44_.input);
					_tmp44_.input = _tmp43_;
					_tmp45_ = _tmp44_;
					kkc_rom_kana_character_list_add (_tmp37_, &_tmp45_);
					kkc_rom_kana_character_destroy (&_tmp45_);
					_tmp46_ = self->priv->_pending_input;
					g_string_erase (_tmp46_, (gssize) 0, (gssize) (-1));
					_tmp47_ = self->priv->_pending_output;
					g_string_erase (_tmp47_, (gssize) 0, (gssize) (-1));
					_tmp48_ = kkc_rom_kana_converter_get_rule (self);
					_tmp49_ = _tmp48_;
					_tmp50_ = _tmp49_->root_node;
					_tmp51_ = _g_object_ref0 (_tmp50_);
					_g_object_unref0 (self->priv->current_node);
					self->priv->current_node = _tmp51_;
					_tmp52_ = uc;
					_tmp53_ = kkc_rom_kana_converter_append (self, _tmp52_);
					result = _tmp53_;
					_g_object_unref0 (child_node);
					return result;
				} else {
					gboolean _tmp54_ = FALSE;
					_tmp54_ = self->priv->_auto_correct;
					if (_tmp54_) {
						GString* _tmp55_ = NULL;
						GString* _tmp56_ = NULL;
						KkcRomKanaMapFile* _tmp57_ = NULL;
						KkcRomKanaMapFile* _tmp58_ = NULL;
						KkcRomKanaNode* _tmp59_ = NULL;
						KkcRomKanaNode* _tmp60_ = NULL;
						gunichar _tmp61_ = 0U;
						gboolean _tmp62_ = FALSE;
						_tmp55_ = self->priv->_pending_input;
						g_string_erase (_tmp55_, (gssize) 0, (gssize) (-1));
						_tmp56_ = self->priv->_pending_output;
						g_string_erase (_tmp56_, (gssize) 0, (gssize) (-1));
						_tmp57_ = kkc_rom_kana_converter_get_rule (self);
						_tmp58_ = _tmp57_;
						_tmp59_ = _tmp58_->root_node;
						_tmp60_ = _g_object_ref0 (_tmp59_);
						_g_object_unref0 (self->priv->current_node);
						self->priv->current_node = _tmp60_;
						_tmp61_ = uc;
						_tmp62_ = kkc_rom_kana_converter_append (self, _tmp61_);
						result = _tmp62_;
						_g_object_unref0 (child_node);
						return result;
					} else {
						KkcRomKanaCharacterList* _tmp63_ = NULL;
						GString* _tmp64_ = NULL;
						const gchar* _tmp65_ = NULL;
						gchar* _tmp66_ = NULL;
						GString* _tmp67_ = NULL;
						const gchar* _tmp68_ = NULL;
						gchar* _tmp69_ = NULL;
						KkcRomKanaCharacter _tmp70_ = {0};
						KkcRomKanaCharacter _tmp71_ = {0};
						GString* _tmp72_ = NULL;
						GString* _tmp73_ = NULL;
						KkcRomKanaMapFile* _tmp74_ = NULL;
						KkcRomKanaMapFile* _tmp75_ = NULL;
						KkcRomKanaNode* _tmp76_ = NULL;
						KkcRomKanaNode* _tmp77_ = NULL;
						gunichar _tmp78_ = 0U;
						gboolean _tmp79_ = FALSE;
						_tmp63_ = self->priv->_produced;
						_tmp64_ = self->priv->_pending_output;
						_tmp65_ = _tmp64_->str;
						_tmp66_ = g_strdup (_tmp65_);
						_tmp67_ = self->priv->_pending_input;
						_tmp68_ = _tmp67_->str;
						_tmp69_ = g_strdup (_tmp68_);
						memset (&_tmp70_, 0, sizeof (KkcRomKanaCharacter));
						_g_free0 (_tmp70_.output);
						_tmp70_.output = _tmp66_;
						_g_free0 (_tmp70_.input);
						_tmp70_.input = _tmp69_;
						_tmp71_ = _tmp70_;
						kkc_rom_kana_character_list_add (_tmp63_, &_tmp71_);
						kkc_rom_kana_character_destroy (&_tmp71_);
						_tmp72_ = self->priv->_pending_input;
						g_string_erase (_tmp72_, (gssize) 0, (gssize) (-1));
						_tmp73_ = self->priv->_pending_output;
						g_string_erase (_tmp73_, (gssize) 0, (gssize) (-1));
						_tmp74_ = kkc_rom_kana_converter_get_rule (self);
						_tmp75_ = _tmp74_;
						_tmp76_ = _tmp75_->root_node;
						_tmp77_ = _g_object_ref0 (_tmp76_);
						_g_object_unref0 (self->priv->current_node);
						self->priv->current_node = _tmp77_;
						_tmp78_ = uc;
						_tmp79_ = kkc_rom_kana_converter_append (self, _tmp78_);
						result = _tmp79_;
						_g_object_unref0 (child_node);
						return result;
					}
				}
			}
		}
	} else {
		KkcRomKanaNode* _tmp80_ = NULL;
		guint _tmp81_ = 0U;
		_tmp80_ = child_node;
		_tmp81_ = _tmp80_->n_children;
		if (_tmp81_ > ((guint) 0)) {
			KkcRomKanaNode* _tmp82_ = NULL;
			KkcRomKanaEntry* _tmp83_ = NULL;
			KkcRomKanaNode* _tmp96_ = NULL;
			KkcRomKanaNode* _tmp97_ = NULL;
			_tmp82_ = child_node;
			_tmp83_ = _tmp82_->entry;
			if (_tmp83_ != NULL) {
				GString* _tmp84_ = NULL;
				gunichar _tmp85_ = 0U;
				GString* _tmp86_ = NULL;
				KkcRomKanaNode* _tmp87_ = NULL;
				KkcRomKanaEntry* _tmp88_ = NULL;
				KkcKanaMode _tmp89_ = 0;
				gchar* _tmp90_ = NULL;
				gchar* _tmp91_ = NULL;
				_tmp84_ = self->priv->_pending_input;
				_tmp85_ = uc;
				g_string_append_unichar (_tmp84_, _tmp85_);
				_tmp86_ = self->priv->_pending_output;
				_tmp87_ = child_node;
				_tmp88_ = _tmp87_->entry;
				_tmp89_ = self->priv->_kana_mode;
				_tmp90_ = kkc_rom_kana_entry_get_kana (_tmp88_, _tmp89_, FALSE);
				_tmp91_ = _tmp90_;
				g_string_append (_tmp86_, _tmp91_);
				_g_free0 (_tmp91_);
			} else {
				GString* _tmp92_ = NULL;
				gunichar _tmp93_ = 0U;
				GString* _tmp94_ = NULL;
				gunichar _tmp95_ = 0U;
				_tmp92_ = self->priv->_pending_input;
				_tmp93_ = uc;
				g_string_append_unichar (_tmp92_, _tmp93_);
				_tmp94_ = self->priv->_pending_output;
				_tmp95_ = uc;
				g_string_append_unichar (_tmp94_, _tmp95_);
			}
			_tmp96_ = child_node;
			_tmp97_ = _g_object_ref0 (_tmp96_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp97_;
			result = TRUE;
			_g_object_unref0 (child_node);
			return result;
		} else {
			gunichar _tmp98_ = 0U;
			gboolean _tmp99_ = FALSE;
			GString* _tmp100_ = NULL;
			gunichar _tmp101_ = 0U;
			KkcRomKanaCharacterList* _tmp102_ = NULL;
			KkcRomKanaNode* _tmp103_ = NULL;
			KkcRomKanaEntry* _tmp104_ = NULL;
			KkcKanaMode _tmp105_ = 0;
			gchar* _tmp106_ = NULL;
			GString* _tmp107_ = NULL;
			const gchar* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			KkcRomKanaCharacter _tmp110_ = {0};
			KkcRomKanaCharacter _tmp111_ = {0};
			GString* _tmp112_ = NULL;
			GString* _tmp113_ = NULL;
			KkcRomKanaMapFile* _tmp114_ = NULL;
			KkcRomKanaMapFile* _tmp115_ = NULL;
			KkcRomKanaNode* _tmp116_ = NULL;
			KkcRomKanaNode* _tmp117_ = NULL;
			_tmp98_ = uc;
			_tmp99_ = kkc_rom_kana_converter_append_punctuation (self, _tmp98_);
			if (_tmp99_) {
				result = TRUE;
				_g_object_unref0 (child_node);
				return result;
			}
			_tmp100_ = self->priv->_pending_input;
			_tmp101_ = uc;
			g_string_append_unichar (_tmp100_, _tmp101_);
			_tmp102_ = self->priv->_produced;
			_tmp103_ = child_node;
			_tmp104_ = _tmp103_->entry;
			_tmp105_ = self->priv->_kana_mode;
			_tmp106_ = kkc_rom_kana_entry_get_kana (_tmp104_, _tmp105_, FALSE);
			_tmp107_ = self->priv->_pending_input;
			_tmp108_ = _tmp107_->str;
			_tmp109_ = g_strdup (_tmp108_);
			memset (&_tmp110_, 0, sizeof (KkcRomKanaCharacter));
			_g_free0 (_tmp110_.output);
			_tmp110_.output = _tmp106_;
			_g_free0 (_tmp110_.input);
			_tmp110_.input = _tmp109_;
			_tmp111_ = _tmp110_;
			kkc_rom_kana_character_list_add (_tmp102_, &_tmp111_);
			kkc_rom_kana_character_destroy (&_tmp111_);
			_tmp112_ = self->priv->_pending_input;
			g_string_erase (_tmp112_, (gssize) 0, (gssize) (-1));
			_tmp113_ = self->priv->_pending_output;
			g_string_erase (_tmp113_, (gssize) 0, (gssize) (-1));
			_tmp114_ = kkc_rom_kana_converter_get_rule (self);
			_tmp115_ = _tmp114_;
			_tmp116_ = _tmp115_->root_node;
			_tmp117_ = _g_object_ref0 (_tmp116_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp117_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp118_ = FALSE;
					_tmp118_ = TRUE;
					while (TRUE) {
						gboolean _tmp119_ = FALSE;
						gint _tmp121_ = 0;
						KkcRomKanaNode* _tmp122_ = NULL;
						KkcRomKanaEntry* _tmp123_ = NULL;
						const gchar* _tmp124_ = NULL;
						gint _tmp125_ = 0;
						gint _tmp126_ = 0;
						KkcRomKanaNode* _tmp127_ = NULL;
						KkcRomKanaEntry* _tmp128_ = NULL;
						const gchar* _tmp129_ = NULL;
						gint _tmp130_ = 0;
						gchar _tmp131_ = '\0';
						_tmp119_ = _tmp118_;
						if (!_tmp119_) {
							gint _tmp120_ = 0;
							_tmp120_ = i;
							i = _tmp120_ + 1;
						}
						_tmp118_ = FALSE;
						_tmp121_ = i;
						_tmp122_ = child_node;
						_tmp123_ = _tmp122_->entry;
						_tmp124_ = (*_tmp123_).carryover;
						_tmp125_ = strlen (_tmp124_);
						_tmp126_ = _tmp125_;
						if (!(_tmp121_ < _tmp126_)) {
							break;
						}
						_tmp127_ = child_node;
						_tmp128_ = _tmp127_->entry;
						_tmp129_ = (*_tmp128_).carryover;
						_tmp130_ = i;
						_tmp131_ = string_get (_tmp129_, (glong) _tmp130_);
						kkc_rom_kana_converter_append (self, (gunichar) _tmp131_);
					}
				}
			}
			result = TRUE;
			_g_object_unref0 (child_node);
			return result;
		}
	}
	_g_object_unref0 (child_node);
}


/**
         * Check if a character will be consumed by the current conversion.
         *
         * @param uc an ASCII character
         * @param no_carryover return false if there will be carryover
         *
         * @return `true` if the character can be consumed
         */
gboolean kkc_rom_kana_converter_can_consume (KkcRomKanaConverter* self, gunichar uc, gboolean no_carryover) {
	gboolean result = FALSE;
	KkcRomKanaNode* child_node = NULL;
	KkcRomKanaNode* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	KkcRomKanaNode* _tmp2_ = NULL;
	KkcRomKanaNode* _tmp3_ = NULL;
	KkcRomKanaNode* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_node;
	_tmp1_ = uc;
	_tmp2_ = _tmp0_->children[_tmp1_];
	_tmp3_ = _g_object_ref0 (_tmp2_);
	child_node = _tmp3_;
	_tmp4_ = child_node;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_object_unref0 (child_node);
		return result;
	}
	_tmp7_ = no_carryover;
	if (_tmp7_) {
		KkcRomKanaNode* _tmp8_ = NULL;
		KkcRomKanaEntry* _tmp9_ = NULL;
		_tmp8_ = child_node;
		_tmp9_ = _tmp8_->entry;
		_tmp6_ = _tmp9_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = _tmp6_;
	if (_tmp10_) {
		KkcRomKanaNode* _tmp11_ = NULL;
		KkcRomKanaEntry* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp11_ = child_node;
		_tmp12_ = _tmp11_->entry;
		_tmp13_ = (*_tmp12_).carryover;
		_tmp5_ = g_strcmp0 (_tmp13_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp14_ = _tmp5_;
	if (_tmp14_) {
		result = FALSE;
		_g_object_unref0 (child_node);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (child_node);
	return result;
}


/**
         * Reset the internal state of the converter.
         */
void kkc_rom_kana_converter_reset (KkcRomKanaConverter* self) {
	KkcRomKanaCharacterList* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	KkcRomKanaMapFile* _tmp3_ = NULL;
	KkcRomKanaMapFile* _tmp4_ = NULL;
	KkcRomKanaNode* _tmp5_ = NULL;
	KkcRomKanaNode* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_produced;
	kkc_rom_kana_character_list_clear (_tmp0_);
	_tmp1_ = self->priv->_pending_input;
	g_string_erase (_tmp1_, (gssize) 0, (gssize) (-1));
	_tmp2_ = self->priv->_pending_output;
	g_string_erase (_tmp2_, (gssize) 0, (gssize) (-1));
	_tmp3_ = kkc_rom_kana_converter_get_rule (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->root_node;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->current_node);
	self->priv->current_node = _tmp6_;
}


/**
         * Delete the trailing character from the internal buffer.
         *
         * @return `true` if any character is removed, `false` otherwise
         */
gboolean kkc_rom_kana_converter_delete (KkcRomKanaConverter* self) {
	gboolean result = FALSE;
	GString* _tmp0_ = NULL;
	gssize _tmp1_ = 0L;
	KkcRomKanaCharacterList* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pending_output;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((gssize) 0)) {
		KkcRomKanaNode* _tmp2_ = NULL;
		KkcRomKanaNode* _tmp3_ = NULL;
		KkcRomKanaNode* _tmp4_ = NULL;
		KkcRomKanaNode* _tmp5_ = NULL;
		GString* _tmp10_ = NULL;
		GString* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GString* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GString* _tmp17_ = NULL;
		GString* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GString* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp2_ = self->priv->current_node;
		_tmp3_ = _tmp2_->parent;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->current_node);
		self->priv->current_node = _tmp4_;
		_tmp5_ = self->priv->current_node;
		if (_tmp5_ == NULL) {
			KkcRomKanaMapFile* _tmp6_ = NULL;
			KkcRomKanaMapFile* _tmp7_ = NULL;
			KkcRomKanaNode* _tmp8_ = NULL;
			KkcRomKanaNode* _tmp9_ = NULL;
			_tmp6_ = kkc_rom_kana_converter_get_rule (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_->root_node;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (self->priv->current_node);
			self->priv->current_node = _tmp9_;
		}
		_tmp10_ = self->priv->_pending_output;
		_tmp11_ = self->priv->_pending_output;
		_tmp12_ = _tmp11_->str;
		_tmp13_ = self->priv->_pending_output;
		_tmp14_ = _tmp13_->str;
		_tmp15_ = g_utf8_strlen (_tmp14_, (gssize) (-1));
		_tmp16_ = string_index_of_nth_char (_tmp12_, (glong) (_tmp15_ - 1));
		g_string_truncate (_tmp10_, (gsize) _tmp16_);
		_tmp17_ = self->priv->_pending_input;
		_tmp18_ = self->priv->_pending_input;
		_tmp19_ = _tmp18_->str;
		_tmp20_ = self->priv->_pending_input;
		_tmp21_ = _tmp20_->str;
		_tmp22_ = g_utf8_strlen (_tmp21_, (gssize) (-1));
		_tmp23_ = string_index_of_nth_char (_tmp19_, (glong) (_tmp22_ - 1));
		g_string_truncate (_tmp17_, (gsize) _tmp23_);
		result = TRUE;
		return result;
	}
	_tmp24_ = self->priv->_produced;
	_tmp25_ = kkc_rom_kana_character_list_get_size (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ > 0) {
		KkcRomKanaCharacterList* _tmp27_ = NULL;
		KkcRomKanaCharacterList* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp27_ = self->priv->_produced;
		_tmp28_ = self->priv->_produced;
		_tmp29_ = kkc_rom_kana_character_list_get_size (_tmp28_);
		_tmp30_ = _tmp29_;
		kkc_rom_kana_character_list_remove_at (_tmp27_, _tmp30_ - 1);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


KkcRomKanaMapFile* kkc_rom_kana_converter_get_rule (KkcRomKanaConverter* self) {
	KkcRomKanaMapFile* result;
	KkcRomKanaMapFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rule;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_rule (KkcRomKanaConverter* self, KkcRomKanaMapFile* value) {
	KkcRomKanaMapFile* _tmp0_ = NULL;
	KkcRomKanaMapFile* _tmp1_ = NULL;
	KkcRomKanaMapFile* _tmp2_ = NULL;
	KkcRomKanaNode* _tmp3_ = NULL;
	KkcRomKanaNode* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_rule);
	self->priv->_rule = _tmp1_;
	_tmp2_ = self->priv->_rule;
	_tmp3_ = _tmp2_->root_node;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->current_node);
	self->priv->current_node = _tmp4_;
	g_object_notify ((GObject *) self, "rule");
}


KkcKanaMode kkc_rom_kana_converter_get_kana_mode (KkcRomKanaConverter* self) {
	KkcKanaMode result;
	KkcKanaMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_kana_mode;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_kana_mode (KkcRomKanaConverter* self, KkcKanaMode value) {
	KkcKanaMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_kana_mode = _tmp0_;
	g_object_notify ((GObject *) self, "kana-mode");
}


KkcPunctuationStyle kkc_rom_kana_converter_get_punctuation_style (KkcRomKanaConverter* self) {
	KkcPunctuationStyle result;
	KkcPunctuationStyle _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_punctuation_style;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_punctuation_style (KkcRomKanaConverter* self, KkcPunctuationStyle value) {
	KkcPunctuationStyle _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_punctuation_style = _tmp0_;
	g_object_notify ((GObject *) self, "punctuation-style");
}


gboolean kkc_rom_kana_converter_get_auto_correct (KkcRomKanaConverter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_auto_correct;
	result = _tmp0_;
	return result;
}


void kkc_rom_kana_converter_set_auto_correct (KkcRomKanaConverter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_auto_correct = _tmp0_;
	g_object_notify ((GObject *) self, "auto-correct");
}


const gchar* kkc_rom_kana_converter_get_pending_output (KkcRomKanaConverter* self) {
	const gchar* result;
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pending_output;
	_tmp1_ = _tmp0_->str;
	result = _tmp1_;
	return result;
}


const gchar* kkc_rom_kana_converter_get_pending_input (KkcRomKanaConverter* self) {
	const gchar* result;
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pending_input;
	_tmp1_ = _tmp0_->str;
	result = _tmp1_;
	return result;
}


KkcRomKanaCharacterList* kkc_rom_kana_converter_get_produced (KkcRomKanaConverter* self) {
	KkcRomKanaCharacterList* result;
	KkcRomKanaCharacterList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_produced;
	result = _tmp0_;
	return result;
}


static void kkc_rom_kana_converter_class_init (KkcRomKanaConverterClass * klass) {
	kkc_rom_kana_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcRomKanaConverterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_rom_kana_converter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_rom_kana_converter_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_rom_kana_converter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_RULE, g_param_spec_object ("rule", "rule", "rule", KKC_TYPE_ROM_KANA_MAP_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The current kana mode.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_KANA_MODE, g_param_spec_enum ("kana-mode", "kana-mode", "kana-mode", KKC_TYPE_KANA_MODE, KKC_KANA_MODE_HIRAGANA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The current punctuation style.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE, g_param_spec_enum ("punctuation-style", "punctuation-style", "punctuation-style", KKC_TYPE_PUNCTUATION_STYLE, KKC_PUNCTUATION_STYLE_JA_JA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The current auto correct flag.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_AUTO_CORRECT, g_param_spec_boolean ("auto-correct", "auto-correct", "auto-correct", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The output being processed.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT, g_param_spec_string ("pending-output", "pending-output", "pending-output", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * The input being processed.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PENDING_INPUT, g_param_spec_string ("pending-input", "pending-input", "pending-input", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * A list of already processed characters.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_ROM_KANA_CONVERTER_PRODUCED, g_param_spec_object ("produced", "produced", "produced", KKC_TYPE_ROM_KANA_CHARACTER_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_rom_kana_converter_instance_init (KkcRomKanaConverter * self) {
	GString* _tmp0_ = NULL;
	GString* _tmp1_ = NULL;
	KkcRomKanaCharacterList* _tmp2_ = NULL;
	self->priv = KKC_ROM_KANA_CONVERTER_GET_PRIVATE (self);
	self->priv->_kana_mode = KKC_KANA_MODE_HIRAGANA;
	self->priv->_punctuation_style = KKC_PUNCTUATION_STYLE_JA_JA;
	self->priv->_auto_correct = TRUE;
	_tmp0_ = g_string_new ("");
	self->priv->_pending_output = _tmp0_;
	_tmp1_ = g_string_new ("");
	self->priv->_pending_input = _tmp1_;
	_tmp2_ = kkc_rom_kana_character_list_new ();
	self->priv->_produced = _tmp2_;
}


static void kkc_rom_kana_converter_finalize (GObject* obj) {
	KkcRomKanaConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter);
	_g_object_unref0 (self->priv->_rule);
	_g_object_unref0 (self->priv->current_node);
	_g_string_free0 (self->priv->_pending_output);
	_g_string_free0 (self->priv->_pending_input);
	_g_object_unref0 (self->priv->_produced);
	G_OBJECT_CLASS (kkc_rom_kana_converter_parent_class)->finalize (obj);
}


/**
     * Romaji-to-kana converter.
     */
GType kkc_rom_kana_converter_get_type (void) {
	static volatile gsize kkc_rom_kana_converter_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_rom_kana_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcRomKanaConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_rom_kana_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcRomKanaConverter), 0, (GInstanceInitFunc) kkc_rom_kana_converter_instance_init, NULL };
		GType kkc_rom_kana_converter_type_id;
		kkc_rom_kana_converter_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcRomKanaConverter", &g_define_type_info, 0);
		g_once_init_leave (&kkc_rom_kana_converter_type_id__volatile, kkc_rom_kana_converter_type_id);
	}
	return kkc_rom_kana_converter_type_id__volatile;
}


static void _vala_kkc_rom_kana_converter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcRomKanaConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter);
	switch (property_id) {
		case KKC_ROM_KANA_CONVERTER_RULE:
		g_value_set_object (value, kkc_rom_kana_converter_get_rule (self));
		break;
		case KKC_ROM_KANA_CONVERTER_KANA_MODE:
		g_value_set_enum (value, kkc_rom_kana_converter_get_kana_mode (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE:
		g_value_set_enum (value, kkc_rom_kana_converter_get_punctuation_style (self));
		break;
		case KKC_ROM_KANA_CONVERTER_AUTO_CORRECT:
		g_value_set_boolean (value, kkc_rom_kana_converter_get_auto_correct (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PENDING_OUTPUT:
		g_value_set_string (value, kkc_rom_kana_converter_get_pending_output (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PENDING_INPUT:
		g_value_set_string (value, kkc_rom_kana_converter_get_pending_input (self));
		break;
		case KKC_ROM_KANA_CONVERTER_PRODUCED:
		g_value_set_object (value, kkc_rom_kana_converter_get_produced (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_rom_kana_converter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcRomKanaConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter);
	switch (property_id) {
		case KKC_ROM_KANA_CONVERTER_RULE:
		kkc_rom_kana_converter_set_rule (self, g_value_get_object (value));
		break;
		case KKC_ROM_KANA_CONVERTER_KANA_MODE:
		kkc_rom_kana_converter_set_kana_mode (self, g_value_get_enum (value));
		break;
		case KKC_ROM_KANA_CONVERTER_PUNCTUATION_STYLE:
		kkc_rom_kana_converter_set_punctuation_style (self, g_value_get_enum (value));
		break;
		case KKC_ROM_KANA_CONVERTER_AUTO_CORRECT:
		kkc_rom_kana_converter_set_auto_correct (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



