/* system-segment-dictionary.c generated by valac 0.22.1, the Vala compiler
 * generated from system-segment-dictionary.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SEGMENT_DICTIONARY (kkc_segment_dictionary_get_type ())
#define KKC_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionary))
#define KKC_IS_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_DICTIONARY))
#define KKC_SEGMENT_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionaryIface))

typedef struct _KkcSegmentDictionary KkcSegmentDictionary;
typedef struct _KkcSegmentDictionaryIface KkcSegmentDictionaryIface;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;

#define KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY (kkc_system_segment_dictionary_get_type ())
#define KKC_SYSTEM_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionary))
#define KKC_SYSTEM_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionaryClass))
#define KKC_IS_SYSTEM_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY))
#define KKC_IS_SYSTEM_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY))
#define KKC_SYSTEM_SEGMENT_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionaryClass))

typedef struct _KkcSystemSegmentDictionary KkcSystemSegmentDictionary;
typedef struct _KkcSystemSegmentDictionaryClass KkcSystemSegmentDictionaryClass;
typedef struct _KkcSystemSegmentDictionaryPrivate KkcSystemSegmentDictionaryPrivate;

#define KKC_TYPE_ENCODING_CONVERTER (kkc_encoding_converter_get_type ())
#define KKC_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverter))
#define KKC_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterClass))
#define KKC_IS_ENCODING_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ENCODING_CONVERTER))
#define KKC_IS_ENCODING_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ENCODING_CONVERTER))
#define KKC_ENCODING_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ENCODING_CONVERTER, KkcEncodingConverterClass))

typedef struct _KkcEncodingConverter KkcEncodingConverter;
typedef struct _KkcEncodingConverterClass KkcEncodingConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

struct _KkcSegmentDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_candidates) (KkcSegmentDictionary* self, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
	gchar** (*complete) (KkcSegmentDictionary* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
	gboolean (*purge_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
};

struct _KkcSystemSegmentDictionary {
	GObject parent_instance;
	KkcSystemSegmentDictionaryPrivate * priv;
};

struct _KkcSystemSegmentDictionaryClass {
	GObjectClass parent_class;
};

struct _KkcSystemSegmentDictionaryPrivate {
	GFile* file;
	GMappedFile* mmap;
	gchar* etag;
	KkcEncodingConverter* converter;
	glong okuri_ari_offset;
	glong okuri_nasi_offset;
};

typedef enum  {
	KKC_DICTIONARY_ERROR_NOT_READABLE,
	KKC_DICTIONARY_ERROR_MALFORMED_INPUT
} KkcDictionaryError;
#define KKC_DICTIONARY_ERROR kkc_dictionary_error_quark ()

static gpointer kkc_system_segment_dictionary_parent_class = NULL;
static KkcDictionaryIface* kkc_system_segment_dictionary_kkc_dictionary_parent_iface = NULL;
static KkcSegmentDictionaryIface* kkc_system_segment_dictionary_kkc_segment_dictionary_parent_iface = NULL;

GType kkc_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
GType kkc_segment_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_system_segment_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_encoding_converter_get_type (void) G_GNUC_CONST;
#define KKC_SYSTEM_SEGMENT_DICTIONARY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionaryPrivate))
enum  {
	KKC_SYSTEM_SEGMENT_DICTIONARY_DUMMY_PROPERTY
};
static gchar* kkc_system_segment_dictionary_read_line (KkcSystemSegmentDictionary* self, glong* offset);
static gchar* kkc_system_segment_dictionary_read_previous_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line);
static gchar* kkc_system_segment_dictionary_read_next_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line);
static gboolean kkc_system_segment_dictionary_read_until (KkcSystemSegmentDictionary* self, glong* offset, const gchar* line);
static void kkc_system_segment_dictionary_load (KkcSystemSegmentDictionary* self, GError** error);
GQuark kkc_dictionary_error_quark (void);
gchar* kkc_encoding_converter_extract_coding_system (const gchar* line);
KkcEncodingConverter* kkc_encoding_converter_new_from_coding_system (const gchar* coding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_construct_from_coding_system (GType object_type, const gchar* coding, GError** error);
static void kkc_system_segment_dictionary_real_reload (KkcDictionary* base, GError** error);
static gboolean kkc_system_segment_dictionary_search_pos (KkcSystemSegmentDictionary* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar** line, gint direction);
static gboolean kkc_system_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
gchar* kkc_encoding_converter_encode (KkcEncodingConverter* self, const gchar* internal_str, GError** error);
gchar* kkc_encoding_converter_decode (KkcEncodingConverter* self, const gchar* external_str, GError** error);
KkcCandidate** kkc_dictionary_utils_split_candidates (const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static gint kkc_system_segment_dictionary_strcmp_prefix (const gchar* a, const gchar* b);
static gchar** kkc_system_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1);
static gint _kkc_system_segment_dictionary_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b);
KkcSystemSegmentDictionary* kkc_system_segment_dictionary_new (const gchar* path, const gchar* encoding, GError** error);
KkcSystemSegmentDictionary* kkc_system_segment_dictionary_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_new (const gchar* encoding, GError** error);
KkcEncodingConverter* kkc_encoding_converter_construct (GType object_type, const gchar* encoding, GError** error);
static void kkc_system_segment_dictionary_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar* kkc_system_segment_dictionary_read_line (KkcSystemSegmentDictionary* self, glong* offset) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
	GMappedFile* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	gchar* p = NULL;
	GMappedFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	glong _tmp5_ = 0L;
	glong _tmp12_ = 0L;
	GString* builder = NULL;
	GString* _tmp15_ = NULL;
	glong _offset = 0L;
	glong _tmp16_ = 0L;
	GString* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = g_mapped_file_get_length (_tmp1_);
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp2_, NULL);
	_tmp3_ = self->priv->mmap;
	_tmp4_ = g_mapped_file_get_contents (_tmp3_);
	_tmp5_ = *offset;
	p = ((gchar*) _tmp4_) + _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			glong _tmp10_ = 0L;
			gchar* _tmp11_ = NULL;
			_tmp7_ = _tmp6_;
			if (!_tmp7_) {
				glong _tmp8_ = 0L;
				gchar* _tmp9_ = NULL;
				_tmp8_ = *offset;
				*offset = _tmp8_ - 1;
				_tmp9_ = p;
				p = _tmp9_ - 1;
			}
			_tmp6_ = FALSE;
			_tmp10_ = *offset;
			if (!(_tmp10_ > ((glong) 0))) {
				break;
			}
			_tmp11_ = p;
			if ((*_tmp11_) == '\n') {
				break;
			}
		}
	}
	_tmp12_ = *offset;
	if (_tmp12_ > ((glong) 0)) {
		glong _tmp13_ = 0L;
		gchar* _tmp14_ = NULL;
		_tmp13_ = *offset;
		*offset = _tmp13_ + 1;
		_tmp14_ = p;
		p = _tmp14_ + 1;
	}
	_tmp15_ = g_string_new ("");
	builder = _tmp15_;
	_tmp16_ = *offset;
	_offset = _tmp16_;
	{
		gboolean _tmp17_ = FALSE;
		_tmp17_ = TRUE;
		while (TRUE) {
			gboolean _tmp18_ = FALSE;
			glong _tmp21_ = 0L;
			GMappedFile* _tmp22_ = NULL;
			gsize _tmp23_ = 0UL;
			gchar* _tmp24_ = NULL;
			GString* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			_tmp18_ = _tmp17_;
			if (!_tmp18_) {
				glong _tmp19_ = 0L;
				gchar* _tmp20_ = NULL;
				_tmp19_ = _offset;
				_offset = _tmp19_ + 1;
				_tmp20_ = p;
				p = _tmp20_ + 1;
			}
			_tmp17_ = FALSE;
			_tmp21_ = _offset;
			_tmp22_ = self->priv->mmap;
			_tmp23_ = g_mapped_file_get_length (_tmp22_);
			if (!(((gsize) _tmp21_) < _tmp23_)) {
				break;
			}
			_tmp24_ = p;
			if ((*_tmp24_) == '\n') {
				break;
			}
			_tmp25_ = builder;
			_tmp26_ = p;
			g_string_append_c (_tmp25_, *_tmp26_);
		}
	}
	_tmp27_ = builder;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = g_strdup (_tmp28_);
	result = _tmp29_;
	_g_string_free0 (builder);
	return result;
}


static gchar* kkc_system_segment_dictionary_read_previous_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	if (_tmp0_ < ((glong) 2)) {
		result = NULL;
		return result;
	}
	_tmp1_ = *pos;
	*pos = _tmp1_ - 2;
	_tmp2_ = kkc_system_segment_dictionary_read_line (self, pos);
	result = _tmp2_;
	return result;
}


static gchar* kkc_system_segment_dictionary_read_next_line (KkcSystemSegmentDictionary* self, glong* pos, const gchar* line) {
	gchar* result = NULL;
	glong _tmp0_ = 0L;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GMappedFile* _tmp4_ = NULL;
	gsize _tmp5_ = 0UL;
	glong _tmp6_ = 0L;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_tmp0_ = *pos;
	_tmp1_ = line;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->mmap;
	_tmp5_ = g_mapped_file_get_length (_tmp4_);
	if (((gsize) ((_tmp0_ + _tmp3_) + 1)) >= _tmp5_) {
		result = NULL;
		return result;
	}
	_tmp6_ = *pos;
	_tmp7_ = line;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	*pos = _tmp6_ + (_tmp9_ + 1);
	_tmp10_ = kkc_system_segment_dictionary_read_line (self, pos);
	result = _tmp10_;
	return result;
}


static gboolean kkc_system_segment_dictionary_read_until (KkcSystemSegmentDictionary* self, glong* offset, const gchar* line) {
	gboolean result = FALSE;
	glong _tmp0_ = 0L;
	GMappedFile* _tmp1_ = NULL;
	gsize _tmp2_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = *offset;
	_tmp1_ = self->priv->mmap;
	_tmp2_ = g_mapped_file_get_length (_tmp1_);
	g_return_val_if_fail (((gsize) _tmp0_) < _tmp2_, NULL);
	while (TRUE) {
		glong _tmp3_ = 0L;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GMappedFile* _tmp7_ = NULL;
		gsize _tmp8_ = 0UL;
		gchar* p = NULL;
		GMappedFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		glong _tmp11_ = 0L;
		gboolean _tmp12_ = FALSE;
		gchar* _tmp13_ = NULL;
		gboolean _tmp20_ = FALSE;
		glong _tmp25_ = 0L;
		_tmp3_ = *offset;
		_tmp4_ = line;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->mmap;
		_tmp8_ = g_mapped_file_get_length (_tmp7_);
		if (!(((gsize) (_tmp3_ + _tmp6_)) < _tmp8_)) {
			break;
		}
		_tmp9_ = self->priv->mmap;
		_tmp10_ = g_mapped_file_get_contents (_tmp9_);
		_tmp11_ = *offset;
		p = ((gchar*) _tmp10_) + _tmp11_;
		_tmp13_ = p;
		if ((*_tmp13_) == '\n') {
			gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp14_ = p;
			_tmp15_ = line;
			_tmp16_ = line;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = memcmp (_tmp14_ + 1, (void*) _tmp15_, (gsize) _tmp18_);
			_tmp12_ = _tmp19_ == 0;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp20_ = _tmp12_;
		if (_tmp20_) {
			glong _tmp21_ = 0L;
			const gchar* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			_tmp21_ = *offset;
			_tmp22_ = line;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			*offset = _tmp21_ + _tmp24_;
			result = TRUE;
			return result;
		}
		_tmp25_ = *offset;
		*offset = _tmp25_ + 1;
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void kkc_system_segment_dictionary_load (KkcSystemSegmentDictionary* self, GError** error) {
	GMappedFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GMappedFile* _tmp4_ = NULL;
	GMappedFile* _tmp5_ = NULL;
	glong offset = 0L;
	gchar* line = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* coding = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp20_ = NULL;
	glong _tmp23_ = 0L;
	gboolean _tmp24_ = FALSE;
	glong _tmp26_ = 0L;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_mapped_file_new (_tmp3_, FALSE, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp0_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_g_mapped_file_unref0 (self->priv->mmap);
	self->priv->mmap = _tmp0_;
	offset = (glong) 0;
	_tmp6_ = kkc_system_segment_dictionary_read_line (self, &offset);
	line = _tmp6_;
	_tmp7_ = line;
	if (_tmp7_ == NULL) {
		GError* _tmp8_ = NULL;
		_tmp8_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't read the first line");
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		return;
	}
	_tmp9_ = line;
	_tmp10_ = kkc_encoding_converter_extract_coding_system (_tmp9_);
	coding = _tmp10_;
	_tmp11_ = coding;
	if (_tmp11_ != NULL) {
		{
			KkcEncodingConverter* _converter = NULL;
			const gchar* _tmp12_ = NULL;
			KkcEncodingConverter* _tmp13_ = NULL;
			KkcEncodingConverter* _tmp14_ = NULL;
			_tmp12_ = coding;
			_tmp13_ = kkc_encoding_converter_new_from_coding_system (_tmp12_, &_inner_error_);
			_converter = _tmp13_;
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
			_tmp14_ = _converter;
			if (_tmp14_ != NULL) {
				KkcEncodingConverter* _tmp15_ = NULL;
				KkcEncodingConverter* _tmp16_ = NULL;
				_tmp15_ = _converter;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (self->priv->converter);
				self->priv->converter = _tmp16_;
			}
			_g_object_unref0 (_converter);
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = coding;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("system-segment-dictionary.vala:104: can't create converter from coding" \
" system %s: %s", _tmp17_, _tmp19_);
			_g_error_free0 (e);
		}
		__finally13:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		}
	}
	_tmp20_ = line;
	if (g_strcmp0 (_tmp20_, ";; okuri-ari entries.") == 0) {
		offset = (glong) 0;
	} else {
		gboolean _tmp21_ = FALSE;
		_tmp21_ = kkc_system_segment_dictionary_read_until (self, &offset, ";; okuri-ari entries.\n");
		if (!_tmp21_) {
			GError* _tmp22_ = NULL;
			_tmp22_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
			_inner_error_ = _tmp22_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (coding);
			_g_free0 (line);
			return;
		}
	}
	_tmp23_ = offset;
	self->priv->okuri_ari_offset = _tmp23_;
	_tmp24_ = kkc_system_segment_dictionary_read_until (self, &offset, ";; okuri-nasi entries.\n");
	if (!_tmp24_) {
		GError* _tmp25_ = NULL;
		_tmp25_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no okuri-nasi boundary");
		_inner_error_ = _tmp25_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (coding);
		_g_free0 (line);
		return;
	}
	_tmp26_ = offset;
	self->priv->okuri_nasi_offset = _tmp26_;
	_g_free0 (coding);
	_g_free0 (line);
}


/**
         * {@inheritDoc}
         */
static void kkc_system_segment_dictionary_real_reload (KkcDictionary* base, GError** error) {
	KkcSystemSegmentDictionary * self;
	gchar* attributes = NULL;
	gchar* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcSystemSegmentDictionary*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = attributes;
	_tmp3_ = g_file_query_info (_tmp1_, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_etag (_tmp4_);
	_tmp6_ = self->priv->etag;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		GFileInfo* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		kkc_system_segment_dictionary_load (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
		_tmp7_ = info;
		_tmp8_ = g_file_info_get_etag (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->etag);
		self->priv->etag = _tmp9_;
	}
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gboolean kkc_system_segment_dictionary_search_pos (KkcSystemSegmentDictionary* self, const gchar* midasi, glong start_offset, glong end_offset, GCompareFunc cmp, glong* pos, gchar** line, gint direction) {
	glong _vala_pos = 0L;
	gchar* _vala_line = NULL;
	gboolean result = FALSE;
	glong offset = 0L;
	glong _tmp0_ = 0L;
	glong _tmp1_ = 0L;
	glong _tmp2_ = 0L;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = start_offset;
	_tmp1_ = end_offset;
	_tmp2_ = start_offset;
	offset = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
	while (TRUE) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		GMappedFile* _tmp6_ = NULL;
		gsize _tmp7_ = 0UL;
		gchar* _line = NULL;
		gchar* _tmp8_ = NULL;
		gint index = 0;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint r = 0;
		GCompareFunc _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		glong _tmp32_ = 0L;
		glong _tmp33_ = 0L;
		glong _tmp34_ = 0L;
		_tmp3_ = start_offset;
		_tmp4_ = end_offset;
		if (!(_tmp3_ <= _tmp4_)) {
			break;
		}
		_tmp5_ = offset;
		_tmp6_ = self->priv->mmap;
		_tmp7_ = g_mapped_file_get_length (_tmp6_);
		_vala_assert (((gsize) _tmp5_) < _tmp7_, "offset < mmap.get_length ()");
		_tmp8_ = kkc_system_segment_dictionary_read_line (self, &offset);
		_line = _tmp8_;
		_tmp9_ = _line;
		_tmp10_ = string_index_of (_tmp9_, " ", 0);
		index = _tmp10_;
		_tmp11_ = index;
		if (_tmp11_ < 1) {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = _line;
			g_warning ("system-segment-dictionary.vala:150: corrupted dictionary entry: %s", _tmp12_);
			_g_free0 (_line);
			break;
		}
		_tmp13_ = cmp;
		_tmp14_ = _line;
		_tmp15_ = index;
		_tmp16_ = string_slice (_tmp14_, (glong) 0, (glong) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = midasi;
		_tmp19_ = _tmp13_ (_tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp17_);
		r = _tmp20_;
		_tmp21_ = r;
		if (_tmp21_ == 0) {
			glong _tmp22_ = 0L;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			_tmp22_ = offset;
			_vala_pos = _tmp22_;
			_tmp23_ = _line;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (_vala_line);
			_vala_line = _tmp24_;
			result = TRUE;
			_g_free0 (_line);
			if (pos) {
				*pos = _vala_pos;
			}
			if (line) {
				*line = _vala_line;
			} else {
				_g_free0 (_vala_line);
			}
			return result;
		}
		_tmp25_ = r;
		_tmp26_ = direction;
		if ((_tmp25_ * _tmp26_) > 0) {
			glong _tmp27_ = 0L;
			_tmp27_ = offset;
			end_offset = _tmp27_ - 2;
		} else {
			glong _tmp28_ = 0L;
			const gchar* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			_tmp28_ = offset;
			_tmp29_ = _line;
			_tmp30_ = strlen (_tmp29_);
			_tmp31_ = _tmp30_;
			start_offset = (_tmp28_ + _tmp31_) + 1;
		}
		_tmp32_ = start_offset;
		_tmp33_ = end_offset;
		_tmp34_ = start_offset;
		offset = _tmp32_ + ((_tmp33_ - _tmp34_) / 2);
		_g_free0 (_line);
	}
	_vala_pos = (glong) (-1);
	_g_free0 (_vala_line);
	_vala_line = NULL;
	result = FALSE;
	if (pos) {
		*pos = _vala_pos;
	}
	if (line) {
		*line = _vala_line;
	} else {
		_g_free0 (_vala_line);
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_system_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1) {
	KkcSystemSegmentDictionary * self;
	KkcCandidate** _vala_candidates = NULL;
	int _vala_candidates_length1 = 0;
	gboolean result = FALSE;
	GMappedFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	glong start_offset = 0L;
	glong end_offset = 0L;
	gboolean _tmp3_ = FALSE;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_ = NULL;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	GCompareFunc _tmp22_ = NULL;
	gint _tmp23_ = 0;
	glong _tmp24_ = 0L;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	KkcCandidate** _tmp50_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcSystemSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_contents (_tmp0_);
	if (_tmp1_ == NULL) {
		KkcCandidate** _tmp2_ = NULL;
		_tmp2_ = g_new0 (KkcCandidate*, 0 + 1);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp2_;
		_vala_candidates_length1 = 0;
		result = FALSE;
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	}
	_tmp3_ = okuri;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp4_ = self->priv->okuri_ari_offset;
		start_offset = _tmp4_;
		_tmp5_ = self->priv->okuri_nasi_offset;
		end_offset = _tmp5_;
	} else {
		glong _tmp6_ = 0L;
		GMappedFile* _tmp7_ = NULL;
		gsize _tmp8_ = 0UL;
		_tmp6_ = self->priv->okuri_nasi_offset;
		start_offset = _tmp6_;
		_tmp7_ = self->priv->mmap;
		_tmp8_ = g_mapped_file_get_length (_tmp7_);
		end_offset = ((glong) _tmp8_) - 1;
	}
	{
		gchar* _tmp9_ = NULL;
		KkcEncodingConverter* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp10_ = self->priv->converter;
		_tmp11_ = midasi;
		_tmp12_ = kkc_encoding_converter_encode (_tmp10_, _tmp11_, &_inner_error_);
		_tmp9_ = _tmp12_;
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_g_free0 (_midasi);
		_midasi = _tmp9_;
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		KkcCandidate** _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = midasi;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("system-segment-dictionary.vala:196: can't encode %s: %s", _tmp13_, _tmp15_);
		_tmp16_ = g_new0 (KkcCandidate*, 0 + 1);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp16_;
		_vala_candidates_length1 = 0;
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		_g_free0 (_midasi);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp18_ = okuri;
	if (_tmp18_) {
		_tmp17_ = -1;
	} else {
		_tmp17_ = 1;
	}
	_tmp19_ = _midasi;
	_tmp20_ = start_offset;
	_tmp21_ = end_offset;
	_tmp22_ = g_strcmp0;
	_tmp23_ = _tmp17_;
	_tmp26_ = kkc_system_segment_dictionary_search_pos (self, _tmp19_, _tmp20_, _tmp21_, _tmp22_, &_tmp24_, &_tmp25_, _tmp23_);
	pos = _tmp24_;
	_g_free0 (line);
	line = _tmp25_;
	if (_tmp26_) {
		gint index = 0;
		const gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gchar* _line = NULL;
		gint _tmp29_ = 0;
		_tmp27_ = line;
		_tmp28_ = string_index_of (_tmp27_, " ", 0);
		index = _tmp28_;
		_tmp29_ = index;
		if (_tmp29_ > 0) {
			const gchar* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
			const gchar* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			KkcCandidate** _tmp49_ = NULL;
			{
				gchar* _tmp30_ = NULL;
				KkcEncodingConverter* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				const gchar* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				_tmp31_ = self->priv->converter;
				_tmp32_ = line;
				_tmp33_ = index;
				_tmp34_ = line;
				_tmp35_ = strlen (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = string_slice (_tmp32_, (glong) _tmp33_, (glong) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = kkc_encoding_converter_decode (_tmp31_, _tmp38_, &_inner_error_);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				_tmp30_ = _tmp40_;
				if (_inner_error_ != NULL) {
					goto __catch15_g_error;
				}
				_g_free0 (_line);
				_line = _tmp30_;
			}
			goto __finally15;
			__catch15_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp41_ = NULL;
				GError* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				KkcCandidate** _tmp44_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp41_ = line;
				_tmp42_ = e;
				_tmp43_ = _tmp42_->message;
				g_warning ("system-segment-dictionary.vala:216: can't decode line %s: %s", _tmp41_, _tmp43_);
				_tmp44_ = g_new0 (KkcCandidate*, 0 + 1);
				_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
				_vala_candidates = _tmp44_;
				_vala_candidates_length1 = 0;
				result = FALSE;
				_g_error_free0 (e);
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				if (candidates) {
					*candidates = _vala_candidates;
				} else {
					_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				if (candidates_length1) {
					*candidates_length1 = _vala_candidates_length1;
				}
				return result;
			}
			__finally15:
			if (_inner_error_ != NULL) {
				_g_free0 (_line);
				_g_free0 (line);
				_g_free0 (_midasi);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp45_ = midasi;
			_tmp46_ = okuri;
			_tmp47_ = _line;
			_tmp49_ = kkc_dictionary_utils_split_candidates (_tmp45_, _tmp46_, _tmp47_, &_tmp48_);
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			_vala_candidates = _tmp49_;
			_vala_candidates_length1 = _tmp48_;
			result = TRUE;
			_g_free0 (_line);
			_g_free0 (line);
			_g_free0 (_midasi);
			if (candidates) {
				*candidates = _vala_candidates;
			} else {
				_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
			}
			if (candidates_length1) {
				*candidates_length1 = _vala_candidates_length1;
			}
			return result;
		}
		_g_free0 (_line);
	}
	_tmp50_ = g_new0 (KkcCandidate*, 0 + 1);
	_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	_vala_candidates = _tmp50_;
	_vala_candidates_length1 = 0;
	result = FALSE;
	_g_free0 (line);
	_g_free0 (_midasi);
	if (candidates) {
		*candidates = _vala_candidates;
	} else {
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (candidates_length1) {
		*candidates_length1 = _vala_candidates_length1;
	}
	return result;
}


static gint kkc_system_segment_dictionary_strcmp_prefix (const gchar* a, const gchar* b) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GCompareFunc _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	_tmp2_ = g_str_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = 0;
		return result;
	}
	_tmp3_ = g_strcmp0;
	_tmp4_ = a;
	_tmp5_ = b;
	_tmp6_ = _tmp3_ (_tmp4_, _tmp5_);
	result = _tmp6_;
	return result;
}


/**
         * {@inheritDoc}
         */
static gint _kkc_system_segment_dictionary_strcmp_prefix_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = kkc_system_segment_dictionary_strcmp_prefix (a, b);
	return result;
}


static gchar** kkc_system_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1) {
	KkcSystemSegmentDictionary * self;
	gchar** result = NULL;
	GMappedFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GeeArrayList* completion = NULL;
	GeeArrayList* _tmp4_ = NULL;
	glong start_offset = 0L;
	glong end_offset = 0L;
	glong _tmp5_ = 0L;
	GMappedFile* _tmp6_ = NULL;
	gsize _tmp7_ = 0UL;
	gchar* _midasi = NULL;
	glong pos = 0L;
	gchar* line = NULL;
	const gchar* _tmp19_ = NULL;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GeeArrayList* _tmp91_ = NULL;
	gint _tmp92_ = 0;
	gpointer* _tmp93_ = NULL;
	gchar** _tmp94_ = NULL;
	gint _tmp94__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (KkcSystemSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = self->priv->mmap;
	_tmp1_ = g_mapped_file_get_contents (_tmp0_);
	if (_tmp1_ == NULL) {
		gchar** _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = g_new0 (gchar*, 0 + 1);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	completion = _tmp4_;
	_tmp5_ = self->priv->okuri_nasi_offset;
	start_offset = _tmp5_;
	_tmp6_ = self->priv->mmap;
	_tmp7_ = g_mapped_file_get_length (_tmp6_);
	end_offset = ((glong) _tmp7_) - 1;
	{
		gchar* _tmp8_ = NULL;
		KkcEncodingConverter* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = self->priv->converter;
		_tmp10_ = midasi;
		_tmp11_ = kkc_encoding_converter_encode (_tmp9_, _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_g_free0 (_midasi);
		_midasi = _tmp8_;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GeeArrayList* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gpointer* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = midasi;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("system-segment-dictionary.vala:254: can't decode %s: %s", _tmp12_, _tmp14_);
		_tmp15_ = completion;
		_tmp17_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp15_, &_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _tmp16_;
		if (result_length1) {
			*result_length1 = _tmp18__length1;
		}
		result = _tmp18_;
		_g_error_free0 (e);
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		return result;
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_free0 (_midasi);
		_g_object_unref0 (completion);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp19_ = _midasi;
	_tmp20_ = start_offset;
	_tmp21_ = end_offset;
	_tmp24_ = kkc_system_segment_dictionary_search_pos (self, _tmp19_, _tmp20_, _tmp21_, _kkc_system_segment_dictionary_strcmp_prefix_gcompare_func, &_tmp22_, &_tmp23_, 1);
	pos = _tmp22_;
	_g_free0 (line);
	line = _tmp23_;
	if (_tmp24_) {
		glong _pos = 0L;
		glong _tmp25_ = 0L;
		gchar* _line = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		glong _tmp59_ = 0L;
		const gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		_tmp25_ = pos;
		_pos = _tmp25_;
		_tmp26_ = line;
		_tmp27_ = g_strdup (_tmp26_);
		_line = _tmp27_;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				gint index = 0;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				_tmp29_ = _tmp28_;
				if (!_tmp29_) {
					gboolean _tmp30_ = FALSE;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					gboolean _tmp37_ = FALSE;
					_tmp31_ = line;
					_tmp32_ = kkc_system_segment_dictionary_read_previous_line (self, &pos, _tmp31_);
					_g_free0 (line);
					line = _tmp32_;
					_tmp33_ = line;
					if (_tmp33_ != NULL) {
						const gchar* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						_tmp34_ = line;
						_tmp35_ = _midasi;
						_tmp36_ = g_str_has_prefix (_tmp34_, _tmp35_);
						_tmp30_ = _tmp36_;
					} else {
						_tmp30_ = FALSE;
					}
					_tmp37_ = _tmp30_;
					if (!_tmp37_) {
						break;
					}
				}
				_tmp28_ = FALSE;
				_tmp38_ = line;
				_tmp39_ = string_index_of (_tmp38_, " ", 0);
				index = _tmp39_;
				_tmp40_ = index;
				if (_tmp40_ < 0) {
					const gchar* _tmp41_ = NULL;
					_tmp41_ = line;
					g_warning ("system-segment-dictionary.vala:274: corrupted dictionary entry: %s", _tmp41_);
				} else {
					gchar* completed = NULL;
					const gchar* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gchar* _tmp44_ = NULL;
					gboolean _tmp45_ = FALSE;
					const gchar* _tmp46_ = NULL;
					const gchar* _tmp47_ = NULL;
					gboolean _tmp50_ = FALSE;
					_tmp42_ = line;
					_tmp43_ = index;
					_tmp44_ = string_slice (_tmp42_, (glong) 0, (glong) _tmp43_);
					completed = _tmp44_;
					_tmp46_ = completed;
					_tmp47_ = _midasi;
					if (g_strcmp0 (_tmp46_, _tmp47_) != 0) {
						const gchar* _tmp48_ = NULL;
						gboolean _tmp49_ = FALSE;
						_tmp48_ = completed;
						_tmp49_ = g_str_has_suffix (_tmp48_, ">");
						_tmp45_ = !_tmp49_;
					} else {
						_tmp45_ = FALSE;
					}
					_tmp50_ = _tmp45_;
					if (_tmp50_) {
						{
							gchar* decoded = NULL;
							KkcEncodingConverter* _tmp51_ = NULL;
							const gchar* _tmp52_ = NULL;
							gchar* _tmp53_ = NULL;
							GeeArrayList* _tmp54_ = NULL;
							const gchar* _tmp55_ = NULL;
							_tmp51_ = self->priv->converter;
							_tmp52_ = completed;
							_tmp53_ = kkc_encoding_converter_decode (_tmp51_, _tmp52_, &_inner_error_);
							decoded = _tmp53_;
							if (_inner_error_ != NULL) {
								goto __catch17_g_error;
							}
							_tmp54_ = completion;
							_tmp55_ = decoded;
							gee_abstract_list_insert ((GeeAbstractList*) _tmp54_, 0, _tmp55_);
							_g_free0 (decoded);
						}
						goto __finally17;
						__catch17_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp56_ = NULL;
							GError* _tmp57_ = NULL;
							const gchar* _tmp58_ = NULL;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp56_ = line;
							_tmp57_ = e;
							_tmp58_ = _tmp57_->message;
							g_warning ("system-segment-dictionary.vala:285: can't decode line %s: %s", _tmp56_, _tmp58_);
							_g_error_free0 (e);
						}
						__finally17:
						if (_inner_error_ != NULL) {
							_g_free0 (completed);
							_g_free0 (_line);
							_g_free0 (line);
							_g_free0 (_midasi);
							_g_object_unref0 (completion);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_g_free0 (completed);
				}
			}
		}
		_tmp59_ = _pos;
		pos = _tmp59_;
		_tmp60_ = _line;
		_tmp61_ = g_strdup (_tmp60_);
		_g_free0 (line);
		line = _tmp61_;
		while (TRUE) {
			gboolean _tmp62_ = FALSE;
			const gchar* _tmp63_ = NULL;
			gchar* _tmp64_ = NULL;
			const gchar* _tmp65_ = NULL;
			gboolean _tmp69_ = FALSE;
			gint index = 0;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			_tmp63_ = line;
			_tmp64_ = kkc_system_segment_dictionary_read_next_line (self, &pos, _tmp63_);
			_g_free0 (line);
			line = _tmp64_;
			_tmp65_ = line;
			if (_tmp65_ != NULL) {
				const gchar* _tmp66_ = NULL;
				const gchar* _tmp67_ = NULL;
				gboolean _tmp68_ = FALSE;
				_tmp66_ = line;
				_tmp67_ = _midasi;
				_tmp68_ = g_str_has_prefix (_tmp66_, _tmp67_);
				_tmp62_ = _tmp68_;
			} else {
				_tmp62_ = FALSE;
			}
			_tmp69_ = _tmp62_;
			if (!_tmp69_) {
				break;
			}
			_tmp70_ = line;
			_tmp71_ = string_index_of (_tmp70_, " ", 0);
			index = _tmp71_;
			_tmp72_ = index;
			if (_tmp72_ < 0) {
				const gchar* _tmp73_ = NULL;
				_tmp73_ = line;
				g_warning ("system-segment-dictionary.vala:300: corrupted dictionary entry: %s", _tmp73_);
			} else {
				gchar* completed = NULL;
				const gchar* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gchar* _tmp76_ = NULL;
				gboolean _tmp77_ = FALSE;
				const gchar* _tmp78_ = NULL;
				const gchar* _tmp79_ = NULL;
				gboolean _tmp82_ = FALSE;
				_tmp74_ = line;
				_tmp75_ = index;
				_tmp76_ = string_slice (_tmp74_, (glong) 0, (glong) _tmp75_);
				completed = _tmp76_;
				_tmp78_ = completed;
				_tmp79_ = _midasi;
				if (g_strcmp0 (_tmp78_, _tmp79_) != 0) {
					const gchar* _tmp80_ = NULL;
					gboolean _tmp81_ = FALSE;
					_tmp80_ = completed;
					_tmp81_ = g_str_has_suffix (_tmp80_, ">");
					_tmp77_ = !_tmp81_;
				} else {
					_tmp77_ = FALSE;
				}
				_tmp82_ = _tmp77_;
				if (_tmp82_) {
					{
						gchar* decoded = NULL;
						KkcEncodingConverter* _tmp83_ = NULL;
						const gchar* _tmp84_ = NULL;
						gchar* _tmp85_ = NULL;
						GeeArrayList* _tmp86_ = NULL;
						const gchar* _tmp87_ = NULL;
						_tmp83_ = self->priv->converter;
						_tmp84_ = completed;
						_tmp85_ = kkc_encoding_converter_decode (_tmp83_, _tmp84_, &_inner_error_);
						decoded = _tmp85_;
						if (_inner_error_ != NULL) {
							goto __catch18_g_error;
						}
						_tmp86_ = completion;
						_tmp87_ = decoded;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
						_g_free0 (decoded);
					}
					goto __finally18;
					__catch18_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp88_ = NULL;
						GError* _tmp89_ = NULL;
						const gchar* _tmp90_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp88_ = line;
						_tmp89_ = e;
						_tmp90_ = _tmp89_->message;
						g_warning ("system-segment-dictionary.vala:311: can't decode line %s: %s", _tmp88_, _tmp90_);
						_g_error_free0 (e);
					}
					__finally18:
					if (_inner_error_ != NULL) {
						_g_free0 (completed);
						_g_free0 (_line);
						_g_free0 (line);
						_g_free0 (_midasi);
						_g_object_unref0 (completion);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_g_free0 (completed);
			}
		}
		_g_free0 (_line);
	}
	_tmp91_ = completion;
	_tmp93_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp91_, &_tmp92_);
	_tmp94_ = _tmp93_;
	_tmp94__length1 = _tmp92_;
	if (result_length1) {
		*result_length1 = _tmp94__length1;
	}
	result = _tmp94_;
	_g_free0 (line);
	_g_free0 (_midasi);
	_g_object_unref0 (completion);
	return result;
}


/**
         * Create a new SystemSegmentDictionary.
         *
         * @param path a path to the file
         * @param encoding encoding of the file (default EUC-JP)
         *
         * @return a new FileDictionary
         * @throws GLib.Error if opening the file is failed
         */
KkcSystemSegmentDictionary* kkc_system_segment_dictionary_construct (GType object_type, const gchar* path, const gchar* encoding, GError** error) {
	KkcSystemSegmentDictionary * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	KkcEncodingConverter* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	KkcEncodingConverter* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	g_return_val_if_fail (encoding != NULL, NULL);
	self = (KkcSystemSegmentDictionary*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp4_ = encoding;
	_tmp5_ = kkc_encoding_converter_new (_tmp4_, &_inner_error_);
	_tmp3_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->converter);
	self->priv->converter = _tmp3_;
	kkc_system_segment_dictionary_load (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcSystemSegmentDictionary* kkc_system_segment_dictionary_new (const gchar* path, const gchar* encoding, GError** error) {
	return kkc_system_segment_dictionary_construct (KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, path, encoding, error);
}


static void kkc_system_segment_dictionary_class_init (KkcSystemSegmentDictionaryClass * klass) {
	kkc_system_segment_dictionary_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcSystemSegmentDictionaryPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_system_segment_dictionary_finalize;
}


static void kkc_system_segment_dictionary_kkc_dictionary_interface_init (KkcDictionaryIface * iface) {
	kkc_system_segment_dictionary_kkc_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->reload = (void (*)(KkcDictionary*, GError**)) kkc_system_segment_dictionary_real_reload;
}


static void kkc_system_segment_dictionary_kkc_segment_dictionary_interface_init (KkcSegmentDictionaryIface * iface) {
	kkc_system_segment_dictionary_kkc_segment_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_candidates = (gboolean (*)(KkcSegmentDictionary*, const gchar*, gboolean, KkcCandidate***, int*)) kkc_system_segment_dictionary_real_lookup_candidates;
	iface->complete = (gchar** (*)(KkcSegmentDictionary*, const gchar*, int*)) kkc_system_segment_dictionary_real_complete;
}


static void kkc_system_segment_dictionary_instance_init (KkcSystemSegmentDictionary * self) {
	self->priv = KKC_SYSTEM_SEGMENT_DICTIONARY_GET_PRIVATE (self);
}


static void kkc_system_segment_dictionary_finalize (GObject* obj) {
	KkcSystemSegmentDictionary * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_SYSTEM_SEGMENT_DICTIONARY, KkcSystemSegmentDictionary);
	_g_object_unref0 (self->priv->file);
	_g_mapped_file_unref0 (self->priv->mmap);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->converter);
	G_OBJECT_CLASS (kkc_system_segment_dictionary_parent_class)->finalize (obj);
}


/**
     * Read-only file based implementation of Dictionary.
     */
GType kkc_system_segment_dictionary_get_type (void) {
	static volatile gsize kkc_system_segment_dictionary_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_system_segment_dictionary_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcSystemSegmentDictionaryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_system_segment_dictionary_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcSystemSegmentDictionary), 0, (GInstanceInitFunc) kkc_system_segment_dictionary_instance_init, NULL };
		static const GInterfaceInfo kkc_dictionary_info = { (GInterfaceInitFunc) kkc_system_segment_dictionary_kkc_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_segment_dictionary_info = { (GInterfaceInitFunc) kkc_system_segment_dictionary_kkc_segment_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_system_segment_dictionary_type_id;
		kkc_system_segment_dictionary_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcSystemSegmentDictionary", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_system_segment_dictionary_type_id, KKC_TYPE_DICTIONARY, &kkc_dictionary_info);
		g_type_add_interface_static (kkc_system_segment_dictionary_type_id, KKC_TYPE_SEGMENT_DICTIONARY, &kkc_segment_dictionary_info);
		g_once_init_leave (&kkc_system_segment_dictionary_type_id__volatile, kkc_system_segment_dictionary_type_id);
	}
	return kkc_system_segment_dictionary_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



