/* user-segment-dictionary.c generated by valac 0.22.1, the Vala compiler
 * generated from user-segment-dictionary.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>


#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SEGMENT_DICTIONARY (kkc_segment_dictionary_get_type ())
#define KKC_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionary))
#define KKC_IS_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_DICTIONARY))
#define KKC_SEGMENT_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SEGMENT_DICTIONARY, KkcSegmentDictionaryIface))

typedef struct _KkcSegmentDictionary KkcSegmentDictionary;
typedef struct _KkcSegmentDictionaryIface KkcSegmentDictionaryIface;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;

#define KKC_TYPE_USER_SEGMENT_DICTIONARY (kkc_user_segment_dictionary_get_type ())
#define KKC_USER_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionary))
#define KKC_USER_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionaryClass))
#define KKC_IS_USER_SEGMENT_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_USER_SEGMENT_DICTIONARY))
#define KKC_IS_USER_SEGMENT_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_USER_SEGMENT_DICTIONARY))
#define KKC_USER_SEGMENT_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionaryClass))

typedef struct _KkcUserSegmentDictionary KkcUserSegmentDictionary;
typedef struct _KkcUserSegmentDictionaryClass KkcUserSegmentDictionaryClass;
typedef struct _KkcUserSegmentDictionaryPrivate KkcUserSegmentDictionaryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

struct _KkcSegmentDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_candidates) (KkcSegmentDictionary* self, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
	gchar** (*complete) (KkcSegmentDictionary* self, const gchar* midasi, int* result_length1);
	gboolean (*select_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
	gboolean (*purge_candidate) (KkcSegmentDictionary* self, KkcCandidate* candidate);
};

struct _KkcUserSegmentDictionary {
	GObject parent_instance;
	KkcUserSegmentDictionaryPrivate * priv;
};

struct _KkcUserSegmentDictionaryClass {
	GObjectClass parent_class;
};

struct _KkcUserSegmentDictionaryPrivate {
	GFile* file;
	gchar* etag;
	GeeMap* okuri_ari_entries;
	GeeMap* okuri_nasi_entries;
	gboolean is_dirty;
};

typedef enum  {
	KKC_DICTIONARY_ERROR_NOT_READABLE,
	KKC_DICTIONARY_ERROR_MALFORMED_INPUT
} KkcDictionaryError;
#define KKC_DICTIONARY_ERROR kkc_dictionary_error_quark ()

static gpointer kkc_user_segment_dictionary_parent_class = NULL;
static KkcDictionaryIface* kkc_user_segment_dictionary_kkc_dictionary_parent_iface = NULL;
static KkcSegmentDictionaryIface* kkc_user_segment_dictionary_kkc_segment_dictionary_parent_iface = NULL;

GType kkc_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
GType kkc_segment_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_user_segment_dictionary_get_type (void) G_GNUC_CONST;
#define KKC_USER_SEGMENT_DICTIONARY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionaryPrivate))
enum  {
	KKC_USER_SEGMENT_DICTIONARY_DUMMY_PROPERTY
};
static void kkc_user_segment_dictionary_load (KkcUserSegmentDictionary* self, GError** error);
static guint8* _vala_array_dup3 (guint8* self, int length);
GQuark kkc_dictionary_error_quark (void);
gchar* kkc_dictionary_utils_unescape (const gchar* input);
KkcCandidate** kkc_dictionary_utils_split_candidates (const gchar* midasi, gboolean okuri, const gchar* line, int* result_length1);
static void kkc_user_segment_dictionary_real_reload (KkcDictionary* base, GError** error);
static gint kkc_user_segment_dictionary_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b);
static gint kkc_user_segment_dictionary_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b);
static void kkc_user_segment_dictionary_write_entries (KkcUserSegmentDictionary* self, GString* builder, GeeList* entries);
gchar* kkc_dictionary_utils_escape (const gchar* input);
gchar* kkc_dictionary_utils_join_candidates (KkcCandidate** candidates, int candidates_length1);
static void kkc_user_segment_dictionary_real_save (KkcDictionary* base, GError** error);
static GeeMap* kkc_user_segment_dictionary_get_entries (KkcUserSegmentDictionary* self, gboolean okuri);
static gboolean kkc_user_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1);
static gchar** kkc_user_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1);
static gboolean kkc_user_segment_dictionary_real_select_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate);
gboolean kkc_candidate_get_okuri (KkcCandidate* self);
const gchar* kkc_candidate_get_midasi (KkcCandidate* self);
static gboolean kkc_user_segment_dictionary_real_purge_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate);
const gchar* kkc_candidate_get_text (KkcCandidate* self);
KkcUserSegmentDictionary* kkc_user_segment_dictionary_new (const gchar* path, GError** error);
KkcUserSegmentDictionary* kkc_user_segment_dictionary_construct (GType object_type, const gchar* path, GError** error);
void kkc_dictionary_reload (KkcDictionary* self, GError** error);
static void kkc_user_segment_dictionary_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void kkc_user_segment_dictionary_load (KkcUserSegmentDictionary* self, GError** error) {
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gsize _tmp2_;
	gchar* _tmp3_ = NULL;
	GMemoryInputStream* memory = NULL;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GDestroyNotify _tmp6_ = NULL;
	GMemoryInputStream* _tmp7_ = NULL;
	GDataInputStream* data = NULL;
	GMemoryInputStream* _tmp8_ = NULL;
	GDataInputStream* _tmp9_ = NULL;
	gchar* line = NULL;
	gsize length = 0UL;
	gchar* _tmp10_ = NULL;
	GDataInputStream* _tmp11_ = NULL;
	gsize _tmp12_ = 0UL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GeeMap* entries = NULL;
	GeeMap* _tmp25_ = NULL;
	gboolean okuri = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
	contents = (g_free (contents), NULL);
	contents = _tmp1_;
	contents_length1 = _tmp2_;
	_contents_size_ = contents_length1;
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp4_ = contents;
	_tmp4__length1 = contents_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup3 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = g_free;
	_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp5_, _tmp5__length1, _tmp6_);
	memory = _tmp7_;
	_tmp8_ = memory;
	_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
	data = _tmp9_;
	line = NULL;
	_tmp11_ = data;
	_tmp13_ = g_data_input_stream_read_line (_tmp11_, &_tmp12_, NULL, &_inner_error_);
	length = _tmp12_;
	_tmp10_ = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_g_free0 (line);
	line = _tmp10_;
	_tmp14_ = line;
	if (_tmp14_ == NULL) {
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	entries = NULL;
	while (TRUE) {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gchar* _tmp20_ = NULL;
		GDataInputStream* _tmp21_ = NULL;
		gsize _tmp22_ = 0UL;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp15_ = line;
		if (!(_tmp15_ != NULL)) {
			break;
		}
		_tmp16_ = line;
		_tmp17_ = g_str_has_prefix (_tmp16_, ";; okuri-ari entries.");
		if (_tmp17_) {
			GeeMap* _tmp18_ = NULL;
			GeeMap* _tmp19_ = NULL;
			_tmp18_ = self->priv->okuri_ari_entries;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			_g_object_unref0 (entries);
			entries = _tmp19_;
			break;
		}
		_tmp21_ = data;
		_tmp23_ = g_data_input_stream_read_line (_tmp21_, &_tmp22_, NULL, &_inner_error_);
		length = _tmp22_;
		_tmp20_ = _tmp23_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (entries);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_g_free0 (line);
		line = _tmp20_;
		_tmp24_ = line;
		if (_tmp24_ == NULL) {
			break;
		}
	}
	_tmp25_ = entries;
	if (_tmp25_ == NULL) {
		GError* _tmp26_ = NULL;
		_tmp26_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no okuri-ari boundary");
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (entries);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	okuri = TRUE;
	while (TRUE) {
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		GDataInputStream* _tmp29_ = NULL;
		gsize _tmp30_ = 0UL;
		gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gboolean _tmp34_ = FALSE;
		gchar** strv = NULL;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar** _tmp40_ = NULL;
		gchar** _tmp41_ = NULL;
		gchar** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gchar* midasi = NULL;
		gchar** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* candidates_str = NULL;
		gchar** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		const gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		gboolean _tmp52_ = FALSE;
		const gchar* _tmp53_ = NULL;
		gboolean _tmp54_ = FALSE;
		gboolean _tmp57_ = FALSE;
		KkcCandidate** candidates = NULL;
		const gchar* _tmp60_ = NULL;
		gboolean _tmp61_ = FALSE;
		const gchar* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		KkcCandidate** _tmp64_ = NULL;
		gint candidates_length1 = 0;
		gint _candidates_size_ = 0;
		GeeArrayList* list = NULL;
		GeeArrayList* _tmp65_ = NULL;
		KkcCandidate** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		GeeMap* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		GeeArrayList* _tmp72_ = NULL;
		_tmp27_ = line;
		if (!(_tmp27_ != NULL)) {
			break;
		}
		_tmp29_ = data;
		_tmp31_ = g_data_input_stream_read_line (_tmp29_, &_tmp30_, NULL, &_inner_error_);
		length = _tmp30_;
		_tmp28_ = _tmp31_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (entries);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_g_free0 (line);
		line = _tmp28_;
		_tmp32_ = line;
		if (_tmp32_ == NULL) {
			break;
		}
		_tmp33_ = line;
		_tmp34_ = g_str_has_prefix (_tmp33_, ";; okuri-nasi entries.");
		if (_tmp34_) {
			GeeMap* _tmp35_ = NULL;
			GeeMap* _tmp36_ = NULL;
			_tmp35_ = self->priv->okuri_nasi_entries;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			_g_object_unref0 (entries);
			entries = _tmp36_;
			okuri = FALSE;
			continue;
		}
		_tmp37_ = line;
		_tmp38_ = string_strip (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp41_ = _tmp40_ = g_strsplit_set (_tmp39_, " \t", 2);
		_tmp42_ = _tmp41_;
		_tmp42__length1 = _vala_array_length (_tmp40_);
		_g_free0 (_tmp39_);
		strv = _tmp42_;
		strv_length1 = _tmp42__length1;
		_strv_size_ = strv_length1;
		_tmp43_ = strv;
		_tmp43__length1 = strv_length1;
		if (_tmp43__length1 < 2) {
			const gchar* _tmp44_ = NULL;
			GError* _tmp45_ = NULL;
			_tmp44_ = line;
			_tmp45_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp44_);
			_inner_error_ = _tmp45_;
			g_propagate_error (error, _inner_error_);
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (entries);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp46_ = strv;
		_tmp46__length1 = strv_length1;
		_tmp47_ = _tmp46_[0];
		_tmp48_ = kkc_dictionary_utils_unescape (_tmp47_);
		midasi = _tmp48_;
		_tmp49_ = strv;
		_tmp49__length1 = strv_length1;
		_tmp50_ = _tmp49_[1];
		_tmp51_ = g_strdup (_tmp50_);
		candidates_str = _tmp51_;
		_tmp53_ = candidates_str;
		_tmp54_ = g_str_has_prefix (_tmp53_, "/");
		if (!_tmp54_) {
			_tmp52_ = TRUE;
		} else {
			const gchar* _tmp55_ = NULL;
			gboolean _tmp56_ = FALSE;
			_tmp55_ = candidates_str;
			_tmp56_ = g_str_has_suffix (_tmp55_, "/");
			_tmp52_ = !_tmp56_;
		}
		_tmp57_ = _tmp52_;
		if (_tmp57_) {
			const gchar* _tmp58_ = NULL;
			GError* _tmp59_ = NULL;
			_tmp58_ = candidates_str;
			_tmp59_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp58_);
			_inner_error_ = _tmp59_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (candidates_str);
			_g_free0 (midasi);
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (entries);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp60_ = midasi;
		_tmp61_ = okuri;
		_tmp62_ = candidates_str;
		_tmp64_ = kkc_dictionary_utils_split_candidates (_tmp60_, _tmp61_, _tmp62_, &_tmp63_);
		candidates = _tmp64_;
		candidates_length1 = _tmp63_;
		_candidates_size_ = candidates_length1;
		_tmp65_ = gee_array_list_new (KKC_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		list = _tmp65_;
		_tmp66_ = candidates;
		_tmp66__length1 = candidates_length1;
		{
			KkcCandidate** c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
			c_collection = _tmp66_;
			c_collection_length1 = _tmp66__length1;
			for (c_it = 0; c_it < _tmp66__length1; c_it = c_it + 1) {
				KkcCandidate* _tmp67_ = NULL;
				KkcCandidate* c = NULL;
				_tmp67_ = _g_object_ref0 (c_collection[c_it]);
				c = _tmp67_;
				{
					GeeArrayList* _tmp68_ = NULL;
					KkcCandidate* _tmp69_ = NULL;
					_tmp68_ = list;
					_tmp69_ = c;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp69_);
					_g_object_unref0 (c);
				}
			}
		}
		_tmp70_ = entries;
		_tmp71_ = midasi;
		_tmp72_ = list;
		gee_map_set (_tmp70_, _tmp71_, (GeeList*) _tmp72_);
		_g_object_unref0 (list);
		candidates = (_vala_array_free (candidates, candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (candidates_str);
		_g_free0 (midasi);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (entries);
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}


/**
         * {@inheritDoc}
         */
static void kkc_user_segment_dictionary_real_reload (KkcDictionary* base, GError** error) {
	KkcUserSegmentDictionary * self;
	gchar* attributes = NULL;
	gchar* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcUserSegmentDictionary*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = attributes;
	_tmp3_ = g_file_query_info (_tmp1_, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_etag (_tmp4_);
	_tmp6_ = self->priv->etag;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		GeeMap* _tmp7_ = NULL;
		GeeMap* _tmp8_ = NULL;
		_tmp7_ = self->priv->okuri_ari_entries;
		gee_map_clear (_tmp7_);
		_tmp8_ = self->priv->okuri_nasi_entries;
		gee_map_clear (_tmp8_);
		kkc_user_segment_dictionary_load (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	self->priv->is_dirty = FALSE;
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


static gint kkc_user_segment_dictionary_compare_entry_asc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	GeeMapEntry* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GeeMapEntry* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gint kkc_user_segment_dictionary_compare_entry_dsc (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	GeeMapEntry* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GeeMapEntry* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = b;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static void kkc_user_segment_dictionary_write_entries (KkcUserSegmentDictionary* self, GString* builder, GeeList* entries) {
	GeeIterator* iter = NULL;
	GeeList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar* line = NULL;
		GeeMapEntry* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GeeMapEntry* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		GeeList* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gpointer* _tmp15_ = NULL;
		KkcCandidate** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GString* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_key (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = kkc_dictionary_utils_escape ((const gchar*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = entry;
		_tmp12_ = gee_map_entry_get_value (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp15_ = gee_collection_to_array ((GeeCollection*) ((GeeList*) _tmp13_), &_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _tmp14_;
		_tmp17_ = kkc_dictionary_utils_join_candidates (_tmp16_, _tmp14_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%s %s\n", _tmp10_, _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (_tmp10_);
		line = _tmp20_;
		_tmp21_ = builder;
		_tmp22_ = line;
		g_string_append (_tmp21_, _tmp22_);
		_g_free0 (line);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


/**
         * {@inheritDoc}
         */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void kkc_user_segment_dictionary_real_save (KkcDictionary* base, GError** error) {
	KkcUserSegmentDictionary * self;
	gboolean _tmp0_ = FALSE;
	GString* builder = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeMap* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
	GeeSet* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GString* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GeeArrayList* _tmp12_ = NULL;
	GString* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	GeeMap* _tmp15_ = NULL;
	GeeSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	GeeSet* _tmp18_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GString* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GeeArrayList* _tmp22_ = NULL;
	GFile* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	GString* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	guint8* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	guint8* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcUserSegmentDictionary*) base;
	_tmp0_ = self->priv->is_dirty;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = builder;
	g_string_append (_tmp2_, ";; okuri-ari entries.\n");
	_tmp3_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = self->priv->okuri_ari_entries;
	_tmp6_ = gee_map_get_entries (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp4_, (GeeCollection*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = entries;
	gee_list_sort ((GeeList*) _tmp9_, (GCompareFunc) kkc_user_segment_dictionary_compare_entry_dsc);
	_tmp10_ = builder;
	_tmp11_ = entries;
	kkc_user_segment_dictionary_write_entries (self, _tmp10_, (GeeList*) _tmp11_);
	_tmp12_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
	_tmp13_ = builder;
	g_string_append (_tmp13_, ";; okuri-nasi entries.\n");
	_tmp14_ = entries;
	_tmp15_ = self->priv->okuri_nasi_entries;
	_tmp16_ = gee_map_get_entries (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp14_, (GeeCollection*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = entries;
	gee_list_sort ((GeeList*) _tmp19_, (GCompareFunc) kkc_user_segment_dictionary_compare_entry_asc);
	_tmp20_ = builder;
	_tmp21_ = entries;
	kkc_user_segment_dictionary_write_entries (self, _tmp20_, (GeeList*) _tmp21_);
	_tmp22_ = entries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp22_);
	_tmp23_ = self->priv->file;
	_tmp24_ = g_file_get_path (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_path_get_dirname (_tmp25_);
	_tmp27_ = _tmp26_;
	g_mkdir_with_parents (_tmp27_, 448);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = self->priv->file;
	_tmp29_ = builder;
	_tmp30_ = _tmp29_->str;
	_tmp31_ = string_get_data (_tmp30_, &_tmp31__length1);
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _tmp31__length1;
	_tmp33_ = self->priv->etag;
	g_file_replace_contents (_tmp28_, _tmp32_, (gsize) _tmp32__length1, _tmp33_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp34_, NULL, &_inner_error_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp34_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (entries);
		_g_string_free0 (builder);
		return;
	}
	self->priv->is_dirty = FALSE;
	_g_object_unref0 (entries);
	_g_string_free0 (builder);
}


static GeeMap* kkc_user_segment_dictionary_get_entries (KkcUserSegmentDictionary* self, gboolean okuri) {
	GeeMap* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = okuri;
	if (_tmp0_) {
		GeeMap* _tmp1_ = NULL;
		GeeMap* _tmp2_ = NULL;
		_tmp1_ = self->priv->okuri_ari_entries;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GeeMap* _tmp3_ = NULL;
		GeeMap* _tmp4_ = NULL;
		_tmp3_ = self->priv->okuri_nasi_entries;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_segment_dictionary_real_lookup_candidates (KkcSegmentDictionary* base, const gchar* midasi, gboolean okuri, KkcCandidate*** candidates, int* candidates_length1) {
	KkcUserSegmentDictionary * self;
	KkcCandidate** _vala_candidates = NULL;
	int _vala_candidates_length1 = 0;
	gboolean result = FALSE;
	GeeMap* entries = NULL;
	gboolean _tmp0_ = FALSE;
	GeeMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, FALSE);
	_tmp0_ = okuri;
	_tmp1_ = kkc_user_segment_dictionary_get_entries (self, _tmp0_);
	entries = _tmp1_;
	_tmp2_ = entries;
	_tmp3_ = midasi;
	_tmp4_ = gee_map_has_key (_tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeMap* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gpointer* _tmp10_ = NULL;
		_tmp5_ = entries;
		_tmp6_ = midasi;
		_tmp7_ = gee_map_get (_tmp5_, _tmp6_);
		_tmp8_ = (GeeList*) _tmp7_;
		_tmp10_ = gee_collection_to_array ((GeeCollection*) _tmp8_, &_tmp9_);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp10_;
		_vala_candidates_length1 = _tmp9_;
		_g_object_unref0 (_tmp8_);
		result = TRUE;
		_g_object_unref0 (entries);
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	} else {
		KkcCandidate** _tmp11_ = NULL;
		_tmp11_ = g_new0 (KkcCandidate*, 0 + 1);
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		_vala_candidates = _tmp11_;
		_vala_candidates_length1 = 0;
		result = FALSE;
		_g_object_unref0 (entries);
		if (candidates) {
			*candidates = _vala_candidates;
		} else {
			_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		}
		if (candidates_length1) {
			*candidates_length1 = _vala_candidates_length1;
		}
		return result;
	}
	_g_object_unref0 (entries);
	if (candidates) {
		*candidates = _vala_candidates;
	} else {
		_vala_candidates = (_vala_array_free (_vala_candidates, _vala_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (candidates_length1) {
		*candidates_length1 = _vala_candidates_length1;
	}
}


/**
         * {@inheritDoc}
         */
static gchar** kkc_user_segment_dictionary_real_complete (KkcSegmentDictionary* base, const gchar* midasi, int* result_length1) {
	KkcUserSegmentDictionary * self;
	gchar** result = NULL;
	GeeList* completion = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeList* keys = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeList* _tmp7_ = NULL;
	GeeIterator* iter = NULL;
	GeeList* _tmp8_ = NULL;
	GeeIterator* _tmp9_ = NULL;
	GeeList* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gpointer* _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (midasi != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	completion = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	keys = (GeeList*) _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->okuri_nasi_entries;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_collection_add_all ((GeeCollection*) _tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort (_tmp7_, NULL);
	_tmp8_ = keys;
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
	iter = _tmp9_;
	while (TRUE) {
		GeeIterator* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gchar* key = NULL;
		GeeIterator* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp10_ = iter;
		_tmp11_ = gee_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = iter;
		_tmp13_ = gee_iterator_get (_tmp12_);
		key = (gchar*) _tmp13_;
		_tmp14_ = key;
		_tmp15_ = midasi;
		_tmp16_ = g_str_has_prefix (_tmp14_, _tmp15_);
		if (_tmp16_) {
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			_tmp17_ = key;
			_tmp18_ = midasi;
			if (g_strcmp0 (_tmp17_, _tmp18_) != 0) {
				GeeList* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				_tmp19_ = completion;
				_tmp20_ = key;
				gee_collection_add ((GeeCollection*) _tmp19_, _tmp20_);
			}
			_g_free0 (key);
			break;
		}
		_g_free0 (key);
	}
	while (TRUE) {
		GeeIterator* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gchar* key = NULL;
		GeeIterator* _tmp23_ = NULL;
		gpointer _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		_tmp21_ = iter;
		_tmp22_ = gee_iterator_next (_tmp21_);
		if (!_tmp22_) {
			break;
		}
		_tmp23_ = iter;
		_tmp24_ = gee_iterator_get (_tmp23_);
		key = (gchar*) _tmp24_;
		_tmp25_ = key;
		_tmp26_ = midasi;
		_tmp27_ = g_str_has_prefix (_tmp25_, _tmp26_);
		if (!_tmp27_) {
			_g_free0 (key);
			break;
		}
		_tmp28_ = key;
		_tmp29_ = midasi;
		if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
			GeeList* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			_tmp30_ = completion;
			_tmp31_ = key;
			gee_collection_add ((GeeCollection*) _tmp30_, _tmp31_);
		}
		_g_free0 (key);
	}
	_tmp32_ = completion;
	_tmp34_ = gee_collection_to_array ((GeeCollection*) _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_object_unref0 (iter);
	_g_object_unref0 (keys);
	_g_object_unref0 (completion);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_segment_dictionary_real_select_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate) {
	KkcUserSegmentDictionary * self;
	gboolean result = FALSE;
	GeeMap* entries = NULL;
	KkcCandidate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeMap* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	KkcCandidate* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GeeList* candidates = NULL;
	GeeMap* _tmp15_ = NULL;
	KkcCandidate* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gpointer _tmp19_ = NULL;
	gint index = 0;
	GeeList* _tmp20_ = NULL;
	KkcCandidate* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GeeList* _tmp29_ = NULL;
	KkcCandidate* _tmp30_ = NULL;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	_tmp0_ = candidate;
	_tmp1_ = kkc_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_user_segment_dictionary_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = kkc_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (!_tmp8_) {
		GeeMap* _tmp9_ = NULL;
		KkcCandidate* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GeeArrayList* _tmp13_ = NULL;
		GeeArrayList* _tmp14_ = NULL;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = kkc_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_array_list_new (KKC_TYPE_CANDIDATE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		_tmp14_ = _tmp13_;
		gee_map_set (_tmp9_, _tmp12_, (GeeList*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = entries;
	_tmp16_ = candidate;
	_tmp17_ = kkc_candidate_get_midasi (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_map_get (_tmp15_, _tmp18_);
	candidates = (GeeList*) _tmp19_;
	_tmp20_ = candidates;
	_tmp21_ = candidate;
	_tmp22_ = gee_list_index_of (_tmp20_, _tmp21_);
	index = _tmp22_;
	_tmp23_ = index;
	if (_tmp23_ == 0) {
		result = FALSE;
		_g_object_unref0 (candidates);
		_g_object_unref0 (entries);
		return result;
	}
	_tmp24_ = index;
	if (_tmp24_ > 0) {
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gpointer _tmp27_ = NULL;
		KkcCandidate* _tmp28_ = NULL;
		_tmp25_ = candidates;
		_tmp26_ = index;
		_tmp27_ = gee_list_remove_at (_tmp25_, _tmp26_);
		_tmp28_ = (KkcCandidate*) _tmp27_;
		_g_object_unref0 (_tmp28_);
	}
	_tmp29_ = candidates;
	_tmp30_ = candidate;
	gee_list_insert (_tmp29_, 0, _tmp30_);
	self->priv->is_dirty = TRUE;
	result = TRUE;
	_g_object_unref0 (candidates);
	_g_object_unref0 (entries);
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_segment_dictionary_real_purge_candidate (KkcSegmentDictionary* base, KkcCandidate* candidate) {
	KkcUserSegmentDictionary * self;
	gboolean result = FALSE;
	gboolean modified = FALSE;
	GeeMap* entries = NULL;
	KkcCandidate* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeMap* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	KkcCandidate* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp37_ = FALSE;
	self = (KkcUserSegmentDictionary*) base;
	g_return_val_if_fail (candidate != NULL, FALSE);
	modified = FALSE;
	_tmp0_ = candidate;
	_tmp1_ = kkc_candidate_get_okuri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_user_segment_dictionary_get_entries (self, _tmp2_);
	entries = _tmp3_;
	_tmp4_ = entries;
	_tmp5_ = candidate;
	_tmp6_ = kkc_candidate_get_midasi (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_map_has_key (_tmp4_, _tmp7_);
	if (_tmp8_) {
		GeeList* candidates = NULL;
		GeeMap* _tmp9_ = NULL;
		KkcCandidate* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		GeeList* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp9_ = entries;
		_tmp10_ = candidate;
		_tmp11_ = kkc_candidate_get_midasi (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_map_get (_tmp9_, _tmp12_);
		candidates = (GeeList*) _tmp13_;
		_tmp14_ = candidates;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ > 0) {
			GeeIterator* iter = NULL;
			GeeList* _tmp17_ = NULL;
			GeeIterator* _tmp18_ = NULL;
			GeeList* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			_tmp17_ = candidates;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			iter = _tmp18_;
			while (TRUE) {
				GeeIterator* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				KkcCandidate* c = NULL;
				GeeIterator* _tmp21_ = NULL;
				gpointer _tmp22_ = NULL;
				KkcCandidate* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				KkcCandidate* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				_tmp19_ = iter;
				_tmp20_ = gee_iterator_next (_tmp19_);
				if (!_tmp20_) {
					break;
				}
				_tmp21_ = iter;
				_tmp22_ = gee_iterator_get (_tmp21_);
				c = (KkcCandidate*) _tmp22_;
				_tmp23_ = c;
				_tmp24_ = kkc_candidate_get_text (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = candidate;
				_tmp27_ = kkc_candidate_get_text (_tmp26_);
				_tmp28_ = _tmp27_;
				if (g_strcmp0 (_tmp25_, _tmp28_) == 0) {
					GeeIterator* _tmp29_ = NULL;
					_tmp29_ = iter;
					gee_iterator_remove (_tmp29_);
					modified = TRUE;
				}
				_g_object_unref0 (c);
			}
			_tmp30_ = candidates;
			_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == 0) {
				GeeMap* _tmp33_ = NULL;
				KkcCandidate* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				_tmp33_ = entries;
				_tmp34_ = candidate;
				_tmp35_ = kkc_candidate_get_midasi (_tmp34_);
				_tmp36_ = _tmp35_;
				gee_map_unset (_tmp33_, _tmp36_, NULL);
			}
			_g_object_unref0 (iter);
		}
		_g_object_unref0 (candidates);
	}
	_tmp37_ = modified;
	if (_tmp37_) {
		self->priv->is_dirty = TRUE;
	}
	result = modified;
	_g_object_unref0 (entries);
	return result;
}


/**
         * Create a new UserSegmentDictionary.
         *
         * @param path a path to the file
         *
         * @return a new UserSegmentDictionary
         * @throws GLib.Error if opening the file is failed
         */
KkcUserSegmentDictionary* kkc_user_segment_dictionary_construct (GType object_type, const gchar* path, GError** error) {
	KkcUserSegmentDictionary * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (KkcUserSegmentDictionary*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (_tmp4_) {
		kkc_dictionary_reload ((KkcDictionary*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


KkcUserSegmentDictionary* kkc_user_segment_dictionary_new (const gchar* path, GError** error) {
	return kkc_user_segment_dictionary_construct (KKC_TYPE_USER_SEGMENT_DICTIONARY, path, error);
}


static void kkc_user_segment_dictionary_class_init (KkcUserSegmentDictionaryClass * klass) {
	kkc_user_segment_dictionary_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcUserSegmentDictionaryPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_user_segment_dictionary_finalize;
}


static void kkc_user_segment_dictionary_kkc_dictionary_interface_init (KkcDictionaryIface * iface) {
	kkc_user_segment_dictionary_kkc_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->reload = (void (*)(KkcDictionary*, GError**)) kkc_user_segment_dictionary_real_reload;
	iface->save = (void (*)(KkcDictionary*, GError**)) kkc_user_segment_dictionary_real_save;
}


static void kkc_user_segment_dictionary_kkc_segment_dictionary_interface_init (KkcSegmentDictionaryIface * iface) {
	kkc_user_segment_dictionary_kkc_segment_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_candidates = (gboolean (*)(KkcSegmentDictionary*, const gchar*, gboolean, KkcCandidate***, int*)) kkc_user_segment_dictionary_real_lookup_candidates;
	iface->complete = (gchar** (*)(KkcSegmentDictionary*, const gchar*, int*)) kkc_user_segment_dictionary_real_complete;
	iface->select_candidate = (gboolean (*)(KkcSegmentDictionary*, KkcCandidate*)) kkc_user_segment_dictionary_real_select_candidate;
	iface->purge_candidate = (gboolean (*)(KkcSegmentDictionary*, KkcCandidate*)) kkc_user_segment_dictionary_real_purge_candidate;
}


static void kkc_user_segment_dictionary_instance_init (KkcUserSegmentDictionary * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self->priv = KKC_USER_SEGMENT_DICTIONARY_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->okuri_ari_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->okuri_nasi_entries = (GeeMap*) _tmp1_;
}


static void kkc_user_segment_dictionary_finalize (GObject* obj) {
	KkcUserSegmentDictionary * self;
	GeeMapIterator* okuri_ari_iter = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	GeeMap* _tmp7_ = NULL;
	GeeMapIterator* okuri_nasi_iter = NULL;
	GeeMap* _tmp8_ = NULL;
	GeeMapIterator* _tmp9_ = NULL;
	GeeMap* _tmp15_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_USER_SEGMENT_DICTIONARY, KkcUserSegmentDictionary);
	_tmp0_ = self->priv->okuri_ari_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	okuri_ari_iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		_tmp2_ = okuri_ari_iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = okuri_ari_iter;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		_tmp6_ = (GeeList*) _tmp5_;
		gee_collection_clear ((GeeCollection*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = self->priv->okuri_ari_entries;
	gee_map_clear (_tmp7_);
	_tmp8_ = self->priv->okuri_nasi_entries;
	_tmp9_ = gee_map_map_iterator (_tmp8_);
	okuri_nasi_iter = _tmp9_;
	while (TRUE) {
		GeeMapIterator* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GeeMapIterator* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		GeeList* _tmp14_ = NULL;
		_tmp10_ = okuri_nasi_iter;
		_tmp11_ = gee_map_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = okuri_nasi_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		_tmp14_ = (GeeList*) _tmp13_;
		gee_collection_clear ((GeeCollection*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->okuri_nasi_entries;
	gee_map_clear (_tmp15_);
	_g_object_unref0 (okuri_nasi_iter);
	_g_object_unref0 (okuri_ari_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->okuri_ari_entries);
	_g_object_unref0 (self->priv->okuri_nasi_entries);
	G_OBJECT_CLASS (kkc_user_segment_dictionary_parent_class)->finalize (obj);
}


/**
     * File based implementation of SegmentDictionary with write access.
     */
GType kkc_user_segment_dictionary_get_type (void) {
	static volatile gsize kkc_user_segment_dictionary_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_user_segment_dictionary_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcUserSegmentDictionaryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_user_segment_dictionary_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcUserSegmentDictionary), 0, (GInstanceInitFunc) kkc_user_segment_dictionary_instance_init, NULL };
		static const GInterfaceInfo kkc_dictionary_info = { (GInterfaceInitFunc) kkc_user_segment_dictionary_kkc_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_segment_dictionary_info = { (GInterfaceInitFunc) kkc_user_segment_dictionary_kkc_segment_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_user_segment_dictionary_type_id;
		kkc_user_segment_dictionary_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcUserSegmentDictionary", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_user_segment_dictionary_type_id, KKC_TYPE_DICTIONARY, &kkc_dictionary_info);
		g_type_add_interface_static (kkc_user_segment_dictionary_type_id, KKC_TYPE_SEGMENT_DICTIONARY, &kkc_segment_dictionary_info);
		g_once_init_leave (&kkc_user_segment_dictionary_type_id__volatile, kkc_user_segment_dictionary_type_id);
	}
	return kkc_user_segment_dictionary_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



