/*
 *  The ManaPlus Client
 *  Copyright (C) 2007  Joshua Langley <joshlangley@optusnet.com.au>
 *  Copyright (C) 2009-2010  The Mana Developers
 *  Copyright (C) 2011-2014  The ManaPlus Developers
 *
 *  This file is part of The ManaPlus Client.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INPUT_INPUTACTIONMAP_H
#define INPUT_INPUTACTIONMAP_H

#include "sdlshared.h"

#include "actions/actions.h"
#include "actions/chat.h"
#include "actions/commands.h"
#include "actions/move.h"
#include "actions/statusbar.h"
#include "actions/tabs.h"
#include "actions/target.h"
#include "actions/windows.h"

#include "input/inputaction.h"
#include "input/inputactiondata.h"
#include "input/inputcondition.h"
#include "input/inputmanager.h"
#include "input/inputtype.h"

#include "utils/gettext.h"

#include <string>

#include "localconsts.h"

// keyData must be in same order as enum keyAction.
static const InputActionData inputActionData[InputAction::TOTAL] = {
    {"keyMoveUp",
        InputType::KEYBOARD, SDLK_UP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveUp,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS,
        "",
        false},
    {"keyMoveDown",
        InputType::KEYBOARD, SDLK_DOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveDown,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS,
        "",
        false},
    {"keyMoveLeft",
        InputType::KEYBOARD, SDLK_LEFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveLeft,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS,
        "",
        false},
    {"keyMoveRight",
        InputType::KEYBOARD, SDLK_RIGHT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveRight,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS,
        "",
        false},
    {"keyAttack",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &Actions::attack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOFOLLOW
            | InputCondition::VALIDSPEED,
        "attack",
        false},
    {"keyTargetAttack",
        InputType::KEYBOARD, SDLK_LCTRL,
        InputType::JOYSTICK, 0,
        Input::GRP_DEFAULT,
        &Actions::targetAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOFOLLOW
            | InputCondition::VALIDSPEED,
        "targetattack",
        false},
    {"keyMoveToTarget",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveToTarget,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "movetotarget",
        false},
    {"keyChangeMoveToTarget",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeMoveToTarget,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyMoveToHome",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveToHome,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "movetohome",
        false},
    {"keySetHome",
        InputType::KEYBOARD, SDLK_KP5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::setHome,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "sethome",
        false},
    {"keyMoveToPoint",
        InputType::KEYBOARD, SDLK_RSHIFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyTalk",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::talk,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "talk",
        false},
    {"keyTarget",
        InputType::KEYBOARD, SDLK_LSHIFT,
        InputType::JOYSTICK, 4,
        Input::GRP_DEFAULT,
        &Actions::stopAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "stopattack",
        false},
    {"keyUnTarget",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::untarget,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "untarget",
        false},
    {"keyTargetMonster",
        InputType::KEYBOARD, SDLK_a,
        InputType::JOYSTICK, 3,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &Actions::targetMonster,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET
            | InputCondition::VALIDSPEED,
        "targetmonster",
        false},
    {"keyTargetNPC",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::targetNPC,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "targetnpc",
        false},
    {"keyTargetPlayer",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::targetPlayer,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "targetplayer",
        false},
    {"keyPickup",
        InputType::KEYBOARD, SDLK_z,
        InputType::JOYSTICK, 1,
        Input::GRP_DEFAULT,
        &Actions::pickup,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "pickup",
        false},
    {"keyChangePickupType",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changePickupType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyHideWindows",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::hideWindows,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "hidewindows",
        false},
    {"keyBeingSit",
        InputType::KEYBOARD, SDLK_s,
        InputType::JOYSTICK, 2,
        Input::GRP_DEFAULT,
        &Actions::sit,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "sit",
        false},
    {"keyScreenshot",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::screenshot,
        InputAction::NO_VALUE, 50,
        InputCondition::NOTARGET | InputCondition::NOINPUT,
        "screenshot",
        false},
    {"keyTrade",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeTrade,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "changetrade",
        false},
    {"keyPathfind",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeMapMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET
            | InputCondition::EMODS,
        "",
        false},
    {"keyOK",
        InputType::KEYBOARD, SDLK_SPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::ok,
        InputAction::NO_VALUE, 50,
        InputCondition::NOMODAL | InputCondition::NOAWAY
            | InputCondition::NONPCINPUT,
        "",
        false},
    {"keyQuit",
        InputType::KEYBOARD, SDLK_ESCAPE,
#if defined(USE_SDL2) && defined(ANDROID)
        InputType::KEYBOARD, SDLK_AC_BACK,
#else
        InputType::UNKNOWN, InputAction::NO_VALUE,
#endif
        Input::GRP_DEFAULT,
        &Actions::quit,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "quit",
        false},
    {"keyShortcutsKey",
        InputType::KEYBOARD, SDLK_MENU,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut16",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut17",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut18",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut19",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyShortcut20",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::shortcut,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT,
        "",
        false},
    {"keyWindowHelp",
        InputType::KEYBOARD, SDLK_F1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::helpWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT0,
        "help|openhelp",
        false},
    {"keyWindowStatus",
        InputType::KEYBOARD, SDLK_F2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::statusWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "status|openstatus",
        false},
    {"keyWindowInventory",
        InputType::KEYBOARD, SDLK_F3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::inventoryWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "inventory|openinventory",
        false},
    {"keyWindowEquipment",
        InputType::KEYBOARD, SDLK_F4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::equipmentWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "equipment|openequipment",
        false},
    {"keyWindowSkill",
        InputType::KEYBOARD, SDLK_F5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::skillDialogShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "skill|skills|openskills",
        false},
    {"keyWindowMinimap",
        InputType::KEYBOARD, SDLK_F6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::minimapWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "minimap|openminimap",
        false},
    {"keyWindowChat",
        InputType::KEYBOARD, SDLK_F7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::chatWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "openchat",
        false},
    {"keyWindowShortcut",
        InputType::KEYBOARD, SDLK_F8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::shortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "openshortcut|openshortcuts",
        false},
    {"keyWindowSetup",
        InputType::KEYBOARD, SDLK_F9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::setupWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::NOTARGET | InputCondition::NOINPUT
            | InputCondition::ENABLED,
        "setup|opensetup",
        false},
    {"keyWindowDebug",
        InputType::KEYBOARD, SDLK_F10,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::debugWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "debug|opendebug",
        false},
    {"keyWindowSocial",
        InputType::KEYBOARD, SDLK_F11,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::socialWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "social|opensocial",
        false},
    {"keyWindowEmoteBar",
        InputType::KEYBOARD, SDLK_F12,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::emoteShortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "emotes|openemotes",
        false},
    {"keyWindowOutfit",
        InputType::KEYBOARD, SDLK_BACKQUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::outfitWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "openoutfit|openoutfits",
        false},
    {"keyWindowShop",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::shopWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "shop|openshop",
        false},
    {"keyWindowDrop",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::dropShortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "opendrop",
        false},
    {"keyWindowKills",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::killStatsWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "kills|openkills",
        false},
    {"keyWindowSpells",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::spellShortcutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "spells|openspells",
        false},
    {"keyWindowBotChecker",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::botcheckerWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "botchecker|openbotchecker",
        false},
    {"keyWindowOnline",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::whoIsOnlineWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "online|openonline",
        false},
    {"keyWindowDidYouKnow",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::didYouKnowWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT0,
        "didyouknow|opendidyouknow",
        false},
    {"keyWindowQuests",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::questsWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "quests|openquests",
        false},
    {"keySocialPrevTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::prevSocialTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "prevsocialtab",
        false},
    {"keySocialNextTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::nextSocialTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "nextsocialtab",
        false},
    {"keySmilie",
        InputType::KEYBOARD, SDLK_LALT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyEmoteShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut16",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut17",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut18",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut19",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut20",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut21",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut22",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut23",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut24",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut25",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut26",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut27",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut28",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut29",
        InputType::KEYBOARD, SDLK_a,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut30",
        InputType::KEYBOARD, SDLK_s,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut31",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut32",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut33",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut34",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut35",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut36",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut37",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut38",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut39",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut40",
        InputType::KEYBOARD, SDLK_z,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut41",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut42",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut43",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut44",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut45",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut46",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut47",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyEmoteShortcut48",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_EMOTION,
        &Actions::emote,
        InputAction::EMOTE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyWearOutfit",
        InputType::KEYBOARD, SDLK_RCTRL,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyCopyOutfit",
        InputType::KEYBOARD, SDLK_RALT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyCopyEquipedOutfit",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::copyEquippedToOutfit,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "",
        false},
    {"keyOutfitShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut16",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut17",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut18",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut19",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut20",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut21",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut22",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut23",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut24",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut25",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut26",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut27",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut28",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut29",
        InputType::KEYBOARD, SDLK_a,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut30",
        InputType::KEYBOARD, SDLK_s,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut31",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut32",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut33",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut34",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut35",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut36",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut37",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut38",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut39",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut40",
        InputType::KEYBOARD, SDLK_z,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut41",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut42",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut43",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut44",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut45",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut46",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut47",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyOutfitShortcut48",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_OUTFIT,
        &Actions::outfit,
        InputAction::NO_VALUE, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut1",
        InputType::KEYBOARD, SDLK_1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut2",
        InputType::KEYBOARD, SDLK_2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut3",
        InputType::KEYBOARD, SDLK_3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut4",
        InputType::KEYBOARD, SDLK_4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut5",
        InputType::KEYBOARD, SDLK_5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut6",
        InputType::KEYBOARD, SDLK_6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut7",
        InputType::KEYBOARD, SDLK_7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut8",
        InputType::KEYBOARD, SDLK_8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut9",
        InputType::KEYBOARD, SDLK_9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut10",
        InputType::KEYBOARD, SDLK_0,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut11",
        InputType::KEYBOARD, SDLK_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut12",
        InputType::KEYBOARD, SDLK_EQUALS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut13",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut14",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut15",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut16",
        InputType::KEYBOARD, SDLK_q,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut17",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut18",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut19",
        InputType::KEYBOARD, SDLK_r,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut20",
        InputType::KEYBOARD, SDLK_t,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut21",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut22",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut23",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut24",
        InputType::KEYBOARD, SDLK_o,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut25",
        InputType::KEYBOARD, SDLK_p,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut26",
        InputType::KEYBOARD, SDLK_LEFTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut27",
        InputType::KEYBOARD, SDLK_RIGHTBRACKET,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut28",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut29",
        InputType::KEYBOARD, SDLK_a,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut30",
        InputType::KEYBOARD, SDLK_s,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut31",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut32",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut33",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut34",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut35",
        InputType::KEYBOARD, SDLK_j,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut36",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut37",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut38",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut39",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut40",
        InputType::KEYBOARD, SDLK_z,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut41",
        InputType::KEYBOARD, SDLK_x,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut42",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut43",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut44",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut45",
        InputType::KEYBOARD, SDLK_n,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut46",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut47",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyMoveToPointShortcut48",
        InputType::KEYBOARD, SDLK_PERIOD,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_MOVETOPOINT,
        &Actions::moveToPoint,
        InputAction::MOVE_TO_POINT, 100,
        InputCondition::GAME,
        "",
        false},
    {"keyChat",
        InputType::KEYBOARD, SDLK_RETURN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_CHAT,
        &Actions::toggleChat,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::NOAWAY
            | InputCondition::NOMODAL | InputCondition::INGAME,
        "chat",
        false},
    {"keyChatScrollUp",
        InputType::KEYBOARD, SDLK_PAGEUP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::scrollChatUp,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "chatscrollup",
        false},
    {"keyChatScrollDown",
        InputType::KEYBOARD, SDLK_PAGEDOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::scrollChatDown,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "chatscrolldown",
        false},
    {"keyChatPrevTab",
        InputType::KEYBOARD, SDLK_KP7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::prevChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "prevtab",
        false},
    {"keyChatNextTab",
        InputType::KEYBOARD, SDLK_KP9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::nextChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "nexttab",
        false},
    {"keyChatCloseTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::closeChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "close",
        false},
    {"keyChatPrevHistory",
        InputType::KEYBOARD, SDLK_KP7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_CHAT | Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyChatNextHistory",
        InputType::KEYBOARD, SDLK_KP9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_CHAT | Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyIgnoreInput1",
#ifdef USE_SDL2
        InputType::UNKNOWN, InputAction::NO_VALUE,
#else
        InputType::KEYBOARD, SDLK_LSUPER,
#endif
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::ignoreInput,
        InputAction::NO_VALUE, 500,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyIgnoreInput2",
#ifdef USE_SDL2
        InputType::UNKNOWN, InputAction::NO_VALUE,
#else
        InputType::KEYBOARD, SDLK_RSUPER,
#endif
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::ignoreInput,
        InputAction::NO_VALUE, 500,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyDirectUp",
        InputType::KEYBOARD, SDLK_l,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::directUp,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "directup|turnup",
        false},
    {"keyDirectDown",
        InputType::KEYBOARD, SDLK_SEMICOLON,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::directDown,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "directdown|turndown",
        false},
    {"keyDirectLeft",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::directLeft,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "directleft|turnleft",
        false},
    {"keyDirectRight",
        InputType::KEYBOARD, SDLK_QUOTE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::directRight,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "directright|turnright",
        false},
    {"keyCrazyMoves",
        InputType::KEYBOARD, SDLK_SLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::crazyMoves,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "",
        false},
    {"keyChangeCrazyMoveType",
        InputType::KEYBOARD, SDLK_BACKSLASH,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeCrazyMove,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyQuickDrop",
        InputType::KEYBOARD, SDLK_y,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dropItem0,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "drop",
        false},
    {"keyQuickDropN",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dropItem,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "dropn",
        false},
    {"keySwitchQuickDrop",
        InputType::KEYBOARD, SDLK_i,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::switchQuickDrop,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "",
        false},
    {"keyMagicInma1",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::heal,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "heal",
        true},
    {"keyMagicItenplz",
        InputType::KEYBOARD, SDLK_m,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::itenplz,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "itenplz",
        false},
    {"keyMagicAttack",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::magicAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "magicattack",
        false},
    {"keySwitchMagicAttack",
        InputType::KEYBOARD, SDLK_COMMA,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeMagicAttackType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keySwitchPvpAttack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changePvpMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyInvertDirection",
        InputType::KEYBOARD, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeMoveType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyChangeAttackWeaponType",
        InputType::KEYBOARD, SDLK_g,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeAttackWeaponType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyChangeAttackType",
        InputType::KEYBOARD, SDLK_END,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeAttackType,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyChangeFollowMode",
        InputType::KEYBOARD, SDLK_KP1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeFollowMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyChangeImitationMode",
        InputType::KEYBOARD, SDLK_KP4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeImitationMode,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyDisableGameModifiers",
        InputType::KEYBOARD, SDLK_KP8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeGameModifier,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "",
        false},
    {"keyChangeAudio",
        InputType::KEYBOARD, SDLK_KP3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::changeAudio,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "audio",
        false},
    {"keyAway",
        InputType::KEYBOARD, SDLK_KP2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::away,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED,
        "",
        false},
    {"keyRightClick",
        InputType::KEYBOARD, SDLK_TAB,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::mouseClick,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::NOAWAY
            | InputCondition::NOMODAL | InputCondition::INGAME,
        "rightclick",
        false},
    {"keyCameraMode",
        InputType::KEYBOARD, SDLK_KP_PLUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::camera,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::VALIDSPEED
            | InputCondition::EMODS,
        "",
        false},
    {"keyMod",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        0,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIUp",
        InputType::KEYBOARD, SDLK_UP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIDown",
        InputType::KEYBOARD, SDLK_DOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUILeft",
        InputType::KEYBOARD, SDLK_LEFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIRight",
        InputType::KEYBOARD, SDLK_RIGHT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUISelect",
        InputType::KEYBOARD, SDLK_SPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUISelect2",
        InputType::KEYBOARD, SDLK_RETURN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUICancel",
        InputType::KEYBOARD, SDLK_ESCAPE,
#if defined(USE_SDL2) && defined(ANDROID)
        InputType::KEYBOARD, SDLK_AC_BACK,
#else
        InputType::UNKNOWN, InputAction::NO_VALUE,
#endif
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIHome",
        InputType::KEYBOARD, SDLK_HOME,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIEnd",
        InputType::KEYBOARD, SDLK_END,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIDelete",
        InputType::KEYBOARD, SDLK_DELETE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIBackSpace",
        InputType::KEYBOARD, SDLK_BACKSPACE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUITab",
        InputType::KEYBOARD, SDLK_TAB,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIPageUp",
        InputType::KEYBOARD, SDLK_PAGEUP,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIPageDown",
        InputType::KEYBOARD, SDLK_PAGEDOWN,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIInsert",
        InputType::KEYBOARD, SDLK_INSERT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIMod",
        InputType::KEYBOARD, SDLK_LSHIFT,
        InputType::KEYBOARD, SDLK_RSHIFT,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keySafeVideo",
        InputType::KEYBOARD, SDLK_KP_MINUS,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::safeVideoMode,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyStopSit",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::stopSit,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "sit2",
        false},
    {"keyShowKeyboard",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::showKeyboard,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "showkeyboard",
        false},
    {"keyShowWindows",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::showWindows,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "showwindows",
        false},
    {"keyChatMod",
        InputType::KEYBOARD, SDLK_LSHIFT,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT | InputCondition::INGAME,
        "",
        false},
    {"keyMoveForward",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::moveForward,
        InputAction::NO_VALUE, 50,
        InputCondition::ARROWKEYS,
        "",
        false},
    {"keyGUICtrl",
        InputType::KEYBOARD, SDLK_LCTRL,
        InputType::KEYBOARD, SDLK_RCTRL,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIb",
        InputType::KEYBOARD, SDLK_b,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIc",
        InputType::KEYBOARD, SDLK_c,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUId",
        InputType::KEYBOARD, SDLK_d,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIe",
        InputType::KEYBOARD, SDLK_e,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIf",
        InputType::KEYBOARD, SDLK_f,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIh",
        InputType::KEYBOARD, SDLK_h,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIk",
        InputType::KEYBOARD, SDLK_k,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIu",
        InputType::KEYBOARD, SDLK_u,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIv",
        InputType::KEYBOARD, SDLK_v,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIw",
        InputType::KEYBOARD, SDLK_w,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyShortcutsPrevTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::prevShortcutsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "shortcutprevtab",
        false},
    {"keyShortcutsNextTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::nextShortcutsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "shortcutnexttab",
        false},
    {"keyCommandsPrevTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::prevCommandsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "commandsprevtab",
        false},
    {"keyCommandsNextTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::nextCommandsTab,
        InputAction::NO_VALUE, 50,
        InputCondition::NOINPUT | InputCondition::INGAME,
        "commandsnexttab",
        false},
    {"keyOpenTrade",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::openTrade,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET,
        "trade",
        false},

    {"keyGUIF1",
        InputType::KEYBOARD, SDLK_F1,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF2",
        InputType::KEYBOARD, SDLK_F2,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF3",
        InputType::KEYBOARD, SDLK_F3,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF4",
        InputType::KEYBOARD, SDLK_F4,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF5",
        InputType::KEYBOARD, SDLK_F5,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF6",
        InputType::KEYBOARD, SDLK_F6,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF7",
        InputType::KEYBOARD, SDLK_F7,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF8",
        InputType::KEYBOARD, SDLK_F8,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF9",
        InputType::KEYBOARD, SDLK_F9,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF10",
        InputType::KEYBOARD, SDLK_F10,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF11",
        InputType::KEYBOARD, SDLK_F11,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyGUIF12",
        InputType::KEYBOARD, SDLK_F12,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_GUICHAN | Input::GRP_CHAT,
        nullptr,
        InputAction::NO_VALUE, 50,
        InputCondition::DEFAULT,
        "",
        false},
    {"keyWindowAbout",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::aboutWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::SHORTCUT0,
        "about",
        false},
    {"keyWindowUpdater",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::updaterWindowShow,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME,
        "updater",
        false},
    {"keyTargetClosestMonster",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_REPEAT,
        &Actions::targetClosestMonster,
        InputAction::NO_VALUE, 50,
        InputCondition::GAME | InputCondition::NOTARGET
            | InputCondition::VALIDSPEED,
        "targetclosestmonster",
        false},
    {"keyChatCloseAllTabs",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::closeAllChatTabs,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "closeall",
        false},
    {"keyChatIgnoreAllWhispers",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::ignoreAllWhispers,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "ignoreallwhispers",
        false},
    {"keyChatAnnounce",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT | Input::GRP_GUI,
        &Actions::chatAnnounce,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "announce",
        true},
    {"keyIpcToggle",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::ipcToggle,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "ipctoggle",
        false},
    {"keyWhere",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::where,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "where",
        false},
    {"keyWho",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::who,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "who",
        false},
    {"keyWhisper",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::msg,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "w|whisper|msg",
        true},
    {"keyQuery",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::query,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "q|query",
        true},
    {"keyClearChatTab",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::clearChatTab,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "clear",
        false},
    {"keyIgnore",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatIgnore,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "ignore",
        true},
    {"keyUnignore",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatUnignore,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "unignore",
        true},
    {"keyFriend",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatFriend,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "friend|befriend",
        true},
    {"keyDisregard",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatDisregard,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "disregard",
        true},
    {"keyNeutral",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatNeutral,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "neutral",
        true},
    {"keyBlacklist",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatBlackList,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "blacklist",
        true},
    {"keyEnemy",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatEnemy,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "enemy",
        true},
    {"keyErase",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::chatErase,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "erase",
        true},
    {"keyCleanGraphics",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::cleanGraphics,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "cleangraphics",
        false},
    {"keyCleanFonts",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::cleanFonts,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "cleanfonts",
        false},
    {"keyCreateParty",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::createParty,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "createparty",
        true},
    {"keyCreateGuild",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::createGuild,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "createguild",
        true},
    {"keyParty",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::party,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "party",
        true},
    {"keyMe",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::me,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "me",
        true},
    {"keyToggle",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::toggle,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "toggle",
        false},
    {"keyPresent",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::present,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "present",
        false},
    {"keyPrintAll",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::printAll,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "all",
        false},
    {"keyMove",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::move,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "move",
        true},
    {"keySetTarget",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::setTarget,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "target",
        true},
    {"keyAttackHuman",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::attackHuman,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "atkhuman",
        false},
    {"keyOutfit",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::commandOutfit,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "outfit",
        true},
    {"keyEmote",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::commandEmote,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "emote",
        true},
    {"keyEmotePet",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::commandEmotePet,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "emotepet",
        true},
    {"keyAwayMessage",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::awayMessage,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "away",
        true},
    {"keyPseudoAway",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::pseudoAway,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "pseudoaway",
        true},
    {"keyFollow",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::follow,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "follow",
        true},
    {"keyNavigate",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::navigate,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "navigate",
        true},
    {"keyImitation",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::imitation,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "imitation",
        true},
    {"keySendMail",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::sendMail,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "mail",
        true},
    {"keyTradeCommand",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::trade,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "trade",
        true},
    {"keyPriceLoad",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::priceLoad,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "priceload",
        false},
    {"keyPriceSave",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::priceSave,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "pricesave",
        false},
    {"keyCacheInfo",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::cacheInfo,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "cacheinfo",
        false},
    {"keyDisconnect",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::disconnect,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "disconnect",
        false},
    {"keyUndress",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::undress,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "undress",
        true},
    {"keyDirs",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dirs,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dirs",
        false},
    {"keyInfo",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::info,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "info",
        false},
    {"keyWait",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::wait,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "wait",
        true},
    {"keyUptime",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::uptime,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "uptime",
        false},
    {"keyAddPriorityAttack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::addPriorityAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "addpriorityattack",
        true},
    {"keyAddAttack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::addAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "addattack",
        true},
    {"keyRemoveAttack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::removeAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "removeattack|removeignoreattack",
        true},
    {"keyAddIgnoreAttack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::addIgnoreAttack,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "addignoreattack",
        true},
    {"keyDump",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dump,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dump",
        false},
    {"keyServerIgnoreAll",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::serverIgnoreAll,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "serverignoreall",
        false},
    {"keyServerUnIgnoreAll",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::serverUnIgnoreAll,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "serverunignoreall",
        false},
    {"keySetDrop",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::setDrop,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "setdrop",
        true},
    {"keyError",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::error,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "error",
        false},
    {"keyDumpg",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dumpGraphics,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dumpg",
        false},
    {"keyDumpe",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dumpEnvironment,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dumpe",
        false},
    {"keyDumpt",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dumpTests,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dumpt",
        false},
    {"keyDumpOGL",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dumpOGL,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dumpogl",
        false},
    {"keyDumpGL",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dumpGL,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dumpgl",
        false},
    {"keyDumpMods",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dumpMods,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dumpMods",
        false},
    {"keyUrl",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::url,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "url",
        true},
    {"keyOpenUrl",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::openUrl,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "open",
        true},
    {"keyExecute",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::execute,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "execute",
        true},
    {"keyTestSdlFont",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
#if defined USE_OPENGL && defined DEBUG_SDLFONT
        &Actions::testSdlFont,
#else
        nullptr,
#endif
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
#if defined USE_OPENGL && defined DEBUG_SDLFONT
        "testsdlfont",
#else
        "",
#endif
        false},
    {"keyEnableHightlight",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::enableHighlight,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "enablehighlight",
        false},
    {"keyDisableHightlight",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::disableHighlight,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "disablehighlight",
        false},
    {"keyDontRemoveName",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::dontRemoveName,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "dontremovename",
        false},
    {"keyRemoveName",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::removeName,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "removename",
        false},
    {"keyDisableAway",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::disableAway,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "disableaway",
        false},
    {"keyEnableAway",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::enableAway,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "enableaway",
        false},
    {"keyTestParticle",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::testParticle,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "testparticle",
        true},
    {"keyCreateItems",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::createItems,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "createitems",
        false},
    {"keyTalkRaw",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::talkRaw,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "talkraw",
        true},
    {"keyTalkPet",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::talkPet,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "talkpet",
        true},
    {"keyUploadConfig",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::uploadConfig,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "uploadconfig",
        false},
    {"keyUploadServerConfig",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::uploadServerConfig,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "uploadserverconfig",
        false},
    {"keyUploadLog",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::uploadLog,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "uploadlog",
        false},
    {"keyGm",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::gm,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "gm",
        true},
    {"keyHack",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::hack,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "hack",
        true},
    {"keyDebugSpawn",
        InputType::UNKNOWN, InputAction::NO_VALUE,
        InputType::UNKNOWN, InputAction::NO_VALUE,
        Input::GRP_DEFAULT,
        &Actions::debugSpawn,
        InputAction::NO_VALUE, 50,
        InputCondition::INGAME,
        "debugspawn",
        true}
};

#endif  // INPUT_INPUTACTIONMAP_H
