import compiler
import compiler.ast

for filename in file('amber12_fix'):

    filename = filename.strip()

    ast = compiler.parse(file(filename).read())
    stmts = ast.getChildren()[1].getChildren()

    vars = set()
    for stmt in stmts:
        if isinstance(stmt, compiler.ast.Assign):
            var_name = stmt.getChildren()[0].getChildren()[0]
            vars.add(var_name)
    if 'amber_atom_type' in vars \
            and 'amber12_atom_type' not in vars:
        print filename
        with file(filename, 'a') as f:
            f.write("amber12_atom_type = amber_atom_type\n")
