/*
 * $Id: TransactionCoordinationTestCase.java 10489 2008-01-23 17:53:38Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transaction;

import org.mule.api.transaction.Transaction;
import org.mule.tck.AbstractMuleTestCase;

import com.mockobjects.dynamic.Mock;

public class TransactionCoordinationTestCase extends AbstractMuleTestCase
{
    volatile TransactionCoordination tc;

    protected void doSetUp() throws Exception
    {
        tc = TransactionCoordination.getInstance();
    }

    protected void doTearDown() throws Exception
    {
        tc.unbindTransaction(tc.getTransaction());
    }

    public void testBindTransaction() throws Exception
    {
        assertNull(tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();

        tc.bindTransaction(tx);
        assertEquals(tx, tc.getTransaction());
        tc.unbindTransaction(tx);
    }

    public void testBindTransactionWithAlreadyBound() throws Exception
    {
        assertNull(tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();

        tc.bindTransaction(tx);
        assertEquals(tx, tc.getTransaction());

        try
        {
            Transaction tx2 = (Transaction)new Mock(Transaction.class, "trans").proxy();
            tc.bindTransaction(tx2);
            fail();
        }
        catch (IllegalTransactionStateException e)
        {
            // expected
        }

        tc.unbindTransaction(tx);
    }

    public void testUnbindTransactionWithoutBound() throws Exception
    {
        assertNull(tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();
        tc.unbindTransaction(tx);
    }

    public void testSetInstanceWithBound() throws Exception
    {
        assertNull(tc.getTransaction());
        Mock mockTx = new Mock(Transaction.class, "trans");
        Transaction tx = (Transaction)mockTx.proxy();

        tc.bindTransaction(tx);

        tc.unbindTransaction(tx);
    }

}
