/*
 * $Id: QuartzReceiveAndDispatchJobTestCase.java 11613 2008-04-20 20:30:10Z rossmason $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.quartz;

import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.functional.FunctionalTestComponent2;
import org.mule.tck.functional.CountdownCallback;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class QuartzReceiveAndDispatchJobTestCase extends FunctionalTestCase
{
    protected String getConfigResources()
    {
        return "quartz-receive-dispatch.xml";
    }

    public void testMuleClientReceiveAndDispatchJob() throws Exception
    {
        FunctionalTestComponent2 component = (FunctionalTestComponent2)getComponent("scheduledService");
        assertNotNull(component);
        CountdownCallback count = new CountdownCallback(3);
        component.setEventCallback(count);

        new MuleClient().send("vm://event.queue", "quartz test", null);
        new MuleClient().send("vm://event.queue", "quartz test", null);
        new MuleClient().send("vm://event.queue", "quartz test", null);

        new MuleClient().send("vm://quartz.scheduler", "test", null);
        assertTrue(count.await(5000));
    }
}
