.TH INC %manext1% "April 14, 2013" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
inc \- incorporate new mail
.SH SYNOPSIS
.HP 5
.na
.B inc
.RI [ +folder ]
.RB [ \-audit
.IR audit\-file ]
.RB [ \-noaudit ]
.RB [ \-changecur " | " \-nochangecur ]
.RB [ \-form
.IR formfile ]
.RB [ \-format
.IR string ]
.RB [ \-file
.IR name ]
.RB [ \-silent " | " \-nosilent ]
.RB [ \-truncate " | " \-notruncate ]
.RB [ \-width
.IR columns ]
.RB [ \-host
.IR hostname ]
.RB [ \-port
.IR portname/number ]
.RB [ \-user
.IR username ]
.RB [ \-pack
.IR file ]
.RB [ \-nopack ]
.RB [ \-proxy
.IR command ]
.RB [ \-sasl " | " \-nosasl ]
.RB [ \-saslmech
.IR mechanism ]
.RB [ \-snoop ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Inc
incorporates mail from the user's incoming mail drop into
an
.B nmh
folder.
If the mail drop is a file, it can be in
.B mbox
or
.B MMDF
format.
If the mail drop is a directory it will considered to be a
.B Maildir
format mail drop.
.PP
You may specify which folder to use with
.IR +folder .
If no folder is specified, then
.B inc
will use either the folder given by a (non\-empty)
.RI \*(lq Inbox \*(rq
entry in the user's profile, or the folder named
.RI \*(lq inbox \*(rq.
If the specified (or default) folder doesn't
exist, the user will be queried prior to its creation.
.PP
When the new messages are incorporated into the folder, they are assigned
numbers starting with the next highest number for the folder.  As the
messages are processed, a
.B scan
listing of the new mail is produced.
.PP
If the user's profile contains a
.RI \*(lq "Msg\-Protect: nnn" \*(rq
entry, it will be used as the protection on the newly created
messages, otherwise the
.B nmh
default of 0600 will be used (on filesystems that support it).  For
all subsequent operations on these messages, this initially assigned
protection will be preserved.
.PP
If the switch
.B \-audit
.I audit\-file
is specified (usually as a default
switch in the profile), then
.B inc
will append a header line and a
line per message to the end of the specified audit\-file with the format:
.PP
.RS 5
.nf
<<inc>> date
<scan line for first message>
<scan line for second message>
<etc.>
.fi
.RE
.PP
This is useful for keeping track of volume and source of incoming mail.
Eventually,
.BR repl ,
.BR forw ,
.BR comp ,
and
.B dist
may also produce audits to this (or another) file, perhaps with
.RI \*(lq Message\-Id \*(rq
information to keep an exact correspondence
history.
.RI \*(lq Audit\-file \*(rq
will be in the user's nmh directory unless a full path is specified.
.PP
.B Inc
will incorporate even improperly formatted messages into the
user's nmh folder, inserting a blank line prior to the offending component
and printing a comment identifying the bad message.
.PP
In all cases, the user's mail drop will be zeroed, unless the
.B \-notruncate
switch is given.
.PP
If the profile entry
.RI \*(lq Unseen\-Sequence \*(rq
is present and non\-empty, then
.B inc
will add each of the newly incorporated messages to
each sequence named by the profile entry.
.B Inc
will not zero each sequence prior to adding messages.
.PP
The interpretation of the
.B \-form
.IR formatfile ,
.B \-format
.IR string ,
and
.B \-width
.I columns
switches is the same as in
.BR scan .
.PP
By using the
.B \-file
.I name
switch, one can direct
.B inc
to incorporate messages from a file other than the user's maildrop.
Note that the name file will NOT be zeroed, unless the
.B \-truncate
switch is given.
.PP
The
.B \-file
switch does not support use of standard input.  Instead,
the
.B rcvstore
command can be used to incorporate mail from the standard input stream.
.PP
If the environment variable
.B $MAILDROP
is set, then
.B inc
uses it as the location of the user's maildrop instead of the default
(the
.B -file
.I name
switch still overrides this, however).  If this
environment variable is not set, then
.B inc
will consult the profile entry
.RI \*(lq MailDrop \*(rq
for this information.  If the value found is
not absolute, then it is interpreted relative to the user's
.B nmh
directory.  If the value is not found, then
.B inc
will look in the standard system location for the user's maildrop.
.PP
The
.B \-silent
switch directs
.B inc
to be quiet and not ask any questions at all.  This is useful for putting
.B inc
in the background and going on to other things.
.PP
.SS "Using POP"
.B inc
will normally check local mail drops for mail, as covered above.  But
if the option
.RI \*(lq pophost \*(rq
is set in
.RI \*(lq mts.conf \*(rq,
or if the
.B \-host
.I hostname
switch is given, or if the
.B $MAILHOST
environment variable is set, then
.B inc
will query this POP service host for mail to incorporate.  If
.B $MAILHOST
is set and
.B \-host
is specified as well, the commandline switch will override
the environment variable.  The
.B \-port
switch specifies the port name or number used to connect to the POP
server.  If unspecified the default is \*(lqpop3\*(rq.
.PP
To specify a username for authentication with the POP server, use the
.B \-user
.I username
switch.  The credentials profile entry in the mh\-profile(5) man page
describes the ways to supply a username and password.
.PP
If passed the
.B \-proxy
.I command
switch,
.B inc
will use the specified command to establish the connection to the POP
server. The string
.IR %h
in the command will be substituted by the hostname to connect to.
.PP
If
.B inc
uses POP, then the
.B \-pack
.I file
switch is considered. If given, then
.B inc
simply uses the POP to
.B packf
the user's maildrop from the POP service host to the named file.  This switch
is provided for those users who prefer to use
.B msh
to read their maildrops.
.PP
For debugging purposes, you may give the switch
.BR \-snoop ,
which will allow you to watch the POP transaction take place
between you and the POP server.
.PP
If
.B nmh
has been compiled with SASL support, the
.B \-sasl
switch will enable
the use of SASL authentication.  Depending on the SASL mechanism used, this
may require an additional password prompt from the user (but the
.I netrc
file can be used to store this password, as described in the
mh-profile(5) man page).  The
.B \-saslmech
switch can be used to select a particular SASL mechanism.
.PP
If SASL authentication is successful,
.B inc
will attempt to negotiate a security layer for session encryption.
Encrypted traffic is labelled with `(encrypted)' and `(decrypted)'
when viewing the POP transaction with the
.B \-snoop
switch.
.SH FILES
.PD 0
.TP 20
$HOME/.mh_profile
The user's profile.
.TP
%etcdir%/mts.conf
mts configuration file.
.TP
%mailspool%/$USER
Location of the system mail drop.
.PD
.SH "PROFILE COMPONENTS"
.PD 0
.TP 20
Path:
To determine the user's nmh directory.
.TP
Alternate\-Mailboxes:
To determine the user's mailboxes.
.TP
Inbox:
To determine the inbox.
.TP
Folder\-Protect:
To set mode when creating a new folder.
.TP
Msg\-Protect:
To set mode when creating a new message and audit\-file.
.TP
Unseen\-Sequence:
To name sequences denoting unseen messages.
.PD
.SH "SEE ALSO"
.IR mhmail (1),
.IR scan (1),
.IR mh\-mail (5),
.IR mh\-profile (5),
.IR post (8),
.IR rcvstore (1)
.SH DEFAULTS
.PD 0
.TP 20
+folder
defaulted by \*(lqInbox\*(rq above.
.TP
\-noaudit
.TP
\-changecur
.TP
\-format
As described above.
.TP
\-nosilent
.TP
\-nosasl
.TP
\-truncate
If
.B \-file
.I name
not given,
\-notruncate otherwise.
.TP
\-width
The width of the terminal.
.TP
\-nopack
.PD
.SH CONTEXT
The folder into which messages are being incorporated will become the
current folder.  The first message incorporated will become the current
message, unless the
.B \-nochangecur
option is specified.  This leaves the context ready for a
.B show
of the first new message.
