/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT International Business Machines Corp. 2001,2002          */

/***************************************************************************
                          Change Log
                          ==========
       4/25/03    Kapil Sood (kapil@corrent.com)
                  Added DH key pair generation and DH shared key derivation
                  functions.
 
 
 
****************************************************************************/

#include <pthread.h>
#include <stdlib.h>

#include "pkcs11types.h"
#include "stdll.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"

CK_SLOT_INFO    slot_info;
CK_BBOOL        initialized = FALSE;

// native_mutex is used to protect C_Initialize.  It gets created when the DLL
// is attached, it gets destroyed when the DLL is detached
//
pthread_mutex_t native_mutex ;
MUTEX pkcs_mutex, obj_list_mutex, sess_list_mutex, login_mutex;

struct btree sess_btree = { NULL, NULL, 0UL, 0UL };
struct btree sess_obj_btree = { NULL, NULL, 0UL, 0UL };
struct btree publ_token_obj_btree = { NULL, NULL, 0UL, 0UL };
struct btree priv_token_obj_btree = { NULL, NULL, 0UL, 0UL };
struct btree object_map_btree = { NULL, NULL, 0UL, 0UL };

CK_ULONG  ro_session_count = 0;

CK_STATE  global_login_state = CKS_RO_PUBLIC_SESSION;

LW_SHM_TYPE *global_shm;

//CK_ULONG next_session_handle = 1;
//CK_ULONG next_object_handle = 1;

TOKEN_DATA  *nv_token_data = NULL;

struct ST_FCN_LIST function_list ;
  extern CK_RV LW_Initialize();                                 /* extern CK_RV SC_Initialize             */
  extern CK_RV SC_GetFunctionList();                            /* extern CK_RV SC_GetFunctionList        */
  extern CK_RV SC_GetTokenInfo();                               /* extern CK_RV SC_GetTokenInfo           */
  extern CK_RV SC_GetMechanismList();                           /* extern CK_RV SC_GetMechanismList       */
  extern CK_RV SC_GetMechanismInfo();                           /* extern CK_RV SC_GetMechanismInfo       */
  extern CK_RV SC_InitToken();                                  /* extern CK_RV SC_InitToken              */
  extern CK_RV SC_InitPIN();                                    /* extern CK_RV SC_InitPIN                */
  extern CK_RV SC_SetPIN();                                     /* extern CK_RV SC_SetPIN                 */
  extern CK_RV SC_OpenSession();                                /* extern CK_RV SC_OpenSession            */
  extern CK_RV SC_CloseSession();                               /* extern CK_RV SC_CloseSession           */
  extern CK_RV SC_CloseAllSessions();                           /* extern CK_RV SC_CloseAllSessions       */
  extern CK_RV SC_GetSessionInfo();                             /* extern CK_RV SC_GetSessionInfo         */
  extern CK_RV SC_GetOperationState();                          /* extern CK_RV SC_GetOperationState      */
  extern CK_RV SC_SetOperationState();                          /* extern CK_RV SC_SetOperationState      */
  extern CK_RV SC_Login();                                      /* extern CK_RV SC_Login                  */
  extern CK_RV SC_Logout();                                     /* extern CK_RV SC_Logout                 */
  extern CK_RV SC_CreateObject();                               /* extern CK_RV SC_CreateObject           */
  extern CK_RV SC_CopyObject();                                 /* extern CK_RV SC_CopyObject             */
  extern CK_RV SC_DestroyObject();                              /* extern CK_RV SC_DestroyObject          */
  extern CK_RV SC_GetObjectSize();                              /* extern CK_RV SC_GetObjectSize          */
  extern CK_RV SC_GetAttributeValue();                          /* extern CK_RV SC_GetAttributeValue      */
  extern CK_RV SC_SetAttributeValue();                          /* extern CK_RV SC_SetAttributeValue      */
  extern CK_RV SC_FindObjectsInit();                            /* extern CK_RV SC_FindObjectsInit        */
  extern CK_RV SC_FindObjects();                                /* extern CK_RV SC_FindObjects            */
  extern CK_RV SC_FindObjectsFinal();                           /* extern CK_RV SC_FindObjectsFinal       */
  extern CK_RV SC_EncryptInit();                                /* extern CK_RV SC_EncryptInit            */
  extern CK_RV SC_Encrypt();                                    /* extern CK_RV SC_Encrypt                */
  extern CK_RV SC_EncryptUpdate();                              /* extern CK_RV SC_EncryptUpdate          */
  extern CK_RV SC_EncryptFinal();                               /* extern CK_RV SC_EncryptFinal           */
  extern CK_RV SC_DecryptInit();                                /* extern CK_RV SC_DecryptInit            */
  extern CK_RV SC_Decrypt();                                    /* extern CK_RV SC_Decrypt                */
  extern CK_RV SC_DecryptUpdate();                              /* extern CK_RV SC_DecryptUpdate          */
  extern CK_RV SC_DecryptFinal();                               /* extern CK_RV SC_DecryptFinal           */
  extern CK_RV SC_DigestInit();                                 /* extern CK_RV SC_DigestInit             */
  extern CK_RV SC_Digest();                                     /* extern CK_RV SC_Digest                 */
  extern CK_RV SC_DigestUpdate();                               /* extern CK_RV SC_DigestUpdate           */
  extern CK_RV SC_DigestKey();                                  /* extern CK_RV SC_DigestKey              */
  extern CK_RV SC_DigestFinal();                                /* extern CK_RV SC_DigestFinal            */
  extern CK_RV SC_SignInit();                                   /* extern CK_RV SC_SignInit               */
  extern CK_RV SC_Sign();                                       /* extern CK_RV SC_Sign                   */
  extern CK_RV SC_SignUpdate();                                 /* extern CK_RV SC_SignUpdate             */
  extern CK_RV SC_SignFinal();                                  /* extern CK_RV SC_SignFinal              */
  extern CK_RV SC_SignRecoverInit();                            /* extern CK_RV SC_SignRecoverInit        */
  extern CK_RV SC_SignRecover();                                /* extern CK_RV SC_SignRecover            */
  extern CK_RV SC_VerifyInit();                                 /* extern CK_RV SC_VerifyInit             */
  extern CK_RV SC_Verify();                                     /* extern CK_RV SC_Verify                 */
  extern CK_RV SC_VerifyUpdate();                               /* extern CK_RV SC_VerifyUpdate           */
  extern CK_RV SC_VerifyFinal();                                /* extern CK_RV SC_VerifyFinal            */
  extern CK_RV SC_VerifyRecoverInit();                          /* extern CK_RV SC_VerifyRecoverInit      */
  extern CK_RV SC_VerifyRecover();                              /* extern CK_RV SC_VerifyRecover          */
  extern CK_RV SC_DigestEncryptUpdate();                        /* extern CK_RV SC_DigestEncryptUpdate    */
  extern CK_RV SC_DecryptDigestUpdate();                        /* extern CK_RV SC_DecryptDigestUpdate    */
  extern CK_RV SC_SignEncryptUpdate();                          /* extern CK_RV SC_SignEncryptUpdate      */
  extern CK_RV SC_DecryptVerifyUpdate();                        /* extern CK_RV SC_DecryptVerifyUpdate    */
  extern CK_RV SC_GenerateKey();                                /* extern CK_RV SC_GenerateKey            */
  extern CK_RV SC_GenerateKeyPair();                            /* extern CK_RV SC_GenerateKeyPair        */
  extern CK_RV SC_WrapKey();                                    /* extern CK_RV SC_WrapKey                */
  extern CK_RV SC_UnwrapKey();                                  /* extern CK_RV SC_UnwrapKey              */
  extern CK_RV SC_DeriveKey();                                  /* extern CK_RV SC_DeriveKey              */
  extern CK_RV SC_SeedRandom();                                 /* extern CK_RV SC_SeedRandom             */
  extern CK_RV SC_GenerateRandom();                             /* extern CK_RV SC_GenerateRandom         */
  extern CK_RV SC_GetFunctionStatus();                          /* extern CK_RV SC_GetFunctionStatus      */
  extern CK_RV SC_CancelFunction();                             /* extern CK_RV SC_CancelFunction         */
  extern CK_RV SC_WaitForSlotEvent();                           /* extern CK_RV SC_WaitForSlotEvent       */


// OBJECT IDENTIFIERs
//
CK_BYTE  ber_idDSA[]         = { 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x38, 0x04, 0x01 };
CK_BYTE  ber_rsaEncryption[] = { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01 };
CK_BYTE  ber_md2WithRSAEncryption[] = { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02 };
CK_BYTE  ber_md4WithRSAEncryption[] = { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x03 };
CK_BYTE  ber_md5WithRSAEncryption[] = { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x04 };
CK_BYTE  ber_sha1WithRSAEncryption[] = { 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05 };

// Algorithm IDs. (Sequence of OID plus parms, usually NULL)
//
CK_BYTE  ber_AlgMd2[] =    { 0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x02, 0x02, 0x05, 0x00 };
CK_BYTE  ber_AlgMd5[] =    { 0x30, 0x0C, 0x06, 0x08, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x02, 0x05, 0x05, 0x00 };
CK_BYTE  ber_AlgSha1[] =   { 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x05, 0x00 };
CK_BYTE  ber_AlgSha256[] = { 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01, 0x05, 0x00 };
CK_BYTE  ber_AlgSha384[] = { 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x02, 0x05, 0x00 };
CK_BYTE  ber_AlgSha512[] = { 0x30, 0x0D, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x03, 0x05, 0x00 };

CK_BYTE  ber_AlgIdRSAEncryption[] = { 0x30, 0x0D, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00 };

// ID Lengths
//
CK_ULONG ber_idDSALen = sizeof(ber_idDSA);
CK_ULONG ber_rsaEncryptionLen = sizeof(ber_rsaEncryption);
CK_ULONG ber_md2WithRSAEncryptionLen = sizeof(ber_md2WithRSAEncryption);
CK_ULONG ber_md4WithRSAEncryptionLen = sizeof(ber_md4WithRSAEncryption);
CK_ULONG ber_md5WithRSAEncryptionLen = sizeof(ber_md5WithRSAEncryption);
CK_ULONG ber_sha1WithRSAEncryptionLen= sizeof(ber_sha1WithRSAEncryption);

CK_ULONG ber_AlgMd2Len=    sizeof(ber_AlgMd2);
CK_ULONG ber_AlgMd5Len=    sizeof(ber_AlgMd5);
CK_ULONG ber_AlgSha1Len=   sizeof(ber_AlgSha1);
CK_ULONG ber_AlgSha256Len= sizeof(ber_AlgSha256);
CK_ULONG ber_AlgSha384Len= sizeof(ber_AlgSha384);
CK_ULONG ber_AlgSha512Len= sizeof(ber_AlgSha512);
CK_ULONG ber_AlgIdRSAEncryptionLen = sizeof(ber_AlgIdRSAEncryption);


CK_ULONG des_weak_count = 4;
CK_ULONG des_semi_weak_count = 12;
CK_ULONG des_possibly_weak_count = 48;

CK_BYTE  des_weak_keys[4][8] = {
   {0x01, 0x01, 0x01, 0x01,  0x01, 0x01, 0x01, 0x01},
   {0x1F, 0x1F, 0x1F, 0x1F,  0x0E, 0x0E, 0x0E, 0x0E},
   {0xE0, 0xE0, 0xE0, 0xE0,  0xF1, 0xF1, 0xF1, 0xF1},
   {0xFE, 0xFE, 0xFE, 0xFE,  0xFE, 0xFE, 0xFE, 0xFE}
};

CK_BYTE  des_semi_weak_keys[12][8] = {
   {0x01, 0xFE, 0x01, 0xFE,  0x01, 0xFE, 0x01, 0xFE},
   {0xFE, 0x01, 0xFE, 0x01,  0xFE, 0x01, 0xFE, 0x01},
   {0x1F, 0xE0, 0x1F, 0xE0,  0x0E, 0xF1, 0x0E, 0xF1},
   {0xE0, 0x1F, 0xE0, 0x1F,  0xF1, 0x0E, 0xF1, 0x0E},
   {0x01, 0xE0, 0x01, 0xE0,  0x01, 0xF1, 0x01, 0xF1},
   {0xE0, 0x01, 0xE0, 0x01,  0xF1, 0x01, 0xF1, 0x01},
   {0x1F, 0xFE, 0x1F, 0xFE,  0x0E, 0xFE, 0x0E, 0xFE},
   {0xFE, 0x1F, 0xFE, 0x1F,  0xFE, 0x0E, 0xFE, 0x0E},
   {0x01, 0x1F, 0x01, 0x1F,  0x01, 0x0E, 0x01, 0x0E},
   {0x1F, 0x01, 0x1F, 0x01,  0x0E, 0x01, 0x0E, 0x01},
   {0xE0, 0xFE, 0xE0, 0xFE,  0xF1, 0xFE, 0xF1, 0xFE},
   {0xFE, 0xE0, 0xFE, 0xE0,  0xFE, 0xF1, 0xFE, 0xF1}
};

CK_BYTE  des_possibly_weak_keys[48][8] = {
   {0x1F, 0x1F, 0x01, 0x01,  0x0E, 0x0E, 0x01, 0x01},
   {0x01, 0x1F, 0x1F, 0x01,  0x01, 0x0E, 0x0E, 0x01},
   {0x1F, 0x01, 0x01, 0x1F,  0x0E, 0x01, 0x01, 0x0E},
   {0x01, 0x01, 0x1F, 0x1F,  0x01, 0x01, 0x0E, 0x0E},

   {0xE0, 0xE0, 0x01, 0x01,  0xF1, 0xF1, 0x01, 0x01},
   {0xFE, 0xFE, 0x01, 0x01,  0xFE, 0xFE, 0x01, 0x01},
   {0xFE, 0xE0, 0x1F, 0x01,  0xFE, 0xF1, 0x0E, 0x01},
   {0xE0, 0xFE, 0x1F, 0x01,  0xF1, 0xFE, 0x0E, 0x01},
   {0xFE, 0xE0, 0x01, 0x1F,  0xFE, 0xF1, 0x01, 0x0E},
   {0xE0, 0xFE, 0x01, 0x1F,  0xF1, 0xFE, 0x01, 0x0E},
   {0xE0, 0xE0, 0x1F, 0x1F,  0xF1, 0xF1, 0x0E, 0x0E},
   {0xFE, 0xFE, 0x1F, 0x1F,  0xFE, 0xFE, 0x0E, 0x0E},

   {0xFE, 0x1F, 0xE0, 0x01,  0xFE, 0x0E, 0xF1, 0x01},
   {0xE0, 0x1F, 0xFE, 0x01,  0xF1, 0x0E, 0xFE, 0x01},
   {0xFE, 0x01, 0xE0, 0x1F,  0xFE, 0x01, 0xF1, 0x0E},
   {0xE0, 0x01, 0xFE, 0x1F,  0xF1, 0x01, 0xFE, 0x0E},

   {0x01, 0xE0, 0xE0, 0x01,  0x01, 0xF1, 0xF1, 0x01},
   {0x1F, 0xFE, 0xE0, 0x01,  0x0E, 0xFE, 0xF0, 0x01},
   {0x1F, 0xE0, 0xFE, 0x01,  0x0E, 0xF1, 0xFE, 0x01},
   {0x01, 0xFE, 0xFE, 0x01,  0x01, 0xFE, 0xFE, 0x01},
   {0x1F, 0xE0, 0xE0, 0x1F,  0x0E, 0xF1, 0xF1, 0x0E},
   {0x01, 0xFE, 0xE0, 0x1F,  0x01, 0xFE, 0xF1, 0x0E},
   {0x01, 0xE0, 0xFE, 0x1F,  0x01, 0xF1, 0xFE, 0x0E},
   {0x1F, 0xFE, 0xFE, 0x1F,  0x0E, 0xFE, 0xFE, 0x0E},

   {0xE0, 0x01, 0x01, 0xE0,  0xF1, 0x01, 0x01, 0xF1},
   {0xFE, 0x1F, 0x01, 0xE0,  0xFE, 0x0E, 0x01, 0xF1},
   {0xFE, 0x01, 0x1F, 0xE0,  0xFE, 0x01, 0x0E, 0xF1},
   {0xE0, 0x1F, 0x1F, 0xE0,  0xF1, 0x0E, 0x0E, 0xF1},
   {0xFE, 0x01, 0x01, 0xFE,  0xFE, 0x01, 0x01, 0xFE},
   {0xE0, 0x1F, 0x01, 0xFE,  0xF1, 0x0E, 0x01, 0xFE},
   {0xE0, 0x01, 0x1F, 0xFE,  0xF1, 0x01, 0x0E, 0xFE},
   {0xFE, 0x1F, 0x1F, 0xFE,  0xFE, 0x0E, 0x0E, 0xFE},

   {0x1F, 0xFE, 0x01, 0xE0,  0x0E, 0xFE, 0x01, 0xF1},
   {0x01, 0xFE, 0x1F, 0xE0,  0x01, 0xFE, 0x0E, 0xF1},
   {0x1F, 0xE0, 0x01, 0xFE,  0x0E, 0xF1, 0x01, 0xFE},
   {0x01, 0xE0, 0x1F, 0xFE,  0x01, 0xF1, 0x0E, 0xFE},

   {0x01, 0x01, 0xE0, 0xE0,  0x01, 0x01, 0xF1, 0xF1},
   {0x1F, 0x1F, 0xE0, 0xE0,  0x0E, 0x0E, 0xF1, 0xF1},
   {0x1F, 0x01, 0xFE, 0xE0,  0x0E, 0x01, 0xFE, 0xF1},
   {0x01, 0x1F, 0xFE, 0xE0,  0x01, 0x0E, 0xFE, 0xF1},
   {0x1F, 0x01, 0xE0, 0xFE,  0x0E, 0x01, 0xF1, 0xFE},
   {0x01, 0x1F, 0xE0, 0xFE,  0x01, 0x0E, 0xF1, 0xFE},
   {0x01, 0x01, 0xFE, 0xFE,  0x01, 0x01, 0xFE, 0xFE},
   {0x1F, 0x1F, 0xFE, 0xFE,  0x0E, 0x0E, 0xFE, 0xFE},

   {0xFE, 0xFE, 0xE0, 0xE0,  0xFE, 0xFE, 0xF1, 0xF1},
   {0xE0, 0xFE, 0xFE, 0xE0,  0xF1, 0xFE, 0xFE, 0xF1},
   {0xFE, 0xE0, 0xE0, 0xFE,  0xFE, 0xF1, 0xF1, 0xFE},
   {0xE0, 0xE0, 0xFE, 0xFE,  0xF1, 0xF1, 0xFE, 0xFE}
};

// default SO pin hash values
//
// default SO pin = "87654321"
//
CK_BYTE default_so_pin_md5[MD5_HASH_SIZE] = {
  0x5E, 0x86, 0x67, 0xA4, 0x39, 0xC6, 0x8F, 0x51,
  0x45, 0xDD, 0x2F, 0xCB, 0xEC, 0xF0, 0x22, 0x09
};

CK_BYTE default_so_pin_sha[SHA1_HASH_SIZE] = {
  0xA7, 0xD5, 0x79, 0xBA, 0x76, 0x39, 0x80, 0x70,
  0xEA, 0xE6, 0x54, 0xC3, 0x0F, 0xF1, 0x53, 0xA4,
  0xC2, 0x73, 0x27, 0x2A
};

/* SHA-1 of "12345678" */
CK_BYTE default_user_pin_sha[SHA1_HASH_SIZE] = {
	0x7c, 0x22, 0x2f, 0xb2, 0x92, 0x7d, 0x82, 0x8a,
	0xf2, 0x2f, 0x59, 0x21, 0x34, 0xe8, 0x93, 0x24,
	0x80, 0x63, 0x7c, 0x0d
};

CK_BYTE user_pin_md5[MD5_HASH_SIZE];
CK_BYTE so_pin_md5[MD5_HASH_SIZE];
CK_BYTE master_key[MAX_KEY_SIZE];


