/* Nessus
 * Copyright (C) 1998 - 2001 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#ifndef _NESSUS_NESSUS_PLUGIN
#define _NESSUS_NESSUS_PLUGIN

/**
 * @brief Basic nessus_plugin struct, describing a NVT and eventual preferences
 *        in their user-modified state.
 * 
 * Implements a single-linked list (through a 'next' pointer).
 */
struct nessus_plugin {
	char * oid;
	char * name;
	char * md5sum;
	
	char * category;
	char * copyright;

	char * description;

	char * summary;

	char * family;
	char * version;

	char * cve;
	char * bid;
	char * xrefs;
        char * script_tags;
        char * sign_key_ids;

	struct arglist * plugin_prefs;

	struct nessus_plugin * next;
	int enabled:1;
	int is_current:1;    /**< Used for the cache */
};



struct nessus_plugin * nessus_plugin_new(char * id, char * name, char * category, char * copyright, char * description, char * summary, char * family, char * version, char * cve, char * bid, char * xrefs, char* sign_key_ids, char* script_tags);

struct nessus_plugin * nessus_plugin_get_by_name( struct nessus_plugin * plugins, char * name);
struct nessus_plugin * nessus_plugin_get_by_oid( struct nessus_plugin * plugins, const char * id);

void nessus_plugin_set_md5sum(struct nessus_plugin * plugin, const char * md5sum);

struct nessus_plugin* nessus_plugin_duplicate(struct nessus_plugin *);

void nessus_plugin_free(struct nessus_plugin * plugins);

char * nessus_plugin_get_description(struct nessus_plugin * plugin);

#endif /* _NESSUS_NESSUS_PLUGIN */
