<?php
/*
 * Copyright (c) 2014 Mathieu Parent <sathieu@debian.org>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

namespace Pkgtools\Phppear;

/**
* This class parses command-line
*
* @copyright Copyright (c) 2014 Mathieu Parent <sathieu@debian.org>
* @author Mathieu Parent <sathieu@debian.org>
* @license Expat http://www.jclark.com/xml/copying.txt
*/
class Command extends \Pkgtools\Base\Command {

    /**
     * Print the package name
     */
    public function runName() {
        $p = new Source($this->getProperty('_sourcedirectory'));
        echo $p->name;
    }

    /**
     * Print the package channel
     */
    public function runChannel() {
        $p = new Source($this->getProperty('_sourcedirectory'));
        echo $p->channel;
    }

    /**
     * Print the package summary
     */
    public function runSummary() {
        $p = new Source($this->getProperty('_sourcedirectory'));
        echo $p->summary;
    }

    /**
     * Print the package description
     */
    public function runDescription() {
        $p = new Source($this->getProperty('_sourcedirectory'));
        echo $p->description;
    }

    /**
     * Print dependencies
     */
    public function runDependencies() {
        $p = new Source($this->getProperty('_sourcedirectory'));
        print $p->getDependencies();
    }

    /**
     * Print substvars (Debian substitution variables)
     */
    public function runSubstvars() {
        $p = new Source($this->getProperty('_sourcedirectory'));
        $dependencies = $p->getDependencies()->asDeb();
        // Ensure no key is missing
        $dependencies = array_merge(Array(
                'require'   => Array(),
                'recommend' => Array(),
                'conflict'  => Array()
            ),
            $dependencies);
        // Print substvars
        echo 'phppear:Debian-Depends='    . implode($dependencies['require'], ', ')."\n";
        echo 'phppear:Debian-Recommends=' . implode($dependencies['recommend'], ', ')."\n";
        //echo 'phppear:Debian-Suggests='   . implode($dependencies['suggest'], ', ')."\n";
        echo 'phppear:Debian-Breaks='     . implode($dependencies['conflict'], ', ')."\n";
        $summary = $p->summary;
        if ($summary[strlen($summary)-1] == '.') {
            $summary = substr($summary, 0, -1);
        }
        echo 'phppear:summary='           . $summary."\n";
        echo 'phppear:description='       . \Pkgtools\Base\Utils::substvar($p->description)."\n";
        echo 'phppear:channel='           . $p->channel."\n";
    }
}
