<?php
/*
 * Copyright (c) 2014 Mathieu Parent <sathieu@debian.org>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

/**
 * This class tests basic functionnality of pear command-line
 *
 * @copyright Copyright (c) 2014 Mathieu Parent <sathieu@debian.org>
 * @author Mathieu Parent <sathieu@debian.org>
 * @license Expat http://www.jclark.com/xml/copying.txt
 */
class PhppearCliTest extends PHPUnit_Framework_TestCase {
    protected $_cli;

    protected function setUp() {
        $this->_cli = new \Pkgtools\Command();
    }

    public function testPhppearName() {
        $this->expectOutputString('MyProject_Packages');
        chdir('testsuite/data/pearpkg1');
        $this->_cli->parseArgs(Array('phppear', 'name'));
    }

    public function testPhppearChannel() {
        $this->expectOutputString('pear.php.net');
        chdir('testsuite/data/pearpkg1');
        $this->_cli->parseArgs(Array('phppear', 'channel'));
    }

    public function testPhppearSummary() {
        $this->expectOutputString('this is a wrapper package for installing dependencies for MyProject.');
        chdir('testsuite/data/pearpkg1');
        $this->_cli->parseArgs(Array('phppear', 'summary'));
    }

    public function testPhppearDescription() {
        $this->expectOutputString('<Some random notes>');
        chdir('testsuite/data/pearpkg1');
        $this->_cli->parseArgs(Array('phppear', 'description'));
    }

    public function testPhppearDependencies() {
        $this->expectOutputString('require:/php (>= 5.2.1)
require:pear-pear.horde.org/Horde_Alarm (>= 2.2.0, < 3.0.0~alpha1)
recommend:pear-pecl.php.net/mysqli
');
        chdir('testsuite/data/pearpkg1');
        $this->_cli->parseArgs(Array('phppear', 'dependencies'));
    }

    public function testPhppearSubstvars() {
        $this->expectOutputString('phppear:Debian-Depends=php5-common (>= 5.2.1), php-horde-alarm (>= 2.2.0), php-horde-alarm (<< 3.0.0~alpha1)
phppear:Debian-Recommends=php5-mysql
phppear:Debian-Breaks=
phppear:summary=this is a wrapper package for installing dependencies for MyProject
phppear:description=<Some random notes>
phppear:channel=pear.php.net
');
        chdir('testsuite/data/pearpkg1');
        $this->_cli->parseArgs(Array('phppear', 'substvars'));
    }
}
