#!/bin/sh

set -e
. ./testsuite/common.sh

composerpkg1='testsuite/data/composerpkg1'
composerpkg2='testsuite/data/composerpkg2'

sed -e "s@/usr/bin/pkgtools@php', '-d', 'include_path=${PWD}/share/php', '${PWD}/bin/pkgtools@" \
    bin/dh_phpcomposer > bin/dh_phpcomposer.test

ret=0
old_dir="${PWD}"

cd "${composerpkg1}"
expect_equal "perl '${old_dir}/bin/dh_phpcomposer.test'" '' || ret=$?
expect_equal "cat 'debian/php-foo.substvars'" 'phpcomposer:name=vendor/project
phpcomposer:description=Some vendor project
phpcomposer:Debian-require=php5-common, php5-common (>= 5.2), php-proj1-pack1 (>= 2.0), php-proj1-pack1 (<< 3~)
phpcomposer:Debian-require-dev=overrideme-sub (>= 3.7), overrideme-sub (<< 3.8~)
phpcomposer:Debian-recommend=php-ocramius-proxy-manager (>= 0.3.1), php-ocramius-proxy-manager (<< 0.4~~dev)
phpcomposer:Debian-suggest=php5-apcu, php5-curl
phpcomposer:Debian-provide=php-example-project (>= 1.7), php-example-project (<< 1.8~), php5-curl' || ret=$?
rm -f debian/php-foo.substvars debian/php-foo.debhelper.log
cd "${old_dir}"

cd "${composerpkg2}"
expect_equal "perl '${old_dir}/bin/dh_phpcomposer.test'" '' || ret=$?
expect_equal "cat 'debian/php-foo.substvars'" 'phpcomposer:name=vendor/project2
phpcomposer:description=Some vendor project 2
phpcomposer:Debian-require=php5-cli, php-proj1-equal-any, php-proj1-equal-self (= ${binary:Version}), php-proj1-equal-wildcard (>= 2), php-proj1-equal-wildcard (<< 3~), php-proj1-equal-exact (= 3.1.2), php-proj1-range-ge (>= 1.0), php-proj1-range-ge-lt (>= 1.1), php-proj1-range-ge-lt (<< 1.9), php-proj1-range-gt-le (>> 1.1), php-proj1-range-gt-le (<= 1.9), php-proj1-tilde (>= 1.2), php-proj1-tilde (<< 2~), php-proj1-unsupported-or, php-proj1-stability-dev (>= 0.3.1), php-proj1-stability-dev (<< 0.4~~dev), php-proj1-stability-patch (>= 0.4~~patch1), php-proj1-stability-beta (>= 2.3~beta2), php-proj1-stabilityflag-beta (>= 1.0), php-proj1-stabilityflag-beta (<< 1.1~), php-proj1-stabilityflag-dev, php-proj1-alias-dev-master, php-proj1-alias-inline
phpcomposer:Debian-recommend=libcurl3 (>= 7.37), libicu52 (>= 50), libxml2 (>= 2.8), libssl1.0.0 (>= 1.0.1), libpcre3 (>= 8.30), libxslt1.1 (>= 1.1.24)
phpcomposer:Debian-suggest=php-proj1-suggest-unparsable, php-proj1-suggest-versioned (>> 12)
phpcomposer:Debian-provide=php-proj1-provide-versioned (>= 1.7), php-proj1-provide-versioned (<< 1.8~), php-proj1-provide-any' || ret=$?
rm -f debian/php-foo.substvars debian/php-foo.debhelper.log
cd "${old_dir}"

rm bin/dh_phpcomposer.test

exit $ret
