/****************************************************************************
**
** Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the test suite of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia. For licensing terms and
** conditions see http://qt.digia.com/licensing. For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights. These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/


#include "uiloader.h"

#include <QtTest/QtTest>
#include <QApplication>
#include <QDir>

#ifdef Q_OS_SYMBIAN
#define SRCDIR ""
#endif

class uiLoaderAutotest: public QObject
{

Q_OBJECT

public slots:
    void init();

private slots:
    void imageDiffTest();

private:
    QString currentDir;

};



void uiLoaderAutotest::init()
{
    currentDir = QDir::currentPath();
#ifndef Q_OS_IRIX
    QDir::setCurrent(QString(SRCDIR) + QString("/.."));
#endif
}

void uiLoaderAutotest::imageDiffTest()
{
    //QApplication app(argc, argv);

    QString pathToProgram   = currentDir + "/tst_screenshot/tst_screenshot";

#ifdef Q_WS_MAC
    pathToProgram += ".app/Contents/MacOS/tst_screenshot";
#endif

#ifdef Q_WS_WIN
    pathToProgram += ".exe";
#endif
    uiLoader wrapper(pathToProgram);
    QString errorMessage;
    switch(wrapper.runAutoTests(&errorMessage)) {
        case uiLoader::TestRunDone:
        break;
        case uiLoader::TestConfigError:
        QVERIFY2(false, qPrintable(errorMessage));
        break;
        case uiLoader::TestNoConfig:
        QSKIP(qPrintable(errorMessage));
        break;
    }
}

QTEST_MAIN(uiLoaderAutotest)
#include "tst_uiloader.moc"
