/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  backendn-scrn.c defines the notes screen output backend of refdbd
  markus@mhoenicka.de 2003-10-14

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#include <string.h>
#include <stdio.h>
#include <syslog.h> /* for definitions of log message priorities */
#include <time.h>
#include <sys/types.h> /* for getpid() */
#include <unistd.h>    /* for getpid() */
#include <dbi/dbi.h>

#include "refdb.h"
#include "backend.h"
#include "backendn-scrn.h"
#include "strfncs.h"
#include "dbfncs.h"
#include "linklist.h"
#include "refdbd.h"
#include "connect.h"

/* some globals */
extern int n_log_level; /* numeric version of log_level */

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  prepare_render_note_scrn(): writes a header for the screen output of a
                         notes query

  int prepare_render_note_scrn returns 0 if successful, >0 if failed

  struct renderinfo* ptr_rendinfo ptr to a structure with the info
                             how the note should be rendered

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int prepare_render_note_scrn(struct renderinfo* ptr_rendinfo) {
  /* we just make sure that we start with a clean string */
  (*(ptr_rendinfo->ptr_ref))[0] = '\0';
  return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  finish_render_note_scrn(): writes a footer for the screen output of
                             a notes query

  int finish_render_note_scrn returns 0 if successful, >0 if failed

  struct renderinfo* ptr_rendinfo ptr to a structure with the info
                             how the reference should be rendered

 ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int finish_render_note_scrn(struct renderinfo* ptr_rendinfo) {
  /* nothing to do here */
  return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  render_note_scrn() renders a note for screen display

  int render_note_scrn returns 0 if successful, >0 if failed

  struct renderinfo* ptr_rendinfo ptr to a structure with the info
                             how the reference should be rendered

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
int render_note_scrn(struct renderinfo* ptr_rendinfo) {
  int i;
  char id[32] = "";
  char date_buffer[256];
  char linktype[4][11] = {"reference", "keyword", "author", "periodical"};
  const char* citem;
  char* item;
  char* new_ref;
  dbi_conn conn;
  dbi_result dbires;

  conn = dbi_result_get_conn(ptr_rendinfo->dbires);

  /*----------------------------------------------------------------*/
  /* ID */
  get_refdb_note_id(ptr_rendinfo->dbires, id);

  if (*id) {
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "Note ID:", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    /* ID */
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), id, ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }
  }
  else {
    LOG_PRINT(LOG_WARNING, get_status_msg(234));
    return 234; /* this is bad and will hopefully never happen */
  }

  /*----------------------------------------------------------------*/
  /* date */
  if (get_refdb_note_date(ptr_rendinfo->dbires, date_buffer, 0) != NULL) {
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), " (", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    /* date */
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), date_buffer, ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), ")", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }
  }

  if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\n", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
    LOG_PRINT(LOG_CRIT, get_status_msg(801));
    return 801;
  }
  else {
    *(ptr_rendinfo->ptr_ref) = new_ref;
  }

  /*----------------------------------------------------------------*/
  /* note key */
  citem = get_refdb_note_key(ptr_rendinfo->dbires);
  if (citem && *citem) {
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "Key: ", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)citem, ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\n", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }
  }

  /*----------------------------------------------------------------*/
  /* note title */
  item = get_refdb_note_title_copy(ptr_rendinfo->dbires);
  if (item != NULL) {
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)item, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* title */
      free(item);
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    free(item);

    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\n", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }
  }

  /*----------------------------------------------------------------*/
  /* the note proper */
  item = get_refdb_note_content_copy(ptr_rendinfo->dbires);
  if (item != NULL) {
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)item, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
      free(item);
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }

    free(item);

    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\n", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }
  }

  /*----------------------------------------------------------------*/
  /* links */
  
  if (strstr((ptr_rendinfo->ptr_biblio_info)->format_string, "NL") != NULL
      || strstr((ptr_rendinfo->ptr_biblio_info)->format_string, "ALL") != NULL) {
    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\nNote is attached to:", ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
      LOG_PRINT(LOG_CRIT, get_status_msg(801));
      return 801;
    }
    else {
      *(ptr_rendinfo->ptr_ref) = new_ref;
    }
    
    /* loop over reference, keyword, author, periodical links */
    for (i = 0; i < 4; i++) {
      int mode = i;
      dbires = request_links(conn, my_dbi_result_get_idval(ptr_rendinfo->dbires, "note_id"), i);
      if (dbires == NULL) {
	return 234;
      }

      /* fetch all links of this type and note */
      while ((citem = get_link(dbires, &mode)) != NULL) {
	if (i == 3) { /* periodical */
	  if (!mode) { /* full name */
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\nPeriodical full name: ", ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)citem, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	}
	  else if (mode == 1) { /* abbrev */
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\nPeriodical abbreviation: ", ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)citem, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	  }
	  else if (mode == 2) { /* custabbrev 1 */
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\nPeriodical custom abbreviation 1: ", ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)citem, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	  }
	  else if (mode == 3) { /* custabbrev 2 */
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\nPeriodical custom abbreviation 2: ", ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	    if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)citem, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	      free(item);
	      LOG_PRINT(LOG_CRIT, get_status_msg(801));
	      return 801;
	    }
	    else {
	      *(ptr_rendinfo->ptr_ref) = new_ref;
	    }
	  }
	}
	else {
	  /* reuse date_buffer */
	  sprintf(date_buffer, "\n%s: ", linktype[i]);
	  if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), date_buffer, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	    free(item);
	    LOG_PRINT(LOG_CRIT, get_status_msg(801));
	    return 801;
	  }
	  else {
	    *(ptr_rendinfo->ptr_ref) = new_ref;
	  }
	  if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), (char*)citem, ptr_rendinfo->ptr_ref_len, 0)) == NULL) { /* note proper */
	    free(item);
	    LOG_PRINT(LOG_CRIT, get_status_msg(801));
	    return 801;
	  }
	  else {
	    *(ptr_rendinfo->ptr_ref) = new_ref;
	  }
	}
      }
      clean_request(dbires);
    } /* end for */
  }

  /*----------------------------------------------------------------*/
  /* ulink */
  if (strstr((ptr_rendinfo->ptr_biblio_info)->format_string, "UR") != NULL
      || strstr((ptr_rendinfo->ptr_biblio_info)->format_string, "ALL") != NULL) {
    int i;
    char link_tag[12];

    /* loop over all link types */
    for (i=0; i<5;i++) {
      if (!i) {
	strcpy(link_tag, "\nURL: ");
      }
      else if (i == 1) {
	strcpy(link_tag, "\nPDF: ");
      }
      else if (i == 2) {
	strcpy(link_tag, "\nFULLTEXT: ");
      }
      else if (i == 3) {
	strcpy(link_tag, "\nRELATED: ");
      }
      else if (i == 4) {
	strcpy(link_tag, "\nIMAGE: ");
      }
      
      dbires = request_ulinks(conn, my_dbi_result_get_idval(ptr_rendinfo->dbires, "note_id"), 1 /* note entry */, i /* link type */, 0 /* is_temp */, ptr_rendinfo->username);
      if (dbires == NULL) {
	return 234;
      }

      while ((citem = get_ulink(dbires)) != NULL) {
	char* full_link;

	if (i>0 && i<5) {
	  full_link = add_root_to_link(citem, ptr_rendinfo->pdfroot);
	}
	else {
	  full_link = strdup(citem);
	}

	if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), link_tag, ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
	  LOG_PRINT(LOG_CRIT, get_status_msg(801));
	  clean_request(dbires);
	  return 801;
	}
	else {
	  *(ptr_rendinfo->ptr_ref) = new_ref;
	}

	if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), full_link, ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
	  LOG_PRINT(LOG_CRIT, get_status_msg(801));
	  clean_request(dbires);
	  return 801;
	}
	else {
	  *(ptr_rendinfo->ptr_ref) = new_ref;
	}

	free(full_link);

      } /* end while */
      clean_request(dbires);
    } /* end for */
  }

  /* finish with an empty line */
  if ((new_ref = mstrcat(*(ptr_rendinfo->ptr_ref), "\n\n", ptr_rendinfo->ptr_ref_len, 0)) == NULL) {
    LOG_PRINT(LOG_CRIT, get_status_msg(801));
    return 801;
  }
  else {
    *(ptr_rendinfo->ptr_ref) = new_ref;
  }
/*      printf("%s\n", ref); */
  return 0;
}
