
%javamethodmodifiers getClock() "
  /**
    * @return The current simulated time
    */
  public";

%typemap(javaimports) Model "
/**
  * A component (e.g., Cpu, Network, Storage, ...) is composed of three classes:
  * <ul>
  *  <li> Model: It handle the interactions between resoucses and actions</li>
  *  <li> Resource: A resource used by the model (e.g., a cpu, a network link)</li>
  *  <li> Action: An action generated by the resources (e.g., execution, communication)</li>
  * </ul>
  * @see Resource
  * @see Action
  */"

%javamethodmodifiers Model::Model(const char *name) "
  /**
    * Model constructor
    * @param name The name of the model
    */
  public";

%javamethodmodifiers Model::getName() "
  /**
    * @return The name of the model
    */
  public";

%javamethodmodifiers Model::shareResources(double now) "
  /**
    * Share the resources between the actions
    * @param now the current time
    * @return the date of the next action of the model will finish
    */
  public";

%javamethodmodifiers Model::updateActionsState(double now, double delta) "
  /**
    * Update time of actions and eventually their states
    * @param now the new current time
    * @param delta the delta between previous and new current time
    */
  public";

  %javamethodmodifiers Model::getRunningActionSet() "
  /**
    * Get the List of running Actions
    */
  public";


%typemap(javaimports) CpuModel "
/**
  * The generic model for the Cpu component
  * @see Cpu
  * @see CpuAction
  */"

%javamethodmodifiers CpuModel::CpuModel(const char *name) "
  /**
    * CpuModel constructon
    * @param name The name of the cpumodel
    */
  public";


%javamethodmodifiers CpuModel::createCpu(const char *name, DoubleDynar power_peak,
                              int pstate, double power_scale,
                              tmgr_trace *power_trace, int core,
                              e_surf_resource_state_t state_initial,
                              tmgr_trace *state_trace,
                              s_xbt_dict *cpu_properties) "
  /**
    * Create a new Cpu
    *
    * @param name
    * @param power_peak
    * @param pstate
    * @param power_scale
    * @param power_trace
    * @param core
    * @param state_initial
    * @param state_trace
    * @param cpu_properties
    * @return The new Cpu
    * @see Cpu
    */
  public";


%typemap(javaimports) Resource "
/**
  * A resource used by a model (e.g., a cpu, a network link)
  * @see Model
  * @see Action
  */"

%javamethodmodifiers Resource::getName() "
  /**
    * @return The name of the resource
    */
  public";

%javamethodmodifiers Resource::isUsed() "
  /**
    * @return True if the Resource is used
    */
  public";

%javamethodmodifiers Resource::getModel() "
  /**
    * @return The model associated to this Resource
    */
  public";

%javamethodmodifiers Resource::getState() "
  /**
    * @return The state of the resource
    * @see ResourceState
    */
  public";

%javamethodmodifiers Resource::getConstraint() "
  /**
    * @return The constraint associatied (if using LMM)
    */
  public";

%javamethodmodifiers Resource::getProperties() "
  /**
    * @return The XbtDict of properties associated to this Resource
    */
  public";

%javamethodmodifiers Resource::updateState(tmgr_trace_event *event_type, double value, double date) "
  /**
    * Update the state of the Resource
    * @param event_type
    * @param value
    * @param date
    */
  public";


%typemap(javaimports) Cpu "
/**
  * A generic resource for the cpu component
  * @see CpuModel
  * @see CpuAction
  */"

%javamethodmodifiers Cpu::Cpu(Model *model, const char *name, s_xbt_dict *props,
    lmm_constraint *constraint, int core, double powerPeak, double powerScale) "
  /**
    * A cpu constructor (using LMM)
    * @param model
    * @param name
    * @param props
    * @param constraint
    * @param core
    * @param powerPeak
    * @param powerScale
    */
  public";

%javamethodmodifiers Cpu::Cpu(Model *model, const char *name, s_xbt_dict *props,
    int core, double powerPeak, double powerScale) "
  /**
    * A cpu constructor
    * @param model
    * @param name
    * @param props
    * @param core
    * @param powerPeak
    * @param powerScale
    */
  public";

%javamethodmodifiers Cpu::getCurrentPowerPeak() "
  /**
    * @return The current power peak
    */
  public";

%javamethodmodifiers Cpu::execute(double size) "
  /**
    * Execute some quantity of computation
    * @param size The processing amount (in flop) needed to process
    * @return A cpu action representing code execution
    */
  public";

%javamethodmodifiers Cpu::sleep(double duration) "
  /**
    * Make a process sleep for duration
    * @param duration The number of seconds to sleep
    * @return A cpu action representing sleeping
    */
  public";

%javamethodmodifiers Cpu::getCore() "
  /**
    * @return The number of cores on the cpu
    */
  public";

%javamethodmodifiers Cpu::getSpeed(double load) "
  /**
    * TODO
    * @param load
    */
  public";

%javamethodmodifiers Cpu::getAvailableSpeed() "
  /**
    * TODO
    */
  public";

%javamethodmodifiers Cpu::getPowerPeakAt(int pstate_index) "
  /**
    * @param pstate_index index of power peak to get
    * @return Power peak at index
    */
  public";

  %javamethodmodifiers Cpu::getNbPstates() "
  /**
    * @return Number of power peak
    */
  public";

%javamethodmodifiers Cpu::setPowerPeakAt(int pstate_index) "
  /**
    * @param pstate_index index of power peak to set
    */
  public";

%javamethodmodifiers Cpu::setState(e_surf_resource_state_t state) "
  /**
    * @param state The new state of the cpu
    */
  public";


%typemap(javaimports) Link "
/**
 * A generic resource for the network component
 */"

  %javamethodmodifiers Link::getBandwidth() "
  /**
    * @return The bandwidth of the link
    */
  public";

%javamethodmodifiers Link::updateBandwidth(double value, double date=surf_get_clock()) "
  /**
    * @param value The new bandwidth
    */
  public";

  %javamethodmodifiers Link::getLatency() "
  /**
    * @return The latency of the link
    */
  public";

%javamethodmodifiers Link::updateLatency(double value, double date=surf_get_clock()) "
  /**
    * @param value The new latency
    */
  public";


%typemap(javaimports) Action "
/**
  * An action created by a Resource (e.g., a communication, an execution)
  * @see Model
  * @see Resource
  */"

%javamethodmodifiers Action::Action(Model *model, double cost, bool failed) "
  /**
    * Action constructor
    * @param model The model associated
    * @param cost The cost of the action (e.g., flops, bytes)
    * @param failed If the action has failed
    */
  public";

%javamethodmodifiers Action::getModel() "
  /**
    * @return The model associated
    */
  public";

%javamethodmodifiers Action::getVariable() "
  /**
    * @return The variable associatied (if using LMM)
    */
  public";

%javamethodmodifiers Action::getState() "
  /**
    * @return The state of the action
    */
  public";

%javamethodmodifiers Action::isSuspended() "
  /**
    * @return True if suspended
    */
  public";

%javamethodmodifiers Action::getBound() "
  /**
    * @return TODO
    */
  public";

%javamethodmodifiers Action::setBound(double bound) "
  /**
    * @param bound TODO
    */
  public";

%javamethodmodifiers Action::updateRemains(double delta) "
  /**
    * Update remaining amount of cost to do
    * @param delta Difference of time since last call to this function
    */
  public";

%javamethodmodifiers Action::getRemains() "
  /**
    * @return The remaining amount of cost to do
    */
  public";

%javamethodmodifiers Action::setPriority(double priority) "
  /**
    * @param priority The new priority of the action
    */
  public";

%javamethodmodifiers Action::setState(e_surf_action_state_t state) "
  /**
    * @param state The new state
    */
  public";


%typemap(javaimports) CpuAction "
/**
  * An cpu action created by a Cpu
  * @see CpuModel
  * @see Cpu
  */"

%javamethodmodifiers CpuAction::CpuAction(Model *model, double cost, bool failed) "
  /**
    * CpuAction constructor
    * @param model The model associated
    * @param cost The cost of the action (e.g., flops, bytes)
    * @param failed If the action has failed
    */
  public";

%javamethodmodifiers CpuAction::getCpu() "
  /**
    * @return The associated cpu
    */
  public";


%typemap(javaimports) NetworkAction "
/**
  * An network action created by network model
  * @see Link
  */"

%javamethodmodifiers NetworkAction::getLatency() "
  /**
    * @return The latency of the action
    */
  public";


%typemap(javaimports) LmmConstraint "
/**
  * An linear maxmin generic constraint
  */"

%javamethodmodifiers LmmConstraint::getUsage() "
  /**
    *
    */
  public";

%typemap(javaimports) LmmVariable "
/**
  * An linear maxmin generic variable
  */"

%javamethodmodifiers LmmVariable::getValue() "
  /**
    *
    */
  public";

%typemap(javaimports) XbtDict "
/**
  * A c structure handling key:values
  */"

%javamethodmodifiers XbtDict::getValue(char *key) "
  /**
    *
    */
  public";


%typemap(javaimports) ActionState "
/**
  * The possible states of an Action
  */"


%typemap(javaimports) ResourceState "
/**
  * The possible states of a Resource
  */"
