/**********************************************************************/
/* File generated by src/simix/simcalls.py from src/simix/simcalls.in */
/*                                                                    */
/*                    DO NOT EVER CHANGE THIS FILE                    */
/*                                                                    */
/* change simcalls specification in src/simix/simcalls.in             */
/**********************************************************************/

/*
 * Note that the name comes from http://en.wikipedia.org/wiki/Popping
 * Indeed, the control flow is doing a strange dance in there.
 *
 * That's not about http://en.wikipedia.org/wiki/Poop, despite the odor :)
 */

#include "smx_private.h"
#include "mc/mc_forward.h"
#include "xbt/ex.h"
  
inline static const char* simcall_BODY_host_get_name(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_name(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_NAME;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.cc;
  }
  
inline static void simcall_BODY_host_on(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_on(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_ON;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_host_off(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_host_off(&self->simcall, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_OFF;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static xbt_dict_t simcall_BODY_host_get_properties(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_properties(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_PROPERTIES;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static int simcall_BODY_host_get_core(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_core(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_CORE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static xbt_swag_t simcall_BODY_host_get_process_list(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_process_list(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_PROCESS_LIST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static double simcall_BODY_host_get_speed(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_speed(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_SPEED;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static double simcall_BODY_host_get_available_speed(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_available_speed(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_AVAILABLE_SPEED;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static int simcall_BODY_host_get_state(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_state(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_STATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static double simcall_BODY_host_get_current_power_peak(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_current_power_peak(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_CURRENT_POWER_PEAK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static double simcall_BODY_host_get_power_peak_at(sg_host_t host, int pstate_index) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_power_peak_at(host, pstate_index);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_POWER_PEAK_AT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    self->simcall.args[1].i = (int) pstate_index;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static int simcall_BODY_host_get_nb_pstates(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_nb_pstates(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_NB_PSTATES;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static double simcall_BODY_host_get_wattmin_at(sg_host_t host, int pstate_index) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_wattmin_at(host, pstate_index);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_WATTMIN_AT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    self->simcall.args[1].i = (int) pstate_index;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static double simcall_BODY_host_get_wattmax_at(sg_host_t host, int pstate_index) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_wattmax_at(host, pstate_index);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_WATTMAX_AT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    self->simcall.args[1].i = (int) pstate_index;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static void simcall_BODY_host_set_pstate(sg_host_t host, int pstate_index) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_set_pstate(host, pstate_index);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_SET_PSTATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    self->simcall.args[1].i = (int) pstate_index;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_host_get_pstate(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_pstate(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_PSTATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static double simcall_BODY_host_get_consumed_energy(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_consumed_energy(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_CONSUMED_ENERGY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static xbt_dict_t simcall_BODY_host_get_mounted_storage_list(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_mounted_storage_list(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_MOUNTED_STORAGE_LIST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static xbt_dynar_t simcall_BODY_host_get_attached_storage_list(sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_attached_storage_list(host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_ATTACHED_STORAGE_LIST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_host_get_params(sg_host_t ind_vm, vm_params_t params) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_get_params(ind_vm, params);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_GET_PARAMS;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    self->simcall.args[1].dp = (void*) params;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_host_set_params(sg_host_t ind_vm, vm_params_t params) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_host_set_params(ind_vm, params);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_HOST_SET_PARAMS;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    self->simcall.args[1].dp = (void*) params;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static sg_host_t simcall_BODY_vm_create(const char* name, sg_host_t ind_pm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_create(name, ind_pm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_CREATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) name;
    self->simcall.args[1].dp = (void*) ind_pm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_vm_start(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_start(ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_START;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_vm_get_state(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_get_state(ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_GET_STATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_vm_migrate(sg_host_t ind_vm, sg_host_t ind_dst_pm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_migrate(ind_vm, ind_dst_pm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_MIGRATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    self->simcall.args[1].dp = (void*) ind_dst_pm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void* simcall_BODY_vm_get_pm(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_get_pm(ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_GET_PM;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_vm_set_bound(sg_host_t ind_vm, double bound) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_set_bound(ind_vm, bound);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_SET_BOUND;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    self->simcall.args[1].d = (double) bound;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_set_affinity(sg_host_t ind_vm, sg_host_t ind_pm, unsigned long mask) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_set_affinity(ind_vm, ind_pm, mask);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_SET_AFFINITY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    self->simcall.args[1].dp = (void*) ind_pm;
    self->simcall.args[2].ul = (unsigned long) mask;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_destroy(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_destroy(ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_DESTROY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_suspend(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_vm_suspend(&self->simcall, ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_SUSPEND;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_resume(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_vm_resume(&self->simcall, ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_RESUME;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_shutdown(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_vm_shutdown(&self->simcall, ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_SHUTDOWN;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_save(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_vm_save(&self->simcall, ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_SAVE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_restore(sg_host_t ind_vm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_vm_restore(&self->simcall, ind_vm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_RESTORE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) ind_vm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_vm_migratefrom_resumeto(sg_host_t vm, sg_host_t src_pm, sg_host_t dst_pm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_vm_migratefrom_resumeto(vm, src_pm, dst_pm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_VM_MIGRATEFROM_RESUMETO;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) vm;
    self->simcall.args[1].dp = (void*) src_pm;
    self->simcall.args[2].dp = (void*) dst_pm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void* simcall_BODY_process_create(const char* name, xbt_main_func_t code, void* data, const char* hostname, double kill_time, int argc, char** argv, xbt_dict_t properties, int auto_restart) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_create(&self->simcall, name, code, data, hostname, kill_time, argc, argv, properties, auto_restart);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_CREATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) name;
    self->simcall.args[1].fp = (FPtr) code;
    self->simcall.args[2].dp = (void*) data;
    self->simcall.args[3].cc = (const char*) hostname;
    self->simcall.args[4].d = (double) kill_time;
    self->simcall.args[5].i = (int) argc;
    self->simcall.args[6].dp = (void*) argv;
    self->simcall.args[7].dp = (void*) properties;
    self->simcall.args[8].i = (int) auto_restart;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_process_kill(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_kill(&self->simcall, process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_KILL;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_killall(int reset_pid) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_killall(&self->simcall, reset_pid);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_KILLALL;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].i = (int) reset_pid;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_cleanup(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_cleanup(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_CLEANUP;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_suspend(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_suspend(&self->simcall, process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_SUSPEND;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_resume(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_resume(&self->simcall, process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_RESUME;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_process_count() {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_count();
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_COUNT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));

    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static int simcall_BODY_process_get_PID(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_get_PID(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_GET_PID;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static int simcall_BODY_process_get_PPID(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_get_PPID(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_GET_PPID;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void* simcall_BODY_process_get_data(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_get_data(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_GET_DATA;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_process_set_data(smx_process_t process, void* data) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_set_data(process, data);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_SET_DATA;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    self->simcall.args[1].dp = (void*) data;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_set_host(smx_process_t process, sg_host_t dest) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_set_host(&self->simcall, process, dest);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_SET_HOST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    self->simcall.args[1].dp = (void*) dest;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static sg_host_t simcall_BODY_process_get_host(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_get_host(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_GET_HOST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static const char* simcall_BODY_process_get_name(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_get_name(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_GET_NAME;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.cc;
  }
  
inline static int simcall_BODY_process_is_suspended(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_is_suspended(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_IS_SUSPENDED;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static xbt_dict_t simcall_BODY_process_get_properties(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_get_properties(process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_GET_PROPERTIES;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static int simcall_BODY_process_join(smx_process_t process, double timeout) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_join(&self->simcall, process, timeout);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_JOIN;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    self->simcall.args[1].d = (double) timeout;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static int simcall_BODY_process_sleep(double duration) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_sleep(&self->simcall, duration);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_SLEEP;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].d = (double) duration;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static smx_synchro_t simcall_BODY_process_execute(const char* name, double flops_amount, double priority, double bound, unsigned long affinity_mask) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_execute(&self->simcall, name, flops_amount, priority, bound, affinity_mask);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) name;
    self->simcall.args[1].d = (double) flops_amount;
    self->simcall.args[2].d = (double) priority;
    self->simcall.args[3].d = (double) bound;
    self->simcall.args[4].ul = (unsigned long) affinity_mask;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static smx_synchro_t simcall_BODY_process_parallel_execute(const char* name, int host_nb, sg_host_t* host_list, double* flops_amount, double* bytes_amount, double amount, double rate) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_parallel_execute(name, host_nb, host_list, flops_amount, bytes_amount, amount, rate);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_PARALLEL_EXECUTE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) name;
    self->simcall.args[1].i = (int) host_nb;
    self->simcall.args[2].dp = (void*) host_list;
    self->simcall.args[3].dp = (void*) flops_amount;
    self->simcall.args[4].dp = (void*) bytes_amount;
    self->simcall.args[5].d = (double) amount;
    self->simcall.args[6].d = (double) rate;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_process_execution_destroy(smx_synchro_t execution) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_destroy(execution);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_DESTROY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_execution_cancel(smx_synchro_t execution) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_cancel(execution);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_CANCEL;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static double simcall_BODY_process_execution_get_remains(smx_synchro_t execution) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_get_remains(execution);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_GET_REMAINS;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static e_smx_state_t simcall_BODY_process_execution_get_state(smx_synchro_t execution) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_get_state(execution);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_GET_STATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_process_execution_set_priority(smx_synchro_t execution, double priority) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_set_priority(execution, priority);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_SET_PRIORITY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    self->simcall.args[1].d = (double) priority;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_execution_set_bound(smx_synchro_t execution, double bound) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_set_bound(execution, bound);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_SET_BOUND;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    self->simcall.args[1].d = (double) bound;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_execution_set_affinity(smx_synchro_t execution, sg_host_t ws, unsigned long mask) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_execution_set_affinity(execution, ws, mask);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_SET_AFFINITY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    self->simcall.args[1].dp = (void*) ws;
    self->simcall.args[2].ul = (unsigned long) mask;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_process_execution_wait(smx_synchro_t execution) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_execution_wait(&self->simcall, execution);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_EXECUTION_WAIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) execution;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_process_on_exit(smx_process_t process, int_f_pvoid_pvoid_t fun, void* data) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_on_exit(process, fun, data);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_ON_EXIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    self->simcall.args[1].fp = (FPtr) fun;
    self->simcall.args[2].dp = (void*) data;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_process_auto_restart_set(smx_process_t process, int auto_restart) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_process_auto_restart_set(process, auto_restart);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_AUTO_RESTART_SET;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    self->simcall.args[1].i = (int) auto_restart;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static smx_process_t simcall_BODY_process_restart(smx_process_t process) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_process_restart(&self->simcall, process);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_PROCESS_RESTART;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) process;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static smx_rdv_t simcall_BODY_rdv_create(const char* name) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_rdv_create(name);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_RDV_CREATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) name;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_rdv_destroy(smx_rdv_t rdv) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_rdv_destroy(rdv);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_RDV_DESTROY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) rdv;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static unsigned int simcall_BODY_rdv_comm_count_by_host(smx_rdv_t rdv, sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_rdv_comm_count_by_host(rdv, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_RDV_COMM_COUNT_BY_HOST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) rdv;
    self->simcall.args[1].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.ui;
  }
  
inline static smx_synchro_t simcall_BODY_rdv_get_head(smx_rdv_t rdv) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_rdv_get_head(rdv);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_RDV_GET_HEAD;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) rdv;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_rdv_set_receiver(smx_rdv_t rdv, smx_process_t receiver) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_rdv_set_receiver(rdv, receiver);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_RDV_SET_RECEIVER;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) rdv;
    self->simcall.args[1].dp = (void*) receiver;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static smx_process_t simcall_BODY_rdv_get_receiver(smx_rdv_t rdv) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_rdv_get_receiver(rdv);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_RDV_GET_RECEIVER;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) rdv;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static smx_synchro_t simcall_BODY_comm_iprobe(smx_rdv_t rdv, int type, int src, int tag, simix_match_func_t match_fun, void* data) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_iprobe(&self->simcall, rdv, type, src, tag, match_fun, data);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_IPROBE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) rdv;
    self->simcall.args[1].i = (int) type;
    self->simcall.args[2].i = (int) src;
    self->simcall.args[3].i = (int) tag;
    self->simcall.args[4].fp = (FPtr) match_fun;
    self->simcall.args[5].dp = (void*) data;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_comm_send(smx_process_t sender, smx_rdv_t rdv, double task_size, double rate, void* src_buff, size_t src_buff_size, simix_match_func_t match_fun, simix_copy_data_func_t copy_data_fun, void* data, double timeout) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_send(&self->simcall, sender, rdv, task_size, rate, src_buff, src_buff_size, match_fun, copy_data_fun, data, timeout);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_SEND;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sender;
    self->simcall.args[1].dp = (void*) rdv;
    self->simcall.args[2].d = (double) task_size;
    self->simcall.args[3].d = (double) rate;
    self->simcall.args[4].dp = (void*) src_buff;
    self->simcall.args[5].sz = (size_t) src_buff_size;
    self->simcall.args[6].fp = (FPtr) match_fun;
    self->simcall.args[7].fp = (FPtr) copy_data_fun;
    self->simcall.args[8].dp = (void*) data;
    self->simcall.args[9].d = (double) timeout;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static smx_synchro_t simcall_BODY_comm_isend(smx_process_t sender, smx_rdv_t rdv, double task_size, double rate, void* src_buff, size_t src_buff_size, simix_match_func_t match_fun, simix_clean_func_t clean_fun, simix_copy_data_func_t copy_data_fun, void* data, int detached) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_isend(&self->simcall, sender, rdv, task_size, rate, src_buff, src_buff_size, match_fun, clean_fun, copy_data_fun, data, detached);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_ISEND;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sender;
    self->simcall.args[1].dp = (void*) rdv;
    self->simcall.args[2].d = (double) task_size;
    self->simcall.args[3].d = (double) rate;
    self->simcall.args[4].dp = (void*) src_buff;
    self->simcall.args[5].sz = (size_t) src_buff_size;
    self->simcall.args[6].fp = (FPtr) match_fun;
    self->simcall.args[7].fp = (FPtr) clean_fun;
    self->simcall.args[8].fp = (FPtr) copy_data_fun;
    self->simcall.args[9].dp = (void*) data;
    self->simcall.args[10].i = (int) detached;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_comm_recv(smx_process_t receiver, smx_rdv_t rdv, void* dst_buff, size_t* dst_buff_size, simix_match_func_t match_fun, simix_copy_data_func_t copy_data_fun, void* data, double timeout, double rate) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_recv(&self->simcall, receiver, rdv, dst_buff, dst_buff_size, match_fun, copy_data_fun, data, timeout, rate);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_RECV;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) receiver;
    self->simcall.args[1].dp = (void*) rdv;
    self->simcall.args[2].dp = (void*) dst_buff;
    self->simcall.args[3].dp = (void*) dst_buff_size;
    self->simcall.args[4].fp = (FPtr) match_fun;
    self->simcall.args[5].fp = (FPtr) copy_data_fun;
    self->simcall.args[6].dp = (void*) data;
    self->simcall.args[7].d = (double) timeout;
    self->simcall.args[8].d = (double) rate;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static smx_synchro_t simcall_BODY_comm_irecv(smx_process_t receiver, smx_rdv_t rdv, void* dst_buff, size_t* dst_buff_size, simix_match_func_t match_fun, simix_copy_data_func_t copy_data_fun, void* data, double rate) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_irecv(&self->simcall, receiver, rdv, dst_buff, dst_buff_size, match_fun, copy_data_fun, data, rate);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_IRECV;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) receiver;
    self->simcall.args[1].dp = (void*) rdv;
    self->simcall.args[2].dp = (void*) dst_buff;
    self->simcall.args[3].dp = (void*) dst_buff_size;
    self->simcall.args[4].fp = (FPtr) match_fun;
    self->simcall.args[5].fp = (FPtr) copy_data_fun;
    self->simcall.args[6].dp = (void*) data;
    self->simcall.args[7].d = (double) rate;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_comm_cancel(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_cancel(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_CANCEL;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_comm_waitany(xbt_dynar_t comms) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_waitany(&self->simcall, comms);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_WAITANY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comms;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_comm_wait(smx_synchro_t comm, double timeout) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_wait(&self->simcall, comm, timeout);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_WAIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    self->simcall.args[1].d = (double) timeout;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_comm_test(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_test(&self->simcall, comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_TEST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static int simcall_BODY_comm_testany(xbt_dynar_t comms) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_comm_testany(&self->simcall, comms);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_TESTANY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comms;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static double simcall_BODY_comm_get_remains(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_get_remains(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_GET_REMAINS;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.d;
  }
  
inline static e_smx_state_t simcall_BODY_comm_get_state(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_get_state(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_GET_STATE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void* simcall_BODY_comm_get_src_data(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_get_src_data(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_GET_SRC_DATA;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void* simcall_BODY_comm_get_dst_data(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_get_dst_data(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_GET_DST_DATA;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static smx_process_t simcall_BODY_comm_get_src_proc(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_get_src_proc(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_GET_SRC_PROC;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static smx_process_t simcall_BODY_comm_get_dst_proc(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_get_dst_proc(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_GET_DST_PROC;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static smx_mutex_t simcall_BODY_mutex_init() {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mutex_init(&self->simcall);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MUTEX_INIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));

    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_mutex_destroy(smx_mutex_t mutex) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_mutex_destroy(mutex);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MUTEX_DESTROY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) mutex;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_mutex_lock(smx_mutex_t mutex) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mutex_lock(&self->simcall, mutex);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MUTEX_LOCK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) mutex;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_mutex_trylock(smx_mutex_t mutex) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mutex_trylock(&self->simcall, mutex);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MUTEX_TRYLOCK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) mutex;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_mutex_unlock(smx_mutex_t mutex) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mutex_unlock(&self->simcall, mutex);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MUTEX_UNLOCK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) mutex;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static smx_cond_t simcall_BODY_cond_init() {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_cond_init();
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COND_INIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));

    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_cond_destroy(smx_cond_t cond) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_cond_destroy(cond);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COND_DESTROY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) cond;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_cond_signal(smx_cond_t cond) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_cond_signal(cond);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COND_SIGNAL;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) cond;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_cond_wait(smx_cond_t cond, smx_mutex_t mutex) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_cond_wait(&self->simcall, cond, mutex);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COND_WAIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) cond;
    self->simcall.args[1].dp = (void*) mutex;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_cond_wait_timeout(smx_cond_t cond, smx_mutex_t mutex, double timeout) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_cond_wait_timeout(&self->simcall, cond, mutex, timeout);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COND_WAIT_TIMEOUT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) cond;
    self->simcall.args[1].dp = (void*) mutex;
    self->simcall.args[2].d = (double) timeout;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_cond_broadcast(smx_cond_t cond) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_cond_broadcast(cond);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COND_BROADCAST;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) cond;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static smx_sem_t simcall_BODY_sem_init(unsigned int capacity) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_sem_init(capacity);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_INIT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].ui = (unsigned int) capacity;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static void simcall_BODY_sem_destroy(smx_sem_t sem) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_sem_destroy(sem);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_DESTROY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sem;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_sem_release(smx_sem_t sem) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_sem_release(&self->simcall, sem);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_RELEASE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sem;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_sem_would_block(smx_sem_t sem) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_sem_would_block(&self->simcall, sem);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_WOULD_BLOCK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sem;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_sem_acquire(smx_sem_t sem) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_sem_acquire(&self->simcall, sem);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_ACQUIRE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sem;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static void simcall_BODY_sem_acquire_timeout(smx_sem_t sem, double timeout) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_sem_acquire_timeout(&self->simcall, sem, timeout);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_ACQUIRE_TIMEOUT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sem;
    self->simcall.args[1].d = (double) timeout;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
  
inline static int simcall_BODY_sem_get_capacity(smx_sem_t sem) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_sem_get_capacity(&self->simcall, sem);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SEM_GET_CAPACITY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) sem;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static sg_size_t simcall_BODY_file_read(smx_file_t fd, sg_size_t size, sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_read(&self->simcall, fd, size, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_READ;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    self->simcall.args[1].sgsz = (sg_size_t) size;
    self->simcall.args[2].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.sgsz;
  }
  
inline static sg_size_t simcall_BODY_file_write(smx_file_t fd, sg_size_t size, sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_write(&self->simcall, fd, size, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_WRITE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    self->simcall.args[1].sgsz = (sg_size_t) size;
    self->simcall.args[2].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.sgsz;
  }
  
inline static smx_file_t simcall_BODY_file_open(const char* fullpath, sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_open(&self->simcall, fullpath, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_OPEN;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) fullpath;
    self->simcall.args[1].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static int simcall_BODY_file_close(smx_file_t fd, sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_close(&self->simcall, fd, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_CLOSE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    self->simcall.args[1].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static int simcall_BODY_file_unlink(smx_file_t fd, sg_host_t host) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_file_unlink(fd, host);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_UNLINK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    self->simcall.args[1].dp = (void*) host;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static sg_size_t simcall_BODY_file_get_size(smx_file_t fd) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_get_size(&self->simcall, fd);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_GET_SIZE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.sgsz;
  }
  
inline static sg_size_t simcall_BODY_file_tell(smx_file_t fd) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_tell(&self->simcall, fd);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_TELL;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.sgsz;
  }
  
inline static int simcall_BODY_file_seek(smx_file_t fd, sg_offset_t offset, int origin) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_seek(&self->simcall, fd, offset, origin);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_SEEK;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    self->simcall.args[1].sgoff = (sg_offset_t) offset;
    self->simcall.args[2].i = (int) origin;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static xbt_dynar_t simcall_BODY_file_get_info(smx_file_t fd) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_get_info(&self->simcall, fd);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_GET_INFO;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static int simcall_BODY_file_move(smx_file_t fd, const char* fullpath) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_file_move(&self->simcall, fd, fullpath);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_FILE_MOVE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) fd;
    self->simcall.args[1].cc = (const char*) fullpath;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static sg_size_t simcall_BODY_storage_get_free_size(smx_storage_t storage) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_storage_get_free_size(&self->simcall, storage);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_STORAGE_GET_FREE_SIZE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) storage;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.sgsz;
  }
  
inline static sg_size_t simcall_BODY_storage_get_used_size(smx_storage_t name) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_storage_get_used_size(&self->simcall, name);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_STORAGE_GET_USED_SIZE;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) name;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.sgsz;
  }
  
inline static xbt_dict_t simcall_BODY_storage_get_properties(smx_storage_t storage) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_storage_get_properties(storage);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_STORAGE_GET_PROPERTIES;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) storage;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static xbt_dict_t simcall_BODY_storage_get_content(smx_storage_t storage) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_storage_get_content(storage);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_STORAGE_GET_CONTENT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) storage;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static xbt_dict_t simcall_BODY_asr_get_properties(const char* name) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_asr_get_properties(&self->simcall, name);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_ASR_GET_PROPERTIES;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].cc = (const char*) name;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static int simcall_BODY_mc_random(int min, int max) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mc_random(&self->simcall, min, max);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MC_RANDOM;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].i = (int) min;
    self->simcall.args[1].i = (int) max;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
  
inline static void simcall_BODY_set_category(smx_synchro_t synchro, const char* category) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_set_category(synchro, category);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_SET_CATEGORY;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) synchro;
    self->simcall.args[1].cc = (const char*) category;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    
  }
#ifdef HAVE_LATENCY_BOUND_TRACKING
  
inline static int simcall_BODY_comm_is_latency_bounded(smx_synchro_t comm) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) SIMIX_comm_is_latency_bounded(comm);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_COMM_IS_LATENCY_BOUNDED;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) comm;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
#endif

#ifdef HAVE_MC
  
inline static mc_snapshot_t simcall_BODY_mc_snapshot() {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mc_snapshot(&self->simcall);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MC_SNAPSHOT;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));

    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.dp;
  }
  
inline static int simcall_BODY_mc_compare_snapshots(mc_snapshot_t s1, mc_snapshot_t s2) {
    smx_process_t self = SIMIX_process_self();

    /* Go to that function to follow the code flow through the simcall barrier */
    if (0) simcall_HANDLER_mc_compare_snapshots(&self->simcall, s1, s2);
    /* end of the guide intended to the poor programmer wanting to go from MSG to Surf */

    self->simcall.call = SIMCALL_MC_COMPARE_SNAPSHOTS;
    memset(&self->simcall.result, 0, sizeof(self->simcall.result));
    memset(self->simcall.args, 0, sizeof(self->simcall.args));
    self->simcall.args[0].dp = (void*) s1;
    self->simcall.args[1].dp = (void*) s2;
    if (self != simix_global->maestro_process) {
      XBT_DEBUG("Yield process '%s' on simcall %s (%d)", self->name,
                SIMIX_simcall_name(self->simcall.call), (int)self->simcall.call);
      SIMIX_process_yield(self);
    } else {
      SIMIX_simcall_handle(&self->simcall, 0);
    }    
    return self->simcall.result.i;
  }
#endif
