/**********************************************************************/
/* File generated by src/simix/simcalls.py from src/simix/simcalls.in */
/*                                                                    */
/*                    DO NOT EVER CHANGE THIS FILE                    */
/*                                                                    */
/* change simcalls specification in src/simix/simcalls.in             */
/**********************************************************************/

/*
 * Note that the name comes from http://en.wikipedia.org/wiki/Popping
 * Indeed, the control flow is doing a strange dance in there.
 *
 * That's not about http://en.wikipedia.org/wiki/Poop, despite the odor :)
 */

#include <xbt/base.h>
#include "smx_private.h"
#ifdef HAVE_MC
#include "mc/mc_forward.h"
#endif

XBT_LOG_EXTERNAL_DEFAULT_CATEGORY(simix_popping);

/** @brief Simcalls' names (generated from src/simix/simcalls.in) */
const char* simcall_names[] = {
  [SIMCALL_HOST_GET_NAME] = "SIMCALL_HOST_GET_NAME",
  [SIMCALL_HOST_ON] = "SIMCALL_HOST_ON",
  [SIMCALL_HOST_OFF] = "SIMCALL_HOST_OFF",
  [SIMCALL_HOST_GET_PROPERTIES] = "SIMCALL_HOST_GET_PROPERTIES",
  [SIMCALL_HOST_GET_CORE] = "SIMCALL_HOST_GET_CORE",
  [SIMCALL_HOST_GET_PROCESS_LIST] = "SIMCALL_HOST_GET_PROCESS_LIST",
  [SIMCALL_HOST_GET_SPEED] = "SIMCALL_HOST_GET_SPEED",
  [SIMCALL_HOST_GET_AVAILABLE_SPEED] = "SIMCALL_HOST_GET_AVAILABLE_SPEED",
  [SIMCALL_HOST_GET_STATE] = "SIMCALL_HOST_GET_STATE",
  [SIMCALL_HOST_GET_CURRENT_POWER_PEAK] = "SIMCALL_HOST_GET_CURRENT_POWER_PEAK",
  [SIMCALL_HOST_GET_POWER_PEAK_AT] = "SIMCALL_HOST_GET_POWER_PEAK_AT",
  [SIMCALL_HOST_GET_NB_PSTATES] = "SIMCALL_HOST_GET_NB_PSTATES",
  [SIMCALL_HOST_GET_WATTMIN_AT] = "SIMCALL_HOST_GET_WATTMIN_AT",
  [SIMCALL_HOST_GET_WATTMAX_AT] = "SIMCALL_HOST_GET_WATTMAX_AT",
  [SIMCALL_HOST_SET_PSTATE] = "SIMCALL_HOST_SET_PSTATE",
  [SIMCALL_HOST_GET_PSTATE] = "SIMCALL_HOST_GET_PSTATE",
  [SIMCALL_HOST_GET_CONSUMED_ENERGY] = "SIMCALL_HOST_GET_CONSUMED_ENERGY",
  [SIMCALL_HOST_GET_MOUNTED_STORAGE_LIST] = "SIMCALL_HOST_GET_MOUNTED_STORAGE_LIST",
  [SIMCALL_HOST_GET_ATTACHED_STORAGE_LIST] = "SIMCALL_HOST_GET_ATTACHED_STORAGE_LIST",
  [SIMCALL_HOST_GET_PARAMS] = "SIMCALL_HOST_GET_PARAMS",
  [SIMCALL_HOST_SET_PARAMS] = "SIMCALL_HOST_SET_PARAMS",
  [SIMCALL_VM_CREATE] = "SIMCALL_VM_CREATE",
  [SIMCALL_VM_START] = "SIMCALL_VM_START",
  [SIMCALL_VM_GET_STATE] = "SIMCALL_VM_GET_STATE",
  [SIMCALL_VM_MIGRATE] = "SIMCALL_VM_MIGRATE",
  [SIMCALL_VM_GET_PM] = "SIMCALL_VM_GET_PM",
  [SIMCALL_VM_SET_BOUND] = "SIMCALL_VM_SET_BOUND",
  [SIMCALL_VM_SET_AFFINITY] = "SIMCALL_VM_SET_AFFINITY",
  [SIMCALL_VM_DESTROY] = "SIMCALL_VM_DESTROY",
  [SIMCALL_VM_SUSPEND] = "SIMCALL_VM_SUSPEND",
  [SIMCALL_VM_RESUME] = "SIMCALL_VM_RESUME",
  [SIMCALL_VM_SHUTDOWN] = "SIMCALL_VM_SHUTDOWN",
  [SIMCALL_VM_SAVE] = "SIMCALL_VM_SAVE",
  [SIMCALL_VM_RESTORE] = "SIMCALL_VM_RESTORE",
  [SIMCALL_VM_MIGRATEFROM_RESUMETO] = "SIMCALL_VM_MIGRATEFROM_RESUMETO",
  [SIMCALL_PROCESS_CREATE] = "SIMCALL_PROCESS_CREATE",
  [SIMCALL_PROCESS_KILL] = "SIMCALL_PROCESS_KILL",
  [SIMCALL_PROCESS_KILLALL] = "SIMCALL_PROCESS_KILLALL",
  [SIMCALL_PROCESS_CLEANUP] = "SIMCALL_PROCESS_CLEANUP",
  [SIMCALL_PROCESS_SUSPEND] = "SIMCALL_PROCESS_SUSPEND",
  [SIMCALL_PROCESS_RESUME] = "SIMCALL_PROCESS_RESUME",
  [SIMCALL_PROCESS_COUNT] = "SIMCALL_PROCESS_COUNT",
  [SIMCALL_PROCESS_GET_PID] = "SIMCALL_PROCESS_GET_PID",
  [SIMCALL_PROCESS_GET_PPID] = "SIMCALL_PROCESS_GET_PPID",
  [SIMCALL_PROCESS_GET_DATA] = "SIMCALL_PROCESS_GET_DATA",
  [SIMCALL_PROCESS_SET_DATA] = "SIMCALL_PROCESS_SET_DATA",
  [SIMCALL_PROCESS_SET_HOST] = "SIMCALL_PROCESS_SET_HOST",
  [SIMCALL_PROCESS_GET_HOST] = "SIMCALL_PROCESS_GET_HOST",
  [SIMCALL_PROCESS_GET_NAME] = "SIMCALL_PROCESS_GET_NAME",
  [SIMCALL_PROCESS_IS_SUSPENDED] = "SIMCALL_PROCESS_IS_SUSPENDED",
  [SIMCALL_PROCESS_GET_PROPERTIES] = "SIMCALL_PROCESS_GET_PROPERTIES",
  [SIMCALL_PROCESS_JOIN] = "SIMCALL_PROCESS_JOIN",
  [SIMCALL_PROCESS_SLEEP] = "SIMCALL_PROCESS_SLEEP",
  [SIMCALL_PROCESS_EXECUTE] = "SIMCALL_PROCESS_EXECUTE",
  [SIMCALL_PROCESS_PARALLEL_EXECUTE] = "SIMCALL_PROCESS_PARALLEL_EXECUTE",
  [SIMCALL_PROCESS_EXECUTION_DESTROY] = "SIMCALL_PROCESS_EXECUTION_DESTROY",
  [SIMCALL_PROCESS_EXECUTION_CANCEL] = "SIMCALL_PROCESS_EXECUTION_CANCEL",
  [SIMCALL_PROCESS_EXECUTION_GET_REMAINS] = "SIMCALL_PROCESS_EXECUTION_GET_REMAINS",
  [SIMCALL_PROCESS_EXECUTION_GET_STATE] = "SIMCALL_PROCESS_EXECUTION_GET_STATE",
  [SIMCALL_PROCESS_EXECUTION_SET_PRIORITY] = "SIMCALL_PROCESS_EXECUTION_SET_PRIORITY",
  [SIMCALL_PROCESS_EXECUTION_SET_BOUND] = "SIMCALL_PROCESS_EXECUTION_SET_BOUND",
  [SIMCALL_PROCESS_EXECUTION_SET_AFFINITY] = "SIMCALL_PROCESS_EXECUTION_SET_AFFINITY",
  [SIMCALL_PROCESS_EXECUTION_WAIT] = "SIMCALL_PROCESS_EXECUTION_WAIT",
  [SIMCALL_PROCESS_ON_EXIT] = "SIMCALL_PROCESS_ON_EXIT",
  [SIMCALL_PROCESS_AUTO_RESTART_SET] = "SIMCALL_PROCESS_AUTO_RESTART_SET",
  [SIMCALL_PROCESS_RESTART] = "SIMCALL_PROCESS_RESTART",
  [SIMCALL_RDV_CREATE] = "SIMCALL_RDV_CREATE",
  [SIMCALL_RDV_DESTROY] = "SIMCALL_RDV_DESTROY",
  [SIMCALL_RDV_COMM_COUNT_BY_HOST] = "SIMCALL_RDV_COMM_COUNT_BY_HOST",
  [SIMCALL_RDV_GET_HEAD] = "SIMCALL_RDV_GET_HEAD",
  [SIMCALL_RDV_SET_RECEIVER] = "SIMCALL_RDV_SET_RECEIVER",
  [SIMCALL_RDV_GET_RECEIVER] = "SIMCALL_RDV_GET_RECEIVER",
  [SIMCALL_COMM_IPROBE] = "SIMCALL_COMM_IPROBE",
  [SIMCALL_COMM_SEND] = "SIMCALL_COMM_SEND",
  [SIMCALL_COMM_ISEND] = "SIMCALL_COMM_ISEND",
  [SIMCALL_COMM_RECV] = "SIMCALL_COMM_RECV",
  [SIMCALL_COMM_IRECV] = "SIMCALL_COMM_IRECV",
  [SIMCALL_COMM_CANCEL] = "SIMCALL_COMM_CANCEL",
  [SIMCALL_COMM_WAITANY] = "SIMCALL_COMM_WAITANY",
  [SIMCALL_COMM_WAIT] = "SIMCALL_COMM_WAIT",
  [SIMCALL_COMM_TEST] = "SIMCALL_COMM_TEST",
  [SIMCALL_COMM_TESTANY] = "SIMCALL_COMM_TESTANY",
  [SIMCALL_COMM_GET_REMAINS] = "SIMCALL_COMM_GET_REMAINS",
  [SIMCALL_COMM_GET_STATE] = "SIMCALL_COMM_GET_STATE",
  [SIMCALL_COMM_GET_SRC_DATA] = "SIMCALL_COMM_GET_SRC_DATA",
  [SIMCALL_COMM_GET_DST_DATA] = "SIMCALL_COMM_GET_DST_DATA",
  [SIMCALL_COMM_GET_SRC_PROC] = "SIMCALL_COMM_GET_SRC_PROC",
  [SIMCALL_COMM_GET_DST_PROC] = "SIMCALL_COMM_GET_DST_PROC",
  [SIMCALL_MUTEX_INIT] = "SIMCALL_MUTEX_INIT",
  [SIMCALL_MUTEX_DESTROY] = "SIMCALL_MUTEX_DESTROY",
  [SIMCALL_MUTEX_LOCK] = "SIMCALL_MUTEX_LOCK",
  [SIMCALL_MUTEX_TRYLOCK] = "SIMCALL_MUTEX_TRYLOCK",
  [SIMCALL_MUTEX_UNLOCK] = "SIMCALL_MUTEX_UNLOCK",
  [SIMCALL_COND_INIT] = "SIMCALL_COND_INIT",
  [SIMCALL_COND_DESTROY] = "SIMCALL_COND_DESTROY",
  [SIMCALL_COND_SIGNAL] = "SIMCALL_COND_SIGNAL",
  [SIMCALL_COND_WAIT] = "SIMCALL_COND_WAIT",
  [SIMCALL_COND_WAIT_TIMEOUT] = "SIMCALL_COND_WAIT_TIMEOUT",
  [SIMCALL_COND_BROADCAST] = "SIMCALL_COND_BROADCAST",
  [SIMCALL_SEM_INIT] = "SIMCALL_SEM_INIT",
  [SIMCALL_SEM_DESTROY] = "SIMCALL_SEM_DESTROY",
  [SIMCALL_SEM_RELEASE] = "SIMCALL_SEM_RELEASE",
  [SIMCALL_SEM_WOULD_BLOCK] = "SIMCALL_SEM_WOULD_BLOCK",
  [SIMCALL_SEM_ACQUIRE] = "SIMCALL_SEM_ACQUIRE",
  [SIMCALL_SEM_ACQUIRE_TIMEOUT] = "SIMCALL_SEM_ACQUIRE_TIMEOUT",
  [SIMCALL_SEM_GET_CAPACITY] = "SIMCALL_SEM_GET_CAPACITY",
  [SIMCALL_FILE_READ] = "SIMCALL_FILE_READ",
  [SIMCALL_FILE_WRITE] = "SIMCALL_FILE_WRITE",
  [SIMCALL_FILE_OPEN] = "SIMCALL_FILE_OPEN",
  [SIMCALL_FILE_CLOSE] = "SIMCALL_FILE_CLOSE",
  [SIMCALL_FILE_UNLINK] = "SIMCALL_FILE_UNLINK",
  [SIMCALL_FILE_GET_SIZE] = "SIMCALL_FILE_GET_SIZE",
  [SIMCALL_FILE_TELL] = "SIMCALL_FILE_TELL",
  [SIMCALL_FILE_SEEK] = "SIMCALL_FILE_SEEK",
  [SIMCALL_FILE_GET_INFO] = "SIMCALL_FILE_GET_INFO",
  [SIMCALL_FILE_MOVE] = "SIMCALL_FILE_MOVE",
  [SIMCALL_STORAGE_GET_FREE_SIZE] = "SIMCALL_STORAGE_GET_FREE_SIZE",
  [SIMCALL_STORAGE_GET_USED_SIZE] = "SIMCALL_STORAGE_GET_USED_SIZE",
  [SIMCALL_STORAGE_GET_PROPERTIES] = "SIMCALL_STORAGE_GET_PROPERTIES",
  [SIMCALL_STORAGE_GET_CONTENT] = "SIMCALL_STORAGE_GET_CONTENT",
  [SIMCALL_ASR_GET_PROPERTIES] = "SIMCALL_ASR_GET_PROPERTIES",
  [SIMCALL_MC_RANDOM] = "SIMCALL_MC_RANDOM",
  [SIMCALL_SET_CATEGORY] = "SIMCALL_SET_CATEGORY",
#ifdef HAVE_LATENCY_BOUND_TRACKING
  [SIMCALL_COMM_IS_LATENCY_BOUNDED] = "SIMCALL_COMM_IS_LATENCY_BOUNDED",
#endif

#ifdef HAVE_MC
  [SIMCALL_MC_SNAPSHOT] = "SIMCALL_MC_SNAPSHOT",
  [SIMCALL_MC_COMPARE_SNAPSHOTS] = "SIMCALL_MC_COMPARE_SNAPSHOTS",
#endif
[SIMCALL_NONE] = "NONE"
};

/**
 * @brief (in kernel mode) unpack the simcall and activate the handler
 * 
 * This function is generated from src/simix/simcalls.in
 */
void SIMIX_simcall_handle(smx_simcall_t simcall, int value) {
  XBT_DEBUG("Handling simcall %p: %s", simcall, SIMIX_simcall_name(simcall->call));
  SIMCALL_SET_MC_VALUE(simcall, value);
  if (simcall->issuer->context->iwannadie && simcall->call != SIMCALL_PROCESS_CLEANUP)
    return;
  switch (simcall->call) {
case SIMCALL_HOST_GET_NAME:
      simcall->result.cc = SIMIX_host_get_name((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_ON:
       SIMIX_host_on((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_OFF:
       simcall_HANDLER_host_off(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_PROPERTIES:
      simcall->result.dp = SIMIX_host_get_properties((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_CORE:
      simcall->result.i = SIMIX_host_get_core((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_PROCESS_LIST:
      simcall->result.dp = SIMIX_host_get_process_list((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_SPEED:
      simcall->result.d = SIMIX_host_get_speed((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_AVAILABLE_SPEED:
      simcall->result.d = SIMIX_host_get_available_speed((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_STATE:
      simcall->result.i = SIMIX_host_get_state((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_CURRENT_POWER_PEAK:
      simcall->result.d = SIMIX_host_get_current_power_peak((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_POWER_PEAK_AT:
      simcall->result.d = SIMIX_host_get_power_peak_at((sg_host_t) simcall->args[0].dp, simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_NB_PSTATES:
      simcall->result.i = SIMIX_host_get_nb_pstates((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_WATTMIN_AT:
      simcall->result.d = SIMIX_host_get_wattmin_at((sg_host_t) simcall->args[0].dp, simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_WATTMAX_AT:
      simcall->result.d = SIMIX_host_get_wattmax_at((sg_host_t) simcall->args[0].dp, simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_SET_PSTATE:
       SIMIX_host_set_pstate((sg_host_t) simcall->args[0].dp, simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_PSTATE:
      simcall->result.i = SIMIX_host_get_pstate((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_CONSUMED_ENERGY:
      simcall->result.d = SIMIX_host_get_consumed_energy((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_MOUNTED_STORAGE_LIST:
      simcall->result.dp = SIMIX_host_get_mounted_storage_list((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_ATTACHED_STORAGE_LIST:
      simcall->result.dp = SIMIX_host_get_attached_storage_list((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_GET_PARAMS:
       SIMIX_host_get_params((sg_host_t) simcall->args[0].dp,(vm_params_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_HOST_SET_PARAMS:
       SIMIX_host_set_params((sg_host_t) simcall->args[0].dp,(vm_params_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_CREATE:
      simcall->result.dp = SIMIX_vm_create( simcall->args[0].cc,(sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_START:
       SIMIX_vm_start((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_GET_STATE:
      simcall->result.i = SIMIX_vm_get_state((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_MIGRATE:
       SIMIX_vm_migrate((sg_host_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_GET_PM:
      simcall->result.dp = SIMIX_vm_get_pm((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SET_BOUND:
       SIMIX_vm_set_bound((sg_host_t) simcall->args[0].dp, simcall->args[1].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SET_AFFINITY:
       SIMIX_vm_set_affinity((sg_host_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp, simcall->args[2].ul);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_DESTROY:
       SIMIX_vm_destroy((sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SUSPEND:
       simcall_HANDLER_vm_suspend(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_RESUME:
       simcall_HANDLER_vm_resume(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SHUTDOWN:
       simcall_HANDLER_vm_shutdown(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SAVE:
       simcall_HANDLER_vm_save(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_RESTORE:
       simcall_HANDLER_vm_restore(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_MIGRATEFROM_RESUMETO:
       SIMIX_vm_migratefrom_resumeto((sg_host_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp,(sg_host_t) simcall->args[2].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_CREATE:
      simcall->result.dp = simcall_HANDLER_process_create(simcall ,  simcall->args[0].cc, (xbt_main_func_t) simcall->args[1].fp,  simcall->args[2].dp,  simcall->args[3].cc,  simcall->args[4].d,  simcall->args[5].i, (char**) simcall->args[6].dp, (xbt_dict_t) simcall->args[7].dp,  simcall->args[8].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_KILL:
       simcall_HANDLER_process_kill(simcall , (smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_KILLALL:
       simcall_HANDLER_process_killall(simcall ,  simcall->args[0].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_CLEANUP:
       SIMIX_process_cleanup((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_SUSPEND:
       simcall_HANDLER_process_suspend(simcall , (smx_process_t) simcall->args[0].dp);
       break;  

case SIMCALL_PROCESS_RESUME:
       simcall_HANDLER_process_resume(simcall , (smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_COUNT:
      simcall->result.i = SIMIX_process_count();
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_GET_PID:
      simcall->result.i = SIMIX_process_get_PID((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_GET_PPID:
      simcall->result.i = SIMIX_process_get_PPID((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_GET_DATA:
      simcall->result.dp = SIMIX_process_get_data((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_SET_DATA:
       SIMIX_process_set_data((smx_process_t) simcall->args[0].dp, simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_SET_HOST:
       simcall_HANDLER_process_set_host(simcall , (smx_process_t) simcall->args[0].dp, (sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_GET_HOST:
      simcall->result.dp = SIMIX_process_get_host((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_GET_NAME:
      simcall->result.cc = SIMIX_process_get_name((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_IS_SUSPENDED:
      simcall->result.i = SIMIX_process_is_suspended((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_GET_PROPERTIES:
      simcall->result.dp = SIMIX_process_get_properties((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_JOIN:
       simcall_HANDLER_process_join(simcall , (smx_process_t) simcall->args[0].dp,  simcall->args[1].d);
       break;  

case SIMCALL_PROCESS_SLEEP:
       simcall_HANDLER_process_sleep(simcall ,  simcall->args[0].d);
       break;  

case SIMCALL_PROCESS_EXECUTE:
      simcall->result.dp = simcall_HANDLER_process_execute(simcall ,  simcall->args[0].cc,  simcall->args[1].d,  simcall->args[2].d,  simcall->args[3].d,  simcall->args[4].ul);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_PARALLEL_EXECUTE:
      simcall->result.dp = SIMIX_process_parallel_execute( simcall->args[0].cc, simcall->args[1].i,(sg_host_t*) simcall->args[2].dp,(double*) simcall->args[3].dp,(double*) simcall->args[4].dp, simcall->args[5].d, simcall->args[6].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_DESTROY:
       SIMIX_process_execution_destroy((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_CANCEL:
       SIMIX_process_execution_cancel((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_GET_REMAINS:
      simcall->result.d = SIMIX_process_execution_get_remains((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_GET_STATE:
      simcall->result.i = SIMIX_process_execution_get_state((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_SET_PRIORITY:
       SIMIX_process_execution_set_priority((smx_synchro_t) simcall->args[0].dp, simcall->args[1].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_SET_BOUND:
       SIMIX_process_execution_set_bound((smx_synchro_t) simcall->args[0].dp, simcall->args[1].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_SET_AFFINITY:
       SIMIX_process_execution_set_affinity((smx_synchro_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp, simcall->args[2].ul);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_EXECUTION_WAIT:
       simcall_HANDLER_process_execution_wait(simcall , (smx_synchro_t) simcall->args[0].dp);
       break;  

case SIMCALL_PROCESS_ON_EXIT:
       SIMIX_process_on_exit((smx_process_t) simcall->args[0].dp,(int_f_pvoid_pvoid_t) simcall->args[1].fp, simcall->args[2].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_AUTO_RESTART_SET:
       SIMIX_process_auto_restart_set((smx_process_t) simcall->args[0].dp, simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_RESTART:
      simcall->result.dp = simcall_HANDLER_process_restart(simcall , (smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RDV_CREATE:
      simcall->result.dp = SIMIX_rdv_create( simcall->args[0].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RDV_DESTROY:
       SIMIX_rdv_destroy((smx_rdv_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RDV_COMM_COUNT_BY_HOST:
      simcall->result.ui = SIMIX_rdv_comm_count_by_host((smx_rdv_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RDV_GET_HEAD:
      simcall->result.dp = SIMIX_rdv_get_head((smx_rdv_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RDV_SET_RECEIVER:
       SIMIX_rdv_set_receiver((smx_rdv_t) simcall->args[0].dp,(smx_process_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RDV_GET_RECEIVER:
      simcall->result.dp = SIMIX_rdv_get_receiver((smx_rdv_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_IPROBE:
      simcall->result.dp = simcall_HANDLER_comm_iprobe(simcall , (smx_rdv_t) simcall->args[0].dp,  simcall->args[1].i,  simcall->args[2].i,  simcall->args[3].i, (simix_match_func_t) simcall->args[4].fp,  simcall->args[5].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_SEND:
       simcall_HANDLER_comm_send(simcall , (smx_process_t) simcall->args[0].dp, (smx_rdv_t) simcall->args[1].dp,  simcall->args[2].d,  simcall->args[3].d,  simcall->args[4].dp,  simcall->args[5].sz, (simix_match_func_t) simcall->args[6].fp, (simix_copy_data_func_t) simcall->args[7].fp,  simcall->args[8].dp,  simcall->args[9].d);
       break;  

case SIMCALL_COMM_ISEND:
      simcall->result.dp = simcall_HANDLER_comm_isend(simcall , (smx_process_t) simcall->args[0].dp, (smx_rdv_t) simcall->args[1].dp,  simcall->args[2].d,  simcall->args[3].d,  simcall->args[4].dp,  simcall->args[5].sz, (simix_match_func_t) simcall->args[6].fp, (simix_clean_func_t) simcall->args[7].fp, (simix_copy_data_func_t) simcall->args[8].fp,  simcall->args[9].dp,  simcall->args[10].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_RECV:
       simcall_HANDLER_comm_recv(simcall , (smx_process_t) simcall->args[0].dp, (smx_rdv_t) simcall->args[1].dp,  simcall->args[2].dp, (size_t*) simcall->args[3].dp, (simix_match_func_t) simcall->args[4].fp, (simix_copy_data_func_t) simcall->args[5].fp,  simcall->args[6].dp,  simcall->args[7].d,  simcall->args[8].d);
       break;  

case SIMCALL_COMM_IRECV:
      simcall->result.dp = simcall_HANDLER_comm_irecv(simcall , (smx_process_t) simcall->args[0].dp, (smx_rdv_t) simcall->args[1].dp,  simcall->args[2].dp, (size_t*) simcall->args[3].dp, (simix_match_func_t) simcall->args[4].fp, (simix_copy_data_func_t) simcall->args[5].fp,  simcall->args[6].dp,  simcall->args[7].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_CANCEL:
       SIMIX_comm_cancel((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_WAITANY:
       simcall_HANDLER_comm_waitany(simcall , (xbt_dynar_t) simcall->args[0].dp);
       break;  

case SIMCALL_COMM_WAIT:
       simcall_HANDLER_comm_wait(simcall , (smx_synchro_t) simcall->args[0].dp,  simcall->args[1].d);
       break;  

case SIMCALL_COMM_TEST:
       simcall_HANDLER_comm_test(simcall , (smx_synchro_t) simcall->args[0].dp);
       break;  

case SIMCALL_COMM_TESTANY:
       simcall_HANDLER_comm_testany(simcall , (xbt_dynar_t) simcall->args[0].dp);
       break;  

case SIMCALL_COMM_GET_REMAINS:
      simcall->result.d = SIMIX_comm_get_remains((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_STATE:
      simcall->result.i = SIMIX_comm_get_state((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_SRC_DATA:
      simcall->result.dp = SIMIX_comm_get_src_data((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_DST_DATA:
      simcall->result.dp = SIMIX_comm_get_dst_data((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_SRC_PROC:
      simcall->result.dp = SIMIX_comm_get_src_proc((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_DST_PROC:
      simcall->result.dp = SIMIX_comm_get_dst_proc((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_INIT:
      simcall->result.dp = simcall_HANDLER_mutex_init(simcall );
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_DESTROY:
       SIMIX_mutex_destroy((smx_mutex_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_LOCK:
       simcall_HANDLER_mutex_lock(simcall , (smx_mutex_t) simcall->args[0].dp);
       break;  

case SIMCALL_MUTEX_TRYLOCK:
      simcall->result.i = simcall_HANDLER_mutex_trylock(simcall , (smx_mutex_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_UNLOCK:
       simcall_HANDLER_mutex_unlock(simcall , (smx_mutex_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_INIT:
      simcall->result.dp = SIMIX_cond_init();
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_DESTROY:
       SIMIX_cond_destroy((smx_cond_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_SIGNAL:
       SIMIX_cond_signal((smx_cond_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_WAIT:
       simcall_HANDLER_cond_wait(simcall , (smx_cond_t) simcall->args[0].dp, (smx_mutex_t) simcall->args[1].dp);
       break;  

case SIMCALL_COND_WAIT_TIMEOUT:
       simcall_HANDLER_cond_wait_timeout(simcall , (smx_cond_t) simcall->args[0].dp, (smx_mutex_t) simcall->args[1].dp,  simcall->args[2].d);
       break;  

case SIMCALL_COND_BROADCAST:
       SIMIX_cond_broadcast((smx_cond_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_INIT:
      simcall->result.dp = SIMIX_sem_init( simcall->args[0].ui);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_DESTROY:
       SIMIX_sem_destroy((smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_RELEASE:
       simcall_HANDLER_sem_release(simcall , (smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_WOULD_BLOCK:
      simcall->result.i = simcall_HANDLER_sem_would_block(simcall , (smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_ACQUIRE:
       simcall_HANDLER_sem_acquire(simcall , (smx_sem_t) simcall->args[0].dp);
       break;  

case SIMCALL_SEM_ACQUIRE_TIMEOUT:
       simcall_HANDLER_sem_acquire_timeout(simcall , (smx_sem_t) simcall->args[0].dp,  simcall->args[1].d);
       break;  

case SIMCALL_SEM_GET_CAPACITY:
      simcall->result.i = simcall_HANDLER_sem_get_capacity(simcall , (smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_READ:
       simcall_HANDLER_file_read(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].sgsz, (sg_host_t) simcall->args[2].dp);
       break;  

case SIMCALL_FILE_WRITE:
       simcall_HANDLER_file_write(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].sgsz, (sg_host_t) simcall->args[2].dp);
       break;  

case SIMCALL_FILE_OPEN:
       simcall_HANDLER_file_open(simcall ,  simcall->args[0].cc, (sg_host_t) simcall->args[1].dp);
       break;  

case SIMCALL_FILE_CLOSE:
       simcall_HANDLER_file_close(simcall , (smx_file_t) simcall->args[0].dp, (sg_host_t) simcall->args[1].dp);
       break;  

case SIMCALL_FILE_UNLINK:
      simcall->result.i = SIMIX_file_unlink((smx_file_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_GET_SIZE:
      simcall->result.sgsz = simcall_HANDLER_file_get_size(simcall , (smx_file_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_TELL:
      simcall->result.sgsz = simcall_HANDLER_file_tell(simcall , (smx_file_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_SEEK:
      simcall->result.i = simcall_HANDLER_file_seek(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].sgoff,  simcall->args[2].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_GET_INFO:
      simcall->result.dp = simcall_HANDLER_file_get_info(simcall , (smx_file_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_MOVE:
      simcall->result.i = simcall_HANDLER_file_move(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_FREE_SIZE:
      simcall->result.sgsz = simcall_HANDLER_storage_get_free_size(simcall , (smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_USED_SIZE:
      simcall->result.sgsz = simcall_HANDLER_storage_get_used_size(simcall , (smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_PROPERTIES:
      simcall->result.dp = SIMIX_storage_get_properties((smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_CONTENT:
      simcall->result.dp = SIMIX_storage_get_content((smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_ASR_GET_PROPERTIES:
      simcall->result.dp = simcall_HANDLER_asr_get_properties(simcall ,  simcall->args[0].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MC_RANDOM:
      simcall->result.i = simcall_HANDLER_mc_random(simcall ,  simcall->args[0].i,  simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SET_CATEGORY:
       SIMIX_set_category((smx_synchro_t) simcall->args[0].dp, simcall->args[1].cc);
      SIMIX_simcall_answer(simcall);
      break;  

#ifdef HAVE_LATENCY_BOUND_TRACKING
case SIMCALL_COMM_IS_LATENCY_BOUNDED:
      simcall->result.i = SIMIX_comm_is_latency_bounded((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

#endif

#ifdef HAVE_MC
case SIMCALL_MC_SNAPSHOT:
      simcall->result.dp = simcall_HANDLER_mc_snapshot(simcall );
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MC_COMPARE_SNAPSHOTS:
      simcall->result.i = simcall_HANDLER_mc_compare_snapshots(simcall , (mc_snapshot_t) simcall->args[0].dp, (mc_snapshot_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

#endif
    case NUM_SIMCALLS:
      break;
    case SIMCALL_NONE:
      THROWF(arg_error,0,"Asked to do the noop syscall on %s@%s",
          SIMIX_process_get_name(simcall->issuer),
          SIMIX_host_get_name(SIMIX_process_get_host(simcall->issuer))
          );
      break;

  }
}
