### define source packages

set(EXTRA_DIST
  src/bindings/java/MANIFEST.MF.in
  src/include/instr/instr_interface.h
  src/include/mc/datatypes.h
  src/include/mc/mc.h
  src/mc/mc_mmu.h
  src/mc/PageStore.hpp
  src/mc/mc_record.h
  src/include/simgrid/platf_interface.h
  src/include/simgrid/sg_config.h
  src/include/smpi/smpi_interface.h
  src/include/surf/datatypes.h
  src/include/surf/maxmin.h
  src/include/surf/random_mgr.h
  src/include/surf/surf.h
  src/include/surf/surfxml_parse_values.h
  src/include/surf/trace_mgr.h
  src/include/xbt/win32_ucontext.h
  src/include/xbt/wine_dbghelp.h
  src/msg/msg_mailbox.h
  src/msg/msg_private.h
  src/portable.h
  src/probes.tp
  src/simdag/dax.dtd
  src/simdag/dax_dtd.c
  src/simdag/dax_dtd.h
  src/simdag/private.h
  src/simix/simcalls.in
  src/simix/simcalls.py
  src/simix/popping_private.h
  src/simix/popping_bodies.c
  src/simix/popping_generated.c
  src/simix/popping_enum.h
  src/simix/popping_accessors.h
  src/simix/smx_host_private.h
  src/simix/smx_io_private.h
  src/simix/smx_network_private.h
  src/simix/smx_private.h
  src/simix/smx_process_private.h
  src/simix/smx_synchro_private.h
  src/smpi/README
  src/smpi/colls/coll_tuned_topo.h
  src/smpi/colls/colls.h
  src/smpi/colls/colls_private.h
  src/smpi/colls/smpi_mvapich2_selector_stampede.h
  src/smpi/private.h
  src/smpi/smpi_mpi_dt_private.h
  src/surf/cpu_cas01.hpp
  src/surf/cpu_interface.hpp
  src/surf/cpu_ti.hpp
  src/surf/maxmin_private.hpp
  src/surf/network_cm02.hpp
  src/surf/network_constant.hpp
  src/surf/network_interface.hpp
  src/surf/network_ns3.hpp
  src/surf/network_smpi.hpp
  src/surf/network_ib.hpp
  src/surf/ns3/my-point-to-point-helper.h
  src/surf/ns3/ns3_interface.h
  src/surf/ns3/ns3_simulator.h
  src/surf/ns3/red-queue.h
  src/surf/platf_generator_private.h
  src/surf/plugins/energy.hpp
  src/surf/simgrid.dtd
  src/surf/simgrid_dtd.c
  src/surf/storage_interface.hpp
  src/surf/storage_n11.hpp
  src/surf/surf_interface.hpp
  src/surf/surf_private.h
  src/surf/surf_routing.hpp
  src/surf/surf_routing_cluster.hpp
  src/surf/surf_routing_cluster_fat_tree.hpp
  src/surf/surf_routing_cluster_torus.hpp
  src/surf/surf_routing_dijkstra.hpp
  src/surf/surf_routing_floyd.hpp
  src/surf/surf_routing_full.hpp
  src/surf/surf_routing_generic.hpp
  src/surf/surf_routing_none.hpp
  src/surf/surf_routing_private.hpp
  src/surf/surf_routing_vivaldi.hpp
  src/surf/surfxml_parse.c
  src/surf/trace_mgr_private.h
  src/surf/vm_hl13.hpp
  src/surf/vm_interface.hpp
  src/surf/host_clm03.hpp
  src/surf/host_interface.hpp
  src/surf/host_ptask_L07.hpp
  src/xbt/automaton/automaton_lexer.yy.c
  src/xbt/automaton/parserPromela.lex
  src/xbt/automaton/parserPromela.tab.cacc
  src/xbt/automaton/parserPromela.tab.hacc
  src/xbt/automaton/parserPromela.yacc
  src/xbt/backtrace_dummy.c
  src/xbt/backtrace_linux.c
  src/xbt/backtrace_windows.c
  src/xbt/dict_private.h
  src/xbt/ex_interface.h
  src/xbt/fifo_private.h
  src/xbt/graph_private.h
  src/xbt/graphxml.c
  src/xbt/graphxml.dtd
  src/xbt/graphxml_parse.c
  src/xbt/heap_private.h
  src/xbt/log_private.h
  src/xbt/mallocator_private.h
  src/xbt/mmalloc/mfree.c
  src/xbt/mmalloc/mm.c
  src/xbt/mmalloc/mm_legacy.c
  src/xbt/mmalloc/mm_module.c
  src/xbt/mmalloc/mmalloc.c
  src/xbt/mmalloc/mmalloc.info
  src/xbt/mmalloc/mmalloc.texi
  src/xbt/mmalloc/mmorecore.c
  src/xbt/mmalloc/mmprivate.h
  src/xbt/mmalloc/mmtrace.awk
  src/xbt/mmalloc/mrealloc.c
  src/xbt/probes.h
  src/xbt/setset_private.h
  src/xbt/win32_ucontext.c
  tools/tesh/generate_tesh
  examples/smpi/mc/only_send_deterministic.tesh
  examples/smpi/mc/non_deterministic.tesh
  )

set(SMPI_SRC
  src/smpi/colls/allgather-2dmesh.c
  src/smpi/colls/allgather-3dmesh.c
  src/smpi/colls/allgather-GB.c
  src/smpi/colls/allgather-NTSLR-NB.c
  src/smpi/colls/allgather-NTSLR.c
  src/smpi/colls/allgather-SMP-NTS.c
  src/smpi/colls/allgather-bruck.c
  src/smpi/colls/allgather-loosely-lr.c
  src/smpi/colls/allgather-ompi-neighborexchange.c
  src/smpi/colls/allgather-pair.c
  src/smpi/colls/allgather-mvapich-smp.c
  src/smpi/colls/allgather-rdb.c
  src/smpi/colls/allgather-rhv.c
  src/smpi/colls/allgather-ring.c
  src/smpi/colls/allgather-smp-simple.c
  src/smpi/colls/allgather-spreading-simple.c
  src/smpi/colls/allgatherv-GB.c
  src/smpi/colls/allgatherv-mpich-rdb.c
  src/smpi/colls/allgatherv-mpich-ring.c
  src/smpi/colls/allgatherv-ompi-bruck.c
  src/smpi/colls/allgatherv-ompi-neighborexchange.c
  src/smpi/colls/allgatherv-pair.c
  src/smpi/colls/allgatherv-ring.c
  src/smpi/colls/allreduce-lr.c
  src/smpi/colls/allreduce-ompi-ring-segmented.c
  src/smpi/colls/allreduce-rab-rdb.c
  src/smpi/colls/allreduce-rab1.c
  src/smpi/colls/allreduce-rab2.c
  src/smpi/colls/allreduce-rdb.c
  src/smpi/colls/allreduce-redbcast.c
  src/smpi/colls/allreduce-smp-binomial-pipeline.c
  src/smpi/colls/allreduce-smp-binomial.c
  src/smpi/colls/allreduce-smp-rdb.c
  src/smpi/colls/allreduce-smp-rsag-lr.c
  src/smpi/colls/allreduce-smp-rsag-rab.c
  src/smpi/colls/allreduce-smp-rsag.c
  src/smpi/colls/allreduce-mvapich-rs.c
  src/smpi/colls/allreduce-mvapich-two-level.c
  src/smpi/colls/alltoall-2dmesh.c
  src/smpi/colls/alltoall-3dmesh.c
#  src/smpi/colls/alltoall-bruck.c
  src/smpi/colls/alltoall-pair-light-barrier.c
  src/smpi/colls/alltoall-pair-mpi-barrier.c
  src/smpi/colls/alltoall-pair-one-barrier.c
  src/smpi/colls/alltoall-pair.c
  src/smpi/colls/alltoall-rdb.c
  src/smpi/colls/alltoall-ring-light-barrier.c
  src/smpi/colls/alltoall-ring-mpi-barrier.c
  src/smpi/colls/alltoall-ring-one-barrier.c
  src/smpi/colls/alltoall-ring.c
  src/smpi/colls/alltoall-mvapich-scatter-dest.c
  src/smpi/colls/alltoallv-bruck.c
  src/smpi/colls/alltoallv-ompi-basic-linear.c
  src/smpi/colls/alltoallv-pair-light-barrier.c
  src/smpi/colls/alltoallv-pair-mpi-barrier.c
  src/smpi/colls/alltoallv-pair-one-barrier.c
  src/smpi/colls/alltoallv-pair.c
  src/smpi/colls/alltoallv-ring-light-barrier.c
  src/smpi/colls/alltoallv-ring-mpi-barrier.c
  src/smpi/colls/alltoallv-ring-one-barrier.c
  src/smpi/colls/alltoallv-ring.c
  src/smpi/colls/barrier-ompi.c
  src/smpi/colls/barrier-mvapich2-pair.c
  src/smpi/colls/bcast-NTSB.c
  src/smpi/colls/bcast-NTSL-Isend.c
  src/smpi/colls/bcast-NTSL.c
  src/smpi/colls/bcast-SMP-binary.c
  src/smpi/colls/bcast-SMP-binomial.c
  src/smpi/colls/bcast-SMP-linear.c
  src/smpi/colls/bcast-arrival-pattern-aware-wait.c
  src/smpi/colls/bcast-arrival-pattern-aware.c
  src/smpi/colls/bcast-arrival-scatter.c
  src/smpi/colls/bcast-binomial-tree.c
  src/smpi/colls/bcast-flattree-pipeline.c
  src/smpi/colls/bcast-flattree.c
  src/smpi/colls/bcast-ompi-pipeline.c
  src/smpi/colls/bcast-ompi-split-bintree.c
  src/smpi/colls/bcast-mvapich-smp.c
  src/smpi/colls/bcast-scatter-LR-allgather.c
  src/smpi/colls/bcast-scatter-rdb-allgather.c
  src/smpi/colls/coll_tuned_topo.c
  src/smpi/colls/colls_global.c
  src/smpi/colls/gather-ompi.c
  src/smpi/colls/gather-mvapich.c
  src/smpi/colls/reduce-NTSL.c
  src/smpi/colls/reduce-arrival-pattern-aware.c
  src/smpi/colls/reduce-binomial.c
  src/smpi/colls/reduce-flat-tree.c
  src/smpi/colls/reduce-ompi.c
  src/smpi/colls/reduce-scatter-gather.c
  src/smpi/colls/reduce_scatter-mpich.c
  src/smpi/colls/reduce_scatter-ompi.c
  src/smpi/colls/reduce-mvapich-knomial.c
  src/smpi/colls/reduce-mvapich-two-level.c
  src/smpi/colls/reduce-rab.c
  src/smpi/colls/scatter-ompi.c
  src/smpi/colls/scatter-mvapich-two-level.c
  src/smpi/colls/smpi_automatic_selector.c
  src/smpi/colls/smpi_mpich_selector.c
  src/smpi/colls/smpi_intel_mpi_selector.c
  src/smpi/colls/smpi_openmpi_selector.c
  src/smpi/colls/smpi_mvapich2_selector.c
  src/smpi/instr_smpi.c
  src/smpi/smpi_base.c
  src/smpi/smpi_bench.c
  src/smpi/smpi_c99.c
  src/smpi/smpi_coll.c
  src/smpi/smpi_comm.c
  src/smpi/smpi_deployment.c
  src/smpi/smpi_dvfs.c
  src/smpi/smpi_global.c
  src/smpi/smpi_group.c
  src/smpi/smpi_mpi.c
  src/smpi/smpi_mpi_dt.c
  src/smpi/smpi_pmpi.c
  src/smpi/smpi_replay.c
  src/smpi/smpi_rma.c
  src/smpi/smpi_topo.c
  src/smpi/smpi_f77.c
  )

set(XBT_SRC
  src/xbt/RngStream.c
  src/xbt/automaton/automaton.c
  src/xbt/automaton/automatonparse_promela.c
  src/xbt/config.c
  src/xbt/cunit.c
  src/xbt/dict.c
  src/xbt/dict_cursor.c
  src/xbt/dict_elm.c
  src/xbt/dict_multi.c
  src/xbt/dynar.c
  src/xbt/ex.c
  src/xbt/fifo.c
  src/xbt/graph.c
  src/xbt/graphxml_parse.c
  src/xbt/heap.c
  src/xbt/lib.c
  src/xbt/log.c
  src/xbt/mallocator.c
  src/xbt/parmap.cpp
  src/xbt/set.c
  src/xbt/setset.c
  src/xbt/snprintf.c
  src/xbt/swag.c
  src/xbt/xbt_log_appender_file.c
  src/xbt/xbt_log_layout_format.c
  src/xbt/xbt_log_layout_simple.c
  src/xbt/xbt_main.c
  src/xbt/xbt_matrix.c
  src/xbt/xbt_os_time.c
  src/xbt/xbt_os_file.c
  src/xbt/xbt_peer.c
  src/xbt/xbt_queue.c
  src/xbt/xbt_replay.c
  src/xbt/xbt_sg_synchro.c
  src/xbt/xbt_sha.c
  src/xbt/xbt_str.c
  src/xbt/xbt_strbuff.c
  src/xbt/xbt_virtu.c
  src/xbt_modinter.h
  )

if(HAVE_MMALLOC)
  set(XBT_SRC
    ${XBT_SRC}
    src/xbt/mmalloc/mm.c
    )
endif()

set(NS3_SRC
  src/surf/network_ns3.cpp
  src/surf/ns3/my-point-to-point-helper.cc
  src/surf/ns3/ns3_interface.cc
  src/surf/ns3/ns3_simulator.cc
  src/surf/ns3/red-queue.cc
  )

set(SURF_SRC
  src/surf/cpu_cas01.cpp
  src/surf/cpu_interface.cpp
  src/surf/cpu_ti.cpp
  src/surf/fair_bottleneck.cpp
  src/surf/instr_routing.c
  src/surf/instr_surf.c
  src/surf/lagrange.cpp
  src/surf/maxmin.cpp
  src/surf/network_cm02.cpp
  src/surf/network_constant.cpp
  src/surf/network_interface.cpp
  src/surf/network_smpi.cpp
  src/surf/network_ib.cpp
  src/surf/platf_generator.c
  src/surf/plugins/energy.cpp
  src/surf/random_mgr.c
  src/surf/sg_platf.c
  src/surf/storage_interface.cpp
  src/surf/storage_n11.cpp
  src/surf/surf_c_bindings.cpp
  src/surf/surf_interface.cpp
  src/surf/surf_routing.cpp
  src/surf/surf_routing_cluster.cpp
  src/surf/surf_routing_cluster_fat_tree.cpp
  src/surf/surf_routing_cluster_torus.cpp
  src/surf/surf_routing_dijkstra.cpp
  src/surf/surf_routing_floyd.cpp
  src/surf/surf_routing_full.cpp
  src/surf/surf_routing_generic.cpp
  src/surf/surf_routing_none.cpp
  src/surf/surf_routing_vivaldi.cpp
  src/surf/surfxml_parse.c
  src/surf/surfxml_parseplatf.c
  src/surf/trace_mgr.c
  src/surf/vm_hl13.cpp
  src/surf/vm_interface.cpp
  src/surf/host_clm03.cpp
  src/surf/host_interface.cpp
  src/surf/host_ptask_L07.cpp
  src/xbt/xbt_sg_stubs.c
  )

set(SIMIX_GENERATED_SRC
  src/simix/popping_generated.c
  )
set(SIMIX_SRC
  src/simix/libsmx.c
  src/simix/smx_context.c
  src/simix/smx_context_base.c
  src/simix/smx_deployment.c
  src/simix/smx_environment.c
  src/simix/smx_global.c
  src/simix/smx_host.c
  src/simix/smx_io.c
  src/simix/smx_network.c
  src/simix/smx_process.c
  src/simix/smx_synchro.c
  src/simix/smx_vm.c
  src/simix/popping.c

  ${SIMIX_GENERATED_SRC}
  )

# Don't try to compile our inline assembly with MSVC
if (MSVC)
  set(EXTRA_DIST
      ${EXTRA_DIST}
      src/simix/smx_context_raw.c)
else()
  set(SIMIX_SRC
      ${SIMIX_SRC}
      src/simix/smx_context_raw.c)
endif()

# Boost context may not be available
if (HAVE_BOOST_CONTEXT)
  set(SIMIX_SRC
      ${SIMIX_SRC}
      src/simix/smx_context_boost.cpp)
else()
  set(EXTRA_DIST
      ${EXTRA_DIST}
      src/simix/smx_context_boost.cpp)
endif()

set(SIMGRID_SRC
  src/simgrid/sg_config.c
  src/simgrid/host.cpp
  src/simgrid/util.hpp
  )

set(MSG_SRC
  src/msg/instr_msg_process.c
  src/msg/instr_msg_task.c
  src/msg/instr_msg_vm.c
  src/msg/msg_actions.c
  src/msg/msg_deployment.c
  src/msg/msg_environment.c
  src/msg/msg_global.c
  src/msg/msg_gos.c
  src/msg/msg_host.c
  src/msg/msg_io.c
  src/msg/msg_mailbox.c
  src/msg/msg_process.c
  src/msg/msg_synchro.c
  src/msg/msg_task.c
  src/msg/msg_vm.c
  )

set(SIMDAG_SRC
  src/simdag/instr_sd_task.c
  src/simdag/sd_daxloader.c
  src/simdag/sd_global.c
  src/simdag/sd_link.c
  src/simdag/sd_task.c
  src/simdag/sd_workstation.c
  )
if(HAVE_GRAPHVIZ)
  set(SIMDAG_SRC
    ${SIMDAG_SRC} src/simdag/sd_dotloader.c
    )
else()
  set(EXTRA_DIST
    ${EXTRA_DIST} src/simdag/sd_dotloader.c
    )
endif()

set(BINDINGS_SRC
  src/bindings/bindings_global.c
  src/bindings/lua/lua_private.h
  src/bindings/lua/lua_state_cloner.h
  src/bindings/lua/lua_utils.h
  src/bindings/lua/simgrid_lua.h
  )

set(JSURF_SWIG_SRC
  src/bindings/java/surf.i
)

set(JSURF_SWIG_SRC_EXTRA
  src/bindings/java/surfdoc.i
)

set(JSURF_JAVA_C_SRC
  src/bindings/java/surf_swig.cpp
  src/bindings/java/surf_swig.hpp
)

set(JSURF_JAVA_GENERATED_SRC
  src/bindings/java/org/simgrid/surf/Action.java
  src/bindings/java/org/simgrid/surf/ActionList.java
  src/bindings/java/org/simgrid/surf/ActionState.java
  src/bindings/java/org/simgrid/surf/Cpu.java
  src/bindings/java/org/simgrid/surf/CpuAction.java
  src/bindings/java/org/simgrid/surf/CpuModel.java
  src/bindings/java/org/simgrid/surf/LmmConstraint.java
  src/bindings/java/org/simgrid/surf/LmmVariable.java
  src/bindings/java/org/simgrid/surf/Model.java
  src/bindings/java/org/simgrid/surf/NetworkAction.java
  src/bindings/java/org/simgrid/surf/Link.java
  src/bindings/java/org/simgrid/surf/Plugin.java
  src/bindings/java/org/simgrid/surf/Resource.java
  src/bindings/java/org/simgrid/surf/ResourceState.java
  src/bindings/java/org/simgrid/surf/RoutingEdge.java
  src/bindings/java/org/simgrid/surf/Surf.java
  src/bindings/java/org/simgrid/surf/SurfJNI.java
  src/bindings/java/org/simgrid/surf/TmgrTrace.java
  src/bindings/java/org/simgrid/surf/TmgrTraceEvent.java
  src/bindings/java/org/simgrid/surf/XbtDict.java
)

set(JMSG_C_SRC
  src/bindings/java/jmsg.c
  src/bindings/java/jmsg.h
  src/bindings/java/jmsg_as.c
  src/bindings/java/jmsg_as.h
  src/bindings/java/jmsg_comm.c
  src/bindings/java/jmsg_comm.h
  src/bindings/java/jmsg_file.c
  src/bindings/java/jmsg_file.h
  src/bindings/java/jmsg_host.c
  src/bindings/java/jmsg_host.h
  src/bindings/java/jmsg_process.c
  src/bindings/java/jmsg_process.h
  src/bindings/java/jmsg_rngstream.c
  src/bindings/java/jmsg_rngstream.h
  src/bindings/java/jmsg_synchro.c
  src/bindings/java/jmsg_synchro.h
  src/bindings/java/jmsg_task.c
  src/bindings/java/jmsg_task.h
  src/bindings/java/jmsg_vm.c
  src/bindings/java/jmsg_vm.h
  src/bindings/java/jxbt_utilities.c
  src/bindings/java/jxbt_utilities.h
  src/bindings/java/smx_context_cojava.c
  src/bindings/java/smx_context_cojava.h
  src/bindings/java/smx_context_java.c
  src/bindings/java/smx_context_java.h
  src/bindings/java/jmsg_storage.c
  src/bindings/java/jmsg_storage.h
)

set(JSURF_C_SRC
  src/bindings/java/org/simgrid/surf/surfJAVA_wrap.cxx
  src/bindings/java/org/simgrid/surf/surfJAVA_wrap.h
  ${JSURF_JAVA_C_SRC}
)

set(JMSG_JAVA_SRC
  src/bindings/java/org/simgrid/NativeLib.java
  src/bindings/java/org/simgrid/msg/As.java
  src/bindings/java/org/simgrid/msg/Comm.java
  src/bindings/java/org/simgrid/msg/File.java
  src/bindings/java/org/simgrid/msg/Host.java
  src/bindings/java/org/simgrid/msg/HostFailureException.java
  src/bindings/java/org/simgrid/msg/HostNotFoundException.java
  src/bindings/java/org/simgrid/msg/JniException.java
  src/bindings/java/org/simgrid/msg/Msg.java
  src/bindings/java/org/simgrid/msg/MsgException.java
  src/bindings/java/org/simgrid/msg/Mutex.java
  src/bindings/java/org/simgrid/msg/NativeException.java
  src/bindings/java/org/simgrid/msg/Process.java
  src/bindings/java/org/simgrid/msg/ProcessKilledError.java
  src/bindings/java/org/simgrid/msg/ProcessNotFoundException.java
  src/bindings/java/org/simgrid/msg/RngStream.java
  src/bindings/java/org/simgrid/msg/Semaphore.java
  src/bindings/java/org/simgrid/msg/Storage.java
  src/bindings/java/org/simgrid/msg/StorageNotFoundException.java
  src/bindings/java/org/simgrid/msg/Task.java
  src/bindings/java/org/simgrid/msg/TaskCancelledException.java
  src/bindings/java/org/simgrid/msg/TimeoutException.java
  src/bindings/java/org/simgrid/msg/TransferFailureException.java
  src/bindings/java/org/simgrid/msg/VM.java
  ${JSURF_JAVA_GENERATED_SRC}
)

set(JTRACE_C_SRC
  src/bindings/java/jtrace.c
  src/bindings/java/jtrace.h
)

set(JTRACE_JAVA_SRC
  src/bindings/java/org/simgrid/trace/Trace.java
)

list(APPEND JMSG_C_SRC ${JTRACE_C_SRC})
list(APPEND JMSG_JAVA_SRC ${JTRACE_JAVA_SRC})

set(LUA_SRC
  src/bindings/lua/lua_comm.c
  src/bindings/lua/lua_host.c
  src/bindings/lua/lua_platf.c
  src/bindings/lua/lua_process.c
  src/bindings/lua/lua_state_cloner.c
  src/bindings/lua/lua_task.c
  src/bindings/lua/lua_utils.c
  src/bindings/lua/simgrid_lua.c
  )

set(TRACING_SRC
  src/instr/instr_TI_trace.c
  src/instr/instr_config.c
  src/instr/instr_interface.c
  src/instr/instr_paje_containers.c
  src/instr/instr_paje_header.c
  src/instr/instr_paje_trace.c
  src/instr/instr_paje_types.c
  src/instr/instr_paje_values.c
  src/instr/instr_private.h
  src/instr/instr_resource_utilization.c
  src/instr/instr_trace.c
  )

set(JEDULE_SRC
  include/simgrid/jedule/jedule_events.h
  include/simgrid/jedule/jedule_output.h
  include/simgrid/jedule/jedule_platform.h
  include/simgrid/jedule/jedule_sd_binding.h
  src/instr/jedule/jedule_events.c
  src/instr/jedule/jedule_output.c
  src/instr/jedule/jedule_platform.c
  src/instr/jedule/jedule_sd_binding.c
  )

set(MC_SRC_BASE
  src/mc/mc_base.cpp
  src/mc/mc_base.h
  src/mc/mc_record.h
  src/mc/mc_replay.h
  src/mc/mc_record.cpp
  src/mc/mc_config.cpp
  src/mc/mc_global.cpp
  )

set(MC_SRC
  src/mc/AddressSpace.hpp
  src/mc/AddressSpace.cpp
  src/mc/Frame.hpp
  src/mc/ModelChecker.hpp
  src/mc/ModelChecker.cpp
  src/mc/ObjectInformation.hpp
  src/mc/ObjectInformation.cpp
  src/mc/PageStore.hpp
  src/mc/PageStore.cpp
  src/mc/RegionSnapshot.cpp
  src/mc/RegionSnapshot.hpp
  src/mc/Type.hpp
  src/mc/Variable.cpp
  src/mc/Variable.hpp

  src/mc/mc_forward.h
  src/mc/mc_forward.hpp
  src/mc/Process.hpp
  src/mc/Process.cpp
  src/mc/mc_unw.h
  src/mc/mc_unw.cpp
  src/mc/mc_unw_vmread.cpp
  src/mc/mc_mmalloc.h
  src/mc/mc_object_info.h
  src/mc/mc_checkpoint.cpp
  src/mc/mc_snapshot.h
  src/mc/mc_snapshot.cpp
  src/mc/mc_page_snapshot.cpp
  src/mc/mc_comm_pattern.h
  src/mc/mc_comm_pattern.cpp
  src/mc/mc_comm_determinism.cpp
  src/mc/mc_compare.cpp
  src/mc/mc_diff.cpp
  src/mc/mc_dwarf.hpp
  src/mc/mc_dwarf.cpp
  src/mc/mc_dwarf_attrnames.cpp
  src/mc/mc_dwarf_expression.cpp
  src/mc/mc_dwarf_tagnames.cpp
  src/mc/mc_hash.hpp
  src/mc/mc_hash.cpp
  src/mc/mc_ignore.cpp
  src/mc/mcer_ignore.cpp
  src/mc/mcer_ignore.h
  src/mc/mc_ignore.h
  src/mc/mc_liveness.h
  src/mc/mc_location.h
  src/mc/mc_liveness.cpp
  src/mc/mc_record.cpp
  src/mc/mc_member.cpp
  src/mc/mc_memory.cpp
  src/mc/mc_pair.cpp
  src/mc/mc_private.h
  src/mc/mc_request.h
  src/mc/mc_request.cpp
  src/mc/mc_safety.h
  src/mc/mc_safety.cpp
  src/mc/mc_state.h
  src/mc/mc_state.cpp
  src/mc/mc_visited.cpp
  src/mc/mc_memory_map.h
  src/mc/memory_map.cpp
  src/mc/mc_client.cpp
  src/mc/mc_client_api.cpp
  src/mc/mc_client.h
  src/mc/mc_protocol.h
  src/mc/mc_protocol.cpp
  src/mc/mc_server.cpp
  src/mc/mc_server.h
  src/mc/mc_smx.h
  src/mc/mc_smx.cpp
  src/mc/mc_xbt.hpp
  src/mc/mc_xbt.cpp
  src/mc/mc_exit.h
  )

set(MC_SIMGRID_MC_SRC
  src/mc/simgrid_mc.cpp)

set(headers_to_install
  include/msg/msg.h
  include/msg/datatypes.h
  include/simdag/simdag.h
  include/simdag/datatypes.h
  
  include/simgrid/instr.h
  include/simgrid/msg.h
  include/simgrid/simdag.h
  include/simgrid.h
  include/simgrid/datatypes.h
  include/simgrid/modelchecker.h
  include/simgrid/platf.h
  include/simgrid/platf_generator.h
  include/simgrid/plugins.h
  include/simgrid/simix.h
  include/simgrid/host.h
  include/simgrid/link.h
  include/smpi/mpi.h
  include/smpi/smpi.h
  include/smpi/smpi_cocci.h
  include/smpi/smpi_main.h
  include/surf/simgrid_dtd.h
  include/surf/surf_routing.h
  include/surf/surfxml_parse.h
  include/xbt.h
  include/xbt/RngStream.h
  include/xbt/asserts.h
  include/xbt/automaton.h
  include/xbt/automaton.hpp
  include/xbt/base.h
  include/xbt/config.h
  include/xbt/cunit.h
  include/xbt/dict.h
  include/xbt/dynar.h
  include/xbt/ex.h
  include/xbt/fifo.h
  include/xbt/file.h
  include/xbt/function_types.h
  include/xbt/graph.h
  include/xbt/graphxml.h
  include/xbt/graphxml_parse.h
  include/xbt/hash.h
  include/xbt/heap.h
  include/xbt/lib.h
  include/xbt/log.h
  include/xbt/mallocator.h
  include/xbt/matrix.h
  include/xbt/misc.h
  include/xbt/mmalloc.h
  include/xbt/module.h
  include/xbt/parmap.h
  include/xbt/peer.h
  include/xbt/queue.h
  include/xbt/replay.h
  include/xbt/set.h
  include/xbt/setset.h
  include/xbt/str.h
  include/xbt/strbuff.h
  include/xbt/swag.h
  include/xbt/synchro_core.h
  include/xbt/sysdep.h
  include/xbt/virtu.h
  include/xbt/xbt_os_thread.h
  include/xbt/xbt_os_time.h
  )
set(source_of_generated_headers
  include/simgrid_config.h.in
  include/smpi/mpif.h.in
  src/context_sysv_config.h.in)

### depend of some variables setted upper
# -->CONTEXT_THREADS CONTEXT_UCONTEXT
if(${CONTEXT_THREADS}) #pthread
  set(SURF_SRC
    ${SURF_SRC}
    src/simix/smx_context_thread.c
    src/xbt/xbt_os_thread.c
    )
else() # NOT pthread
  set(EXTRA_DIST
    ${EXTRA_DIST}
    src/simix/smx_context_thread.c
    src/xbt/xbt_os_thread.c
    )
endif()

if(${CONTEXT_UCONTEXT}) #ucontext
  set(SURF_SRC
    ${SURF_SRC}
    src/simix/smx_context_sysv.c
    )
else() # NOT ucontext
  set(EXTRA_DIST
    ${EXTRA_DIST}
    src/simix/smx_context_sysv.c
    )
endif()

### Simgrid Lib sources
set(simgrid_sources
  ${BINDINGS_SRC}
  ${MSG_SRC}
  ${SIMDAG_SRC}
  ${SIMGRID_SRC}
  ${SIMIX_SRC}
  ${SURF_SRC}
  ${XBT_SRC}
  )

if(${HAVE_JEDULE})
  set(simgrid_sources
    ${simgrid_sources}
    ${JEDULE_SRC}
    )
else()
  set(EXTRA_DIST
    ${EXTRA_DIST}
    ${JEDULE_SRC}
    )
endif()

if(enable_smpi)
  set(simgrid_sources
    ${simgrid_sources}
    ${SMPI_SRC}
    )
endif()

set(simgrid_sources
    ${simgrid_sources}
    ${TRACING_SRC}
    )

set(simgrid_sources
  ${simgrid_sources}
  ${MC_SRC_BASE}
  )

if(HAVE_MC)
  set(simgrid_sources
    ${simgrid_sources}
    ${MC_SRC}
    )
endif()

if(HAVE_NS3)
  set(simgrid_sources
    ${simgrid_sources}
    ${NS3_SRC}
    )
endif()

# WINDOWS
if(WIN32)
  set(simgrid_sources
    ${simgrid_sources}
    src/simix/smx_context_thread.c
    src/xbt/win32_ucontext.c
    src/xbt/xbt_os_thread.c
    )
endif()

if(${HAVE_LUA})
  set(simgrid_sources
    ${simgrid_sources}
    ${LUA_SRC}
    )
else()
  set(EXTRA_DIST
    ${EXTRA_DIST}
    ${LUA_SRC}
    )
endif()

set(DOC_SOURCES
  doc/Doxyfile.in
  doc/Layout.xml
  doc/sg_thread_model.fig
  doc/simix.fig
  doc/surf_nutshell.fig
  doc/surf++.png
  doc/surf++.pdf
  doc/surf++.graphml
  doc/surf++.uml
  doc/triva-graph_configuration.png
  doc/triva-graph_configuration.svg
  doc/triva-graph_visualization.png
  doc/triva-graph_visualization.svg
  doc/triva-time_interval.png
  doc/triva-time_interval.svg

  doc/HelloWorld/CMakeLists.txt
  doc/HelloWorld/HelloWorld.c
  doc/HelloWorld/README

  doc/doxygen/FAQ.doc
  doc/doxygen/advanced.doc
  doc/doxygen/bindings.doc
  doc/doxygen/contributing.doc
  doc/doxygen/deployment.doc
  doc/doxygen/footer.html
  doc/doxygen/getting_started.doc
  doc/doxygen/getting_started_index.doc
  doc/doxygen/header.html
  doc/doxygen/help.doc
  doc/doxygen/index.doc
  doc/doxygen/inside_ci.doc
  doc/doxygen/inside_cmake.doc
  doc/doxygen/inside_doxygen.doc
  doc/doxygen/inside_extending.doc
  doc/doxygen/inside_release.doc
  doc/doxygen/install.doc
  doc/doxygen/internals.doc
  doc/doxygen/introduction.doc
  doc/doxygen/module-msg.doc
  doc/doxygen/module-sd.doc
  doc/doxygen/module-simix.doc
  doc/doxygen/module-smpi.doc
  doc/doxygen/module-surf.doc
  doc/doxygen/module-trace.doc
  doc/doxygen/module-xbt.doc
  doc/doxygen/modules.doc
  doc/doxygen/options.doc
  doc/doxygen/platform.doc
  doc/doxygen/pls.doc
  doc/doxygen/stylesheet.css
  doc/doxygen/tracing.doc
  doc/doxygen/examples.doc

  doc/manpage/smpicc.1
  doc/manpage/smpicxx.1
  doc/manpage/smpif90.1
  doc/manpage/smpiff.1
  doc/manpage/smpirun.1

  doc/msg-tuto-src/deployment0.xml
  doc/msg-tuto-src/deployment1.xml
  doc/msg-tuto-src/deployment2.xml
  doc/msg-tuto-src/deployment3.xml
  doc/msg-tuto-src/deployment_general.xml
  doc/msg-tuto-src/masterworker0.c
  doc/msg-tuto-src/masterworker1.c
  doc/msg-tuto-src/masterworker2.c
  doc/msg-tuto-src/masterworker3.c
  doc/msg-tuto-src/masterworker4.c
  doc/msg-tuto-src/platforms/cloud.xml
  doc/msg-tuto-src/platforms/g5k.xml
  doc/msg-tuto-src/platforms/griffon.xml
  doc/msg-tuto-src/platforms/peers.xml
  doc/msg-tuto-src/platforms/platform.xml

  CITATION.bib
  )

set(DOC_FIGS
  ${CMAKE_HOME_DIRECTORY}/doc/shared/fig/simgrid_modules.fig
  ${CMAKE_HOME_DIRECTORY}/doc/shared/fig/simgrid_modules2.fig
  )

set(DOC_TOOLS
  tools/doxygen/fig2dev_postprocessor.pl
  tools/doxygen/index_create.pl
  tools/doxygen/xbt_log_extract_hierarchy.pl
  tools/doxygen/list_routing_models_examples.sh
  )

# these files get copied automatically to the html documentation
set(DOC_IMG
  ${CMAKE_HOME_DIRECTORY}/doc/simgrid.css
  ${CMAKE_HOME_DIRECTORY}/doc/sc3-description.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/AS_hierarchy.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/Paje_MSG_screenshot.jpg
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/Paje_MSG_screenshot_thn.jpg
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/SGicon.gif
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/SGicon.icns
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/SGicon.ico
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/awstats_logo3.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/output.goal.pdf
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/poster_thumbnail.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/storage_sample_scenario.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_2011.gif
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_2011.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_2011_small.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_win.bmp
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_win_2011.bmp
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_01.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_02.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_03.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_04.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_05.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_06.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/smpi_simgrid_alltoall_pair_16.png
  ${CMAKE_HOME_DIRECTORY}/doc/webcruft/smpi_simgrid_alltoall_ring_16.png
  )

set(bin_files
  ${bin_files}
  src/smpi/smpicc.in
  src/smpi/smpicxx.in
  src/smpi/smpiff.in
  src/smpi/smpif90.in
  src/smpi/smpirun.in
  src/smpi/smpitools.sh
  )

set(txt_files
  ${txt_files}
  AUTHORS
  COPYING
  README
  README.java
  ChangeLog
  ChangeLog.SimGrid-java
  INSTALL
  LICENSE-LGPL-2.1
  NEWS
  TODO
  configure
  )

set(EXAMPLES_CMAKEFILES_TXT
  examples/java/CMakeLists.txt
  examples/java/async/CMakeLists.txt
  examples/java/bittorrent/CMakeLists.txt
  examples/java/chord/CMakeLists.txt
  examples/java/cloud/CMakeLists.txt
  examples/java/cloud/migration/CMakeLists.txt
  examples/java/commTime/CMakeLists.txt
  examples/java/io/CMakeLists.txt
  examples/java/kademlia/CMakeLists.txt
  examples/java/master_slave_bypass/CMakeLists.txt
  examples/java/master_slave_kill/CMakeLists.txt
  examples/java/masterslave/CMakeLists.txt
  examples/java/migration/CMakeLists.txt
  examples/java/mutualExclusion/CMakeLists.txt
  examples/java/pingPong/CMakeLists.txt
  examples/java/priority/CMakeLists.txt
  examples/java/reservationSurfPlugin/CMakeLists.txt
  examples/java/startKillTime/CMakeLists.txt
  examples/java/surfCpuModel/CMakeLists.txt
  examples/java/surfPlugin/CMakeLists.txt
  examples/java/suspend/CMakeLists.txt
  examples/java/tracing/CMakeLists.txt
  examples/lua/CMakeLists.txt
  examples/msg/CMakeLists.txt
  examples/msg/actions/CMakeLists.txt
  examples/msg/bittorrent/CMakeLists.txt
  examples/msg/chainsend/CMakeLists.txt
  examples/msg/chord/CMakeLists.txt
  examples/msg/cloud/CMakeLists.txt
  examples/msg/energy/consumption/CMakeLists.txt
  examples/msg/energy/onoff/CMakeLists.txt
  examples/msg/energy/pstate/CMakeLists.txt
  examples/msg/exception/CMakeLists.txt
  examples/msg/gpu/CMakeLists.txt
  examples/msg/gtnets/CMakeLists.txt 
  examples/msg/icomms/CMakeLists.txt
  examples/msg/io/CMakeLists.txt
  examples/msg/kademlia/CMakeLists.txt
  examples/msg/masterslave/CMakeLists.txt
  examples/msg/mc/CMakeLists.txt
  examples/msg/migration/CMakeLists.txt
  examples/msg/ns3/CMakeLists.txt
  examples/msg/parallel_task/CMakeLists.txt
  examples/msg/pastry/CMakeLists.txt
  examples/msg/pmm/CMakeLists.txt
  examples/msg/priority/CMakeLists.txt
  examples/msg/properties/CMakeLists.txt
  examples/msg/semaphores/CMakeLists.txt
  examples/msg/sendrecv/CMakeLists.txt
  examples/msg/start_kill_time/CMakeLists.txt
  examples/msg/suspend/CMakeLists.txt
  examples/msg/token_ring/CMakeLists.txt
  examples/msg/tracing/CMakeLists.txt
  examples/scala/CMakeLists.txt
  examples/scala/master_slave_bypass/CMakeLists.txt
  examples/scala/master_slave_kill/CMakeLists.txt
  examples/scala/masterslave/CMakeLists.txt
  examples/simdag/CMakeLists.txt
  examples/simdag/dax/CMakeLists.txt
  examples/simdag/dot/CMakeLists.txt
  examples/simdag/goal/CMakeLists.txt
  examples/simdag/io/CMakeLists.txt
  examples/simdag/metaxml/CMakeLists.txt
  examples/simdag/properties/CMakeLists.txt
  examples/simdag/scheduling/CMakeLists.txt
  examples/smpi/CMakeLists.txt
  examples/smpi/smpi_msg_masterslave/CMakeLists.txt
  examples/smpi/replay_multiple/CMakeLists.txt
  examples/smpi/MM/CMakeLists.txt
  examples/smpi/energy/CMakeLists.txt
  examples/smpi/energy/f77/CMakeLists.txt
  examples/smpi/energy/f90/CMakeLists.txt
  examples/xbt/CMakeLists.txt
  )

set(TESHSUITE_CMAKEFILES_TXT
  teshsuite/bug-17132/CMakeLists.txt
  teshsuite/java/CMakeLists.txt
  teshsuite/java/sleep_host_off/CMakeLists.txt
  teshsuite/mc/CMakeLists.txt
  teshsuite/mc/dwarf/CMakeLists.txt
  teshsuite/mc/dwarf_expression/CMakeLists.txt
  teshsuite/mc/replay/CMakeLists.txt
  teshsuite/msg/CMakeLists.txt
  teshsuite/msg/get_sender/CMakeLists.txt
  teshsuite/msg/host_on_off/CMakeLists.txt
  teshsuite/msg/host_on_off_processes/CMakeLists.txt
  teshsuite/msg/pid/CMakeLists.txt
  teshsuite/msg/process/CMakeLists.txt
  teshsuite/msg/process_join/CMakeLists.txt
  teshsuite/msg/storage/CMakeLists.txt
  teshsuite/msg/task_destroy_cancel/CMakeLists.txt
  teshsuite/msg/trace/CMakeLists.txt
  teshsuite/simdag/availability/CMakeLists.txt
  teshsuite/simdag/basic/CMakeLists.txt
  teshsuite/simdag/incomplete/CMakeLists.txt
  teshsuite/simdag/network/CMakeLists.txt
  teshsuite/simdag/network/mxn/CMakeLists.txt
  teshsuite/simdag/network/p2p/CMakeLists.txt
  teshsuite/simdag/partask/CMakeLists.txt
  teshsuite/simdag/platforms/CMakeLists.txt
  teshsuite/simix/check_defaults/CMakeLists.txt
  teshsuite/simix/stack_overflow/CMakeLists.txt
  teshsuite/smpi/CMakeLists.txt
  teshsuite/smpi/allgather/CMakeLists.txt
  teshsuite/smpi/allgatherv/CMakeLists.txt
  teshsuite/smpi/allreduce/CMakeLists.txt
  teshsuite/smpi/alltoall/CMakeLists.txt
  teshsuite/smpi/alltoallv/CMakeLists.txt
  teshsuite/smpi/barrier/CMakeLists.txt
  teshsuite/smpi/bcast/CMakeLists.txt
  teshsuite/smpi/compute/CMakeLists.txt
  teshsuite/smpi/gather/CMakeLists.txt
  teshsuite/smpi/hvector/CMakeLists.txt
  teshsuite/smpi/indexed/CMakeLists.txt
  teshsuite/smpi/pingpong/CMakeLists.txt
  teshsuite/smpi/reduce/CMakeLists.txt
  teshsuite/smpi/scatter/CMakeLists.txt
  teshsuite/smpi/shared/CMakeLists.txt
  teshsuite/smpi/struct/CMakeLists.txt
  teshsuite/smpi/vector/CMakeLists.txt
  teshsuite/smpi/isp/umpire/CMakeLists.txt
  teshsuite/smpi/mpich3-test/CMakeLists.txt
  teshsuite/smpi/mpich3-test/attr/CMakeLists.txt
  teshsuite/smpi/mpich3-test/coll/CMakeLists.txt
  teshsuite/smpi/mpich3-test/comm/CMakeLists.txt
  teshsuite/smpi/mpich3-test/datatype/CMakeLists.txt
#  teshsuite/smpi/mpich3-test/f77/attr/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/coll/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/info/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/comm/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/datatype/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/ext/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/init/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/pt2pt/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/util/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/topo/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f77/rma/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/coll/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/datatype/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/info/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/init/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/pt2pt/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/util/CMakeLists.txt
  teshsuite/smpi/mpich3-test/f90/rma/CMakeLists.txt
  teshsuite/smpi/mpich3-test/group/CMakeLists.txt
  teshsuite/smpi/mpich3-test/info/CMakeLists.txt
  teshsuite/smpi/mpich3-test/init/CMakeLists.txt
  teshsuite/smpi/mpich3-test/pt2pt/CMakeLists.txt
  teshsuite/smpi/mpich3-test/topo/CMakeLists.txt
  teshsuite/smpi/mpich3-test/rma/CMakeLists.txt
  teshsuite/smpi/mpich3-test/perf/CMakeLists.txt
  teshsuite/surf/CMakeLists.txt
  teshsuite/surf/lmm_usage/CMakeLists.txt
  teshsuite/surf/maxmin_bench/CMakeLists.txt
  teshsuite/surf/surf_usage/CMakeLists.txt
  teshsuite/surf/trace_usage/CMakeLists.txt
  teshsuite/xbt/graphxml_usage/CMakeLists.txt
  teshsuite/xbt/heap_bench/CMakeLists.txt
  teshsuite/xbt/log_large/CMakeLists.txt
  teshsuite/xbt/log_usage/CMakeLists.txt
  teshsuite/xbt/mallocator/CMakeLists.txt
  teshsuite/xbt/mmalloc/CMakeLists.txt
  teshsuite/xbt/parallel_log/CMakeLists.txt
  teshsuite/xbt/parmap_bench/CMakeLists.txt
  teshsuite/xbt/parmap_test/CMakeLists.txt
  )

set(TOOLS_CMAKEFILES_TXT
  tools/CMakeLists.txt
  tools/graphicator/CMakeLists.txt
  tools/tesh/CMakeLists.txt
  )

set(CMAKE_SOURCE_FILES
  CMakeLists.txt
  tools/cmake/Tests.cmake
  tools/cmake/CTestConfig.cmake
  tools/cmake/CTestCustom.cmake
  tools/cmake/CompleteInFiles.cmake
  tools/cmake/DefinePackages.cmake
  tools/cmake/Distrib.cmake
  tools/cmake/GCCFlags.cmake
  tools/cmake/Documentation.cmake
  tools/cmake/MaintainerMode.cmake
  tools/cmake/MakeExe.cmake
  tools/cmake/Java.cmake
  tools/cmake/MakeLib.cmake
  tools/cmake/MakeLibWin.cmake
  tools/cmake/Modules/FindGFortran.cmake
  tools/cmake/Modules/FindGraphviz.cmake
  tools/cmake/Modules/FindLibSigc++.cmake
  tools/cmake/Modules/FindLibdw.cmake
  tools/cmake/Modules/FindLibunwind.cmake
  tools/cmake/Modules/FindLua51Simgrid.cmake
  tools/cmake/Modules/FindNS3.cmake
  tools/cmake/Modules/FindRngStream.cmake
  tools/cmake/Modules/FindRubySimgrid.cmake
  tools/cmake/Modules/FindScala.cmake
  tools/cmake/Modules/FindSimGrid.cmake
  tools/cmake/Modules/FindValgrind.cmake
  tools/cmake/Option.cmake
  tools/cmake/PrintArgs.cmake
  tools/cmake/scripts/IPC/Run.pm
  tools/cmake/scripts/IPC/Run/Debug.pm
  tools/cmake/scripts/IPC/Run/IO.pm
  tools/cmake/scripts/IPC/Run/Timer.pm
  tools/cmake/scripts/IPC/Run/Win32Helper.pm
  tools/cmake/scripts/IPC/Run/Win32IO.pm
  tools/cmake/scripts/IPC/Run/Win32Pump.pm
  tools/cmake/scripts/Diff.pm
  tools/cmake/scripts/Makefile.default
  tools/cmake/scripts/SimGrid.packproj
  tools/cmake/scripts/generate_memcheck_tests.pl
  tools/cmake/scripts/my_valgrind.pl
  tools/cmake/scripts/postinstall.sh
  tools/cmake/scripts/preinstall.sh
  tools/cmake/scripts/update_tesh.pl
  tools/cmake/UnitTesting.cmake
  tools/cmake/src/internal_config.h.in
  tools/cmake/src/simgrid.nsi.in
  tools/cmake/test_prog/prog_AC_CHECK_MCSC.c
  tools/cmake/test_prog/prog_gnu_dynlinker.c
  tools/cmake/test_prog/prog_mutex_timedlock.c
  tools/cmake/test_prog/prog_sem_init.c
  tools/cmake/test_prog/prog_sem_open.c
  tools/cmake/test_prog/prog_sem_timedwait.c
  tools/cmake/test_prog/prog_snprintf.c
  tools/cmake/test_prog/prog_stackgrowth.c
  tools/cmake/test_prog/prog_stacksetup.c
  tools/cmake/test_prog/prog_thread_storage.c
  tools/cmake/test_prog/prog_vsnprintf.c
  tools/cmake/cross-mingw.cmake
  tools/stack-cleaner/as
  tools/stack-cleaner/cc
  tools/stack-cleaner/c++
  tools/stack-cleaner/fortran
  tools/stack-cleaner/clean-stack-filter
  tools/stack-cleaner/compiler-wrapper
  tools/stack-cleaner/README
  )

set(PLATFORMS_EXAMPLES
  examples/platforms/bypassASroute.xml
  examples/platforms/bypassRoute.xml
  examples/platforms/cloud.xml
  examples/platforms/cluster.xml
  examples/platforms/cluster_and_one_host.xml
  examples/platforms/cluster_no_backbone.xml
  examples/platforms/clusters_routing_full.xml
  examples/platforms/crosstraffic.xml
  examples/platforms/conf/gridpp_grid_2004.conf
  examples/platforms/conf/gridpp_grid_2004.xml
  examples/platforms/conf/lcg_sept2004_grid.conf
  examples/platforms/conf/lcg_sept2004_grid.xml
  examples/platforms/conf/transform_optorsim_platform.pl
  examples/platforms/config.xml
  examples/platforms/config_tracing.xml
  examples/platforms/trace/trace_A_failure.txt
  examples/platforms/trace/trace_A.txt
  examples/platforms/trace/trace_B.txt
  examples/platforms/data_center.xml
  examples/platforms/energy_platform.xml
  examples/platforms/fat_tree_cluster.xml
  examples/platforms/g5k.xml
  examples/platforms/generation_scripts/create_hierarchical_clusters.pl
  examples/platforms/generation_scripts/enhancedDTDwithHierarchicalCluster.pl
  examples/platforms/generation_scripts/generate_g5k_platform.pl
  examples/platforms/generation_scripts/generate_g5k_platform_cabinets.pl
  examples/platforms/griffon.xml
  examples/platforms/meta_cluster.xml
  examples/platforms/multicore_machine.xml
  examples/platforms/platform.xml
  examples/platforms/prop.xml
  examples/platforms/routing_cluster.xml
  examples/platforms/routing_none.xml
  examples/platforms/storage/content/small_content.txt
  examples/platforms/storage/content/storage_content.txt
  examples/platforms/storage/content/win_storage_content.txt
  examples/platforms/storage/remote_io.deployment.xml
  examples/platforms/storage/remote_io.xml
  examples/platforms/storage/storage.xml
  examples/platforms/small_platform.xml
  examples/platforms/small_platform_fatpipe.xml
  examples/platforms/small_platform_one_link_routes.xml
  examples/platforms/small_platform_with_failures.xml
  examples/platforms/small_platform_with_routers.xml
  examples/platforms/syscoord/generate_peer_platform.pl
  examples/platforms/syscoord/median_harvard.syscoord
  examples/platforms/syscoord/median_harvard.xml
  examples/platforms/syscoord/median_meridian.syscoord
  examples/platforms/syscoord/median_meridian.xml
  examples/platforms/syscoord/median_p2psim.syscoord
  examples/platforms/syscoord/median_p2psim.xml
  examples/platforms/torus_cluster.xml
  examples/platforms/two_hosts_platform.xml
  examples/platforms/two_hosts_platform_shared.xml
  examples/platforms/two_hosts_platform_with_availability.xml
  examples/platforms/two_hosts_platform_with_availability_included.xml
  examples/platforms/two_peers.xml
  examples/platforms/vivaldi.xml
  )

set(generated_src_files
  src/xbt/automaton/automaton_lexer.yy.c
  src/xbt/automaton/parserPromela.tab.cacc
  src/xbt/automaton/parserPromela.tab.hacc
  )

if(enable_ust)
  set(simgrid_sources ${CMAKE_CURRENT_BINARY_DIR}/src/simgrid_ust.c ${simgrid_sources})
  ADD_CUSTOM_COMMAND(
    OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/src/simgrid_ust.c
    OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/src/simgrid_ust.h
    COMMAND lttng-gen-tp -o simgrid_ust.c -o simgrid_ust.h ${CMAKE_CURRENT_SOURCE_DIR}/src/probes.tp
    WORKING_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}/src/
    DEPENDS ${CMAKE_CURRENT_SOURCE_DIR}/src/probes.tp
  )
  ADD_CUSTOM_TARGET(simgrid_ust
    DEPENDS
      ${CMAKE_CURRENT_BINARY_DIR}/src/simgrid_ust.c
      ${CMAKE_CURRENT_BINARY_DIR}/src/simgrid_ust.h
    )
  set(generated_src_files ${CMAKE_CURRENT_BINARY_DIR}/src/simgrid_ust.c ${generated_src_files})
endif()

foreach(file ${generated_src_files})
  set_source_files_properties(${file} PROPERTIES GENERATED true)
endforeach(file ${generated_src_files})
