-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (ErrorHandler.Conversions.ToString)
procedure Note (Err_Num          : in     Error_Types.NumericError;
                With_Explanation : in     Boolean;
                E_Str            : in out E_Strings.T) is

   procedure NoteExpl (E_Str : in out E_Strings.T)
   --# global in Err_Num;
   --# derives E_Str from *,
   --#                    Err_Num;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an Append_String for the
   --      explanatory text that is delineated by --! comments.

   procedure Append_Explanation
   --# global in     Err_Num;
   --#        in     With_Explanation;
   --#        in out E_Str;
   --# derives E_Str from *,
   --#                    Err_Num,
   --#                    With_Explanation;
   is
      Explanation_String : E_Strings.T := E_Strings.Empty_String;
   begin
      if With_Explanation then
         -- we need to at least look for an explanation
         NoteExpl (E_Str => Explanation_String);
         if E_Strings.Get_Length (E_Str => Explanation_String) > 0 then
            -- there actually is one
            E_Strings.Append_String (E_Str => E_Str,
                                     Str   => ErrorHandler.Explanation_Prefix);
            E_Strings.Append_Examiner_String (E_Str1 => E_Str,
                                              E_Str2 => Explanation_String);
            E_Strings.Append_String (E_Str => E_Str,
                                     Str   => ErrorHandler.Explanation_Postfix);
         end if;
      end if;
   end Append_Explanation;

begin

   -- HTML Directives
   --! <NameFormat> <"note-"><Name>
   --! <ErrorFormat> <"--- note : "><Name><" : "><Error>

   case Err_Num.ErrorNum is
      when 1 =>
         E_Strings.Append_String
           (E_Str => E_Str,
            Str   => "This dependency relation was not used for this analysis and has not been checked for accuracy");
         --! Issued when information flow analysis is not performed and when
         --! modes were specified in the global annotation. It is a reminder
         --! that the dependencies specified in this annotation
         --! (including whether each variable is an import or an export) have
         --! not been checked against the code, and may therefore be incorrect.
         --! (warning control file keyword:<b> notes</b>)

      when 2 =>
         E_Strings.Append_String
           (E_Str => E_Str,
            Str   => "This dependency relation has been used " &
              "only to identify imports and exports, " &
              "dependencies have been ignored");
         --! Issued as a reminder when information flow analysis is not
         --! performed in SPARK 83. The dependencies specified in this annotation
         --! have not been checked against the code, and may
         --! therefore be incorrect. (warning control file keyword: <b>notes</b>)

      when 3 =>
         E_Strings.Append_String (E_Str => E_Str,
                                  Str   => "The deferred constant Null_Address has been implicitly defined here");
         --! Issued as a reminder that the declaration of the type Address
         --! within the target configuration file
         --! implicitly defines a deferred constant of type Null_Address.
         --! (warning control file keyword:<b> notes</b>)

      when 4 =>
         E_Strings.Append_String
           (E_Str => E_Str,
            Str   => "The constant Default_Priority, of type Priority, has been implicitly defined here");
         --! Issued as a reminder that the declaration of the subtype
         --! Priority within the target configuration file implicitly defines
         --! a constant Default_Priority, of type Priority, with the value
         --! (Priority'First + Priority'Last) / 2.
         --! (warning control file keyword:<b> notes</b>)

      when others =>
         E_Strings.Append_String (E_Str => E_Str,
                                  Str   => "UNKNOWN ERROR NUMBER PASSED TO Convert.Note");

   end case;

   Append_Explanation;
   E_Strings.Append_String (E_Str => E_Str,
                            Str   => ".");
end Note;
