-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with ComponentManager;
with Dictionary;
with Heap;
with LexTokenManager;
with RefList;
with STree;

use type Dictionary.Modes;
use type Heap.Atom;
use type STree.SyntaxNode;

--# inherit CommandLineData,
--#         ComponentErrors,
--#         ComponentManager,
--#         Debug,
--#         Dictionary,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         Heap,
--#         LexTokenManager,
--#         RefList,
--#         RelationAlgebra,
--#         RelationAlgebra.Debug,
--#         SeqAlgebra,
--#         SPARK_IO,
--#         SP_Symbols,
--#         Statistics,
--#         STree,
--#         SystemErrors;
package FlowAnalyser is
   procedure FlowAnalyse
     (SubprogSym         : in     Dictionary.Symbol;
      StartNode          : in     STree.SyntaxNode;
      EndPosition        : in     LexTokenManager.Token_Position;
      ComponentData      : in out ComponentManager.ComponentData;
      TheHeap            : in out Heap.HeapRecord;
      Table              : in     RefList.HashTable;
      DataFlowErrorFound :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives ComponentData,
   --#         Statistics.TableUsage,
   --#         TheHeap                    from *,
   --#                                         ComponentData,
   --#                                         Dictionary.Dict,
   --#                                         EndPosition,
   --#                                         StartNode,
   --#                                         STree.Table,
   --#                                         SubprogSym,
   --#                                         Table,
   --#                                         TheHeap &
   --#         DataFlowErrorFound         from ComponentData,
   --#                                         Dictionary.Dict,
   --#                                         EndPosition,
   --#                                         StartNode,
   --#                                         STree.Table,
   --#                                         SubprogSym,
   --#                                         Table,
   --#                                         TheHeap &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         ComponentData,
   --#                                         Dictionary.Dict,
   --#                                         EndPosition,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         StartNode,
   --#                                         STree.Table,
   --#                                         SubprogSym,
   --#                                         Table,
   --#                                         TheHeap;

   procedure FlowAnalysePartition (Node    : in     STree.SyntaxNode;
                                   TheHeap : in out Heap.HeapRecord);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         TheHeap &
   --#         Statistics.TableUsage,
   --#         TheHeap                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         TheHeap;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.main_program_declaration;

end FlowAnalyser;
