-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--  The generic procedure Sort_Table is missing in the generic package
--  GNAT.Table (it exists in the generic package
--  GNAT.Dynamic_Tables). To prevent to change the generic package
--  GNAT.Table, a public child package has been written to add this
--  functionality. This generic child package contains a generic
--  function to sort the table.

generic
package GNAT.Table.Sort is

   generic
      with function Lt (Comp1, Comp2 : Table_Component_Type) return Boolean;
   procedure Sort_Table;
   --  This procedure sorts the components of the table into ascending
   --  order making calls to Lt to do required comparisons, and using
   --  assignments to move components around. The Lt function returns True
   --  if Comp1 is less than Comp2 (in the sense of the desired sort), and
   --  False if Comp1 is greater than Comp2. For equal objects it does not
   --  matter if True or False is returned (it is slightly more efficient
   --  to return False). The sort is not stable (the order of equal items
   --  in the table is not preserved).

end GNAT.Table.Sort;
