-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Top level package for the summary tool                                      --
--The main program is simply a call to the procedure MainProcedure wrapped in --
--an execption handler to deal with the exceptions raised by FatalErrors      --
--                                                                            --
--------------------------------------------------------------------------------

--# inherit Banner,
--#         CommandLine,
--#         E_Strings,
--#         FatalErrors,
--#         FileDetails,
--#         FileHeap,
--#         FindFiles,
--#         Heap,
--#         OSCommandLine,
--#         OSFiling,
--#         SPARK_IO,
--#         Total,
--#         VCHeap,
--#         VCS;

package TopPackage is

   procedure Main_Procedure;
   --# global in     OSCommandLine.State;
   --#        in     OSFiling.File_Structure;
   --#        in out FatalErrors.State;
   --#        in out FileHeap.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Total.State;
   --#           out CommandLine.Data;
   --#           out VCHeap.I_State;
   --#           out VCHeap.State;
   --# derives CommandLine.Data  from OSCommandLine.State,
   --#                                OSFiling.File_Structure &
   --#         FatalErrors.State,
   --#         Total.State       from *,
   --#                                OSCommandLine.State,
   --#                                OSFiling.File_Structure,
   --#                                SPARK_IO.File_Sys &
   --#         FileHeap.State    from *,
   --#                                OSCommandLine.State,
   --#                                OSFiling.File_Structure &
   --#         SPARK_IO.File_Sys from *,
   --#                                OSCommandLine.State,
   --#                                OSFiling.File_Structure,
   --#                                Total.State &
   --#         VCHeap.I_State,
   --#         VCHeap.State      from OSCommandLine.State,
   --#                                OSFiling.File_Structure,
   --#                                SPARK_IO.File_Sys;

end TopPackage;
