/* test-umockdev-run.c generated by valac 0.24.0, the Vala compiler
 * generated from test-umockdev-run.vala, do not modify */

/*
 * test-umockdev-run.vala
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/wait.h>
#include <signal.h>
#include "config.h"
#include <glib/gstdio.h>
#include <unistd.h>
#include <float.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/types.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern gchar* rootdir;
gchar* rootdir = NULL;

#define umockdev_run_command "env LC_ALL=C umockdev-run "
void assert_in (const gchar* needle, const gchar* haystack);
gboolean have_program (const gchar* program);
gboolean get_program_out (const gchar* program, const gchar* command, gchar** sout, gchar** serr, gint* exit);
void check_program_out (const gchar* program, const gchar* run_command, const gchar* expected_out);
void check_program_error (const gchar* program, const gchar* run_command, const gchar* expected_err);
void t_run_exit_code (void);
void t_run_version (void);
void t_run_pipes (void);
void t_run_invalid_args (void);
void t_run_invalid_device (void);
void t_run_invalid_ioctl (void);
void t_run_invalid_script (void);
void t_run_invalid_program (void);
void t_run_script_chatter (void);
void t_run_script_chatter_socket_stream (void);
void t_gphoto_detect (void);
gboolean check_gphoto_version (void);
void t_gphoto_folderlist (void);
void t_gphoto_filelist (void);
void t_gphoto_thumbs (void);
void t_gphoto_download (void);
void t_input_touchpad (void);
void t_input_evtest (void);
void t_input_evtest_evemu (void);
gint _vala_main (gchar** args, int args_length1);
static void _t_run_exit_code_gtest_func (void);
static void _t_run_version_gtest_func (void);
static void _t_run_pipes_gtest_func (void);
static void _t_run_invalid_args_gtest_func (void);
static void _t_run_invalid_device_gtest_func (void);
static void _t_run_invalid_ioctl_gtest_func (void);
static void _t_run_invalid_script_gtest_func (void);
static void _t_run_invalid_program_gtest_func (void);
static void _t_run_script_chatter_gtest_func (void);
static void _t_run_script_chatter_socket_stream_gtest_func (void);
static void _t_gphoto_detect_gtest_func (void);
static void _t_gphoto_folderlist_gtest_func (void);
static void _t_gphoto_filelist_gtest_func (void);
static void _t_gphoto_thumbs_gtest_func (void);
static void _t_gphoto_download_gtest_func (void);
static void _t_input_touchpad_gtest_func (void);
static void _t_input_evtest_gtest_func (void);
static void _t_input_evtest_evemu_gtest_func (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void assert_in (const gchar* needle, const gchar* haystack) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (needle != NULL);
	g_return_if_fail (haystack != NULL);
	_tmp0_ = haystack;
	_tmp1_ = needle;
	_tmp2_ = string_contains (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		FILE* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = needle;
		_tmp5_ = haystack;
		fprintf (_tmp3_, "'%s' not found in '%s'\n", _tmp4_, _tmp5_);
		abort ();
	}
}


gboolean have_program (const gchar* program) {
	gboolean result = FALSE;
	gchar* sout = NULL;
	gint exit = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (program != NULL, FALSE);
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp0_ = program;
		_tmp1_ = g_strconcat ("which ", _tmp0_, NULL);
		_tmp2_ = _tmp1_;
		g_spawn_command_line_sync (_tmp2_, &_tmp3_, NULL, &_tmp4_, &_inner_error_);
		_g_free0 (sout);
		sout = _tmp3_;
		exit = _tmp4_;
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (sout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = program;
		_tmp7_ = e->message;
		fprintf (_tmp5_, "cannot call which %s: %s\n", _tmp6_, _tmp7_);
		abort ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = exit == 0;
	_g_free0 (sout);
	return result;
}


gboolean get_program_out (const gchar* program, const gchar* command, gchar** sout, gchar** serr, gint* exit) {
	gchar* _vala_sout = NULL;
	gchar* _vala_serr = NULL;
	gint _vala_exit = 0;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (program != NULL, FALSE);
	g_return_val_if_fail (command != NULL, FALSE);
	_tmp0_ = program;
	_tmp1_ = have_program (_tmp0_);
	if (!_tmp1_) {
		FILE* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = stdout;
		_tmp3_ = program;
		fprintf (_tmp2_, "[SKIP: %s not installed] ", _tmp3_);
		_tmp4_ = g_strdup ("");
		_g_free0 (_vala_sout);
		_vala_sout = _tmp4_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_vala_serr);
		_vala_serr = _tmp5_;
		_vala_exit = -1;
		result = FALSE;
		if (sout) {
			*sout = _vala_sout;
		} else {
			_g_free0 (_vala_sout);
		}
		if (serr) {
			*serr = _vala_serr;
		} else {
			_g_free0 (_vala_serr);
		}
		if (exit) {
			*exit = _vala_exit;
		}
		return result;
	}
	{
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp6_ = command;
		g_spawn_command_line_sync (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_inner_error_);
		_g_free0 (_vala_sout);
		_vala_sout = _tmp7_;
		_g_free0 (_vala_serr);
		_vala_serr = _tmp8_;
		_vala_exit = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = stderr;
		_tmp11_ = command;
		_tmp12_ = e->message;
		fprintf (_tmp10_, "cannot call %s: %s\n", _tmp11_, _tmp12_);
		abort ();
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	if (sout) {
		*sout = _vala_sout;
	} else {
		_g_free0 (_vala_sout);
	}
	if (serr) {
		*serr = _vala_serr;
	} else {
		_g_free0 (_vala_serr);
	}
	if (exit) {
		*exit = _vala_exit;
	}
	return result;
}


void check_program_out (const gchar* program, const gchar* run_command, const gchar* expected_out) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	g_return_if_fail (program != NULL);
	g_return_if_fail (run_command != NULL);
	g_return_if_fail (expected_out != NULL);
	_tmp0_ = program;
	_tmp1_ = run_command;
	_tmp2_ = g_strconcat (umockdev_run_command, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp7_ = get_program_out (_tmp0_, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (sout);
	sout = _tmp4_;
	_g_free0 (serr);
	serr = _tmp5_;
	exit = _tmp6_;
	_tmp8_ = !_tmp7_;
	_g_free0 (_tmp3_);
	if (_tmp8_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp9_ = sout;
	_tmp10_ = expected_out;
	g_assert_cmpstr (_tmp9_, ==, _tmp10_);
	_tmp11_ = serr;
	g_assert_cmpstr (_tmp11_, ==, "");
	_tmp12_ = exit;
	g_assert_cmpint (_tmp12_, ==, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}


void check_program_error (const gchar* program, const gchar* run_command, const gchar* expected_err) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_ = NULL;
	g_return_if_fail (program != NULL);
	g_return_if_fail (run_command != NULL);
	g_return_if_fail (expected_err != NULL);
	_tmp0_ = program;
	_tmp1_ = run_command;
	_tmp2_ = g_strconcat (umockdev_run_command, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp7_ = get_program_out (_tmp0_, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (sout);
	sout = _tmp4_;
	_g_free0 (serr);
	serr = _tmp5_;
	exit = _tmp6_;
	_tmp8_ = !_tmp7_;
	_g_free0 (_tmp3_);
	if (_tmp8_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp9_ = expected_err;
	_tmp10_ = serr;
	assert_in (_tmp9_, _tmp10_);
	_tmp11_ = exit;
	g_assert_cmpint (_tmp11_, !=, 0);
	_tmp12_ = exit;
	_tmp13_ = WIFEXITED (_tmp12_);
	_vala_assert (_tmp13_, "Process.if_exited (exit)");
	_tmp14_ = sout;
	g_assert_cmpstr (_tmp14_, ==, "");
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_run_exit_code (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gint _tmp14_ = 0;
	int _tmp15_ = 0;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	check_program_out ("true", umockdev_run_command "true", "");
	get_program_out ("ls", umockdev_run_command "ls /nonexisting", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_tmp3_ = exit;
	_tmp4_ = WIFEXITED (_tmp3_);
	_vala_assert (_tmp4_, "Process.if_exited (exit)");
	_tmp5_ = exit;
	_tmp6_ = WEXITSTATUS (_tmp5_);
	g_assert_cmpint (_tmp6_, ==, 2);
	_tmp7_ = sout;
	g_assert_cmpstr (_tmp7_, ==, "");
	_tmp8_ = serr;
	g_assert_cmpstr (_tmp8_, !=, "");
	get_program_out ("sh", umockdev_run_command "-- sh -c 'kill -SEGV $$'", &_tmp9_, &_tmp10_, &_tmp11_);
	_g_free0 (sout);
	sout = _tmp9_;
	_g_free0 (serr);
	serr = _tmp10_;
	exit = _tmp11_;
	_tmp12_ = exit;
	_tmp13_ = WIFSIGNALED (_tmp12_);
	_vala_assert (_tmp13_, "Process.if_signaled (exit)");
	_tmp14_ = exit;
	_tmp15_ = WTERMSIG (_tmp14_);
	g_assert_cmpint ((gint) _tmp15_, ==, (gint) SIGSEGV);
	_tmp16_ = sout;
	g_assert_cmpstr (_tmp16_, ==, "");
	_tmp17_ = serr;
	g_assert_cmpstr (_tmp17_, ==, "");
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_run_version (void) {
	check_program_out ("true", "--version", VERSION "\n");
}


void t_run_pipes (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	_tmp3_ = get_program_out ("echo", "sh -c 'echo hello | " umockdev_run_command "cat'", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_vala_assert (_tmp3_, "get_program_out (\"echo\", \"sh -c 'echo hello | \" + umockdev_run_command + \"cat'\",                             out sout, out serr, out exit)");
	g_assert_cmpstr (sout, ==, "hello\n");
	g_assert_cmpstr (serr, ==, "");
	g_assert_cmpint (exit, ==, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_run_invalid_args (void) {
	check_program_error ("true", "", "--help");
	check_program_error ("true", "--foobarize", "--help");
}


void t_run_invalid_device (void) {
	GError * _inner_error_ = NULL;
	check_program_error ("true", "-d non.existing", "Cannot open non.existing:");
	{
		gchar* umockdev_file = NULL;
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp1_ = g_file_open_tmp ("ttyS0.XXXXXX.umockdev", &_tmp0_, &_inner_error_);
		_g_free0 (umockdev_file);
		umockdev_file = _tmp0_;
		fd = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_free0 (umockdev_file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = fd;
		close (_tmp2_);
		_tmp3_ = umockdev_file;
		g_file_set_contents (_tmp3_, "P: /devices/foo\n", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (umockdev_file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = umockdev_file;
		_tmp5_ = g_strconcat ("-d ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = umockdev_file;
		_tmp8_ = g_strconcat ("Invalid record file ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, ": missing SUBSYSTEM", NULL);
		_tmp11_ = _tmp10_;
		check_program_error ("true", _tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
		_g_free0 (umockdev_file);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e->message;
		fprintf (_tmp12_, "cannot create temporary file: %s\n", _tmp13_);
		abort ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void t_run_invalid_ioctl (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/dev/bus/usb/001/011=/non/existing.ioctl -- gphoto2 -l", NULL);
	_tmp6_ = _tmp5_;
	check_program_error ("gphoto2", _tmp6_, "/non/existing.ioctl");
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = rootdir;
	_tmp8_ = g_strconcat ("-d ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/dev/bus/usb/001/011=/dev/null -- gphoto2 -l", NULL);
	_tmp13_ = _tmp12_;
	check_program_error ("gphoto2", _tmp13_, "001/011");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = rootdir;
	_tmp15_ = g_strconcat ("-d ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/dev/bus/usb/001/011=", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = rootdir;
	_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, "/NEWS -- gphoto2 -l", NULL);
	_tmp25_ = _tmp24_;
	check_program_error ("gphoto2", _tmp25_, "001/011");
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp26_ = rootdir;
	_tmp27_ = g_strconcat ("-d ", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "/dev/bus/usb/001/011 -- gphoto2 -l", NULL);
	_tmp32_ = _tmp31_;
	check_program_error ("gphoto2", _tmp32_, "--ioctl");
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
}


void t_run_invalid_script (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -s ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/dev/bus/usb/001/011 -- true", NULL);
	_tmp6_ = _tmp5_;
	check_program_error ("true", _tmp6_, "--script argument must be");
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = rootdir;
	_tmp8_ = g_strconcat ("-d ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/devices/cameras/canon-powershot-sx200.umockdev -s ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/dev/bus/usb/001/011=/etc/passwd -- true", NULL);
	_tmp13_ = _tmp12_;
	check_program_error ("true", _tmp13_, "not a device suitable for scripts");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = rootdir;
	_tmp15_ = g_strconcat ("-d ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/devices/input/usbkbd.umockdev -s ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/dev/input/event5=/non/existing -- true", NULL);
	_tmp20_ = _tmp19_;
	check_program_error ("true", _tmp20_, "Cannot install /non/existing for device /dev/input/event5:");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	check_program_error ("true", "-u /dev/mysock -- true", "--unix-stream argument must be");
}


void t_run_invalid_program (void) {
	check_program_error ("true", "no.such.prog", "Cannot run no.such.prog: Failed to execute");
}


void t_run_script_chatter (void) {
	gchar* umockdev_file = NULL;
	gchar* script_file = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	{
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp1_ = g_file_open_tmp ("ttyS0.XXXXXX.umockdev", &_tmp0_, &_inner_error_);
		_g_free0 (umockdev_file);
		umockdev_file = _tmp0_;
		fd = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = fd;
		close (_tmp2_);
		_tmp5_ = g_file_open_tmp ("chatter.XXXXXX.script", &_tmp4_, &_inner_error_);
		_g_free0 (script_file);
		script_file = _tmp4_;
		_tmp3_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		fd = _tmp3_;
		_tmp6_ = fd;
		close (_tmp6_);
		_tmp7_ = umockdev_file;
		g_file_set_contents (_tmp7_, "P: /devices/platform/serial8250/tty/ttyS0\n" \
"N: ttyS0\n" \
"E: DEVNAME=/dev/ttyS0\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=4:64", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = script_file;
		g_file_set_contents (_tmp8_, "w 0 Hello world!^JWhat is your name?^J\n" \
"r 300 Joe Tester^J\n" \
"w 0 I \342\231\245 Joe Tester^Ja^I tab and a^J   line break in one wri" \
"te^J\n" \
"r 200 somejunk^J\n" \
"w 0 bye!^J", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = stderr;
		_tmp10_ = e->message;
		fprintf (_tmp9_, "cannot create temporary file: %s\n", _tmp10_);
		abort ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (script_file);
		_g_free0 (umockdev_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = umockdev_file;
	_tmp12_ = g_strconcat ("-d ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, " -s /dev/ttyS0=", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = script_file;
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, " -- tests/chatter /dev/ttyS0", NULL);
	_tmp20_ = _tmp19_;
	check_program_out ("true", _tmp20_, "Got input: Joe Tester\nGot input: somejunk\n");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp21_ = umockdev_file;
	g_remove (_tmp21_);
	_tmp22_ = script_file;
	g_remove (_tmp22_);
	_g_free0 (script_file);
	_g_free0 (umockdev_file);
}


void t_run_script_chatter_socket_stream (void) {
	gchar* script_file = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	{
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		const gchar* _tmp3_ = NULL;
		_tmp1_ = g_file_open_tmp ("chatter.XXXXXX.script", &_tmp0_, &_inner_error_);
		_g_free0 (script_file);
		script_file = _tmp0_;
		fd = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (script_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = fd;
		close (_tmp2_);
		_tmp3_ = script_file;
		g_file_set_contents (_tmp3_, "w 0 What is your name?^J\n" \
"r 307 Joe Tester^J\n" \
"w 0 hello Joe Tester^J\n" \
"w 20 send()\n" \
"r 30 somejunk", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (script_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e->message;
		fprintf (_tmp4_, "cannot create temporary file: %s\n", _tmp5_);
		abort ();
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (script_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = script_file;
	_tmp7_ = g_strconcat (" -u /dev/socket/chatter=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, " -- tests/chatter-socket-stream /dev/socket/chatter", NULL);
	_tmp10_ = _tmp9_;
	check_program_out ("true", _tmp10_, "Got name: Joe Tester\n\nGot recv: somejunk\n");
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = script_file;
	g_remove (_tmp11_);
	_g_free0 (script_file);
}


void t_gphoto_detect (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 --auto-detect", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "Model                          Port            \n" \
"----------------------------------------------------------\n" \
"Canon PowerShot SX200 IS       usb:001,011     \n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


gboolean check_gphoto_version (void) {
	gboolean result = FALSE;
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** words = NULL;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint words_length1 = 0;
	gint _words_size_ = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	_tmp3_ = get_program_out ("gphoto2", "gphoto2 --version", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	_tmp4_ = sout;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 3);
	words = _tmp6_;
	words_length1 = _vala_array_length (_tmp5_);
	_words_size_ = words_length1;
	_tmp7_ = words;
	_tmp7__length1 = words_length1;
	if (_tmp7__length1 < 2) {
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	_tmp8_ = words;
	_tmp8__length1 = words_length1;
	_tmp9_ = _tmp8_[1];
	_tmp10_ = double_parse (_tmp9_);
	if (_tmp10_ < 2.5) {
		FILE* _tmp11_ = NULL;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "[SKIP: needs gphoto >= 2.5] ");
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	result = TRUE;
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (serr);
	_g_free0 (sout);
	return result;
}


void t_gphoto_folderlist (void) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	_tmp0_ = check_gphoto_version ();
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rootdir;
	_tmp2_ = g_strconcat ("-d ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = rootdir;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -l", NULL);
	_tmp10_ = _tmp9_;
	check_program_out ("gphoto2", _tmp10_, "There is 1 folder in folder '/'.\n" \
" - store_00010001\n" \
"There is 1 folder in folder '/store_00010001'.\n" \
" - DCIM\n" \
"There is 1 folder in folder '/store_00010001/DCIM'.\n" \
" - 100CANON\n" \
"There are 0 folders in folder '/store_00010001/DCIM/100CANON'.\n");
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


void t_gphoto_filelist (void) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	_tmp0_ = check_gphoto_version ();
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = rootdir;
	_tmp2_ = g_strconcat ("-d ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = rootdir;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -L", NULL);
	_tmp10_ = _tmp9_;
	check_program_out ("gphoto2", _tmp10_, "There is no file in folder '/'.\n" \
"There is no file in folder '/store_00010001'.\n" \
"There is no file in folder '/store_00010001/DCIM'.\n" \
"There are 2 files in folder '/store_00010001/DCIM/100CANON'.\n" \
"#1     IMG_0001.JPG               rd    67 KB  640x480  image/jpeg\n" \
"#2     IMG_0002.JPG               rd    88 KB  640x480  image/jpeg\n");
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}


void t_gphoto_thumbs (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	struct stat st = {0};
	struct stat _tmp17_ = {0};
	gint _tmp18_ = 0;
	struct stat _tmp19_ = {0};
	gsize _tmp20_ = 0UL;
	struct stat _tmp21_ = {0};
	gint _tmp22_ = 0;
	struct stat _tmp23_ = {0};
	gsize _tmp24_ = 0UL;
	_tmp0_ = check_gphoto_version ();
	if (!_tmp0_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp1_ = rootdir;
	_tmp2_ = g_strconcat (umockdev_run_command "-d ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = rootdir;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -T", NULL);
	_tmp10_ = _tmp9_;
	get_program_out ("gphoto2", _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	_g_free0 (sout);
	sout = _tmp11_;
	_g_free0 (serr);
	serr = _tmp12_;
	exit = _tmp13_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	assert_in ("thumb_IMG_0001.jpg", _tmp15_);
	_tmp16_ = sout;
	assert_in ("thumb_IMG_0002.jpg", _tmp16_);
	_tmp18_ = stat ("thumb_IMG_0001.jpg", &_tmp17_);
	st = _tmp17_;
	_vala_assert (_tmp18_ == 0, "Posix.stat(\"thumb_IMG_0001.jpg\", out st) == 0");
	_tmp19_ = st;
	_tmp20_ = _tmp19_.st_size;
	g_assert_cmpuint ((guint) _tmp20_, >, (guint) 500);
	_tmp22_ = stat ("thumb_IMG_0002.jpg", &_tmp21_);
	st = _tmp21_;
	_vala_assert (_tmp22_ == 0, "Posix.stat(\"thumb_IMG_0002.jpg\", out st) == 0");
	_tmp23_ = st;
	_tmp24_ = _tmp23_.st_size;
	g_assert_cmpuint ((guint) _tmp24_, >, (guint) 500);
	g_remove ("thumb_IMG_0001.jpg");
	g_remove ("thumb_IMG_0002.jpg");
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_gphoto_download (void) {
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	struct stat st = {0};
	struct stat _tmp17_ = {0};
	gint _tmp18_ = 0;
	struct stat _tmp19_ = {0};
	gsize _tmp20_ = 0UL;
	struct stat _tmp21_ = {0};
	gint _tmp22_ = 0;
	struct stat _tmp23_ = {0};
	gsize _tmp24_ = 0UL;
	_tmp0_ = check_gphoto_version ();
	if (!_tmp0_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp1_ = rootdir;
	_tmp2_ = g_strconcat (umockdev_run_command "-d ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = rootdir;
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -P", NULL);
	_tmp10_ = _tmp9_;
	get_program_out ("gphoto2", _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	_g_free0 (sout);
	sout = _tmp11_;
	_g_free0 (serr);
	serr = _tmp12_;
	exit = _tmp13_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp14_ = exit;
	g_assert_cmpint (_tmp14_, ==, 0);
	_tmp15_ = sout;
	assert_in ("IMG_0001.JPG", _tmp15_);
	_tmp16_ = sout;
	assert_in ("IMG_0002.JPG", _tmp16_);
	_tmp18_ = stat ("IMG_0001.JPG", &_tmp17_);
	st = _tmp17_;
	_vala_assert (_tmp18_ == 0, "Posix.stat(\"IMG_0001.JPG\", out st) == 0");
	_tmp19_ = st;
	_tmp20_ = _tmp19_.st_size;
	g_assert_cmpuint ((guint) _tmp20_, >, (guint) 5000);
	_tmp22_ = stat ("IMG_0002.JPG", &_tmp21_);
	st = _tmp21_;
	_vala_assert (_tmp22_ == 0, "Posix.stat(\"IMG_0002.JPG\", out st) == 0");
	_tmp23_ = st;
	_tmp24_ = _tmp23_.st_size;
	g_assert_cmpuint ((guint) _tmp24_, >, (guint) 5000);
	g_remove ("IMG_0001.JPG");
	g_remove ("IMG_0002.JPG");
	_g_free0 (serr);
	_g_free0 (sout);
}


void t_input_touchpad (void) {
	gboolean _tmp1_ = FALSE;
	glong _tmp3_ = 0L;
	gint64 _tmp4_ = 0LL;
	GPid xorg_pid = 0;
	gchar* logfile = NULL;
	gint timeout = 0;
	gint _tmp37_ = 0;
	gchar* xinput_out = NULL;
	gchar* xinput_err = NULL;
	gint xinput_exit = 0;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gchar* props_out = NULL;
	gchar* props_err = NULL;
	gint props_exit = 0;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	GPid _tmp46_ = 0;
	gint status = 0;
	GPid _tmp47_ = 0;
	gint _tmp48_ = 0;
	GPid _tmp49_ = 0;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GError * _inner_error_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	_tmp1_ = have_program ("Xorg");
	if (!_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "[SKIP: Xorg not installed] ");
		return;
	}
	_tmp3_ = G_MAXLONG;
	_tmp4_ = G_MAXINT64;
	if (((gint64) _tmp3_) != _tmp4_) {
		FILE* _tmp5_ = NULL;
		_tmp5_ = stdout;
		fprintf (_tmp5_, "[SKIP: test only works on 64 bit architectures] ");
		return;
	}
	{
		gint fd = 0;
		gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = g_file_open_tmp ("Xorg.log.XXXXXX", &_tmp6_, &_inner_error_);
		_g_free0 (logfile);
		logfile = _tmp6_;
		fd = _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (logfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = fd;
		close (_tmp8_);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = stderr;
		_tmp10_ = e->message;
		fprintf (_tmp9_, "cannot create temporary file: %s\n", _tmp10_);
		abort ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (logfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar** _tmp29_ = NULL;
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		GPid _tmp31_ = 0;
		_tmp11_ = g_strdup ("umockdev-run");
		_tmp12_ = g_strdup ("-d");
		_tmp13_ = rootdir;
		_tmp14_ = g_strconcat (_tmp13_, "/devices/input/synaptics-touchpad.umockdev", NULL);
		_tmp15_ = g_strdup ("-i");
		_tmp16_ = rootdir;
		_tmp17_ = g_strconcat ("/dev/input/event12=", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "/devices/input/synaptics-touchpad.ioctl", NULL);
		_tmp20_ = g_strdup ("--");
		_tmp21_ = g_strdup ("Xorg");
		_tmp22_ = g_strdup ("-config");
		_tmp23_ = rootdir;
		_tmp24_ = g_strconcat (_tmp23_, "/tests/xorg-dummy.conf", NULL);
		_tmp25_ = g_strdup ("-logfile");
		_tmp26_ = logfile;
		_tmp27_ = g_strdup (_tmp26_);
		_tmp28_ = g_strdup (":5");
		_tmp29_ = g_new0 (gchar*, 12 + 1);
		_tmp29_[0] = _tmp11_;
		_tmp29_[1] = _tmp12_;
		_tmp29_[2] = _tmp14_;
		_tmp29_[3] = _tmp15_;
		_tmp29_[4] = _tmp19_;
		_tmp29_[5] = _tmp20_;
		_tmp29_[6] = _tmp21_;
		_tmp29_[7] = _tmp22_;
		_tmp29_[8] = _tmp24_;
		_tmp29_[9] = _tmp25_;
		_tmp29_[10] = _tmp27_;
		_tmp29_[11] = _tmp28_;
		_tmp30_ = _tmp29_;
		_tmp30__length1 = 12;
		g_spawn_async (NULL, _tmp30_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp31_, &_inner_error_);
		xorg_pid = _tmp31_;
		_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp18_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			_g_free0 (logfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = stderr;
		_tmp33_ = e->message;
		fprintf (_tmp32_, "cannot call Xorg: %s\n", _tmp33_);
		abort ();
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_free0 (logfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	timeout = 50;
	while (TRUE) {
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gboolean _tmp36_ = FALSE;
		_tmp34_ = timeout;
		if (!(_tmp34_ > 0)) {
			break;
		}
		_tmp35_ = timeout;
		timeout = _tmp35_ - 1;
		usleep ((guint) 100000);
		_tmp36_ = g_file_test ("/tmp/.X11-unix/X5", G_FILE_TEST_EXISTS);
		if (_tmp36_) {
			break;
		}
	}
	_tmp37_ = timeout;
	if (_tmp37_ <= 0) {
		FILE* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		_tmp38_ = stderr;
		_tmp39_ = logfile;
		fprintf (_tmp38_, "Xorg failed to start up; please ensure you have the X.org dummy driver" \
" installed, and check the log file: %s\n", _tmp39_);
		abort ();
	}
	get_program_out ("xinput", "env DISPLAY=:5 xinput", &_tmp40_, &_tmp41_, &_tmp42_);
	_g_free0 (xinput_out);
	xinput_out = _tmp40_;
	_g_free0 (xinput_err);
	xinput_err = _tmp41_;
	xinput_exit = _tmp42_;
	get_program_out ("xinput", "env DISPLAY=:5 xinput --list-props 'SynPS/2 Synaptics TouchPad'", &_tmp43_, &_tmp44_, &_tmp45_);
	_g_free0 (props_out);
	props_out = _tmp43_;
	_g_free0 (props_err);
	props_err = _tmp44_;
	props_exit = _tmp45_;
	_tmp46_ = xorg_pid;
	kill ((pid_t) _tmp46_, SIGTERM);
	_tmp47_ = xorg_pid;
	waitpid ((pid_t) _tmp47_, &_tmp48_, 0);
	status = _tmp48_;
	_tmp49_ = xorg_pid;
	g_spawn_close_pid (_tmp49_);
	_tmp50_ = logfile;
	g_remove (_tmp50_);
	_tmp51_ = logfile;
	_tmp52_ = g_strconcat (_tmp51_, ".old", NULL);
	_tmp53_ = _tmp52_;
	g_remove (_tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = xinput_err;
	g_assert_cmpstr (_tmp54_, ==, "");
	_tmp55_ = xinput_exit;
	g_assert_cmpint (_tmp55_, ==, 0);
	_tmp56_ = xinput_out;
	assert_in ("SynPS/2 Synaptics TouchPad", _tmp56_);
	_tmp57_ = props_err;
	g_assert_cmpstr (_tmp57_, ==, "");
	_tmp58_ = props_exit;
	g_assert_cmpint (_tmp58_, ==, 0);
	_tmp59_ = props_out;
	assert_in ("Synaptics Two-Finger Scrolling", _tmp59_);
	_tmp60_ = props_out;
	assert_in ("/dev/input/event12", _tmp60_);
	_g_free0 (props_err);
	_g_free0 (props_out);
	_g_free0 (xinput_err);
	_g_free0 (xinput_out);
	_g_free0 (logfile);
}


void t_input_evtest (void) {
	gboolean _tmp1_ = FALSE;
	GPid evtest_pid = 0;
	gint outfd = 0;
	gint errfd = 0;
	gchar* script_arch = NULL;
	glong _tmp3_ = 0L;
	gint64 _tmp4_ = 0LL;
	GPid _tmp33_ = 0;
	guint8* sout = NULL;
	guint8* _tmp34_ = NULL;
	gint sout_length1 = 0;
	gint _sout_size_ = 0;
	guint8* serr = NULL;
	guint8* _tmp35_ = NULL;
	gint serr_length1 = 0;
	gint _serr_size_ = 0;
	gssize sout_len = 0L;
	gint _tmp36_ = 0;
	guint8* _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	guint8* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gssize _tmp39_ = 0L;
	gssize serr_len = 0L;
	gint _tmp40_ = 0;
	guint8* _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	guint8* _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gssize _tmp43_ = 0L;
	gint status = 0;
	GPid _tmp44_ = 0;
	gint _tmp45_ = 0;
	GPid _tmp46_ = 0;
	gssize _tmp47_ = 0L;
	gssize _tmp53_ = 0L;
	guint8* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	gssize _tmp55_ = 0L;
	guint8 _tmp56_ = 0U;
	gchar* output = NULL;
	guint8* _tmp57_ = NULL;
	gint _tmp57__length1 = 0;
	gchar* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	GError * _inner_error_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	_tmp1_ = have_program ("evtest");
	if (!_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "[SKIP: evtest not installed] ");
		return;
	}
	_tmp3_ = G_MAXLONG;
	_tmp4_ = G_MAXINT64;
	if (((gint64) _tmp3_) == _tmp4_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_strdup ("64");
		_g_free0 (script_arch);
		script_arch = _tmp5_;
	} else {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup ("32");
		_g_free0 (script_arch);
		script_arch = _tmp6_;
	}
	{
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		GPid _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp7_ = g_strdup ("umockdev-run");
		_tmp8_ = g_strdup ("-d");
		_tmp9_ = rootdir;
		_tmp10_ = g_strconcat (_tmp9_, "/devices/input/usbkbd.umockdev", NULL);
		_tmp11_ = g_strdup ("-i");
		_tmp12_ = rootdir;
		_tmp13_ = g_strconcat ("/dev/input/event5=", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "/devices/input/usbkbd.evtest.ioctl", NULL);
		_tmp16_ = g_strdup ("-s");
		_tmp17_ = rootdir;
		_tmp18_ = g_strconcat ("/dev/input/event5=", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp19_, "/devices/input/usbkbd.evtest.script.", NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = script_arch;
		_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
		_tmp24_ = g_strdup ("evtest");
		_tmp25_ = g_strdup ("/dev/input/event5");
		_tmp26_ = g_new0 (gchar*, 9 + 1);
		_tmp26_[0] = _tmp7_;
		_tmp26_[1] = _tmp8_;
		_tmp26_[2] = _tmp10_;
		_tmp26_[3] = _tmp11_;
		_tmp26_[4] = _tmp15_;
		_tmp26_[5] = _tmp16_;
		_tmp26_[6] = _tmp23_;
		_tmp26_[7] = _tmp24_;
		_tmp26_[8] = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp27__length1 = 9;
		g_spawn_async_with_pipes (NULL, _tmp27_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp28_, NULL, &_tmp29_, &_tmp30_, &_inner_error_);
		evtest_pid = _tmp28_;
		outfd = _tmp29_;
		errfd = _tmp30_;
		_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp14_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			_g_free0 (script_arch);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = stderr;
		_tmp32_ = e->message;
		fprintf (_tmp31_, "cannot call evtest: %s\n", _tmp32_);
		abort ();
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (script_arch);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sleep ((guint) 2);
	_tmp33_ = evtest_pid;
	kill ((pid_t) _tmp33_, SIGTERM);
	_tmp34_ = g_new0 (guint8, 10000);
	sout = _tmp34_;
	sout_length1 = 10000;
	_sout_size_ = sout_length1;
	_tmp35_ = g_new0 (guint8, 10000);
	serr = _tmp35_;
	serr_length1 = 10000;
	_serr_size_ = serr_length1;
	_tmp36_ = outfd;
	_tmp37_ = sout;
	_tmp37__length1 = sout_length1;
	_tmp38_ = sout;
	_tmp38__length1 = sout_length1;
	_tmp39_ = read (_tmp36_, _tmp37_, (gsize) _tmp38__length1);
	sout_len = _tmp39_;
	_tmp40_ = errfd;
	_tmp41_ = serr;
	_tmp41__length1 = serr_length1;
	_tmp42_ = sout;
	_tmp42__length1 = sout_length1;
	_tmp43_ = read (_tmp40_, _tmp41_, (gsize) _tmp42__length1);
	serr_len = _tmp43_;
	_tmp44_ = evtest_pid;
	waitpid ((pid_t) _tmp44_, &_tmp45_, 0);
	status = _tmp45_;
	_tmp46_ = evtest_pid;
	g_spawn_close_pid (_tmp46_);
	_tmp47_ = serr_len;
	if (_tmp47_ > ((gssize) 0)) {
		guint8* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		gssize _tmp49_ = 0L;
		guint8 _tmp50_ = 0U;
		FILE* _tmp51_ = NULL;
		guint8* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
		_tmp48_ = serr;
		_tmp48__length1 = serr_length1;
		_tmp49_ = serr_len;
		_tmp48_[_tmp49_] = (guint8) 0;
		_tmp50_ = _tmp48_[_tmp49_];
		_tmp51_ = stderr;
		_tmp52_ = serr;
		_tmp52__length1 = serr_length1;
		fprintf (_tmp51_, "evtest error: %s\n", (const gchar*) _tmp52_);
		abort ();
	}
	_tmp53_ = sout_len;
	g_assert_cmpint ((gint) _tmp53_, >, 10);
	_tmp54_ = sout;
	_tmp54__length1 = sout_length1;
	_tmp55_ = sout_len;
	_tmp54_[_tmp55_] = (guint8) 0;
	_tmp56_ = _tmp54_[_tmp55_];
	_tmp57_ = sout;
	_tmp57__length1 = sout_length1;
	_tmp58_ = g_strdup ((const gchar*) _tmp57_);
	output = _tmp58_;
	_tmp59_ = output;
	assert_in ("Event type 1 (EV_KEY)", _tmp59_);
	_tmp60_ = output;
	assert_in ("Event code 15 (KEY_TAB)", _tmp60_);
	_tmp61_ = output;
	assert_in ("type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004", _tmp61_);
	_tmp62_ = output;
	assert_in ("type 1 (EV_KEY), code 30 (KEY_A), value 1\n", _tmp62_);
	_tmp63_ = output;
	assert_in ("type 1 (EV_KEY), code 30 (KEY_A), value 0\n", _tmp63_);
	_tmp64_ = output;
	assert_in ("type 4 (EV_MSC), code 4 (MSC_SCAN), value 700e1", _tmp64_);
	_tmp65_ = output;
	assert_in ("type 1 (EV_KEY), code 42 (KEY_LEFTSHIFT), value 1\n", _tmp65_);
	_tmp66_ = output;
	assert_in ("type 1 (EV_KEY), code 42 (KEY_LEFTSHIFT), value 0\n", _tmp66_);
	_g_free0 (output);
	serr = (g_free (serr), NULL);
	sout = (g_free (sout), NULL);
	_g_free0 (script_arch);
}


void t_input_evtest_evemu (void) {
	gboolean _tmp1_ = FALSE;
	GPid evtest_pid = 0;
	gint outfd = 0;
	gint errfd = 0;
	gchar* evemu_file = NULL;
	const gchar* _tmp30_ = NULL;
	GPid _tmp31_ = 0;
	guint8* sout = NULL;
	guint8* _tmp32_ = NULL;
	gint sout_length1 = 0;
	gint _sout_size_ = 0;
	guint8* serr = NULL;
	guint8* _tmp33_ = NULL;
	gint serr_length1 = 0;
	gint _serr_size_ = 0;
	gssize sout_len = 0L;
	gint _tmp34_ = 0;
	guint8* _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	guint8* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gssize _tmp37_ = 0L;
	gssize serr_len = 0L;
	gint _tmp38_ = 0;
	guint8* _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	guint8* _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	gssize _tmp41_ = 0L;
	gint status = 0;
	GPid _tmp42_ = 0;
	gint _tmp43_ = 0;
	GPid _tmp44_ = 0;
	gssize _tmp45_ = 0L;
	gssize _tmp51_ = 0L;
	guint8* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gssize _tmp53_ = 0L;
	guint8 _tmp54_ = 0U;
	gchar* output = NULL;
	guint8* _tmp55_ = NULL;
	gint _tmp55__length1 = 0;
	gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GError * _inner_error_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_ = NULL;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	_tmp1_ = have_program ("evtest");
	if (!_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "[SKIP: evtest not installed] ");
		return;
	}
	{
		gint fd = 0;
		gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = g_file_open_tmp ("evemu.XXXXXX.events", &_tmp3_, &_inner_error_);
		_g_free0 (evemu_file);
		evemu_file = _tmp3_;
		fd = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = fd;
		close (_tmp5_);
		_tmp6_ = evemu_file;
		g_file_set_contents (_tmp6_, "E: 0.000000 0000 0000 0000\t# ------------ SYN_REPORT (0) ----------\n" \
"E: 0.200000 0004 0004 458756\t# EV_MSC / MSC_SCAN             458756\n" \
"E: 0.200000 0001 001e 0001\t# EV_KEY / KEY_A                1\n" \
"E: 0.200000 0000 0000 0000\t# ------------ SYN_REPORT (0) ----------\n" \
"E: 0.500000 0004 0004 458756\t# EV_MSC / MSC_SCAN             458756\n" \
"E: 0.500000 0001 001e 0000\t# EV_KEY / KEY_A                0\n", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e->message;
		fprintf (_tmp7_, "cannot create temporary file: %s\n", _tmp8_);
		abort ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_free0 (evemu_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		GPid _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		_tmp9_ = g_strdup ("umockdev-run");
		_tmp10_ = g_strdup ("-d");
		_tmp11_ = rootdir;
		_tmp12_ = g_strconcat (_tmp11_, "/devices/input/usbkbd.umockdev", NULL);
		_tmp13_ = g_strdup ("-i");
		_tmp14_ = rootdir;
		_tmp15_ = g_strconcat ("/dev/input/event5=", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "/devices/input/usbkbd.evtest.ioctl", NULL);
		_tmp18_ = g_strdup ("-e");
		_tmp19_ = evemu_file;
		_tmp20_ = g_strconcat ("/dev/input/event5=", _tmp19_, NULL);
		_tmp21_ = g_strdup ("evtest");
		_tmp22_ = g_strdup ("/dev/input/event5");
		_tmp23_ = g_new0 (gchar*, 9 + 1);
		_tmp23_[0] = _tmp9_;
		_tmp23_[1] = _tmp10_;
		_tmp23_[2] = _tmp12_;
		_tmp23_[3] = _tmp13_;
		_tmp23_[4] = _tmp17_;
		_tmp23_[5] = _tmp18_;
		_tmp23_[6] = _tmp20_;
		_tmp23_[7] = _tmp21_;
		_tmp23_[8] = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp24__length1 = 9;
		g_spawn_async_with_pipes (NULL, _tmp24_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp25_, NULL, &_tmp26_, &_tmp27_, &_inner_error_);
		evtest_pid = _tmp25_;
		outfd = _tmp26_;
		errfd = _tmp27_;
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp16_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch9_g_spawn_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = stderr;
		_tmp29_ = e->message;
		fprintf (_tmp28_, "cannot call evtest: %s\n", _tmp29_);
		abort ();
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (evemu_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sleep ((guint) 1);
	_tmp30_ = evemu_file;
	g_remove (_tmp30_);
	_tmp31_ = evtest_pid;
	kill ((pid_t) _tmp31_, SIGTERM);
	_tmp32_ = g_new0 (guint8, 10000);
	sout = _tmp32_;
	sout_length1 = 10000;
	_sout_size_ = sout_length1;
	_tmp33_ = g_new0 (guint8, 10000);
	serr = _tmp33_;
	serr_length1 = 10000;
	_serr_size_ = serr_length1;
	_tmp34_ = outfd;
	_tmp35_ = sout;
	_tmp35__length1 = sout_length1;
	_tmp36_ = sout;
	_tmp36__length1 = sout_length1;
	_tmp37_ = read (_tmp34_, _tmp35_, (gsize) _tmp36__length1);
	sout_len = _tmp37_;
	_tmp38_ = errfd;
	_tmp39_ = serr;
	_tmp39__length1 = serr_length1;
	_tmp40_ = sout;
	_tmp40__length1 = sout_length1;
	_tmp41_ = read (_tmp38_, _tmp39_, (gsize) _tmp40__length1);
	serr_len = _tmp41_;
	_tmp42_ = evtest_pid;
	waitpid ((pid_t) _tmp42_, &_tmp43_, 0);
	status = _tmp43_;
	_tmp44_ = evtest_pid;
	g_spawn_close_pid (_tmp44_);
	_tmp45_ = serr_len;
	if (_tmp45_ > ((gssize) 0)) {
		guint8* _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		gssize _tmp47_ = 0L;
		guint8 _tmp48_ = 0U;
		FILE* _tmp49_ = NULL;
		guint8* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		_tmp46_ = serr;
		_tmp46__length1 = serr_length1;
		_tmp47_ = serr_len;
		_tmp46_[_tmp47_] = (guint8) 0;
		_tmp48_ = _tmp46_[_tmp47_];
		_tmp49_ = stderr;
		_tmp50_ = serr;
		_tmp50__length1 = serr_length1;
		fprintf (_tmp49_, "evtest error: %s\n", (const gchar*) _tmp50_);
		abort ();
	}
	_tmp51_ = sout_len;
	g_assert_cmpint ((gint) _tmp51_, >, 10);
	_tmp52_ = sout;
	_tmp52__length1 = sout_length1;
	_tmp53_ = sout_len;
	_tmp52_[_tmp53_] = (guint8) 0;
	_tmp54_ = _tmp52_[_tmp53_];
	_tmp55_ = sout;
	_tmp55__length1 = sout_length1;
	_tmp56_ = g_strdup ((const gchar*) _tmp55_);
	output = _tmp56_;
	_tmp57_ = output;
	assert_in ("Event: time 0.000000, -------------- SYN_REPORT ------------\n" \
"Event: time 0.200000, type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004\n" \
"Event: time 0.200000, type 1 (EV_KEY), code 30 (KEY_A), value 1\n" \
"Event: time 0.200000, -------------- SYN_REPORT ------------\n" \
"Event: time 0.500000, type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004\n" \
"Event: time 0.500000, type 1 (EV_KEY), code 30 (KEY_A), value 0\n", _tmp57_);
	_g_free0 (output);
	serr = (g_free (serr), NULL);
	sout = (g_free (sout), NULL);
	_g_free0 (evemu_file);
}


static void _t_run_exit_code_gtest_func (void) {
	t_run_exit_code ();
}


static void _t_run_version_gtest_func (void) {
	t_run_version ();
}


static void _t_run_pipes_gtest_func (void) {
	t_run_pipes ();
}


static void _t_run_invalid_args_gtest_func (void) {
	t_run_invalid_args ();
}


static void _t_run_invalid_device_gtest_func (void) {
	t_run_invalid_device ();
}


static void _t_run_invalid_ioctl_gtest_func (void) {
	t_run_invalid_ioctl ();
}


static void _t_run_invalid_script_gtest_func (void) {
	t_run_invalid_script ();
}


static void _t_run_invalid_program_gtest_func (void) {
	t_run_invalid_program ();
}


static void _t_run_script_chatter_gtest_func (void) {
	t_run_script_chatter ();
}


static void _t_run_script_chatter_socket_stream_gtest_func (void) {
	t_run_script_chatter_socket_stream ();
}


static void _t_gphoto_detect_gtest_func (void) {
	t_gphoto_detect ();
}


static void _t_gphoto_folderlist_gtest_func (void) {
	t_gphoto_folderlist ();
}


static void _t_gphoto_filelist_gtest_func (void) {
	t_gphoto_filelist ();
}


static void _t_gphoto_thumbs_gtest_func (void) {
	t_gphoto_thumbs ();
}


static void _t_gphoto_download_gtest_func (void) {
	t_gphoto_download ();
}


static void _t_input_touchpad_gtest_func (void) {
	t_input_touchpad ();
}


static void _t_input_evtest_gtest_func (void) {
	t_input_evtest ();
}


static void _t_input_evtest_evemu_gtest_func (void) {
	t_input_evtest_evemu ();
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* top_srcdir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp6_ = 0;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_getenv ("TOP_SRCDIR");
	_tmp1_ = g_strdup (_tmp0_);
	top_srcdir = _tmp1_;
	_tmp2_ = top_srcdir;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = top_srcdir;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (rootdir);
		rootdir = _tmp4_;
	} else {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_strdup (".");
		_g_free0 (rootdir);
		rootdir = _tmp5_;
	}
	g_test_add_func ("/umockdev-run/exit_code", _t_run_exit_code_gtest_func);
	g_test_add_func ("/umockdev-run/version", _t_run_version_gtest_func);
	g_test_add_func ("/umockdev-run/pipes", _t_run_pipes_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-args", _t_run_invalid_args_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-device", _t_run_invalid_device_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-ioctl", _t_run_invalid_ioctl_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-script", _t_run_invalid_script_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-program", _t_run_invalid_program_gtest_func);
	g_test_add_func ("/umockdev-run/script-chatter", _t_run_script_chatter_gtest_func);
	g_test_add_func ("/umockdev-run/script-chatter-socket-stream", _t_run_script_chatter_socket_stream_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-detect", _t_gphoto_detect_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-folderlist", _t_gphoto_folderlist_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-filelist", _t_gphoto_filelist_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-thumbs", _t_gphoto_thumbs_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-download", _t_gphoto_download_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-touchpad", _t_input_touchpad_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-evtest", _t_input_evtest_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-evtest-evemu", _t_input_evtest_evemu_gtest_func);
	_tmp6_ = g_test_run ();
	result = _tmp6_;
	_g_free0 (top_srcdir);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



