/* changesymlinkop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2004,2008,2011,2013 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "changesymlinkop.h"
#include "listermode.h"
#include "worker.h"
#include "nmspecialsourceext.hh"
#include "worker_locale.h"
#include "changesymlinkorder.hh"
#include "virtualdirmode.hh"

const char *ChangeSymlinkOp::name="ChangeSymlinkOp";

ChangeSymlinkOp::ChangeSymlinkOp() : FunctionProto()
{
    m_category = FunctionProto::CAT_FILEOPS;
}

ChangeSymlinkOp::~ChangeSymlinkOp()
{
}

ChangeSymlinkOp*
ChangeSymlinkOp::duplicate() const
{
  ChangeSymlinkOp *ta=new ChangeSymlinkOp();
  return ta;
}

bool
ChangeSymlinkOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ChangeSymlinkOp::getName()
{
  return name;
}

int
ChangeSymlinkOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL) {
          if(dynamic_cast< VirtualDirMode *>( lm1 ) ) {
              normalmodechangesl( msg );
          } else {
              lm1->not_supported();
          }
      }
    }
  }
  return 0;
}

const char *
ChangeSymlinkOp::getDescription()
{
  return catalog.getLocaleCom(37);
}

int
ChangeSymlinkOp::normalmodechangesl( ActionMessage *am )
{
  ListerMode *lm1 = NULL;
  NM_specialsourceExt *specialsource=NULL;
  struct NM_changesymlinkorder chslorder;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;

  memset( &chslorder, 0, sizeof( chslorder ) );
  if(am->mode==am->AM_MODE_ONLYACTIVE)
    chslorder.source=chslorder.NM_ONLYACTIVE;
  else if(am->mode==am->AM_MODE_DNDACTION) {
    // insert DND-element into list
    chslorder.source=chslorder.NM_SPECIAL;
    chslorder.sources=new std::list<NM_specialsourceExt*>;
    specialsource = new NM_specialsourceExt( NULL );
    //TODO: specialsource nach am besetzen (je nachdem wir ich das realisiere)
    chslorder.sources->push_back(specialsource);
  } else if(am->mode==am->AM_MODE_SPECIAL) {
    chslorder.source=chslorder.NM_SPECIAL;
    chslorder.sources=new std::list<NM_specialsourceExt*>;
    specialsource = new NM_specialsourceExt( am->getFE() );
    chslorder.sources->push_back(specialsource);
  } else
    chslorder.source=chslorder.NM_ALLENTRIES;

  if ( auto vdm = dynamic_cast< VirtualDirMode * >( lm1 ) ) {
      vdm->changesymlink( &chslorder );
  }

  if(chslorder.source==chslorder.NM_SPECIAL) {
    if ( specialsource != NULL ) delete specialsource;
    delete chslorder.sources;
  }
  return 0;
}

