/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class TailIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int start;

    private TailIterator(SequenceIterator base, int start) throws XPathException {
        this.base = base;
        this.start = start;
    }

    public static SequenceIterator make(SequenceIterator base, int start) throws XPathException {
        if (start == 1) {
            return base;
        }
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(start, Integer.MAX_VALUE);
        }
        if (base instanceof GroundedIterator) {
            GroundedValue value = ((GroundedIterator)base).materialize();
            if (value == EmptySequence.getInstance()) {
                return EmptyIterator.getInstance();
            }
            return new ValueTailIterator(value, start - 1);
        }
        for (int i = 0; i < start - 1; ++i) {
            Item b = base.next();
            if (b != null) continue;
            return EmptyIterator.getInstance();
        }
        return new TailIterator(base, start);
    }

    public Item next() throws XPathException {
        return this.base.next();
    }

    public Item current() {
        return this.base.current();
    }

    public int position() {
        int bp = this.base.position();
        return bp > 0 ? this.base.position() - this.start + 1 : bp;
    }

    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    public int getLastPosition() throws XPathException {
        int bl = ((LastPositionFinder)this.base).getLastPosition() - this.start + 1;
        return bl > 0 ? bl : 0;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return TailIterator.make(this.base.getAnother(), this.start);
    }

    public int getProperties() {
        return this.base.getProperties() & 6;
    }
}

