/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.distribution;

import io.micrometer.core.instrument.distribution.CountAtBucket;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongArray;

class FixedBoundaryHistogram {
    final AtomicLongArray values;
    private final double[] buckets;
    private final boolean isCumulativeBucketCounts;

    FixedBoundaryHistogram(double[] buckets, boolean isCumulativeBucketCounts) {
        this.buckets = buckets;
        this.values = new AtomicLongArray(buckets.length);
        this.isCumulativeBucketCounts = isCumulativeBucketCounts;
    }

    double[] getBuckets() {
        return this.buckets;
    }

    private long countAtBucket(double bucket) {
        int index = Arrays.binarySearch(this.buckets, bucket);
        if (index < 0) {
            return 0L;
        }
        return this.values.get(index);
    }

    void reset() {
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
    }

    void record(long value) {
        int index = this.leastLessThanOrEqualTo(value);
        if (index > -1) {
            this.values.incrementAndGet(index);
        }
    }

    int leastLessThanOrEqualTo(double valueToRecord) {
        int low = 0;
        int high = this.buckets.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double bucket = this.buckets[mid];
            if (bucket < valueToRecord) {
                low = mid + 1;
                continue;
            }
            if (bucket > valueToRecord) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low < this.buckets.length ? low : -1;
    }

    CountAtBucket[] getCountAtBuckets() {
        CountAtBucket[] countAtBuckets = new CountAtBucket[this.buckets.length];
        long cumulativeCount = 0L;
        for (int i = 0; i < this.buckets.length; ++i) {
            long valueAtCurrentBucket = this.values.get(i);
            countAtBuckets[i] = this.isCumulativeBucketCounts ? new CountAtBucket(this.buckets[i], (double)(cumulativeCount += valueAtCurrentBucket)) : new CountAtBucket(this.buckets[i], (double)valueAtCurrentBucket);
        }
        return countAtBuckets;
    }
}

